/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLError.h"

#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSQLErrorCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSQLErrorMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSQLErrorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSQLErrorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSQLErrorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLErrorPrototype>(vm.heap)) JSSQLErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSSQLErrorPrototypeTableValues[] =
{
    { "code", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "message", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSQLErrorMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "UNKNOWN_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "DATABASE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "VERSION_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "TOO_LARGE_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "QUOTA_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SYNTAX_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CONSTRAINT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "TIMEOUT_ERR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
};

const ClassInfo JSSQLErrorPrototype::s_info = { "SQLErrorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLErrorPrototype) };

void JSSQLErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLErrorPrototypeTableValues, *this);
}

const ClassInfo JSSQLError::s_info = { "SQLError", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLError) };

JSSQLError::JSSQLError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLError>&& impl)
    : JSDOMWrapper<SQLError>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSQLError::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSQLErrorPrototype::create(vm, globalObject, JSSQLErrorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSQLError::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLError>(vm, globalObject);
}

void JSSQLError::destroy(JSC::JSCell* cell)
{
    JSSQLError* thisObject = static_cast<JSSQLError*>(cell);
    thisObject->JSSQLError::~JSSQLError();
}

EncodedJSValue jsSQLErrorCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLError*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLError", "code");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.code());
    return JSValue::encode(result);
}


EncodedJSValue jsSQLErrorMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSQLError*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SQLError", "message");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.message());
    return JSValue::encode(result);
}


void setJSSQLErrorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSQLErrorPrototype* domObject = jsDynamicCast<JSSQLErrorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSSQLErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLError = jsCast<JSSQLError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLError->wrapped(), jsSQLError);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLError* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSQLError>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLError>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to SQLError.
    COMPILE_ASSERT(!__is_polymorphic(SQLError), SQLError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSSQLError>(globalObject, impl);
}

SQLError* JSSQLError::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
