/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSeg.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGPathSegPathSegType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPathSegPathSegTypeAsLetter(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGPathSegConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGPathSegConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGPathSegPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGPathSegPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegPrototype>(vm.heap)) JSSVGPathSegPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGPathSeg> JSSVGPathSegConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGPathSegConstructorTableValues[] =
{
    { "PATHSEG_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "PATHSEG_CLOSEPATH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PATHSEG_MOVETO_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "PATHSEG_MOVETO_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "PATHSEG_LINETO_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PATHSEG_LINETO_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PATHSEG_CURVETO_CUBIC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PATHSEG_CURVETO_CUBIC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "PATHSEG_CURVETO_QUADRATIC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "PATHSEG_ARC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "PATHSEG_ARC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "PATHSEG_LINETO_HORIZONTAL_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "PATHSEG_LINETO_VERTICAL_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "PATHSEG_LINETO_VERTICAL_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
};


COMPILE_ASSERT(0 == SVGPathSeg::PATHSEG_UNKNOWN, SVGPathSegEnumPATHSEG_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGPathSeg::PATHSEG_CLOSEPATH, SVGPathSegEnumPATHSEG_CLOSEPATHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGPathSeg::PATHSEG_MOVETO_ABS, SVGPathSegEnumPATHSEG_MOVETO_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGPathSeg::PATHSEG_MOVETO_REL, SVGPathSegEnumPATHSEG_MOVETO_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGPathSeg::PATHSEG_LINETO_ABS, SVGPathSegEnumPATHSEG_LINETO_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGPathSeg::PATHSEG_LINETO_REL, SVGPathSegEnumPATHSEG_LINETO_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGPathSeg::PATHSEG_CURVETO_CUBIC_ABS, SVGPathSegEnumPATHSEG_CURVETO_CUBIC_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == SVGPathSeg::PATHSEG_CURVETO_CUBIC_REL, SVGPathSegEnumPATHSEG_CURVETO_CUBIC_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_ABS, SVGPathSegEnumPATHSEG_CURVETO_QUADRATIC_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_REL, SVGPathSegEnumPATHSEG_CURVETO_QUADRATIC_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == SVGPathSeg::PATHSEG_ARC_ABS, SVGPathSegEnumPATHSEG_ARC_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(11 == SVGPathSeg::PATHSEG_ARC_REL, SVGPathSegEnumPATHSEG_ARC_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(12 == SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_ABS, SVGPathSegEnumPATHSEG_LINETO_HORIZONTAL_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(13 == SVGPathSeg::PATHSEG_LINETO_HORIZONTAL_REL, SVGPathSegEnumPATHSEG_LINETO_HORIZONTAL_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(14 == SVGPathSeg::PATHSEG_LINETO_VERTICAL_ABS, SVGPathSegEnumPATHSEG_LINETO_VERTICAL_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == SVGPathSeg::PATHSEG_LINETO_VERTICAL_REL, SVGPathSegEnumPATHSEG_LINETO_VERTICAL_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_ABS, SVGPathSegEnumPATHSEG_CURVETO_CUBIC_SMOOTH_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(17 == SVGPathSeg::PATHSEG_CURVETO_CUBIC_SMOOTH_REL, SVGPathSegEnumPATHSEG_CURVETO_CUBIC_SMOOTH_RELIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(18 == SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS, SVGPathSegEnumPATHSEG_CURVETO_QUADRATIC_SMOOTH_ABSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(19 == SVGPathSeg::PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL, SVGPathSegEnumPATHSEG_CURVETO_QUADRATIC_SMOOTH_RELIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGPathSegConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPathSegConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSeg::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGPathSeg"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGPathSegConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGPathSegConstructor::s_info = { "SVGPathSeg", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGPathSegConstructor) } },
    { "pathSegType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegPathSegType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pathSegTypeAsLetter", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegPathSegTypeAsLetter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "PATHSEG_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "PATHSEG_CLOSEPATH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PATHSEG_MOVETO_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "PATHSEG_MOVETO_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "PATHSEG_LINETO_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "PATHSEG_LINETO_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PATHSEG_CURVETO_CUBIC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "PATHSEG_CURVETO_CUBIC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "PATHSEG_CURVETO_QUADRATIC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "PATHSEG_CURVETO_QUADRATIC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "PATHSEG_ARC_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "PATHSEG_ARC_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "PATHSEG_LINETO_HORIZONTAL_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "PATHSEG_LINETO_HORIZONTAL_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "PATHSEG_LINETO_VERTICAL_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "PATHSEG_LINETO_VERTICAL_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "PATHSEG_CURVETO_CUBIC_SMOOTH_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
};

const ClassInfo JSSVGPathSegPrototype::s_info = { "SVGPathSegPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSegPrototype) };

void JSSVGPathSegPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegPrototypeTableValues, *this);
}

const ClassInfo JSSVGPathSeg::s_info = { "SVGPathSeg", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGPathSeg) };

JSSVGPathSeg::JSSVGPathSeg(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSeg>&& impl)
    : JSDOMWrapper<SVGPathSeg>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGPathSeg::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGPathSegPrototype::create(vm, globalObject, JSSVGPathSegPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGPathSeg::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSeg>(vm, globalObject);
}

void JSSVGPathSeg::destroy(JSC::JSCell* cell)
{
    JSSVGPathSeg* thisObject = static_cast<JSSVGPathSeg*>(cell);
    thisObject->JSSVGPathSeg::~JSSVGPathSeg();
}

EncodedJSValue jsSVGPathSegPathSegType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSeg*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSeg", "pathSegType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.pathSegType());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegPathSegTypeAsLetter(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGPathSeg*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGPathSeg", "pathSegTypeAsLetter");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.pathSegTypeAsLetter());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGPathSegConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGPathSegPrototype* domObject = jsDynamicCast<JSSVGPathSegPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGPathSeg::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGPathSegConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGPathSegPrototype* domObject = jsDynamicCast<JSSVGPathSegPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGPathSeg::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGPathSegOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPathSegOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPathSeg = jsCast<JSSVGPathSeg*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGPathSeg->wrapped(), jsSVGPathSeg);
}

SVGPathSeg* JSSVGPathSeg::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPathSeg*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
