/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDepthTexture.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSWebGLDepthTexturePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLDepthTexturePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDepthTexturePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDepthTexturePrototype>(vm.heap)) JSWebGLDepthTexturePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDepthTexturePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSWebGLDepthTexturePrototypeTableValues[] =
{
    { "UNSIGNED_INT_24_8_WEBGL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x84FA) } },
};

const ClassInfo JSWebGLDepthTexturePrototype::s_info = { "WebGLDepthTexturePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDepthTexturePrototype) };

void JSWebGLDepthTexturePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDepthTexturePrototypeTableValues, *this);
}

const ClassInfo JSWebGLDepthTexture::s_info = { "WebGLDepthTexture", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLDepthTexture) };

JSWebGLDepthTexture::JSWebGLDepthTexture(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDepthTexture>&& impl)
    : JSDOMWrapper<WebGLDepthTexture>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLDepthTexture::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLDepthTexturePrototype::create(vm, globalObject, JSWebGLDepthTexturePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLDepthTexture::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDepthTexture>(vm, globalObject);
}

void JSWebGLDepthTexture::destroy(JSC::JSCell* cell)
{
    JSWebGLDepthTexture* thisObject = static_cast<JSWebGLDepthTexture*>(cell);
    thisObject->JSWebGLDepthTexture::~JSWebGLDepthTexture();
}

bool JSWebGLDepthTextureOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsWebGLDepthTexture = jsCast<JSWebGLDepthTexture*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsWebGLDepthTexture->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDepthTextureOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDepthTexture = jsCast<JSWebGLDepthTexture*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDepthTexture->wrapped(), jsWebGLDepthTexture);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDepthTexture@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17WebGLDepthTextureE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDepthTexture* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLDepthTexture>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLDepthTexture* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLDepthTexture>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLDepthTexture@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17WebGLDepthTextureE[2];
#if COMPILER(CLANG)
    // If this fails WebGLDepthTexture does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLDepthTexture), WebGLDepthTexture_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLDepthTexture has subclasses. If WebGLDepthTexture has subclasses that get passed
    // to toJS() we currently require WebGLDepthTexture you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLDepthTexture>(globalObject, impl);
}

WebGLDepthTexture* JSWebGLDepthTexture::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDepthTexture*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
