/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebPageGroupProxyMessages_h
#define WebPageGroupProxyMessages_h

#if ENABLE(CONTENT_EXTENSIONS)
#include "ArgumentCoders.h"
#endif
#include "Arguments.h"
#include "MessageEncoder.h"
#include "StringReference.h"
#if ENABLE(CONTENT_EXTENSIONS)
#include "WebCompiledContentExtensionData.h"
#endif
#include "WebCoreArgumentCoders.h"
#include <WebCore/UserScript.h>
#include <WebCore/UserStyleSheet.h>
#if ENABLE(CONTENT_EXTENSIONS)
#include <wtf/text/WTFString.h>
#endif


namespace Messages {
namespace WebPageGroupProxy {

static inline IPC::StringReference messageReceiverName()
{
    return IPC::StringReference("WebPageGroupProxy");
}

class AddUserStyleSheet {
public:
    typedef std::tuple<WebCore::UserStyleSheet> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserStyleSheet"); }
    static const bool isSync = false;

    explicit AddUserStyleSheet(const WebCore::UserStyleSheet& userStyleSheet)
        : m_arguments(userStyleSheet)
    {
    }

    const std::tuple<const WebCore::UserStyleSheet&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::UserStyleSheet&> m_arguments;
};

class AddUserScript {
public:
    typedef std::tuple<WebCore::UserScript> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserScript"); }
    static const bool isSync = false;

    explicit AddUserScript(const WebCore::UserScript& userScript)
        : m_arguments(userScript)
    {
    }

    const std::tuple<const WebCore::UserScript&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const WebCore::UserScript&> m_arguments;
};

class RemoveAllUserStyleSheets {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserStyleSheets"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class RemoveAllUserScripts {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserScripts"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class RemoveAllUserContent {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserContent"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

#if ENABLE(CONTENT_EXTENSIONS)
class AddUserContentExtension {
public:
    typedef std::tuple<String, WebKit::WebCompiledContentExtensionData> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserContentExtension"); }
    static const bool isSync = false;

    AddUserContentExtension(const String& name, const WebKit::WebCompiledContentExtensionData& contentExtension)
        : m_arguments(name, contentExtension)
    {
    }

    const std::tuple<const String&, const WebKit::WebCompiledContentExtensionData&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&, const WebKit::WebCompiledContentExtensionData&> m_arguments;
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
class RemoveUserContentExtension {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveUserContentExtension"); }
    static const bool isSync = false;

    explicit RemoveUserContentExtension(const String& name)
        : m_arguments(name)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
class RemoveAllUserContentExtensions {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserContentExtensions"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};
#endif

} // namespace WebPageGroupProxy
} // namespace Messages

#endif // WebPageGroupProxyMessages_h
