/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "HTMLElementFactory.h"

#include "HTMLNames.h"

#include "HTMLAnchorElement.h"
#include "HTMLElement.h"
#include "HTMLAppletElement.h"
#include "HTMLAreaElement.h"
#include "HTMLBaseElement.h"
#include "HTMLUnknownElement.h"
#include "HTMLBDIElement.h"
#include "HTMLQuoteElement.h"
#include "HTMLBodyElement.h"
#include "HTMLBRElement.h"
#include "HTMLButtonElement.h"
#include "HTMLCanvasElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableColElement.h"
#include "HTMLDataElement.h"
#include "HTMLModElement.h"
#include "HTMLDirectoryElement.h"
#include "HTMLDivElement.h"
#include "HTMLDListElement.h"
#include "HTMLEmbedElement.h"
#include "HTMLFieldSetElement.h"
#include "HTMLFontElement.h"
#include "HTMLFormElement.h"
#include "HTMLFrameElement.h"
#include "HTMLFrameSetElement.h"
#include "HTMLHeadingElement.h"
#include "HTMLHeadElement.h"
#include "HTMLHRElement.h"
#include "HTMLHtmlElement.h"
#include "HTMLIFrameElement.h"
#include "HTMLImageElement.h"
#include "HTMLInputElement.h"
#include "HTMLKeygenElement.h"
#include "HTMLLabelElement.h"
#include "HTMLLegendElement.h"
#include "HTMLLIElement.h"
#include "HTMLLinkElement.h"
#include "HTMLPreElement.h"
#include "HTMLMapElement.h"
#include "HTMLMarqueeElement.h"
#include "HTMLMenuElement.h"
#include "HTMLMetaElement.h"
#include "HTMLObjectElement.h"
#include "HTMLOListElement.h"
#include "HTMLOptGroupElement.h"
#include "HTMLOptionElement.h"
#include "HTMLOutputElement.h"
#include "HTMLParagraphElement.h"
#include "HTMLParamElement.h"
#include "HTMLPictureElement.h"
#include "HTMLProgressElement.h"
#include "RubyTextElement.h"
#include "RubyElement.h"
#include "HTMLScriptElement.h"
#include "HTMLSelectElement.h"
#include "HTMLSourceElement.h"
#include "HTMLSpanElement.h"
#include "HTMLStyleElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "HTMLTableDataCellElement.h"
#include "HTMLTextAreaElement.h"
#include "HTMLTableHeaderCellElement.h"
#include "HTMLTimeElement.h"
#include "HTMLTitleElement.h"
#include "HTMLTableRowElement.h"
#include "HTMLUListElement.h"
#include "HTMLWBRElement.h"
#include "HTMLUnknownElement.h"

#if ENABLE(ATTACHMENT_ELEMENT)
#include "HTMLAttachmentElement.h"
#endif

#if ENABLE(DATALIST_ELEMENT)
#include "HTMLDataListElement.h"
#endif

#if ENABLE(DETAILS_ELEMENT)
#include "HTMLDetailsElement.h"
#include "HTMLSummaryElement.h"
#endif

#if ENABLE(METER_ELEMENT)
#include "HTMLMeterElement.h"
#endif

#if ENABLE(SHADOW_DOM)
#include "HTMLSlotElement.h"
#endif

#if ENABLE(TEMPLATE_ELEMENT)
#include "HTMLTemplateElement.h"
#endif

#if ENABLE(VIDEO)
#include "HTMLAudioElement.h"
#include "HTMLVideoElement.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "HTMLTrackElement.h"
#endif

#include "Document.h"
#include "RuntimeEnabledFeatures.h"
#include "Settings.h"
#include <wtf/HashMap.h>
#include <wtf/NeverDestroyed.h>

namespace WebCore {

using namespace HTMLNames;

typedef Ref<HTMLElement> (*HTMLConstructorFunction)(const QualifiedName&, Document&, HTMLFormElement*, bool createdByParser);

static Ref<HTMLElement> anchorConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAnchorElement::create(tagName, document);
}

static Ref<HTMLElement> Constructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLElement::create(tagName, document);
}

static Ref<HTMLElement> appletConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLAppletElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> areaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAreaElement::create(tagName, document);
}

#if ENABLE(ATTACHMENT_ELEMENT)
static Ref<HTMLElement> attachmentConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    Settings* settings = document.settings();
    if (!settings || !settings->attachmentElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLAttachmentElement::create(tagName, document);
}
#endif

#if ENABLE(VIDEO)
static Ref<HTMLElement> audioConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    Settings* settings = document.settings();
    if (!MediaPlayer::isAvailable() || (settings && !settings->mediaEnabled()))
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLAudioElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> baseConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBaseElement::create(tagName, document);
}

static Ref<HTMLElement> unknownConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUnknownElement::create(tagName, document);
}

static Ref<HTMLElement> bdiConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBDIElement::create(tagName, document);
}

static Ref<HTMLElement> quoteConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLQuoteElement::create(tagName, document);
}

static Ref<HTMLElement> bodyConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBodyElement::create(tagName, document);
}

static Ref<HTMLElement> brConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBRElement::create(tagName, document);
}

static Ref<HTMLElement> buttonConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLButtonElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> canvasConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLCanvasElement::create(tagName, document);
}

static Ref<HTMLElement> tablecaptionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableCaptionElement::create(tagName, document);
}

static Ref<HTMLElement> tablecolConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableColElement::create(tagName, document);
}

static Ref<HTMLElement> dataConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDataElement::create(tagName, document);
}

#if ENABLE(DATALIST_ELEMENT)
static Ref<HTMLElement> datalistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDataListElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> modConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLModElement::create(tagName, document);
}

#if ENABLE(DETAILS_ELEMENT)
static Ref<HTMLElement> detailsConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDetailsElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> directoryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDirectoryElement::create(tagName, document);
}

static Ref<HTMLElement> divConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDivElement::create(tagName, document);
}

static Ref<HTMLElement> dlistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDListElement::create(tagName, document);
}

static Ref<HTMLElement> embedConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLEmbedElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> fieldsetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLFieldSetElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> fontConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFontElement::create(tagName, document);
}

static Ref<HTMLElement> formConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFormElement::create(tagName, document);
}

static Ref<HTMLElement> frameConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameElement::create(tagName, document);
}

static Ref<HTMLElement> framesetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameSetElement::create(tagName, document);
}

static Ref<HTMLElement> headingConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadingElement::create(tagName, document);
}

static Ref<HTMLElement> headConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadElement::create(tagName, document);
}

static Ref<HTMLElement> hrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHRElement::create(tagName, document);
}

static Ref<HTMLElement> htmlConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHtmlElement::create(tagName, document);
}

static Ref<HTMLElement> iframeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLIFrameElement::create(tagName, document);
}

static Ref<HTMLElement> imageConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLImageElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> inputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return HTMLInputElement::create(tagName, document, formElement, createdByParser);
}

static Ref<HTMLElement> keygenConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLKeygenElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> labelConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLabelElement::create(tagName, document);
}

static Ref<HTMLElement> legendConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLegendElement::create(tagName, document);
}

static Ref<HTMLElement> liConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLIElement::create(tagName, document);
}

static Ref<HTMLElement> linkConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLLinkElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> preConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPreElement::create(tagName, document);
}

static Ref<HTMLElement> mapConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMapElement::create(tagName, document);
}

static Ref<HTMLElement> marqueeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMarqueeElement::create(tagName, document);
}

static Ref<HTMLElement> menuConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMenuElement::create(tagName, document);
}

static Ref<HTMLElement> metaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMetaElement::create(tagName, document);
}

#if ENABLE(METER_ELEMENT)
static Ref<HTMLElement> meterConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMeterElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> objectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return HTMLObjectElement::create(tagName, document, formElement, createdByParser);
}

static Ref<HTMLElement> olistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOListElement::create(tagName, document);
}

static Ref<HTMLElement> optgroupConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptGroupElement::create(tagName, document);
}

static Ref<HTMLElement> optionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptionElement::create(tagName, document);
}

static Ref<HTMLElement> outputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLOutputElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> paragraphConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParagraphElement::create(tagName, document);
}

static Ref<HTMLElement> paramConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParamElement::create(tagName, document);
}

static Ref<HTMLElement> pictureConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPictureElement::create(tagName, document);
}

static Ref<HTMLElement> progressConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLProgressElement::create(tagName, document);
}

static Ref<HTMLElement> rubytextelementConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return RubyTextElement::create(tagName, document);
}

static Ref<HTMLElement> rubyelementConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return RubyElement::create(tagName, document);
}

static Ref<HTMLElement> scriptConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLScriptElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> selectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLSelectElement::create(tagName, document, formElement);
}

#if ENABLE(SHADOW_DOM)
static Ref<HTMLElement> slotConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSlotElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> sourceConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSourceElement::create(tagName, document);
}

static Ref<HTMLElement> spanConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSpanElement::create(tagName, document);
}

static Ref<HTMLElement> styleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLStyleElement::create(tagName, document, createdByParser);
}

#if ENABLE(DETAILS_ELEMENT)
static Ref<HTMLElement> summaryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSummaryElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> tableConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableElement::create(tagName, document);
}

static Ref<HTMLElement> tablesectionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableSectionElement::create(tagName, document);
}

static Ref<HTMLElement> tabledatacellConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableDataCellElement::create(tagName, document);
}

#if ENABLE(TEMPLATE_ELEMENT)
static Ref<HTMLElement> templateConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTemplateElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> textareaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLTextAreaElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> tableheadercellConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableHeaderCellElement::create(tagName, document);
}

static Ref<HTMLElement> timeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTimeElement::create(tagName, document);
}

static Ref<HTMLElement> titleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTitleElement::create(tagName, document);
}

static Ref<HTMLElement> tablerowConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableRowElement::create(tagName, document);
}

#if ENABLE(VIDEO_TRACK)
static Ref<HTMLElement> trackConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    Settings* settings = document.settings();
    if (!MediaPlayer::isAvailable() || (settings && !settings->mediaEnabled()))
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLTrackElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> ulistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUListElement::create(tagName, document);
}

#if ENABLE(VIDEO)
static Ref<HTMLElement> videoConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    Settings* settings = document.settings();
    if (!MediaPlayer::isAvailable() || (settings && !settings->mediaEnabled()))
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLVideoElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> wbrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLWBRElement::create(tagName, document);
}

static NEVER_INLINE void populateHTMLFactoryMap(HashMap<AtomicStringImpl*, HTMLConstructorFunction>& map)
{
    struct TableEntry {
        const QualifiedName& name;
        HTMLConstructorFunction function;
    };

    static const TableEntry table[] = {
        { aTag, anchorConstructor },
        { abbrTag, Constructor },
        { acronymTag, Constructor },
        { addressTag, Constructor },
        { appletTag, appletConstructor },
        { areaTag, areaConstructor },
        { articleTag, Constructor },
        { asideTag, Constructor },
#if ENABLE(ATTACHMENT_ELEMENT)
        { attachmentTag, attachmentConstructor },
#endif
#if ENABLE(VIDEO)
        { audioTag, audioConstructor },
#endif
        { bTag, Constructor },
        { baseTag, baseConstructor },
        { basefontTag, unknownConstructor },
        { bdiTag, bdiConstructor },
        { bdoTag, Constructor },
        { bgsoundTag, unknownConstructor },
        { bigTag, Constructor },
        { blockquoteTag, quoteConstructor },
        { bodyTag, bodyConstructor },
        { brTag, brConstructor },
        { buttonTag, buttonConstructor },
        { canvasTag, canvasConstructor },
        { captionTag, tablecaptionConstructor },
        { centerTag, Constructor },
        { citeTag, Constructor },
        { codeTag, Constructor },
        { colTag, tablecolConstructor },
        { colgroupTag, tablecolConstructor },
        { commandTag, Constructor },
        { dataTag, dataConstructor },
#if ENABLE(DATALIST_ELEMENT)
        { datalistTag, datalistConstructor },
#endif
        { ddTag, Constructor },
        { delTag, modConstructor },
#if ENABLE(DETAILS_ELEMENT)
        { detailsTag, detailsConstructor },
#endif
        { dfnTag, Constructor },
        { dirTag, directoryConstructor },
        { divTag, divConstructor },
        { dlTag, dlistConstructor },
        { dtTag, Constructor },
        { emTag, Constructor },
        { embedTag, embedConstructor },
        { fieldsetTag, fieldsetConstructor },
        { figcaptionTag, Constructor },
        { figureTag, Constructor },
        { fontTag, fontConstructor },
        { footerTag, Constructor },
        { formTag, formConstructor },
        { frameTag, frameConstructor },
        { framesetTag, framesetConstructor },
        { h1Tag, headingConstructor },
        { h2Tag, headingConstructor },
        { h3Tag, headingConstructor },
        { h4Tag, headingConstructor },
        { h5Tag, headingConstructor },
        { h6Tag, headingConstructor },
        { headTag, headConstructor },
        { headerTag, Constructor },
        { hgroupTag, Constructor },
        { hrTag, hrConstructor },
        { htmlTag, htmlConstructor },
        { iTag, Constructor },
        { iframeTag, iframeConstructor },
        { imageTag, unknownConstructor },
        { imgTag, imageConstructor },
        { inputTag, inputConstructor },
        { insTag, modConstructor },
        { isindexTag, unknownConstructor },
        { kbdTag, Constructor },
        { keygenTag, keygenConstructor },
        { labelTag, labelConstructor },
        { layerTag, Constructor },
        { legendTag, legendConstructor },
        { liTag, liConstructor },
        { linkTag, linkConstructor },
        { listingTag, preConstructor },
        { mainTag, Constructor },
        { mapTag, mapConstructor },
        { markTag, Constructor },
        { marqueeTag, marqueeConstructor },
        { menuTag, menuConstructor },
        { metaTag, metaConstructor },
#if ENABLE(METER_ELEMENT)
        { meterTag, meterConstructor },
#endif
        { navTag, Constructor },
        { nobrTag, Constructor },
        { noembedTag, Constructor },
        { noframesTag, Constructor },
        { nolayerTag, Constructor },
        { noscriptTag, Constructor },
        { objectTag, objectConstructor },
        { olTag, olistConstructor },
        { optgroupTag, optgroupConstructor },
        { optionTag, optionConstructor },
        { outputTag, outputConstructor },
        { pTag, paragraphConstructor },
        { paramTag, paramConstructor },
        { pictureTag, pictureConstructor },
        { plaintextTag, Constructor },
        { preTag, preConstructor },
        { progressTag, progressConstructor },
        { qTag, quoteConstructor },
        { rbTag, Constructor },
        { rpTag, Constructor },
        { rtTag, rubytextelementConstructor },
        { rtcTag, Constructor },
        { rubyTag, rubyelementConstructor },
        { sTag, Constructor },
        { sampTag, Constructor },
        { scriptTag, scriptConstructor },
        { sectionTag, Constructor },
        { selectTag, selectConstructor },
#if ENABLE(SHADOW_DOM)
        { slotTag, slotConstructor },
#endif
        { smallTag, Constructor },
        { sourceTag, sourceConstructor },
        { spanTag, spanConstructor },
        { strikeTag, Constructor },
        { strongTag, Constructor },
        { styleTag, styleConstructor },
        { subTag, Constructor },
#if ENABLE(DETAILS_ELEMENT)
        { summaryTag, summaryConstructor },
#endif
        { supTag, Constructor },
        { tableTag, tableConstructor },
        { tbodyTag, tablesectionConstructor },
        { tdTag, tabledatacellConstructor },
#if ENABLE(TEMPLATE_ELEMENT)
        { templateTag, templateConstructor },
#endif
        { textareaTag, textareaConstructor },
        { tfootTag, tablesectionConstructor },
        { thTag, tableheadercellConstructor },
        { theadTag, tablesectionConstructor },
        { timeTag, timeConstructor },
        { titleTag, titleConstructor },
        { trTag, tablerowConstructor },
#if ENABLE(VIDEO_TRACK)
        { trackTag, trackConstructor },
#endif
        { ttTag, Constructor },
        { uTag, Constructor },
        { ulTag, ulistConstructor },
        { varTag, Constructor },
#if ENABLE(VIDEO)
        { videoTag, videoConstructor },
#endif
        { wbrTag, wbrConstructor },
        { xmpTag, preConstructor },
    };

    for (unsigned i = 0; i < WTF_ARRAY_LENGTH(table); ++i)
        map.add(table[i].name.localName().impl(), table[i].function);
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    static NeverDestroyed<HashMap<AtomicStringImpl*, HTMLConstructorFunction>> functions;
    if (functions.get().isEmpty())
        populateHTMLFactoryMap(functions);
    HTMLConstructorFunction function = functions.get().get(name.localName().impl());
    if (LIKELY(function))
        return function(name, document, formElement, createdByParser);
    return nullptr;
}

Ref<HTMLElement> HTMLElementFactory::createElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    RefPtr<HTMLElement> element = HTMLElementFactory::createKnownElement(name, document, formElement, createdByParser);
    if (LIKELY(element))
        return element.releaseNonNull();
    return HTMLUnknownElement::create(name, document);
}

} // namespace WebCore

