/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBlob.h"

#include "Blob.h"
#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsBlobPrototypeFunctionSlice(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsBlobSize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBlobType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBlobConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSBlobConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSBlobPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSBlobPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBlobPrototype* ptr = new (NotNull, JSC::allocateCell<JSBlobPrototype>(vm.heap)) JSBlobPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBlobPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSBlob> JSBlobConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSBlobConstructor::construct(JSC::ExecState* state)
{
    return constructJSBlob(state);
}

template<> JSValue JSBlobConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSBlobConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSBlob::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Blob"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSBlobConstructor::s_info = { "Blob", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBlobConstructor) };

/* Hash table for prototype */

static const HashTableValue JSBlobPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBlobConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBlobConstructor) } },
    { "size", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBlobSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBlobType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "slice", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsBlobPrototypeFunctionSlice), (intptr_t) (0) } },
};

const ClassInfo JSBlobPrototype::s_info = { "BlobPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBlobPrototype) };

void JSBlobPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBlobPrototypeTableValues, *this);
}

const ClassInfo JSBlob::s_info = { "Blob", &Base::s_info, 0, CREATE_METHOD_TABLE(JSBlob) };

JSBlob::JSBlob(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Blob>&& impl)
    : JSDOMWrapper<Blob>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSBlob::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSBlobPrototype::create(vm, globalObject, JSBlobPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSBlob::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBlob>(vm, globalObject);
}

void JSBlob::destroy(JSC::JSCell* cell)
{
    JSBlob* thisObject = static_cast<JSBlob*>(cell);
    thisObject->JSBlob::~JSBlob();
}

EncodedJSValue jsBlobSize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBlob*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Blob", "size");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.size());
    return JSValue::encode(result);
}


EncodedJSValue jsBlobType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSBlob*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Blob", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsBlobConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSBlobPrototype* domObject = jsDynamicCast<JSBlobPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSBlob::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSBlobConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSBlobPrototype* domObject = jsDynamicCast<JSBlobPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSBlob::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBlobConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsBlobPrototypeFunctionSlice(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSBlob*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Blob", "slice");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSBlob::info());
    auto& impl = castedThis->wrapped();

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.slice()));
        return JSValue::encode(result);
    }

    long long start = toInt64(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.slice(start)));
        return JSValue::encode(result);
    }

    long long end = toInt64(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.slice(start, end)));
        return JSValue::encode(result);
    }

    String contentType = valueToStringWithUndefinedOrNullCheck(state, state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.slice(start, end, contentType)));
    return JSValue::encode(result);
}

bool JSBlobOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsBlob = jsCast<JSBlob*>(handle.slot()->asCell());
    Blob* root = &jsBlob->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSBlobOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsBlob = jsCast<JSBlob*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsBlob->wrapped(), jsBlob);
}

Blob* JSBlob::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSBlob*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
