/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMStringMap.h"

#include "Element.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNodeCustom.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsDOMStringMapConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMStringMapConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMStringMapPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMStringMapPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMStringMapPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMStringMapPrototype>(vm.heap)) JSDOMStringMapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMStringMapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDOMStringMap> JSDOMStringMapConstructor;

template<> JSValue JSDOMStringMapConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMStringMapConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMStringMap::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DOMStringMap"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMStringMapConstructor::s_info = { "DOMStringMap", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMStringMapConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMStringMapPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMStringMapConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMStringMapConstructor) } },
};

const ClassInfo JSDOMStringMapPrototype::s_info = { "DOMStringMapPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMStringMapPrototype) };

void JSDOMStringMapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMStringMapPrototypeTableValues, *this);
}

const ClassInfo JSDOMStringMap::s_info = { "DOMStringMap", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMStringMap) };

JSDOMStringMap::JSDOMStringMap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMStringMap>&& impl)
    : JSDOMWrapper<DOMStringMap>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMStringMap::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMStringMapPrototype::create(vm, globalObject, JSDOMStringMapPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMStringMap::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMStringMap>(vm, globalObject);
}

void JSDOMStringMap::destroy(JSC::JSCell* cell)
{
    JSDOMStringMap* thisObject = static_cast<JSDOMStringMap*>(cell);
    thisObject->JSDOMStringMap::~JSDOMStringMap();
}

bool JSDOMStringMap::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSDOMStringMap::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsDOMStringMapConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMStringMapPrototype* domObject = jsDynamicCast<JSDOMStringMapPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMStringMap::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMStringMapConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMStringMapPrototype* domObject = jsDynamicCast<JSDOMStringMapPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSDOMStringMap::put(JSCell* cell, ExecState* state, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::put(thisObject, state, propertyName, value, slot);
}

void JSDOMStringMap::putByIndex(JSCell* cell, ExecState* state, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSDOMStringMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    PutPropertySlot slot(thisObject, shouldThrow);
    if (thisObject->putDelegate(state, propertyName, value, slot))
        return;
    Base::putByIndex(cell, state, index, value, shouldThrow);
}

JSValue JSDOMStringMap::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMStringMapConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSDOMStringMapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsDOMStringMap = jsCast<JSDOMStringMap*>(handle.slot()->asCell());
    Element* element = WTF::getPtr(jsDOMStringMap->wrapped().element());
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSDOMStringMapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMStringMap = jsCast<JSDOMStringMap*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMStringMap->wrapped(), jsDOMStringMap);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMStringMap* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMStringMap>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMStringMap* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMStringMap>(globalObject, impl))
        return result;
    return createNewWrapper<JSDOMStringMap>(globalObject, impl);
}

DOMStringMap* JSDOMStringMap::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMStringMap*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
