/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeoposition.h"

#include "Coordinates.h"
#include "JSCoordinates.h"
#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsGeopositionCoords(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeopositionTimestamp(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSGeopositionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSGeopositionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSGeopositionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeopositionPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeopositionPrototype>(vm.heap)) JSGeopositionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeopositionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSGeopositionPrototypeTableValues[] =
{
    { "coords", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionCoords), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timestamp", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionTimestamp), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSGeopositionPrototype::s_info = { "GeopositionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGeopositionPrototype) };

void JSGeopositionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeopositionPrototypeTableValues, *this);
}

const ClassInfo JSGeoposition::s_info = { "Geoposition", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGeoposition) };

JSGeoposition::JSGeoposition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Geoposition>&& impl)
    : JSDOMWrapper<Geoposition>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSGeoposition::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSGeopositionPrototype::create(vm, globalObject, JSGeopositionPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSGeoposition::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeoposition>(vm, globalObject);
}

void JSGeoposition::destroy(JSC::JSCell* cell)
{
    JSGeoposition* thisObject = static_cast<JSGeoposition*>(cell);
    thisObject->JSGeoposition::~JSGeoposition();
}

EncodedJSValue jsGeopositionCoords(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGeoposition*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Geoposition", "coords");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.coords()));
    return JSValue::encode(result);
}


EncodedJSValue jsGeopositionTimestamp(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGeoposition*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Geoposition", "timestamp");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.timestamp());
    return JSValue::encode(result);
}


void setJSGeopositionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSGeopositionPrototype* domObject = jsDynamicCast<JSGeopositionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSGeopositionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSGeopositionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeoposition = jsCast<JSGeoposition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeoposition->wrapped(), jsGeoposition);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Geoposition* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSGeoposition>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Geoposition* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGeoposition>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Geoposition.
    COMPILE_ASSERT(!__is_polymorphic(Geoposition), Geoposition_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSGeoposition>(globalObject, impl);
}

Geoposition* JSGeoposition::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeoposition*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
