/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSHTMLMediaElement_h
#define JSHTMLMediaElement_h

#if ENABLE(VIDEO)

#include "HTMLMediaElement.h"
#include "JSHTMLElement.h"
#include "JSNode.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSHTMLMediaElement : public JSHTMLElement {
public:
    typedef JSHTMLElement Base;
    static JSHTMLMediaElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<HTMLMediaElement>&& impl)
    {
        JSHTMLMediaElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLMediaElement>(globalObject->vm().heap)) JSHTMLMediaElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static const bool hasStaticPropertyTable = false;

    static JSC::JSObject* createPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static JSC::JSObject* getPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static HTMLMediaElement* toWrapped(JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);


    // Custom attributes
    void setController(JSC::ExecState&, JSC::JSValue);
    HTMLMediaElement& wrapped() const
    {
        return static_cast<HTMLMediaElement&>(Base::wrapped());
    }
protected:
    JSHTMLMediaElement(JSC::Structure*, JSDOMGlobalObject&, Ref<HTMLMediaElement>&&);

    void finishCreation(JSC::VM& vm)
    {
        Base::finishCreation(vm);
        ASSERT(inherits(info()));
    }

};

class JSHTMLMediaElementOwner : public JSNodeOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, HTMLMediaElement*)
{
    static NeverDestroyed<JSHTMLMediaElementOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(HTMLMediaElement* wrappableObject)
{
    return wrappableObject;
}



} // namespace WebCore

#endif // ENABLE(VIDEO)

#endif
