/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLSourceElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLSourceElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSourceElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSourceElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSourceElementType(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSourceElementMedia(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSourceElementMedia(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLSourceElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLSourceElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLSourceElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLSourceElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLSourceElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLSourceElementPrototype>(vm.heap)) JSHTMLSourceElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLSourceElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLSourceElement> JSHTMLSourceElementConstructor;

template<> JSValue JSHTMLSourceElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLSourceElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLSourceElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLSourceElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLSourceElementConstructor::s_info = { "HTMLSourceElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSourceElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLSourceElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSourceElementConstructor) } },
    { "src", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSourceElementSrc) } },
    { "type", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSourceElementType) } },
    { "media", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSourceElementMedia), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLSourceElementMedia) } },
};

const ClassInfo JSHTMLSourceElementPrototype::s_info = { "HTMLSourceElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSourceElementPrototype) };

void JSHTMLSourceElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLSourceElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLSourceElement::s_info = { "HTMLSourceElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLSourceElement) };

JSHTMLSourceElement::JSHTMLSourceElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLSourceElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLSourceElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLSourceElementPrototype::create(vm, globalObject, JSHTMLSourceElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLSourceElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSourceElement>(vm, globalObject);
}

EncodedJSValue jsHTMLSourceElementSrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSourceElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSourceElement", "src");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSourceElementType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSourceElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSourceElement", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSourceElementMedia(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLSourceElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLSourceElement", "media");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.media());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLSourceElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLSourceElementPrototype* domObject = jsDynamicCast<JSHTMLSourceElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLSourceElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLSourceElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLSourceElementPrototype* domObject = jsDynamicCast<JSHTMLSourceElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLSourceElementSrc(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSourceElement* castedThis = jsDynamicCast<JSHTMLSourceElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSourceElement", "src");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, nativeValue);
}


void setJSHTMLSourceElementType(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSourceElement* castedThis = jsDynamicCast<JSHTMLSourceElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSourceElement", "type");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setType(nativeValue);
}


void setJSHTMLSourceElementMedia(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLSourceElement* castedThis = jsDynamicCast<JSHTMLSourceElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLSourceElement", "media");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMedia(nativeValue);
}


JSValue JSHTMLSourceElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSourceElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLSourceElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLSourceElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
