/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSOverflowEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsOverflowEventOrient(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOverflowEventHorizontalOverflow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOverflowEventVerticalOverflow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsOverflowEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSOverflowEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSOverflowEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSOverflowEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOverflowEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSOverflowEventPrototype>(vm.heap)) JSOverflowEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOverflowEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSOverflowEvent> JSOverflowEventConstructor;

/* Hash table for constructor */

static const HashTableValue JSOverflowEventConstructorTableValues[] =
{
    { "HORIZONTAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "VERTICAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "BOTH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};


COMPILE_ASSERT(0 == OverflowEvent::HORIZONTAL, OverflowEventEnumHORIZONTALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == OverflowEvent::VERTICAL, OverflowEventEnumVERTICALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == OverflowEvent::BOTH, OverflowEventEnumBOTHIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSOverflowEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSOverflowEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    OverflowEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillOverflowEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<OverflowEvent> event = OverflowEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillOverflowEventInit(OverflowEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("orient", eventInit.orient))
        return false;
    if (!dictionary.tryGetProperty("horizontalOverflow", eventInit.horizontalOverflow))
        return false;
    if (!dictionary.tryGetProperty("verticalOverflow", eventInit.verticalOverflow))
        return false;
    return true;
}

template<> JSValue JSOverflowEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSOverflowEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSOverflowEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("OverflowEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSOverflowEventConstructorTableValues, *this);
}

template<> const ClassInfo JSOverflowEventConstructor::s_info = { "OverflowEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOverflowEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSOverflowEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSOverflowEventConstructor) } },
    { "orient", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventOrient), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "horizontalOverflow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventHorizontalOverflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "verticalOverflow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOverflowEventVerticalOverflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "HORIZONTAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "VERTICAL", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "BOTH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSOverflowEventPrototype::s_info = { "OverflowEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOverflowEventPrototype) };

void JSOverflowEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOverflowEventPrototypeTableValues, *this);
}

const ClassInfo JSOverflowEvent::s_info = { "OverflowEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSOverflowEvent) };

JSOverflowEvent::JSOverflowEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OverflowEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOverflowEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSOverflowEventPrototype::create(vm, globalObject, JSOverflowEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSOverflowEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOverflowEvent>(vm, globalObject);
}

EncodedJSValue jsOverflowEventOrient(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOverflowEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OverflowEvent", "orient");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.orient());
    return JSValue::encode(result);
}


EncodedJSValue jsOverflowEventHorizontalOverflow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOverflowEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OverflowEvent", "horizontalOverflow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.horizontalOverflow());
    return JSValue::encode(result);
}


EncodedJSValue jsOverflowEventVerticalOverflow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSOverflowEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "OverflowEvent", "verticalOverflow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.verticalOverflow());
    return JSValue::encode(result);
}


EncodedJSValue jsOverflowEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSOverflowEventPrototype* domObject = jsDynamicCast<JSOverflowEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSOverflowEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSOverflowEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSOverflowEventPrototype* domObject = jsDynamicCast<JSOverflowEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSOverflowEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOverflowEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
