/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRange.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "ExceptionCode.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "JSRange.h"
#include "Node.h"
#include "Range.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEnd(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartAfter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndAfter(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCollapse(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNodeContents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareBoundaryPoints(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDeleteContents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExtractContents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneContents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionInsertNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSurroundContents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneRange(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionToString(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDetach(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetClientRects(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetBoundingClientRect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCreateContextualFragment(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionComparePoint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIntersectsNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIsPointInRange(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExpand(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsRangeStartContainer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeStartOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeEndContainer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeEndOffset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeCollapsed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeCommonAncestorContainer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSRangePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSRangePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSRangePrototype>(vm.heap)) JSRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSRange> JSRangeConstructor;

/* Hash table for constructor */

static const HashTableValue JSRangeConstructorTableValues[] =
{
    { "START_TO_START", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "START_TO_END", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "END_TO_END", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "END_TO_START", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "NODE_BEFORE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NODE_AFTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NODE_INSIDE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == Range::START_TO_START, RangeEnumSTART_TO_STARTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Range::START_TO_END, RangeEnumSTART_TO_ENDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Range::END_TO_END, RangeEnumEND_TO_ENDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Range::END_TO_START, RangeEnumEND_TO_STARTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == Range::NODE_BEFORE, RangeEnumNODE_BEFOREIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Range::NODE_AFTER, RangeEnumNODE_AFTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Range::NODE_BEFORE_AND_AFTER, RangeEnumNODE_BEFORE_AND_AFTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Range::NODE_INSIDE, RangeEnumNODE_INSIDEIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSRangeConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSRangeConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "Range");
    auto& document = downcast<Document>(*context);
    RefPtr<Range> object = Range::create(document);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSRangeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSRangeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSRange::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Range"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSRangeConstructorTableValues, *this);
}

template<> const ClassInfo JSRangeConstructor::s_info = { "Range", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRangeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSRangePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSRangeConstructor) } },
    { "startContainer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "startOffset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeStartOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "endContainer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "endOffset", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeEndOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "collapsed", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCollapsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "commonAncestorContainer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRangeCommonAncestorContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setStart", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStart), (intptr_t) (1) } },
    { "setEnd", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEnd), (intptr_t) (1) } },
    { "setStartBefore", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartBefore), (intptr_t) (1) } },
    { "setStartAfter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetStartAfter), (intptr_t) (1) } },
    { "setEndBefore", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndBefore), (intptr_t) (1) } },
    { "setEndAfter", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSetEndAfter), (intptr_t) (1) } },
    { "collapse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCollapse), (intptr_t) (0) } },
    { "selectNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNode), (intptr_t) (1) } },
    { "selectNodeContents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSelectNodeContents), (intptr_t) (1) } },
    { "compareBoundaryPoints", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareBoundaryPoints), (intptr_t) (0) } },
    { "deleteContents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDeleteContents), (intptr_t) (0) } },
    { "extractContents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExtractContents), (intptr_t) (0) } },
    { "cloneContents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneContents), (intptr_t) (0) } },
    { "insertNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionInsertNode), (intptr_t) (1) } },
    { "surroundContents", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionSurroundContents), (intptr_t) (1) } },
    { "cloneRange", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCloneRange), (intptr_t) (0) } },
    { "toString", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionToString), (intptr_t) (0) } },
    { "detach", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionDetach), (intptr_t) (0) } },
    { "getClientRects", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetClientRects), (intptr_t) (0) } },
    { "getBoundingClientRect", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionGetBoundingClientRect), (intptr_t) (0) } },
    { "createContextualFragment", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCreateContextualFragment), (intptr_t) (0) } },
    { "compareNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionCompareNode), (intptr_t) (1) } },
    { "comparePoint", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionComparePoint), (intptr_t) (1) } },
    { "intersectsNode", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIntersectsNode), (intptr_t) (1) } },
    { "isPointInRange", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionIsPointInRange), (intptr_t) (1) } },
    { "expand", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsRangePrototypeFunctionExpand), (intptr_t) (0) } },
    { "START_TO_START", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "START_TO_END", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "END_TO_END", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "END_TO_START", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "NODE_BEFORE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NODE_AFTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NODE_BEFORE_AND_AFTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NODE_INSIDE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSRangePrototype::s_info = { "RangePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRangePrototype) };

void JSRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSRangePrototypeTableValues, *this);
}

const ClassInfo JSRange::s_info = { "Range", &Base::s_info, 0, CREATE_METHOD_TABLE(JSRange) };

JSRange::JSRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Range>&& impl)
    : JSDOMWrapper<Range>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSRange::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSRangePrototype::create(vm, globalObject, JSRangePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSRange::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRange>(vm, globalObject);
}

void JSRange::destroy(JSC::JSCell* cell)
{
    JSRange* thisObject = static_cast<JSRange*>(cell);
    thisObject->JSRange::~JSRange();
}

EncodedJSValue jsRangeStartContainer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "startContainer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.startContainer()));
    return JSValue::encode(result);
}


EncodedJSValue jsRangeStartOffset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "startOffset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.startOffset());
    return JSValue::encode(result);
}


EncodedJSValue jsRangeEndContainer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "endContainer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.endContainer()));
    return JSValue::encode(result);
}


EncodedJSValue jsRangeEndOffset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "endOffset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.endOffset());
    return JSValue::encode(result);
}


EncodedJSValue jsRangeCollapsed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "collapsed");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.collapsed());
    return JSValue::encode(result);
}


EncodedJSValue jsRangeCommonAncestorContainer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSRange*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Range", "commonAncestorContainer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.commonAncestorContainer()));
    return JSValue::encode(result);
}


EncodedJSValue jsRangeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSRangePrototype* domObject = jsDynamicCast<JSRangePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSRange::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSRangeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSRangePrototype* domObject = jsDynamicCast<JSRangePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRangeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setStart");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int offset = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStart(refNode, offset, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEnd(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setEnd");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int offset = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setEnd(refNode, offset, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setStartBefore");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStartBefore(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetStartAfter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setStartAfter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStartAfter(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndBefore(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setEndBefore");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setEndBefore(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSetEndAfter(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "setEndAfter");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setEndAfter(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCollapse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "collapse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    bool toStart = state->argument(0).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.collapse(toStart);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "selectNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.selectNode(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSelectNodeContents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "selectNodeContents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.selectNodeContents(refNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareBoundaryPoints(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "compareBoundaryPoints");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    uint16_t how = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Range* sourceRange = JSRange::toWrapped(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.compareBoundaryPointsForBindings(how, sourceRange, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDeleteContents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "deleteContents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    impl.deleteContents(ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExtractContents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "extractContents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.extractContents(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneContents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "cloneContents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.cloneContents(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionInsertNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "insertNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* newNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.insertNode(newNode, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionSurroundContents(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "surroundContents");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* newParent = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.surroundContents(newParent, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCloneRange(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "cloneRange");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.cloneRange()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "toString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.toString());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionDetach(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "detach");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    impl.detach();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetClientRects(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "getClientRects");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getClientRects()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionGetBoundingClientRect(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "getBoundingClientRect");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getBoundingClientRect()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCreateContextualFragment(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "createContextualFragment");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String html = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createContextualFragment(html, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionCompareNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "compareNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.compareNode(refNode, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionComparePoint(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "comparePoint");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int offset = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.comparePoint(refNode, offset, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIntersectsNode(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "intersectsNode");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.intersectsNode(refNode, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionIsPointInRange(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "isPointInRange");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Node* refNode = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    int offset = toInt32(state, state->argument(1), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.isPointInRange(refNode, offset, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsRangePrototypeFunctionExpand(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSRange*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Range", "expand");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSRange::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String unit = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.expand(unit, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

bool JSRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsRange = jsCast<JSRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsRange->wrapped(), jsRange);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Range* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSRange>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Range* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSRange>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Range.
    COMPILE_ASSERT(!__is_polymorphic(Range), Range_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSRange>(globalObject, impl);
}

Range* JSRange::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSRange*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
