/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorageEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include "JSStorage.h"
#include "Storage.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsStorageEventPrototypeFunctionInitStorageEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsStorageEventKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventOldValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventNewValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventUrl(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventStorageArea(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsStorageEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSStorageEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSStorageEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSStorageEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSStorageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSStorageEventPrototype>(vm.heap)) JSStorageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSStorageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSStorageEvent> JSStorageEventConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSStorageEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSStorageEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    StorageEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillStorageEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<StorageEvent> event = StorageEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillStorageEventInit(StorageEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("key", eventInit.key))
        return false;
    if (!dictionary.tryGetProperty("oldValue", eventInit.oldValue))
        return false;
    if (!dictionary.tryGetProperty("newValue", eventInit.newValue))
        return false;
    if (!dictionary.tryGetProperty("url", eventInit.url))
        return false;
    if (!dictionary.tryGetProperty("storageArea", eventInit.storageArea))
        return false;
    return true;
}

template<> JSValue JSStorageEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSStorageEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSStorageEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("StorageEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSStorageEventConstructor::s_info = { "StorageEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStorageEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSStorageEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSStorageEventConstructor) } },
    { "key", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oldValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventOldValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "newValue", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventNewValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "storageArea", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageEventStorageArea), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initStorageEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsStorageEventPrototypeFunctionInitStorageEvent), (intptr_t) (0) } },
};

const ClassInfo JSStorageEventPrototype::s_info = { "StorageEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStorageEventPrototype) };

void JSStorageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSStorageEventPrototypeTableValues, *this);
}

const ClassInfo JSStorageEvent::s_info = { "StorageEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSStorageEvent) };

JSStorageEvent::JSStorageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<StorageEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSStorageEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSStorageEventPrototype::create(vm, globalObject, JSStorageEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSStorageEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorageEvent>(vm, globalObject);
}

EncodedJSValue jsStorageEventKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorageEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StorageEvent", "key");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.key());
    return JSValue::encode(result);
}


EncodedJSValue jsStorageEventOldValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorageEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StorageEvent", "oldValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.oldValue());
    return JSValue::encode(result);
}


EncodedJSValue jsStorageEventNewValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorageEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StorageEvent", "newValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.newValue());
    return JSValue::encode(result);
}


EncodedJSValue jsStorageEventUrl(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorageEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StorageEvent", "url");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.url());
    return JSValue::encode(result);
}


EncodedJSValue jsStorageEventStorageArea(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSStorageEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "StorageEvent", "storageArea");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.storageArea()));
    return JSValue::encode(result);
}


EncodedJSValue jsStorageEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSStorageEventPrototype* domObject = jsDynamicCast<JSStorageEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSStorageEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSStorageEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSStorageEventPrototype* domObject = jsDynamicCast<JSStorageEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSStorageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStorageEventPrototypeFunctionInitStorageEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSStorageEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "StorageEvent", "initStorageEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSStorageEvent::info());
    auto& impl = castedThis->wrapped();
    String typeArg = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool canBubbleArg = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool cancelableArg = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String keyArg = state->argument(3).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String oldValueArg = valueToStringWithNullCheck(state, state->argument(4));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String newValueArg = valueToStringWithNullCheck(state, state->argument(5));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String urlArg = state->argument(6).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Storage* storageAreaArg = JSStorage::toWrapped(state->argument(7));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initStorageEvent(typeArg, canBubbleArg, cancelableArg, keyArg, oldValueArg, newValueArg, urlArg, storageAreaArg);
    return JSValue::encode(jsUndefined());
}


}
