/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLSampler.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLSamplerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLSamplerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLSamplerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLSamplerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLSamplerPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLSamplerPrototype>(vm.heap)) JSWebGLSamplerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLSamplerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLSampler> JSWebGLSamplerConstructor;

template<> JSValue JSWebGLSamplerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLSamplerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLSampler::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLSampler"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLSamplerConstructor::s_info = { "WebGLSampler", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLSamplerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLSamplerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLSamplerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLSamplerConstructor) } },
};

const ClassInfo JSWebGLSamplerPrototype::s_info = { "WebGLSamplerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLSamplerPrototype) };

void JSWebGLSamplerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLSamplerPrototypeTableValues, *this);
}

const ClassInfo JSWebGLSampler::s_info = { "WebGLSampler", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLSampler) };

JSWebGLSampler::JSWebGLSampler(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLSampler>&& impl)
    : JSDOMWrapper<WebGLSampler>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLSampler::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLSamplerPrototype::create(vm, globalObject, JSWebGLSamplerPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLSampler::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLSampler>(vm, globalObject);
}

void JSWebGLSampler::destroy(JSC::JSCell* cell)
{
    JSWebGLSampler* thisObject = static_cast<JSWebGLSampler*>(cell);
    thisObject->JSWebGLSampler::~JSWebGLSampler();
}

EncodedJSValue jsWebGLSamplerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLSamplerPrototype* domObject = jsDynamicCast<JSWebGLSamplerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLSampler::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLSamplerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLSamplerPrototype* domObject = jsDynamicCast<JSWebGLSamplerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLSampler::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLSamplerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLSamplerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLSamplerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLSampler = jsCast<JSWebGLSampler*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLSampler->wrapped(), jsWebGLSampler);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLSampler@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGLSamplerE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLSampler* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLSampler>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLSampler* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLSampler>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLSampler@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGLSamplerE[2];
#if COMPILER(CLANG)
    // If this fails WebGLSampler does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLSampler), WebGLSampler_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLSampler has subclasses. If WebGLSampler has subclasses that get passed
    // to toJS() we currently require WebGLSampler you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLSampler>(globalObject, impl);
}

WebGLSampler* JSWebGLSampler::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLSampler*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
