/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitPoint.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebKitPointX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitPointX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitPointY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitPointY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWebKitPointConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebKitPointConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebKitPointPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebKitPointPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebKitPointPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebKitPointPrototype>(vm.heap)) JSWebKitPointPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebKitPointPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSWebKitPoint> JSWebKitPointConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSWebKitPointConstructor::construct(JSC::ExecState* state)
{
    return constructJSWebKitPoint(state);
}

template<> JSValue JSWebKitPointConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebKitPointConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebKitPoint::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebKitPoint"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebKitPointConstructor::s_info = { "WebKitPoint", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitPointConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebKitPointPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitPointConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitPointConstructor) } },
    { "x", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitPointX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitPointX) } },
    { "y", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitPointY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebKitPointY) } },
};

const ClassInfo JSWebKitPointPrototype::s_info = { "WebKitPointPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitPointPrototype) };

void JSWebKitPointPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebKitPointPrototypeTableValues, *this);
}

const ClassInfo JSWebKitPoint::s_info = { "WebKitPoint", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebKitPoint) };

JSWebKitPoint::JSWebKitPoint(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebKitPoint>&& impl)
    : JSDOMWrapper<WebKitPoint>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebKitPoint::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebKitPointPrototype::create(vm, globalObject, JSWebKitPointPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebKitPoint::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitPoint>(vm, globalObject);
}

void JSWebKitPoint::destroy(JSC::JSCell* cell)
{
    JSWebKitPoint* thisObject = static_cast<JSWebKitPoint*>(cell);
    thisObject->JSWebKitPoint::~JSWebKitPoint();
}

EncodedJSValue jsWebKitPointX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitPoint*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitPoint", "x");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.x());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitPointY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebKitPoint*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebKitPoint", "y");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.y());
    return JSValue::encode(result);
}


EncodedJSValue jsWebKitPointConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebKitPointPrototype* domObject = jsDynamicCast<JSWebKitPointPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebKitPoint::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebKitPointConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebKitPointPrototype* domObject = jsDynamicCast<JSWebKitPointPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSWebKitPointX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitPoint* castedThis = jsDynamicCast<JSWebKitPoint*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitPoint", "x");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setX(nativeValue);
}


void setJSWebKitPointY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWebKitPoint* castedThis = jsDynamicCast<JSWebKitPoint*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WebKitPoint", "y");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setY(nativeValue);
}


JSValue JSWebKitPoint::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitPointConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebKitPointOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebKitPointOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebKitPoint = jsCast<JSWebKitPoint*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebKitPoint->wrapped(), jsWebKitPoint);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitPoint* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebKitPoint>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebKitPoint* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebKitPoint>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to WebKitPoint.
    COMPILE_ASSERT(!__is_polymorphic(WebKitPoint), WebKitPoint_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSWebKitPoint>(globalObject, impl);
}

WebKitPoint* JSWebKitPoint::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebKitPoint*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
