/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLSerializer.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXMLSerializerPrototypeFunctionSerializeToString(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsXMLSerializerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLSerializerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLSerializerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXMLSerializerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLSerializerPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLSerializerPrototype>(vm.heap)) JSXMLSerializerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLSerializerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSXMLSerializer> JSXMLSerializerConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSXMLSerializerConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSXMLSerializerConstructor*>(state->callee());
    RefPtr<XMLSerializer> object = XMLSerializer::create();
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSXMLSerializerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXMLSerializerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLSerializer::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XMLSerializer"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXMLSerializerConstructor::s_info = { "XMLSerializer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLSerializerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLSerializerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLSerializerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLSerializerConstructor) } },
    { "serializeToString", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsXMLSerializerPrototypeFunctionSerializeToString), (intptr_t) (0) } },
};

const ClassInfo JSXMLSerializerPrototype::s_info = { "XMLSerializerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLSerializerPrototype) };

void JSXMLSerializerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLSerializerPrototypeTableValues, *this);
}

const ClassInfo JSXMLSerializer::s_info = { "XMLSerializer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLSerializer) };

JSXMLSerializer::JSXMLSerializer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLSerializer>&& impl)
    : JSDOMWrapper<XMLSerializer>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXMLSerializer::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXMLSerializerPrototype::create(vm, globalObject, JSXMLSerializerPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSXMLSerializer::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLSerializer>(vm, globalObject);
}

void JSXMLSerializer::destroy(JSC::JSCell* cell)
{
    JSXMLSerializer* thisObject = static_cast<JSXMLSerializer*>(cell);
    thisObject->JSXMLSerializer::~JSXMLSerializer();
}

EncodedJSValue jsXMLSerializerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXMLSerializerPrototype* domObject = jsDynamicCast<JSXMLSerializerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXMLSerializer::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXMLSerializerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXMLSerializerPrototype* domObject = jsDynamicCast<JSXMLSerializerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSXMLSerializer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLSerializerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsXMLSerializerPrototypeFunctionSerializeToString(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSXMLSerializer*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "XMLSerializer", "serializeToString");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSXMLSerializer::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* node = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.serializeToString(node, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSXMLSerializerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSXMLSerializerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXMLSerializer = jsCast<JSXMLSerializer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXMLSerializer->wrapped(), jsXMLSerializer);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLSerializer* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSXMLSerializer>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, XMLSerializer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSXMLSerializer>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XMLSerializer.
    COMPILE_ASSERT(!__is_polymorphic(XMLSerializer), XMLSerializer_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSXMLSerializer>(globalObject, impl);
}

XMLSerializer* JSXMLSerializer::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLSerializer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
