/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSXSLTProcessor_h
#define JSXSLTProcessor_h

#if ENABLE(XSLT)

#include "JSDOMWrapper.h"
#include "XSLTProcessor.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSXSLTProcessor : public JSDOMWrapper<XSLTProcessor> {
public:
    typedef JSDOMWrapper<XSLTProcessor> Base;
    static JSXSLTProcessor* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<XSLTProcessor>&& impl)
    {
        JSXSLTProcessor* ptr = new (NotNull, JSC::allocateCell<JSXSLTProcessor>(globalObject->vm().heap)) JSXSLTProcessor(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static const bool hasStaticPropertyTable = false;

    static JSC::JSObject* createPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static JSC::JSObject* getPrototype(JSC::VM&, JSC::JSGlobalObject*);
    static XSLTProcessor* toWrapped(JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue setParameter(JSC::ExecState&);
    JSC::JSValue getParameter(JSC::ExecState&);
    JSC::JSValue removeParameter(JSC::ExecState&);
protected:
    JSXSLTProcessor(JSC::Structure*, JSDOMGlobalObject&, Ref<XSLTProcessor>&&);

    void finishCreation(JSC::VM& vm)
    {
        Base::finishCreation(vm);
        ASSERT(inherits(info()));
    }

};

class JSXSLTProcessorOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, XSLTProcessor*)
{
    static NeverDestroyed<JSXSLTProcessorOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(XSLTProcessor* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, XSLTProcessor*);
inline JSC::JSValue toJS(JSC::ExecState* state, JSDOMGlobalObject* globalObject, XSLTProcessor& impl) { return toJS(state, globalObject, &impl); }
JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject*, XSLTProcessor*);


} // namespace WebCore

#endif // ENABLE(XSLT)

#endif
