/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebUserContentControllerMessages_h
#define WebUserContentControllerMessages_h

#include "ArgumentCoders.h"
#include "Arguments.h"
#include "MessageEncoder.h"
#include "StringReference.h"
#if ENABLE(CONTENT_EXTENSIONS)
#include "WebCompiledContentExtensionData.h"
#endif
#include "WebCoreArgumentCoders.h"
#include "WebScriptMessageHandler.h"
#include <WebCore/UserScript.h>
#include <WebCore/UserStyleSheet.h>
#if ENABLE(CONTENT_EXTENSIONS)
#include <utility>
#endif
#include <wtf/Vector.h>
#include <wtf/text/WTFString.h>


namespace Messages {
namespace WebUserContentController {

static inline IPC::StringReference messageReceiverName()
{
    return IPC::StringReference("WebUserContentController");
}

class AddUserScripts {
public:
    typedef std::tuple<Vector<WebCore::UserScript>> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserScripts"); }
    static const bool isSync = false;

    explicit AddUserScripts(const Vector<WebCore::UserScript>& userScripts)
        : m_arguments(userScripts)
    {
    }

    const std::tuple<const Vector<WebCore::UserScript>&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const Vector<WebCore::UserScript>&> m_arguments;
};

class RemoveUserScript {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveUserScript"); }
    static const bool isSync = false;

    explicit RemoveUserScript(const String& url)
        : m_arguments(url)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};

class RemoveAllUserScripts {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserScripts"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class AddUserStyleSheets {
public:
    typedef std::tuple<Vector<WebCore::UserStyleSheet>> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserStyleSheets"); }
    static const bool isSync = false;

    explicit AddUserStyleSheets(const Vector<WebCore::UserStyleSheet>& userStyleSheets)
        : m_arguments(userStyleSheets)
    {
    }

    const std::tuple<const Vector<WebCore::UserStyleSheet>&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const Vector<WebCore::UserStyleSheet>&> m_arguments;
};

class RemoveUserStyleSheet {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveUserStyleSheet"); }
    static const bool isSync = false;

    explicit RemoveUserStyleSheet(const String& url)
        : m_arguments(url)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};

class RemoveAllUserStyleSheets {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserStyleSheets"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};

class AddUserScriptMessageHandlers {
public:
    typedef std::tuple<Vector<WebKit::WebScriptMessageHandlerHandle>> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserScriptMessageHandlers"); }
    static const bool isSync = false;

    explicit AddUserScriptMessageHandlers(const Vector<WebKit::WebScriptMessageHandlerHandle>& scriptMessageHandlers)
        : m_arguments(scriptMessageHandlers)
    {
    }

    const std::tuple<const Vector<WebKit::WebScriptMessageHandlerHandle>&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const Vector<WebKit::WebScriptMessageHandlerHandle>&> m_arguments;
};

class RemoveUserScriptMessageHandler {
public:
    typedef std::tuple<uint64_t> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveUserScriptMessageHandler"); }
    static const bool isSync = false;

    explicit RemoveUserScriptMessageHandler(uint64_t identifier)
        : m_arguments(identifier)
    {
    }

    const std::tuple<uint64_t>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<uint64_t> m_arguments;
};

#if ENABLE(CONTENT_EXTENSIONS)
class AddUserContentExtensions {
public:
    typedef std::tuple<Vector<std::pair<String, WebKit::WebCompiledContentExtensionData>>> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("AddUserContentExtensions"); }
    static const bool isSync = false;

    explicit AddUserContentExtensions(const Vector<std::pair<String, WebKit::WebCompiledContentExtensionData>>& userContentFilters)
        : m_arguments(userContentFilters)
    {
    }

    const std::tuple<const Vector<std::pair<String, WebKit::WebCompiledContentExtensionData>>&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const Vector<std::pair<String, WebKit::WebCompiledContentExtensionData>>&> m_arguments;
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
class RemoveUserContentExtension {
public:
    typedef std::tuple<String> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveUserContentExtension"); }
    static const bool isSync = false;

    explicit RemoveUserContentExtension(const String& name)
        : m_arguments(name)
    {
    }

    const std::tuple<const String&>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<const String&> m_arguments;
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
class RemoveAllUserContentExtensions {
public:
    typedef std::tuple<> DecodeType;

    static IPC::StringReference receiverName() { return messageReceiverName(); }
    static IPC::StringReference name() { return IPC::StringReference("RemoveAllUserContentExtensions"); }
    static const bool isSync = false;

    const std::tuple<>& arguments() const
    {
        return m_arguments;
    }

private:
    std::tuple<> m_arguments;
};
#endif

} // namespace WebUserContentController
} // namespace Messages

#endif // WebUserContentControllerMessages_h
