/*
 * Copyright (c) 2014, 2015 Apple Inc. All rights reserved.
 * Copyright (c) 2015 Andy VanWagoner <thetalecrafter@gmail.com>.
 * Copyright (c) 2015 Jordan Harband. All rights reserved.
 * Copyright (c) 2015, 2016 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016 Yusuke Suzuki <utatane.tea@gmail.com>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#ifndef JSCBuiltins_h
#define JSCBuiltins_h

namespace JSC {
class FunctionExecutable;
class VM;

enum class ConstructAbility : unsigned;
}

namespace JSC {

/* ArrayConstructor */
extern const char* s_arrayConstructorOfCode;
extern const int s_arrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorOfCodeConstructAbility;
extern const char* s_arrayConstructorFromCode;
extern const int s_arrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorFromCodeConstructAbility;

#define JSC_FOREACH_ARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, arrayConstructorOf, 0) \
    macro(from, arrayConstructorFrom, 1) \

/* ArrayIteratorPrototype */
extern const char* s_arrayIteratorPrototypeNextCode;
extern const int s_arrayIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_arrayIteratorPrototypeNextCodeConstructAbility;

#define JSC_FOREACH_ARRAYITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, arrayIteratorPrototypeNext, 0) \

/* ArrayPrototype */
extern const char* s_arrayPrototypeReduceCode;
extern const int s_arrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceCodeConstructAbility;
extern const char* s_arrayPrototypeReduceRightCode;
extern const int s_arrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceRightCodeConstructAbility;
extern const char* s_arrayPrototypeEveryCode;
extern const int s_arrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeEveryCodeConstructAbility;
extern const char* s_arrayPrototypeForEachCode;
extern const int s_arrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeForEachCodeConstructAbility;
extern const char* s_arrayPrototypeFilterCode;
extern const int s_arrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFilterCodeConstructAbility;
extern const char* s_arrayPrototypeMapCode;
extern const int s_arrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMapCodeConstructAbility;
extern const char* s_arrayPrototypeSomeCode;
extern const int s_arrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSomeCodeConstructAbility;
extern const char* s_arrayPrototypeFillCode;
extern const int s_arrayPrototypeFillCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFillCodeConstructAbility;
extern const char* s_arrayPrototypeFindCode;
extern const int s_arrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindCodeConstructAbility;
extern const char* s_arrayPrototypeFindIndexCode;
extern const int s_arrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindIndexCodeConstructAbility;
extern const char* s_arrayPrototypeIncludesCode;
extern const int s_arrayPrototypeIncludesCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeIncludesCodeConstructAbility;
extern const char* s_arrayPrototypeSortCode;
extern const int s_arrayPrototypeSortCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortCodeConstructAbility;
extern const char* s_arrayPrototypeCopyWithinCode;
extern const int s_arrayPrototypeCopyWithinCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeCopyWithinCodeConstructAbility;

#define JSC_FOREACH_ARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(reduce, arrayPrototypeReduce, 1) \
    macro(reduceRight, arrayPrototypeReduceRight, 1) \
    macro(every, arrayPrototypeEvery, 1) \
    macro(forEach, arrayPrototypeForEach, 1) \
    macro(filter, arrayPrototypeFilter, 1) \
    macro(map, arrayPrototypeMap, 1) \
    macro(some, arrayPrototypeSome, 1) \
    macro(fill, arrayPrototypeFill, 1) \
    macro(find, arrayPrototypeFind, 1) \
    macro(findIndex, arrayPrototypeFindIndex, 1) \
    macro(includes, arrayPrototypeIncludes, 1) \
    macro(sort, arrayPrototypeSort, 1) \
    macro(copyWithin, arrayPrototypeCopyWithin, 2) \

/* DatePrototype */
extern const char* s_datePrototypeToLocaleStringCode;
extern const int s_datePrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleStringCodeConstructAbility;
extern const char* s_datePrototypeToLocaleDateStringCode;
extern const int s_datePrototypeToLocaleDateStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleDateStringCodeConstructAbility;
extern const char* s_datePrototypeToLocaleTimeStringCode;
extern const int s_datePrototypeToLocaleTimeStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleTimeStringCodeConstructAbility;

#define JSC_FOREACH_DATEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(toLocaleString, datePrototypeToLocaleString, 0) \
    macro(toLocaleDateString, datePrototypeToLocaleDateString, 0) \
    macro(toLocaleTimeString, datePrototypeToLocaleTimeString, 0) \

/* FunctionPrototype */
extern const char* s_functionPrototypeCallCode;
extern const int s_functionPrototypeCallCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeCallCodeConstructAbility;
extern const char* s_functionPrototypeApplyCode;
extern const int s_functionPrototypeApplyCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeApplyCodeConstructAbility;
extern const char* s_functionPrototypeSymbolHasInstanceCode;
extern const int s_functionPrototypeSymbolHasInstanceCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeSymbolHasInstanceCodeConstructAbility;

#define JSC_FOREACH_FUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(call, functionPrototypeCall, 1) \
    macro(apply, functionPrototypeApply, 2) \
    macro(symbolHasInstance, functionPrototypeSymbolHasInstance, 1) \

/* GeneratorPrototype */
extern const char* s_generatorPrototypeGeneratorResumeCode;
extern const int s_generatorPrototypeGeneratorResumeCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeGeneratorResumeCodeConstructAbility;
extern const char* s_generatorPrototypeNextCode;
extern const int s_generatorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeNextCodeConstructAbility;
extern const char* s_generatorPrototypeReturnCode;
extern const int s_generatorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeReturnCodeConstructAbility;
extern const char* s_generatorPrototypeThrowCode;
extern const int s_generatorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeThrowCodeConstructAbility;

#define JSC_FOREACH_GENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(generatorResume, generatorPrototypeGeneratorResume, 3) \
    macro(next, generatorPrototypeNext, 1) \
    macro(return, generatorPrototypeReturn, 1) \
    macro(throw, generatorPrototypeThrow, 1) \

/* GlobalObject */
extern const char* s_globalObjectToIntegerCode;
extern const int s_globalObjectToIntegerCodeLength;
extern const JSC::ConstructAbility s_globalObjectToIntegerCodeConstructAbility;
extern const char* s_globalObjectToLengthCode;
extern const int s_globalObjectToLengthCodeLength;
extern const JSC::ConstructAbility s_globalObjectToLengthCodeConstructAbility;
extern const char* s_globalObjectIsDictionaryCode;
extern const int s_globalObjectIsDictionaryCodeLength;
extern const JSC::ConstructAbility s_globalObjectIsDictionaryCodeConstructAbility;
extern const char* s_globalObjectSpeciesGetterCode;
extern const int s_globalObjectSpeciesGetterCodeLength;
extern const JSC::ConstructAbility s_globalObjectSpeciesGetterCodeConstructAbility;

#define JSC_FOREACH_GLOBALOBJECT_BUILTIN_DATA(macro) \
    macro(toInteger, globalObjectToInteger, 1) \
    macro(toLength, globalObjectToLength, 1) \
    macro(isDictionary, globalObjectIsDictionary, 1) \
    macro(speciesGetter, globalObjectSpeciesGetter, 0) \

/* InspectorInstrumentationObject */
extern const char* s_inspectorInstrumentationObjectPromiseFulfilledCode;
extern const int s_inspectorInstrumentationObjectPromiseFulfilledCodeLength;
extern const JSC::ConstructAbility s_inspectorInstrumentationObjectPromiseFulfilledCodeConstructAbility;
extern const char* s_inspectorInstrumentationObjectPromiseRejectedCode;
extern const int s_inspectorInstrumentationObjectPromiseRejectedCodeLength;
extern const JSC::ConstructAbility s_inspectorInstrumentationObjectPromiseRejectedCodeConstructAbility;

#define JSC_FOREACH_INSPECTORINSTRUMENTATIONOBJECT_BUILTIN_DATA(macro) \
    macro(promiseFulfilled, inspectorInstrumentationObjectPromiseFulfilled, 3) \
    macro(promiseRejected, inspectorInstrumentationObjectPromiseRejected, 3) \

/* InternalPromiseConstructor */
extern const char* s_internalPromiseConstructorInternalAllCode;
extern const int s_internalPromiseConstructorInternalAllCodeLength;
extern const JSC::ConstructAbility s_internalPromiseConstructorInternalAllCodeConstructAbility;

#define JSC_FOREACH_INTERNALPROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(internalAll, internalPromiseConstructorInternalAll, 1) \

/* IteratorPrototype */
extern const char* s_iteratorPrototypeSymbolIteratorGetterCode;
extern const int s_iteratorPrototypeSymbolIteratorGetterCodeLength;
extern const JSC::ConstructAbility s_iteratorPrototypeSymbolIteratorGetterCodeConstructAbility;

#define JSC_FOREACH_ITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(symbolIteratorGetter, iteratorPrototypeSymbolIteratorGetter, 0) \

/* MapPrototype */
extern const char* s_mapPrototypeForEachCode;
extern const int s_mapPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_mapPrototypeForEachCodeConstructAbility;

#define JSC_FOREACH_MAPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, mapPrototypeForEach, 1) \

/* ModuleLoaderObject */
extern const char* s_moduleLoaderObjectSetStateToMaxCode;
extern const int s_moduleLoaderObjectSetStateToMaxCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectSetStateToMaxCodeConstructAbility;
extern const char* s_moduleLoaderObjectNewRegistryEntryCode;
extern const int s_moduleLoaderObjectNewRegistryEntryCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectNewRegistryEntryCodeConstructAbility;
extern const char* s_moduleLoaderObjectEnsureRegisteredCode;
extern const int s_moduleLoaderObjectEnsureRegisteredCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectEnsureRegisteredCodeConstructAbility;
extern const char* s_moduleLoaderObjectForceFulfillPromiseCode;
extern const int s_moduleLoaderObjectForceFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectForceFulfillPromiseCodeConstructAbility;
extern const char* s_moduleLoaderObjectFulfillFetchCode;
extern const int s_moduleLoaderObjectFulfillFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectFulfillFetchCodeConstructAbility;
extern const char* s_moduleLoaderObjectFulfillTranslateCode;
extern const int s_moduleLoaderObjectFulfillTranslateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectFulfillTranslateCodeConstructAbility;
extern const char* s_moduleLoaderObjectFulfillInstantiateCode;
extern const int s_moduleLoaderObjectFulfillInstantiateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectFulfillInstantiateCodeConstructAbility;
extern const char* s_moduleLoaderObjectCommitInstantiatedCode;
extern const int s_moduleLoaderObjectCommitInstantiatedCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectCommitInstantiatedCodeConstructAbility;
extern const char* s_moduleLoaderObjectInstantiationCode;
extern const int s_moduleLoaderObjectInstantiationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectInstantiationCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestFetchCode;
extern const int s_moduleLoaderObjectRequestFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestFetchCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestTranslateCode;
extern const int s_moduleLoaderObjectRequestTranslateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestTranslateCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestInstantiateCode;
extern const int s_moduleLoaderObjectRequestInstantiateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestInstantiateCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestResolveDependenciesCode;
extern const int s_moduleLoaderObjectRequestResolveDependenciesCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestResolveDependenciesCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestInstantiateAllCode;
extern const int s_moduleLoaderObjectRequestInstantiateAllCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestInstantiateAllCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestLinkCode;
extern const int s_moduleLoaderObjectRequestLinkCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestLinkCodeConstructAbility;
extern const char* s_moduleLoaderObjectRequestReadyCode;
extern const int s_moduleLoaderObjectRequestReadyCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectRequestReadyCodeConstructAbility;
extern const char* s_moduleLoaderObjectLinkCode;
extern const int s_moduleLoaderObjectLinkCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectLinkCodeConstructAbility;
extern const char* s_moduleLoaderObjectModuleEvaluationCode;
extern const int s_moduleLoaderObjectModuleEvaluationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectModuleEvaluationCodeConstructAbility;
extern const char* s_moduleLoaderObjectProvideCode;
extern const int s_moduleLoaderObjectProvideCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectProvideCodeConstructAbility;
extern const char* s_moduleLoaderObjectLoadAndEvaluateModuleCode;
extern const int s_moduleLoaderObjectLoadAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectLoadAndEvaluateModuleCodeConstructAbility;
extern const char* s_moduleLoaderObjectLoadModuleCode;
extern const int s_moduleLoaderObjectLoadModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectLoadModuleCodeConstructAbility;
extern const char* s_moduleLoaderObjectLinkAndEvaluateModuleCode;
extern const int s_moduleLoaderObjectLinkAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderObjectLinkAndEvaluateModuleCodeConstructAbility;

#define JSC_FOREACH_MODULELOADEROBJECT_BUILTIN_DATA(macro) \
    macro(setStateToMax, moduleLoaderObjectSetStateToMax, 2) \
    macro(newRegistryEntry, moduleLoaderObjectNewRegistryEntry, 1) \
    macro(ensureRegistered, moduleLoaderObjectEnsureRegistered, 1) \
    macro(forceFulfillPromise, moduleLoaderObjectForceFulfillPromise, 2) \
    macro(fulfillFetch, moduleLoaderObjectFulfillFetch, 2) \
    macro(fulfillTranslate, moduleLoaderObjectFulfillTranslate, 2) \
    macro(fulfillInstantiate, moduleLoaderObjectFulfillInstantiate, 3) \
    macro(commitInstantiated, moduleLoaderObjectCommitInstantiated, 3) \
    macro(instantiation, moduleLoaderObjectInstantiation, 3) \
    macro(requestFetch, moduleLoaderObjectRequestFetch, 1) \
    macro(requestTranslate, moduleLoaderObjectRequestTranslate, 1) \
    macro(requestInstantiate, moduleLoaderObjectRequestInstantiate, 1) \
    macro(requestResolveDependencies, moduleLoaderObjectRequestResolveDependencies, 1) \
    macro(requestInstantiateAll, moduleLoaderObjectRequestInstantiateAll, 1) \
    macro(requestLink, moduleLoaderObjectRequestLink, 1) \
    macro(requestReady, moduleLoaderObjectRequestReady, 1) \
    macro(link, moduleLoaderObjectLink, 1) \
    macro(moduleEvaluation, moduleLoaderObjectModuleEvaluation, 1) \
    macro(provide, moduleLoaderObjectProvide, 3) \
    macro(loadAndEvaluateModule, moduleLoaderObjectLoadAndEvaluateModule, 2) \
    macro(loadModule, moduleLoaderObjectLoadModule, 2) \
    macro(linkAndEvaluateModule, moduleLoaderObjectLinkAndEvaluateModule, 1) \

/* NumberPrototype */
extern const char* s_numberPrototypeToLocaleStringCode;
extern const int s_numberPrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_numberPrototypeToLocaleStringCodeConstructAbility;

#define JSC_FOREACH_NUMBERPROTOTYPE_BUILTIN_DATA(macro) \
    macro(toLocaleString, numberPrototypeToLocaleString, 0) \

/* ObjectConstructor */
extern const char* s_objectConstructorAssignCode;
extern const int s_objectConstructorAssignCodeLength;
extern const JSC::ConstructAbility s_objectConstructorAssignCodeConstructAbility;

#define JSC_FOREACH_OBJECTCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(assign, objectConstructorAssign, 2) \

/* PromiseConstructor */
extern const char* s_promiseConstructorAllCode;
extern const int s_promiseConstructorAllCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAllCodeConstructAbility;
extern const char* s_promiseConstructorRaceCode;
extern const int s_promiseConstructorRaceCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRaceCodeConstructAbility;
extern const char* s_promiseConstructorRejectCode;
extern const int s_promiseConstructorRejectCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRejectCodeConstructAbility;
extern const char* s_promiseConstructorResolveCode;
extern const int s_promiseConstructorResolveCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorResolveCodeConstructAbility;

#define JSC_FOREACH_PROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(all, promiseConstructorAll, 1) \
    macro(race, promiseConstructorRace, 1) \
    macro(reject, promiseConstructorReject, 1) \
    macro(resolve, promiseConstructorResolve, 1) \

/* PromiseOperations */
extern const char* s_promiseOperationsIsPromiseCode;
extern const int s_promiseOperationsIsPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsIsPromiseCodeConstructAbility;
extern const char* s_promiseOperationsNewPromiseReactionCode;
extern const int s_promiseOperationsNewPromiseReactionCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseReactionCodeConstructAbility;
extern const char* s_promiseOperationsNewPromiseCapabilityCode;
extern const int s_promiseOperationsNewPromiseCapabilityCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilityCodeConstructAbility;
extern const char* s_promiseOperationsTriggerPromiseReactionsCode;
extern const int s_promiseOperationsTriggerPromiseReactionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsTriggerPromiseReactionsCodeConstructAbility;
extern const char* s_promiseOperationsRejectPromiseCode;
extern const int s_promiseOperationsRejectPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectPromiseCodeConstructAbility;
extern const char* s_promiseOperationsFulfillPromiseCode;
extern const int s_promiseOperationsFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillPromiseCodeConstructAbility;
extern const char* s_promiseOperationsCreateResolvingFunctionsCode;
extern const int s_promiseOperationsCreateResolvingFunctionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsCodeConstructAbility;
extern const char* s_promiseOperationsPromiseReactionJobCode;
extern const int s_promiseOperationsPromiseReactionJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobCodeConstructAbility;
extern const char* s_promiseOperationsPromiseResolveThenableJobCode;
extern const int s_promiseOperationsPromiseResolveThenableJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobCodeConstructAbility;
extern const char* s_promiseOperationsInitializePromiseCode;
extern const int s_promiseOperationsInitializePromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsInitializePromiseCodeConstructAbility;

#define JSC_FOREACH_PROMISEOPERATIONS_BUILTIN_DATA(macro) \
    macro(isPromise, promiseOperationsIsPromise, 1) \
    macro(newPromiseReaction, promiseOperationsNewPromiseReaction, 2) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability, 1) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions, 2) \
    macro(rejectPromise, promiseOperationsRejectPromise, 2) \
    macro(fulfillPromise, promiseOperationsFulfillPromise, 2) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions, 1) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob, 2) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob, 3) \
    macro(initializePromise, promiseOperationsInitializePromise, 1) \

/* PromisePrototype */
extern const char* s_promisePrototypeCatchCode;
extern const int s_promisePrototypeCatchCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeCatchCodeConstructAbility;
extern const char* s_promisePrototypeThenCode;
extern const int s_promisePrototypeThenCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeThenCodeConstructAbility;

#define JSC_FOREACH_PROMISEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(catch, promisePrototypeCatch, 1) \
    macro(then, promisePrototypeThen, 2) \

/* ReflectObject */
extern const char* s_reflectObjectApplyCode;
extern const int s_reflectObjectApplyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectApplyCodeConstructAbility;
extern const char* s_reflectObjectDeletePropertyCode;
extern const int s_reflectObjectDeletePropertyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectDeletePropertyCodeConstructAbility;
extern const char* s_reflectObjectHasCode;
extern const int s_reflectObjectHasCodeLength;
extern const JSC::ConstructAbility s_reflectObjectHasCodeConstructAbility;

#define JSC_FOREACH_REFLECTOBJECT_BUILTIN_DATA(macro) \
    macro(apply, reflectObjectApply, 3) \
    macro(deleteProperty, reflectObjectDeleteProperty, 2) \
    macro(has, reflectObjectHas, 2) \

/* SetPrototype */
extern const char* s_setPrototypeForEachCode;
extern const int s_setPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_setPrototypeForEachCodeConstructAbility;

#define JSC_FOREACH_SETPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, setPrototypeForEach, 1) \

/* StringConstructor */
extern const char* s_stringConstructorRawCode;
extern const int s_stringConstructorRawCodeLength;
extern const JSC::ConstructAbility s_stringConstructorRawCodeConstructAbility;

#define JSC_FOREACH_STRINGCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(raw, stringConstructorRaw, 1) \

/* StringIteratorPrototype */
extern const char* s_stringIteratorPrototypeNextCode;
extern const int s_stringIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_stringIteratorPrototypeNextCodeConstructAbility;

#define JSC_FOREACH_STRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, stringIteratorPrototypeNext, 0) \

/* StringPrototype */
extern const char* s_stringPrototypeLocaleCompareCode;
extern const int s_stringPrototypeLocaleCompareCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeLocaleCompareCodeConstructAbility;
extern const char* s_stringPrototypeSearchCode;
extern const int s_stringPrototypeSearchCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSearchCodeConstructAbility;

#define JSC_FOREACH_STRINGPROTOTYPE_BUILTIN_DATA(macro) \
    macro(localeCompare, stringPrototypeLocaleCompare, 1) \
    macro(search, stringPrototypeSearch, 1) \

/* TypedArrayConstructor */
extern const char* s_typedArrayConstructorOfCode;
extern const int s_typedArrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorOfCodeConstructAbility;
extern const char* s_typedArrayConstructorFromCode;
extern const int s_typedArrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorFromCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateInt8ArrayCode;
extern const int s_typedArrayConstructorAllocateInt8ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateInt8ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateInt16ArrayCode;
extern const int s_typedArrayConstructorAllocateInt16ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateInt16ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateInt32ArrayCode;
extern const int s_typedArrayConstructorAllocateInt32ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateInt32ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateUint32ArrayCode;
extern const int s_typedArrayConstructorAllocateUint32ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateUint32ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateUint16ArrayCode;
extern const int s_typedArrayConstructorAllocateUint16ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateUint16ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateUint8ArrayCode;
extern const int s_typedArrayConstructorAllocateUint8ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateUint8ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateUint8ClampedArrayCode;
extern const int s_typedArrayConstructorAllocateUint8ClampedArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateUint8ClampedArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateFloat32ArrayCode;
extern const int s_typedArrayConstructorAllocateFloat32ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateFloat32ArrayCodeConstructAbility;
extern const char* s_typedArrayConstructorAllocateFloat64ArrayCode;
extern const int s_typedArrayConstructorAllocateFloat64ArrayCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorAllocateFloat64ArrayCodeConstructAbility;

#define JSC_FOREACH_TYPEDARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, typedArrayConstructorOf, 0) \
    macro(from, typedArrayConstructorFrom, 1) \
    macro(allocateInt8Array, typedArrayConstructorAllocateInt8Array, 1) \
    macro(allocateInt16Array, typedArrayConstructorAllocateInt16Array, 1) \
    macro(allocateInt32Array, typedArrayConstructorAllocateInt32Array, 1) \
    macro(allocateUint32Array, typedArrayConstructorAllocateUint32Array, 1) \
    macro(allocateUint16Array, typedArrayConstructorAllocateUint16Array, 1) \
    macro(allocateUint8Array, typedArrayConstructorAllocateUint8Array, 1) \
    macro(allocateUint8ClampedArray, typedArrayConstructorAllocateUint8ClampedArray, 1) \
    macro(allocateFloat32Array, typedArrayConstructorAllocateFloat32Array, 1) \
    macro(allocateFloat64Array, typedArrayConstructorAllocateFloat64Array, 1) \

/* TypedArrayPrototype */
extern const char* s_typedArrayPrototypeEveryCode;
extern const int s_typedArrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeEveryCodeConstructAbility;
extern const char* s_typedArrayPrototypeFindCode;
extern const int s_typedArrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindCodeConstructAbility;
extern const char* s_typedArrayPrototypeFindIndexCode;
extern const int s_typedArrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindIndexCodeConstructAbility;
extern const char* s_typedArrayPrototypeForEachCode;
extern const int s_typedArrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeForEachCodeConstructAbility;
extern const char* s_typedArrayPrototypeSomeCode;
extern const int s_typedArrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeSomeCodeConstructAbility;
extern const char* s_typedArrayPrototypeSortCode;
extern const int s_typedArrayPrototypeSortCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeSortCodeConstructAbility;
extern const char* s_typedArrayPrototypeReduceCode;
extern const int s_typedArrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceCodeConstructAbility;
extern const char* s_typedArrayPrototypeReduceRightCode;
extern const int s_typedArrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceRightCodeConstructAbility;
extern const char* s_typedArrayPrototypeMapCode;
extern const int s_typedArrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeMapCodeConstructAbility;
extern const char* s_typedArrayPrototypeFilterCode;
extern const int s_typedArrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFilterCodeConstructAbility;
extern const char* s_typedArrayPrototypeToLocaleStringCode;
extern const int s_typedArrayPrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeToLocaleStringCodeConstructAbility;

#define JSC_FOREACH_TYPEDARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(every, typedArrayPrototypeEvery, 1) \
    macro(find, typedArrayPrototypeFind, 1) \
    macro(findIndex, typedArrayPrototypeFindIndex, 1) \
    macro(forEach, typedArrayPrototypeForEach, 1) \
    macro(some, typedArrayPrototypeSome, 1) \
    macro(sort, typedArrayPrototypeSort, 1) \
    macro(reduce, typedArrayPrototypeReduce, 1) \
    macro(reduceRight, typedArrayPrototypeReduceRight, 1) \
    macro(map, typedArrayPrototypeMap, 1) \
    macro(filter, typedArrayPrototypeFilter, 1) \
    macro(toLocaleString, typedArrayPrototypeToLocaleString, 0) \

#define JSC_FOREACH_BUILTIN_CODE(macro) \
    macro(promiseConstructorAllCode, all, s_promiseConstructorAllCodeLength) \
    macro(typedArrayConstructorAllocateFloat32ArrayCode, allocateFloat32Array, s_typedArrayConstructorAllocateFloat32ArrayCodeLength) \
    macro(typedArrayConstructorAllocateFloat64ArrayCode, allocateFloat64Array, s_typedArrayConstructorAllocateFloat64ArrayCodeLength) \
    macro(typedArrayConstructorAllocateInt16ArrayCode, allocateInt16Array, s_typedArrayConstructorAllocateInt16ArrayCodeLength) \
    macro(typedArrayConstructorAllocateInt32ArrayCode, allocateInt32Array, s_typedArrayConstructorAllocateInt32ArrayCodeLength) \
    macro(typedArrayConstructorAllocateInt8ArrayCode, allocateInt8Array, s_typedArrayConstructorAllocateInt8ArrayCodeLength) \
    macro(typedArrayConstructorAllocateUint16ArrayCode, allocateUint16Array, s_typedArrayConstructorAllocateUint16ArrayCodeLength) \
    macro(typedArrayConstructorAllocateUint32ArrayCode, allocateUint32Array, s_typedArrayConstructorAllocateUint32ArrayCodeLength) \
    macro(typedArrayConstructorAllocateUint8ArrayCode, allocateUint8Array, s_typedArrayConstructorAllocateUint8ArrayCodeLength) \
    macro(typedArrayConstructorAllocateUint8ClampedArrayCode, allocateUint8ClampedArray, s_typedArrayConstructorAllocateUint8ClampedArrayCodeLength) \
    macro(functionPrototypeApplyCode, apply, s_functionPrototypeApplyCodeLength) \
    macro(reflectObjectApplyCode, apply, s_reflectObjectApplyCodeLength) \
    macro(objectConstructorAssignCode, assign, s_objectConstructorAssignCodeLength) \
    macro(functionPrototypeCallCode, call, s_functionPrototypeCallCodeLength) \
    macro(promisePrototypeCatchCode, catch, s_promisePrototypeCatchCodeLength) \
    macro(moduleLoaderObjectCommitInstantiatedCode, commitInstantiated, s_moduleLoaderObjectCommitInstantiatedCodeLength) \
    macro(arrayPrototypeCopyWithinCode, copyWithin, s_arrayPrototypeCopyWithinCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsCode, createResolvingFunctions, s_promiseOperationsCreateResolvingFunctionsCodeLength) \
    macro(reflectObjectDeletePropertyCode, deleteProperty, s_reflectObjectDeletePropertyCodeLength) \
    macro(moduleLoaderObjectEnsureRegisteredCode, ensureRegistered, s_moduleLoaderObjectEnsureRegisteredCodeLength) \
    macro(arrayPrototypeEveryCode, every, s_arrayPrototypeEveryCodeLength) \
    macro(typedArrayPrototypeEveryCode, every, s_typedArrayPrototypeEveryCodeLength) \
    macro(arrayPrototypeFillCode, fill, s_arrayPrototypeFillCodeLength) \
    macro(arrayPrototypeFilterCode, filter, s_arrayPrototypeFilterCodeLength) \
    macro(typedArrayPrototypeFilterCode, filter, s_typedArrayPrototypeFilterCodeLength) \
    macro(arrayPrototypeFindCode, find, s_arrayPrototypeFindCodeLength) \
    macro(typedArrayPrototypeFindCode, find, s_typedArrayPrototypeFindCodeLength) \
    macro(arrayPrototypeFindIndexCode, findIndex, s_arrayPrototypeFindIndexCodeLength) \
    macro(typedArrayPrototypeFindIndexCode, findIndex, s_typedArrayPrototypeFindIndexCodeLength) \
    macro(arrayPrototypeForEachCode, forEach, s_arrayPrototypeForEachCodeLength) \
    macro(mapPrototypeForEachCode, forEach, s_mapPrototypeForEachCodeLength) \
    macro(setPrototypeForEachCode, forEach, s_setPrototypeForEachCodeLength) \
    macro(typedArrayPrototypeForEachCode, forEach, s_typedArrayPrototypeForEachCodeLength) \
    macro(moduleLoaderObjectForceFulfillPromiseCode, forceFulfillPromise, s_moduleLoaderObjectForceFulfillPromiseCodeLength) \
    macro(arrayConstructorFromCode, from, s_arrayConstructorFromCodeLength) \
    macro(typedArrayConstructorFromCode, from, s_typedArrayConstructorFromCodeLength) \
    macro(moduleLoaderObjectFulfillFetchCode, fulfillFetch, s_moduleLoaderObjectFulfillFetchCodeLength) \
    macro(moduleLoaderObjectFulfillInstantiateCode, fulfillInstantiate, s_moduleLoaderObjectFulfillInstantiateCodeLength) \
    macro(promiseOperationsFulfillPromiseCode, fulfillPromise, s_promiseOperationsFulfillPromiseCodeLength) \
    macro(moduleLoaderObjectFulfillTranslateCode, fulfillTranslate, s_moduleLoaderObjectFulfillTranslateCodeLength) \
    macro(generatorPrototypeGeneratorResumeCode, generatorResume, s_generatorPrototypeGeneratorResumeCodeLength) \
    macro(reflectObjectHasCode, has, s_reflectObjectHasCodeLength) \
    macro(arrayPrototypeIncludesCode, includes, s_arrayPrototypeIncludesCodeLength) \
    macro(promiseOperationsInitializePromiseCode, initializePromise, s_promiseOperationsInitializePromiseCodeLength) \
    macro(moduleLoaderObjectInstantiationCode, instantiation, s_moduleLoaderObjectInstantiationCodeLength) \
    macro(internalPromiseConstructorInternalAllCode, internalAll, s_internalPromiseConstructorInternalAllCodeLength) \
    macro(globalObjectIsDictionaryCode, isDictionary, s_globalObjectIsDictionaryCodeLength) \
    macro(promiseOperationsIsPromiseCode, isPromise, s_promiseOperationsIsPromiseCodeLength) \
    macro(moduleLoaderObjectLinkCode, link, s_moduleLoaderObjectLinkCodeLength) \
    macro(moduleLoaderObjectLinkAndEvaluateModuleCode, linkAndEvaluateModule, s_moduleLoaderObjectLinkAndEvaluateModuleCodeLength) \
    macro(moduleLoaderObjectLoadAndEvaluateModuleCode, loadAndEvaluateModule, s_moduleLoaderObjectLoadAndEvaluateModuleCodeLength) \
    macro(moduleLoaderObjectLoadModuleCode, loadModule, s_moduleLoaderObjectLoadModuleCodeLength) \
    macro(stringPrototypeLocaleCompareCode, localeCompare, s_stringPrototypeLocaleCompareCodeLength) \
    macro(arrayPrototypeMapCode, map, s_arrayPrototypeMapCodeLength) \
    macro(typedArrayPrototypeMapCode, map, s_typedArrayPrototypeMapCodeLength) \
    macro(moduleLoaderObjectModuleEvaluationCode, moduleEvaluation, s_moduleLoaderObjectModuleEvaluationCodeLength) \
    macro(promiseOperationsNewPromiseCapabilityCode, newPromiseCapability, s_promiseOperationsNewPromiseCapabilityCodeLength) \
    macro(promiseOperationsNewPromiseReactionCode, newPromiseReaction, s_promiseOperationsNewPromiseReactionCodeLength) \
    macro(moduleLoaderObjectNewRegistryEntryCode, newRegistryEntry, s_moduleLoaderObjectNewRegistryEntryCodeLength) \
    macro(arrayIteratorPrototypeNextCode, next, s_arrayIteratorPrototypeNextCodeLength) \
    macro(generatorPrototypeNextCode, next, s_generatorPrototypeNextCodeLength) \
    macro(stringIteratorPrototypeNextCode, next, s_stringIteratorPrototypeNextCodeLength) \
    macro(arrayConstructorOfCode, of, s_arrayConstructorOfCodeLength) \
    macro(typedArrayConstructorOfCode, of, s_typedArrayConstructorOfCodeLength) \
    macro(inspectorInstrumentationObjectPromiseFulfilledCode, promiseFulfilled, s_inspectorInstrumentationObjectPromiseFulfilledCodeLength) \
    macro(promiseOperationsPromiseReactionJobCode, promiseReactionJob, s_promiseOperationsPromiseReactionJobCodeLength) \
    macro(inspectorInstrumentationObjectPromiseRejectedCode, promiseRejected, s_inspectorInstrumentationObjectPromiseRejectedCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobCode, promiseResolveThenableJob, s_promiseOperationsPromiseResolveThenableJobCodeLength) \
    macro(moduleLoaderObjectProvideCode, provide, s_moduleLoaderObjectProvideCodeLength) \
    macro(promiseConstructorRaceCode, race, s_promiseConstructorRaceCodeLength) \
    macro(stringConstructorRawCode, raw, s_stringConstructorRawCodeLength) \
    macro(arrayPrototypeReduceCode, reduce, s_arrayPrototypeReduceCodeLength) \
    macro(typedArrayPrototypeReduceCode, reduce, s_typedArrayPrototypeReduceCodeLength) \
    macro(arrayPrototypeReduceRightCode, reduceRight, s_arrayPrototypeReduceRightCodeLength) \
    macro(typedArrayPrototypeReduceRightCode, reduceRight, s_typedArrayPrototypeReduceRightCodeLength) \
    macro(promiseConstructorRejectCode, reject, s_promiseConstructorRejectCodeLength) \
    macro(promiseOperationsRejectPromiseCode, rejectPromise, s_promiseOperationsRejectPromiseCodeLength) \
    macro(moduleLoaderObjectRequestFetchCode, requestFetch, s_moduleLoaderObjectRequestFetchCodeLength) \
    macro(moduleLoaderObjectRequestInstantiateCode, requestInstantiate, s_moduleLoaderObjectRequestInstantiateCodeLength) \
    macro(moduleLoaderObjectRequestInstantiateAllCode, requestInstantiateAll, s_moduleLoaderObjectRequestInstantiateAllCodeLength) \
    macro(moduleLoaderObjectRequestLinkCode, requestLink, s_moduleLoaderObjectRequestLinkCodeLength) \
    macro(moduleLoaderObjectRequestReadyCode, requestReady, s_moduleLoaderObjectRequestReadyCodeLength) \
    macro(moduleLoaderObjectRequestResolveDependenciesCode, requestResolveDependencies, s_moduleLoaderObjectRequestResolveDependenciesCodeLength) \
    macro(moduleLoaderObjectRequestTranslateCode, requestTranslate, s_moduleLoaderObjectRequestTranslateCodeLength) \
    macro(promiseConstructorResolveCode, resolve, s_promiseConstructorResolveCodeLength) \
    macro(generatorPrototypeReturnCode, return, s_generatorPrototypeReturnCodeLength) \
    macro(stringPrototypeSearchCode, search, s_stringPrototypeSearchCodeLength) \
    macro(moduleLoaderObjectSetStateToMaxCode, setStateToMax, s_moduleLoaderObjectSetStateToMaxCodeLength) \
    macro(arrayPrototypeSomeCode, some, s_arrayPrototypeSomeCodeLength) \
    macro(typedArrayPrototypeSomeCode, some, s_typedArrayPrototypeSomeCodeLength) \
    macro(arrayPrototypeSortCode, sort, s_arrayPrototypeSortCodeLength) \
    macro(typedArrayPrototypeSortCode, sort, s_typedArrayPrototypeSortCodeLength) \
    macro(globalObjectSpeciesGetterCode, speciesGetter, s_globalObjectSpeciesGetterCodeLength) \
    macro(functionPrototypeSymbolHasInstanceCode, symbolHasInstance, s_functionPrototypeSymbolHasInstanceCodeLength) \
    macro(iteratorPrototypeSymbolIteratorGetterCode, symbolIteratorGetter, s_iteratorPrototypeSymbolIteratorGetterCodeLength) \
    macro(promisePrototypeThenCode, then, s_promisePrototypeThenCodeLength) \
    macro(generatorPrototypeThrowCode, throw, s_generatorPrototypeThrowCodeLength) \
    macro(globalObjectToIntegerCode, toInteger, s_globalObjectToIntegerCodeLength) \
    macro(globalObjectToLengthCode, toLength, s_globalObjectToLengthCodeLength) \
    macro(datePrototypeToLocaleDateStringCode, toLocaleDateString, s_datePrototypeToLocaleDateStringCodeLength) \
    macro(datePrototypeToLocaleStringCode, toLocaleString, s_datePrototypeToLocaleStringCodeLength) \
    macro(numberPrototypeToLocaleStringCode, toLocaleString, s_numberPrototypeToLocaleStringCodeLength) \
    macro(typedArrayPrototypeToLocaleStringCode, toLocaleString, s_typedArrayPrototypeToLocaleStringCodeLength) \
    macro(datePrototypeToLocaleTimeStringCode, toLocaleTimeString, s_datePrototypeToLocaleTimeStringCodeLength) \
    macro(promiseOperationsTriggerPromiseReactionsCode, triggerPromiseReactions, s_promiseOperationsTriggerPromiseReactionsCodeLength) \

#define JSC_FOREACH_BUILTIN_FUNCTION_NAME(macro) \
    macro(all) \
    macro(allocateFloat32Array) \
    macro(allocateFloat64Array) \
    macro(allocateInt16Array) \
    macro(allocateInt32Array) \
    macro(allocateInt8Array) \
    macro(allocateUint16Array) \
    macro(allocateUint32Array) \
    macro(allocateUint8Array) \
    macro(allocateUint8ClampedArray) \
    macro(apply) \
    macro(assign) \
    macro(call) \
    macro(catch) \
    macro(commitInstantiated) \
    macro(copyWithin) \
    macro(createResolvingFunctions) \
    macro(deleteProperty) \
    macro(ensureRegistered) \
    macro(every) \
    macro(fill) \
    macro(filter) \
    macro(find) \
    macro(findIndex) \
    macro(forEach) \
    macro(forceFulfillPromise) \
    macro(from) \
    macro(fulfillFetch) \
    macro(fulfillInstantiate) \
    macro(fulfillPromise) \
    macro(fulfillTranslate) \
    macro(generatorResume) \
    macro(has) \
    macro(includes) \
    macro(initializePromise) \
    macro(instantiation) \
    macro(internalAll) \
    macro(isDictionary) \
    macro(isPromise) \
    macro(link) \
    macro(linkAndEvaluateModule) \
    macro(loadAndEvaluateModule) \
    macro(loadModule) \
    macro(localeCompare) \
    macro(map) \
    macro(moduleEvaluation) \
    macro(newPromiseCapability) \
    macro(newPromiseReaction) \
    macro(newRegistryEntry) \
    macro(next) \
    macro(of) \
    macro(promiseFulfilled) \
    macro(promiseReactionJob) \
    macro(promiseRejected) \
    macro(promiseResolveThenableJob) \
    macro(provide) \
    macro(race) \
    macro(raw) \
    macro(reduce) \
    macro(reduceRight) \
    macro(reject) \
    macro(rejectPromise) \
    macro(requestFetch) \
    macro(requestInstantiate) \
    macro(requestInstantiateAll) \
    macro(requestLink) \
    macro(requestReady) \
    macro(requestResolveDependencies) \
    macro(requestTranslate) \
    macro(resolve) \
    macro(return) \
    macro(search) \
    macro(setStateToMax) \
    macro(some) \
    macro(sort) \
    macro(speciesGetter) \
    macro(symbolHasInstance) \
    macro(symbolIteratorGetter) \
    macro(then) \
    macro(throw) \
    macro(toInteger) \
    macro(toLength) \
    macro(toLocaleDateString) \
    macro(toLocaleString) \
    macro(toLocaleTimeString) \
    macro(triggerPromiseReactions) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

JSC_FOREACH_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

} // namespace JSC

#endif // JSCBuiltins_h
