/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013, 2014 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#ifndef InspectorProtocolObjects_h
#define InspectorProtocolObjects_h

#include <inspector/InspectorProtocolTypes.h>
#include <wtf/Assertions.h>

namespace Inspector {



namespace Protocol {

// Forward declarations.
namespace ApplicationCache {
class ApplicationCache;
class ApplicationCacheResource;
class FrameWithManifest;
} // ApplicationCache

namespace CSS {
class CSSComputedStyleProperty;
class CSSMedia;
class CSSProperty;
class CSSPropertyInfo;
class CSSRule;
class CSSRuleId;
class CSSSelector;
class CSSStyle;
class CSSStyleAttribute;
class CSSStyleId;
class CSSStyleSheetBody;
class CSSStyleSheetHeader;
class InheritedStyleEntry;
class NamedFlow;
class PseudoIdMatches;
class Region;
class RuleMatch;
class SelectorList;
class ShorthandEntry;
class SourceRange;
enum class CSSPropertyStatus;
enum class StyleSheetOrigin;
} // CSS

namespace Console {
class CallFrame;
class ConsoleMessage;
} // Console

namespace DOM {
class AccessibilityProperties;
class EventListener;
class HighlightConfig;
class Node;
class RGBAColor;
enum class LiveRegionRelevant;
enum class PseudoType;
} // DOM

namespace DOMDebugger {
enum class DOMBreakpointType;
} // DOMDebugger

namespace DOMStorage {
class StorageId;
} // DOMStorage

namespace Database {
class Database;
class Error;
} // Database

namespace Debugger {
class AssertPauseReason;
class BreakpointAction;
class BreakpointOptions;
class BreakpointPauseReason;
class CSPViolationPauseReason;
class CallFrame;
class FunctionDetails;
class Location;
class ProbeSample;
class Scope;
} // Debugger

namespace GenericTypes {
class SearchMatch;
} // GenericTypes

namespace Heap {
class GarbageCollection;
} // Heap

#if ENABLE(INDEXED_DATABASE)
namespace IndexedDB {
class DataEntry;
class DatabaseWithObjectStores;
class Key;
class KeyPath;
class KeyRange;
class ObjectStore;
class ObjectStoreIndex;
} // IndexedDB
#endif // ENABLE(INDEXED_DATABASE)

namespace LayerTree {
class CompositingReasons;
class IntRect;
class Layer;
} // LayerTree

namespace Network {
class CachedResource;
class Headers;
class Initiator;
class Request;
class ResourceTiming;
class Response;
class WebSocketFrame;
class WebSocketRequest;
class WebSocketResponse;
} // Network

namespace OverlayTypes {
class ContentFlowData;
class ElementData;
class FragmentHighlightData;
class NodeHighlightData;
class OverlayConfiguration;
class Point;
class Rect;
class Region;
class RegionFlowData;
class ShapeOutsideData;
class Size;
} // OverlayTypes

namespace Page {
class Cookie;
class Frame;
class FrameResource;
class FrameResourceTree;
class SearchResult;
enum class CoordinateSystem;
enum class ResourceType;
} // Page

namespace Runtime {
class BasicBlock;
class CallArgument;
class CollectionEntry;
class EntryPreview;
class ErrorRange;
class ExecutionContextDescription;
class InternalPropertyDescriptor;
class ObjectPreview;
class PropertyDescriptor;
class PropertyPreview;
class RemoteObject;
class StructureDescription;
class TypeDescription;
class TypeLocation;
class TypeSet;
enum class SyntaxErrorType;
} // Runtime

namespace ScriptProfiler {
class Event;
class ExpressionLocation;
class Samples;
class StackFrame;
class StackTrace;
enum class EventType;
} // ScriptProfiler

namespace Timeline {
class CPUProfile;
class CPUProfileNode;
class CPUProfileNodeAggregateCallInfo;
class TimelineEvent;
enum class EventType;
} // Timeline
// End of forward declarations.


// Typedefs.
namespace CSS {
typedef String StyleSheetId;
} // CSS

namespace Console {
/* Call frames for assertions or error messages. */
typedef Inspector::Protocol::Array<Inspector::Protocol::Console::CallFrame> StackTrace;
} // Console

namespace DOM {
/* Unique DOM node identifier. */
typedef int NodeId;
/* Unique DOM node identifier used to reference a node that may not have been pushed to the front-end. */
typedef int BackendNodeId;
/* An array of quad vertices, x immediately followed by y for each point, points clock-wise. */
typedef Inspector::Protocol::Array<double> Quad;
} // DOM

namespace DOMStorage {
/* DOM Storage item. */
typedef Inspector::Protocol::Array<String> Item;
} // DOMStorage

namespace Database {
/* Unique identifier of Database object. */
typedef String DatabaseId;
} // Database

namespace Debugger {
/* Breakpoint identifier. */
typedef String BreakpointId;
/* Breakpoint action identifier. */
typedef int BreakpointActionIdentifier;
/* Unique script identifier. */
typedef String ScriptId;
/* Call frame identifier. */
typedef String CallFrameId;
} // Debugger

namespace LayerTree {
/* Unique RenderLayer identifier. */
typedef String LayerId;
/* Unique PseudoElement identifier. */
typedef String PseudoElementId;
} // LayerTree

namespace Network {
/* Unique loader identifier. */
typedef String LoaderId;
/* Unique frame identifier. */
typedef String FrameId;
/* Unique request identifier. */
typedef String RequestId;
/* Number of seconds since epoch. */
typedef double Timestamp;
} // Network

namespace OverlayTypes {
/* A quad is a collection of 4 points. When initialized from a rect, the points are in clockwise order from top left. */
typedef Inspector::Protocol::Array<Inspector::Protocol::OverlayTypes::Point> Quad;
/* A vector path described using SVG path syntax. */
typedef Inspector::Protocol::Array<Inspector::InspectorValue> DisplayPath;
} // OverlayTypes

namespace Page {
/* Unique script identifier. */
typedef String ScriptIdentifier;
} // Page

namespace Runtime {
/* Unique object identifier. */
typedef String RemoteObjectId;
/* Id of an execution context. */
typedef int ExecutionContextId;
} // Runtime
// End of typedefs.

JS_EXPORT_PRIVATE String getEnumConstantValue(int code);

template<typename T> String getEnumConstantValue(T enumValue)
{
    return getEnumConstantValue(static_cast<int>(enumValue));
}

namespace ApplicationCache {
/* Detailed application cache resource information. */
class ApplicationCacheResource : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        SizeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | SizeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCacheResource*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ApplicationCacheResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setInteger(ASCIILiteral("size"), value);
            return castState<SizeSet>();
        }

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), value);
            return castState<TypeSet>();
        }

        Ref<ApplicationCacheResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCacheResource) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ApplicationCacheResource>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCacheResource> result = ApplicationCacheResource::create()
     *     .setUrl(...)
     *     .setSize(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Detailed application cache information. */
class ApplicationCache : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ManifestURLSet = 1 << 0,
        SizeSet = 1 << 1,
        CreationTimeSet = 1 << 2,
        UpdateTimeSet = 1 << 3,
        ResourcesSet = 1 << 4,
        AllFieldsSet = (ManifestURLSet | SizeSet | CreationTimeSet | UpdateTimeSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ApplicationCache*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ApplicationCache;
    public:

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString(ASCIILiteral("manifestURL"), value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | SizeSet>& setSize(double value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setDouble(ASCIILiteral("size"), value);
            return castState<SizeSet>();
        }

        Builder<STATE | CreationTimeSet>& setCreationTime(double value)
        {
            COMPILE_ASSERT(!(STATE & CreationTimeSet), property_creationTime_already_set);
            m_result->setDouble(ASCIILiteral("creationTime"), value);
            return castState<CreationTimeSet>();
        }

        Builder<STATE | UpdateTimeSet>& setUpdateTime(double value)
        {
            COMPILE_ASSERT(!(STATE & UpdateTimeSet), property_updateTime_already_set);
            m_result->setDouble(ASCIILiteral("updateTime"), value);
            return castState<UpdateTimeSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::ApplicationCache::ApplicationCacheResource>> value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setArray(ASCIILiteral("resources"), value);
            return castState<ResourcesSet>();
        }

        Ref<ApplicationCache> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ApplicationCache) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ApplicationCache>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ApplicationCache> result = ApplicationCache::create()
     *     .setManifestURL(...)
     *     .setSize(...)
     *     .setCreationTime(...)
     *     .setUpdateTime(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Frame identifier - manifest URL pair. */
class FrameWithManifest : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameIdSet = 1 << 0,
        ManifestURLSet = 1 << 1,
        StatusSet = 1 << 2,
        AllFieldsSet = (FrameIdSet | ManifestURLSet | StatusSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameWithManifest*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameWithManifest;
    public:

        Builder<STATE | FrameIdSet>& setFrameId(const Inspector::Protocol::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString(ASCIILiteral("frameId"), value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | ManifestURLSet>& setManifestURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ManifestURLSet), property_manifestURL_already_set);
            m_result->setString(ASCIILiteral("manifestURL"), value);
            return castState<ManifestURLSet>();
        }

        Builder<STATE | StatusSet>& setStatus(int value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setInteger(ASCIILiteral("status"), value);
            return castState<StatusSet>();
        }

        Ref<FrameWithManifest> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameWithManifest) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<FrameWithManifest>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameWithManifest> result = FrameWithManifest::create()
     *     .setFrameId(...)
     *     .setManifestURL(...)
     *     .setStatus(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // ApplicationCache

namespace CSS {
/* This object identifies a CSS style in a unique way. */
class CSSStyleId : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleId*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const Inspector::Protocol::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString(ASCIILiteral("styleSheetId"), value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setInteger(ASCIILiteral("ordinal"), value);
            return castState<OrdinalSet>();
        }

        Ref<CSSStyleId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleId) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSStyleId>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleId> result = CSSStyleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Stylesheet type: "user" for user stylesheets, "user-agent" for user-agent stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via inspector" rules), "regular" for regular stylesheets. */
enum class StyleSheetOrigin {
    User = 0,
    UserAgent = 1,
    Inspector = 2,
    Regular = 3,
}; // enum class StyleSheetOrigin
/* This object identifies a CSS rule in a unique way. */
class CSSRuleId : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        OrdinalSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | OrdinalSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRuleId*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSRuleId;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const Inspector::Protocol::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString(ASCIILiteral("styleSheetId"), value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | OrdinalSet>& setOrdinal(int value)
        {
            COMPILE_ASSERT(!(STATE & OrdinalSet), property_ordinal_already_set);
            m_result->setInteger(ASCIILiteral("ordinal"), value);
            return castState<OrdinalSet>();
        }

        Ref<CSSRuleId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRuleId) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSRuleId>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRuleId> result = CSSRuleId::create()
     *     .setStyleSheetId(...)
     *     .setOrdinal(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS rule collection for a single pseudo style. */
class PseudoIdMatches : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        PseudoIdSet = 1 << 0,
        MatchesSet = 1 << 1,
        AllFieldsSet = (PseudoIdSet | MatchesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PseudoIdMatches*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PseudoIdMatches;
    public:

        Builder<STATE | PseudoIdSet>& setPseudoId(int value)
        {
            COMPILE_ASSERT(!(STATE & PseudoIdSet), property_pseudoId_already_set);
            m_result->setInteger(ASCIILiteral("pseudoId"), value);
            return castState<PseudoIdSet>();
        }

        Builder<STATE | MatchesSet>& setMatches(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::RuleMatch>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchesSet), property_matches_already_set);
            m_result->setArray(ASCIILiteral("matches"), value);
            return castState<MatchesSet>();
        }

        Ref<PseudoIdMatches> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PseudoIdMatches) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<PseudoIdMatches>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PseudoIdMatches> result = PseudoIdMatches::create()
     *     .setPseudoId(...)
     *     .setMatches(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS rule collection for a single pseudo style. */
class InheritedStyleEntry : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MatchedCSSRulesSet = 1 << 0,
        AllFieldsSet = (MatchedCSSRulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InheritedStyleEntry*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class InheritedStyleEntry;
    public:

        Builder<STATE | MatchedCSSRulesSet>& setMatchedCSSRules(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::RuleMatch>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchedCSSRulesSet), property_matchedCSSRules_already_set);
            m_result->setArray(ASCIILiteral("matchedCSSRules"), value);
            return castState<MatchedCSSRulesSet>();
        }

        Ref<InheritedStyleEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InheritedStyleEntry) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<InheritedStyleEntry>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InheritedStyleEntry> result = InheritedStyleEntry::create()
     *     .setMatchedCSSRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setInlineStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("inlineStyle"), WTFMove(value));
    }
};

/* Match data for a CSS rule. */
class RuleMatch : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RuleSet = 1 << 0,
        MatchingSelectorsSet = 1 << 1,
        AllFieldsSet = (RuleSet | MatchingSelectorsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RuleMatch*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RuleMatch;
    public:

        Builder<STATE | RuleSet>& setRule(RefPtr<Inspector::Protocol::CSS::CSSRule> value)
        {
            COMPILE_ASSERT(!(STATE & RuleSet), property_rule_already_set);
            m_result->setObject(ASCIILiteral("rule"), value);
            return castState<RuleSet>();
        }

        Builder<STATE | MatchingSelectorsSet>& setMatchingSelectors(RefPtr<Inspector::Protocol::Array<int>> value)
        {
            COMPILE_ASSERT(!(STATE & MatchingSelectorsSet), property_matchingSelectors_already_set);
            m_result->setArray(ASCIILiteral("matchingSelectors"), value);
            return castState<MatchingSelectorsSet>();
        }

        Ref<RuleMatch> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RuleMatch) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<RuleMatch>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RuleMatch> result = RuleMatch::create()
     *     .setRule(...)
     *     .setMatchingSelectors(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS selector. */
class CSSSelector : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        AllFieldsSet = (TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSSelector*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSSelector;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString(ASCIILiteral("text"), value);
            return castState<TextSet>();
        }

        Ref<CSSSelector> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSSelector) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSSelector>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSSelector> result = CSSSelector::create()
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setSpecificity(RefPtr<Inspector::Protocol::Array<int>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("specificity"), WTFMove(value));
    }

    void setDynamic(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("dynamic"), value);
    }
};

/* Selector list data. */
class SelectorList : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorsSet = 1 << 0,
        TextSet = 1 << 1,
        AllFieldsSet = (SelectorsSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SelectorList*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SelectorList;
    public:

        Builder<STATE | SelectorsSet>& setSelectors(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSSelector>> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorsSet), property_selectors_already_set);
            m_result->setArray(ASCIILiteral("selectors"), value);
            return castState<SelectorsSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString(ASCIILiteral("text"), value);
            return castState<TextSet>();
        }

        Ref<SelectorList> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SelectorList) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<SelectorList>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SelectorList> result = SelectorList::create()
     *     .setSelectors(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("range"), WTFMove(value));
    }
};

/* CSS style information for a DOM style attribute. */
class CSSStyleAttribute : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        StyleSet = 1 << 1,
        AllFieldsSet = (NameSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleAttribute*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleAttribute;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | StyleSet>& setStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setObject(ASCIILiteral("style"), value);
            return castState<StyleSet>();
        }

        Ref<CSSStyleAttribute> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleAttribute) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSStyleAttribute>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleAttribute> result = CSSStyleAttribute::create()
     *     .setName(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS stylesheet metainformation. */
class CSSStyleSheetHeader : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        FrameIdSet = 1 << 1,
        SourceURLSet = 1 << 2,
        OriginSet = 1 << 3,
        TitleSet = 1 << 4,
        DisabledSet = 1 << 5,
        IsInlineSet = 1 << 6,
        StartLineSet = 1 << 7,
        StartColumnSet = 1 << 8,
        AllFieldsSet = (StyleSheetIdSet | FrameIdSet | SourceURLSet | OriginSet | TitleSet | DisabledSet | IsInlineSet | StartLineSet | StartColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetHeader*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleSheetHeader;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const Inspector::Protocol::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString(ASCIILiteral("styleSheetId"), value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const Inspector::Protocol::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString(ASCIILiteral("frameId"), value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | SourceURLSet>& setSourceURL(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceURLSet), property_sourceURL_already_set);
            m_result->setString(ASCIILiteral("sourceURL"), value);
            return castState<SourceURLSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Inspector::Protocol::CSS::StyleSheetOrigin value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString(ASCIILiteral("origin"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<OriginSet>();
        }

        Builder<STATE | TitleSet>& setTitle(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TitleSet), property_title_already_set);
            m_result->setString(ASCIILiteral("title"), value);
            return castState<TitleSet>();
        }

        Builder<STATE | DisabledSet>& setDisabled(bool value)
        {
            COMPILE_ASSERT(!(STATE & DisabledSet), property_disabled_already_set);
            m_result->setBoolean(ASCIILiteral("disabled"), value);
            return castState<DisabledSet>();
        }

        Builder<STATE | IsInlineSet>& setIsInline(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsInlineSet), property_isInline_already_set);
            m_result->setBoolean(ASCIILiteral("isInline"), value);
            return castState<IsInlineSet>();
        }

        Builder<STATE | StartLineSet>& setStartLine(double value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setDouble(ASCIILiteral("startLine"), value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(double value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setDouble(ASCIILiteral("startColumn"), value);
            return castState<StartColumnSet>();
        }

        Ref<CSSStyleSheetHeader> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetHeader) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSStyleSheetHeader>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetHeader> result = CSSStyleSheetHeader::create()
     *     .setStyleSheetId(...)
     *     .setFrameId(...)
     *     .setSourceURL(...)
     *     .setOrigin(...)
     *     .setTitle(...)
     *     .setDisabled(...)
     *     .setIsInline(...)
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS stylesheet contents. */
class CSSStyleSheetBody : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StyleSheetIdSet = 1 << 0,
        RulesSet = 1 << 1,
        AllFieldsSet = (StyleSheetIdSet | RulesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyleSheetBody*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyleSheetBody;
    public:

        Builder<STATE | StyleSheetIdSet>& setStyleSheetId(const Inspector::Protocol::CSS::StyleSheetId& value)
        {
            COMPILE_ASSERT(!(STATE & StyleSheetIdSet), property_styleSheetId_already_set);
            m_result->setString(ASCIILiteral("styleSheetId"), value);
            return castState<StyleSheetIdSet>();
        }

        Builder<STATE | RulesSet>& setRules(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSRule>> value)
        {
            COMPILE_ASSERT(!(STATE & RulesSet), property_rules_already_set);
            m_result->setArray(ASCIILiteral("rules"), value);
            return castState<RulesSet>();
        }

        Ref<CSSStyleSheetBody> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyleSheetBody) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSStyleSheetBody>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyleSheetBody> result = CSSStyleSheetBody::create()
     *     .setStyleSheetId(...)
     *     .setRules(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setText(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("text"), value);
    }
};

/* CSS rule representation. */
class CSSRule : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SelectorListSet = 1 << 0,
        SourceLineSet = 1 << 1,
        OriginSet = 1 << 2,
        StyleSet = 1 << 3,
        AllFieldsSet = (SelectorListSet | SourceLineSet | OriginSet | StyleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSRule*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSRule;
    public:

        Builder<STATE | SelectorListSet>& setSelectorList(RefPtr<Inspector::Protocol::CSS::SelectorList> value)
        {
            COMPILE_ASSERT(!(STATE & SelectorListSet), property_selectorList_already_set);
            m_result->setObject(ASCIILiteral("selectorList"), value);
            return castState<SelectorListSet>();
        }

        Builder<STATE | SourceLineSet>& setSourceLine(int value)
        {
            COMPILE_ASSERT(!(STATE & SourceLineSet), property_sourceLine_already_set);
            m_result->setInteger(ASCIILiteral("sourceLine"), value);
            return castState<SourceLineSet>();
        }

        Builder<STATE | OriginSet>& setOrigin(Inspector::Protocol::CSS::StyleSheetOrigin value)
        {
            COMPILE_ASSERT(!(STATE & OriginSet), property_origin_already_set);
            m_result->setString(ASCIILiteral("origin"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<OriginSet>();
        }

        Builder<STATE | StyleSet>& setStyle(RefPtr<Inspector::Protocol::CSS::CSSStyle> value)
        {
            COMPILE_ASSERT(!(STATE & StyleSet), property_style_already_set);
            m_result->setObject(ASCIILiteral("style"), value);
            return castState<StyleSet>();
        }

        Ref<CSSRule> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSRule) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSRule>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSRule> result = CSSRule::create()
     *     .setSelectorList(...)
     *     .setSourceLine(...)
     *     .setOrigin(...)
     *     .setStyle(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setRuleId(RefPtr<Inspector::Protocol::CSS::CSSRuleId> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("ruleId"), WTFMove(value));
    }

    void setSourceURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("sourceURL"), value);
    }

    void setMedia(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSMedia>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("media"), WTFMove(value));
    }
};

/* Text range within a resource. */
class SourceRange : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartLineSet = 1 << 0,
        StartColumnSet = 1 << 1,
        EndLineSet = 1 << 2,
        EndColumnSet = 1 << 3,
        AllFieldsSet = (StartLineSet | StartColumnSet | EndLineSet | EndColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SourceRange*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SourceRange;
    public:

        Builder<STATE | StartLineSet>& setStartLine(int value)
        {
            COMPILE_ASSERT(!(STATE & StartLineSet), property_startLine_already_set);
            m_result->setInteger(ASCIILiteral("startLine"), value);
            return castState<StartLineSet>();
        }

        Builder<STATE | StartColumnSet>& setStartColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & StartColumnSet), property_startColumn_already_set);
            m_result->setInteger(ASCIILiteral("startColumn"), value);
            return castState<StartColumnSet>();
        }

        Builder<STATE | EndLineSet>& setEndLine(int value)
        {
            COMPILE_ASSERT(!(STATE & EndLineSet), property_endLine_already_set);
            m_result->setInteger(ASCIILiteral("endLine"), value);
            return castState<EndLineSet>();
        }

        Builder<STATE | EndColumnSet>& setEndColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & EndColumnSet), property_endColumn_already_set);
            m_result->setInteger(ASCIILiteral("endColumn"), value);
            return castState<EndColumnSet>();
        }

        Ref<SourceRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SourceRange) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<SourceRange>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SourceRange> result = SourceRange::create()
     *     .setStartLine(...)
     *     .setStartColumn(...)
     *     .setEndLine(...)
     *     .setEndColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class ShorthandEntry : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShorthandEntry*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ShorthandEntry;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<ShorthandEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShorthandEntry) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ShorthandEntry>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShorthandEntry> result = ShorthandEntry::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class CSSPropertyInfo : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSPropertyInfo*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSPropertyInfo;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Ref<CSSPropertyInfo> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSPropertyInfo) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSPropertyInfo>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSPropertyInfo> result = CSSPropertyInfo::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setLonghands(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("longhands"), WTFMove(value));
    }

    void setValues(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("values"), WTFMove(value));
    }
};

class CSSComputedStyleProperty : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSComputedStyleProperty*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSComputedStyleProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<CSSComputedStyleProperty> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSComputedStyleProperty) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSComputedStyleProperty>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSComputedStyleProperty> result = CSSComputedStyleProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CSS style representation. */
class CSSStyle : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CssPropertiesSet = 1 << 0,
        ShorthandEntriesSet = 1 << 1,
        AllFieldsSet = (CssPropertiesSet | ShorthandEntriesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSStyle*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSStyle;
    public:

        Builder<STATE | CssPropertiesSet>& setCssProperties(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::CSSProperty>> value)
        {
            COMPILE_ASSERT(!(STATE & CssPropertiesSet), property_cssProperties_already_set);
            m_result->setArray(ASCIILiteral("cssProperties"), value);
            return castState<CssPropertiesSet>();
        }

        Builder<STATE | ShorthandEntriesSet>& setShorthandEntries(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::ShorthandEntry>> value)
        {
            COMPILE_ASSERT(!(STATE & ShorthandEntriesSet), property_shorthandEntries_already_set);
            m_result->setArray(ASCIILiteral("shorthandEntries"), value);
            return castState<ShorthandEntriesSet>();
        }

        Ref<CSSStyle> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSStyle) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSStyle>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSStyle> result = CSSStyle::create()
     *     .setCssProperties(...)
     *     .setShorthandEntries(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setStyleId(RefPtr<Inspector::Protocol::CSS::CSSStyleId> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("styleId"), WTFMove(value));
    }

    void setCssText(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("cssText"), value);
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("range"), WTFMove(value));
    }

    void setWidth(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("width"), value);
    }

    void setHeight(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("height"), value);
    }
};

/* The property status: "active" if the property is effective in the style, "inactive" if the property is overridden by a same-named property in this style later on, "disabled" if the property is disabled by the user, "style" (implied if absent) if the property is reported by the browser rather than by the CSS source parser. */
enum class CSSPropertyStatus {
    Active = 4,
    Inactive = 5,
    Disabled = 6,
    Style = 7,
}; // enum class CSSPropertyStatus
/* CSS style effective visual dimensions and source offsets. */
class CSSProperty : public Inspector::InspectorObject {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        AllFieldsSet = (NameSet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSProperty*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSProperty;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<CSSProperty> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSProperty) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSProperty>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSProperty> result = CSSProperty::create()
     *     .setName(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setPriority(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("priority"), value);
    }

    void setImplicit(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("implicit"), value);
    }

    void setText(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("text"), value);
    }

    void setParsedOk(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("parsedOk"), value);
    }

    void setStatus(Inspector::Protocol::CSS::CSSPropertyStatus value)
    {
        InspectorObjectBase::setString(ASCIILiteral("status"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setRange(RefPtr<Inspector::Protocol::CSS::SourceRange> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("range"), WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* Name;
    JS_EXPORT_PRIVATE static const char* Value;
    JS_EXPORT_PRIVATE static const char* Priority;
    JS_EXPORT_PRIVATE static const char* Implicit;
    JS_EXPORT_PRIVATE static const char* Text;
    JS_EXPORT_PRIVATE static const char* ParsedOk;
    JS_EXPORT_PRIVATE static const char* Status;
    JS_EXPORT_PRIVATE static const char* Range;
};

/* CSS media query descriptor. */
class CSSMedia : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'source' while generating CSSMedia.
    enum class Source {
        MediaRule = 8,
        ImportRule = 9,
        LinkedSheet = 10,
        InlineSheet = 11,
    }; // enum class Source
    enum {
        NoFieldsSet = 0,
        TextSet = 1 << 0,
        SourceSet = 1 << 1,
        AllFieldsSet = (TextSet | SourceSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSSMedia*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSSMedia;
    public:

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString(ASCIILiteral("text"), value);
            return castState<TextSet>();
        }

        Builder<STATE | SourceSet>& setSource(Source value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString(ASCIILiteral("source"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<SourceSet>();
        }

        Ref<CSSMedia> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSSMedia) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSSMedia>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSSMedia> result = CSSMedia::create()
     *     .setText(...)
     *     .setSource(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setSourceURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("sourceURL"), value);
    }

    void setSourceLine(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("sourceLine"), value);
    }
};

/* This object represents a region that flows from a Named Flow. */
class Region : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'regionOverset' while generating Region.
    enum class RegionOverset {
        Overset = 12,
        Fit = 13,
        Empty = 14,
    }; // enum class RegionOverset
    enum {
        NoFieldsSet = 0,
        RegionOversetSet = 1 << 0,
        NodeIdSet = 1 << 1,
        AllFieldsSet = (RegionOversetSet | NodeIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Region*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Region;
    public:

        Builder<STATE | RegionOversetSet>& setRegionOverset(RegionOverset value)
        {
            COMPILE_ASSERT(!(STATE & RegionOversetSet), property_regionOverset_already_set);
            m_result->setString(ASCIILiteral("regionOverset"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<RegionOversetSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger(ASCIILiteral("nodeId"), value);
            return castState<NodeIdSet>();
        }

        Ref<Region> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Region) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Region>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Region> result = Region::create()
     *     .setRegionOverset(...)
     *     .setNodeId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* This object represents a Named Flow. */
class NamedFlow : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DocumentNodeIdSet = 1 << 0,
        NameSet = 1 << 1,
        OversetSet = 1 << 2,
        ContentSet = 1 << 3,
        RegionsSet = 1 << 4,
        AllFieldsSet = (DocumentNodeIdSet | NameSet | OversetSet | ContentSet | RegionsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*NamedFlow*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class NamedFlow;
    public:

        Builder<STATE | DocumentNodeIdSet>& setDocumentNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & DocumentNodeIdSet), property_documentNodeId_already_set);
            m_result->setInteger(ASCIILiteral("documentNodeId"), value);
            return castState<DocumentNodeIdSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | OversetSet>& setOverset(bool value)
        {
            COMPILE_ASSERT(!(STATE & OversetSet), property_overset_already_set);
            m_result->setBoolean(ASCIILiteral("overset"), value);
            return castState<OversetSet>();
        }

        Builder<STATE | ContentSet>& setContent(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
        {
            COMPILE_ASSERT(!(STATE & ContentSet), property_content_already_set);
            m_result->setArray(ASCIILiteral("content"), value);
            return castState<ContentSet>();
        }

        Builder<STATE | RegionsSet>& setRegions(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::CSS::Region>> value)
        {
            COMPILE_ASSERT(!(STATE & RegionsSet), property_regions_already_set);
            m_result->setArray(ASCIILiteral("regions"), value);
            return castState<RegionsSet>();
        }

        Ref<NamedFlow> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(NamedFlow) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<NamedFlow>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<NamedFlow> result = NamedFlow::create()
     *     .setDocumentNodeId(...)
     *     .setName(...)
     *     .setOverset(...)
     *     .setContent(...)
     *     .setRegions(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // CSS

namespace Console {
/* Console message. */
class ConsoleMessage : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'source' while generating ConsoleMessage.
    enum class Source {
        XML = 15,
        Javascript = 16,
        Network = 17,
        ConsoleAPI = 18,
        Storage = 19,
        Appcache = 20,
        Rendering = 21,
        CSS = 22,
        Security = 23,
        ContentBlocker = 24,
        Other = 25,
    }; // enum class Source
    // Named after property name 'level' while generating ConsoleMessage.
    enum class Level {
        Log = 26,
        Info = 27,
        Warning = 28,
        Error = 29,
        Debug = 30,
    }; // enum class Level
    // Named after property name 'type' while generating ConsoleMessage.
    enum class Type {
        Log = 26,
        Dir = 31,
        DirXML = 32,
        Table = 33,
        Trace = 34,
        Clear = 35,
        StartGroup = 36,
        StartGroupCollapsed = 37,
        EndGroup = 38,
        Assert = 39,
        Timing = 40,
        Profile = 41,
        ProfileEnd = 42,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        SourceSet = 1 << 0,
        LevelSet = 1 << 1,
        TextSet = 1 << 2,
        AllFieldsSet = (SourceSet | LevelSet | TextSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ConsoleMessage*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ConsoleMessage;
    public:

        Builder<STATE | SourceSet>& setSource(Source value)
        {
            COMPILE_ASSERT(!(STATE & SourceSet), property_source_already_set);
            m_result->setString(ASCIILiteral("source"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<SourceSet>();
        }

        Builder<STATE | LevelSet>& setLevel(Level value)
        {
            COMPILE_ASSERT(!(STATE & LevelSet), property_level_already_set);
            m_result->setString(ASCIILiteral("level"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<LevelSet>();
        }

        Builder<STATE | TextSet>& setText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TextSet), property_text_already_set);
            m_result->setString(ASCIILiteral("text"), value);
            return castState<TextSet>();
        }

        Ref<ConsoleMessage> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ConsoleMessage) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ConsoleMessage>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ConsoleMessage> result = ConsoleMessage::create()
     *     .setSource(...)
     *     .setLevel(...)
     *     .setText(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setType(Type value)
    {
        InspectorObjectBase::setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setUrl(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("url"), value);
    }

    void setLine(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("line"), value);
    }

    void setColumn(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("column"), value);
    }

    void setRepeatCount(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("repeatCount"), value);
    }

    void setParameters(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::RemoteObject>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("parameters"), WTFMove(value));
    }

    void setStackTrace(RefPtr<Inspector::Protocol::Console::StackTrace> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("stackTrace"), WTFMove(value));
    }

    void setNetworkRequestId(const Inspector::Protocol::Network::RequestId& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("networkRequestId"), value);
    }
};

/* Stack entry for console errors and assertions. */
class CallFrame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FunctionNameSet = 1 << 0,
        UrlSet = 1 << 1,
        LineNumberSet = 1 << 2,
        ColumnNumberSet = 1 << 3,
        AllFieldsSet = (FunctionNameSet | UrlSet | LineNumberSet | ColumnNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallFrame;
    public:

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString(ASCIILiteral("functionName"), value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setInteger(ASCIILiteral("lineNumber"), value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | ColumnNumberSet>& setColumnNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnNumberSet), property_columnNumber_already_set);
            m_result->setInteger(ASCIILiteral("columnNumber"), value);
            return castState<ColumnNumberSet>();
        }

        Ref<CallFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setFunctionName(...)
     *     .setUrl(...)
     *     .setLineNumber(...)
     *     .setColumnNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Console

namespace DOM {
/* Pseudo element type. */
enum class PseudoType {
    Before = 43,
    After = 44,
}; // enum class PseudoType
/* Token values of @aria-relevant attribute. */
enum class LiveRegionRelevant {
    Additions = 45,
    Removals = 46,
    Text = 47,
}; // enum class LiveRegionRelevant
/* DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes. DOMNode is a base node mirror type. */
class Node : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NodeIdSet = 1 << 0,
        NodeTypeSet = 1 << 1,
        NodeNameSet = 1 << 2,
        LocalNameSet = 1 << 3,
        NodeValueSet = 1 << 4,
        AllFieldsSet = (NodeIdSet | NodeTypeSet | NodeNameSet | LocalNameSet | NodeValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Node*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Node;
    public:

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger(ASCIILiteral("nodeId"), value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | NodeTypeSet>& setNodeType(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeTypeSet), property_nodeType_already_set);
            m_result->setInteger(ASCIILiteral("nodeType"), value);
            return castState<NodeTypeSet>();
        }

        Builder<STATE | NodeNameSet>& setNodeName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeNameSet), property_nodeName_already_set);
            m_result->setString(ASCIILiteral("nodeName"), value);
            return castState<NodeNameSet>();
        }

        Builder<STATE | LocalNameSet>& setLocalName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LocalNameSet), property_localName_already_set);
            m_result->setString(ASCIILiteral("localName"), value);
            return castState<LocalNameSet>();
        }

        Builder<STATE | NodeValueSet>& setNodeValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NodeValueSet), property_nodeValue_already_set);
            m_result->setString(ASCIILiteral("nodeValue"), value);
            return castState<NodeValueSet>();
        }

        Ref<Node> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Node) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Node>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Node> result = Node::create()
     *     .setNodeId(...)
     *     .setNodeType(...)
     *     .setNodeName(...)
     *     .setLocalName(...)
     *     .setNodeValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setChildNodeCount(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("childNodeCount"), value);
    }

    void setChildren(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::Node>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("children"), WTFMove(value));
    }

    void setAttributes(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("attributes"), WTFMove(value));
    }

    void setDocumentURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("documentURL"), value);
    }

    void setBaseURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("baseURL"), value);
    }

    void setPublicId(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("publicId"), value);
    }

    void setSystemId(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("systemId"), value);
    }

    void setInternalSubset(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("internalSubset"), value);
    }

    void setXmlVersion(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("xmlVersion"), value);
    }

    void setName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("name"), value);
    }

    void setValue(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("value"), value);
    }

    void setPseudoType(Inspector::Protocol::DOM::PseudoType value)
    {
        InspectorObjectBase::setString(ASCIILiteral("pseudoType"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setFrameId(const Inspector::Protocol::Network::FrameId& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("frameId"), value);
    }

    void setContentDocument(RefPtr<Inspector::Protocol::DOM::Node> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("contentDocument"), WTFMove(value));
    }

    void setShadowRoots(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::Node>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("shadowRoots"), WTFMove(value));
    }

    void setTemplateContent(RefPtr<Inspector::Protocol::DOM::Node> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("templateContent"), WTFMove(value));
    }

    void setPseudoElements(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::Node>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("pseudoElements"), WTFMove(value));
    }

    void setRole(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("role"), value);
    }
};

/* A structure holding event listener properties. */
class EventListener : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        UseCaptureSet = 1 << 1,
        IsAttributeSet = 1 << 2,
        NodeIdSet = 1 << 3,
        HandlerBodySet = 1 << 4,
        AllFieldsSet = (TypeSet | UseCaptureSet | IsAttributeSet | NodeIdSet | HandlerBodySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EventListener*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class EventListener;
    public:

        Builder<STATE | TypeSet>& setType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), value);
            return castState<TypeSet>();
        }

        Builder<STATE | UseCaptureSet>& setUseCapture(bool value)
        {
            COMPILE_ASSERT(!(STATE & UseCaptureSet), property_useCapture_already_set);
            m_result->setBoolean(ASCIILiteral("useCapture"), value);
            return castState<UseCaptureSet>();
        }

        Builder<STATE | IsAttributeSet>& setIsAttribute(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsAttributeSet), property_isAttribute_already_set);
            m_result->setBoolean(ASCIILiteral("isAttribute"), value);
            return castState<IsAttributeSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger(ASCIILiteral("nodeId"), value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | HandlerBodySet>& setHandlerBody(const String& value)
        {
            COMPILE_ASSERT(!(STATE & HandlerBodySet), property_handlerBody_already_set);
            m_result->setString(ASCIILiteral("handlerBody"), value);
            return castState<HandlerBodySet>();
        }

        Ref<EventListener> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EventListener) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<EventListener>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EventListener> result = EventListener::create()
     *     .setType(...)
     *     .setUseCapture(...)
     *     .setIsAttribute(...)
     *     .setNodeId(...)
     *     .setHandlerBody(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("location"), WTFMove(value));
    }

    void setSourceName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("sourceName"), value);
    }

    void setHandler(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("handler"), WTFMove(value));
    }
};

/* A structure holding accessibility properties. */
class AccessibilityProperties : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'checked' while generating AccessibilityProperties.
    enum class Checked {
        True = 48,
        False = 49,
        Mixed = 50,
    }; // enum class Checked
    // Named after property name 'current' while generating AccessibilityProperties.
    enum class Current {
        True = 48,
        False = 49,
        Page = 51,
        Step = 52,
        Location = 53,
        Date = 54,
        Time = 55,
    }; // enum class Current
    // Named after property name 'invalid' while generating AccessibilityProperties.
    enum class Invalid {
        True = 48,
        False = 49,
        Grammar = 56,
        Spelling = 57,
    }; // enum class Invalid
    // Named after property name 'liveRegionStatus' while generating AccessibilityProperties.
    enum class LiveRegionStatus {
        Assertive = 58,
        Polite = 59,
        Off = 60,
    }; // enum class LiveRegionStatus
    enum {
        NoFieldsSet = 0,
        ExistsSet = 1 << 0,
        LabelSet = 1 << 1,
        NodeIdSet = 1 << 2,
        RoleSet = 1 << 3,
        AllFieldsSet = (ExistsSet | LabelSet | NodeIdSet | RoleSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AccessibilityProperties*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class AccessibilityProperties;
    public:

        Builder<STATE | ExistsSet>& setExists(bool value)
        {
            COMPILE_ASSERT(!(STATE & ExistsSet), property_exists_already_set);
            m_result->setBoolean(ASCIILiteral("exists"), value);
            return castState<ExistsSet>();
        }

        Builder<STATE | LabelSet>& setLabel(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LabelSet), property_label_already_set);
            m_result->setString(ASCIILiteral("label"), value);
            return castState<LabelSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger(ASCIILiteral("nodeId"), value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | RoleSet>& setRole(const String& value)
        {
            COMPILE_ASSERT(!(STATE & RoleSet), property_role_already_set);
            m_result->setString(ASCIILiteral("role"), value);
            return castState<RoleSet>();
        }

        Ref<AccessibilityProperties> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(AccessibilityProperties) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<AccessibilityProperties>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AccessibilityProperties> result = AccessibilityProperties::create()
     *     .setExists(...)
     *     .setLabel(...)
     *     .setNodeId(...)
     *     .setRole(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setActiveDescendantNodeId(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("activeDescendantNodeId"), value);
    }

    void setBusy(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("busy"), value);
    }

    void setChecked(Checked value)
    {
        InspectorObjectBase::setString(ASCIILiteral("checked"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setChildNodeIds(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("childNodeIds"), WTFMove(value));
    }

    void setControlledNodeIds(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("controlledNodeIds"), WTFMove(value));
    }

    void setCurrent(Current value)
    {
        InspectorObjectBase::setString(ASCIILiteral("current"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setDisabled(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("disabled"), value);
    }

    void setExpanded(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("expanded"), value);
    }

    void setFlowedNodeIds(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("flowedNodeIds"), WTFMove(value));
    }

    void setFocused(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("focused"), value);
    }

    void setIgnored(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("ignored"), value);
    }

    void setIgnoredByDefault(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("ignoredByDefault"), value);
    }

    void setInvalid(Invalid value)
    {
        InspectorObjectBase::setString(ASCIILiteral("invalid"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setHidden(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("hidden"), value);
    }

    void setLiveRegionAtomic(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("liveRegionAtomic"), value);
    }

    void setLiveRegionRelevant(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("liveRegionRelevant"), WTFMove(value));
    }

    void setLiveRegionStatus(LiveRegionStatus value)
    {
        InspectorObjectBase::setString(ASCIILiteral("liveRegionStatus"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setMouseEventNodeId(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("mouseEventNodeId"), value);
    }

    void setOwnedNodeIds(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("ownedNodeIds"), WTFMove(value));
    }

    void setParentNodeId(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("parentNodeId"), value);
    }

    void setPressed(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("pressed"), value);
    }

    void setReadonly(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("readonly"), value);
    }

    void setRequired(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("required"), value);
    }

    void setSelected(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("selected"), value);
    }

    void setSelectedChildNodeIds(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::DOM::NodeId>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("selectedChildNodeIds"), WTFMove(value));
    }
};

/* A structure holding an RGBA color. */
class RGBAColor : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RSet = 1 << 0,
        GSet = 1 << 1,
        BSet = 1 << 2,
        AllFieldsSet = (RSet | GSet | BSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RGBAColor*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RGBAColor;
    public:

        Builder<STATE | RSet>& setR(int value)
        {
            COMPILE_ASSERT(!(STATE & RSet), property_r_already_set);
            m_result->setInteger(ASCIILiteral("r"), value);
            return castState<RSet>();
        }

        Builder<STATE | GSet>& setG(int value)
        {
            COMPILE_ASSERT(!(STATE & GSet), property_g_already_set);
            m_result->setInteger(ASCIILiteral("g"), value);
            return castState<GSet>();
        }

        Builder<STATE | BSet>& setB(int value)
        {
            COMPILE_ASSERT(!(STATE & BSet), property_b_already_set);
            m_result->setInteger(ASCIILiteral("b"), value);
            return castState<BSet>();
        }

        Ref<RGBAColor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RGBAColor) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<RGBAColor>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RGBAColor> result = RGBAColor::create()
     *     .setR(...)
     *     .setG(...)
     *     .setB(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setA(double value)
    {
        InspectorObjectBase::setDouble(ASCIILiteral("a"), value);
    }
};

/* Configuration data for the highlighting of page elements. */
class HighlightConfig : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*HighlightConfig*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class HighlightConfig;
    public:

        Ref<HighlightConfig> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(HighlightConfig) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<HighlightConfig>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<HighlightConfig> result = HighlightConfig::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setShowInfo(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("showInfo"), value);
    }

    void setContentColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("contentColor"), WTFMove(value));
    }

    void setPaddingColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("paddingColor"), WTFMove(value));
    }

    void setBorderColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("borderColor"), WTFMove(value));
    }

    void setMarginColor(RefPtr<Inspector::Protocol::DOM::RGBAColor> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("marginColor"), WTFMove(value));
    }
};

} // DOM

namespace DOMDebugger {
/* DOM breakpoint type. */
enum class DOMBreakpointType {
    SubtreeModified = 61,
    AttributeModified = 62,
    NodeRemoved = 63,
}; // enum class DOMBreakpointType
} // DOMDebugger

namespace DOMStorage {
/* DOM Storage identifier. */
class StorageId : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SecurityOriginSet = 1 << 0,
        IsLocalStorageSet = 1 << 1,
        AllFieldsSet = (SecurityOriginSet | IsLocalStorageSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StorageId*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StorageId;
    public:

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString(ASCIILiteral("securityOrigin"), value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | IsLocalStorageSet>& setIsLocalStorage(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsLocalStorageSet), property_isLocalStorage_already_set);
            m_result->setBoolean(ASCIILiteral("isLocalStorage"), value);
            return castState<IsLocalStorageSet>();
        }

        Ref<StorageId> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StorageId) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<StorageId>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StorageId> result = StorageId::create()
     *     .setSecurityOrigin(...)
     *     .setIsLocalStorage(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // DOMStorage

namespace Database {
/* Database object. */
class Database : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        DomainSet = 1 << 1,
        NameSet = 1 << 2,
        VersionSet = 1 << 3,
        AllFieldsSet = (IdSet | DomainSet | NameSet | VersionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Database*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Database;
    public:

        Builder<STATE | IdSet>& setId(const Inspector::Protocol::Database::DatabaseId& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString(ASCIILiteral("id"), value);
            return castState<IdSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString(ASCIILiteral("domain"), value);
            return castState<DomainSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(const String& value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setString(ASCIILiteral("version"), value);
            return castState<VersionSet>();
        }

        Ref<Database> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Database) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Database>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Database> result = Database::create()
     *     .setId(...)
     *     .setDomain(...)
     *     .setName(...)
     *     .setVersion(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Database error. */
class Error : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        MessageSet = 1 << 0,
        CodeSet = 1 << 1,
        AllFieldsSet = (MessageSet | CodeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Error*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Error;
    public:

        Builder<STATE | MessageSet>& setMessage(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MessageSet), property_message_already_set);
            m_result->setString(ASCIILiteral("message"), value);
            return castState<MessageSet>();
        }

        Builder<STATE | CodeSet>& setCode(int value)
        {
            COMPILE_ASSERT(!(STATE & CodeSet), property_code_already_set);
            m_result->setInteger(ASCIILiteral("code"), value);
            return castState<CodeSet>();
        }

        Ref<Error> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Error) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Error>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Error> result = Error::create()
     *     .setMessage(...)
     *     .setCode(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Database

namespace Debugger {
/* Location in the source code. */
class Location : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScriptIdSet = 1 << 0,
        LineNumberSet = 1 << 1,
        AllFieldsSet = (ScriptIdSet | LineNumberSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Location*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Location;
    public:

        Builder<STATE | ScriptIdSet>& setScriptId(const Inspector::Protocol::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & ScriptIdSet), property_scriptId_already_set);
            m_result->setString(ASCIILiteral("scriptId"), value);
            return castState<ScriptIdSet>();
        }

        Builder<STATE | LineNumberSet>& setLineNumber(int value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setInteger(ASCIILiteral("lineNumber"), value);
            return castState<LineNumberSet>();
        }

        Ref<Location> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Location) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Location>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Location> result = Location::create()
     *     .setScriptId(...)
     *     .setLineNumber(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setColumnNumber(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("columnNumber"), value);
    }
};

/* Action to perform when a breakpoint is triggered. */
class BreakpointAction : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating BreakpointAction.
    enum class Type {
        Log = 26,
        Evaluate = 64,
        Sound = 65,
        Probe = 66,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointAction*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointAction;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<BreakpointAction> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointAction) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<BreakpointAction>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointAction> result = BreakpointAction::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setData(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("data"), value);
    }

    void setId(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("id"), value);
    }
};

/* Extra options that modify breakpoint behavior. */
class BreakpointOptions : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointOptions*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointOptions;
    public:

        Ref<BreakpointOptions> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointOptions) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<BreakpointOptions>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointOptions> result = BreakpointOptions::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setCondition(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("condition"), value);
    }

    void setActions(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Debugger::BreakpointAction>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("actions"), WTFMove(value));
    }

    void setAutoContinue(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("autoContinue"), value);
    }

    void setIgnoreCount(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("ignoreCount"), value);
    }
};

/* Information about the function. */
class FunctionDetails : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LocationSet = 1 << 0,
        AllFieldsSet = (LocationSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FunctionDetails*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FunctionDetails;
    public:

        Builder<STATE | LocationSet>& setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setObject(ASCIILiteral("location"), value);
            return castState<LocationSet>();
        }

        Ref<FunctionDetails> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FunctionDetails) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<FunctionDetails>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FunctionDetails> result = FunctionDetails::create()
     *     .setLocation(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("name"), value);
    }

    void setDisplayName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("displayName"), value);
    }

    void setInferredName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("inferredName"), value);
    }

    void setScopeChain(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Debugger::Scope>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("scopeChain"), WTFMove(value));
    }
};

/* JavaScript call frame. Array of call frames form the call stack. */
class CallFrame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallFrameIdSet = 1 << 0,
        FunctionNameSet = 1 << 1,
        LocationSet = 1 << 2,
        ScopeChainSet = 1 << 3,
        ThisSet = 1 << 4,
        AllFieldsSet = (CallFrameIdSet | FunctionNameSet | LocationSet | ScopeChainSet | ThisSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallFrame*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallFrame;
    public:

        Builder<STATE | CallFrameIdSet>& setCallFrameId(const Inspector::Protocol::Debugger::CallFrameId& value)
        {
            COMPILE_ASSERT(!(STATE & CallFrameIdSet), property_callFrameId_already_set);
            m_result->setString(ASCIILiteral("callFrameId"), value);
            return castState<CallFrameIdSet>();
        }

        Builder<STATE | FunctionNameSet>& setFunctionName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & FunctionNameSet), property_functionName_already_set);
            m_result->setString(ASCIILiteral("functionName"), value);
            return castState<FunctionNameSet>();
        }

        Builder<STATE | LocationSet>& setLocation(RefPtr<Inspector::Protocol::Debugger::Location> value)
        {
            COMPILE_ASSERT(!(STATE & LocationSet), property_location_already_set);
            m_result->setObject(ASCIILiteral("location"), value);
            return castState<LocationSet>();
        }

        Builder<STATE | ScopeChainSet>& setScopeChain(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Debugger::Scope>> value)
        {
            COMPILE_ASSERT(!(STATE & ScopeChainSet), property_scopeChain_already_set);
            m_result->setArray(ASCIILiteral("scopeChain"), value);
            return castState<ScopeChainSet>();
        }

        Builder<STATE | ThisSet>& setThis(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ThisSet), property_this_already_set);
            m_result->setObject(ASCIILiteral("this"), value);
            return castState<ThisSet>();
        }

        Ref<CallFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallFrame) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CallFrame>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallFrame> result = CallFrame::create()
     *     .setCallFrameId(...)
     *     .setFunctionName(...)
     *     .setLocation(...)
     *     .setScopeChain(...)
     *     .setThis(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Scope description. */
class Scope : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating Scope.
    enum class Type {
        Global = 67,
        With = 68,
        Closure = 69,
        Catch = 70,
        FunctionName = 71,
        GlobalLexicalEnvironment = 72,
        NestedLexical = 73,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        ObjectSet = 1 << 1,
        AllFieldsSet = (TypeSet | ObjectSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Scope*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Scope;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | ObjectSet>& setObject(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectSet), property_object_already_set);
            m_result->setObject(ASCIILiteral("object"), value);
            return castState<ObjectSet>();
        }

        Ref<Scope> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Scope) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Scope>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Scope> result = Scope::create()
     *     .setType(...)
     *     .setObject(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* A sample collected by evaluating a probe breakpoint action. */
class ProbeSample : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ProbeIdSet = 1 << 0,
        SampleIdSet = 1 << 1,
        BatchIdSet = 1 << 2,
        TimestampSet = 1 << 3,
        PayloadSet = 1 << 4,
        AllFieldsSet = (ProbeIdSet | SampleIdSet | BatchIdSet | TimestampSet | PayloadSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ProbeSample*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ProbeSample;
    public:

        Builder<STATE | ProbeIdSet>& setProbeId(int value)
        {
            COMPILE_ASSERT(!(STATE & ProbeIdSet), property_probeId_already_set);
            m_result->setInteger(ASCIILiteral("probeId"), value);
            return castState<ProbeIdSet>();
        }

        Builder<STATE | SampleIdSet>& setSampleId(int value)
        {
            COMPILE_ASSERT(!(STATE & SampleIdSet), property_sampleId_already_set);
            m_result->setInteger(ASCIILiteral("sampleId"), value);
            return castState<SampleIdSet>();
        }

        Builder<STATE | BatchIdSet>& setBatchId(int value)
        {
            COMPILE_ASSERT(!(STATE & BatchIdSet), property_batchId_already_set);
            m_result->setInteger(ASCIILiteral("batchId"), value);
            return castState<BatchIdSet>();
        }

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble(ASCIILiteral("timestamp"), value);
            return castState<TimestampSet>();
        }

        Builder<STATE | PayloadSet>& setPayload(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PayloadSet), property_payload_already_set);
            m_result->setObject(ASCIILiteral("payload"), value);
            return castState<PayloadSet>();
        }

        Ref<ProbeSample> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ProbeSample) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ProbeSample>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ProbeSample> result = ProbeSample::create()
     *     .setProbeId(...)
     *     .setSampleId(...)
     *     .setBatchId(...)
     *     .setTimestamp(...)
     *     .setPayload(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* The pause reason auxiliary data when paused because of an assertion. */
class AssertPauseReason : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*AssertPauseReason*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class AssertPauseReason;
    public:

        Ref<AssertPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(AssertPauseReason) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<AssertPauseReason>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<AssertPauseReason> result = AssertPauseReason::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setMessage(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("message"), value);
    }
};

/* The pause reason auxiliary data when paused because of hitting a breakpoint. */
class BreakpointPauseReason : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BreakpointIdSet = 1 << 0,
        AllFieldsSet = (BreakpointIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BreakpointPauseReason*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BreakpointPauseReason;
    public:

        Builder<STATE | BreakpointIdSet>& setBreakpointId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & BreakpointIdSet), property_breakpointId_already_set);
            m_result->setString(ASCIILiteral("breakpointId"), value);
            return castState<BreakpointIdSet>();
        }

        Ref<BreakpointPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BreakpointPauseReason) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<BreakpointPauseReason>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BreakpointPauseReason> result = BreakpointPauseReason::create()
     *     .setBreakpointId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* The pause reason auxiliary data when paused because of a Content Security Policy directive. */
class CSPViolationPauseReason : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DirectiveSet = 1 << 0,
        AllFieldsSet = (DirectiveSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CSPViolationPauseReason*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CSPViolationPauseReason;
    public:

        Builder<STATE | DirectiveSet>& setDirective(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DirectiveSet), property_directive_already_set);
            m_result->setString(ASCIILiteral("directive"), value);
            return castState<DirectiveSet>();
        }

        Ref<CSPViolationPauseReason> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CSPViolationPauseReason) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CSPViolationPauseReason>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CSPViolationPauseReason> result = CSPViolationPauseReason::create()
     *     .setDirective(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Debugger

namespace GenericTypes {
/* Search match in a resource. */
class SearchMatch : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineNumberSet = 1 << 0,
        LineContentSet = 1 << 1,
        AllFieldsSet = (LineNumberSet | LineContentSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchMatch*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SearchMatch;
    public:

        Builder<STATE | LineNumberSet>& setLineNumber(double value)
        {
            COMPILE_ASSERT(!(STATE & LineNumberSet), property_lineNumber_already_set);
            m_result->setDouble(ASCIILiteral("lineNumber"), value);
            return castState<LineNumberSet>();
        }

        Builder<STATE | LineContentSet>& setLineContent(const String& value)
        {
            COMPILE_ASSERT(!(STATE & LineContentSet), property_lineContent_already_set);
            m_result->setString(ASCIILiteral("lineContent"), value);
            return castState<LineContentSet>();
        }

        Ref<SearchMatch> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchMatch) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<SearchMatch>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchMatch> result = SearchMatch::create()
     *     .setLineNumber(...)
     *     .setLineContent(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // GenericTypes

namespace Heap {
/* Information about a garbage collection. */
class GarbageCollection : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating GarbageCollection.
    enum class Type {
        Full = 74,
        Partial = 75,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        StartTimeSet = 1 << 1,
        EndTimeSet = 1 << 2,
        AllFieldsSet = (TypeSet | StartTimeSet | EndTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*GarbageCollection*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class GarbageCollection;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble(ASCIILiteral("startTime"), value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setDouble(ASCIILiteral("endTime"), value);
            return castState<EndTimeSet>();
        }

        Ref<GarbageCollection> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(GarbageCollection) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<GarbageCollection>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<GarbageCollection> result = GarbageCollection::create()
     *     .setType(...)
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Heap

#if ENABLE(INDEXED_DATABASE)
namespace IndexedDB {
/* Database with an array of object stores. */
class DatabaseWithObjectStores : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        VersionSet = 1 << 1,
        ObjectStoresSet = 1 << 2,
        AllFieldsSet = (NameSet | VersionSet | ObjectStoresSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DatabaseWithObjectStores*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class DatabaseWithObjectStores;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | VersionSet>& setVersion(double value)
        {
            COMPILE_ASSERT(!(STATE & VersionSet), property_version_already_set);
            m_result->setDouble(ASCIILiteral("version"), value);
            return castState<VersionSet>();
        }

        Builder<STATE | ObjectStoresSet>& setObjectStores(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::IndexedDB::ObjectStore>> value)
        {
            COMPILE_ASSERT(!(STATE & ObjectStoresSet), property_objectStores_already_set);
            m_result->setArray(ASCIILiteral("objectStores"), value);
            return castState<ObjectStoresSet>();
        }

        Ref<DatabaseWithObjectStores> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DatabaseWithObjectStores) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<DatabaseWithObjectStores>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DatabaseWithObjectStores> result = DatabaseWithObjectStores::create()
     *     .setName(...)
     *     .setVersion(...)
     *     .setObjectStores(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Object store. */
class ObjectStore : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        AutoIncrementSet = 1 << 2,
        IndexesSet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | AutoIncrementSet | IndexesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStore*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectStore;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(RefPtr<Inspector::Protocol::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setObject(ASCIILiteral("keyPath"), value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | AutoIncrementSet>& setAutoIncrement(bool value)
        {
            COMPILE_ASSERT(!(STATE & AutoIncrementSet), property_autoIncrement_already_set);
            m_result->setBoolean(ASCIILiteral("autoIncrement"), value);
            return castState<AutoIncrementSet>();
        }

        Builder<STATE | IndexesSet>& setIndexes(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::IndexedDB::ObjectStoreIndex>> value)
        {
            COMPILE_ASSERT(!(STATE & IndexesSet), property_indexes_already_set);
            m_result->setArray(ASCIILiteral("indexes"), value);
            return castState<IndexesSet>();
        }

        Ref<ObjectStore> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStore) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ObjectStore>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStore> result = ObjectStore::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setAutoIncrement(...)
     *     .setIndexes(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Object store index. */
class ObjectStoreIndex : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        KeyPathSet = 1 << 1,
        UniqueSet = 1 << 2,
        MultiEntrySet = 1 << 3,
        AllFieldsSet = (NameSet | KeyPathSet | UniqueSet | MultiEntrySet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectStoreIndex*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectStoreIndex;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | KeyPathSet>& setKeyPath(RefPtr<Inspector::Protocol::IndexedDB::KeyPath> value)
        {
            COMPILE_ASSERT(!(STATE & KeyPathSet), property_keyPath_already_set);
            m_result->setObject(ASCIILiteral("keyPath"), value);
            return castState<KeyPathSet>();
        }

        Builder<STATE | UniqueSet>& setUnique(bool value)
        {
            COMPILE_ASSERT(!(STATE & UniqueSet), property_unique_already_set);
            m_result->setBoolean(ASCIILiteral("unique"), value);
            return castState<UniqueSet>();
        }

        Builder<STATE | MultiEntrySet>& setMultiEntry(bool value)
        {
            COMPILE_ASSERT(!(STATE & MultiEntrySet), property_multiEntry_already_set);
            m_result->setBoolean(ASCIILiteral("multiEntry"), value);
            return castState<MultiEntrySet>();
        }

        Ref<ObjectStoreIndex> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectStoreIndex) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ObjectStoreIndex>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectStoreIndex> result = ObjectStoreIndex::create()
     *     .setName(...)
     *     .setKeyPath(...)
     *     .setUnique(...)
     *     .setMultiEntry(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Key. */
class Key : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating Key.
    enum class Type {
        Number = 76,
        String = 77,
        Date = 54,
        Array = 78,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Key*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Key;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<Key> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Key) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Key>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Key> result = Key::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setNumber(double value)
    {
        InspectorObjectBase::setDouble(ASCIILiteral("number"), value);
    }

    void setString(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("string"), value);
    }

    void setDate(double value)
    {
        InspectorObjectBase::setDouble(ASCIILiteral("date"), value);
    }

    void setArray(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::IndexedDB::Key>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("array"), WTFMove(value));
    }
};

/* Key range. */
class KeyRange : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LowerOpenSet = 1 << 0,
        UpperOpenSet = 1 << 1,
        AllFieldsSet = (LowerOpenSet | UpperOpenSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyRange*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class KeyRange;
    public:

        Builder<STATE | LowerOpenSet>& setLowerOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & LowerOpenSet), property_lowerOpen_already_set);
            m_result->setBoolean(ASCIILiteral("lowerOpen"), value);
            return castState<LowerOpenSet>();
        }

        Builder<STATE | UpperOpenSet>& setUpperOpen(bool value)
        {
            COMPILE_ASSERT(!(STATE & UpperOpenSet), property_upperOpen_already_set);
            m_result->setBoolean(ASCIILiteral("upperOpen"), value);
            return castState<UpperOpenSet>();
        }

        Ref<KeyRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyRange) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<KeyRange>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyRange> result = KeyRange::create()
     *     .setLowerOpen(...)
     *     .setUpperOpen(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setLower(RefPtr<Inspector::Protocol::IndexedDB::Key> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("lower"), WTFMove(value));
    }

    void setUpper(RefPtr<Inspector::Protocol::IndexedDB::Key> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("upper"), WTFMove(value));
    }
};

/* Data entry. */
class DataEntry : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        KeySet = 1 << 0,
        PrimaryKeySet = 1 << 1,
        ValueSet = 1 << 2,
        AllFieldsSet = (KeySet | PrimaryKeySet | ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*DataEntry*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class DataEntry;
    public:

        Builder<STATE | KeySet>& setKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & KeySet), property_key_already_set);
            m_result->setObject(ASCIILiteral("key"), value);
            return castState<KeySet>();
        }

        Builder<STATE | PrimaryKeySet>& setPrimaryKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & PrimaryKeySet), property_primaryKey_already_set);
            m_result->setObject(ASCIILiteral("primaryKey"), value);
            return castState<PrimaryKeySet>();
        }

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<DataEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(DataEntry) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<DataEntry>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<DataEntry> result = DataEntry::create()
     *     .setKey(...)
     *     .setPrimaryKey(...)
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Key path. */
class KeyPath : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating KeyPath.
    enum class Type {
        Null = 79,
        String = 77,
        Array = 78,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*KeyPath*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class KeyPath;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<KeyPath> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(KeyPath) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<KeyPath>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<KeyPath> result = KeyPath::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setString(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("string"), value);
    }

    void setArray(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("array"), WTFMove(value));
    }
};

} // IndexedDB
#endif // ENABLE(INDEXED_DATABASE)

namespace LayerTree {
/* A rectangle. */
class IntRect : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*IntRect*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class IntRect;
    public:

        Builder<STATE | XSet>& setX(int value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setInteger(ASCIILiteral("x"), value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(int value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setInteger(ASCIILiteral("y"), value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setInteger(ASCIILiteral("width"), value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setInteger(ASCIILiteral("height"), value);
            return castState<HeightSet>();
        }

        Ref<IntRect> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(IntRect) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<IntRect>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<IntRect> result = IntRect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Information about a compositing layer. */
class Layer : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LayerIdSet = 1 << 0,
        NodeIdSet = 1 << 1,
        BoundsSet = 1 << 2,
        PaintCountSet = 1 << 3,
        MemorySet = 1 << 4,
        CompositedBoundsSet = 1 << 5,
        AllFieldsSet = (LayerIdSet | NodeIdSet | BoundsSet | PaintCountSet | MemorySet | CompositedBoundsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Layer*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Layer;
    public:

        Builder<STATE | LayerIdSet>& setLayerId(const Inspector::Protocol::LayerTree::LayerId& value)
        {
            COMPILE_ASSERT(!(STATE & LayerIdSet), property_layerId_already_set);
            m_result->setString(ASCIILiteral("layerId"), value);
            return castState<LayerIdSet>();
        }

        Builder<STATE | NodeIdSet>& setNodeId(int value)
        {
            COMPILE_ASSERT(!(STATE & NodeIdSet), property_nodeId_already_set);
            m_result->setInteger(ASCIILiteral("nodeId"), value);
            return castState<NodeIdSet>();
        }

        Builder<STATE | BoundsSet>& setBounds(RefPtr<Inspector::Protocol::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & BoundsSet), property_bounds_already_set);
            m_result->setObject(ASCIILiteral("bounds"), value);
            return castState<BoundsSet>();
        }

        Builder<STATE | PaintCountSet>& setPaintCount(int value)
        {
            COMPILE_ASSERT(!(STATE & PaintCountSet), property_paintCount_already_set);
            m_result->setInteger(ASCIILiteral("paintCount"), value);
            return castState<PaintCountSet>();
        }

        Builder<STATE | MemorySet>& setMemory(int value)
        {
            COMPILE_ASSERT(!(STATE & MemorySet), property_memory_already_set);
            m_result->setInteger(ASCIILiteral("memory"), value);
            return castState<MemorySet>();
        }

        Builder<STATE | CompositedBoundsSet>& setCompositedBounds(RefPtr<Inspector::Protocol::LayerTree::IntRect> value)
        {
            COMPILE_ASSERT(!(STATE & CompositedBoundsSet), property_compositedBounds_already_set);
            m_result->setObject(ASCIILiteral("compositedBounds"), value);
            return castState<CompositedBoundsSet>();
        }

        Ref<Layer> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Layer) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Layer>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Layer> result = Layer::create()
     *     .setLayerId(...)
     *     .setNodeId(...)
     *     .setBounds(...)
     *     .setPaintCount(...)
     *     .setMemory(...)
     *     .setCompositedBounds(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setIsInShadowTree(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isInShadowTree"), value);
    }

    void setIsReflection(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isReflection"), value);
    }

    void setIsGeneratedContent(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isGeneratedContent"), value);
    }

    void setIsAnonymous(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isAnonymous"), value);
    }

    void setPseudoElementId(const Inspector::Protocol::LayerTree::PseudoElementId& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("pseudoElementId"), value);
    }

    void setPseudoElement(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("pseudoElement"), value);
    }
};

/* An object containing the reasons why the layer was composited as properties. */
class CompositingReasons : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CompositingReasons*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CompositingReasons;
    public:

        Ref<CompositingReasons> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CompositingReasons) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CompositingReasons>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CompositingReasons> result = CompositingReasons::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setTransform3D(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("transform3D"), value);
    }

    void setVideo(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("video"), value);
    }

    void setCanvas(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("canvas"), value);
    }

    void setPlugin(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("plugin"), value);
    }

    void setIFrame(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("iFrame"), value);
    }

    void setBackfaceVisibilityHidden(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("backfaceVisibilityHidden"), value);
    }

    void setClipsCompositingDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("clipsCompositingDescendants"), value);
    }

    void setAnimation(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("animation"), value);
    }

    void setFilters(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("filters"), value);
    }

    void setPositionFixed(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("positionFixed"), value);
    }

    void setPositionSticky(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("positionSticky"), value);
    }

    void setOverflowScrollingTouch(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("overflowScrollingTouch"), value);
    }

    void setStacking(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("stacking"), value);
    }

    void setOverlap(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("overlap"), value);
    }

    void setNegativeZIndexChildren(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("negativeZIndexChildren"), value);
    }

    void setTransformWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("transformWithCompositedDescendants"), value);
    }

    void setOpacityWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("opacityWithCompositedDescendants"), value);
    }

    void setMaskWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("maskWithCompositedDescendants"), value);
    }

    void setReflectionWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("reflectionWithCompositedDescendants"), value);
    }

    void setFilterWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("filterWithCompositedDescendants"), value);
    }

    void setBlendingWithCompositedDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("blendingWithCompositedDescendants"), value);
    }

    void setIsolatesCompositedBlendingDescendants(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isolatesCompositedBlendingDescendants"), value);
    }

    void setPerspective(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("perspective"), value);
    }

    void setPreserve3D(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("preserve3D"), value);
    }

    void setWillChange(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("willChange"), value);
    }

    void setRoot(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("root"), value);
    }

    void setBlending(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("blending"), value);
    }
};

} // LayerTree

namespace Network {
/* Timing information for the request. */
class ResourceTiming : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NavigationStartSet = 1 << 0,
        DomainLookupStartSet = 1 << 1,
        DomainLookupEndSet = 1 << 2,
        ConnectStartSet = 1 << 3,
        ConnectEndSet = 1 << 4,
        SecureConnectionStartSet = 1 << 5,
        RequestStartSet = 1 << 6,
        ResponseStartSet = 1 << 7,
        AllFieldsSet = (NavigationStartSet | DomainLookupStartSet | DomainLookupEndSet | ConnectStartSet | ConnectEndSet | SecureConnectionStartSet | RequestStartSet | ResponseStartSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ResourceTiming*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ResourceTiming;
    public:

        Builder<STATE | NavigationStartSet>& setNavigationStart(double value)
        {
            COMPILE_ASSERT(!(STATE & NavigationStartSet), property_navigationStart_already_set);
            m_result->setDouble(ASCIILiteral("navigationStart"), value);
            return castState<NavigationStartSet>();
        }

        Builder<STATE | DomainLookupStartSet>& setDomainLookupStart(double value)
        {
            COMPILE_ASSERT(!(STATE & DomainLookupStartSet), property_domainLookupStart_already_set);
            m_result->setDouble(ASCIILiteral("domainLookupStart"), value);
            return castState<DomainLookupStartSet>();
        }

        Builder<STATE | DomainLookupEndSet>& setDomainLookupEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & DomainLookupEndSet), property_domainLookupEnd_already_set);
            m_result->setDouble(ASCIILiteral("domainLookupEnd"), value);
            return castState<DomainLookupEndSet>();
        }

        Builder<STATE | ConnectStartSet>& setConnectStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectStartSet), property_connectStart_already_set);
            m_result->setDouble(ASCIILiteral("connectStart"), value);
            return castState<ConnectStartSet>();
        }

        Builder<STATE | ConnectEndSet>& setConnectEnd(double value)
        {
            COMPILE_ASSERT(!(STATE & ConnectEndSet), property_connectEnd_already_set);
            m_result->setDouble(ASCIILiteral("connectEnd"), value);
            return castState<ConnectEndSet>();
        }

        Builder<STATE | SecureConnectionStartSet>& setSecureConnectionStart(double value)
        {
            COMPILE_ASSERT(!(STATE & SecureConnectionStartSet), property_secureConnectionStart_already_set);
            m_result->setDouble(ASCIILiteral("secureConnectionStart"), value);
            return castState<SecureConnectionStartSet>();
        }

        Builder<STATE | RequestStartSet>& setRequestStart(double value)
        {
            COMPILE_ASSERT(!(STATE & RequestStartSet), property_requestStart_already_set);
            m_result->setDouble(ASCIILiteral("requestStart"), value);
            return castState<RequestStartSet>();
        }

        Builder<STATE | ResponseStartSet>& setResponseStart(double value)
        {
            COMPILE_ASSERT(!(STATE & ResponseStartSet), property_responseStart_already_set);
            m_result->setDouble(ASCIILiteral("responseStart"), value);
            return castState<ResponseStartSet>();
        }

        Ref<ResourceTiming> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ResourceTiming) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ResourceTiming>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ResourceTiming> result = ResourceTiming::create()
     *     .setNavigationStart(...)
     *     .setDomainLookupStart(...)
     *     .setDomainLookupEnd(...)
     *     .setConnectStart(...)
     *     .setConnectEnd(...)
     *     .setSecureConnectionStart(...)
     *     .setRequestStart(...)
     *     .setResponseStart(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* HTTP request data. */
class Request : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        MethodSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (UrlSet | MethodSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Request*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Request;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | MethodSet>& setMethod(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MethodSet), property_method_already_set);
            m_result->setString(ASCIILiteral("method"), value);
            return castState<MethodSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<Inspector::InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject(ASCIILiteral("headers"), value);
            return castState<HeadersSet>();
        }

        Ref<Request> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Request) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Request>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Request> result = Request::create()
     *     .setUrl(...)
     *     .setMethod(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setPostData(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("postData"), value);
    }
};

/* HTTP response data. */
class Response : public Inspector::InspectorObject {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        StatusSet = 1 << 1,
        StatusTextSet = 1 << 2,
        HeadersSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Response*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Response;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setDouble(ASCIILiteral("status"), value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString(ASCIILiteral("statusText"), value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<Inspector::InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject(ASCIILiteral("headers"), value);
            return castState<HeadersSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString(ASCIILiteral("mimeType"), value);
            return castState<MimeTypeSet>();
        }

        Ref<Response> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Response) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Response>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Response> result = Response::create()
     *     .setUrl(...)
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setHeadersText(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("headersText"), value);
    }

    void setRequestHeaders(RefPtr<Inspector::InspectorObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("requestHeaders"), WTFMove(value));
    }

    void setRequestHeadersText(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("requestHeadersText"), value);
    }

    void setFromDiskCache(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("fromDiskCache"), value);
    }

    void setTiming(RefPtr<Inspector::Protocol::Network::ResourceTiming> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("timing"), WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* Url;
    JS_EXPORT_PRIVATE static const char* Status;
    JS_EXPORT_PRIVATE static const char* StatusText;
    JS_EXPORT_PRIVATE static const char* Headers;
    JS_EXPORT_PRIVATE static const char* HeadersText;
    JS_EXPORT_PRIVATE static const char* MimeType;
    JS_EXPORT_PRIVATE static const char* RequestHeaders;
    JS_EXPORT_PRIVATE static const char* RequestHeadersText;
    JS_EXPORT_PRIVATE static const char* FromDiskCache;
    JS_EXPORT_PRIVATE static const char* Timing;
};

/* WebSocket request data. */
class WebSocketRequest : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        HeadersSet = 1 << 0,
        AllFieldsSet = (HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketRequest*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketRequest;
    public:

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<Inspector::InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject(ASCIILiteral("headers"), value);
            return castState<HeadersSet>();
        }

        Ref<WebSocketRequest> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketRequest) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<WebSocketRequest>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketRequest> result = WebSocketRequest::create()
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* WebSocket response data. */
class WebSocketResponse : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StatusSet = 1 << 0,
        StatusTextSet = 1 << 1,
        HeadersSet = 1 << 2,
        AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketResponse*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketResponse;
    public:

        Builder<STATE | StatusSet>& setStatus(double value)
        {
            COMPILE_ASSERT(!(STATE & StatusSet), property_status_already_set);
            m_result->setDouble(ASCIILiteral("status"), value);
            return castState<StatusSet>();
        }

        Builder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            COMPILE_ASSERT(!(STATE & StatusTextSet), property_statusText_already_set);
            m_result->setString(ASCIILiteral("statusText"), value);
            return castState<StatusTextSet>();
        }

        Builder<STATE | HeadersSet>& setHeaders(RefPtr<Inspector::InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & HeadersSet), property_headers_already_set);
            m_result->setObject(ASCIILiteral("headers"), value);
            return castState<HeadersSet>();
        }

        Ref<WebSocketResponse> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketResponse) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<WebSocketResponse>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketResponse> result = WebSocketResponse::create()
     *     .setStatus(...)
     *     .setStatusText(...)
     *     .setHeaders(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* WebSocket frame data. */
class WebSocketFrame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        OpcodeSet = 1 << 0,
        MaskSet = 1 << 1,
        PayloadDataSet = 1 << 2,
        AllFieldsSet = (OpcodeSet | MaskSet | PayloadDataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*WebSocketFrame*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class WebSocketFrame;
    public:

        Builder<STATE | OpcodeSet>& setOpcode(double value)
        {
            COMPILE_ASSERT(!(STATE & OpcodeSet), property_opcode_already_set);
            m_result->setDouble(ASCIILiteral("opcode"), value);
            return castState<OpcodeSet>();
        }

        Builder<STATE | MaskSet>& setMask(bool value)
        {
            COMPILE_ASSERT(!(STATE & MaskSet), property_mask_already_set);
            m_result->setBoolean(ASCIILiteral("mask"), value);
            return castState<MaskSet>();
        }

        Builder<STATE | PayloadDataSet>& setPayloadData(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PayloadDataSet), property_payloadData_already_set);
            m_result->setString(ASCIILiteral("payloadData"), value);
            return castState<PayloadDataSet>();
        }

        Ref<WebSocketFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(WebSocketFrame) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<WebSocketFrame>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<WebSocketFrame> result = WebSocketFrame::create()
     *     .setOpcode(...)
     *     .setMask(...)
     *     .setPayloadData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Information about the cached resource. */
class CachedResource : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        BodySizeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | BodySizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CachedResource*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CachedResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Page::ResourceType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | BodySizeSet>& setBodySize(double value)
        {
            COMPILE_ASSERT(!(STATE & BodySizeSet), property_bodySize_already_set);
            m_result->setDouble(ASCIILiteral("bodySize"), value);
            return castState<BodySizeSet>();
        }

        Ref<CachedResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CachedResource) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CachedResource>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CachedResource> result = CachedResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setBodySize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setResponse(RefPtr<Inspector::Protocol::Network::Response> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("response"), WTFMove(value));
    }

    void setSourceMapURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("sourceMapURL"), value);
    }
};

/* Information about the request initiator. */
class Initiator : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating Initiator.
    enum class Type {
        Parser = 88,
        Script = 89,
        Other = 25,
    }; // enum class Type
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Initiator*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Initiator;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<Initiator> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Initiator) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Initiator>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Initiator> result = Initiator::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setStackTrace(RefPtr<Inspector::Protocol::Console::StackTrace> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("stackTrace"), WTFMove(value));
    }

    void setUrl(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("url"), value);
    }

    void setLineNumber(double value)
    {
        InspectorObjectBase::setDouble(ASCIILiteral("lineNumber"), value);
    }
};

} // Network

namespace OverlayTypes {
class Point : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        AllFieldsSet = (XSet | YSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Point*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Point;
    public:

        Builder<STATE | XSet>& setX(double value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setDouble(ASCIILiteral("x"), value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(double value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setDouble(ASCIILiteral("y"), value);
            return castState<YSet>();
        }

        Ref<Point> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Point) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Point>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Point> result = Point::create()
     *     .setX(...)
     *     .setY(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class Size : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        WidthSet = 1 << 0,
        HeightSet = 1 << 1,
        AllFieldsSet = (WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Size*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Size;
    public:

        Builder<STATE | WidthSet>& setWidth(int value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setInteger(ASCIILiteral("width"), value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(int value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setInteger(ASCIILiteral("height"), value);
            return castState<HeightSet>();
        }

        Ref<Size> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Size) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Size>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Size> result = Size::create()
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* A rectangle specified by a reference coordinate and width/height offsets. */
class Rect : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        XSet = 1 << 0,
        YSet = 1 << 1,
        WidthSet = 1 << 2,
        HeightSet = 1 << 3,
        AllFieldsSet = (XSet | YSet | WidthSet | HeightSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Rect*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Rect;
    public:

        Builder<STATE | XSet>& setX(double value)
        {
            COMPILE_ASSERT(!(STATE & XSet), property_x_already_set);
            m_result->setDouble(ASCIILiteral("x"), value);
            return castState<XSet>();
        }

        Builder<STATE | YSet>& setY(double value)
        {
            COMPILE_ASSERT(!(STATE & YSet), property_y_already_set);
            m_result->setDouble(ASCIILiteral("y"), value);
            return castState<YSet>();
        }

        Builder<STATE | WidthSet>& setWidth(double value)
        {
            COMPILE_ASSERT(!(STATE & WidthSet), property_width_already_set);
            m_result->setDouble(ASCIILiteral("width"), value);
            return castState<WidthSet>();
        }

        Builder<STATE | HeightSet>& setHeight(double value)
        {
            COMPILE_ASSERT(!(STATE & HeightSet), property_height_already_set);
            m_result->setDouble(ASCIILiteral("height"), value);
            return castState<HeightSet>();
        }

        Ref<Rect> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Rect) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Rect>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Rect> result = Rect::create()
     *     .setX(...)
     *     .setY(...)
     *     .setWidth(...)
     *     .setHeight(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* A single region in a flow thread. */
class Region : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BorderQuadSet = 1 << 0,
        IncomingQuadSet = 1 << 1,
        OutgoingQuadSet = 1 << 2,
        AllFieldsSet = (BorderQuadSet | IncomingQuadSet | OutgoingQuadSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Region*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Region;
    public:

        Builder<STATE | BorderQuadSet>& setBorderQuad(RefPtr<Inspector::Protocol::OverlayTypes::Quad> value)
        {
            COMPILE_ASSERT(!(STATE & BorderQuadSet), property_borderQuad_already_set);
            m_result->setArray(ASCIILiteral("borderQuad"), value);
            return castState<BorderQuadSet>();
        }

        Builder<STATE | IncomingQuadSet>& setIncomingQuad(RefPtr<Inspector::Protocol::OverlayTypes::Quad> value)
        {
            COMPILE_ASSERT(!(STATE & IncomingQuadSet), property_incomingQuad_already_set);
            m_result->setArray(ASCIILiteral("incomingQuad"), value);
            return castState<IncomingQuadSet>();
        }

        Builder<STATE | OutgoingQuadSet>& setOutgoingQuad(RefPtr<Inspector::Protocol::OverlayTypes::Quad> value)
        {
            COMPILE_ASSERT(!(STATE & OutgoingQuadSet), property_outgoingQuad_already_set);
            m_result->setArray(ASCIILiteral("outgoingQuad"), value);
            return castState<OutgoingQuadSet>();
        }

        Ref<Region> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Region) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Region>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Region> result = Region::create()
     *     .setBorderQuad(...)
     *     .setIncomingQuad(...)
     *     .setOutgoingQuad(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setIsHighlighted(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isHighlighted"), value);
    }
};

class RegionFlowData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RegionsSet = 1 << 0,
        NameSet = 1 << 1,
        AllFieldsSet = (RegionsSet | NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RegionFlowData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RegionFlowData;
    public:

        Builder<STATE | RegionsSet>& setRegions(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::OverlayTypes::Region>> value)
        {
            COMPILE_ASSERT(!(STATE & RegionsSet), property_regions_already_set);
            m_result->setArray(ASCIILiteral("regions"), value);
            return castState<RegionsSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Ref<RegionFlowData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RegionFlowData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<RegionFlowData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RegionFlowData> result = RegionFlowData::create()
     *     .setRegions(...)
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class ContentFlowData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ContentFlowData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ContentFlowData;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Ref<ContentFlowData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ContentFlowData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ContentFlowData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ContentFlowData> result = ContentFlowData::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class ShapeOutsideData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        BoundsSet = 1 << 0,
        AllFieldsSet = (BoundsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ShapeOutsideData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ShapeOutsideData;
    public:

        Builder<STATE | BoundsSet>& setBounds(RefPtr<Inspector::Protocol::OverlayTypes::Quad> value)
        {
            COMPILE_ASSERT(!(STATE & BoundsSet), property_bounds_already_set);
            m_result->setArray(ASCIILiteral("bounds"), value);
            return castState<BoundsSet>();
        }

        Ref<ShapeOutsideData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ShapeOutsideData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ShapeOutsideData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ShapeOutsideData> result = ShapeOutsideData::create()
     *     .setBounds(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setShape(RefPtr<Inspector::Protocol::OverlayTypes::DisplayPath> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("shape"), WTFMove(value));
    }

    void setMarginShape(RefPtr<Inspector::Protocol::OverlayTypes::DisplayPath> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("marginShape"), WTFMove(value));
    }
};

/* Data that describes an element to be highlighted. */
class ElementData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TagNameSet = 1 << 0,
        IdValueSet = 1 << 1,
        AllFieldsSet = (TagNameSet | IdValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ElementData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ElementData;
    public:

        Builder<STATE | TagNameSet>& setTagName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & TagNameSet), property_tagName_already_set);
            m_result->setString(ASCIILiteral("tagName"), value);
            return castState<TagNameSet>();
        }

        Builder<STATE | IdValueSet>& setIdValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdValueSet), property_idValue_already_set);
            m_result->setString(ASCIILiteral("idValue"), value);
            return castState<IdValueSet>();
        }

        Ref<ElementData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ElementData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ElementData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ElementData> result = ElementData::create()
     *     .setTagName(...)
     *     .setIdValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setClassName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("className"), value);
    }

    void setSize(RefPtr<Inspector::Protocol::OverlayTypes::Size> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("size"), WTFMove(value));
    }

    void setRole(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("role"), value);
    }

    void setRegionFlowData(RefPtr<Inspector::Protocol::OverlayTypes::RegionFlowData> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("regionFlowData"), WTFMove(value));
    }

    void setContentFlowData(RefPtr<Inspector::Protocol::OverlayTypes::ContentFlowData> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("contentFlowData"), WTFMove(value));
    }

    void setShapeOutsideData(RefPtr<Inspector::Protocol::OverlayTypes::ShapeOutsideData> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("shapeOutsideData"), WTFMove(value));
    }
};

/* Data required to highlight multiple quads. */
class FragmentHighlightData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        QuadsSet = 1 << 0,
        ContentColorSet = 1 << 1,
        ContentOutlineColorSet = 1 << 2,
        PaddingColorSet = 1 << 3,
        BorderColorSet = 1 << 4,
        MarginColorSet = 1 << 5,
        AllFieldsSet = (QuadsSet | ContentColorSet | ContentOutlineColorSet | PaddingColorSet | BorderColorSet | MarginColorSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FragmentHighlightData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FragmentHighlightData;
    public:

        Builder<STATE | QuadsSet>& setQuads(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::OverlayTypes::Quad>> value)
        {
            COMPILE_ASSERT(!(STATE & QuadsSet), property_quads_already_set);
            m_result->setArray(ASCIILiteral("quads"), value);
            return castState<QuadsSet>();
        }

        Builder<STATE | ContentColorSet>& setContentColor(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ContentColorSet), property_contentColor_already_set);
            m_result->setString(ASCIILiteral("contentColor"), value);
            return castState<ContentColorSet>();
        }

        Builder<STATE | ContentOutlineColorSet>& setContentOutlineColor(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ContentOutlineColorSet), property_contentOutlineColor_already_set);
            m_result->setString(ASCIILiteral("contentOutlineColor"), value);
            return castState<ContentOutlineColorSet>();
        }

        Builder<STATE | PaddingColorSet>& setPaddingColor(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PaddingColorSet), property_paddingColor_already_set);
            m_result->setString(ASCIILiteral("paddingColor"), value);
            return castState<PaddingColorSet>();
        }

        Builder<STATE | BorderColorSet>& setBorderColor(const String& value)
        {
            COMPILE_ASSERT(!(STATE & BorderColorSet), property_borderColor_already_set);
            m_result->setString(ASCIILiteral("borderColor"), value);
            return castState<BorderColorSet>();
        }

        Builder<STATE | MarginColorSet>& setMarginColor(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MarginColorSet), property_marginColor_already_set);
            m_result->setString(ASCIILiteral("marginColor"), value);
            return castState<MarginColorSet>();
        }

        Ref<FragmentHighlightData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FragmentHighlightData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<FragmentHighlightData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FragmentHighlightData> result = FragmentHighlightData::create()
     *     .setQuads(...)
     *     .setContentColor(...)
     *     .setContentOutlineColor(...)
     *     .setPaddingColor(...)
     *     .setBorderColor(...)
     *     .setMarginColor(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setRegionClippingArea(RefPtr<Inspector::Protocol::OverlayTypes::Quad> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("regionClippingArea"), WTFMove(value));
    }
};

/* Data required to highlight a DOM node. */
class NodeHighlightData : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ScrollOffsetSet = 1 << 0,
        FragmentsSet = 1 << 1,
        AllFieldsSet = (ScrollOffsetSet | FragmentsSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*NodeHighlightData*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class NodeHighlightData;
    public:

        Builder<STATE | ScrollOffsetSet>& setScrollOffset(RefPtr<Inspector::Protocol::OverlayTypes::Point> value)
        {
            COMPILE_ASSERT(!(STATE & ScrollOffsetSet), property_scrollOffset_already_set);
            m_result->setObject(ASCIILiteral("scrollOffset"), value);
            return castState<ScrollOffsetSet>();
        }

        Builder<STATE | FragmentsSet>& setFragments(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::OverlayTypes::FragmentHighlightData>> value)
        {
            COMPILE_ASSERT(!(STATE & FragmentsSet), property_fragments_already_set);
            m_result->setArray(ASCIILiteral("fragments"), value);
            return castState<FragmentsSet>();
        }

        Ref<NodeHighlightData> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(NodeHighlightData) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<NodeHighlightData>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<NodeHighlightData> result = NodeHighlightData::create()
     *     .setScrollOffset(...)
     *     .setFragments(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setElementData(RefPtr<Inspector::Protocol::OverlayTypes::ElementData> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("elementData"), WTFMove(value));
    }
};

/* Data required to configure the overlay's size and scaling behavior. */
class OverlayConfiguration : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        DeviceScaleFactorSet = 1 << 0,
        ViewportSizeSet = 1 << 1,
        FrameViewFullSizeSet = 1 << 2,
        AllFieldsSet = (DeviceScaleFactorSet | ViewportSizeSet | FrameViewFullSizeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*OverlayConfiguration*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class OverlayConfiguration;
    public:

        Builder<STATE | DeviceScaleFactorSet>& setDeviceScaleFactor(double value)
        {
            COMPILE_ASSERT(!(STATE & DeviceScaleFactorSet), property_deviceScaleFactor_already_set);
            m_result->setDouble(ASCIILiteral("deviceScaleFactor"), value);
            return castState<DeviceScaleFactorSet>();
        }

        Builder<STATE | ViewportSizeSet>& setViewportSize(RefPtr<Inspector::Protocol::OverlayTypes::Size> value)
        {
            COMPILE_ASSERT(!(STATE & ViewportSizeSet), property_viewportSize_already_set);
            m_result->setObject(ASCIILiteral("viewportSize"), value);
            return castState<ViewportSizeSet>();
        }

        Builder<STATE | FrameViewFullSizeSet>& setFrameViewFullSize(RefPtr<Inspector::Protocol::OverlayTypes::Size> value)
        {
            COMPILE_ASSERT(!(STATE & FrameViewFullSizeSet), property_frameViewFullSize_already_set);
            m_result->setObject(ASCIILiteral("frameViewFullSize"), value);
            return castState<FrameViewFullSizeSet>();
        }

        Ref<OverlayConfiguration> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(OverlayConfiguration) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<OverlayConfiguration>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<OverlayConfiguration> result = OverlayConfiguration::create()
     *     .setDeviceScaleFactor(...)
     *     .setViewportSize(...)
     *     .setFrameViewFullSize(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // OverlayTypes

namespace Page {
/* Resource type as it was perceived by the rendering engine. */
enum class ResourceType {
    Document = 80,
    Stylesheet = 81,
    Image = 82,
    Font = 83,
    Script = 84,
    XHR = 85,
    WebSocket = 86,
    Other = 87,
}; // enum class ResourceType
/* Coordinate system used by supplied coordinates. */
enum class CoordinateSystem {
    Viewport = 90,
    Page = 91,
}; // enum class CoordinateSystem
/* Information about the Frame on the page. */
class Frame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        LoaderIdSet = 1 << 1,
        UrlSet = 1 << 2,
        SecurityOriginSet = 1 << 3,
        MimeTypeSet = 1 << 4,
        AllFieldsSet = (IdSet | LoaderIdSet | UrlSet | SecurityOriginSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Frame*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Frame;
    public:

        Builder<STATE | IdSet>& setId(const String& value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setString(ASCIILiteral("id"), value);
            return castState<IdSet>();
        }

        Builder<STATE | LoaderIdSet>& setLoaderId(const Inspector::Protocol::Network::LoaderId& value)
        {
            COMPILE_ASSERT(!(STATE & LoaderIdSet), property_loaderId_already_set);
            m_result->setString(ASCIILiteral("loaderId"), value);
            return castState<LoaderIdSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | SecurityOriginSet>& setSecurityOrigin(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SecurityOriginSet), property_securityOrigin_already_set);
            m_result->setString(ASCIILiteral("securityOrigin"), value);
            return castState<SecurityOriginSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString(ASCIILiteral("mimeType"), value);
            return castState<MimeTypeSet>();
        }

        Ref<Frame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Frame) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Frame>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Frame> result = Frame::create()
     *     .setId(...)
     *     .setLoaderId(...)
     *     .setUrl(...)
     *     .setSecurityOrigin(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setParentId(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("parentId"), value);
    }

    void setName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("name"), value);
    }
};

class FrameResource : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        TypeSet = 1 << 1,
        MimeTypeSet = 1 << 2,
        AllFieldsSet = (UrlSet | TypeSet | MimeTypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResource*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameResource;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Page::ResourceType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            COMPILE_ASSERT(!(STATE & MimeTypeSet), property_mimeType_already_set);
            m_result->setString(ASCIILiteral("mimeType"), value);
            return castState<MimeTypeSet>();
        }

        Ref<FrameResource> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResource) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<FrameResource>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResource> result = FrameResource::create()
     *     .setUrl(...)
     *     .setType(...)
     *     .setMimeType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setFailed(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("failed"), value);
    }

    void setCanceled(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("canceled"), value);
    }

    void setSourceMapURL(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("sourceMapURL"), value);
    }
};

/* Information about the Frame hierarchy along with their cached resources. */
class FrameResourceTree : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        FrameSet = 1 << 0,
        ResourcesSet = 1 << 1,
        AllFieldsSet = (FrameSet | ResourcesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*FrameResourceTree*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class FrameResourceTree;
    public:

        Builder<STATE | FrameSet>& setFrame(RefPtr<Inspector::Protocol::Page::Frame> value)
        {
            COMPILE_ASSERT(!(STATE & FrameSet), property_frame_already_set);
            m_result->setObject(ASCIILiteral("frame"), value);
            return castState<FrameSet>();
        }

        Builder<STATE | ResourcesSet>& setResources(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Page::FrameResource>> value)
        {
            COMPILE_ASSERT(!(STATE & ResourcesSet), property_resources_already_set);
            m_result->setArray(ASCIILiteral("resources"), value);
            return castState<ResourcesSet>();
        }

        Ref<FrameResourceTree> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(FrameResourceTree) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<FrameResourceTree>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<FrameResourceTree> result = FrameResourceTree::create()
     *     .setFrame(...)
     *     .setResources(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setChildFrames(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Page::FrameResourceTree>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("childFrames"), WTFMove(value));
    }
};

/* Search result for resource. */
class SearchResult : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        UrlSet = 1 << 0,
        FrameIdSet = 1 << 1,
        MatchesCountSet = 1 << 2,
        AllFieldsSet = (UrlSet | FrameIdSet | MatchesCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*SearchResult*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class SearchResult;
    public:

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const Inspector::Protocol::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString(ASCIILiteral("frameId"), value);
            return castState<FrameIdSet>();
        }

        Builder<STATE | MatchesCountSet>& setMatchesCount(double value)
        {
            COMPILE_ASSERT(!(STATE & MatchesCountSet), property_matchesCount_already_set);
            m_result->setDouble(ASCIILiteral("matchesCount"), value);
            return castState<MatchesCountSet>();
        }

        Ref<SearchResult> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(SearchResult) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<SearchResult>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<SearchResult> result = SearchResult::create()
     *     .setUrl(...)
     *     .setFrameId(...)
     *     .setMatchesCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Cookie object */
class Cookie : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ValueSet = 1 << 1,
        DomainSet = 1 << 2,
        PathSet = 1 << 3,
        ExpiresSet = 1 << 4,
        SizeSet = 1 << 5,
        HttpOnlySet = 1 << 6,
        SecureSet = 1 << 7,
        SessionSet = 1 << 8,
        AllFieldsSet = (NameSet | ValueSet | DomainSet | PathSet | ExpiresSet | SizeSet | HttpOnlySet | SecureSet | SessionSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Cookie*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Cookie;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ValueSet>& setValue(const String& value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setString(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Builder<STATE | DomainSet>& setDomain(const String& value)
        {
            COMPILE_ASSERT(!(STATE & DomainSet), property_domain_already_set);
            m_result->setString(ASCIILiteral("domain"), value);
            return castState<DomainSet>();
        }

        Builder<STATE | PathSet>& setPath(const String& value)
        {
            COMPILE_ASSERT(!(STATE & PathSet), property_path_already_set);
            m_result->setString(ASCIILiteral("path"), value);
            return castState<PathSet>();
        }

        Builder<STATE | ExpiresSet>& setExpires(double value)
        {
            COMPILE_ASSERT(!(STATE & ExpiresSet), property_expires_already_set);
            m_result->setDouble(ASCIILiteral("expires"), value);
            return castState<ExpiresSet>();
        }

        Builder<STATE | SizeSet>& setSize(int value)
        {
            COMPILE_ASSERT(!(STATE & SizeSet), property_size_already_set);
            m_result->setInteger(ASCIILiteral("size"), value);
            return castState<SizeSet>();
        }

        Builder<STATE | HttpOnlySet>& setHttpOnly(bool value)
        {
            COMPILE_ASSERT(!(STATE & HttpOnlySet), property_httpOnly_already_set);
            m_result->setBoolean(ASCIILiteral("httpOnly"), value);
            return castState<HttpOnlySet>();
        }

        Builder<STATE | SecureSet>& setSecure(bool value)
        {
            COMPILE_ASSERT(!(STATE & SecureSet), property_secure_already_set);
            m_result->setBoolean(ASCIILiteral("secure"), value);
            return castState<SecureSet>();
        }

        Builder<STATE | SessionSet>& setSession(bool value)
        {
            COMPILE_ASSERT(!(STATE & SessionSet), property_session_already_set);
            m_result->setBoolean(ASCIILiteral("session"), value);
            return castState<SessionSet>();
        }

        Ref<Cookie> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Cookie) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Cookie>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Cookie> result = Cookie::create()
     *     .setName(...)
     *     .setValue(...)
     *     .setDomain(...)
     *     .setPath(...)
     *     .setExpires(...)
     *     .setSize(...)
     *     .setHttpOnly(...)
     *     .setSecure(...)
     *     .setSession(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Page

namespace Runtime {
/* Mirror object referencing original JavaScript object. */
class RemoteObject : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating RemoteObject.
    enum class Type {
        Object = 92,
        Function = 93,
        Undefined = 94,
        String = 77,
        Number = 76,
        Boolean = 95,
        Symbol = 96,
    }; // enum class Type
    // Named after property name 'subtype' while generating RemoteObject.
    enum class Subtype {
        Array = 78,
        Null = 79,
        Node = 97,
        Regexp = 98,
        Date = 54,
        Error = 29,
        Map = 99,
        Set = 100,
        Weakmap = 101,
        Weakset = 102,
        Iterator = 103,
        Class = 104,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        AllFieldsSet = (TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*RemoteObject*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class RemoteObject;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<RemoteObject> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(RemoteObject) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<RemoteObject>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<RemoteObject> result = RemoteObject::create()
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setSubtype(Subtype value)
    {
        InspectorObjectBase::setString(ASCIILiteral("subtype"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setClassName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("className"), value);
    }

    void setValue(RefPtr<Inspector::InspectorValue> value)
    {
        InspectorObjectBase::setValue(ASCIILiteral("value"), WTFMove(value));
    }

    void setDescription(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("description"), value);
    }

    void setObjectId(const Inspector::Protocol::Runtime::RemoteObjectId& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("objectId"), value);
    }

    void setSize(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("size"), value);
    }

    void setClassPrototype(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("classPrototype"), WTFMove(value));
    }

    void setPreview(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("preview"), WTFMove(value));
    }
};

/* Object containing abbreviated remote object value. */
class ObjectPreview : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating ObjectPreview.
    enum class Type {
        Object = 92,
        Function = 93,
        Undefined = 94,
        String = 77,
        Number = 76,
        Boolean = 95,
        Symbol = 96,
    }; // enum class Type
    // Named after property name 'subtype' while generating ObjectPreview.
    enum class Subtype {
        Array = 78,
        Null = 79,
        Node = 97,
        Regexp = 98,
        Date = 54,
        Error = 29,
        Map = 99,
        Set = 100,
        Weakmap = 101,
        Weakset = 102,
        Iterator = 103,
        Class = 104,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        LosslessSet = 1 << 1,
        AllFieldsSet = (TypeSet | LosslessSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ObjectPreview*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ObjectPreview;
    public:

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | LosslessSet>& setLossless(bool value)
        {
            COMPILE_ASSERT(!(STATE & LosslessSet), property_lossless_already_set);
            m_result->setBoolean(ASCIILiteral("lossless"), value);
            return castState<LosslessSet>();
        }

        Ref<ObjectPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ObjectPreview) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ObjectPreview>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ObjectPreview> result = ObjectPreview::create()
     *     .setType(...)
     *     .setLossless(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setSubtype(Subtype value)
    {
        InspectorObjectBase::setString(ASCIILiteral("subtype"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setDescription(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("description"), value);
    }

    void setOverflow(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("overflow"), value);
    }

    void setProperties(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::PropertyPreview>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("properties"), WTFMove(value));
    }

    void setEntries(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::EntryPreview>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("entries"), WTFMove(value));
    }

    void setSize(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("size"), value);
    }
};

class PropertyPreview : public Inspector::InspectorObjectBase {
public:
    // Named after property name 'type' while generating PropertyPreview.
    enum class Type {
        Object = 92,
        Function = 93,
        Undefined = 94,
        String = 77,
        Number = 76,
        Boolean = 95,
        Symbol = 96,
        Accessor = 105,
    }; // enum class Type
    // Named after property name 'subtype' while generating PropertyPreview.
    enum class Subtype {
        Array = 78,
        Null = 79,
        Node = 97,
        Regexp = 98,
        Date = 54,
        Error = 29,
        Map = 99,
        Set = 100,
        Weakmap = 101,
        Weakset = 102,
        Iterator = 103,
        Class = 104,
    }; // enum class Subtype
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        TypeSet = 1 << 1,
        AllFieldsSet = (NameSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyPreview*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PropertyPreview;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | TypeSet>& setType(Type value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<PropertyPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyPreview) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<PropertyPreview>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyPreview> result = PropertyPreview::create()
     *     .setName(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setSubtype(Subtype value)
    {
        InspectorObjectBase::setString(ASCIILiteral("subtype"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
    }

    void setValue(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("value"), value);
    }

    void setValuePreview(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("valuePreview"), WTFMove(value));
    }

    void setInternal(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("internal"), value);
    }
};

class EntryPreview : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*EntryPreview*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class EntryPreview;
    public:

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<EntryPreview> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(EntryPreview) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<EntryPreview>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<EntryPreview> result = EntryPreview::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setKey(RefPtr<Inspector::Protocol::Runtime::ObjectPreview> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("key"), WTFMove(value));
    }
};

class CollectionEntry : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        ValueSet = 1 << 0,
        AllFieldsSet = (ValueSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CollectionEntry*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CollectionEntry;
    public:

        Builder<STATE | ValueSet>& setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
        {
            COMPILE_ASSERT(!(STATE & ValueSet), property_value_already_set);
            m_result->setObject(ASCIILiteral("value"), value);
            return castState<ValueSet>();
        }

        Ref<CollectionEntry> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CollectionEntry) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CollectionEntry>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CollectionEntry> result = CollectionEntry::create()
     *     .setValue(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setKey(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("key"), WTFMove(value));
    }
};

/* Object property descriptor. */
class PropertyDescriptor : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        ConfigurableSet = 1 << 1,
        EnumerableSet = 1 << 2,
        AllFieldsSet = (NameSet | ConfigurableSet | EnumerableSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*PropertyDescriptor*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class PropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | ConfigurableSet>& setConfigurable(bool value)
        {
            COMPILE_ASSERT(!(STATE & ConfigurableSet), property_configurable_already_set);
            m_result->setBoolean(ASCIILiteral("configurable"), value);
            return castState<ConfigurableSet>();
        }

        Builder<STATE | EnumerableSet>& setEnumerable(bool value)
        {
            COMPILE_ASSERT(!(STATE & EnumerableSet), property_enumerable_already_set);
            m_result->setBoolean(ASCIILiteral("enumerable"), value);
            return castState<EnumerableSet>();
        }

        Ref<PropertyDescriptor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(PropertyDescriptor) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<PropertyDescriptor>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<PropertyDescriptor> result = PropertyDescriptor::create()
     *     .setName(...)
     *     .setConfigurable(...)
     *     .setEnumerable(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("value"), WTFMove(value));
    }

    void setWritable(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("writable"), value);
    }

    void setGet(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("get"), WTFMove(value));
    }

    void setSet(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("set"), WTFMove(value));
    }

    void setWasThrown(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("wasThrown"), value);
    }

    void setIsOwn(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isOwn"), value);
    }

    void setSymbol(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("symbol"), WTFMove(value));
    }

    void setNativeGetter(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("nativeGetter"), value);
    }
};

/* Object internal property descriptor. This property isn't normally visible in JavaScript code. */
class InternalPropertyDescriptor : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        NameSet = 1 << 0,
        AllFieldsSet = (NameSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*InternalPropertyDescriptor*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class InternalPropertyDescriptor;
    public:

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Ref<InternalPropertyDescriptor> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(InternalPropertyDescriptor) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<InternalPropertyDescriptor>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<InternalPropertyDescriptor> result = InternalPropertyDescriptor::create()
     *     .setName(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setValue(RefPtr<Inspector::Protocol::Runtime::RemoteObject> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("value"), WTFMove(value));
    }
};

/* Represents function call argument. Either remote object id <code>objectId</code> or primitive <code>value</code> or neither of (for undefined) them should be specified. */
class CallArgument : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CallArgument*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CallArgument;
    public:

        Ref<CallArgument> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CallArgument) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CallArgument>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CallArgument> result = CallArgument::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setValue(RefPtr<Inspector::InspectorValue> value)
    {
        InspectorObjectBase::setValue(ASCIILiteral("value"), WTFMove(value));
    }

    void setObjectId(const Inspector::Protocol::Runtime::RemoteObjectId& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("objectId"), value);
    }
};

/* Description of an isolated world. */
class ExecutionContextDescription : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        IsPageContextSet = 1 << 1,
        NameSet = 1 << 2,
        FrameIdSet = 1 << 3,
        AllFieldsSet = (IdSet | IsPageContextSet | NameSet | FrameIdSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExecutionContextDescription*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ExecutionContextDescription;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setInteger(ASCIILiteral("id"), value);
            return castState<IdSet>();
        }

        Builder<STATE | IsPageContextSet>& setIsPageContext(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsPageContextSet), property_isPageContext_already_set);
            m_result->setBoolean(ASCIILiteral("isPageContext"), value);
            return castState<IsPageContextSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | FrameIdSet>& setFrameId(const Inspector::Protocol::Network::FrameId& value)
        {
            COMPILE_ASSERT(!(STATE & FrameIdSet), property_frameId_already_set);
            m_result->setString(ASCIILiteral("frameId"), value);
            return castState<FrameIdSet>();
        }

        Ref<ExecutionContextDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExecutionContextDescription) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ExecutionContextDescription>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExecutionContextDescription> result = ExecutionContextDescription::create()
     *     .setId(...)
     *     .setIsPageContext(...)
     *     .setName(...)
     *     .setFrameId(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Syntax error type: "none" for no error, "irrecoverable" for unrecoverable errors, "unterminated-literal" for when there is an unterminated literal, "recoverable" for when the expression is unfinished but valid so far. */
enum class SyntaxErrorType {
    None = 106,
    Irrecoverable = 107,
    UnterminatedLiteral = 108,
    Recoverable = 109,
}; // enum class SyntaxErrorType
/* Range of an error in source code. */
class ErrorRange : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ErrorRange*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ErrorRange;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setInteger(ASCIILiteral("startOffset"), value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setInteger(ASCIILiteral("endOffset"), value);
            return castState<EndOffsetSet>();
        }

        Ref<ErrorRange> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ErrorRange) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ErrorRange>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ErrorRange> result = ErrorRange::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class StructureDescription : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        AllFieldsSet = 0
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StructureDescription*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StructureDescription;
    public:

        Ref<StructureDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StructureDescription) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<StructureDescription>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StructureDescription> result = StructureDescription::create()
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setFields(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("fields"), WTFMove(value));
    }

    void setOptionalFields(RefPtr<Inspector::Protocol::Array<String>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("optionalFields"), WTFMove(value));
    }

    void setConstructorName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("constructorName"), value);
    }

    void setPrototypeStructure(RefPtr<Inspector::Protocol::Runtime::StructureDescription> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("prototypeStructure"), WTFMove(value));
    }

    void setIsImprecise(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isImprecise"), value);
    }
};

class TypeSet : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsFunctionSet = 1 << 0,
        IsUndefinedSet = 1 << 1,
        IsNullSet = 1 << 2,
        IsBooleanSet = 1 << 3,
        IsIntegerSet = 1 << 4,
        IsNumberSet = 1 << 5,
        IsStringSet = 1 << 6,
        IsObjectSet = 1 << 7,
        IsSymbolSet = 1 << 8,
        AllFieldsSet = (IsFunctionSet | IsUndefinedSet | IsNullSet | IsBooleanSet | IsIntegerSet | IsNumberSet | IsStringSet | IsObjectSet | IsSymbolSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeSet*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeSet;
    public:

        Builder<STATE | IsFunctionSet>& setIsFunction(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsFunctionSet), property_isFunction_already_set);
            m_result->setBoolean(ASCIILiteral("isFunction"), value);
            return castState<IsFunctionSet>();
        }

        Builder<STATE | IsUndefinedSet>& setIsUndefined(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsUndefinedSet), property_isUndefined_already_set);
            m_result->setBoolean(ASCIILiteral("isUndefined"), value);
            return castState<IsUndefinedSet>();
        }

        Builder<STATE | IsNullSet>& setIsNull(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsNullSet), property_isNull_already_set);
            m_result->setBoolean(ASCIILiteral("isNull"), value);
            return castState<IsNullSet>();
        }

        Builder<STATE | IsBooleanSet>& setIsBoolean(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsBooleanSet), property_isBoolean_already_set);
            m_result->setBoolean(ASCIILiteral("isBoolean"), value);
            return castState<IsBooleanSet>();
        }

        Builder<STATE | IsIntegerSet>& setIsInteger(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsIntegerSet), property_isInteger_already_set);
            m_result->setBoolean(ASCIILiteral("isInteger"), value);
            return castState<IsIntegerSet>();
        }

        Builder<STATE | IsNumberSet>& setIsNumber(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsNumberSet), property_isNumber_already_set);
            m_result->setBoolean(ASCIILiteral("isNumber"), value);
            return castState<IsNumberSet>();
        }

        Builder<STATE | IsStringSet>& setIsString(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsStringSet), property_isString_already_set);
            m_result->setBoolean(ASCIILiteral("isString"), value);
            return castState<IsStringSet>();
        }

        Builder<STATE | IsObjectSet>& setIsObject(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsObjectSet), property_isObject_already_set);
            m_result->setBoolean(ASCIILiteral("isObject"), value);
            return castState<IsObjectSet>();
        }

        Builder<STATE | IsSymbolSet>& setIsSymbol(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsSymbolSet), property_isSymbol_already_set);
            m_result->setBoolean(ASCIILiteral("isSymbol"), value);
            return castState<IsSymbolSet>();
        }

        Ref<TypeSet> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeSet) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<TypeSet>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeSet> result = TypeSet::create()
     *     .setIsFunction(...)
     *     .setIsUndefined(...)
     *     .setIsNull(...)
     *     .setIsBoolean(...)
     *     .setIsInteger(...)
     *     .setIsNumber(...)
     *     .setIsString(...)
     *     .setIsObject(...)
     *     .setIsSymbol(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* Container for type information that has been gathered. */
class TypeDescription : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IsValidSet = 1 << 0,
        AllFieldsSet = (IsValidSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeDescription*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeDescription;
    public:

        Builder<STATE | IsValidSet>& setIsValid(bool value)
        {
            COMPILE_ASSERT(!(STATE & IsValidSet), property_isValid_already_set);
            m_result->setBoolean(ASCIILiteral("isValid"), value);
            return castState<IsValidSet>();
        }

        Ref<TypeDescription> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeDescription) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<TypeDescription>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeDescription> result = TypeDescription::create()
     *     .setIsValid(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setLeastCommonAncestor(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("leastCommonAncestor"), value);
    }

    void setTypeSet(RefPtr<Inspector::Protocol::Runtime::TypeSet> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("typeSet"), WTFMove(value));
    }

    void setStructures(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Runtime::StructureDescription>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("structures"), WTFMove(value));
    }

    void setIsTruncated(bool value)
    {
        InspectorObjectBase::setBoolean(ASCIILiteral("isTruncated"), value);
    }
};

/* Describes the location of an expression we want type information for. */
class TypeLocation : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TypeInformationDescriptorSet = 1 << 0,
        SourceIDSet = 1 << 1,
        DivotSet = 1 << 2,
        AllFieldsSet = (TypeInformationDescriptorSet | SourceIDSet | DivotSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TypeLocation*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TypeLocation;
    public:

        Builder<STATE | TypeInformationDescriptorSet>& setTypeInformationDescriptor(int value)
        {
            COMPILE_ASSERT(!(STATE & TypeInformationDescriptorSet), property_typeInformationDescriptor_already_set);
            m_result->setInteger(ASCIILiteral("typeInformationDescriptor"), value);
            return castState<TypeInformationDescriptorSet>();
        }

        Builder<STATE | SourceIDSet>& setSourceID(const String& value)
        {
            COMPILE_ASSERT(!(STATE & SourceIDSet), property_sourceID_already_set);
            m_result->setString(ASCIILiteral("sourceID"), value);
            return castState<SourceIDSet>();
        }

        Builder<STATE | DivotSet>& setDivot(int value)
        {
            COMPILE_ASSERT(!(STATE & DivotSet), property_divot_already_set);
            m_result->setInteger(ASCIILiteral("divot"), value);
            return castState<DivotSet>();
        }

        Ref<TypeLocation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TypeLocation) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<TypeLocation>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TypeLocation> result = TypeLocation::create()
     *     .setTypeInformationDescriptor(...)
     *     .setSourceID(...)
     *     .setDivot(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* From Wikipedia: a basic block is a portion of the code within a program with only one entry point and only one exit point. This type gives the location of a basic block and if that basic block has executed. */
class BasicBlock : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartOffsetSet = 1 << 0,
        EndOffsetSet = 1 << 1,
        HasExecutedSet = 1 << 2,
        ExecutionCountSet = 1 << 3,
        AllFieldsSet = (StartOffsetSet | EndOffsetSet | HasExecutedSet | ExecutionCountSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*BasicBlock*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class BasicBlock;
    public:

        Builder<STATE | StartOffsetSet>& setStartOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & StartOffsetSet), property_startOffset_already_set);
            m_result->setInteger(ASCIILiteral("startOffset"), value);
            return castState<StartOffsetSet>();
        }

        Builder<STATE | EndOffsetSet>& setEndOffset(int value)
        {
            COMPILE_ASSERT(!(STATE & EndOffsetSet), property_endOffset_already_set);
            m_result->setInteger(ASCIILiteral("endOffset"), value);
            return castState<EndOffsetSet>();
        }

        Builder<STATE | HasExecutedSet>& setHasExecuted(bool value)
        {
            COMPILE_ASSERT(!(STATE & HasExecutedSet), property_hasExecuted_already_set);
            m_result->setBoolean(ASCIILiteral("hasExecuted"), value);
            return castState<HasExecutedSet>();
        }

        Builder<STATE | ExecutionCountSet>& setExecutionCount(int value)
        {
            COMPILE_ASSERT(!(STATE & ExecutionCountSet), property_executionCount_already_set);
            m_result->setInteger(ASCIILiteral("executionCount"), value);
            return castState<ExecutionCountSet>();
        }

        Ref<BasicBlock> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(BasicBlock) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<BasicBlock>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<BasicBlock> result = BasicBlock::create()
     *     .setStartOffset(...)
     *     .setEndOffset(...)
     *     .setHasExecuted(...)
     *     .setExecutionCount(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // Runtime

namespace ScriptProfiler {
/*  */
enum class EventType {
    API = 110,
    Microtask = 111,
    Other = 87,
}; // enum class EventType
class Event : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        StartTimeSet = 1 << 0,
        EndTimeSet = 1 << 1,
        TypeSet = 1 << 2,
        AllFieldsSet = (StartTimeSet | EndTimeSet | TypeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Event*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Event;
    public:

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble(ASCIILiteral("startTime"), value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setDouble(ASCIILiteral("endTime"), value);
            return castState<EndTimeSet>();
        }

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::ScriptProfiler::EventType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Ref<Event> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Event) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Event>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Event> result = Event::create()
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .setType(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class ExpressionLocation : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        LineSet = 1 << 0,
        ColumnSet = 1 << 1,
        AllFieldsSet = (LineSet | ColumnSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*ExpressionLocation*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class ExpressionLocation;
    public:

        Builder<STATE | LineSet>& setLine(int value)
        {
            COMPILE_ASSERT(!(STATE & LineSet), property_line_already_set);
            m_result->setInteger(ASCIILiteral("line"), value);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnSet), property_column_already_set);
            m_result->setInteger(ASCIILiteral("column"), value);
            return castState<ColumnSet>();
        }

        Ref<ExpressionLocation> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(ExpressionLocation) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<ExpressionLocation>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<ExpressionLocation> result = ExpressionLocation::create()
     *     .setLine(...)
     *     .setColumn(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class StackFrame : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        SourceIDSet = 1 << 0,
        NameSet = 1 << 1,
        LineSet = 1 << 2,
        ColumnSet = 1 << 3,
        UrlSet = 1 << 4,
        AllFieldsSet = (SourceIDSet | NameSet | LineSet | ColumnSet | UrlSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackFrame*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StackFrame;
    public:

        Builder<STATE | SourceIDSet>& setSourceID(const Inspector::Protocol::Debugger::ScriptId& value)
        {
            COMPILE_ASSERT(!(STATE & SourceIDSet), property_sourceID_already_set);
            m_result->setString(ASCIILiteral("sourceID"), value);
            return castState<SourceIDSet>();
        }

        Builder<STATE | NameSet>& setName(const String& value)
        {
            COMPILE_ASSERT(!(STATE & NameSet), property_name_already_set);
            m_result->setString(ASCIILiteral("name"), value);
            return castState<NameSet>();
        }

        Builder<STATE | LineSet>& setLine(int value)
        {
            COMPILE_ASSERT(!(STATE & LineSet), property_line_already_set);
            m_result->setInteger(ASCIILiteral("line"), value);
            return castState<LineSet>();
        }

        Builder<STATE | ColumnSet>& setColumn(int value)
        {
            COMPILE_ASSERT(!(STATE & ColumnSet), property_column_already_set);
            m_result->setInteger(ASCIILiteral("column"), value);
            return castState<ColumnSet>();
        }

        Builder<STATE | UrlSet>& setUrl(const String& value)
        {
            COMPILE_ASSERT(!(STATE & UrlSet), property_url_already_set);
            m_result->setString(ASCIILiteral("url"), value);
            return castState<UrlSet>();
        }

        Ref<StackFrame> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackFrame) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<StackFrame>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackFrame> result = StackFrame::create()
     *     .setSourceID(...)
     *     .setName(...)
     *     .setLine(...)
     *     .setColumn(...)
     *     .setUrl(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setExpressionLocation(RefPtr<Inspector::Protocol::ScriptProfiler::ExpressionLocation> value)
    {
        InspectorObjectBase::setObject(ASCIILiteral("expressionLocation"), WTFMove(value));
    }
};

class StackTrace : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TimestampSet = 1 << 0,
        StackFramesSet = 1 << 1,
        AllFieldsSet = (TimestampSet | StackFramesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*StackTrace*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class StackTrace;
    public:

        Builder<STATE | TimestampSet>& setTimestamp(double value)
        {
            COMPILE_ASSERT(!(STATE & TimestampSet), property_timestamp_already_set);
            m_result->setDouble(ASCIILiteral("timestamp"), value);
            return castState<TimestampSet>();
        }

        Builder<STATE | StackFramesSet>& setStackFrames(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::ScriptProfiler::StackFrame>> value)
        {
            COMPILE_ASSERT(!(STATE & StackFramesSet), property_stackFrames_already_set);
            m_result->setArray(ASCIILiteral("stackFrames"), value);
            return castState<StackFramesSet>();
        }

        Ref<StackTrace> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(StackTrace) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<StackTrace>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<StackTrace> result = StackTrace::create()
     *     .setTimestamp(...)
     *     .setStackFrames(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

class Samples : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        TotalTimeSet = 1 << 0,
        StackTracesSet = 1 << 1,
        AllFieldsSet = (TotalTimeSet | StackTracesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*Samples*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class Samples;
    public:

        Builder<STATE | TotalTimeSet>& setTotalTime(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalTimeSet), property_totalTime_already_set);
            m_result->setDouble(ASCIILiteral("totalTime"), value);
            return castState<TotalTimeSet>();
        }

        Builder<STATE | StackTracesSet>& setStackTraces(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::ScriptProfiler::StackTrace>> value)
        {
            COMPILE_ASSERT(!(STATE & StackTracesSet), property_stackTraces_already_set);
            m_result->setArray(ASCIILiteral("stackTraces"), value);
            return castState<StackTracesSet>();
        }

        Ref<Samples> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(Samples) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<Samples>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<Samples> result = Samples::create()
     *     .setTotalTime(...)
     *     .setStackTraces(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

} // ScriptProfiler

namespace Timeline {
/* Timeline record type. */
enum class EventType {
    EventDispatch = 112,
    ScheduleStyleRecalculation = 113,
    RecalculateStyles = 114,
    InvalidateLayout = 115,
    Layout = 116,
    Paint = 117,
    Composite = 118,
    RenderingFrame = 119,
    TimerInstall = 120,
    TimerRemove = 121,
    TimerFire = 122,
    EvaluateScript = 123,
    TimeStamp = 124,
    Time = 125,
    TimeEnd = 126,
    FunctionCall = 127,
    ProbeSample = 128,
    ConsoleProfile = 129,
    RequestAnimationFrame = 130,
    CancelAnimationFrame = 131,
    FireAnimationFrame = 132,
}; // enum class EventType
/* Timeline record contains information about the recorded activity. */
class TimelineEvent : public Inspector::InspectorObject {
public:
    enum {
        NoFieldsSet = 0,
        TypeSet = 1 << 0,
        DataSet = 1 << 1,
        AllFieldsSet = (TypeSet | DataSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*TimelineEvent*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class TimelineEvent;
    public:

        Builder<STATE | TypeSet>& setType(Inspector::Protocol::Timeline::EventType value)
        {
            COMPILE_ASSERT(!(STATE & TypeSet), property_type_already_set);
            m_result->setString(ASCIILiteral("type"), Inspector::Protocol::getEnumConstantValue(static_cast<int>(value)));
            return castState<TypeSet>();
        }

        Builder<STATE | DataSet>& setData(RefPtr<Inspector::InspectorObject> value)
        {
            COMPILE_ASSERT(!(STATE & DataSet), property_data_already_set);
            m_result->setObject(ASCIILiteral("data"), value);
            return castState<DataSet>();
        }

        Ref<TimelineEvent> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(TimelineEvent) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<TimelineEvent>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<TimelineEvent> result = TimelineEvent::create()
     *     .setType(...)
     *     .setData(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setChildren(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Timeline::TimelineEvent>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("children"), WTFMove(value));
    }

    // Property names for type generated as open.
    JS_EXPORT_PRIVATE static const char* Type;
    JS_EXPORT_PRIVATE static const char* Data;
    JS_EXPORT_PRIVATE static const char* Children;
};

/* Aggregate CPU Profile call info. Holds time information for all the calls that happened on a node. */
class CPUProfileNodeAggregateCallInfo : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        CallCountSet = 1 << 0,
        StartTimeSet = 1 << 1,
        EndTimeSet = 1 << 2,
        TotalTimeSet = 1 << 3,
        AllFieldsSet = (CallCountSet | StartTimeSet | EndTimeSet | TotalTimeSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CPUProfileNodeAggregateCallInfo*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CPUProfileNodeAggregateCallInfo;
    public:

        Builder<STATE | CallCountSet>& setCallCount(double value)
        {
            COMPILE_ASSERT(!(STATE & CallCountSet), property_callCount_already_set);
            m_result->setDouble(ASCIILiteral("callCount"), value);
            return castState<CallCountSet>();
        }

        Builder<STATE | StartTimeSet>& setStartTime(double value)
        {
            COMPILE_ASSERT(!(STATE & StartTimeSet), property_startTime_already_set);
            m_result->setDouble(ASCIILiteral("startTime"), value);
            return castState<StartTimeSet>();
        }

        Builder<STATE | EndTimeSet>& setEndTime(double value)
        {
            COMPILE_ASSERT(!(STATE & EndTimeSet), property_endTime_already_set);
            m_result->setDouble(ASCIILiteral("endTime"), value);
            return castState<EndTimeSet>();
        }

        Builder<STATE | TotalTimeSet>& setTotalTime(double value)
        {
            COMPILE_ASSERT(!(STATE & TotalTimeSet), property_totalTime_already_set);
            m_result->setDouble(ASCIILiteral("totalTime"), value);
            return castState<TotalTimeSet>();
        }

        Ref<CPUProfileNodeAggregateCallInfo> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfileNodeAggregateCallInfo) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CPUProfileNodeAggregateCallInfo>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CPUProfileNodeAggregateCallInfo> result = CPUProfileNodeAggregateCallInfo::create()
     *     .setCallCount(...)
     *     .setStartTime(...)
     *     .setEndTime(...)
     *     .setTotalTime(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }
};

/* CPU Profile node. Holds callsite information, execution statistics and child nodes. */
class CPUProfileNode : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        IdSet = 1 << 0,
        CallInfoSet = 1 << 1,
        AllFieldsSet = (IdSet | CallInfoSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CPUProfileNode*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CPUProfileNode;
    public:

        Builder<STATE | IdSet>& setId(int value)
        {
            COMPILE_ASSERT(!(STATE & IdSet), property_id_already_set);
            m_result->setInteger(ASCIILiteral("id"), value);
            return castState<IdSet>();
        }

        Builder<STATE | CallInfoSet>& setCallInfo(RefPtr<Inspector::Protocol::Timeline::CPUProfileNodeAggregateCallInfo> value)
        {
            COMPILE_ASSERT(!(STATE & CallInfoSet), property_callInfo_already_set);
            m_result->setObject(ASCIILiteral("callInfo"), value);
            return castState<CallInfoSet>();
        }

        Ref<CPUProfileNode> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfileNode) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CPUProfileNode>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CPUProfileNode> result = CPUProfileNode::create()
     *     .setId(...)
     *     .setCallInfo(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setFunctionName(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("functionName"), value);
    }

    void setUrl(const String& value)
    {
        InspectorObjectBase::setString(ASCIILiteral("url"), value);
    }

    void setLineNumber(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("lineNumber"), value);
    }

    void setColumnNumber(int value)
    {
        InspectorObjectBase::setInteger(ASCIILiteral("columnNumber"), value);
    }

    void setChildren(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Timeline::CPUProfileNode>> value)
    {
        InspectorObjectBase::setArray(ASCIILiteral("children"), WTFMove(value));
    }
};

/* Profile. */
class CPUProfile : public Inspector::InspectorObjectBase {
public:
    enum {
        NoFieldsSet = 0,
        RootNodesSet = 1 << 0,
        AllFieldsSet = (RootNodesSet)
    };

    template<int STATE>
    class Builder {
    private:
        RefPtr<InspectorObject> m_result;

        template<int STEP> Builder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<Builder<STATE | STEP>*>(this);
        }

        Builder(Ref</*CPUProfile*/InspectorObject>&& object)
            : m_result(WTFMove(object))
        {
            COMPILE_ASSERT(STATE == NoFieldsSet, builder_created_in_non_init_state);
        }
        friend class CPUProfile;
    public:

        Builder<STATE | RootNodesSet>& setRootNodes(RefPtr<Inspector::Protocol::Array<Inspector::Protocol::Timeline::CPUProfileNode>> value)
        {
            COMPILE_ASSERT(!(STATE & RootNodesSet), property_rootNodes_already_set);
            m_result->setArray(ASCIILiteral("rootNodes"), value);
            return castState<RootNodesSet>();
        }

        Ref<CPUProfile> release()
        {
            COMPILE_ASSERT(STATE == AllFieldsSet, result_is_not_ready);
            COMPILE_ASSERT(sizeof(CPUProfile) == sizeof(InspectorObject), cannot_cast);

            Ref<InspectorObject> result = m_result.releaseNonNull();
            return WTFMove(*reinterpret_cast<Ref<CPUProfile>*>(&result));
        }
    };

    /*
     * Synthetic constructor:
     * Ref<CPUProfile> result = CPUProfile::create()
     *     .setRootNodes(...)
     *     .release();
     */
    static Builder<NoFieldsSet> create()
    {
        return Builder<NoFieldsSet>(InspectorObject::create());
    }

    void setIdleTime(double value)
    {
        InspectorObjectBase::setDouble(ASCIILiteral("idleTime"), value);
    }
};

} // Timeline

template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Location> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::FunctionDetails> {
static RefPtr<Inspector::Protocol::Debugger::FunctionDetails> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::CallFrame> {
static RefPtr<Inspector::Protocol::Debugger::CallFrame> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Scope::Type> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Debugger::Scope> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::RemoteObject> {
static RefPtr<Inspector::Protocol::Runtime::RemoteObject> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::ObjectPreview> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyPreview> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::EntryPreview> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::CollectionEntry> {
static RefPtr<Inspector::Protocol::Runtime::CollectionEntry> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor> {
static RefPtr<Inspector::Protocol::Runtime::PropertyDescriptor> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor> {
static RefPtr<Inspector::Protocol::Runtime::InternalPropertyDescriptor> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Timeline::EventType> {
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};
template<> struct JS_EXPORT_PRIVATE BindingTraits<Inspector::Protocol::Timeline::TimelineEvent> {
static RefPtr<Inspector::Protocol::Timeline::TimelineEvent> runtimeCast(RefPtr<Inspector::InspectorValue>&& value);
#if !ASSERT_DISABLED
static void assertValueHasExpectedType(Inspector::InspectorValue*);
#endif // !ASSERT_DISABLED
};

} // namespace Protocol

} // namespace Inspector

#endif // !defined(InspectorProtocolObjects_h)
