/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSPrimitiveValue.h"

#include "Counter.h"
#include "ExceptionCode.h"
#include "JSCounter.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSRGBColor.h"
#include "JSRect.h"
#include "RGBColor.h"
#include "Rect.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetFloatValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetFloatValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetStringValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetStringValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetCounterValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRectValue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRGBColorValue(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsCSSPrimitiveValuePrimitiveType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSPrimitiveValuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSPrimitiveValuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSPrimitiveValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSPrimitiveValuePrototype>(vm.heap)) JSCSSPrimitiveValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSPrimitiveValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSPrimitiveValue> JSCSSPrimitiveValueConstructor;

/* Hash table for constructor */

static const HashTableValue JSCSSPrimitiveValueConstructorTableValues[] =
{
    { "CSS_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_NUMBER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_PERCENTAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_EMS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_EXS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_PX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_CM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_MM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_PT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_PC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_DEG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_RAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_GRAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_MS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_S", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_HZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_KHZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_DIMENSION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_STRING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_URI", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_IDENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(21) } },
    { "CSS_ATTR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(22) } },
    { "CSS_COUNTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(23) } },
    { "CSS_RECT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(24) } },
    { "CSS_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(25) } },
    { "CSS_VW", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(26) } },
    { "CSS_VH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(27) } },
    { "CSS_VMIN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(28) } },
    { "CSS_VMAX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(29) } },
};


COMPILE_ASSERT(0 == CSSPrimitiveValue::CSS_UNKNOWN, CSSPrimitiveValueEnumCSS_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSPrimitiveValue::CSS_NUMBER, CSSPrimitiveValueEnumCSS_NUMBERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSPrimitiveValue::CSS_PERCENTAGE, CSSPrimitiveValueEnumCSS_PERCENTAGEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSPrimitiveValue::CSS_EMS, CSSPrimitiveValueEnumCSS_EMSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == CSSPrimitiveValue::CSS_EXS, CSSPrimitiveValueEnumCSS_EXSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == CSSPrimitiveValue::CSS_PX, CSSPrimitiveValueEnumCSS_PXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == CSSPrimitiveValue::CSS_CM, CSSPrimitiveValueEnumCSS_CMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == CSSPrimitiveValue::CSS_MM, CSSPrimitiveValueEnumCSS_MMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == CSSPrimitiveValue::CSS_IN, CSSPrimitiveValueEnumCSS_INIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == CSSPrimitiveValue::CSS_PT, CSSPrimitiveValueEnumCSS_PTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == CSSPrimitiveValue::CSS_PC, CSSPrimitiveValueEnumCSS_PCIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(11 == CSSPrimitiveValue::CSS_DEG, CSSPrimitiveValueEnumCSS_DEGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(12 == CSSPrimitiveValue::CSS_RAD, CSSPrimitiveValueEnumCSS_RADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(13 == CSSPrimitiveValue::CSS_GRAD, CSSPrimitiveValueEnumCSS_GRADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(14 == CSSPrimitiveValue::CSS_MS, CSSPrimitiveValueEnumCSS_MSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == CSSPrimitiveValue::CSS_S, CSSPrimitiveValueEnumCSS_SIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == CSSPrimitiveValue::CSS_HZ, CSSPrimitiveValueEnumCSS_HZIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(17 == CSSPrimitiveValue::CSS_KHZ, CSSPrimitiveValueEnumCSS_KHZIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(18 == CSSPrimitiveValue::CSS_DIMENSION, CSSPrimitiveValueEnumCSS_DIMENSIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(19 == CSSPrimitiveValue::CSS_STRING, CSSPrimitiveValueEnumCSS_STRINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(20 == CSSPrimitiveValue::CSS_URI, CSSPrimitiveValueEnumCSS_URIIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(21 == CSSPrimitiveValue::CSS_IDENT, CSSPrimitiveValueEnumCSS_IDENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(22 == CSSPrimitiveValue::CSS_ATTR, CSSPrimitiveValueEnumCSS_ATTRIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(23 == CSSPrimitiveValue::CSS_COUNTER, CSSPrimitiveValueEnumCSS_COUNTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(24 == CSSPrimitiveValue::CSS_RECT, CSSPrimitiveValueEnumCSS_RECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(25 == CSSPrimitiveValue::CSS_RGBCOLOR, CSSPrimitiveValueEnumCSS_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(26 == CSSPrimitiveValue::CSS_VW, CSSPrimitiveValueEnumCSS_VWIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(27 == CSSPrimitiveValue::CSS_VH, CSSPrimitiveValueEnumCSS_VHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(28 == CSSPrimitiveValue::CSS_VMIN, CSSPrimitiveValueEnumCSS_VMINIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(29 == CSSPrimitiveValue::CSS_VMAX, CSSPrimitiveValueEnumCSS_VMAXIsWrongUseDoNotCheckConstants);

template<> JSValue JSCSSPrimitiveValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSPrimitiveValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSPrimitiveValue::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSPrimitiveValue"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSCSSPrimitiveValueConstructorTableValues, *this);
}

template<> const ClassInfo JSCSSPrimitiveValueConstructor::s_info = { "CSSPrimitiveValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSPrimitiveValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSPrimitiveValuePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSPrimitiveValueConstructor) } },
    { "primitiveType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValuePrimitiveType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setFloatValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionSetFloatValue), (intptr_t) (0) } },
    { "getFloatValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetFloatValue), (intptr_t) (0) } },
    { "setStringValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionSetStringValue), (intptr_t) (0) } },
    { "getStringValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetStringValue), (intptr_t) (0) } },
    { "getCounterValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetCounterValue), (intptr_t) (0) } },
    { "getRectValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetRectValue), (intptr_t) (0) } },
    { "getRGBColorValue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetRGBColorValue), (intptr_t) (0) } },
    { "CSS_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_NUMBER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_PERCENTAGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_EMS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_EXS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_PX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_CM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_MM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_IN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_PT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_PC", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_DEG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_RAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_GRAD", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_MS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_S", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_HZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_KHZ", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_DIMENSION", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_STRING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_URI", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_IDENT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(21) } },
    { "CSS_ATTR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(22) } },
    { "CSS_COUNTER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(23) } },
    { "CSS_RECT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(24) } },
    { "CSS_RGBCOLOR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(25) } },
    { "CSS_VW", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(26) } },
    { "CSS_VH", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(27) } },
    { "CSS_VMIN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(28) } },
    { "CSS_VMAX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(29) } },
};

const ClassInfo JSCSSPrimitiveValuePrototype::s_info = { "CSSPrimitiveValuePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSPrimitiveValuePrototype) };

void JSCSSPrimitiveValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSPrimitiveValuePrototypeTableValues, *this);
}

const ClassInfo JSCSSPrimitiveValue::s_info = { "CSSPrimitiveValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSPrimitiveValue) };

JSCSSPrimitiveValue::JSCSSPrimitiveValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSPrimitiveValue>&& impl)
    : JSCSSValue(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSPrimitiveValue::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSPrimitiveValuePrototype::create(vm, globalObject, JSCSSPrimitiveValuePrototype::createStructure(vm, globalObject, JSCSSValue::getPrototype(vm, globalObject)));
}

JSObject* JSCSSPrimitiveValue::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSPrimitiveValue>(vm, globalObject);
}

EncodedJSValue jsCSSPrimitiveValuePrimitiveType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSPrimitiveValue", "primitiveType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.primitiveType());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSPrimitiveValueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSPrimitiveValuePrototype* domObject = jsDynamicCast<JSCSSPrimitiveValuePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSPrimitiveValue::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSPrimitiveValueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSPrimitiveValuePrototype* domObject = jsDynamicCast<JSCSSPrimitiveValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCSSPrimitiveValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSPrimitiveValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetFloatValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "setFloatValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    uint16_t unitType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float floatValue = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setFloatValue(unitType, floatValue, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetFloatValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "getFloatValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    uint16_t unitType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.getFloatValue(unitType, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetStringValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "setStringValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    uint16_t stringType = toUInt16(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String stringValue = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setStringValue(stringType, stringValue, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetStringValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "getStringValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = jsStringWithCache(state, impl.getStringValue(ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetCounterValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "getCounterValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getCounterValue(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRectValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "getRectValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getRectValue(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRGBColorValue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSCSSPrimitiveValue*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "CSSPrimitiveValue", "getRGBColorValue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSCSSPrimitiveValue::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getRGBColorValue(ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}


}
