/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTFragDepth.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSEXTFragDepthPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEXTFragDepthPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTFragDepthPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTFragDepthPrototype>(vm.heap)) JSEXTFragDepthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTFragDepthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};

/* Hash table for prototype */
const ClassInfo JSEXTFragDepthPrototype::s_info = { "EXTFragDepthPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTFragDepthPrototype) };

const ClassInfo JSEXTFragDepth::s_info = { "EXTFragDepth", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTFragDepth) };

JSEXTFragDepth::JSEXTFragDepth(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTFragDepth>&& impl)
    : JSDOMWrapper<EXTFragDepth>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEXTFragDepth::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEXTFragDepthPrototype::create(vm, globalObject, JSEXTFragDepthPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSEXTFragDepth::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEXTFragDepth>(vm, globalObject);
}

void JSEXTFragDepth::destroy(JSC::JSCell* cell)
{
    JSEXTFragDepth* thisObject = static_cast<JSEXTFragDepth*>(cell);
    thisObject->JSEXTFragDepth::~JSEXTFragDepth();
}

bool JSEXTFragDepthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsEXTFragDepth = jsCast<JSEXTFragDepth*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsEXTFragDepth->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSEXTFragDepthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTFragDepth = jsCast<JSEXTFragDepth*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTFragDepth->wrapped(), jsEXTFragDepth);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTFragDepth@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12EXTFragDepthE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTFragDepth* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSEXTFragDepth>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTFragDepth* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEXTFragDepth>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7EXTFragDepth@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12EXTFragDepthE[2];
#if COMPILER(CLANG)
    // If this fails EXTFragDepth does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(EXTFragDepth), EXTFragDepth_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // EXTFragDepth has subclasses. If EXTFragDepth has subclasses that get passed
    // to toJS() we currently require EXTFragDepth you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSEXTFragDepth>(globalObject, impl);
}

EXTFragDepth* JSEXTFragDepth::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTFragDepth*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
