/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureFilterAnisotropic.h"

#include "JSDOMBinding.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

class JSEXTTextureFilterAnisotropicPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEXTTextureFilterAnisotropicPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureFilterAnisotropicPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureFilterAnisotropicPrototype>(vm.heap)) JSEXTTextureFilterAnisotropicPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureFilterAnisotropicPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSEXTTextureFilterAnisotropicPrototypeTableValues[] =
{
    { "TEXTURE_MAX_ANISOTROPY_EXT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x84FE) } },
    { "MAX_TEXTURE_MAX_ANISOTROPY_EXT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0x84FF) } },
};

const ClassInfo JSEXTTextureFilterAnisotropicPrototype::s_info = { "EXTTextureFilterAnisotropicPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTTextureFilterAnisotropicPrototype) };

void JSEXTTextureFilterAnisotropicPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureFilterAnisotropicPrototypeTableValues, *this);
}

const ClassInfo JSEXTTextureFilterAnisotropic::s_info = { "EXTTextureFilterAnisotropic", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEXTTextureFilterAnisotropic) };

JSEXTTextureFilterAnisotropic::JSEXTTextureFilterAnisotropic(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureFilterAnisotropic>&& impl)
    : JSDOMWrapper<EXTTextureFilterAnisotropic>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEXTTextureFilterAnisotropic::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEXTTextureFilterAnisotropicPrototype::create(vm, globalObject, JSEXTTextureFilterAnisotropicPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSEXTTextureFilterAnisotropic::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEXTTextureFilterAnisotropic>(vm, globalObject);
}

void JSEXTTextureFilterAnisotropic::destroy(JSC::JSCell* cell)
{
    JSEXTTextureFilterAnisotropic* thisObject = static_cast<JSEXTTextureFilterAnisotropic*>(cell);
    thisObject->JSEXTTextureFilterAnisotropic::~JSEXTTextureFilterAnisotropic();
}

bool JSEXTTextureFilterAnisotropicOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsEXTTextureFilterAnisotropic = jsCast<JSEXTTextureFilterAnisotropic*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsEXTTextureFilterAnisotropic->wrapped().context());
    return visitor.containsOpaqueRoot(root);
}

void JSEXTTextureFilterAnisotropicOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureFilterAnisotropic = jsCast<JSEXTTextureFilterAnisotropic*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTTextureFilterAnisotropic->wrapped(), jsEXTTextureFilterAnisotropic);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureFilterAnisotropic@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27EXTTextureFilterAnisotropicE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTTextureFilterAnisotropic* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSEXTTextureFilterAnisotropic>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, EXTTextureFilterAnisotropic* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEXTTextureFilterAnisotropic>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7EXTTextureFilterAnisotropic@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27EXTTextureFilterAnisotropicE[2];
#if COMPILER(CLANG)
    // If this fails EXTTextureFilterAnisotropic does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(EXTTextureFilterAnisotropic), EXTTextureFilterAnisotropic_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // EXTTextureFilterAnisotropic has subclasses. If EXTTextureFilterAnisotropic has subclasses that get passed
    // to toJS() we currently require EXTTextureFilterAnisotropic you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSEXTTextureFilterAnisotropic>(globalObject, impl);
}

EXTTextureFilterAnisotropic* JSEXTTextureFilterAnisotropic::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureFilterAnisotropic*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
