/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEvent.h"

#include "EventTarget.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include "JSEventTarget.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopPropagation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionPreventDefault(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionInitEvent(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopImmediatePropagation(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsEventType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventCurrentTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventEventPhase(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventBubbles(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventCancelable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventTimeStamp(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventDefaultPrevented(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventIsTrusted(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSrcElement(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventReturnValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventReturnValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventCancelBubble(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventCancelBubble(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventClipboardData(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSEventPrototype>(vm.heap)) JSEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSEvent> JSEventConstructor;

/* Hash table */

static const struct CompactHashIndex JSEventTableIndex[2] = {
    { 0, -1 },
    { -1, -1 },
};


static const HashTableValue JSEventTableValues[] =
{
    { "isTrusted", DontDelete | ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventIsTrusted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSEventTable = { 1, 1, true, JSEventTableValues, JSEventTableIndex };
/* Hash table for constructor */

static const HashTableValue JSEventConstructorTableValues[] =
{
    { "NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CAPTURING_PHASE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "AT_TARGET", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "BUBBLING_PHASE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MOUSEDOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MOUSEUP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MOUSEOVER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "MOUSEOUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "MOUSEMOVE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "MOUSEDRAG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(32) } },
    { "CLICK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(64) } },
    { "DBLCLICK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(128) } },
    { "KEYDOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(256) } },
    { "KEYUP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(512) } },
    { "KEYPRESS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1024) } },
    { "DRAGDROP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2048) } },
    { "FOCUS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4096) } },
    { "BLUR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8192) } },
    { "SELECT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16384) } },
    { "CHANGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(32768) } },
};


COMPILE_ASSERT(0 == Event::NONE, EventEnumNONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Event::CAPTURING_PHASE, EventEnumCAPTURING_PHASEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Event::AT_TARGET, EventEnumAT_TARGETIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Event::BUBBLING_PHASE, EventEnumBUBBLING_PHASEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Event::MOUSEDOWN, EventEnumMOUSEDOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Event::MOUSEUP, EventEnumMOUSEUPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == Event::MOUSEOVER, EventEnumMOUSEOVERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == Event::MOUSEOUT, EventEnumMOUSEOUTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == Event::MOUSEMOVE, EventEnumMOUSEMOVEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(32 == Event::MOUSEDRAG, EventEnumMOUSEDRAGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(64 == Event::CLICK, EventEnumCLICKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(128 == Event::DBLCLICK, EventEnumDBLCLICKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(256 == Event::KEYDOWN, EventEnumKEYDOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(512 == Event::KEYUP, EventEnumKEYUPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1024 == Event::KEYPRESS, EventEnumKEYPRESSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2048 == Event::DRAGDROP, EventEnumDRAGDROPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4096 == Event::FOCUS, EventEnumFOCUSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8192 == Event::BLUR, EventEnumBLURIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16384 == Event::SELECT, EventEnumSELECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(32768 == Event::CHANGE, EventEnumCHANGEIsWrongUseDoNotCheckConstants);

template<> EncodedJSValue JSC_HOST_CALL JSEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    EventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<Event> event = Event::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillEventInit(EventInit& eventInit, JSDictionary& dictionary)
{
    if (!dictionary.tryGetProperty("bubbles", eventInit.bubbles))
        return false;
    if (!dictionary.tryGetProperty("cancelable", eventInit.cancelable))
        return false;
    return true;
}

template<> JSValue JSEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Event"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSEventConstructorTableValues, *this);
}

template<> const ClassInfo JSEventConstructor::s_info = { "Event", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTarget", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCurrentTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "eventPhase", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventEventPhase), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bubbles", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBubbles), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cancelable", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCancelable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timeStamp", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventTimeStamp), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultPrevented", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDefaultPrevented), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "srcElement", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSrcElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "returnValue", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventReturnValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventReturnValue) } },
    { "cancelBubble", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCancelBubble), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventCancelBubble) } },
    { "clipboardData", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventClipboardData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stopPropagation", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionStopPropagation), (intptr_t) (0) } },
    { "preventDefault", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionPreventDefault), (intptr_t) (0) } },
    { "initEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionInitEvent), (intptr_t) (0) } },
    { "stopImmediatePropagation", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionStopImmediatePropagation), (intptr_t) (0) } },
    { "NONE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CAPTURING_PHASE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "AT_TARGET", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "BUBBLING_PHASE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MOUSEDOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "MOUSEUP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "MOUSEOVER", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "MOUSEOUT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "MOUSEMOVE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "MOUSEDRAG", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(32) } },
    { "CLICK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(64) } },
    { "DBLCLICK", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(128) } },
    { "KEYDOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(256) } },
    { "KEYUP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(512) } },
    { "KEYPRESS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1024) } },
    { "DRAGDROP", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2048) } },
    { "FOCUS", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4096) } },
    { "BLUR", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(8192) } },
    { "SELECT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(16384) } },
    { "CHANGE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(32768) } },
};

const ClassInfo JSEventPrototype::s_info = { "EventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventPrototype) };

void JSEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEventPrototypeTableValues, *this);
}

const ClassInfo JSEvent::s_info = { "Event", &Base::s_info, &JSEventTable, CREATE_METHOD_TABLE(JSEvent) };

JSEvent::JSEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Event>&& impl)
    : JSDOMWrapper<Event>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEventPrototype::create(vm, globalObject, JSEventPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEvent>(vm, globalObject);
}

void JSEvent::destroy(JSC::JSCell* cell)
{
    JSEvent* thisObject = static_cast<JSEvent*>(cell);
    thisObject->JSEvent::~JSEvent();
}

bool JSEvent::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (getStaticValueSlot<JSEvent, Base>(state, JSEventTable, thisObject, propertyName, slot))
        return true;
    return false;
}

EncodedJSValue jsEventType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "type");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsEventTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.target()));
    return JSValue::encode(result);
}


EncodedJSValue jsEventCurrentTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "currentTarget");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.currentTarget()));
    return JSValue::encode(result);
}


EncodedJSValue jsEventEventPhase(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "eventPhase");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.eventPhase());
    return JSValue::encode(result);
}


EncodedJSValue jsEventBubbles(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "bubbles");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.bubbles());
    return JSValue::encode(result);
}


EncodedJSValue jsEventCancelable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "cancelable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.cancelable());
    return JSValue::encode(result);
}


EncodedJSValue jsEventTimeStamp(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "timeStamp");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.timeStamp());
    return JSValue::encode(result);
}


EncodedJSValue jsEventDefaultPrevented(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "defaultPrevented");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.defaultPrevented());
    return JSValue::encode(result);
}


EncodedJSValue jsEventIsTrusted(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "isTrusted");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.isTrusted());
    return JSValue::encode(result);
}


EncodedJSValue jsEventSrcElement(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "srcElement");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.srcElement()));
    return JSValue::encode(result);
}


EncodedJSValue jsEventReturnValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "returnValue");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.legacyReturnValue());
    return JSValue::encode(result);
}


EncodedJSValue jsEventCancelBubble(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "cancelBubble");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.cancelBubble());
    return JSValue::encode(result);
}


EncodedJSValue jsEventClipboardData(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Event", "clipboardData");
    }
    return JSValue::encode(castedThis->clipboardData(*state));
}


EncodedJSValue jsEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSEventPrototype* domObject = jsDynamicCast<JSEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSEventPrototype* domObject = jsDynamicCast<JSEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSEventReturnValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSEvent* castedThis = jsDynamicCast<JSEvent*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Event", "returnValue");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setLegacyReturnValue(nativeValue);
}


void setJSEventCancelBubble(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSEvent* castedThis = jsDynamicCast<JSEvent*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "Event", "cancelBubble");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCancelBubble(nativeValue);
}


JSValue JSEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopPropagation(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Event", "stopPropagation");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSEvent::info());
    auto& impl = castedThis->wrapped();
    impl.stopPropagation();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionPreventDefault(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Event", "preventDefault");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSEvent::info());
    auto& impl = castedThis->wrapped();
    impl.preventDefault();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionInitEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Event", "initEvent");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSEvent::info());
    auto& impl = castedThis->wrapped();
    String eventTypeArg = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool canBubbleArg = state->argument(1).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    bool cancelableArg = state->argument(2).toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.initEvent(eventTypeArg, canBubbleArg, cancelableArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopImmediatePropagation(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSEvent*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "Event", "stopImmediatePropagation");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSEvent::info());
    auto& impl = castedThis->wrapped();
    impl.stopImmediatePropagation();
    return JSValue::encode(jsUndefined());
}

bool JSEventOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSEventOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEvent = jsCast<JSEvent*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEvent->wrapped(), jsEvent);
}

Event* JSEvent::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEvent*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
