/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD_DEPRECATED)

#include "JSGamepad.h"

#include "JSDOMBinding.h"
#include "URL.h"
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsGamepadId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGamepadIndex(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGamepadTimestamp(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGamepadAxes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGamepadButtons(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSGamepadConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSGamepadPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSGamepadPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGamepadPrototype* ptr = new (NotNull, JSC::allocateCell<JSGamepadPrototype>(vm.heap)) JSGamepadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGamepadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSGamepadPrototypeTableValues[] =
{
    { "id", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "index", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timestamp", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadTimestamp), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "axes", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadAxes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "buttons", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadButtons), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSGamepadPrototype::s_info = { "GamepadPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGamepadPrototype) };

void JSGamepadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGamepadPrototypeTableValues, *this);
}

const ClassInfo JSGamepad::s_info = { "Gamepad", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGamepad) };

JSGamepad::JSGamepad(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Gamepad>&& impl)
    : JSDOMWrapper<Gamepad>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSGamepad::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSGamepadPrototype::create(vm, globalObject, JSGamepadPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSGamepad::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGamepad>(vm, globalObject);
}

void JSGamepad::destroy(JSC::JSCell* cell)
{
    JSGamepad* thisObject = static_cast<JSGamepad*>(cell);
    thisObject->JSGamepad::~JSGamepad();
}

EncodedJSValue jsGamepadId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepad*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Gamepad", "id");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.id());
    return JSValue::encode(result);
}


EncodedJSValue jsGamepadIndex(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepad*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Gamepad", "index");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.index());
    return JSValue::encode(result);
}


EncodedJSValue jsGamepadTimestamp(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepad*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Gamepad", "timestamp");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.timestamp());
    return JSValue::encode(result);
}


EncodedJSValue jsGamepadAxes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepad*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Gamepad", "axes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.axes());
    return JSValue::encode(result);
}


EncodedJSValue jsGamepadButtons(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepad*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "Gamepad", "buttons");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsArray(state, castedThis->globalObject(), impl.buttons());
    return JSValue::encode(result);
}


void setJSGamepadConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSGamepadPrototype* domObject = jsDynamicCast<JSGamepadPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

bool JSGamepadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSGamepadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGamepad = jsCast<JSGamepad*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGamepad->wrapped(), jsGamepad);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Gamepad* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSGamepad>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, Gamepad* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGamepad>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Gamepad.
    COMPILE_ASSERT(!__is_polymorphic(Gamepad), Gamepad_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSGamepad>(globalObject, impl);
}

Gamepad* JSGamepad::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGamepad*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GAMEPAD_DEPRECATED)
