/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBFactory.h"

#include "ExceptionCode.h"
#include "IDBOpenDBRequest.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSIDBOpenDBRequest.h"
#include <bindings/ScriptValue.h>
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionOpen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionDeleteDatabase(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionCmp(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBFactoryPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSIDBFactoryPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBFactoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBFactoryPrototype>(vm.heap)) JSIDBFactoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBFactoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSIDBFactory> JSIDBFactoryConstructor;

template<> JSValue JSIDBFactoryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBFactoryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBFactory::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("IDBFactory"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSIDBFactoryConstructor::s_info = { "IDBFactory", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBFactoryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBFactoryPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBFactoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBFactoryConstructor) } },
    { "open", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionOpen), (intptr_t) (1) } },
    { "deleteDatabase", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionDeleteDatabase), (intptr_t) (1) } },
    { "cmp", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBFactoryPrototypeFunctionCmp), (intptr_t) (2) } },
};

const ClassInfo JSIDBFactoryPrototype::s_info = { "IDBFactoryPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBFactoryPrototype) };

void JSIDBFactoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBFactoryPrototypeTableValues, *this);
}

const ClassInfo JSIDBFactory::s_info = { "IDBFactory", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBFactory) };

JSIDBFactory::JSIDBFactory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBFactory>&& impl)
    : JSDOMWrapper<IDBFactory>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIDBFactory::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSIDBFactoryPrototype::create(vm, globalObject, JSIDBFactoryPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSIDBFactory::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBFactory>(vm, globalObject);
}

void JSIDBFactory::destroy(JSC::JSCell* cell)
{
    JSIDBFactory* thisObject = static_cast<JSIDBFactory*>(cell);
    thisObject->JSIDBFactory::~JSIDBFactory();
}

EncodedJSValue jsIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSIDBFactoryPrototype* domObject = jsDynamicCast<JSIDBFactoryPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSIDBFactory::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSIDBFactoryPrototype* domObject = jsDynamicCast<JSIDBFactoryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSIDBFactory::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBFactoryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionOpen(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBFactory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBFactory", "open");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBFactory::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.open(scriptContext, name, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    unsigned long long version = toUInt64(state, state->argument(1), EnforceRange);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.open(scriptContext, name, version, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionDeleteDatabase(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBFactory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBFactory", "deleteDatabase");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBFactory::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.deleteDatabase(scriptContext, name, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBFactoryPrototypeFunctionCmp(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBFactory*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBFactory", "cmp");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBFactory::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue first = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    Deprecated::ScriptValue second = { state->vm(), state->argument(1) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsNumber(impl.cmp(scriptContext, first, second, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSIDBFactoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBFactoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBFactory = jsCast<JSIDBFactory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBFactory->wrapped(), jsIDBFactory);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBFactory* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSIDBFactory>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBFactory* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBFactory>(globalObject, impl))
        return result;
    return createNewWrapper<JSIDBFactory>(globalObject, impl);
}

IDBFactory* JSIDBFactory::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBFactory*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
