/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSMediaQueryListListener_h
#define JSMediaQueryListListener_h

#include "ActiveDOMCallback.h"
#include "JSCallbackData.h"
#include "MediaQueryListListener.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSMediaQueryListListener : public MediaQueryListListener, public ActiveDOMCallback {
public:
    static Ref<JSMediaQueryListListener> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSMediaQueryListListener(callback, globalObject));
    }

    virtual ScriptExecutionContext* scriptExecutionContext() const { return ContextDestructionObserver::scriptExecutionContext(); }

    virtual ~JSMediaQueryListListener();
    JSCallbackDataStrong* callbackData() { return m_data; }
    virtual bool operator==(const MediaQueryListListener&) const;


    // Functions
    virtual bool queryChanged(MediaQueryList* list);

private:
    JSMediaQueryListListener(JSC::JSObject* callback, JSDOMGlobalObject*);

    JSCallbackDataStrong* m_data;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, MediaQueryListListener*);
inline JSC::JSValue toJS(JSC::ExecState* state, JSDOMGlobalObject* globalObject, MediaQueryListListener& impl) { return toJS(state, globalObject, &impl); }

} // namespace WebCore

#endif
