/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedBoolean.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGAnimatedBooleanBaseVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAnimatedBooleanBaseVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGAnimatedBooleanAnimVal(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGAnimatedBooleanPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGAnimatedBooleanPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedBooleanPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedBooleanPrototype>(vm.heap)) JSSVGAnimatedBooleanPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedBooleanPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGAnimatedBoolean> JSSVGAnimatedBooleanConstructor;

template<> JSValue JSSVGAnimatedBooleanConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedBooleanConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedBoolean::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGAnimatedBoolean"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGAnimatedBooleanConstructor::s_info = { "SVGAnimatedBoolean", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedBooleanConstructor) } },
    { "baseVal", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanBaseVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGAnimatedBooleanBaseVal) } },
    { "animVal", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedBooleanAnimVal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBooleanPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanPrototype) };

void JSSVGAnimatedBooleanPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedBooleanPrototypeTableValues, *this);
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGAnimatedBoolean) };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedBoolean>&& impl)
    : JSDOMWrapper<SVGAnimatedBoolean>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGAnimatedBoolean::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedBooleanPrototype::create(vm, globalObject, JSSVGAnimatedBooleanPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGAnimatedBoolean::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(vm, globalObject);
}

void JSSVGAnimatedBoolean::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedBoolean* thisObject = static_cast<JSSVGAnimatedBoolean*>(cell);
    thisObject->JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean();
}

EncodedJSValue jsSVGAnimatedBooleanBaseVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedBoolean*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedBoolean", "baseVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.baseVal());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedBooleanAnimVal(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGAnimatedBoolean*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGAnimatedBoolean", "animVal");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.animVal());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGAnimatedBooleanConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGAnimatedBooleanPrototype* domObject = jsDynamicCast<JSSVGAnimatedBooleanPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGAnimatedBoolean::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGAnimatedBooleanConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGAnimatedBooleanPrototype* domObject = jsDynamicCast<JSSVGAnimatedBooleanPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGAnimatedBooleanBaseVal(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGAnimatedBoolean* castedThis = jsDynamicCast<JSSVGAnimatedBoolean*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGAnimatedBoolean", "baseVal");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBaseVal(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSSVGAnimatedBoolean::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedBooleanConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGAnimatedBooleanOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedBooleanOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedBoolean = jsCast<JSSVGAnimatedBoolean*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedBoolean->wrapped(), jsSVGAnimatedBoolean);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGAnimatedBoolean>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGAnimatedBoolean>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGAnimatedBoolean>(globalObject, impl);
}

SVGAnimatedBoolean* JSSVGAnimatedBoolean::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedBoolean*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
