/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGMatrix.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGMatrix.h"
#include "SVGMatrix.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGMatrixA(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixA(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixB(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixB(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixC(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixC(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixD(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixD(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixE(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixE(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixF(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixF(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGMatrixConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGMatrixConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGMatrixPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGMatrixPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGMatrixPrototype>(vm.heap)) JSSVGMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGMatrix> JSSVGMatrixConstructor;

template<> JSValue JSSVGMatrixConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGMatrixConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGMatrix::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGMatrix"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGMatrixConstructor::s_info = { "SVGMatrix", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGMatrixConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGMatrixPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixConstructor) } },
    { "a", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixA), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixA) } },
    { "b", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixB) } },
    { "c", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixC), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixC) } },
    { "d", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixD), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixD) } },
    { "e", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixE), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixE) } },
    { "f", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGMatrixF) } },
    { "multiply", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionMultiply), (intptr_t) (1) } },
    { "inverse", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionInverse), (intptr_t) (0) } },
    { "translate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionTranslate), (intptr_t) (2) } },
    { "scale", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScale), (intptr_t) (1) } },
    { "scaleNonUniform", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScaleNonUniform), (intptr_t) (2) } },
    { "rotate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotate), (intptr_t) (1) } },
    { "rotateFromVector", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotateFromVector), (intptr_t) (2) } },
    { "flipX", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipX), (intptr_t) (0) } },
    { "flipY", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipY), (intptr_t) (0) } },
    { "skewX", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewX), (intptr_t) (1) } },
    { "skewY", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewY), (intptr_t) (1) } },
};

const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGMatrixPrototype) };

void JSSVGMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGMatrixPrototypeTableValues, *this);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGMatrix) };

JSSVGMatrix::JSSVGMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<SVGMatrix>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<SVGMatrix>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGMatrix::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGMatrixPrototype::create(vm, globalObject, JSSVGMatrixPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGMatrix::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(vm, globalObject);
}

void JSSVGMatrix::destroy(JSC::JSCell* cell)
{
    JSSVGMatrix* thisObject = static_cast<JSSVGMatrix*>(cell);
    thisObject->JSSVGMatrix::~JSSVGMatrix();
}

EncodedJSValue jsSVGMatrixA(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "a");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.a());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixB(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "b");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.b());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixC(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "c");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.c());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixD(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "d");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.d());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixE(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "e");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.e());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixF(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGMatrix*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGMatrix", "f");
    }
    SVGMatrix& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.f());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGMatrixConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGMatrixPrototype* domObject = jsDynamicCast<JSSVGMatrixPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGMatrix::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGMatrixConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGMatrixPrototype* domObject = jsDynamicCast<JSSVGMatrixPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGMatrixA(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "a");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setA(nativeValue);
    impl.commitChange();
}


void setJSSVGMatrixB(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "b");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setB(nativeValue);
    impl.commitChange();
}


void setJSSVGMatrixC(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "c");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setC(nativeValue);
    impl.commitChange();
}


void setJSSVGMatrixD(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "d");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setD(nativeValue);
    impl.commitChange();
}


void setJSSVGMatrixE(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "e");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setE(nativeValue);
    impl.commitChange();
}


void setJSSVGMatrixF(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGMatrix* castedThis = jsDynamicCast<JSSVGMatrix*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGMatrix", "f");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl.propertyReference();
    podImpl.setF(nativeValue);
    impl.commitChange();
}


JSValue JSSVGMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMatrixConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "multiply");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGMatrix::info()))
        return throwArgumentTypeError(*state, 0, "secondMatrix", "SVGMatrix", "multiply", "SVGMatrix");
    SVGPropertyTearOff<SVGMatrix>* secondMatrix = JSSVGMatrix::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!secondMatrix) {
        setDOMException(state, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.multiply(secondMatrix->propertyReference()))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "inverse");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    ExceptionCode ec = 0;
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.inverse(ec))));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "translate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.translate(x, y))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "scale");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float scaleFactor = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.scale(scaleFactor))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "scaleNonUniform");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float scaleFactorX = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float scaleFactorY = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.scaleNonUniform(scaleFactorX, scaleFactorY))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "rotate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.rotate(angle))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "rotateFromVector");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.rotateFromVector(x, y, ec))));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "flipX");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.flipX())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "flipY");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.flipY())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "skewX");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.skewX(angle))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGMatrix*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGMatrix", "skewY");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGMatrix::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.skewY(angle))));
    return JSValue::encode(result);
}

bool JSSVGMatrixOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGMatrixOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGMatrix = jsCast<JSSVGMatrix*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGMatrix->wrapped(), jsSVGMatrix);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGMatrix>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGMatrix, SVGPropertyTearOff<SVGMatrix>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGMatrix>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGMatrix, SVGPropertyTearOff<SVGMatrix>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGMatrix, SVGPropertyTearOff<SVGMatrix>>(globalObject, impl);
}

SVGPropertyTearOff<SVGMatrix>* JSSVGMatrix::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGMatrix*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
