/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGNumber.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGNumberValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGNumberValue(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGNumberConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGNumberConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGNumberPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGNumberPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGNumberPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGNumberPrototype>(vm.heap)) JSSVGNumberPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGNumberPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGNumber> JSSVGNumberConstructor;

template<> JSValue JSSVGNumberConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGNumberConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGNumber::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGNumber"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGNumberConstructor::s_info = { "SVGNumber", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGNumberConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGNumberPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGNumberConstructor) } },
    { "value", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGNumberValue) } },
};

const ClassInfo JSSVGNumberPrototype::s_info = { "SVGNumberPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGNumberPrototype) };

void JSSVGNumberPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGNumberPrototypeTableValues, *this);
}

const ClassInfo JSSVGNumber::s_info = { "SVGNumber", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGNumber) };

JSSVGNumber::JSSVGNumber(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<float>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<float>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGNumber::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGNumberPrototype::create(vm, globalObject, JSSVGNumberPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGNumber::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGNumber>(vm, globalObject);
}

void JSSVGNumber::destroy(JSC::JSCell* cell)
{
    JSSVGNumber* thisObject = static_cast<JSSVGNumber*>(cell);
    thisObject->JSSVGNumber::~JSSVGNumber();
}

EncodedJSValue jsSVGNumberValue(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGNumber*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGNumber", "value");
    }
    float& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl);
    return JSValue::encode(result);
}


EncodedJSValue jsSVGNumberConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGNumberPrototype* domObject = jsDynamicCast<JSSVGNumberPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGNumber::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGNumberConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGNumberPrototype* domObject = jsDynamicCast<JSSVGNumberPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGNumberValue(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGNumber* castedThis = jsDynamicCast<JSSVGNumber*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGNumber", "value");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    float& podImpl = impl.propertyReference();
    podImpl = nativeValue;
    impl.commitChange();
}


JSValue JSSVGNumber::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGNumberConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGNumberOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGNumberOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGNumber = jsCast<JSSVGNumber*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGNumber->wrapped(), jsSVGNumber);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<float>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGNumber, SVGPropertyTearOff<float>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<float>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGNumber, SVGPropertyTearOff<float>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGNumber, SVGPropertyTearOff<float>>(globalObject, impl);
}

SVGPropertyTearOff<float>* JSSVGNumber::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGNumber*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
