/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSTextTrack.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "JSNodeCustom.h"
#include "JSTextTrackCue.h"
#include "JSTextTrackCueList.h"
#include "JSVTTRegion.h"
#include "JSVTTRegionList.h"
#include "TextTrackCueList.h"
#include "URL.h"
#include "VTTRegionList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionAddCue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionRemoveCue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionAddRegion(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionRemoveRegion(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTextTrackId(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackLabel(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackLanguage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackLanguage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackInBandMetadataTrackDispatchType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackMode(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackCues(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackActiveCues(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackOncuechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackOncuechange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTextTrackRegions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTextTrackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTextTrackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTextTrackPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTextTrackPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTextTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSTextTrackPrototype>(vm.heap)) JSTextTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTextTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTextTrack> JSTextTrackConstructor;

template<> JSValue JSTextTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSTextTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTextTrack::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TextTrack"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTextTrackConstructor::s_info = { "TextTrack", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTextTrackPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackConstructor) } },
    { "id", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kind", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackKind) } },
    { "label", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "language", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackLanguage) } },
    { "inBandMetadataTrackDispatchType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackInBandMetadataTrackDispatchType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "mode", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackMode) } },
    { "cues", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackCues), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "activeCues", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackActiveCues), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oncuechange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackOncuechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTextTrackOncuechange) } },
    { "regions", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextTrackRegions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "addCue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackPrototypeFunctionAddCue), (intptr_t) (1) } },
    { "removeCue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackPrototypeFunctionRemoveCue), (intptr_t) (1) } },
    { "addRegion", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackPrototypeFunctionAddRegion), (intptr_t) (1) } },
    { "removeRegion", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTextTrackPrototypeFunctionRemoveRegion), (intptr_t) (1) } },
};

const ClassInfo JSTextTrackPrototype::s_info = { "TextTrackPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrackPrototype) };

void JSTextTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTextTrackPrototypeTableValues, *this);
}

const ClassInfo JSTextTrack::s_info = { "TextTrack", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTextTrack) };

JSTextTrack::JSTextTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TextTrack>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTextTrack::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTextTrackPrototype::create(vm, globalObject, JSTextTrackPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSTextTrack::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextTrack>(vm, globalObject);
}

EncodedJSValue jsTextTrackId(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "id");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.id());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackKind(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "kind");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.kind());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackLabel(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "label");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.label());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackLanguage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "language");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.language());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackInBandMetadataTrackDispatchType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "inBandMetadataTrackDispatchType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.inBandMetadataTrackDispatchType());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackMode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "mode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.mode());
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackCues(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "cues");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.cues()));
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackActiveCues(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "activeCues");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.activeCues()));
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackOncuechange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "oncuechange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().cuechangeEvent));
}


EncodedJSValue jsTextTrackRegions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTextTrack*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "TextTrack", "regions");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.regions()));
    return JSValue::encode(result);
}


EncodedJSValue jsTextTrackConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTextTrackPrototype* domObject = jsDynamicCast<JSTextTrackPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTextTrack::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTextTrackConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTextTrackPrototype* domObject = jsDynamicCast<JSTextTrackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSTextTrackKind(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSTextTrack* castedThis = jsDynamicCast<JSTextTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "TextTrack", "kind");
        return;
    }
    castedThis->setKind(*state, value);
}


void setJSTextTrackLanguage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSTextTrack* castedThis = jsDynamicCast<JSTextTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "TextTrack", "language");
        return;
    }
    castedThis->setLanguage(*state, value);
}


void setJSTextTrackMode(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSTextTrack* castedThis = jsDynamicCast<JSTextTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "TextTrack", "mode");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (nativeValue != "disabled" && nativeValue != "hidden" && nativeValue != "showing")
        return;
    impl.setMode(nativeValue);
}


void setJSTextTrackOncuechange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSTextTrack* castedThis = jsDynamicCast<JSTextTrack*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "TextTrack", "oncuechange");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().cuechangeEvent, value);
}


JSValue JSTextTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionAddCue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrack*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrack", "addCue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrack::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    TextTrackCue* cue = JSTextTrackCue::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.addCue(cue, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionRemoveCue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrack*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrack", "removeCue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrack::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    TextTrackCue* cue = JSTextTrackCue::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeCue(cue, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionAddRegion(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrack*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrack", "addRegion");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrack::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    VTTRegion* region = JSVTTRegion::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.addRegion(region);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTextTrackPrototypeFunctionRemoveRegion(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTextTrack*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TextTrack", "removeRegion");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTextTrack::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    VTTRegion* region = JSVTTRegion::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.removeRegion(region, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

void JSTextTrack::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSTextTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSTextTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsTextTrack = jsCast<JSTextTrack*>(handle.slot()->asCell());
    if (jsTextTrack->wrapped().isFiringEventListeners())
        return true;
    Element* element = WTF::getPtr(jsTextTrack->wrapped().element());
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSTextTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTextTrack = jsCast<JSTextTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTextTrack->wrapped(), jsTextTrack);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextTrack* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTextTrack>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TextTrack* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTextTrack>(globalObject, impl))
        return result;
    return createNewWrapper<JSTextTrack>(globalObject, impl);
}

TextTrack* JSTextTrack::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTextTrack*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
