/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WritableStreamBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <runtime/Executable.h>
#include <runtime/JSCJSValueInlines.h>
#include <runtime/JSCellInlines.h>
#include <runtime/StructureInlines.h>
#include <runtime/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_writableStreamInitializeWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamInitializeWritableStreamCodeLength = 1274;
const char* s_writableStreamInitializeWritableStreamCode =
    "(function (underlyingSink, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (underlyingSink === @undefined)\n" \
    "        underlyingSink = { };\n" \
    "    if (strategy === @undefined)\n" \
    "        strategy = { highWaterMark: 0, size: function() { return 1; } };\n" \
    "    if (!@isObject(underlyingSink))\n" \
    "        throw new @TypeError(\"WritableStream constructor takes an object as first argument\");\n" \
    "    if (!@isObject(strategy))\n" \
    "        throw new @TypeError(\"WritableStream constructor takes an object as second argument, if any\");\n" \
    "    this.@underlyingSink = underlyingSink;\n" \
    "    this.@closedPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    this.@readyPromiseCapability = { @promise: @Promise.@resolve() };\n" \
    "    this.@queue = @newQueue();\n" \
    "    this.@state = @streamWritable;\n" \
    "    this.@started = false;\n" \
    "    this.@writing = false;\n" \
    "    this.@strategy = @validateAndNormalizeQueuingStrategy(strategy.size, strategy.highWaterMark);\n" \
    "    @syncWritableStreamStateWithQueue(this);\n" \
    "    const errorFunction = (e) => {\n" \
    "        @errorWritableStream(this, e);\n" \
    "    };\n" \
    "    this.@startedPromise = @promiseInvokeOrNoopNoCatch(underlyingSink, \"start\", [errorFunction]);\n" \
    "    this.@startedPromise.@then(() => {\n" \
    "        this.@started = true;\n" \
    "        this.@startedPromise = @undefined;\n" \
    "    }, errorFunction);\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamAbortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamAbortCodeLength = 534;
const char* s_writableStreamAbortCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"The WritableStream.abort method can only be used on instances of WritableStream\"));\n" \
    "    if (this.@state === @streamClosed)\n" \
    "        return @Promise.@resolve();\n" \
    "    if (this.@state === @streamErrored)\n" \
    "        return @Promise.@reject(this.@storedError);\n" \
    "    @errorWritableStream(this, reason);\n" \
    "    return @promiseInvokeOrFallbackOrNoop(this.@underlyingSink, \"abort\", [reason], \"close\", []).@then(function() { });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamCloseCodeLength = 760;
const char* s_writableStreamCloseCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"The WritableStream.close method can only be used on instances of WritableStream\"));\n" \
    "    if (this.@state === @streamClosed || this.@state === @streamClosing)\n" \
    "        return @Promise.@reject(new @TypeError(\"Cannot close a WritableString that is closed or closing\"));\n" \
    "    if (this.@state === @streamErrored)\n" \
    "        return @Promise.@reject(this.@storedError);\n" \
    "    if (this.@state === @streamWaiting)\n" \
    "        this.@readyPromiseCapability.@resolve.@call();\n" \
    "    this.@state = @streamClosing;\n" \
    "    @enqueueValueWithSize(this.@queue, \"close\", 0);\n" \
    "    @callOrScheduleWritableStreamAdvanceQueue(this);\n" \
    "    return this.@closedPromiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamWriteCodeLength = 1256;
const char* s_writableStreamWriteCode =
    "(function (chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"The WritableStream.close method can only be used on instances of WritableStream\"));\n" \
    "    if (this.@state === @streamClosed || this.@state === @streamClosing)\n" \
    "        return @Promise.@reject(new @TypeError(\"Cannot write on a WritableString that is closed or closing\"));\n" \
    "    if (this.@state === @streamErrored)\n" \
    "        return @Promise.@reject(this.@storedError);\n" \
    "    @assert(this.@state === @streamWritable || this.@state === @streamWaiting);\n" \
    "    let chunkSize = 1;\n" \
    "    if (this.@strategy.size !== @undefined) {\n" \
    "        try {\n" \
    "            chunkSize = this.@strategy.size.@call(@undefined, chunk);\n" \
    "        } catch(e) {\n" \
    "            @errorWritableStream(this, e);\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "    }\n" \
    "    const promiseCapability = @newPromiseCapability(@Promise);\n" \
    "    try {\n" \
    "        @enqueueValueWithSize(this.@queue, { promiseCapability: promiseCapability, chunk: chunk }, chunkSize);\n" \
    "    } catch (e) {\n" \
    "        @errorWritableStream(this, e);\n" \
    "        return @Promise.@reject(e);\n" \
    "    }\n" \
    "    @syncWritableStreamStateWithQueue(this);\n" \
    "    @callOrScheduleWritableStreamAdvanceQueue(this);\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamClosedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamClosedCodeLength = 254;
const char* s_writableStreamClosedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"The WritableStream.closed getter can only be used on instances of WritableStream\"));\n" \
    "    return this.@closedPromiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamReadyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamReadyCodeLength = 252;
const char* s_writableStreamReadyCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(new @TypeError(\"The WritableStream.ready getter can only be used on instances of WritableStream\"));\n" \
    "    return this.@readyPromiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamStateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const int s_writableStreamStateCodeLength = 490;
const char* s_writableStreamStateCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    if (!@isWritableStream(this))\n" \
    "        throw new @TypeError(\"The WritableStream.state getter can only be used on instances of WritableStream\");\n" \
    "    switch(this.@state) {\n" \
    "    case @streamClosed:\n" \
    "        return \"closed\";\n" \
    "    case @streamClosing:\n" \
    "        return \"closing\";\n" \
    "    case @streamErrored:\n" \
    "        return \"errored\";\n" \
    "    case @streamWaiting:\n" \
    "        return \"waiting\";\n" \
    "    case @streamWritable:\n" \
    "        return \"writable\";\n" \
    "    }\n" \
    "    @assert(false);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().writableStreamBuiltins().codeName##Executable()->link(vm, clientData->builtinFunctions().writableStreamBuiltins().codeName##Source()); \
}
WEBCORE_FOREACH_WRITABLESTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
