/*
 * Copyright (C) 2024 AMD, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Author: Anatoliy Klymenko <anatoliy.klymenko@amd.com>
 *
 */

#ifndef ARMSOC_REPULSION_H_
#define ARMSOC_REPULSION_H_

#include <stdbool.h>
#include "armsoc_dumb.h"

struct ARMSOCRepulsion;

/**
 * Initialize armsoc repulsion compositor.
 *
 * Return: pointer to new ARMSOCRepulsion object on success, NULL otherwise.
 */
struct ARMSOCRepulsion *armsoc_repulsion_init(void);

/**
 * Release armsoc repulsion compositor and free all resources.
 * @repulsion: pointer to previously allocated ARMSOCRepulsion object.
 */
void armsoc_repulsion_release(struct ARMSOCRepulsion *repulsion);

/**
 * Perform 2 image composition.
 * @repulsion: pointer to ARMSOCRepulsion object.
 * @src: source buffer object.
 * @dest: destination buffer object.
 * @xform_matrix: transformation matrix to apply to source image before copying
 * it into destination.
 *
 * This function performs GPU accelerated copy of @src buffer into @dest buffer
 * while applying linear transformation.
 *
 * Return: pointer to new ARMSOCRepulsion object on success, NULL otherwise.
 */
bool armsoc_repulsion_composite(struct ARMSOCRepulsion *repulsion,
                                struct armsoc_bo *src,
                                struct armsoc_bo *dest,
                                float xform_matrix[3][3]);


#endif // ARMSOC_REPULSION_H_
