# Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set(fastcdr_VERSION 2.2.1)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if(MSVC OR MSVC_IDE)
    set_and_check(fastcdr_BIN_DIR "${PACKAGE_PREFIX_DIR}/bin")
endif()
set_and_check(fastcdr_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(fastcdr_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")

set(fastcdr_known_comps static shared)
set(fastcdr_comp_static NO)
set(fastcdr_comp_shared NO)
foreach (fastcdr_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
    if (fastcdr_comp IN_LIST fastcdr_known_comps)
        set(fastcdr_comp_${fastcdr_comp} YES)
    else ()
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "fastcdr does not recognize component `${fastcdr_comp}`.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
endforeach ()

if (fastcdr_comp_static AND fastcdr_comp_shared)
    set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
        "fastcdr `static` and `shared` components are mutually exclusive.")
    set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
    return()
endif ()

set(fastcdr_static_targets "${CMAKE_CURRENT_LIST_DIR}/fastcdr-static-targets.cmake")
set(fastcdr_shared_targets "${CMAKE_CURRENT_LIST_DIR}/fastcdr-shared-targets.cmake")

macro(fastcdr_load_targets type)
    if (NOT EXISTS "${fastcdr_${type}_targets}")
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "fastcdr `${type}` libraries were requested but not found.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
    include("${fastcdr_${type}_targets}")
endmacro()

if (fastcdr_comp_static)
    fastcdr_load_targets(static)
elseif (fastcdr_comp_shared)
    fastcdr_load_targets(shared)
elseif (DEFINED fastcdr_SHARED_LIBS AND fastcdr_SHARED_LIBS)
    fastcdr_load_targets(shared)
elseif (DEFINED fastcdr_SHARED_LIBS AND NOT fastcdr_SHARED_LIBS)
    fastcdr_load_targets(static)
elseif (BUILD_SHARED_LIBS)
    if (EXISTS "${fastcdr_shared_targets}")
        fastcdr_load_targets(shared)
    else ()
        fastcdr_load_targets(static)
    endif ()
else ()
    if (EXISTS "${fastcdr_static_targets}")
        fastcdr_load_targets(static)
    else ()
        fastcdr_load_targets(shared)
    endif ()
endif ()
