#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


/* define our OpenSSL API compatibility level to 1.1.0. Any symbols older than
   that will raise an error during compilation. */
#define OPENSSL_API_COMPAT 0x10100000L

#if defined(_WIN32)
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#include <windows.h>
#include <Wincrypt.h>
#include <Winsock2.h>
/*
    undef some macros that are defined by wincrypt.h but are also types in
    boringssl. openssl has worked around this but boring has not yet. see:
    https://chromium.googlesource.com/chromium/src/+/refs/heads/main/base
    /win/wincrypt_shim.h
*/
#undef X509_NAME
#undef X509_EXTENSIONS
#undef PKCS7_SIGNER_INFO
#endif

#include <openssl/opensslv.h>


#if defined(LIBRESSL_VERSION_NUMBER)
#define CRYPTOGRAPHY_IS_LIBRESSL 1
#else
#define CRYPTOGRAPHY_IS_LIBRESSL 0
#endif

#if defined(OPENSSL_IS_BORINGSSL)
#define CRYPTOGRAPHY_IS_BORINGSSL 1
#else
#define CRYPTOGRAPHY_IS_BORINGSSL 0
#endif

#if OPENSSL_VERSION_NUMBER < 0x10101040
    #error "pyca/cryptography MUST be linked with Openssl 1.1.1d or later"
#endif

#define CRYPTOGRAPHY_OPENSSL_300_OR_GREATER     (OPENSSL_VERSION_NUMBER >= 0x30000000 && !CRYPTOGRAPHY_IS_LIBRESSL)
#define CRYPTOGRAPHY_OPENSSL_320_OR_GREATER     (OPENSSL_VERSION_NUMBER >= 0x30200000 && !CRYPTOGRAPHY_IS_LIBRESSL)

#define CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E     (OPENSSL_VERSION_NUMBER < 0x10101050 || CRYPTOGRAPHY_IS_LIBRESSL)

#if CRYPTOGRAPHY_IS_LIBRESSL
#define CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380     (LIBRESSL_VERSION_NUMBER < 0x3080000f)

#else
#define CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380 (0)
#endif


#if CRYPTOGRAPHY_OPENSSL_300_OR_GREATER
#include <openssl/provider.h>
#include <openssl/proverr.h>
#endif


#include <openssl/asn1.h>


#include <openssl/bn.h>


#include <openssl/bio.h>


#include <openssl/crypto.h>


#include <openssl/dh.h>


#include <openssl/dsa.h>


#include <openssl/ec.h>
#include <openssl/obj_mac.h>


#include <openssl/engine.h>


#include <openssl/err.h>


#include <openssl/evp.h>


#include <openssl/obj_mac.h>


#include <openssl/objects.h>


#include <openssl/opensslv.h>


#include <openssl/pem.h>


#include <openssl/pkcs12.h>


#include <openssl/rand.h>


#include <openssl/rsa.h>


#include <openssl/ssl.h>


#include <openssl/ssl.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `STACK_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */
typedef STACK_OF(X509) Cryptography_STACK_OF_X509;
typedef STACK_OF(X509_CRL) Cryptography_STACK_OF_X509_CRL;
typedef STACK_OF(X509_REVOKED) Cryptography_STACK_OF_X509_REVOKED;


#include <openssl/x509.h>

/*
 * See the comment above Cryptography_STACK_OF_X509 in x509.py
 */
typedef STACK_OF(X509_NAME) Cryptography_STACK_OF_X509_NAME;
typedef STACK_OF(X509_NAME_ENTRY) Cryptography_STACK_OF_X509_NAME_ENTRY;


#include <openssl/x509v3.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `STACK_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */


#include <openssl/x509_vfy.h>

/*
 * This is part of a work-around for the difficulty cffi has in dealing with
 * `STACK_OF(foo)` as the name of a type.  We invent a new, simpler name that
 * will be an alias for this type and use the alias throughout.  This works
 * together with another opaque typedef for the same name in the TYPES section.
 * Note that the result is an opaque type.
 */
typedef STACK_OF(ASN1_OBJECT) Cryptography_STACK_OF_ASN1_OBJECT;
typedef STACK_OF(X509_OBJECT) Cryptography_STACK_OF_X509_OBJECT;


#include <openssl/pkcs7.h>




#if CRYPTOGRAPHY_OPENSSL_300_OR_GREATER
static const long Cryptography_HAS_PROVIDERS = 1;
#else
static const long Cryptography_HAS_PROVIDERS = 0;
typedef void OSSL_PROVIDER;
typedef void OSSL_LIB_CTX;
static const long PROV_R_BAD_DECRYPT = 0;
static const long PROV_R_XTS_DUPLICATED_KEYS = 0;
static const long PROV_R_WRONG_FINAL_BLOCK_LENGTH = 0;
OSSL_PROVIDER *(*OSSL_PROVIDER_load)(OSSL_LIB_CTX *, const char *) = NULL;
int (*OSSL_PROVIDER_unload)(OSSL_PROVIDER *) = NULL;
#endif




#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_PRIME_CHECKS = 0;
int (*BN_prime_checks_for_size)(int) = NULL;
#else
static const long Cryptography_HAS_PRIME_CHECKS = 1;
#endif


#if CRYPTOGRAPHY_IS_LIBRESSL || CRYPTOGRAPHY_IS_BORINGSSL

#if !defined(_WIN32)
#include <sys/socket.h>
#endif

#include <stdlib.h>
typedef struct sockaddr BIO_ADDR;

BIO_ADDR *BIO_ADDR_new(void) {
    return malloc(sizeof(struct sockaddr_storage));
}

void BIO_ADDR_free(BIO_ADDR *ptr) {
    free(ptr);
}
#endif










#ifdef OPENSSL_NO_ENGINE
static const long Cryptography_HAS_ENGINE = 0;

#if CRYPTOGRAPHY_IS_BORINGSSL
typedef void UI_METHOD;
#endif

/* Despite being OPENSSL_NO_ENGINE, BoringSSL/LibreSSL define these symbols. */
#if !CRYPTOGRAPHY_IS_BORINGSSL && !CRYPTOGRAPHY_IS_LIBRESSL
int (*ENGINE_free)(ENGINE *) = NULL;
void (*ENGINE_load_builtin_engines)(void) = NULL;
#endif

ENGINE *(*ENGINE_get_default_RAND)(void) = NULL;
int (*ENGINE_set_default_RAND)(ENGINE *) = NULL;
void (*ENGINE_unregister_RAND)(ENGINE *) = NULL;

#if !CRYPTOGRAPHY_IS_LIBRESSL
ENGINE *(*ENGINE_by_id)(const char *) = NULL;
int (*ENGINE_init)(ENGINE *) = NULL;
int (*ENGINE_finish)(ENGINE *) = NULL;
int (*ENGINE_ctrl_cmd)(ENGINE *, const char *, long, void *,
                       void (*)(void), int) = NULL;

const char *(*ENGINE_get_id)(const ENGINE *) = NULL;
const char *(*ENGINE_get_name)(const ENGINE *) = NULL;

int (*ENGINE_ctrl_cmd_string)(ENGINE *, const char *, const char *,
                              int) = NULL;
EVP_PKEY *(*ENGINE_load_private_key)(ENGINE *, const char *, UI_METHOD *,
                                     void *) = NULL;
EVP_PKEY *(*ENGINE_load_public_key)(ENGINE *, const char *,
                                    UI_METHOD *, void *) = NULL;
#endif

#else
static const long Cryptography_HAS_ENGINE = 1;
#endif


/* This define is tied to provider support and is conditionally
   removed if Cryptography_HAS_PROVIDERS is false */
#ifndef ERR_LIB_PROV
#define ERR_LIB_PROV 0
#endif

#ifndef EVP_R_XTS_DUPLICATED_KEYS
static const int EVP_R_XTS_DUPLICATED_KEYS = 0;
#endif

#if CRYPTOGRAPHY_IS_BORINGSSL
static const int ERR_LIB_PKCS12 = 0;
static const int EVP_F_EVP_ENCRYPTFINAL_EX = 0;
static const int EVP_R_BAD_DECRYPT = 0;
static const int EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH = 0;
static const int EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM = 0;
static const int PKCS12_R_PKCS12_CIPHERFINAL_ERROR = 0;
#else
static const int CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH = 0;
#endif

/* SSL_R_UNEXPECTED_EOF_WHILE_READING is needed for pyOpenSSL
   with OpenSSL 3+ */
#if defined(SSL_R_UNEXPECTED_EOF_WHILE_READING)
#define Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING 1
#else
#define Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING 0
#define SSL_R_UNEXPECTED_EOF_WHILE_READING 0
#endif


#ifdef EVP_PKEY_DHX
const long Cryptography_HAS_EVP_PKEY_DHX = 1;
#else
const long Cryptography_HAS_EVP_PKEY_DHX = 0;
#endif

#if CRYPTOGRAPHY_IS_LIBRESSL || defined(OPENSSL_NO_SCRYPT)
static const long Cryptography_HAS_SCRYPT = 0;
#else
static const long Cryptography_HAS_SCRYPT = 1;
#endif

/* This is tied to X448 support so we reuse the Cryptography_HAS_X448
   conditional to remove it. OpenSSL 1.1.1 adds this define.  We can remove
   this in the distant future when we drop 1.1.0 support. */
#ifndef EVP_PKEY_X448
#define EVP_PKEY_X448 NID_X448
#endif

/* This is tied to ED448 support so we reuse the Cryptography_HAS_ED448
   conditional to remove it. */
#ifndef EVP_PKEY_ED448
#define EVP_PKEY_ED448 0
#endif

#if CRYPTOGRAPHY_OPENSSL_300_OR_GREATER
static const long Cryptography_HAS_300_FIPS = 1;
static const long Cryptography_HAS_300_EVP_CIPHER = 1;
#else
static const long Cryptography_HAS_300_FIPS = 0;
static const long Cryptography_HAS_300_EVP_CIPHER = 0;
int (*EVP_default_properties_enable_fips)(OSSL_LIB_CTX *, int) = NULL;
EVP_CIPHER * (*EVP_CIPHER_fetch)(OSSL_LIB_CTX *, const char *,
                                 const char *) = NULL;
void (*EVP_CIPHER_free)(EVP_CIPHER *) = NULL;
#endif


#ifndef NID_ED448
static const long Cryptography_HAS_ED448 = 0;
#else
static const long Cryptography_HAS_ED448 = 1;
#endif
#ifndef NID_poly1305
static const long Cryptography_HAS_POLY1305 = 0;
#else
static const long Cryptography_HAS_POLY1305 = 1;
#endif








#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_PKCS12_SET_MAC = 0;
int (*PKCS12_set_mac)(PKCS12 *, const char *, int, unsigned char *, int, int,
                      const EVP_MD *) = NULL;
#else
static const long Cryptography_HAS_PKCS12_SET_MAC = 1;
#endif




#if defined(EVP_PKEY_CTRL_RSA_IMPLICIT_REJECTION)
static const int Cryptography_HAS_IMPLICIT_RSA_REJECTION = 1;
#else
static const int Cryptography_HAS_IMPLICIT_RSA_REJECTION = 0;
#endif


#ifdef OPENSSL_NO_ENGINE
int (*SSL_CTX_set_client_cert_engine)(SSL_CTX *, ENGINE *) = NULL;
#endif

#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_VERIFIED_CHAIN = 0;
Cryptography_STACK_OF_X509 *(*SSL_get0_verified_chain)(const SSL *) = NULL;
#else
static const long Cryptography_HAS_VERIFIED_CHAIN = 1;
#endif

static const long Cryptography_HAS_KEYLOG = 1;

static const long Cryptography_HAS_NEXTPROTONEG = 0;
static const long Cryptography_HAS_ALPN = 1;

#ifdef SSL_OP_NO_RENEGOTIATION
static const long Cryptography_HAS_OP_NO_RENEGOTIATION = 1;
#else
static const long Cryptography_HAS_OP_NO_RENEGOTIATION = 0;
static const long SSL_OP_NO_RENEGOTIATION = 0;
#endif

#ifdef SSL_OP_IGNORE_UNEXPECTED_EOF
static const long Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF = 1;
#else
static const long Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF = 0;
static const long SSL_OP_IGNORE_UNEXPECTED_EOF = 1;
#endif

#if CRYPTOGRAPHY_IS_LIBRESSL
void (*SSL_CTX_set_cert_cb)(SSL_CTX *, int (*)(SSL *, void *), void *) = NULL;
void (*SSL_set_cert_cb)(SSL *, int (*)(SSL *, void *), void *) = NULL;
static const long Cryptography_HAS_SET_CERT_CB = 0;

long (*SSL_get_extms_support)(SSL *) = NULL;
static const long Cryptography_HAS_GET_EXTMS_SUPPORT = 0;
#else
static const long Cryptography_HAS_SET_CERT_CB = 1;
static const long Cryptography_HAS_GET_EXTMS_SUPPORT = 1;
#endif

/* in OpenSSL 1.1.0 the SSL_ST values were renamed to TLS_ST and several were
   removed */
#if CRYPTOGRAPHY_IS_LIBRESSL || CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_SSL_ST = 1;
#else
static const long Cryptography_HAS_SSL_ST = 0;
static const long SSL_ST_BEFORE = 0;
static const long SSL_ST_OK = 0;
static const long SSL_ST_INIT = 0;
static const long SSL_ST_RENEGOTIATE = 0;
#endif
#if !CRYPTOGRAPHY_IS_LIBRESSL
static const long Cryptography_HAS_TLS_ST = 1;
#else
static const long Cryptography_HAS_TLS_ST = 0;
static const long TLS_ST_BEFORE = 0;
static const long TLS_ST_OK = 0;
#endif

#if CRYPTOGRAPHY_IS_LIBRESSL || CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_DTLS_GET_DATA_MTU = 0;
size_t (*DTLS_get_data_mtu)(SSL *) = NULL;
#else
static const long Cryptography_HAS_DTLS_GET_DATA_MTU = 1;
#endif

/* Wrap DTLSv1_get_timeout to avoid cffi to handle a 'struct timeval'. */
long Cryptography_DTLSv1_get_timeout(SSL *ssl, time_t *ptv_sec,
                                     long *ptv_usec) {
    struct timeval tv = { 0 };
    long r = DTLSv1_get_timeout(ssl, &tv);

    if (r == 1) {
        if (ptv_sec) {
            *ptv_sec = tv.tv_sec;
        }

        if (ptv_usec) {
            *ptv_usec = tv.tv_usec;
        }
    }

    return r;
}

#if CRYPTOGRAPHY_IS_LIBRESSL
static const long Cryptography_HAS_SIGALGS = 0;
const long (*SSL_CTX_set1_sigalgs_list)(SSL_CTX *, const char *) = NULL;
#else
static const long Cryptography_HAS_SIGALGS = 1;
#endif

#if CRYPTOGRAPHY_IS_LIBRESSL || defined(OPENSSL_NO_PSK)
static const long Cryptography_HAS_PSK = 0;
int (*SSL_CTX_use_psk_identity_hint)(SSL_CTX *, const char *) = NULL;
void (*SSL_CTX_set_psk_server_callback)(SSL_CTX *,
                                        unsigned int (*)(
                                            SSL *,
                                            const char *,
                                            unsigned char *,
                                            unsigned int
                                        )) = NULL;
void (*SSL_CTX_set_psk_client_callback)(SSL_CTX *,
                                        unsigned int (*)(
                                            SSL *,
                                            const char *,
                                            char *,
                                            unsigned int,
                                            unsigned char *,
                                            unsigned int
                                        )) = NULL;
#else
static const long Cryptography_HAS_PSK = 1;
#endif

#if !CRYPTOGRAPHY_IS_LIBRESSL && !CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_CUSTOM_EXT = 1;
#else
static const long Cryptography_HAS_CUSTOM_EXT = 0;
typedef int (*custom_ext_add_cb)(SSL *, unsigned int,
                                 const unsigned char **,
                                 size_t *, int *,
                                 void *);
typedef void (*custom_ext_free_cb)(SSL *, unsigned int,
                                   const unsigned char *,
                                   void *);
typedef int (*custom_ext_parse_cb)(SSL *, unsigned int,
                                   const unsigned char *,
                                   size_t, int *,
                                   void *);
int (*SSL_CTX_add_client_custom_ext)(SSL_CTX *, unsigned int,
                                     custom_ext_add_cb,
                                     custom_ext_free_cb, void *,
                                     custom_ext_parse_cb,
                                     void *) = NULL;
int (*SSL_CTX_add_server_custom_ext)(SSL_CTX *, unsigned int,
                                     custom_ext_add_cb,
                                     custom_ext_free_cb, void *,
                                     custom_ext_parse_cb,
                                     void *) = NULL;
int (*SSL_extension_supported)(unsigned int) = NULL;
#endif

#ifndef OPENSSL_NO_SRTP
static const long Cryptography_HAS_SRTP = 1;
#else
static const long Cryptography_HAS_SRTP = 0;
int (*SSL_CTX_set_tlsext_use_srtp)(SSL_CTX *, const char *) = NULL;
int (*SSL_set_tlsext_use_srtp)(SSL *, const char *) = NULL;
SRTP_PROTECTION_PROFILE * (*SSL_get_selected_srtp_profile)(SSL *) = NULL;
#endif

#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_TLSv1_3_FUNCTIONS = 0;

static const long SSL_VERIFY_POST_HANDSHAKE = 0;
int (*SSL_CTX_set_ciphersuites)(SSL_CTX *, const char *) = NULL;
int (*SSL_verify_client_post_handshake)(SSL *) = NULL;
void (*SSL_CTX_set_post_handshake_auth)(SSL_CTX *, int) = NULL;
void (*SSL_set_post_handshake_auth)(SSL *, int) = NULL;
uint32_t (*SSL_SESSION_get_max_early_data)(const SSL_SESSION *) = NULL;
int (*SSL_write_early_data)(SSL *, const void *, size_t, size_t *) = NULL;
int (*SSL_read_early_data)(SSL *, void *, size_t, size_t *) = NULL;
int (*SSL_CTX_set_max_early_data)(SSL_CTX *, uint32_t) = NULL;
#else
static const long Cryptography_HAS_TLSv1_3_FUNCTIONS = 1;
#endif

#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_SSL_COOKIE = 0;

static const long SSL_OP_COOKIE_EXCHANGE = 0;
int (*DTLSv1_listen)(SSL *, BIO_ADDR *) = NULL;
void (*SSL_CTX_set_cookie_generate_cb)(SSL_CTX *,
                                       int (*)(
                                           SSL *,
                                           unsigned char *,
                                           unsigned int *
                                       )) = NULL;
void (*SSL_CTX_set_cookie_verify_cb)(SSL_CTX *,
                                       int (*)(
                                           SSL *,
                                           const unsigned char *,
                                           unsigned int
                                       )) = NULL;
#else
static const long Cryptography_HAS_SSL_COOKIE = 1;
#endif
#if CRYPTOGRAPHY_IS_LIBRESSL || CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_PSK_TLSv1_3 = 0;
void (*SSL_CTX_set_psk_find_session_callback)(SSL_CTX *,
                                           int (*)(
                                               SSL *,
                                               const unsigned char *,
                                               size_t,
                                               SSL_SESSION **
                                           )) = NULL;
void (*SSL_CTX_set_psk_use_session_callback)(SSL_CTX *,
                                          int (*)(
                                              SSL *,
                                              const EVP_MD *,
                                              const unsigned char **,
                                              size_t *,
                                              SSL_SESSION **
                                          )) = NULL;
#if CRYPTOGRAPHY_IS_BORINGSSL
const SSL_CIPHER *(*SSL_CIPHER_find)(SSL *, const unsigned char *) = NULL;
#endif
int (*SSL_SESSION_set1_master_key)(SSL_SESSION *, const unsigned char *,
                                   size_t) = NULL;
int (*SSL_SESSION_set_cipher)(SSL_SESSION *, const SSL_CIPHER *) = NULL;
#if !CRYPTOGRAPHY_IS_BORINGSSL
int (*SSL_SESSION_set_protocol_version)(SSL_SESSION *, int) = NULL;
#endif
SSL_SESSION *(*Cryptography_SSL_SESSION_new)(void) = NULL;
#else
static const long Cryptography_HAS_PSK_TLSv1_3 = 1;
SSL_SESSION *Cryptography_SSL_SESSION_new(void) {
    return SSL_SESSION_new();
}
#endif










#if CRYPTOGRAPHY_IS_BORINGSSL
static const long Cryptography_HAS_PKCS7_FUNCS = 0;

int (*PKCS7_verify)(PKCS7 *, Cryptography_STACK_OF_X509 *, X509_STORE *, BIO *,
                    BIO *, int) = NULL;
PKCS7 *(*SMIME_read_PKCS7)(BIO *, BIO **) = NULL;
#else
static const long Cryptography_HAS_PKCS7_FUNCS = 1;
#endif

#define CRYPTOGRAPHY_PACKAGE_VERSION "42.0.5"

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 384), // ASN1_ENUMERATED *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1244), // ASN1_GENERALIZEDTIME *()(ASN1_OCTET_STRING const *, ASN1_GENERALIZEDTIME * *)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 1530), // ASN1_OCTET_STRING const *
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 1244), // ASN1_GENERALIZEDTIME * *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // ASN1_INTEGER *()(BIGNUM *, ASN1_INTEGER *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 1533), // BIGNUM *
/*  8 */ _CFFI_OP(_CFFI_OP_POINTER, 1527), // ASN1_INTEGER *
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION, 8), // ASN1_INTEGER *()(X509 *)
/* 11 */ _CFFI_OP(_CFFI_OP_POINTER, 1592), // X509 *
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 435), // ASN1_INTEGER const *()(X509_REVOKED const *)
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 1603), // X509_REVOKED const *
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1528), // ASN1_OBJECT *()(X509_EXTENSION *)
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 1597), // X509_EXTENSION *
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1528), // ASN1_OBJECT *()(X509_NAME_ENTRY const *)
/* 20 */ _CFFI_OP(_CFFI_OP_POINTER, 1600), // X509_NAME_ENTRY const *
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ASN1_OCTET_STRING *()(ASN1_OCTET_STRING *, long)
/* 23 */ _CFFI_OP(_CFFI_OP_POINTER, 1530), // ASN1_OCTET_STRING *
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9), // long
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ASN1_OCTET_STRING *()(X509 const *)
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 1592), // X509 const *
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ASN1_OCTET_STRING *()(X509_EXTENSION *)
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ASN1_OCTET_STRING *()(X509_NAME_ENTRY const *)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 20),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ASN1_OCTET_STRING *()(void)
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // ASN1_OCTET_STRING const *()(X509_REVOKED const *)
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // BIGNUM *()(ASN1_INTEGER *, BIGNUM *)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // BIGNUM *()(void)
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION, 84), // BIO *()(BIO_METHOD *)
/* 47 */ _CFFI_OP(_CFFI_OP_POINTER, 1537), // BIO_METHOD *
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 84), // BIO *()(char const *, char const *)
/* 50 */ _CFFI_OP(_CFFI_OP_POINTER, 1607), // char const *
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 84), // BIO *()(void const *, int)
/* 54 */ _CFFI_OP(_CFFI_OP_POINTER, 1612), // void const *
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 677), // BIO_ADDR *()(void)
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1536), // BIO_METHOD const *()(void)
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 160), // Cryptography_STACK_OF_X509 *()(SSL const *)
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 1585), // SSL const *
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION, 160), // Cryptography_STACK_OF_X509 *()(X509_STORE_CTX *)
/* 65 */ _CFFI_OP(_CFFI_OP_POINTER, 1605), // X509_STORE_CTX *
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 160), // Cryptography_STACK_OF_X509 *()(void)
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 287), // Cryptography_STACK_OF_X509_NAME *()(SSL const *)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 287), // Cryptography_STACK_OF_X509_NAME *()(char const *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 287), // Cryptography_STACK_OF_X509_NAME *()(void)
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 518), // Cryptography_STACK_OF_X509_OBJECT *()(X509_STORE *)
/* 78 */ _CFFI_OP(_CFFI_OP_POINTER, 1604), // X509_STORE *
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 325), // Cryptography_STACK_OF_X509_REVOKED *()(X509_CRL *)
/* 81 */ _CFFI_OP(_CFFI_OP_POINTER, 1596), // X509_CRL *
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1123), // DH *()(BIO *, DH * *, int(*)(char *, int, int, void *), void *)
/* 84 */ _CFFI_OP(_CFFI_OP_POINTER, 1534), // BIO *
/* 85 */ _CFFI_OP(_CFFI_OP_POINTER, 1123), // DH * *
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 1054), // int(*)(char *, int, int, void *)
/* 87 */ _CFFI_OP(_CFFI_OP_POINTER, 1612), // void *
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 524), // DSA *()(void)
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1127), // EC_KEY *()(int)
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION, 125), // ENGINE *()(char const *)
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 125), // ENGINE *()(void)
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1283), // EVP_CIPHER *()(OSSL_LIB_CTX *, char const *, char const *)
/* 100 */ _CFFI_OP(_CFFI_OP_POINTER, 1565), // OSSL_LIB_CTX *
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 444), // EVP_CIPHER const *()(char const *)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 553), // EVP_CIPHER_CTX *()(void)
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 587), // EVP_MD const *()(char const *)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 586), // EVP_MD_CTX *()(void)
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(BIO *, EVP_PKEY * *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 116 */ _CFFI_OP(_CFFI_OP_POINTER, 158), // EVP_PKEY * *
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(BIO *, EVP_PKEY * *, int(*)(char *, int, int, void *), void *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(ENGINE *, char const *, UI_METHOD *, void *)
/* 125 */ _CFFI_OP(_CFFI_OP_POINTER, 1554), // ENGINE *
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 127 */ _CFFI_OP(_CFFI_OP_POINTER, 1591), // UI_METHOD *
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(NETSCAPE_SPKI *)
/* 131 */ _CFFI_OP(_CFFI_OP_POINTER, 1564), // NETSCAPE_SPKI *
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(X509 *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(X509_REQ *)
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 1602), // X509_REQ *
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 158), // EVP_PKEY *()(void)
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 452), // GENERAL_NAME *()(GENERAL_NAMES *, int)
/* 142 */ _CFFI_OP(_CFFI_OP_POINTER, 1563), // GENERAL_NAMES *
/* 143 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 131), // NETSCAPE_SPKI *()(void)
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION, 637), // OSSL_PROVIDER *()(OSSL_LIB_CTX *, char const *)
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 100),
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 456), // PKCS12 *()(BIO *, PKCS12 * *)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 456), // PKCS12 * *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 456), // PKCS12 *()(char *, char *, EVP_PKEY *, X509 *, Cryptography_STACK_OF_X509 *, int, int, int, int, int)
/* 156 */ _CFFI_OP(_CFFI_OP_POINTER, 1607), // char *
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 156),
/* 158 */ _CFFI_OP(_CFFI_OP_POINTER, 1559), // EVP_PKEY *
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 160 */ _CFFI_OP(_CFFI_OP_POINTER, 1542), // Cryptography_STACK_OF_X509 *
/* 161 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 162 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 163 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 165 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 656), // PKCS7 *()(BIO *, BIO * *)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 169 */ _CFFI_OP(_CFFI_OP_POINTER, 84), // BIO * *
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 656), // PKCS7 *()(BIO *, PKCS7 * *)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 173 */ _CFFI_OP(_CFFI_OP_POINTER, 656), // PKCS7 * *
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 656), // PKCS7 *()(BIO *, PKCS7 * *, int(*)(char *, int, int, void *), void *)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 173),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION, 615), // RSA *()(EVP_PKEY *)
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 615), // RSA *()(void)
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1583), // SRTP_PROTECTION_PROFILE *()(SSL *)
/* 187 */ _CFFI_OP(_CFFI_OP_POINTER, 1585), // SSL *
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 187), // SSL *()(SSL_CTX *)
/* 190 */ _CFFI_OP(_CFFI_OP_POINTER, 1587), // SSL_CTX *
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION, 370), // SSL_CIPHER const *()(SSL *, unsigned char const *)
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 194 */ _CFFI_OP(_CFFI_OP_POINTER, 1611), // unsigned char const *
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 370), // SSL_CIPHER const *()(SSL const *)
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // SSL_CTX *()(SSL *, SSL_CTX *)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 190), // SSL_CTX *()(SSL_METHOD *)
/* 204 */ _CFFI_OP(_CFFI_OP_POINTER, 1589), // SSL_METHOD *
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1588), // SSL_METHOD const *()(void)
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 692), // SSL_SESSION *()(SSL *)
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION, 692), // SSL_SESSION *()(SSL const *)
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION, 692), // SSL_SESSION *()(void)
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(BIO *, X509 * *)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 218 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // X509 * *
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(BIO *, X509 * *, int(*)(char *, int, int, void *), void *)
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 222 */ _CFFI_OP(_CFFI_OP_NOOP, 218),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(Cryptography_STACK_OF_X509 *, int)
/* 227 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(SSL const *)
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(X509 *)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(X509_STORE_CTX *)
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // X509 *()(void)
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1253), // X509_ALGOR const *()(X509 const *)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 81), // X509_CRL *()(BIO *, X509_CRL * *)
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 246 */ _CFFI_OP(_CFFI_OP_POINTER, 81), // X509_CRL * *
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 81), // X509_CRL *()(BIO *, X509_CRL * *, int(*)(char *, int, int, void *), void *)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 246),
/* 251 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION, 81), // X509_CRL *()(void)
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(CONF *, X509V3_CTX *, char const *, char const *)
/* 257 */ _CFFI_OP(_CFFI_OP_POINTER, 1540), // CONF *
/* 258 */ _CFFI_OP(_CFFI_OP_POINTER, 1593), // X509V3_CTX *
/* 259 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 260 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(X509 const *, int)
/* 263 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(X509_EXTENSION *)
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(X509_EXTENSIONS *, int)
/* 270 */ _CFFI_OP(_CFFI_OP_POINTER, 1598), // X509_EXTENSIONS *
/* 271 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(X509_REVOKED *, int)
/* 274 */ _CFFI_OP(_CFFI_OP_POINTER, 1603), // X509_REVOKED *
/* 275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // X509_EXTENSION *()(X509_REVOKED const *, int)
/* 278 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 270), // X509_EXTENSIONS *()(X509_REQ *)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 270), // X509_EXTENSIONS *()(void)
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 286 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(Cryptography_STACK_OF_X509_NAME *, int)
/* 287 */ _CFFI_OP(_CFFI_OP_POINTER, 1544), // Cryptography_STACK_OF_X509_NAME *
/* 288 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 290 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(X509 const *)
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(X509_CRL *)
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(X509_NAME *)
/* 297 */ _CFFI_OP(_CFFI_OP_POINTER, 1599), // X509_NAME *
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(X509_REQ *)
/* 300 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION, 297), // X509_NAME *()(void)
/* 303 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1467), // X509_NAME_ENTRY *()(X509_NAME *, int)
/* 305 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 306 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1467), // X509_NAME_ENTRY *()(X509_NAME const *, int)
/* 309 */ _CFFI_OP(_CFFI_OP_POINTER, 1599), // X509_NAME const *
/* 310 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // X509_REQ *()(BIO *, X509_REQ * *)
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 314 */ _CFFI_OP(_CFFI_OP_POINTER, 137), // X509_REQ * *
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // X509_REQ *()(BIO *, X509_REQ * *, int(*)(char *, int, int, void *), void *)
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 314),
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // X509_REQ *()(void)
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 324 */ _CFFI_OP(_CFFI_OP_FUNCTION, 274), // X509_REVOKED *()(Cryptography_STACK_OF_X509_REVOKED *, int)
/* 325 */ _CFFI_OP(_CFFI_OP_POINTER, 1547), // Cryptography_STACK_OF_X509_REVOKED *
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 328 */ _CFFI_OP(_CFFI_OP_FUNCTION, 274), // X509_REVOKED *()(X509_REVOKED *)
/* 329 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 274), // X509_REVOKED *()(void)
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 333 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // X509_STORE *()(SSL_CTX const *)
/* 334 */ _CFFI_OP(_CFFI_OP_POINTER, 1587), // SSL_CTX const *
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 336 */ _CFFI_OP(_CFFI_OP_FUNCTION, 78), // X509_STORE *()(void)
/* 337 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION, 65), // X509_STORE_CTX *()(void)
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 340 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1016), // X509_VERIFY_PARAM *()(SSL *)
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 342 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 343 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1016), // X509_VERIFY_PARAM *()(SSL_CTX *)
/* 344 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 346 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1016), // X509_VERIFY_PARAM *()(void)
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 348 */ _CFFI_OP(_CFFI_OP_FUNCTION, 156), // char *()(BIGNUM const *)
/* 349 */ _CFFI_OP(_CFFI_OP_POINTER, 1533), // BIGNUM const *
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION, 156), // char *()(NETSCAPE_SPKI *)
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 353 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 354 */ _CFFI_OP(_CFFI_OP_FUNCTION, 156), // char *()(X509_NAME const *, char *, int)
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 309),
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 156),
/* 357 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(ENGINE const *)
/* 360 */ _CFFI_OP(_CFFI_OP_POINTER, 1554), // ENGINE const *
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 362 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(SSL const *)
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(SSL const *, int)
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 367 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 369 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(SSL_CIPHER const *)
/* 370 */ _CFFI_OP(_CFFI_OP_POINTER, 1586), // SSL_CIPHER const *
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(int)
/* 373 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 374 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 375 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(long)
/* 376 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(unsigned long)
/* 379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 381 */ _CFFI_OP(_CFFI_OP_FUNCTION, 50), // char const *()(void)
/* 382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_ENUMERATED *, long)
/* 384 */ _CFFI_OP(_CFFI_OP_POINTER, 1525), // ASN1_ENUMERATED *
/* 385 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_INTEGER *, long)
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 391 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_OBJECT const *)
/* 392 */ _CFFI_OP(_CFFI_OP_POINTER, 1529), // ASN1_OBJECT const *
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_OCTET_STRING *)
/* 395 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 397 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_OCTET_STRING *, char const *)
/* 398 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 399 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ASN1_OCTET_STRING const *)
/* 402 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 403 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIGNUM * *, char const *)
/* 405 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // BIGNUM * *
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 407 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 408 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIGNUM *, BIGNUM const *)
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 410 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 412 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIGNUM *, BN_ULONG)
/* 413 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 414 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(BN_ULONG), (
           ((BN_ULONG)-1) | 0 /* check that BN_ULONG is an integer type */
         ) <= 0)), // BN_ULONG
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIGNUM *, int, int, BIGNUM const *, BIGNUM const *, BN_GENCB *)
/* 417 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 418 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 419 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 421 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 422 */ _CFFI_OP(_CFFI_OP_POINTER, 1539), // BN_GENCB *
/* 423 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIGNUM const *, int, BN_CTX *, BN_GENCB *)
/* 425 */ _CFFI_OP(_CFFI_OP_NOOP, 349),
/* 426 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 427 */ _CFFI_OP(_CFFI_OP_POINTER, 1538), // BN_CTX *
/* 428 */ _CFFI_OP(_CFFI_OP_NOOP, 422),
/* 429 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 430 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *)
/* 431 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 432 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 433 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, ASN1_INTEGER const *)
/* 434 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 435 */ _CFFI_OP(_CFFI_OP_POINTER, 1527), // ASN1_INTEGER const *
/* 436 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 437 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, EVP_PKEY *)
/* 438 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 439 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 440 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 441 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, EVP_PKEY *, EVP_CIPHER const *, unsigned char *, int, int(*)(char *, int, int, void *), void *)
/* 442 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 443 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 444 */ _CFFI_OP(_CFFI_OP_POINTER, 1555), // EVP_CIPHER const *
/* 445 */ _CFFI_OP(_CFFI_OP_POINTER, 1611), // unsigned char *
/* 446 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 447 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 448 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, GENERAL_NAME *)
/* 451 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 452 */ _CFFI_OP(_CFFI_OP_POINTER, 1562), // GENERAL_NAME *
/* 453 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 454 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, PKCS12 *)
/* 455 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 456 */ _CFFI_OP(_CFFI_OP_POINTER, 1567), // PKCS12 *
/* 457 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 458 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, RSA const *, int)
/* 459 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 460 */ _CFFI_OP(_CFFI_OP_POINTER, 1582), // RSA const *
/* 461 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509 *)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 465 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 466 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 467 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509 *, unsigned long, unsigned long)
/* 468 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 470 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 472 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 473 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509_CRL *)
/* 474 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 475 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 476 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 477 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509_EXTENSION *, unsigned long, int)
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 479 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 480 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 481 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 482 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 483 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509_REQ *)
/* 484 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 485 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 486 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 487 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, X509_REQ *, unsigned long, unsigned long)
/* 488 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 489 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 492 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 493 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, void *, int)
/* 494 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 495 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 496 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 497 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 498 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(BIO *, void const *, int)
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 500 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 502 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 503 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509 *)
/* 504 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 505 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 506 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509 *, X509 *)
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 508 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 509 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 510 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509_NAME *)
/* 511 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 513 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509_NAME *, X509_NAME *)
/* 514 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 515 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 516 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 517 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509_OBJECT *)
/* 518 */ _CFFI_OP(_CFFI_OP_POINTER, 1546), // Cryptography_STACK_OF_X509_OBJECT *
/* 519 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 520 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(Cryptography_STACK_OF_X509_REVOKED *)
/* 521 */ _CFFI_OP(_CFFI_OP_NOOP, 325),
/* 522 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 523 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(DSA *)
/* 524 */ _CFFI_OP(_CFFI_OP_POINTER, 1549), // DSA *
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 526 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(DSA *, int, unsigned char *, int, int *, unsigned long *, BN_GENCB *)
/* 527 */ _CFFI_OP(_CFFI_OP_NOOP, 524),
/* 528 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 529 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 531 */ _CFFI_OP(_CFFI_OP_POINTER, 55), // int *
/* 532 */ _CFFI_OP(_CFFI_OP_POINTER, 379), // unsigned long *
/* 533 */ _CFFI_OP(_CFFI_OP_NOOP, 422),
/* 534 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ENGINE *)
/* 536 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 537 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 538 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ENGINE *, char const *, char const *, int)
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 540 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 541 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 542 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 543 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 544 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(ENGINE *, char const *, long, void *, void(*)(void), int)
/* 545 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 546 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 547 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 548 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 549 */ _CFFI_OP(_CFFI_OP_POINTER, 1520), // void(*)(void)
/* 550 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 551 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 552 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *)
/* 553 */ _CFFI_OP(_CFFI_OP_POINTER, 1556), // EVP_CIPHER_CTX *
/* 554 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 555 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *, EVP_CIPHER const *, ENGINE *, unsigned char const *, unsigned char const *, int)
/* 556 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 557 */ _CFFI_OP(_CFFI_OP_NOOP, 444),
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 559 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 560 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 562 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 563 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *, int)
/* 564 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 565 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 566 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 567 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *, int, int, void *)
/* 568 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 569 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 570 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 571 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 573 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *, unsigned char *, int *)
/* 574 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 576 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_CIPHER_CTX *, unsigned char *, int *, unsigned char const *, int)
/* 579 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 580 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 581 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 582 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 583 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 584 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_MD_CTX *, EVP_MD const *)
/* 586 */ _CFFI_OP(_CFFI_OP_POINTER, 1558), // EVP_MD_CTX *
/* 587 */ _CFFI_OP(_CFFI_OP_POINTER, 1557), // EVP_MD const *
/* 588 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 589 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_MD_CTX *, unsigned char *, unsigned int *, EVP_PKEY *)
/* 590 */ _CFFI_OP(_CFFI_OP_NOOP, 586),
/* 591 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 592 */ _CFFI_OP(_CFFI_OP_POINTER, 598), // unsigned int *
/* 593 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 594 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 595 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_MD_CTX *, unsigned char const *, unsigned int, EVP_PKEY *)
/* 596 */ _CFFI_OP(_CFFI_OP_NOOP, 586),
/* 597 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 598 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 599 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 600 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 601 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_MD_CTX *, void const *, size_t)
/* 602 */ _CFFI_OP(_CFFI_OP_NOOP, 586),
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 604 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 606 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_PKEY *)
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 608 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 609 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_PKEY *, DSA *)
/* 610 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 611 */ _CFFI_OP(_CFFI_OP_NOOP, 524),
/* 612 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 613 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_PKEY *, RSA *)
/* 614 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 615 */ _CFFI_OP(_CFFI_OP_POINTER, 1582), // RSA *
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 617 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(EVP_PKEY const *)
/* 618 */ _CFFI_OP(_CFFI_OP_POINTER, 1559), // EVP_PKEY const *
/* 619 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 620 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(GENERAL_NAMES *)
/* 621 */ _CFFI_OP(_CFFI_OP_NOOP, 142),
/* 622 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 623 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(NETSCAPE_SPKI *, EVP_PKEY *)
/* 624 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 625 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 626 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 627 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(NETSCAPE_SPKI *, EVP_PKEY *, EVP_MD const *)
/* 628 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 629 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 630 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 631 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 632 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(OSSL_LIB_CTX *, int)
/* 633 */ _CFFI_OP(_CFFI_OP_NOOP, 100),
/* 634 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 635 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 636 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(OSSL_PROVIDER *)
/* 637 */ _CFFI_OP(_CFFI_OP_POINTER, 1566), // OSSL_PROVIDER *
/* 638 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 639 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(PKCS12 *, char const *, EVP_PKEY * *, X509 * *, Cryptography_STACK_OF_X509 * *)
/* 640 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 641 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 642 */ _CFFI_OP(_CFFI_OP_NOOP, 116),
/* 643 */ _CFFI_OP(_CFFI_OP_NOOP, 218),
/* 644 */ _CFFI_OP(_CFFI_OP_POINTER, 160), // Cryptography_STACK_OF_X509 * *
/* 645 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 646 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(PKCS12 *, char const *, int, unsigned char *, int, int, EVP_MD const *)
/* 647 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 648 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 649 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 650 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 651 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 652 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 653 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 654 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 655 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(PKCS7 *, Cryptography_STACK_OF_X509 *, X509_STORE *, BIO *, BIO *, int)
/* 656 */ _CFFI_OP(_CFFI_OP_POINTER, 1568), // PKCS7 *
/* 657 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 658 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 659 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 660 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 661 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 662 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 663 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(RSA *, int, BIGNUM *, BN_GENCB *)
/* 664 */ _CFFI_OP(_CFFI_OP_NOOP, 615),
/* 665 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 666 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 667 */ _CFFI_OP(_CFFI_OP_NOOP, 422),
/* 668 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 669 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(RSA const *)
/* 670 */ _CFFI_OP(_CFFI_OP_NOOP, 460),
/* 671 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 672 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *)
/* 673 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 674 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 675 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, BIO_ADDR *)
/* 676 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 677 */ _CFFI_OP(_CFFI_OP_POINTER, 1535), // BIO_ADDR *
/* 678 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 679 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *)
/* 680 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 681 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 682 */ _CFFI_OP(_CFFI_OP_POINTER, 194), // unsigned char const * *
/* 683 */ _CFFI_OP(_CFFI_OP_POINTER, 604), // size_t *
/* 684 */ _CFFI_OP(_CFFI_OP_POINTER, 692), // SSL_SESSION * *
/* 685 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 686 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, EVP_PKEY *)
/* 687 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 688 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 689 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 690 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, SSL_SESSION *)
/* 691 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 692 */ _CFFI_OP(_CFFI_OP_POINTER, 1590), // SSL_SESSION *
/* 693 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 694 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, X509 *)
/* 695 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 696 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 697 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 698 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, char const *)
/* 699 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 700 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 701 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 702 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, int *, void *)
/* 703 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 704 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 705 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 706 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 707 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, int)
/* 708 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 709 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 711 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned char *, size_t, char const *, size_t, unsigned char const *, size_t, int)
/* 712 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 713 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 714 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 715 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 716 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 717 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 718 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 719 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 720 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 721 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned char *, unsigned int *)
/* 722 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 723 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 724 */ _CFFI_OP(_CFFI_OP_NOOP, 592),
/* 725 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 726 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *)
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 728 */ _CFFI_OP(_CFFI_OP_NOOP, 682),
/* 729 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 730 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 731 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 732 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 733 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 734 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned char const *, size_t, SSL_SESSION * *)
/* 735 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 736 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 737 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 738 */ _CFFI_OP(_CFFI_OP_NOOP, 684),
/* 739 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 740 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned char const *, unsigned int)
/* 741 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 742 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 743 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 744 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 745 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *)
/* 746 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 747 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 682),
/* 749 */ _CFFI_OP(_CFFI_OP_NOOP, 683),
/* 750 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 751 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 752 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 753 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, unsigned int, unsigned char const *, size_t, int *, void *)
/* 754 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 755 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 756 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 757 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 758 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 759 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 760 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 761 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, void *)
/* 762 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 763 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 764 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 765 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, void *, int)
/* 766 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 767 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 768 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 769 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 770 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, void *, size_t, size_t *)
/* 771 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 772 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 773 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 774 */ _CFFI_OP(_CFFI_OP_NOOP, 683),
/* 775 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 776 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, void const *, int)
/* 777 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 778 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 779 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 780 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 781 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL *, void const *, size_t, size_t *)
/* 782 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 783 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 784 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 785 */ _CFFI_OP(_CFFI_OP_NOOP, 683),
/* 786 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 787 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL const *)
/* 788 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 789 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 790 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL const *, int)
/* 791 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 792 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 793 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 794 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CIPHER const *, int *)
/* 795 */ _CFFI_OP(_CFFI_OP_NOOP, 370),
/* 796 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 797 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 798 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *)
/* 799 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 800 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 801 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, ENGINE *)
/* 802 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 803 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 804 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 805 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, EVP_PKEY *)
/* 806 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 807 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 808 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 809 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, X509 *)
/* 810 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 811 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 812 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 813 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, char const *)
/* 814 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 815 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 816 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 817 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, char const *, char const *)
/* 818 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 819 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 820 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 822 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, char const *, int)
/* 823 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 824 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 825 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 826 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 827 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, uint32_t)
/* 828 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 829 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 830 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 831 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, unsigned char const *, unsigned int)
/* 832 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 833 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 834 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 835 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX *, unsigned int, int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *), void(*)(SSL *, unsigned int, unsigned char const *, void *), void *, int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *), void *)
/* 837 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 838 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 839 */ _CFFI_OP(_CFFI_OP_POINTER, 745), // int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *)
/* 840 */ _CFFI_OP(_CFFI_OP_POINTER, 1335), // void(*)(SSL *, unsigned int, unsigned char const *, void *)
/* 841 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 842 */ _CFFI_OP(_CFFI_OP_POINTER, 753), // int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *)
/* 843 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 844 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 845 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_CTX const *)
/* 846 */ _CFFI_OP(_CFFI_OP_NOOP, 334),
/* 847 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 848 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_SESSION *, SSL_CIPHER const *)
/* 849 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 850 */ _CFFI_OP(_CFFI_OP_NOOP, 370),
/* 851 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 852 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_SESSION *, int)
/* 853 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 854 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 855 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 856 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(SSL_SESSION *, unsigned char const *, size_t)
/* 857 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 858 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 859 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 860 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 861 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 * *, X509_STORE_CTX *, X509 *)
/* 862 */ _CFFI_OP(_CFFI_OP_NOOP, 218),
/* 863 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 864 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 865 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 866 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *)
/* 867 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 868 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 869 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, ASN1_INTEGER *)
/* 870 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 871 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 872 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 873 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, EVP_PKEY *)
/* 874 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 875 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 876 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 877 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, EVP_PKEY *, EVP_MD const *)
/* 878 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 879 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 880 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 881 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 882 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, X509_EXTENSION *, int)
/* 883 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 884 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 885 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 886 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 887 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, X509_NAME *)
/* 888 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 889 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 890 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 891 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, long)
/* 892 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 893 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 894 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 895 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 *, unsigned char const *, int)
/* 896 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 897 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 898 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 899 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 900 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 const *)
/* 901 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 902 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 903 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509 const *, EVP_MD const *, unsigned char *, unsigned int *)
/* 904 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 905 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 906 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 907 */ _CFFI_OP(_CFFI_OP_NOOP, 592),
/* 908 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 909 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *)
/* 910 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 911 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 912 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *, ASN1_OCTET_STRING const *)
/* 913 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 914 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 915 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 916 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *, EVP_PKEY *, EVP_MD const *)
/* 917 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 918 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 919 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 920 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 921 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *, X509_NAME *)
/* 922 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 923 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 924 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 925 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *, X509_REVOKED *)
/* 926 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 927 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 928 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 929 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_CRL *, long)
/* 930 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 931 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 932 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 933 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_EXTENSION const *)
/* 934 */ _CFFI_OP(_CFFI_OP_POINTER, 1597), // X509_EXTENSION const *
/* 935 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 936 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_EXTENSIONS *)
/* 937 */ _CFFI_OP(_CFFI_OP_NOOP, 270),
/* 938 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 939 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_EXTENSIONS *, X509_EXTENSION *)
/* 940 */ _CFFI_OP(_CFFI_OP_NOOP, 270),
/* 941 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 942 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 943 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_NAME *, int, int)
/* 944 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 945 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 946 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 947 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 948 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_NAME *, int, int, unsigned char const *, int, int, int)
/* 949 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 950 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 951 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 952 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 953 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 954 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 955 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 956 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 957 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_NAME *, unsigned char * *)
/* 958 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 959 */ _CFFI_OP(_CFFI_OP_POINTER, 445), // unsigned char * *
/* 960 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 961 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_NAME const *)
/* 962 */ _CFFI_OP(_CFFI_OP_NOOP, 309),
/* 963 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 964 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_NAME const *, X509_NAME const *)
/* 965 */ _CFFI_OP(_CFFI_OP_NOOP, 309),
/* 966 */ _CFFI_OP(_CFFI_OP_NOOP, 309),
/* 967 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 968 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REQ *, EVP_PKEY *)
/* 969 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 970 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 971 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 972 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REQ *, EVP_PKEY *, EVP_MD const *)
/* 973 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 974 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 975 */ _CFFI_OP(_CFFI_OP_NOOP, 587),
/* 976 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 977 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REQ *, X509_EXTENSIONS *)
/* 978 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 979 */ _CFFI_OP(_CFFI_OP_NOOP, 270),
/* 980 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 981 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REQ *, long)
/* 982 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 983 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 984 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 985 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REVOKED *, ASN1_INTEGER *)
/* 986 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 987 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 988 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 989 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REVOKED *, ASN1_OCTET_STRING *)
/* 990 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 991 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 992 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 993 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REVOKED *, int, void *, int, unsigned long)
/* 994 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 995 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 996 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 997 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 998 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 999 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1000 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_REVOKED const *)
/* 1001 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 1002 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1003 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *)
/* 1004 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1005 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1006 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, X509 *)
/* 1007 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1008 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1009 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1010 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, X509_CRL *)
/* 1011 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1012 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 1013 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1014 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, X509_VERIFY_PARAM *)
/* 1015 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1016 */ _CFFI_OP(_CFFI_OP_POINTER, 1606), // X509_VERIFY_PARAM *
/* 1017 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1018 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, char const *, char const *)
/* 1019 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1020 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1021 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1022 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1023 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, int)
/* 1024 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1025 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1026 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1027 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE *, unsigned long)
/* 1028 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1029 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 1030 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1031 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE_CTX *)
/* 1032 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1033 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1034 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_STORE_CTX *, X509_STORE *, X509 *, Cryptography_STACK_OF_X509 *)
/* 1035 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1036 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1037 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1038 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 1039 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1040 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_VERIFY_PARAM *, char const *, size_t)
/* 1041 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1042 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1043 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1044 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1045 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_VERIFY_PARAM *, unsigned char const *, size_t)
/* 1046 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1047 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 1048 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1049 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1050 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(X509_VERIFY_PARAM *, unsigned long)
/* 1051 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1052 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 1053 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1054 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(char *, int, int, void *)
/* 1055 */ _CFFI_OP(_CFFI_OP_NOOP, 156),
/* 1056 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1057 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1058 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1059 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1060 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(char const *)
/* 1061 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1062 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1063 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(int)
/* 1064 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1065 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1066 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(int, X509_STORE_CTX *)
/* 1067 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1068 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1069 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1070 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(unsigned char * *, ASN1_OCTET_STRING const *)
/* 1071 */ _CFFI_OP(_CFFI_OP_NOOP, 959),
/* 1072 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 1073 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1074 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(unsigned char *, int)
/* 1075 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1076 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1077 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1078 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(unsigned int)
/* 1079 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1080 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1081 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(unsigned long)
/* 1082 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10),
/* 1083 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1084 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // int()(void)
/* 1085 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1086 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(BIO *, char * *)
/* 1087 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 1088 */ _CFFI_OP(_CFFI_OP_POINTER, 156), // char * *
/* 1089 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1090 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(BIO *, int)
/* 1091 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 1092 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1093 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1094 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL *)
/* 1095 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1096 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1097 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL *, long)
/* 1098 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1099 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 1100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL *, time_t *, long *)
/* 1102 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1103 */ _CFFI_OP(_CFFI_OP_POINTER, 1490), // time_t *
/* 1104 */ _CFFI_OP(_CFFI_OP_POINTER, 24), // long *
/* 1105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL *, unsigned char *, int)
/* 1107 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1108 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL *, unsigned char const * *)
/* 1112 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1113 */ _CFFI_OP(_CFFI_OP_NOOP, 682),
/* 1114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL const *)
/* 1116 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *)
/* 1119 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, DH *)
/* 1122 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1123 */ _CFFI_OP(_CFFI_OP_POINTER, 1548), // DH *
/* 1124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, EC_KEY *)
/* 1126 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1127 */ _CFFI_OP(_CFFI_OP_POINTER, 1551), // EC_KEY *
/* 1128 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1129 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, X509 *)
/* 1130 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1131 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, char const *)
/* 1134 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1135 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, int(*)(SSL *, void *))
/* 1138 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1139 */ _CFFI_OP(_CFFI_OP_POINTER, 761), // int(*)(SSL *, void *)
/* 1140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, int)
/* 1142 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1143 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, long)
/* 1146 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1147 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9),
/* 1148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX *, void *)
/* 1150 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1151 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(SSL_CTX const *)
/* 1154 */ _CFFI_OP(_CFFI_OP_NOOP, 334),
/* 1155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(X509 *)
/* 1157 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1158 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1159 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // long()(X509_REQ *)
/* 1160 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 1161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 604), // size_t()(EC_builtin_curve *, size_t)
/* 1163 */ _CFFI_OP(_CFFI_OP_POINTER, 1553), // EC_builtin_curve *
/* 1164 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 604), // size_t()(SSL *)
/* 1167 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 604), // size_t()(SSL const *, unsigned char *, size_t)
/* 1170 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1171 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1172 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1173 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1174 */ _CFFI_OP(_CFFI_OP_FUNCTION, 604), // size_t()(SSL const *, void *, size_t)
/* 1175 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1176 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 604), // size_t()(SSL_SESSION const *, unsigned char *, size_t)
/* 1180 */ _CFFI_OP(_CFFI_OP_POINTER, 1590), // SSL_SESSION const *
/* 1181 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1182 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 829), // uint32_t()(SSL_SESSION const *)
/* 1185 */ _CFFI_OP(_CFFI_OP_NOOP, 1180),
/* 1186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1192), // uint64_t()(SSL *)
/* 1188 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1189 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1190 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1192), // uint64_t()(SSL *, uint64_t)
/* 1191 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1192 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 1193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1192), // uint64_t()(SSL_CTX *)
/* 1195 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1196 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1197 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1192), // uint64_t()(SSL_CTX *, uint64_t)
/* 1198 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1199 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24),
/* 1200 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1201 */ _CFFI_OP(_CFFI_OP_FUNCTION, 445), // unsigned char *()(X509 *, int *)
/* 1202 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1203 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 1204 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1205 */ _CFFI_OP(_CFFI_OP_FUNCTION, 194), // unsigned char const *()(ASN1_OCTET_STRING const *)
/* 1206 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 1207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 598), // unsigned int()(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int)
/* 1209 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1210 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1211 */ _CFFI_OP(_CFFI_OP_NOOP, 156),
/* 1212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1213 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1214 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 598), // unsigned int()(SSL *, char const *, unsigned char *, unsigned int)
/* 1217 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1218 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1219 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 1220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 379), // unsigned long()(X509 *)
/* 1223 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 379), // unsigned long()(X509_NAME *)
/* 1226 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 1227 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1228 */ _CFFI_OP(_CFFI_OP_FUNCTION, 379), // unsigned long()(void)
/* 1229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 87), // void *()(X509_EXTENSION *)
/* 1231 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 1232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 87), // void *()(X509_STORE_CTX *, int)
/* 1234 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1235 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1236 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1237 */ _CFFI_OP(_CFFI_OP_FUNCTION, 87), // void *()(size_t)
/* 1238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ASN1_ENUMERATED *)
/* 1241 */ _CFFI_OP(_CFFI_OP_NOOP, 384),
/* 1242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ASN1_GENERALIZEDTIME *)
/* 1244 */ _CFFI_OP(_CFFI_OP_POINTER, 1526), // ASN1_GENERALIZEDTIME *
/* 1245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ASN1_INTEGER *)
/* 1247 */ _CFFI_OP(_CFFI_OP_NOOP, 8),
/* 1248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ASN1_OBJECT const * *, int *, void const * *, X509_ALGOR const *)
/* 1250 */ _CFFI_OP(_CFFI_OP_POINTER, 392), // ASN1_OBJECT const * *
/* 1251 */ _CFFI_OP(_CFFI_OP_NOOP, 531),
/* 1252 */ _CFFI_OP(_CFFI_OP_POINTER, 54), // void const * *
/* 1253 */ _CFFI_OP(_CFFI_OP_POINTER, 1594), // X509_ALGOR const *
/* 1254 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1255 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ASN1_OCTET_STRING *)
/* 1256 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 1257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(BIGNUM *)
/* 1259 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 1260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(BIO_ADDR *)
/* 1262 */ _CFFI_OP(_CFFI_OP_NOOP, 677),
/* 1263 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1264 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(Cryptography_STACK_OF_X509 *)
/* 1265 */ _CFFI_OP(_CFFI_OP_NOOP, 160),
/* 1266 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1267 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(Cryptography_STACK_OF_X509_NAME *)
/* 1268 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 1269 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1270 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(DH *)
/* 1271 */ _CFFI_OP(_CFFI_OP_NOOP, 1123),
/* 1272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(DSA *)
/* 1274 */ _CFFI_OP(_CFFI_OP_NOOP, 524),
/* 1275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(EC_KEY *)
/* 1277 */ _CFFI_OP(_CFFI_OP_NOOP, 1127),
/* 1278 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1279 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(ENGINE *)
/* 1280 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 1281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(EVP_CIPHER *)
/* 1283 */ _CFFI_OP(_CFFI_OP_POINTER, 1555), // EVP_CIPHER *
/* 1284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(EVP_CIPHER_CTX *)
/* 1286 */ _CFFI_OP(_CFFI_OP_NOOP, 553),
/* 1287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(EVP_MD_CTX *)
/* 1289 */ _CFFI_OP(_CFFI_OP_NOOP, 586),
/* 1290 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1291 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(EVP_PKEY *)
/* 1292 */ _CFFI_OP(_CFFI_OP_NOOP, 158),
/* 1293 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1294 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(GENERAL_NAMES *)
/* 1295 */ _CFFI_OP(_CFFI_OP_NOOP, 142),
/* 1296 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1297 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(NETSCAPE_SPKI *)
/* 1298 */ _CFFI_OP(_CFFI_OP_NOOP, 131),
/* 1299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(PKCS12 *)
/* 1301 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 1302 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1303 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(PKCS7 *)
/* 1304 */ _CFFI_OP(_CFFI_OP_NOOP, 656),
/* 1305 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1306 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(RSA *)
/* 1307 */ _CFFI_OP(_CFFI_OP_NOOP, 615),
/* 1308 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1309 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *)
/* 1310 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1311 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1312 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, BIO *, BIO *)
/* 1313 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1314 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 1315 */ _CFFI_OP(_CFFI_OP_NOOP, 84),
/* 1316 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1317 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, char *)
/* 1318 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1319 */ _CFFI_OP(_CFFI_OP_NOOP, 156),
/* 1320 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1321 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, int(*)(SSL *, void *), void *)
/* 1322 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1323 */ _CFFI_OP(_CFFI_OP_NOOP, 1139),
/* 1324 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1325 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1326 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, int)
/* 1327 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1328 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1329 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1330 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, int, int(*)(int, X509_STORE_CTX *))
/* 1331 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1332 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1333 */ _CFFI_OP(_CFFI_OP_POINTER, 1066), // int(*)(int, X509_STORE_CTX *)
/* 1334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL *, unsigned int, unsigned char const *, void *)
/* 1336 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1338 */ _CFFI_OP(_CFFI_OP_NOOP, 194),
/* 1339 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1340 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1341 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL const *, char const *)
/* 1342 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1343 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1344 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1345 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL const *, int, int)
/* 1346 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1347 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1348 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1349 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1350 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL const *, unsigned char const * *, unsigned int *)
/* 1351 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 1352 */ _CFFI_OP(_CFFI_OP_NOOP, 682),
/* 1353 */ _CFFI_OP(_CFFI_OP_NOOP, 592),
/* 1354 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1355 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *)
/* 1356 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, Cryptography_STACK_OF_X509_NAME *)
/* 1359 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1360 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 1361 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1362 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, X509_STORE *)
/* 1363 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1364 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *))
/* 1367 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1368 */ _CFFI_OP(_CFFI_OP_POINTER, 679), // int(*)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *)
/* 1369 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1370 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, int *, void *))
/* 1371 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1372 */ _CFFI_OP(_CFFI_OP_POINTER, 702), // int(*)(SSL *, int *, void *)
/* 1373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1374 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, unsigned char *, unsigned int *))
/* 1375 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1376 */ _CFFI_OP(_CFFI_OP_POINTER, 721), // int(*)(SSL *, unsigned char *, unsigned int *)
/* 1377 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1378 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *), void *)
/* 1379 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1380 */ _CFFI_OP(_CFFI_OP_POINTER, 726), // int(*)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *)
/* 1381 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, unsigned char const *, size_t, SSL_SESSION * *))
/* 1384 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1385 */ _CFFI_OP(_CFFI_OP_POINTER, 734), // int(*)(SSL *, unsigned char const *, size_t, SSL_SESSION * *)
/* 1386 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1387 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, unsigned char const *, unsigned int))
/* 1388 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1389 */ _CFFI_OP(_CFFI_OP_POINTER, 740), // int(*)(SSL *, unsigned char const *, unsigned int)
/* 1390 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1391 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(SSL *, void *), void *)
/* 1392 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1393 */ _CFFI_OP(_CFFI_OP_NOOP, 1139),
/* 1394 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1395 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1396 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int(*)(char *, int, int, void *))
/* 1397 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1398 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 1399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int)
/* 1401 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1402 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1403 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1404 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, int, int(*)(int, X509_STORE_CTX *))
/* 1405 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1406 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1407 */ _CFFI_OP(_CFFI_OP_NOOP, 1333),
/* 1408 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1409 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, unsigned int(*)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int))
/* 1410 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1411 */ _CFFI_OP(_CFFI_OP_POINTER, 1208), // unsigned int(*)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int)
/* 1412 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1413 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, unsigned int(*)(SSL *, char const *, unsigned char *, unsigned int))
/* 1414 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1415 */ _CFFI_OP(_CFFI_OP_POINTER, 1216), // unsigned int(*)(SSL *, char const *, unsigned char *, unsigned int)
/* 1416 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1417 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, void *)
/* 1418 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1419 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1420 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1421 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, void(*)(SSL const *, char const *))
/* 1422 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1423 */ _CFFI_OP(_CFFI_OP_POINTER, 1341), // void(*)(SSL const *, char const *)
/* 1424 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1425 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, void(*)(SSL const *, int, int))
/* 1426 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1427 */ _CFFI_OP(_CFFI_OP_POINTER, 1345), // void(*)(SSL const *, int, int)
/* 1428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1429 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_CTX *, void(*)(int, int, int, void const *, size_t, SSL *, void *))
/* 1430 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1431 */ _CFFI_OP(_CFFI_OP_POINTER, 1503), // void(*)(int, int, int, void const *, size_t, SSL *, void *)
/* 1432 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1433 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(SSL_SESSION *)
/* 1434 */ _CFFI_OP(_CFFI_OP_NOOP, 692),
/* 1435 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1436 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509 *)
/* 1437 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1438 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1439 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509V3_CTX *)
/* 1440 */ _CFFI_OP(_CFFI_OP_NOOP, 258),
/* 1441 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1442 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509V3_CTX *, X509 *, X509 *, X509_REQ *, X509_CRL *, int)
/* 1443 */ _CFFI_OP(_CFFI_OP_NOOP, 258),
/* 1444 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1445 */ _CFFI_OP(_CFFI_OP_NOOP, 11),
/* 1446 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 1447 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 1448 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_CRL *)
/* 1451 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 1452 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1453 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_EXTENSION *)
/* 1454 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 1455 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1456 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_EXTENSIONS *)
/* 1457 */ _CFFI_OP(_CFFI_OP_NOOP, 270),
/* 1458 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1459 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_EXTENSIONS *, void(*)(X509_EXTENSION *))
/* 1460 */ _CFFI_OP(_CFFI_OP_NOOP, 270),
/* 1461 */ _CFFI_OP(_CFFI_OP_POINTER, 1453), // void(*)(X509_EXTENSION *)
/* 1462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_NAME *)
/* 1464 */ _CFFI_OP(_CFFI_OP_NOOP, 297),
/* 1465 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1466 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_NAME_ENTRY *)
/* 1467 */ _CFFI_OP(_CFFI_OP_POINTER, 1600), // X509_NAME_ENTRY *
/* 1468 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1469 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_REQ *)
/* 1470 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 1471 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1472 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_REVOKED *)
/* 1473 */ _CFFI_OP(_CFFI_OP_NOOP, 274),
/* 1474 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1475 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_STORE *)
/* 1476 */ _CFFI_OP(_CFFI_OP_NOOP, 78),
/* 1477 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1478 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_STORE_CTX *)
/* 1479 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1480 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1481 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_STORE_CTX *, int)
/* 1482 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 1483 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1484 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1485 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_VERIFY_PARAM *)
/* 1486 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1487 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1488 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_VERIFY_PARAM *, time_t)
/* 1489 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1490 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 1491 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1492 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(X509_VERIFY_PARAM *, unsigned int)
/* 1493 */ _CFFI_OP(_CFFI_OP_NOOP, 1016),
/* 1494 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 1495 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1496 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(int, int, int, char const *, int)
/* 1497 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1498 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1499 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1500 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 1501 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1502 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1503 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(int, int, int, void const *, size_t, SSL *, void *)
/* 1504 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1505 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1506 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1507 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 1508 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 1509 */ _CFFI_OP(_CFFI_OP_NOOP, 187),
/* 1510 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1511 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1512 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(void *)
/* 1513 */ _CFFI_OP(_CFFI_OP_NOOP, 87),
/* 1514 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1515 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(void const *, int, double)
/* 1516 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 1517 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 1518 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 1519 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1520 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1612), // void()(void)
/* 1521 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1522 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1423), // void(*()(SSL_CTX *))(SSL const *, char const *)
/* 1523 */ _CFFI_OP(_CFFI_OP_NOOP, 190),
/* 1524 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 1525 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // ASN1_ENUMERATED
/* 1526 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // ASN1_GENERALIZEDTIME
/* 1527 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // ASN1_INTEGER
/* 1528 */ _CFFI_OP(_CFFI_OP_POINTER, 1529), // ASN1_OBJECT *
/* 1529 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // ASN1_OBJECT
/* 1530 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 73), // ASN1_OCTET_STRING
/* 1531 */ _CFFI_OP(_CFFI_OP_POINTER, 1532), // ASN1_TYPE *
/* 1532 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // ASN1_TYPE
/* 1533 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // BIGNUM
/* 1534 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // BIO
/* 1535 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // BIO_ADDR
/* 1536 */ _CFFI_OP(_CFFI_OP_POINTER, 1537), // BIO_METHOD const *
/* 1537 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // BIO_METHOD
/* 1538 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // BN_CTX
/* 1539 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // BN_GENCB
/* 1540 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // CONF
/* 1541 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // Cryptography_STACK_OF_ASN1_OBJECT
/* 1542 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // Cryptography_STACK_OF_X509
/* 1543 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // Cryptography_STACK_OF_X509_CRL
/* 1544 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // Cryptography_STACK_OF_X509_NAME
/* 1545 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // Cryptography_STACK_OF_X509_NAME_ENTRY
/* 1546 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // Cryptography_STACK_OF_X509_OBJECT
/* 1547 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // Cryptography_STACK_OF_X509_REVOKED
/* 1548 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // DH
/* 1549 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // DSA
/* 1550 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // EC_GROUP
/* 1551 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // EC_KEY
/* 1552 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // EC_POINT
/* 1553 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // EC_builtin_curve
/* 1554 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // ENGINE
/* 1555 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // EVP_CIPHER
/* 1556 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // EVP_CIPHER_CTX
/* 1557 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // EVP_MD
/* 1558 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // EVP_MD_CTX
/* 1559 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // EVP_PKEY
/* 1560 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // EVP_PKEY_CTX
/* 1561 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // EXTENDED_KEY_USAGE
/* 1562 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // GENERAL_NAME
/* 1563 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // GENERAL_NAMES
/* 1564 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // NETSCAPE_SPKI
/* 1565 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // OSSL_LIB_CTX
/* 1566 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // OSSL_PROVIDER
/* 1567 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // PKCS12
/* 1568 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // PKCS7
/* 1569 */ _CFFI_OP(_CFFI_OP_POINTER, 1570), // PKCS7_DIGEST *
/* 1570 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // PKCS7_DIGEST
/* 1571 */ _CFFI_OP(_CFFI_OP_POINTER, 1572), // PKCS7_ENCRYPT *
/* 1572 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // PKCS7_ENCRYPT
/* 1573 */ _CFFI_OP(_CFFI_OP_POINTER, 1574), // PKCS7_ENVELOPE *
/* 1574 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // PKCS7_ENVELOPE
/* 1575 */ _CFFI_OP(_CFFI_OP_POINTER, 1576), // PKCS7_SIGNED *
/* 1576 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // PKCS7_SIGNED
/* 1577 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // PKCS7_SIGNER_INFO
/* 1578 */ _CFFI_OP(_CFFI_OP_POINTER, 1579), // PKCS7_SIGN_ENVELOPE *
/* 1579 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // PKCS7_SIGN_ENVELOPE
/* 1580 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // PKCS8_PRIV_KEY_INFO
/* 1581 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // RAND_METHOD
/* 1582 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // RSA
/* 1583 */ _CFFI_OP(_CFFI_OP_POINTER, 1584), // SRTP_PROTECTION_PROFILE *
/* 1584 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // SRTP_PROTECTION_PROFILE
/* 1585 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // SSL
/* 1586 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // SSL_CIPHER
/* 1587 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // SSL_CTX
/* 1588 */ _CFFI_OP(_CFFI_OP_POINTER, 1589), // SSL_METHOD const *
/* 1589 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // SSL_METHOD
/* 1590 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // SSL_SESSION
/* 1591 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // UI_METHOD
/* 1592 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 58), // X509
/* 1593 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 59), // X509V3_CTX
/* 1594 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 60), // X509_ALGOR
/* 1595 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 61), // X509_ATTRIBUTE
/* 1596 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 62), // X509_CRL
/* 1597 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 63), // X509_EXTENSION
/* 1598 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 64), // X509_EXTENSIONS
/* 1599 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 65), // X509_NAME
/* 1600 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 66), // X509_NAME_ENTRY
/* 1601 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 67), // X509_OBJECT
/* 1602 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 68), // X509_REQ
/* 1603 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 69), // X509_REVOKED
/* 1604 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 70), // X509_STORE
/* 1605 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 71), // X509_STORE_CTX
/* 1606 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 72), // X509_VERIFY_PARAM
/* 1607 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 1608 */ _CFFI_OP(_CFFI_OP_POINTER, 861), // int(*)(X509 * *, X509_STORE_CTX *, X509 *)
/* 1609 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $1
/* 1610 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // union $2
/* 1611 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 1612 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ASN1_TYPE(ASN1_TYPE *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->type) | 0);  /* check that 'ASN1_TYPE.type' is an integer */
}
struct _cffi_align_typedef_ASN1_TYPE { char x; ASN1_TYPE y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_EC_builtin_curve(EC_builtin_curve *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->nid) | 0);  /* check that 'EC_builtin_curve.nid' is an integer */
  { char const * *tmp = &p->comment; (void)tmp; }
}
struct _cffi_align_typedef_EC_builtin_curve { char x; EC_builtin_curve y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_GENERAL_NAME(GENERAL_NAME *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->type) | 0);  /* check that 'GENERAL_NAME.type' is an integer */
  /* cannot generate 'union $1' in field 'd': unknown type name */
}
struct _cffi_align_typedef_GENERAL_NAME { char x; GENERAL_NAME y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_PKCS7(PKCS7 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { ASN1_OBJECT * *tmp = &p->type; (void)tmp; }
  /* cannot generate 'union $2' in field 'd': unknown type name */
}
struct _cffi_align_typedef_PKCS7 { char x; PKCS7 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_PKCS7_SIGNED(PKCS7_SIGNED *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { Cryptography_STACK_OF_X509 * *tmp = &p->cert; (void)tmp; }
}
struct _cffi_align_typedef_PKCS7_SIGNED { char x; PKCS7_SIGNED y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_SRTP_PROTECTION_PROFILE(SRTP_PROTECTION_PROFILE *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  (void)((p->id) | 0);  /* check that 'SRTP_PROTECTION_PROFILE.id' is an integer */
}
struct _cffi_align_typedef_SRTP_PROTECTION_PROFILE { char x; SRTP_PROTECTION_PROFILE y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_X509V3_CTX(X509V3_CTX *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { X509 * *tmp = &p->issuer_cert; (void)tmp; }
  { X509 * *tmp = &p->subject_cert; (void)tmp; }
}
struct _cffi_align_typedef_X509V3_CTX { char x; X509V3_CTX y; };

static int _cffi_const_CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH(unsigned long long *o)
{
  int n = (CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH) <= 0;
  *o = (unsigned long long)((CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH) | 0);  /* check that CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_IS_BORINGSSL(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_IS_BORINGSSL) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_IS_BORINGSSL) | 0);  /* check that CRYPTOGRAPHY_IS_BORINGSSL is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_IS_LIBRESSL(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_IS_LIBRESSL) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_IS_LIBRESSL) | 0);  /* check that CRYPTOGRAPHY_IS_LIBRESSL is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380) | 0);  /* check that CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380 is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_OPENSSL_300_OR_GREATER(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_OPENSSL_300_OR_GREATER) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_OPENSSL_300_OR_GREATER) | 0);  /* check that CRYPTOGRAPHY_OPENSSL_300_OR_GREATER is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_OPENSSL_320_OR_GREATER(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_OPENSSL_320_OR_GREATER) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_OPENSSL_320_OR_GREATER) | 0);  /* check that CRYPTOGRAPHY_OPENSSL_320_OR_GREATER is an integer */
  return n;
}

static int _cffi_const_CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E(unsigned long long *o)
{
  int n = (CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E) <= 0;
  *o = (unsigned long long)((CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E) | 0);  /* check that CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E is an integer */
  return n;
}

static void _cffi_const_CRYPTOGRAPHY_PACKAGE_VERSION(char *o)
{
  *(char const * *)o = CRYPTOGRAPHY_PACKAGE_VERSION;
}

static int _cffi_const_Cryptography_HAS_300_EVP_CIPHER(unsigned long long *o)
{
  int n = (Cryptography_HAS_300_EVP_CIPHER) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_300_EVP_CIPHER) | 0);  /* check that Cryptography_HAS_300_EVP_CIPHER is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_300_FIPS(unsigned long long *o)
{
  int n = (Cryptography_HAS_300_FIPS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_300_FIPS) | 0);  /* check that Cryptography_HAS_300_FIPS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_ALPN(unsigned long long *o)
{
  int n = (Cryptography_HAS_ALPN) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_ALPN) | 0);  /* check that Cryptography_HAS_ALPN is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_CUSTOM_EXT(unsigned long long *o)
{
  int n = (Cryptography_HAS_CUSTOM_EXT) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_CUSTOM_EXT) | 0);  /* check that Cryptography_HAS_CUSTOM_EXT is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_DTLS_GET_DATA_MTU(unsigned long long *o)
{
  int n = (Cryptography_HAS_DTLS_GET_DATA_MTU) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_DTLS_GET_DATA_MTU) | 0);  /* check that Cryptography_HAS_DTLS_GET_DATA_MTU is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_ED448(unsigned long long *o)
{
  int n = (Cryptography_HAS_ED448) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_ED448) | 0);  /* check that Cryptography_HAS_ED448 is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_ENGINE(unsigned long long *o)
{
  int n = (Cryptography_HAS_ENGINE) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_ENGINE) | 0);  /* check that Cryptography_HAS_ENGINE is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_EVP_PKEY_DHX(unsigned long long *o)
{
  int n = (Cryptography_HAS_EVP_PKEY_DHX) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_EVP_PKEY_DHX) | 0);  /* check that Cryptography_HAS_EVP_PKEY_DHX is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_GET_EXTMS_SUPPORT(unsigned long long *o)
{
  int n = (Cryptography_HAS_GET_EXTMS_SUPPORT) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_GET_EXTMS_SUPPORT) | 0);  /* check that Cryptography_HAS_GET_EXTMS_SUPPORT is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_IMPLICIT_RSA_REJECTION(unsigned long long *o)
{
  int n = (Cryptography_HAS_IMPLICIT_RSA_REJECTION) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_IMPLICIT_RSA_REJECTION) | 0);  /* check that Cryptography_HAS_IMPLICIT_RSA_REJECTION is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_KEYLOG(unsigned long long *o)
{
  int n = (Cryptography_HAS_KEYLOG) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_KEYLOG) | 0);  /* check that Cryptography_HAS_KEYLOG is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_NEXTPROTONEG(unsigned long long *o)
{
  int n = (Cryptography_HAS_NEXTPROTONEG) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_NEXTPROTONEG) | 0);  /* check that Cryptography_HAS_NEXTPROTONEG is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_OP_NO_RENEGOTIATION(unsigned long long *o)
{
  int n = (Cryptography_HAS_OP_NO_RENEGOTIATION) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_OP_NO_RENEGOTIATION) | 0);  /* check that Cryptography_HAS_OP_NO_RENEGOTIATION is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PKCS12_SET_MAC(unsigned long long *o)
{
  int n = (Cryptography_HAS_PKCS12_SET_MAC) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PKCS12_SET_MAC) | 0);  /* check that Cryptography_HAS_PKCS12_SET_MAC is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PKCS7_FUNCS(unsigned long long *o)
{
  int n = (Cryptography_HAS_PKCS7_FUNCS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PKCS7_FUNCS) | 0);  /* check that Cryptography_HAS_PKCS7_FUNCS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_POLY1305(unsigned long long *o)
{
  int n = (Cryptography_HAS_POLY1305) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_POLY1305) | 0);  /* check that Cryptography_HAS_POLY1305 is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PRIME_CHECKS(unsigned long long *o)
{
  int n = (Cryptography_HAS_PRIME_CHECKS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PRIME_CHECKS) | 0);  /* check that Cryptography_HAS_PRIME_CHECKS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PROVIDERS(unsigned long long *o)
{
  int n = (Cryptography_HAS_PROVIDERS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PROVIDERS) | 0);  /* check that Cryptography_HAS_PROVIDERS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PSK(unsigned long long *o)
{
  int n = (Cryptography_HAS_PSK) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PSK) | 0);  /* check that Cryptography_HAS_PSK is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_PSK_TLSv1_3(unsigned long long *o)
{
  int n = (Cryptography_HAS_PSK_TLSv1_3) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_PSK_TLSv1_3) | 0);  /* check that Cryptography_HAS_PSK_TLSv1_3 is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SCRYPT(unsigned long long *o)
{
  int n = (Cryptography_HAS_SCRYPT) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SCRYPT) | 0);  /* check that Cryptography_HAS_SCRYPT is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SET_CERT_CB(unsigned long long *o)
{
  int n = (Cryptography_HAS_SET_CERT_CB) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SET_CERT_CB) | 0);  /* check that Cryptography_HAS_SET_CERT_CB is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SIGALGS(unsigned long long *o)
{
  int n = (Cryptography_HAS_SIGALGS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SIGALGS) | 0);  /* check that Cryptography_HAS_SIGALGS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SRTP(unsigned long long *o)
{
  int n = (Cryptography_HAS_SRTP) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SRTP) | 0);  /* check that Cryptography_HAS_SRTP is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SSL_COOKIE(unsigned long long *o)
{
  int n = (Cryptography_HAS_SSL_COOKIE) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SSL_COOKIE) | 0);  /* check that Cryptography_HAS_SSL_COOKIE is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF(unsigned long long *o)
{
  int n = (Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF) | 0);  /* check that Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_SSL_ST(unsigned long long *o)
{
  int n = (Cryptography_HAS_SSL_ST) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_SSL_ST) | 0);  /* check that Cryptography_HAS_SSL_ST is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_TLS_ST(unsigned long long *o)
{
  int n = (Cryptography_HAS_TLS_ST) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_TLS_ST) | 0);  /* check that Cryptography_HAS_TLS_ST is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_TLSv1_3_FUNCTIONS(unsigned long long *o)
{
  int n = (Cryptography_HAS_TLSv1_3_FUNCTIONS) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_TLSv1_3_FUNCTIONS) | 0);  /* check that Cryptography_HAS_TLSv1_3_FUNCTIONS is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING(unsigned long long *o)
{
  int n = (Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING) | 0);  /* check that Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING is an integer */
  return n;
}

static int _cffi_const_Cryptography_HAS_VERIFIED_CHAIN(unsigned long long *o)
{
  int n = (Cryptography_HAS_VERIFIED_CHAIN) <= 0;
  *o = (unsigned long long)((Cryptography_HAS_VERIFIED_CHAIN) | 0);  /* check that Cryptography_HAS_VERIFIED_CHAIN is an integer */
  return n;
}

static int _cffi_const_ERR_LIB_EVP(unsigned long long *o)
{
  int n = (ERR_LIB_EVP) <= 0;
  *o = (unsigned long long)((ERR_LIB_EVP) | 0);  /* check that ERR_LIB_EVP is an integer */
  return n;
}

static int _cffi_const_ERR_LIB_PKCS12(unsigned long long *o)
{
  int n = (ERR_LIB_PKCS12) <= 0;
  *o = (unsigned long long)((ERR_LIB_PKCS12) | 0);  /* check that ERR_LIB_PKCS12 is an integer */
  return n;
}

static int _cffi_const_ERR_LIB_PROV(unsigned long long *o)
{
  int n = (ERR_LIB_PROV) <= 0;
  *o = (unsigned long long)((ERR_LIB_PROV) | 0);  /* check that ERR_LIB_PROV is an integer */
  return n;
}

static int _cffi_const_EVP_CTRL_AEAD_GET_TAG(unsigned long long *o)
{
  int n = (EVP_CTRL_AEAD_GET_TAG) <= 0;
  *o = (unsigned long long)((EVP_CTRL_AEAD_GET_TAG) | 0);  /* check that EVP_CTRL_AEAD_GET_TAG is an integer */
  return n;
}

static int _cffi_const_EVP_CTRL_AEAD_SET_IVLEN(unsigned long long *o)
{
  int n = (EVP_CTRL_AEAD_SET_IVLEN) <= 0;
  *o = (unsigned long long)((EVP_CTRL_AEAD_SET_IVLEN) | 0);  /* check that EVP_CTRL_AEAD_SET_IVLEN is an integer */
  return n;
}

static int _cffi_const_EVP_CTRL_AEAD_SET_TAG(unsigned long long *o)
{
  int n = (EVP_CTRL_AEAD_SET_TAG) <= 0;
  *o = (unsigned long long)((EVP_CTRL_AEAD_SET_TAG) | 0);  /* check that EVP_CTRL_AEAD_SET_TAG is an integer */
  return n;
}

static int _cffi_const_EVP_F_EVP_ENCRYPTFINAL_EX(unsigned long long *o)
{
  int n = (EVP_F_EVP_ENCRYPTFINAL_EX) <= 0;
  *o = (unsigned long long)((EVP_F_EVP_ENCRYPTFINAL_EX) | 0);  /* check that EVP_F_EVP_ENCRYPTFINAL_EX is an integer */
  return n;
}

static int _cffi_const_EVP_MAX_MD_SIZE(unsigned long long *o)
{
  int n = (EVP_MAX_MD_SIZE) <= 0;
  *o = (unsigned long long)((EVP_MAX_MD_SIZE) | 0);  /* check that EVP_MAX_MD_SIZE is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_DH(unsigned long long *o)
{
  int n = (EVP_PKEY_DH) <= 0;
  *o = (unsigned long long)((EVP_PKEY_DH) | 0);  /* check that EVP_PKEY_DH is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_DSA(unsigned long long *o)
{
  int n = (EVP_PKEY_DSA) <= 0;
  *o = (unsigned long long)((EVP_PKEY_DSA) | 0);  /* check that EVP_PKEY_DSA is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_EC(unsigned long long *o)
{
  int n = (EVP_PKEY_EC) <= 0;
  *o = (unsigned long long)((EVP_PKEY_EC) | 0);  /* check that EVP_PKEY_EC is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_ED25519(unsigned long long *o)
{
  int n = (EVP_PKEY_ED25519) <= 0;
  *o = (unsigned long long)((EVP_PKEY_ED25519) | 0);  /* check that EVP_PKEY_ED25519 is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_ED448(unsigned long long *o)
{
  int n = (EVP_PKEY_ED448) <= 0;
  *o = (unsigned long long)((EVP_PKEY_ED448) | 0);  /* check that EVP_PKEY_ED448 is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_RSA(unsigned long long *o)
{
  int n = (EVP_PKEY_RSA) <= 0;
  *o = (unsigned long long)((EVP_PKEY_RSA) | 0);  /* check that EVP_PKEY_RSA is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_RSA_PSS(unsigned long long *o)
{
  int n = (EVP_PKEY_RSA_PSS) <= 0;
  *o = (unsigned long long)((EVP_PKEY_RSA_PSS) | 0);  /* check that EVP_PKEY_RSA_PSS is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_X25519(unsigned long long *o)
{
  int n = (EVP_PKEY_X25519) <= 0;
  *o = (unsigned long long)((EVP_PKEY_X25519) | 0);  /* check that EVP_PKEY_X25519 is an integer */
  return n;
}

static int _cffi_const_EVP_PKEY_X448(unsigned long long *o)
{
  int n = (EVP_PKEY_X448) <= 0;
  *o = (unsigned long long)((EVP_PKEY_X448) | 0);  /* check that EVP_PKEY_X448 is an integer */
  return n;
}

static int _cffi_const_EVP_R_BAD_DECRYPT(unsigned long long *o)
{
  int n = (EVP_R_BAD_DECRYPT) <= 0;
  *o = (unsigned long long)((EVP_R_BAD_DECRYPT) | 0);  /* check that EVP_R_BAD_DECRYPT is an integer */
  return n;
}

static int _cffi_const_EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH(unsigned long long *o)
{
  int n = (EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH) <= 0;
  *o = (unsigned long long)((EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH) | 0);  /* check that EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH is an integer */
  return n;
}

static int _cffi_const_EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM(unsigned long long *o)
{
  int n = (EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM) <= 0;
  *o = (unsigned long long)((EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM) | 0);  /* check that EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM is an integer */
  return n;
}

static int _cffi_const_EVP_R_XTS_DUPLICATED_KEYS(unsigned long long *o)
{
  int n = (EVP_R_XTS_DUPLICATED_KEYS) <= 0;
  *o = (unsigned long long)((EVP_R_XTS_DUPLICATED_KEYS) | 0);  /* check that EVP_R_XTS_DUPLICATED_KEYS is an integer */
  return n;
}

static int _cffi_const_GEN_DNS(unsigned long long *o)
{
  int n = (GEN_DNS) <= 0;
  *o = (unsigned long long)((GEN_DNS) | 0);  /* check that GEN_DNS is an integer */
  return n;
}

static int _cffi_const_GEN_EMAIL(unsigned long long *o)
{
  int n = (GEN_EMAIL) <= 0;
  *o = (unsigned long long)((GEN_EMAIL) | 0);  /* check that GEN_EMAIL is an integer */
  return n;
}

static int _cffi_const_GEN_URI(unsigned long long *o)
{
  int n = (GEN_URI) <= 0;
  *o = (unsigned long long)((GEN_URI) | 0);  /* check that GEN_URI is an integer */
  return n;
}

static int _cffi_const_MBSTRING_UTF8(unsigned long long *o)
{
  int n = (MBSTRING_UTF8) <= 0;
  *o = (unsigned long long)((MBSTRING_UTF8) | 0);  /* check that MBSTRING_UTF8 is an integer */
  return n;
}

static int _cffi_const_NID_aes_256_cbc(unsigned long long *o)
{
  int n = (NID_aes_256_cbc) <= 0;
  *o = (unsigned long long)((NID_aes_256_cbc) | 0);  /* check that NID_aes_256_cbc is an integer */
  return n;
}

static int _cffi_const_NID_crl_reason(unsigned long long *o)
{
  int n = (NID_crl_reason) <= 0;
  *o = (unsigned long long)((NID_crl_reason) | 0);  /* check that NID_crl_reason is an integer */
  return n;
}

static int _cffi_const_NID_pbe_WithSHA1And3_Key_TripleDES_CBC(unsigned long long *o)
{
  int n = (NID_pbe_WithSHA1And3_Key_TripleDES_CBC) <= 0;
  *o = (unsigned long long)((NID_pbe_WithSHA1And3_Key_TripleDES_CBC) | 0);  /* check that NID_pbe_WithSHA1And3_Key_TripleDES_CBC is an integer */
  return n;
}

static int _cffi_const_NID_pkcs7_signed(unsigned long long *o)
{
  int n = (NID_pkcs7_signed) <= 0;
  *o = (unsigned long long)((NID_pkcs7_signed) | 0);  /* check that NID_pkcs7_signed is an integer */
  return n;
}

static int _cffi_const_NID_subject_alt_name(unsigned long long *o)
{
  int n = (NID_subject_alt_name) <= 0;
  *o = (unsigned long long)((NID_subject_alt_name) | 0);  /* check that NID_subject_alt_name is an integer */
  return n;
}

static int _cffi_const_NID_undef(unsigned long long *o)
{
  int n = (NID_undef) <= 0;
  *o = (unsigned long long)((NID_undef) | 0);  /* check that NID_undef is an integer */
  return n;
}

static int _cffi_const_OPENSSL_BUILT_ON(unsigned long long *o)
{
  int n = (OPENSSL_BUILT_ON) <= 0;
  *o = (unsigned long long)((OPENSSL_BUILT_ON) | 0);  /* check that OPENSSL_BUILT_ON is an integer */
  return n;
}

static int _cffi_const_OPENSSL_CFLAGS(unsigned long long *o)
{
  int n = (OPENSSL_CFLAGS) <= 0;
  *o = (unsigned long long)((OPENSSL_CFLAGS) | 0);  /* check that OPENSSL_CFLAGS is an integer */
  return n;
}

static int _cffi_const_OPENSSL_DIR(unsigned long long *o)
{
  int n = (OPENSSL_DIR) <= 0;
  *o = (unsigned long long)((OPENSSL_DIR) | 0);  /* check that OPENSSL_DIR is an integer */
  return n;
}

static int _cffi_const_OPENSSL_PLATFORM(unsigned long long *o)
{
  int n = (OPENSSL_PLATFORM) <= 0;
  *o = (unsigned long long)((OPENSSL_PLATFORM) | 0);  /* check that OPENSSL_PLATFORM is an integer */
  return n;
}

static int _cffi_const_OPENSSL_VERSION(unsigned long long *o)
{
  int n = (OPENSSL_VERSION) <= 0;
  *o = (unsigned long long)((OPENSSL_VERSION) | 0);  /* check that OPENSSL_VERSION is an integer */
  return n;
}

static int _cffi_const_OPENSSL_VERSION_NUMBER(unsigned long long *o)
{
  int n = (OPENSSL_VERSION_NUMBER) <= 0;
  *o = (unsigned long long)((OPENSSL_VERSION_NUMBER) | 0);  /* check that OPENSSL_VERSION_NUMBER is an integer */
  return n;
}

static void _cffi_const_OPENSSL_VERSION_TEXT(char *o)
{
  *(char const * *)o = OPENSSL_VERSION_TEXT;
}

static int _cffi_const_PKCS12_R_PKCS12_CIPHERFINAL_ERROR(unsigned long long *o)
{
  int n = (PKCS12_R_PKCS12_CIPHERFINAL_ERROR) <= 0;
  *o = (unsigned long long)((PKCS12_R_PKCS12_CIPHERFINAL_ERROR) | 0);  /* check that PKCS12_R_PKCS12_CIPHERFINAL_ERROR is an integer */
  return n;
}

static int _cffi_const_PKCS7_TEXT(unsigned long long *o)
{
  int n = (PKCS7_TEXT) <= 0;
  *o = (unsigned long long)((PKCS7_TEXT) | 0);  /* check that PKCS7_TEXT is an integer */
  return n;
}

static int _cffi_const_PROV_R_BAD_DECRYPT(unsigned long long *o)
{
  int n = (PROV_R_BAD_DECRYPT) <= 0;
  *o = (unsigned long long)((PROV_R_BAD_DECRYPT) | 0);  /* check that PROV_R_BAD_DECRYPT is an integer */
  return n;
}

static int _cffi_const_PROV_R_WRONG_FINAL_BLOCK_LENGTH(unsigned long long *o)
{
  int n = (PROV_R_WRONG_FINAL_BLOCK_LENGTH) <= 0;
  *o = (unsigned long long)((PROV_R_WRONG_FINAL_BLOCK_LENGTH) | 0);  /* check that PROV_R_WRONG_FINAL_BLOCK_LENGTH is an integer */
  return n;
}

static int _cffi_const_PROV_R_XTS_DUPLICATED_KEYS(unsigned long long *o)
{
  int n = (PROV_R_XTS_DUPLICATED_KEYS) <= 0;
  *o = (unsigned long long)((PROV_R_XTS_DUPLICATED_KEYS) | 0);  /* check that PROV_R_XTS_DUPLICATED_KEYS is an integer */
  return n;
}

static int _cffi_const_RSA_F4(unsigned long long *o)
{
  int n = (RSA_F4) <= 0;
  *o = (unsigned long long)((RSA_F4) | 0);  /* check that RSA_F4 is an integer */
  return n;
}

static int _cffi_const_SSL3_VERSION(unsigned long long *o)
{
  int n = (SSL3_VERSION) <= 0;
  *o = (unsigned long long)((SSL3_VERSION) | 0);  /* check that SSL3_VERSION is an integer */
  return n;
}

static int _cffi_const_SSL_CB_ACCEPT_EXIT(unsigned long long *o)
{
  int n = (SSL_CB_ACCEPT_EXIT) <= 0;
  *o = (unsigned long long)((SSL_CB_ACCEPT_EXIT) | 0);  /* check that SSL_CB_ACCEPT_EXIT is an integer */
  return n;
}

static int _cffi_const_SSL_CB_ACCEPT_LOOP(unsigned long long *o)
{
  int n = (SSL_CB_ACCEPT_LOOP) <= 0;
  *o = (unsigned long long)((SSL_CB_ACCEPT_LOOP) | 0);  /* check that SSL_CB_ACCEPT_LOOP is an integer */
  return n;
}

static int _cffi_const_SSL_CB_ALERT(unsigned long long *o)
{
  int n = (SSL_CB_ALERT) <= 0;
  *o = (unsigned long long)((SSL_CB_ALERT) | 0);  /* check that SSL_CB_ALERT is an integer */
  return n;
}

static int _cffi_const_SSL_CB_CONNECT_EXIT(unsigned long long *o)
{
  int n = (SSL_CB_CONNECT_EXIT) <= 0;
  *o = (unsigned long long)((SSL_CB_CONNECT_EXIT) | 0);  /* check that SSL_CB_CONNECT_EXIT is an integer */
  return n;
}

static int _cffi_const_SSL_CB_CONNECT_LOOP(unsigned long long *o)
{
  int n = (SSL_CB_CONNECT_LOOP) <= 0;
  *o = (unsigned long long)((SSL_CB_CONNECT_LOOP) | 0);  /* check that SSL_CB_CONNECT_LOOP is an integer */
  return n;
}

static int _cffi_const_SSL_CB_EXIT(unsigned long long *o)
{
  int n = (SSL_CB_EXIT) <= 0;
  *o = (unsigned long long)((SSL_CB_EXIT) | 0);  /* check that SSL_CB_EXIT is an integer */
  return n;
}

static int _cffi_const_SSL_CB_HANDSHAKE_DONE(unsigned long long *o)
{
  int n = (SSL_CB_HANDSHAKE_DONE) <= 0;
  *o = (unsigned long long)((SSL_CB_HANDSHAKE_DONE) | 0);  /* check that SSL_CB_HANDSHAKE_DONE is an integer */
  return n;
}

static int _cffi_const_SSL_CB_HANDSHAKE_START(unsigned long long *o)
{
  int n = (SSL_CB_HANDSHAKE_START) <= 0;
  *o = (unsigned long long)((SSL_CB_HANDSHAKE_START) | 0);  /* check that SSL_CB_HANDSHAKE_START is an integer */
  return n;
}

static int _cffi_const_SSL_CB_LOOP(unsigned long long *o)
{
  int n = (SSL_CB_LOOP) <= 0;
  *o = (unsigned long long)((SSL_CB_LOOP) | 0);  /* check that SSL_CB_LOOP is an integer */
  return n;
}

static int _cffi_const_SSL_CB_READ(unsigned long long *o)
{
  int n = (SSL_CB_READ) <= 0;
  *o = (unsigned long long)((SSL_CB_READ) | 0);  /* check that SSL_CB_READ is an integer */
  return n;
}

static int _cffi_const_SSL_CB_READ_ALERT(unsigned long long *o)
{
  int n = (SSL_CB_READ_ALERT) <= 0;
  *o = (unsigned long long)((SSL_CB_READ_ALERT) | 0);  /* check that SSL_CB_READ_ALERT is an integer */
  return n;
}

static int _cffi_const_SSL_CB_WRITE(unsigned long long *o)
{
  int n = (SSL_CB_WRITE) <= 0;
  *o = (unsigned long long)((SSL_CB_WRITE) | 0);  /* check that SSL_CB_WRITE is an integer */
  return n;
}

static int _cffi_const_SSL_CB_WRITE_ALERT(unsigned long long *o)
{
  int n = (SSL_CB_WRITE_ALERT) <= 0;
  *o = (unsigned long long)((SSL_CB_WRITE_ALERT) | 0);  /* check that SSL_CB_WRITE_ALERT is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_NONE(unsigned long long *o)
{
  int n = (SSL_ERROR_NONE) <= 0;
  *o = (unsigned long long)((SSL_ERROR_NONE) | 0);  /* check that SSL_ERROR_NONE is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_SSL(unsigned long long *o)
{
  int n = (SSL_ERROR_SSL) <= 0;
  *o = (unsigned long long)((SSL_ERROR_SSL) | 0);  /* check that SSL_ERROR_SSL is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_SYSCALL(unsigned long long *o)
{
  int n = (SSL_ERROR_SYSCALL) <= 0;
  *o = (unsigned long long)((SSL_ERROR_SYSCALL) | 0);  /* check that SSL_ERROR_SYSCALL is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_WANT_READ(unsigned long long *o)
{
  int n = (SSL_ERROR_WANT_READ) <= 0;
  *o = (unsigned long long)((SSL_ERROR_WANT_READ) | 0);  /* check that SSL_ERROR_WANT_READ is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_WANT_WRITE(unsigned long long *o)
{
  int n = (SSL_ERROR_WANT_WRITE) <= 0;
  *o = (unsigned long long)((SSL_ERROR_WANT_WRITE) | 0);  /* check that SSL_ERROR_WANT_WRITE is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_WANT_X509_LOOKUP(unsigned long long *o)
{
  int n = (SSL_ERROR_WANT_X509_LOOKUP) <= 0;
  *o = (unsigned long long)((SSL_ERROR_WANT_X509_LOOKUP) | 0);  /* check that SSL_ERROR_WANT_X509_LOOKUP is an integer */
  return n;
}

static int _cffi_const_SSL_ERROR_ZERO_RETURN(unsigned long long *o)
{
  int n = (SSL_ERROR_ZERO_RETURN) <= 0;
  *o = (unsigned long long)((SSL_ERROR_ZERO_RETURN) | 0);  /* check that SSL_ERROR_ZERO_RETURN is an integer */
  return n;
}

static int _cffi_const_SSL_FILETYPE_ASN1(unsigned long long *o)
{
  int n = (SSL_FILETYPE_ASN1) <= 0;
  *o = (unsigned long long)((SSL_FILETYPE_ASN1) | 0);  /* check that SSL_FILETYPE_ASN1 is an integer */
  return n;
}

static int _cffi_const_SSL_FILETYPE_PEM(unsigned long long *o)
{
  int n = (SSL_FILETYPE_PEM) <= 0;
  *o = (unsigned long long)((SSL_FILETYPE_PEM) | 0);  /* check that SSL_FILETYPE_PEM is an integer */
  return n;
}

static int _cffi_const_SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER(unsigned long long *o)
{
  int n = (SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER) <= 0;
  *o = (unsigned long long)((SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER) | 0);  /* check that SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER is an integer */
  return n;
}

static int _cffi_const_SSL_MODE_AUTO_RETRY(unsigned long long *o)
{
  int n = (SSL_MODE_AUTO_RETRY) <= 0;
  *o = (unsigned long long)((SSL_MODE_AUTO_RETRY) | 0);  /* check that SSL_MODE_AUTO_RETRY is an integer */
  return n;
}

static int _cffi_const_SSL_MODE_ENABLE_PARTIAL_WRITE(unsigned long long *o)
{
  int n = (SSL_MODE_ENABLE_PARTIAL_WRITE) <= 0;
  *o = (unsigned long long)((SSL_MODE_ENABLE_PARTIAL_WRITE) | 0);  /* check that SSL_MODE_ENABLE_PARTIAL_WRITE is an integer */
  return n;
}

static int _cffi_const_SSL_MODE_RELEASE_BUFFERS(unsigned long long *o)
{
  int n = (SSL_MODE_RELEASE_BUFFERS) <= 0;
  *o = (unsigned long long)((SSL_MODE_RELEASE_BUFFERS) | 0);  /* check that SSL_MODE_RELEASE_BUFFERS is an integer */
  return n;
}

static int _cffi_const_SSL_OP_ALL(unsigned long long *o)
{
  int n = (SSL_OP_ALL) <= 0;
  *o = (unsigned long long)((SSL_OP_ALL) | 0);  /* check that SSL_OP_ALL is an integer */
  return n;
}

static int _cffi_const_SSL_OP_CIPHER_SERVER_PREFERENCE(unsigned long long *o)
{
  int n = (SSL_OP_CIPHER_SERVER_PREFERENCE) <= 0;
  *o = (unsigned long long)((SSL_OP_CIPHER_SERVER_PREFERENCE) | 0);  /* check that SSL_OP_CIPHER_SERVER_PREFERENCE is an integer */
  return n;
}

static int _cffi_const_SSL_OP_COOKIE_EXCHANGE(unsigned long long *o)
{
  int n = (SSL_OP_COOKIE_EXCHANGE) <= 0;
  *o = (unsigned long long)((SSL_OP_COOKIE_EXCHANGE) | 0);  /* check that SSL_OP_COOKIE_EXCHANGE is an integer */
  return n;
}

static int _cffi_const_SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS(unsigned long long *o)
{
  int n = (SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS) <= 0;
  *o = (unsigned long long)((SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS) | 0);  /* check that SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS is an integer */
  return n;
}

static int _cffi_const_SSL_OP_EPHEMERAL_RSA(unsigned long long *o)
{
  int n = (SSL_OP_EPHEMERAL_RSA) <= 0;
  *o = (unsigned long long)((SSL_OP_EPHEMERAL_RSA) | 0);  /* check that SSL_OP_EPHEMERAL_RSA is an integer */
  return n;
}

static int _cffi_const_SSL_OP_IGNORE_UNEXPECTED_EOF(unsigned long long *o)
{
  int n = (SSL_OP_IGNORE_UNEXPECTED_EOF) <= 0;
  *o = (unsigned long long)((SSL_OP_IGNORE_UNEXPECTED_EOF) | 0);  /* check that SSL_OP_IGNORE_UNEXPECTED_EOF is an integer */
  return n;
}

static int _cffi_const_SSL_OP_LEGACY_SERVER_CONNECT(unsigned long long *o)
{
  int n = (SSL_OP_LEGACY_SERVER_CONNECT) <= 0;
  *o = (unsigned long long)((SSL_OP_LEGACY_SERVER_CONNECT) | 0);  /* check that SSL_OP_LEGACY_SERVER_CONNECT is an integer */
  return n;
}

static int _cffi_const_SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER(unsigned long long *o)
{
  int n = (SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER) <= 0;
  *o = (unsigned long long)((SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER) | 0);  /* check that SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER is an integer */
  return n;
}

static int _cffi_const_SSL_OP_MICROSOFT_SESS_ID_BUG(unsigned long long *o)
{
  int n = (SSL_OP_MICROSOFT_SESS_ID_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_MICROSOFT_SESS_ID_BUG) | 0);  /* check that SSL_OP_MICROSOFT_SESS_ID_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_MSIE_SSLV2_RSA_PADDING(unsigned long long *o)
{
  int n = (SSL_OP_MSIE_SSLV2_RSA_PADDING) <= 0;
  *o = (unsigned long long)((SSL_OP_MSIE_SSLV2_RSA_PADDING) | 0);  /* check that SSL_OP_MSIE_SSLV2_RSA_PADDING is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NETSCAPE_CA_DN_BUG(unsigned long long *o)
{
  int n = (SSL_OP_NETSCAPE_CA_DN_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_NETSCAPE_CA_DN_BUG) | 0);  /* check that SSL_OP_NETSCAPE_CA_DN_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NETSCAPE_CHALLENGE_BUG(unsigned long long *o)
{
  int n = (SSL_OP_NETSCAPE_CHALLENGE_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_NETSCAPE_CHALLENGE_BUG) | 0);  /* check that SSL_OP_NETSCAPE_CHALLENGE_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG(unsigned long long *o)
{
  int n = (SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG) | 0);  /* check that SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG(unsigned long long *o)
{
  int n = (SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG) | 0);  /* check that SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_COMPRESSION(unsigned long long *o)
{
  int n = (SSL_OP_NO_COMPRESSION) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_COMPRESSION) | 0);  /* check that SSL_OP_NO_COMPRESSION is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_QUERY_MTU(unsigned long long *o)
{
  int n = (SSL_OP_NO_QUERY_MTU) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_QUERY_MTU) | 0);  /* check that SSL_OP_NO_QUERY_MTU is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_RENEGOTIATION(unsigned long long *o)
{
  int n = (SSL_OP_NO_RENEGOTIATION) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_RENEGOTIATION) | 0);  /* check that SSL_OP_NO_RENEGOTIATION is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_SSLv2(unsigned long long *o)
{
  int n = (SSL_OP_NO_SSLv2) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_SSLv2) | 0);  /* check that SSL_OP_NO_SSLv2 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_SSLv3(unsigned long long *o)
{
  int n = (SSL_OP_NO_SSLv3) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_SSLv3) | 0);  /* check that SSL_OP_NO_SSLv3 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_TICKET(unsigned long long *o)
{
  int n = (SSL_OP_NO_TICKET) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_TICKET) | 0);  /* check that SSL_OP_NO_TICKET is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_TLSv1(unsigned long long *o)
{
  int n = (SSL_OP_NO_TLSv1) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_TLSv1) | 0);  /* check that SSL_OP_NO_TLSv1 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_TLSv1_1(unsigned long long *o)
{
  int n = (SSL_OP_NO_TLSv1_1) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_TLSv1_1) | 0);  /* check that SSL_OP_NO_TLSv1_1 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_TLSv1_2(unsigned long long *o)
{
  int n = (SSL_OP_NO_TLSv1_2) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_TLSv1_2) | 0);  /* check that SSL_OP_NO_TLSv1_2 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_NO_TLSv1_3(unsigned long long *o)
{
  int n = (SSL_OP_NO_TLSv1_3) <= 0;
  *o = (unsigned long long)((SSL_OP_NO_TLSv1_3) | 0);  /* check that SSL_OP_NO_TLSv1_3 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_PKCS1_CHECK_1(unsigned long long *o)
{
  int n = (SSL_OP_PKCS1_CHECK_1) <= 0;
  *o = (unsigned long long)((SSL_OP_PKCS1_CHECK_1) | 0);  /* check that SSL_OP_PKCS1_CHECK_1 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_PKCS1_CHECK_2(unsigned long long *o)
{
  int n = (SSL_OP_PKCS1_CHECK_2) <= 0;
  *o = (unsigned long long)((SSL_OP_PKCS1_CHECK_2) | 0);  /* check that SSL_OP_PKCS1_CHECK_2 is an integer */
  return n;
}

static int _cffi_const_SSL_OP_SINGLE_DH_USE(unsigned long long *o)
{
  int n = (SSL_OP_SINGLE_DH_USE) <= 0;
  *o = (unsigned long long)((SSL_OP_SINGLE_DH_USE) | 0);  /* check that SSL_OP_SINGLE_DH_USE is an integer */
  return n;
}

static int _cffi_const_SSL_OP_SINGLE_ECDH_USE(unsigned long long *o)
{
  int n = (SSL_OP_SINGLE_ECDH_USE) <= 0;
  *o = (unsigned long long)((SSL_OP_SINGLE_ECDH_USE) | 0);  /* check that SSL_OP_SINGLE_ECDH_USE is an integer */
  return n;
}

static int _cffi_const_SSL_OP_SSLEAY_080_CLIENT_DH_BUG(unsigned long long *o)
{
  int n = (SSL_OP_SSLEAY_080_CLIENT_DH_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_SSLEAY_080_CLIENT_DH_BUG) | 0);  /* check that SSL_OP_SSLEAY_080_CLIENT_DH_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG(unsigned long long *o)
{
  int n = (SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG) | 0);  /* check that SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_TLS_BLOCK_PADDING_BUG(unsigned long long *o)
{
  int n = (SSL_OP_TLS_BLOCK_PADDING_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_TLS_BLOCK_PADDING_BUG) | 0);  /* check that SSL_OP_TLS_BLOCK_PADDING_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_TLS_D5_BUG(unsigned long long *o)
{
  int n = (SSL_OP_TLS_D5_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_TLS_D5_BUG) | 0);  /* check that SSL_OP_TLS_D5_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_OP_TLS_ROLLBACK_BUG(unsigned long long *o)
{
  int n = (SSL_OP_TLS_ROLLBACK_BUG) <= 0;
  *o = (unsigned long long)((SSL_OP_TLS_ROLLBACK_BUG) | 0);  /* check that SSL_OP_TLS_ROLLBACK_BUG is an integer */
  return n;
}

static int _cffi_const_SSL_RECEIVED_SHUTDOWN(unsigned long long *o)
{
  int n = (SSL_RECEIVED_SHUTDOWN) <= 0;
  *o = (unsigned long long)((SSL_RECEIVED_SHUTDOWN) | 0);  /* check that SSL_RECEIVED_SHUTDOWN is an integer */
  return n;
}

static int _cffi_const_SSL_R_UNEXPECTED_EOF_WHILE_READING(unsigned long long *o)
{
  int n = (SSL_R_UNEXPECTED_EOF_WHILE_READING) <= 0;
  *o = (unsigned long long)((SSL_R_UNEXPECTED_EOF_WHILE_READING) | 0);  /* check that SSL_R_UNEXPECTED_EOF_WHILE_READING is an integer */
  return n;
}

static int _cffi_const_SSL_SENT_SHUTDOWN(unsigned long long *o)
{
  int n = (SSL_SENT_SHUTDOWN) <= 0;
  *o = (unsigned long long)((SSL_SENT_SHUTDOWN) | 0);  /* check that SSL_SENT_SHUTDOWN is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_BOTH(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_BOTH) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_BOTH) | 0);  /* check that SSL_SESS_CACHE_BOTH is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_CLIENT(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_CLIENT) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_CLIENT) | 0);  /* check that SSL_SESS_CACHE_CLIENT is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_NO_AUTO_CLEAR(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_NO_AUTO_CLEAR) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_NO_AUTO_CLEAR) | 0);  /* check that SSL_SESS_CACHE_NO_AUTO_CLEAR is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_NO_INTERNAL) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_NO_INTERNAL) | 0);  /* check that SSL_SESS_CACHE_NO_INTERNAL is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_LOOKUP(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_NO_INTERNAL_LOOKUP) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_NO_INTERNAL_LOOKUP) | 0);  /* check that SSL_SESS_CACHE_NO_INTERNAL_LOOKUP is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_NO_INTERNAL_STORE(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_NO_INTERNAL_STORE) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_NO_INTERNAL_STORE) | 0);  /* check that SSL_SESS_CACHE_NO_INTERNAL_STORE is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_OFF(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_OFF) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_OFF) | 0);  /* check that SSL_SESS_CACHE_OFF is an integer */
  return n;
}

static int _cffi_const_SSL_SESS_CACHE_SERVER(unsigned long long *o)
{
  int n = (SSL_SESS_CACHE_SERVER) <= 0;
  *o = (unsigned long long)((SSL_SESS_CACHE_SERVER) | 0);  /* check that SSL_SESS_CACHE_SERVER is an integer */
  return n;
}

static int _cffi_const_SSL_ST_ACCEPT(unsigned long long *o)
{
  int n = (SSL_ST_ACCEPT) <= 0;
  *o = (unsigned long long)((SSL_ST_ACCEPT) | 0);  /* check that SSL_ST_ACCEPT is an integer */
  return n;
}

static int _cffi_const_SSL_ST_BEFORE(unsigned long long *o)
{
  int n = (SSL_ST_BEFORE) <= 0;
  *o = (unsigned long long)((SSL_ST_BEFORE) | 0);  /* check that SSL_ST_BEFORE is an integer */
  return n;
}

static int _cffi_const_SSL_ST_CONNECT(unsigned long long *o)
{
  int n = (SSL_ST_CONNECT) <= 0;
  *o = (unsigned long long)((SSL_ST_CONNECT) | 0);  /* check that SSL_ST_CONNECT is an integer */
  return n;
}

static int _cffi_const_SSL_ST_INIT(unsigned long long *o)
{
  int n = (SSL_ST_INIT) <= 0;
  *o = (unsigned long long)((SSL_ST_INIT) | 0);  /* check that SSL_ST_INIT is an integer */
  return n;
}

static int _cffi_const_SSL_ST_MASK(unsigned long long *o)
{
  int n = (SSL_ST_MASK) <= 0;
  *o = (unsigned long long)((SSL_ST_MASK) | 0);  /* check that SSL_ST_MASK is an integer */
  return n;
}

static int _cffi_const_SSL_ST_OK(unsigned long long *o)
{
  int n = (SSL_ST_OK) <= 0;
  *o = (unsigned long long)((SSL_ST_OK) | 0);  /* check that SSL_ST_OK is an integer */
  return n;
}

static int _cffi_const_SSL_ST_RENEGOTIATE(unsigned long long *o)
{
  int n = (SSL_ST_RENEGOTIATE) <= 0;
  *o = (unsigned long long)((SSL_ST_RENEGOTIATE) | 0);  /* check that SSL_ST_RENEGOTIATE is an integer */
  return n;
}

static int _cffi_const_SSL_TLSEXT_ERR_ALERT_FATAL(unsigned long long *o)
{
  int n = (SSL_TLSEXT_ERR_ALERT_FATAL) <= 0;
  *o = (unsigned long long)((SSL_TLSEXT_ERR_ALERT_FATAL) | 0);  /* check that SSL_TLSEXT_ERR_ALERT_FATAL is an integer */
  return n;
}

static int _cffi_const_SSL_TLSEXT_ERR_NOACK(unsigned long long *o)
{
  int n = (SSL_TLSEXT_ERR_NOACK) <= 0;
  *o = (unsigned long long)((SSL_TLSEXT_ERR_NOACK) | 0);  /* check that SSL_TLSEXT_ERR_NOACK is an integer */
  return n;
}

static int _cffi_const_SSL_TLSEXT_ERR_OK(unsigned long long *o)
{
  int n = (SSL_TLSEXT_ERR_OK) <= 0;
  *o = (unsigned long long)((SSL_TLSEXT_ERR_OK) | 0);  /* check that SSL_TLSEXT_ERR_OK is an integer */
  return n;
}

static int _cffi_const_SSL_VERIFY_CLIENT_ONCE(unsigned long long *o)
{
  int n = (SSL_VERIFY_CLIENT_ONCE) <= 0;
  *o = (unsigned long long)((SSL_VERIFY_CLIENT_ONCE) | 0);  /* check that SSL_VERIFY_CLIENT_ONCE is an integer */
  return n;
}

static int _cffi_const_SSL_VERIFY_FAIL_IF_NO_PEER_CERT(unsigned long long *o)
{
  int n = (SSL_VERIFY_FAIL_IF_NO_PEER_CERT) <= 0;
  *o = (unsigned long long)((SSL_VERIFY_FAIL_IF_NO_PEER_CERT) | 0);  /* check that SSL_VERIFY_FAIL_IF_NO_PEER_CERT is an integer */
  return n;
}

static int _cffi_const_SSL_VERIFY_NONE(unsigned long long *o)
{
  int n = (SSL_VERIFY_NONE) <= 0;
  *o = (unsigned long long)((SSL_VERIFY_NONE) | 0);  /* check that SSL_VERIFY_NONE is an integer */
  return n;
}

static int _cffi_const_SSL_VERIFY_PEER(unsigned long long *o)
{
  int n = (SSL_VERIFY_PEER) <= 0;
  *o = (unsigned long long)((SSL_VERIFY_PEER) | 0);  /* check that SSL_VERIFY_PEER is an integer */
  return n;
}

static int _cffi_const_SSL_VERIFY_POST_HANDSHAKE(unsigned long long *o)
{
  int n = (SSL_VERIFY_POST_HANDSHAKE) <= 0;
  *o = (unsigned long long)((SSL_VERIFY_POST_HANDSHAKE) | 0);  /* check that SSL_VERIFY_POST_HANDSHAKE is an integer */
  return n;
}

static int _cffi_const_TLS1_1_VERSION(unsigned long long *o)
{
  int n = (TLS1_1_VERSION) <= 0;
  *o = (unsigned long long)((TLS1_1_VERSION) | 0);  /* check that TLS1_1_VERSION is an integer */
  return n;
}

static int _cffi_const_TLS1_2_VERSION(unsigned long long *o)
{
  int n = (TLS1_2_VERSION) <= 0;
  *o = (unsigned long long)((TLS1_2_VERSION) | 0);  /* check that TLS1_2_VERSION is an integer */
  return n;
}

static int _cffi_const_TLS1_3_VERSION(unsigned long long *o)
{
  int n = (TLS1_3_VERSION) <= 0;
  *o = (unsigned long long)((TLS1_3_VERSION) | 0);  /* check that TLS1_3_VERSION is an integer */
  return n;
}

static int _cffi_const_TLS1_VERSION(unsigned long long *o)
{
  int n = (TLS1_VERSION) <= 0;
  *o = (unsigned long long)((TLS1_VERSION) | 0);  /* check that TLS1_VERSION is an integer */
  return n;
}

static int _cffi_const_TLSEXT_NAMETYPE_host_name(unsigned long long *o)
{
  int n = (TLSEXT_NAMETYPE_host_name) <= 0;
  *o = (unsigned long long)((TLSEXT_NAMETYPE_host_name) | 0);  /* check that TLSEXT_NAMETYPE_host_name is an integer */
  return n;
}

static int _cffi_const_TLSEXT_STATUSTYPE_ocsp(unsigned long long *o)
{
  int n = (TLSEXT_STATUSTYPE_ocsp) <= 0;
  *o = (unsigned long long)((TLSEXT_STATUSTYPE_ocsp) | 0);  /* check that TLSEXT_STATUSTYPE_ocsp is an integer */
  return n;
}

static int _cffi_const_TLS_ST_BEFORE(unsigned long long *o)
{
  int n = (TLS_ST_BEFORE) <= 0;
  *o = (unsigned long long)((TLS_ST_BEFORE) | 0);  /* check that TLS_ST_BEFORE is an integer */
  return n;
}

static int _cffi_const_TLS_ST_OK(unsigned long long *o)
{
  int n = (TLS_ST_OK) <= 0;
  *o = (unsigned long long)((TLS_ST_OK) | 0);  /* check that TLS_ST_OK is an integer */
  return n;
}

static int _cffi_const_V_ASN1_GENERALIZEDTIME(unsigned long long *o)
{
  int n = (V_ASN1_GENERALIZEDTIME) <= 0;
  *o = (unsigned long long)((V_ASN1_GENERALIZEDTIME) | 0);  /* check that V_ASN1_GENERALIZEDTIME is an integer */
  return n;
}

static int _cffi_const_X509V3_EXT_ERROR_UNKNOWN(unsigned long long *o)
{
  int n = (X509V3_EXT_ERROR_UNKNOWN) <= 0;
  *o = (unsigned long long)((X509V3_EXT_ERROR_UNKNOWN) | 0);  /* check that X509V3_EXT_ERROR_UNKNOWN is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT) | 0);  /* check that X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS) | 0);  /* check that X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_NEVER_CHECK_SUBJECT(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_NEVER_CHECK_SUBJECT) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_NEVER_CHECK_SUBJECT) | 0);  /* check that X509_CHECK_FLAG_NEVER_CHECK_SUBJECT is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS) | 0);  /* check that X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_NO_WILDCARDS(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_NO_WILDCARDS) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_NO_WILDCARDS) | 0);  /* check that X509_CHECK_FLAG_NO_WILDCARDS is an integer */
  return n;
}

static int _cffi_const_X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS(unsigned long long *o)
{
  int n = (X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS) <= 0;
  *o = (unsigned long long)((X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS) | 0);  /* check that X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_ANY(unsigned long long *o)
{
  int n = (X509_PURPOSE_ANY) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_ANY) | 0);  /* check that X509_PURPOSE_ANY is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_CRL_SIGN(unsigned long long *o)
{
  int n = (X509_PURPOSE_CRL_SIGN) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_CRL_SIGN) | 0);  /* check that X509_PURPOSE_CRL_SIGN is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_NS_SSL_SERVER(unsigned long long *o)
{
  int n = (X509_PURPOSE_NS_SSL_SERVER) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_NS_SSL_SERVER) | 0);  /* check that X509_PURPOSE_NS_SSL_SERVER is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_OCSP_HELPER(unsigned long long *o)
{
  int n = (X509_PURPOSE_OCSP_HELPER) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_OCSP_HELPER) | 0);  /* check that X509_PURPOSE_OCSP_HELPER is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_SMIME_ENCRYPT(unsigned long long *o)
{
  int n = (X509_PURPOSE_SMIME_ENCRYPT) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_SMIME_ENCRYPT) | 0);  /* check that X509_PURPOSE_SMIME_ENCRYPT is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_SMIME_SIGN(unsigned long long *o)
{
  int n = (X509_PURPOSE_SMIME_SIGN) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_SMIME_SIGN) | 0);  /* check that X509_PURPOSE_SMIME_SIGN is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_SSL_CLIENT(unsigned long long *o)
{
  int n = (X509_PURPOSE_SSL_CLIENT) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_SSL_CLIENT) | 0);  /* check that X509_PURPOSE_SSL_CLIENT is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_SSL_SERVER(unsigned long long *o)
{
  int n = (X509_PURPOSE_SSL_SERVER) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_SSL_SERVER) | 0);  /* check that X509_PURPOSE_SSL_SERVER is an integer */
  return n;
}

static int _cffi_const_X509_PURPOSE_TIMESTAMP_SIGN(unsigned long long *o)
{
  int n = (X509_PURPOSE_TIMESTAMP_SIGN) <= 0;
  *o = (unsigned long long)((X509_PURPOSE_TIMESTAMP_SIGN) | 0);  /* check that X509_PURPOSE_TIMESTAMP_SIGN is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH) | 0);  /* check that X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_AKID_SKID_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_AKID_SKID_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_AKID_SKID_MISMATCH) | 0);  /* check that X509_V_ERR_AKID_SKID_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_APPLICATION_VERIFICATION(unsigned long long *o)
{
  int n = (X509_V_ERR_APPLICATION_VERIFICATION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_APPLICATION_VERIFICATION) | 0);  /* check that X509_V_ERR_APPLICATION_VERIFICATION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_CHAIN_TOO_LONG(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_CHAIN_TOO_LONG) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_CHAIN_TOO_LONG) | 0);  /* check that X509_V_ERR_CERT_CHAIN_TOO_LONG is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_HAS_EXPIRED(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_HAS_EXPIRED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_HAS_EXPIRED) | 0);  /* check that X509_V_ERR_CERT_HAS_EXPIRED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_NOT_YET_VALID(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_NOT_YET_VALID) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_NOT_YET_VALID) | 0);  /* check that X509_V_ERR_CERT_NOT_YET_VALID is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_REJECTED(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_REJECTED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_REJECTED) | 0);  /* check that X509_V_ERR_CERT_REJECTED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_REVOKED(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_REVOKED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_REVOKED) | 0);  /* check that X509_V_ERR_CERT_REVOKED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_SIGNATURE_FAILURE(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_SIGNATURE_FAILURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_SIGNATURE_FAILURE) | 0);  /* check that X509_V_ERR_CERT_SIGNATURE_FAILURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CERT_UNTRUSTED(unsigned long long *o)
{
  int n = (X509_V_ERR_CERT_UNTRUSTED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CERT_UNTRUSTED) | 0);  /* check that X509_V_ERR_CERT_UNTRUSTED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CRL_HAS_EXPIRED(unsigned long long *o)
{
  int n = (X509_V_ERR_CRL_HAS_EXPIRED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CRL_HAS_EXPIRED) | 0);  /* check that X509_V_ERR_CRL_HAS_EXPIRED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CRL_NOT_YET_VALID(unsigned long long *o)
{
  int n = (X509_V_ERR_CRL_NOT_YET_VALID) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CRL_NOT_YET_VALID) | 0);  /* check that X509_V_ERR_CRL_NOT_YET_VALID is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CRL_PATH_VALIDATION_ERROR(unsigned long long *o)
{
  int n = (X509_V_ERR_CRL_PATH_VALIDATION_ERROR) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CRL_PATH_VALIDATION_ERROR) | 0);  /* check that X509_V_ERR_CRL_PATH_VALIDATION_ERROR is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_CRL_SIGNATURE_FAILURE(unsigned long long *o)
{
  int n = (X509_V_ERR_CRL_SIGNATURE_FAILURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_CRL_SIGNATURE_FAILURE) | 0);  /* check that X509_V_ERR_CRL_SIGNATURE_FAILURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT(unsigned long long *o)
{
  int n = (X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT) <= 0;
  *o = (unsigned long long)((X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT) | 0);  /* check that X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_DIFFERENT_CRL_SCOPE(unsigned long long *o)
{
  int n = (X509_V_ERR_DIFFERENT_CRL_SCOPE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_DIFFERENT_CRL_SCOPE) | 0);  /* check that X509_V_ERR_DIFFERENT_CRL_SCOPE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_EMAIL_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_EMAIL_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_EMAIL_MISMATCH) | 0);  /* check that X509_V_ERR_EMAIL_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD(unsigned long long *o)
{
  int n = (X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD) <= 0;
  *o = (unsigned long long)((X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD) | 0);  /* check that X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD(unsigned long long *o)
{
  int n = (X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD) <= 0;
  *o = (unsigned long long)((X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD) | 0);  /* check that X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD(unsigned long long *o)
{
  int n = (X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD) <= 0;
  *o = (unsigned long long)((X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD) | 0);  /* check that X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD(unsigned long long *o)
{
  int n = (X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD) <= 0;
  *o = (unsigned long long)((X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD) | 0);  /* check that X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_EXCLUDED_VIOLATION(unsigned long long *o)
{
  int n = (X509_V_ERR_EXCLUDED_VIOLATION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_EXCLUDED_VIOLATION) | 0);  /* check that X509_V_ERR_EXCLUDED_VIOLATION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_HOSTNAME_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_HOSTNAME_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_HOSTNAME_MISMATCH) | 0);  /* check that X509_V_ERR_HOSTNAME_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_INVALID_CA(unsigned long long *o)
{
  int n = (X509_V_ERR_INVALID_CA) <= 0;
  *o = (unsigned long long)((X509_V_ERR_INVALID_CA) | 0);  /* check that X509_V_ERR_INVALID_CA is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_INVALID_EXTENSION(unsigned long long *o)
{
  int n = (X509_V_ERR_INVALID_EXTENSION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_INVALID_EXTENSION) | 0);  /* check that X509_V_ERR_INVALID_EXTENSION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_INVALID_NON_CA(unsigned long long *o)
{
  int n = (X509_V_ERR_INVALID_NON_CA) <= 0;
  *o = (unsigned long long)((X509_V_ERR_INVALID_NON_CA) | 0);  /* check that X509_V_ERR_INVALID_NON_CA is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_INVALID_POLICY_EXTENSION(unsigned long long *o)
{
  int n = (X509_V_ERR_INVALID_POLICY_EXTENSION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_INVALID_POLICY_EXTENSION) | 0);  /* check that X509_V_ERR_INVALID_POLICY_EXTENSION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_INVALID_PURPOSE(unsigned long long *o)
{
  int n = (X509_V_ERR_INVALID_PURPOSE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_INVALID_PURPOSE) | 0);  /* check that X509_V_ERR_INVALID_PURPOSE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_IP_ADDRESS_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_IP_ADDRESS_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_IP_ADDRESS_MISMATCH) | 0);  /* check that X509_V_ERR_IP_ADDRESS_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_CERTSIGN(unsigned long long *o)
{
  int n = (X509_V_ERR_KEYUSAGE_NO_CERTSIGN) <= 0;
  *o = (unsigned long long)((X509_V_ERR_KEYUSAGE_NO_CERTSIGN) | 0);  /* check that X509_V_ERR_KEYUSAGE_NO_CERTSIGN is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_CRL_SIGN(unsigned long long *o)
{
  int n = (X509_V_ERR_KEYUSAGE_NO_CRL_SIGN) <= 0;
  *o = (unsigned long long)((X509_V_ERR_KEYUSAGE_NO_CRL_SIGN) | 0);  /* check that X509_V_ERR_KEYUSAGE_NO_CRL_SIGN is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE(unsigned long long *o)
{
  int n = (X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE) | 0);  /* check that X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_NO_EXPLICIT_POLICY(unsigned long long *o)
{
  int n = (X509_V_ERR_NO_EXPLICIT_POLICY) <= 0;
  *o = (unsigned long long)((X509_V_ERR_NO_EXPLICIT_POLICY) | 0);  /* check that X509_V_ERR_NO_EXPLICIT_POLICY is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_OUT_OF_MEM(unsigned long long *o)
{
  int n = (X509_V_ERR_OUT_OF_MEM) <= 0;
  *o = (unsigned long long)((X509_V_ERR_OUT_OF_MEM) | 0);  /* check that X509_V_ERR_OUT_OF_MEM is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_PATH_LENGTH_EXCEEDED(unsigned long long *o)
{
  int n = (X509_V_ERR_PATH_LENGTH_EXCEEDED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_PATH_LENGTH_EXCEEDED) | 0);  /* check that X509_V_ERR_PATH_LENGTH_EXCEEDED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_PERMITTED_VIOLATION(unsigned long long *o)
{
  int n = (X509_V_ERR_PERMITTED_VIOLATION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_PERMITTED_VIOLATION) | 0);  /* check that X509_V_ERR_PERMITTED_VIOLATION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED(unsigned long long *o)
{
  int n = (X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED) | 0);  /* check that X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED(unsigned long long *o)
{
  int n = (X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED) <= 0;
  *o = (unsigned long long)((X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED) | 0);  /* check that X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN(unsigned long long *o)
{
  int n = (X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN) <= 0;
  *o = (unsigned long long)((X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN) | 0);  /* check that X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_SUBJECT_ISSUER_MISMATCH(unsigned long long *o)
{
  int n = (X509_V_ERR_SUBJECT_ISSUER_MISMATCH) <= 0;
  *o = (unsigned long long)((X509_V_ERR_SUBJECT_ISSUER_MISMATCH) | 0);  /* check that X509_V_ERR_SUBJECT_ISSUER_MISMATCH is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_SUBTREE_MINMAX(unsigned long long *o)
{
  int n = (X509_V_ERR_SUBTREE_MINMAX) <= 0;
  *o = (unsigned long long)((X509_V_ERR_SUBTREE_MINMAX) | 0);  /* check that X509_V_ERR_SUBTREE_MINMAX is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY) | 0);  /* check that X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE) | 0);  /* check that X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE) | 0);  /* check that X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_GET_CRL) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_GET_CRL) | 0);  /* check that X509_V_ERR_UNABLE_TO_GET_CRL is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER) | 0);  /* check that X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT) | 0);  /* check that X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY) | 0);  /* check that X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE) | 0);  /* check that X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION(unsigned long long *o)
{
  int n = (X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION) | 0);  /* check that X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION(unsigned long long *o)
{
  int n = (X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION) | 0);  /* check that X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNNESTED_RESOURCE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNNESTED_RESOURCE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNNESTED_RESOURCE) | 0);  /* check that X509_V_ERR_UNNESTED_RESOURCE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX(unsigned long long *o)
{
  int n = (X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX) | 0);  /* check that X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE) | 0);  /* check that X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE(unsigned long long *o)
{
  int n = (X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE) | 0);  /* check that X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_ERR_UNSUPPORTED_NAME_SYNTAX(unsigned long long *o)
{
  int n = (X509_V_ERR_UNSUPPORTED_NAME_SYNTAX) <= 0;
  *o = (unsigned long long)((X509_V_ERR_UNSUPPORTED_NAME_SYNTAX) | 0);  /* check that X509_V_ERR_UNSUPPORTED_NAME_SYNTAX is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_ALLOW_PROXY_CERTS(unsigned long long *o)
{
  int n = (X509_V_FLAG_ALLOW_PROXY_CERTS) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_ALLOW_PROXY_CERTS) | 0);  /* check that X509_V_FLAG_ALLOW_PROXY_CERTS is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_CHECK_SS_SIGNATURE(unsigned long long *o)
{
  int n = (X509_V_FLAG_CHECK_SS_SIGNATURE) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_CHECK_SS_SIGNATURE) | 0);  /* check that X509_V_FLAG_CHECK_SS_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_CRL_CHECK(unsigned long long *o)
{
  int n = (X509_V_FLAG_CRL_CHECK) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_CRL_CHECK) | 0);  /* check that X509_V_FLAG_CRL_CHECK is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_CRL_CHECK_ALL(unsigned long long *o)
{
  int n = (X509_V_FLAG_CRL_CHECK_ALL) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_CRL_CHECK_ALL) | 0);  /* check that X509_V_FLAG_CRL_CHECK_ALL is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_EXPLICIT_POLICY(unsigned long long *o)
{
  int n = (X509_V_FLAG_EXPLICIT_POLICY) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_EXPLICIT_POLICY) | 0);  /* check that X509_V_FLAG_EXPLICIT_POLICY is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_IGNORE_CRITICAL(unsigned long long *o)
{
  int n = (X509_V_FLAG_IGNORE_CRITICAL) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_IGNORE_CRITICAL) | 0);  /* check that X509_V_FLAG_IGNORE_CRITICAL is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_INHIBIT_MAP(unsigned long long *o)
{
  int n = (X509_V_FLAG_INHIBIT_MAP) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_INHIBIT_MAP) | 0);  /* check that X509_V_FLAG_INHIBIT_MAP is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_PARTIAL_CHAIN(unsigned long long *o)
{
  int n = (X509_V_FLAG_PARTIAL_CHAIN) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_PARTIAL_CHAIN) | 0);  /* check that X509_V_FLAG_PARTIAL_CHAIN is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_POLICY_CHECK(unsigned long long *o)
{
  int n = (X509_V_FLAG_POLICY_CHECK) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_POLICY_CHECK) | 0);  /* check that X509_V_FLAG_POLICY_CHECK is an integer */
  return n;
}

static int _cffi_const_X509_V_FLAG_X509_STRICT(unsigned long long *o)
{
  int n = (X509_V_FLAG_X509_STRICT) <= 0;
  *o = (unsigned long long)((X509_V_FLAG_X509_STRICT) | 0);  /* check that X509_V_FLAG_X509_STRICT is an integer */
  return n;
}

static int _cffi_const_X509_V_OK(unsigned long long *o)
{
  int n = (X509_V_OK) <= 0;
  *o = (unsigned long long)((X509_V_OK) | 0);  /* check that X509_V_OK is an integer */
  return n;
}

static void _cffi_d_ASN1_ENUMERATED_free(ASN1_ENUMERATED * x0)
{
  ASN1_ENUMERATED_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_ENUMERATED_free(PyObject *self, PyObject *arg0)
{
  ASN1_ENUMERATED * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(384), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_ENUMERATED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(384), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_ENUMERATED_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ASN1_ENUMERATED_free _cffi_d_ASN1_ENUMERATED_free
#endif

static ASN1_ENUMERATED * _cffi_d_ASN1_ENUMERATED_new(void)
{
  return ASN1_ENUMERATED_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_ENUMERATED_new(PyObject *self, PyObject *noarg)
{
  ASN1_ENUMERATED * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_ENUMERATED_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(384));
  return pyresult;
}
#else
#  define _cffi_f_ASN1_ENUMERATED_new _cffi_d_ASN1_ENUMERATED_new
#endif

static int _cffi_d_ASN1_ENUMERATED_set(ASN1_ENUMERATED * x0, long x1)
{
  return ASN1_ENUMERATED_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_ENUMERATED_set(PyObject *self, PyObject *args)
{
  ASN1_ENUMERATED * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_ENUMERATED_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(384), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_ENUMERATED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(384), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_ENUMERATED_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_ENUMERATED_set _cffi_d_ASN1_ENUMERATED_set
#endif

static void _cffi_d_ASN1_GENERALIZEDTIME_free(ASN1_GENERALIZEDTIME * x0)
{
  ASN1_GENERALIZEDTIME_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_GENERALIZEDTIME_free(PyObject *self, PyObject *arg0)
{
  ASN1_GENERALIZEDTIME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1244), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_GENERALIZEDTIME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1244), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_GENERALIZEDTIME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ASN1_GENERALIZEDTIME_free _cffi_d_ASN1_GENERALIZEDTIME_free
#endif

static void _cffi_d_ASN1_INTEGER_free(ASN1_INTEGER * x0)
{
  ASN1_INTEGER_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_INTEGER_free(PyObject *self, PyObject *arg0)
{
  ASN1_INTEGER * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_INTEGER_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ASN1_INTEGER_free _cffi_d_ASN1_INTEGER_free
#endif

static int _cffi_d_ASN1_INTEGER_set(ASN1_INTEGER * x0, long x1)
{
  return ASN1_INTEGER_set(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_INTEGER_set(PyObject *self, PyObject *args)
{
  ASN1_INTEGER * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_INTEGER_set", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_set(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_INTEGER_set _cffi_d_ASN1_INTEGER_set
#endif

static BIGNUM * _cffi_d_ASN1_INTEGER_to_BN(ASN1_INTEGER * x0, BIGNUM * x1)
{
  return ASN1_INTEGER_to_BN(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_INTEGER_to_BN(PyObject *self, PyObject *args)
{
  ASN1_INTEGER * x0;
  BIGNUM * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BIGNUM * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_INTEGER_to_BN", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_INTEGER_to_BN(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(7));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_INTEGER_to_BN _cffi_d_ASN1_INTEGER_to_BN
#endif

static unsigned char const * _cffi_d_ASN1_STRING_get0_data(ASN1_OCTET_STRING const * x0)
{
  return ASN1_STRING_get0_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_STRING_get0_data(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_get0_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(194));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_STRING_get0_data _cffi_d_ASN1_STRING_get0_data
#endif

static int _cffi_d_ASN1_STRING_length(ASN1_OCTET_STRING * x0)
{
  return ASN1_STRING_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_STRING_length(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_STRING_length _cffi_d_ASN1_STRING_length
#endif

static int _cffi_d_ASN1_STRING_to_UTF8(unsigned char * * x0, ASN1_OCTET_STRING const * x1)
{
  return ASN1_STRING_to_UTF8(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_STRING_to_UTF8(PyObject *self, PyObject *args)
{
  unsigned char * * x0;
  ASN1_OCTET_STRING const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_STRING_to_UTF8", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(959), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(959), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_to_UTF8(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_STRING_to_UTF8 _cffi_d_ASN1_STRING_to_UTF8
#endif

static int _cffi_d_ASN1_STRING_type(ASN1_OCTET_STRING const * x0)
{
  return ASN1_STRING_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_STRING_type(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_STRING_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_STRING_type _cffi_d_ASN1_STRING_type
#endif

static void _cffi_d_ASN1_TIME_free(ASN1_OCTET_STRING * x0)
{
  ASN1_TIME_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_TIME_free(PyObject *self, PyObject *arg0)
{
  ASN1_OCTET_STRING * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ASN1_TIME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ASN1_TIME_free _cffi_d_ASN1_TIME_free
#endif

static ASN1_OCTET_STRING * _cffi_d_ASN1_TIME_new(void)
{
  return ASN1_TIME_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_TIME_new(PyObject *self, PyObject *noarg)
{
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  return pyresult;
}
#else
#  define _cffi_f_ASN1_TIME_new _cffi_d_ASN1_TIME_new
#endif

static int _cffi_d_ASN1_TIME_set_string(ASN1_OCTET_STRING * x0, char const * x1)
{
  return ASN1_TIME_set_string(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_TIME_set_string(PyObject *self, PyObject *args)
{
  ASN1_OCTET_STRING * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_TIME_set_string", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_set_string(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_TIME_set_string _cffi_d_ASN1_TIME_set_string
#endif

static ASN1_GENERALIZEDTIME * _cffi_d_ASN1_TIME_to_generalizedtime(ASN1_OCTET_STRING const * x0, ASN1_GENERALIZEDTIME * * x1)
{
  return ASN1_TIME_to_generalizedtime(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ASN1_TIME_to_generalizedtime(PyObject *self, PyObject *args)
{
  ASN1_OCTET_STRING const * x0;
  ASN1_GENERALIZEDTIME * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_GENERALIZEDTIME * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ASN1_TIME_to_generalizedtime", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_GENERALIZEDTIME * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ASN1_TIME_to_generalizedtime(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1244));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ASN1_TIME_to_generalizedtime _cffi_d_ASN1_TIME_to_generalizedtime
#endif

static void _cffi_d_BIO_ADDR_free(BIO_ADDR * x0)
{
  BIO_ADDR_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_ADDR_free(PyObject *self, PyObject *arg0)
{
  BIO_ADDR * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(677), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO_ADDR *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(677), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BIO_ADDR_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_BIO_ADDR_free _cffi_d_BIO_ADDR_free
#endif

static BIO_ADDR * _cffi_d_BIO_ADDR_new(void)
{
  return BIO_ADDR_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_ADDR_new(PyObject *self, PyObject *noarg)
{
  BIO_ADDR * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_ADDR_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(677));
  return pyresult;
}
#else
#  define _cffi_f_BIO_ADDR_new _cffi_d_BIO_ADDR_new
#endif

static int _cffi_d_BIO_free(BIO * x0)
{
  return BIO_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_free(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_free _cffi_d_BIO_free
#endif

static long _cffi_d_BIO_get_mem_data(BIO * x0, char * * x1)
{
  return BIO_get_mem_data(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_get_mem_data(PyObject *self, PyObject *args)
{
  BIO * x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BIO_get_mem_data", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1088), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1088), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_get_mem_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_get_mem_data _cffi_d_BIO_get_mem_data
#endif

static BIO * _cffi_d_BIO_new(BIO_METHOD * x0)
{
  return BIO_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_new(PyObject *self, PyObject *arg0)
{
  BIO_METHOD * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BIO * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(47), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO_METHOD *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(47), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(84));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_new _cffi_d_BIO_new
#endif

static BIO * _cffi_d_BIO_new_file(char const * x0, char const * x1)
{
  return BIO_new_file(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_new_file(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BIO * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BIO_new_file", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(84));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_new_file _cffi_d_BIO_new_file
#endif

static BIO * _cffi_d_BIO_new_mem_buf(void const * x0, int x1)
{
  return BIO_new_mem_buf(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_new_mem_buf(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  BIO * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BIO_new_mem_buf", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_new_mem_buf(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(84));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_new_mem_buf _cffi_d_BIO_new_mem_buf
#endif

static int _cffi_d_BIO_read(BIO * x0, void * x1, int x2)
{
  return BIO_read(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_read(PyObject *self, PyObject *args)
{
  BIO * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "BIO_read", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_read(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_read _cffi_d_BIO_read
#endif

static int _cffi_d_BIO_reset(BIO * x0)
{
  return BIO_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_reset(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_reset _cffi_d_BIO_reset
#endif

static BIO_METHOD const * _cffi_d_BIO_s_mem(void)
{
  return BIO_s_mem();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_s_mem(PyObject *self, PyObject *noarg)
{
  BIO_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_s_mem(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1536));
  return pyresult;
}
#else
#  define _cffi_f_BIO_s_mem _cffi_d_BIO_s_mem
#endif

static long _cffi_d_BIO_set_mem_eof_return(BIO * x0, int x1)
{
  return BIO_set_mem_eof_return(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_set_mem_eof_return(PyObject *self, PyObject *args)
{
  BIO * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BIO_set_mem_eof_return", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_set_mem_eof_return(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_set_mem_eof_return _cffi_d_BIO_set_mem_eof_return
#endif

static int _cffi_d_BIO_should_io_special(BIO * x0)
{
  return BIO_should_io_special(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_should_io_special(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_io_special(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_should_io_special _cffi_d_BIO_should_io_special
#endif

static int _cffi_d_BIO_should_read(BIO * x0)
{
  return BIO_should_read(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_should_read(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_read(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_should_read _cffi_d_BIO_should_read
#endif

static int _cffi_d_BIO_should_retry(BIO * x0)
{
  return BIO_should_retry(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_should_retry(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_retry(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_should_retry _cffi_d_BIO_should_retry
#endif

static int _cffi_d_BIO_should_write(BIO * x0)
{
  return BIO_should_write(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_should_write(PyObject *self, PyObject *arg0)
{
  BIO * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_should_write(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_should_write _cffi_d_BIO_should_write
#endif

static int _cffi_d_BIO_write(BIO * x0, void const * x1, int x2)
{
  return BIO_write(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BIO_write(PyObject *self, PyObject *args)
{
  BIO * x0;
  void const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "BIO_write", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BIO_write(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BIO_write _cffi_d_BIO_write
#endif

static char * _cffi_d_BN_bn2hex(BIGNUM const * x0)
{
  return BN_bn2hex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_bn2hex(PyObject *self, PyObject *arg0)
{
  BIGNUM const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_bn2hex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(156));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_bn2hex _cffi_d_BN_bn2hex
#endif

static void _cffi_d_BN_free(BIGNUM * x0)
{
  BN_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_free(PyObject *self, PyObject *arg0)
{
  BIGNUM * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { BN_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_BN_free _cffi_d_BN_free
#endif

static int _cffi_d_BN_generate_prime_ex(BIGNUM * x0, int x1, int x2, BIGNUM const * x3, BIGNUM const * x4, BN_GENCB * x5)
{
  return BN_generate_prime_ex(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_generate_prime_ex(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  int x1;
  int x2;
  BIGNUM const * x3;
  BIGNUM const * x4;
  BN_GENCB * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "BN_generate_prime_ex", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (BIGNUM const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (BIGNUM const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(422), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (BN_GENCB *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(422), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_generate_prime_ex(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_generate_prime_ex _cffi_d_BN_generate_prime_ex
#endif

static int _cffi_d_BN_hex2bn(BIGNUM * * x0, char const * x1)
{
  return BN_hex2bn(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_hex2bn(PyObject *self, PyObject *args)
{
  BIGNUM * * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BN_hex2bn", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(405), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(405), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_hex2bn(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_hex2bn _cffi_d_BN_hex2bn
#endif

static int _cffi_d_BN_is_prime_ex(BIGNUM const * x0, int x1, BN_CTX * x2, BN_GENCB * x3)
{
  return BN_is_prime_ex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_is_prime_ex(PyObject *self, PyObject *args)
{
  BIGNUM const * x0;
  int x1;
  BN_CTX * x2;
  BN_GENCB * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "BN_is_prime_ex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(427), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (BN_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(427), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(422), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (BN_GENCB *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(422), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_is_prime_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_is_prime_ex _cffi_d_BN_is_prime_ex
#endif

static BIGNUM * _cffi_d_BN_new(void)
{
  return BN_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_new(PyObject *self, PyObject *noarg)
{
  BIGNUM * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(7));
  return pyresult;
}
#else
#  define _cffi_f_BN_new _cffi_d_BN_new
#endif

static int _cffi_d_BN_prime_checks_for_size(int x0)
{
  return BN_prime_checks_for_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_prime_checks_for_size(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_prime_checks_for_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_BN_prime_checks_for_size _cffi_d_BN_prime_checks_for_size
#endif

static int _cffi_d_BN_rand_range(BIGNUM * x0, BIGNUM const * x1)
{
  return BN_rand_range(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_rand_range(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BIGNUM const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BN_rand_range", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(349), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (BIGNUM const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(349), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_rand_range(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_rand_range _cffi_d_BN_rand_range
#endif

static int _cffi_d_BN_set_word(BIGNUM * x0, BN_ULONG x1)
{
  return BN_set_word(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_set_word(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  BN_ULONG x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BN_set_word", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, BN_ULONG);
  if (x1 == (BN_ULONG)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_set_word(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_set_word _cffi_d_BN_set_word
#endif

static ASN1_INTEGER * _cffi_d_BN_to_ASN1_INTEGER(BIGNUM * x0, ASN1_INTEGER * x1)
{
  return BN_to_ASN1_INTEGER(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_BN_to_ASN1_INTEGER(PyObject *self, PyObject *args)
{
  BIGNUM * x0;
  ASN1_INTEGER * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_INTEGER * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "BN_to_ASN1_INTEGER", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = BN_to_ASN1_INTEGER(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_BN_to_ASN1_INTEGER _cffi_d_BN_to_ASN1_INTEGER
#endif

static long _cffi_d_Cryptography_DTLSv1_get_timeout(SSL * x0, time_t * x1, long * x2)
{
  return Cryptography_DTLSv1_get_timeout(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Cryptography_DTLSv1_get_timeout(PyObject *self, PyObject *args)
{
  SSL * x0;
  time_t * x1;
  long * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Cryptography_DTLSv1_get_timeout", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1103), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (time_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1103), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1104), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1104), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_DTLSv1_get_timeout(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Cryptography_DTLSv1_get_timeout _cffi_d_Cryptography_DTLSv1_get_timeout
#endif

static SSL_SESSION * _cffi_d_Cryptography_SSL_SESSION_new(void)
{
  return Cryptography_SSL_SESSION_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Cryptography_SSL_SESSION_new(PyObject *self, PyObject *noarg)
{
  SSL_SESSION * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Cryptography_SSL_SESSION_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(692));
  return pyresult;
}
#else
#  define _cffi_f_Cryptography_SSL_SESSION_new _cffi_d_Cryptography_SSL_SESSION_new
#endif

static void _cffi_d_DH_free(DH * x0)
{
  DH_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DH_free(PyObject *self, PyObject *arg0)
{
  DH * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1123), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DH *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1123), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { DH_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_DH_free _cffi_d_DH_free
#endif

static void _cffi_d_DSA_free(DSA * x0)
{
  DSA_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DSA_free(PyObject *self, PyObject *arg0)
{
  DSA * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { DSA_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_DSA_free _cffi_d_DSA_free
#endif

static int _cffi_d_DSA_generate_key(DSA * x0)
{
  return DSA_generate_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DSA_generate_key(PyObject *self, PyObject *arg0)
{
  DSA * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_generate_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DSA_generate_key _cffi_d_DSA_generate_key
#endif

static int _cffi_d_DSA_generate_parameters_ex(DSA * x0, int x1, unsigned char * x2, int x3, int * x4, unsigned long * x5, BN_GENCB * x6)
{
  return DSA_generate_parameters_ex(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DSA_generate_parameters_ex(PyObject *self, PyObject *args)
{
  DSA * x0;
  int x1;
  unsigned char * x2;
  int x3;
  int * x4;
  unsigned long * x5;
  BN_GENCB * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "DSA_generate_parameters_ex", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(532), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(532), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(422), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (BN_GENCB *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(422), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_generate_parameters_ex(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DSA_generate_parameters_ex _cffi_d_DSA_generate_parameters_ex
#endif

static DSA * _cffi_d_DSA_new(void)
{
  return DSA_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DSA_new(PyObject *self, PyObject *noarg)
{
  DSA * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DSA_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(524));
  return pyresult;
}
#else
#  define _cffi_f_DSA_new _cffi_d_DSA_new
#endif

static SSL_METHOD const * _cffi_d_DTLS_client_method(void)
{
  return DTLS_client_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLS_client_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLS_client_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_DTLS_client_method _cffi_d_DTLS_client_method
#endif

static size_t _cffi_d_DTLS_get_data_mtu(SSL * x0)
{
  return DTLS_get_data_mtu(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLS_get_data_mtu(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLS_get_data_mtu(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DTLS_get_data_mtu _cffi_d_DTLS_get_data_mtu
#endif

static SSL_METHOD const * _cffi_d_DTLS_method(void)
{
  return DTLS_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLS_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLS_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_DTLS_method _cffi_d_DTLS_method
#endif

static SSL_METHOD const * _cffi_d_DTLS_server_method(void)
{
  return DTLS_server_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLS_server_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLS_server_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_DTLS_server_method _cffi_d_DTLS_server_method
#endif

static long _cffi_d_DTLSv1_handle_timeout(SSL * x0)
{
  return DTLSv1_handle_timeout(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLSv1_handle_timeout(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLSv1_handle_timeout(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DTLSv1_handle_timeout _cffi_d_DTLSv1_handle_timeout
#endif

static int _cffi_d_DTLSv1_listen(SSL * x0, BIO_ADDR * x1)
{
  return DTLSv1_listen(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DTLSv1_listen(PyObject *self, PyObject *args)
{
  SSL * x0;
  BIO_ADDR * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "DTLSv1_listen", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(677), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (BIO_ADDR *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(677), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DTLSv1_listen(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DTLSv1_listen _cffi_d_DTLSv1_listen
#endif

static void _cffi_d_EC_KEY_free(EC_KEY * x0)
{
  EC_KEY_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EC_KEY_free(PyObject *self, PyObject *arg0)
{
  EC_KEY * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1127), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EC_KEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1127), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EC_KEY_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_EC_KEY_free _cffi_d_EC_KEY_free
#endif

static EC_KEY * _cffi_d_EC_KEY_new_by_curve_name(int x0)
{
  return EC_KEY_new_by_curve_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EC_KEY_new_by_curve_name(PyObject *self, PyObject *arg0)
{
  int x0;
  EC_KEY * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_KEY_new_by_curve_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1127));
  return pyresult;
}
#else
#  define _cffi_f_EC_KEY_new_by_curve_name _cffi_d_EC_KEY_new_by_curve_name
#endif

static char const * _cffi_d_EC_curve_nid2nist(int x0)
{
  return EC_curve_nid2nist(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EC_curve_nid2nist(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_curve_nid2nist(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_EC_curve_nid2nist _cffi_d_EC_curve_nid2nist
#endif

static size_t _cffi_d_EC_get_builtin_curves(EC_builtin_curve * x0, size_t x1)
{
  return EC_get_builtin_curves(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EC_get_builtin_curves(PyObject *self, PyObject *args)
{
  EC_builtin_curve * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EC_get_builtin_curves", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EC_builtin_curve *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EC_get_builtin_curves(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EC_get_builtin_curves _cffi_d_EC_get_builtin_curves
#endif

static ENGINE * _cffi_d_ENGINE_by_id(char const * x0)
{
  return ENGINE_by_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_by_id(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ENGINE * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_by_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(125));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_by_id _cffi_d_ENGINE_by_id
#endif

static int _cffi_d_ENGINE_ctrl_cmd(ENGINE * x0, char const * x1, long x2, void * x3, void(* x4)(void), int x5)
{
  return ENGINE_ctrl_cmd(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_ctrl_cmd(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  long x2;
  void * x3;
  void(* x4)(void);
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ENGINE_ctrl_cmd", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, long);
  if (x2 == (long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(void))_cffi_to_c_pointer(arg4, _cffi_type(549));
  if (x4 == (void(*)(void))NULL && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_ctrl_cmd(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_ctrl_cmd _cffi_d_ENGINE_ctrl_cmd
#endif

static int _cffi_d_ENGINE_ctrl_cmd_string(ENGINE * x0, char const * x1, char const * x2, int x3)
{
  return ENGINE_ctrl_cmd_string(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_ctrl_cmd_string(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ENGINE_ctrl_cmd_string", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_ctrl_cmd_string(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_ctrl_cmd_string _cffi_d_ENGINE_ctrl_cmd_string
#endif

static int _cffi_d_ENGINE_finish(ENGINE * x0)
{
  return ENGINE_finish(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_finish(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_finish(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_finish _cffi_d_ENGINE_finish
#endif

static int _cffi_d_ENGINE_free(ENGINE * x0)
{
  return ENGINE_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_free(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_free _cffi_d_ENGINE_free
#endif

static ENGINE * _cffi_d_ENGINE_get_default_RAND(void)
{
  return ENGINE_get_default_RAND();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_get_default_RAND(PyObject *self, PyObject *noarg)
{
  ENGINE * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_default_RAND(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(125));
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_get_default_RAND _cffi_d_ENGINE_get_default_RAND
#endif

static char const * _cffi_d_ENGINE_get_name(ENGINE const * x0)
{
  return ENGINE_get_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_get_name(PyObject *self, PyObject *arg0)
{
  ENGINE const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(360), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(360), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_get_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_get_name _cffi_d_ENGINE_get_name
#endif

static int _cffi_d_ENGINE_init(ENGINE * x0)
{
  return ENGINE_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_init(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_init _cffi_d_ENGINE_init
#endif

static void _cffi_d_ENGINE_load_builtin_engines(void)
{
  ENGINE_load_builtin_engines();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_load_builtin_engines(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_load_builtin_engines(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ENGINE_load_builtin_engines _cffi_d_ENGINE_load_builtin_engines
#endif

static EVP_PKEY * _cffi_d_ENGINE_load_private_key(ENGINE * x0, char const * x1, UI_METHOD * x2, void * x3)
{
  return ENGINE_load_private_key(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_load_private_key(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  UI_METHOD * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ENGINE_load_private_key", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (UI_METHOD *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(127), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_load_private_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_load_private_key _cffi_d_ENGINE_load_private_key
#endif

static EVP_PKEY * _cffi_d_ENGINE_load_public_key(ENGINE * x0, char const * x1, UI_METHOD * x2, void * x3)
{
  return ENGINE_load_public_key(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_load_public_key(PyObject *self, PyObject *args)
{
  ENGINE * x0;
  char const * x1;
  UI_METHOD * x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ENGINE_load_public_key", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (UI_METHOD *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(127), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_load_public_key(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_load_public_key _cffi_d_ENGINE_load_public_key
#endif

static int _cffi_d_ENGINE_set_default_RAND(ENGINE * x0)
{
  return ENGINE_set_default_RAND(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_set_default_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENGINE_set_default_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENGINE_set_default_RAND _cffi_d_ENGINE_set_default_RAND
#endif

static void _cffi_d_ENGINE_unregister_RAND(ENGINE * x0)
{
  ENGINE_unregister_RAND(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENGINE_unregister_RAND(PyObject *self, PyObject *arg0)
{
  ENGINE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ENGINE_unregister_RAND(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ENGINE_unregister_RAND _cffi_d_ENGINE_unregister_RAND
#endif

static int _cffi_d_ERR_GET_REASON(unsigned long x0)
{
  return ERR_GET_REASON(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_GET_REASON(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_GET_REASON(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ERR_GET_REASON _cffi_d_ERR_GET_REASON
#endif

static void _cffi_d_ERR_clear_error(void)
{
  ERR_clear_error();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_clear_error(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_clear_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ERR_clear_error _cffi_d_ERR_clear_error
#endif

static char const * _cffi_d_ERR_func_error_string(unsigned long x0)
{
  return ERR_func_error_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_func_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_func_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_ERR_func_error_string _cffi_d_ERR_func_error_string
#endif

static unsigned long _cffi_d_ERR_get_error(void)
{
  return ERR_get_error();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_get_error(PyObject *self, PyObject *noarg)
{
  unsigned long result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_get_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  return pyresult;
}
#else
#  define _cffi_f_ERR_get_error _cffi_d_ERR_get_error
#endif

static char const * _cffi_d_ERR_lib_error_string(unsigned long x0)
{
  return ERR_lib_error_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_lib_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_lib_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_ERR_lib_error_string _cffi_d_ERR_lib_error_string
#endif

static unsigned long _cffi_d_ERR_peek_error(void)
{
  return ERR_peek_error();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_peek_error(PyObject *self, PyObject *noarg)
{
  unsigned long result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_peek_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  return pyresult;
}
#else
#  define _cffi_f_ERR_peek_error _cffi_d_ERR_peek_error
#endif

static void _cffi_d_ERR_put_error(int x0, int x1, int x2, char const * x3, int x4)
{
  ERR_put_error(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_put_error(PyObject *self, PyObject *args)
{
  int x0;
  int x1;
  int x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ERR_put_error", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ERR_put_error(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ERR_put_error _cffi_d_ERR_put_error
#endif

static char const * _cffi_d_ERR_reason_error_string(unsigned long x0)
{
  return ERR_reason_error_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ERR_reason_error_string(PyObject *self, PyObject *arg0)
{
  unsigned long x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned long);
  if (x0 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ERR_reason_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_ERR_reason_error_string _cffi_d_ERR_reason_error_string
#endif

static int _cffi_d_EVP_CIPHER_CTX_ctrl(EVP_CIPHER_CTX * x0, int x1, int x2, void * x3)
{
  return EVP_CIPHER_CTX_ctrl(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_ctrl(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  int x2;
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "EVP_CIPHER_CTX_ctrl", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_ctrl(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_ctrl _cffi_d_EVP_CIPHER_CTX_ctrl
#endif

static void _cffi_d_EVP_CIPHER_CTX_free(EVP_CIPHER_CTX * x0)
{
  EVP_CIPHER_CTX_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_free(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_CIPHER_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_free _cffi_d_EVP_CIPHER_CTX_free
#endif

static EVP_CIPHER_CTX * _cffi_d_EVP_CIPHER_CTX_new(void)
{
  return EVP_CIPHER_CTX_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_new(PyObject *self, PyObject *noarg)
{
  EVP_CIPHER_CTX * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(553));
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_new _cffi_d_EVP_CIPHER_CTX_new
#endif

static int _cffi_d_EVP_CIPHER_CTX_reset(EVP_CIPHER_CTX * x0)
{
  return EVP_CIPHER_CTX_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_reset(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_reset _cffi_d_EVP_CIPHER_CTX_reset
#endif

static int _cffi_d_EVP_CIPHER_CTX_set_key_length(EVP_CIPHER_CTX * x0, int x1)
{
  return EVP_CIPHER_CTX_set_key_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_set_key_length(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_CIPHER_CTX_set_key_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_set_key_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_set_key_length _cffi_d_EVP_CIPHER_CTX_set_key_length
#endif

static int _cffi_d_EVP_CIPHER_CTX_set_padding(EVP_CIPHER_CTX * x0, int x1)
{
  return EVP_CIPHER_CTX_set_padding(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_CTX_set_padding(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_CIPHER_CTX_set_padding", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_CTX_set_padding(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_CTX_set_padding _cffi_d_EVP_CIPHER_CTX_set_padding
#endif

static EVP_CIPHER * _cffi_d_EVP_CIPHER_fetch(OSSL_LIB_CTX * x0, char const * x1, char const * x2)
{
  return EVP_CIPHER_fetch(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_fetch(PyObject *self, PyObject *args)
{
  OSSL_LIB_CTX * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_CIPHER * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "EVP_CIPHER_fetch", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OSSL_LIB_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CIPHER_fetch(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1283));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CIPHER_fetch _cffi_d_EVP_CIPHER_fetch
#endif

static void _cffi_d_EVP_CIPHER_free(EVP_CIPHER * x0)
{
  EVP_CIPHER_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CIPHER_free(PyObject *self, PyObject *arg0)
{
  EVP_CIPHER * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1283), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1283), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_CIPHER_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_EVP_CIPHER_free _cffi_d_EVP_CIPHER_free
#endif

static int _cffi_d_EVP_CipherFinal_ex(EVP_CIPHER_CTX * x0, unsigned char * x1, int * x2)
{
  return EVP_CipherFinal_ex(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CipherFinal_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "EVP_CipherFinal_ex", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherFinal_ex(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CipherFinal_ex _cffi_d_EVP_CipherFinal_ex
#endif

static int _cffi_d_EVP_CipherInit_ex(EVP_CIPHER_CTX * x0, EVP_CIPHER const * x1, ENGINE * x2, unsigned char const * x3, unsigned char const * x4, int x5)
{
  return EVP_CipherInit_ex(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CipherInit_ex(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  EVP_CIPHER const * x1;
  ENGINE * x2;
  unsigned char const * x3;
  unsigned char const * x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "EVP_CipherInit_ex", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(444), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(444), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherInit_ex(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CipherInit_ex _cffi_d_EVP_CipherInit_ex
#endif

static int _cffi_d_EVP_CipherUpdate(EVP_CIPHER_CTX * x0, unsigned char * x1, int * x2, unsigned char const * x3, int x4)
{
  return EVP_CipherUpdate(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_CipherUpdate(PyObject *self, PyObject *args)
{
  EVP_CIPHER_CTX * x0;
  unsigned char * x1;
  int * x2;
  unsigned char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "EVP_CipherUpdate", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(553), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_CIPHER_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(553), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_CipherUpdate(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_CipherUpdate _cffi_d_EVP_CipherUpdate
#endif

static void _cffi_d_EVP_MD_CTX_free(EVP_MD_CTX * x0)
{
  EVP_MD_CTX_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_MD_CTX_free(PyObject *self, PyObject *arg0)
{
  EVP_MD_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_MD_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_EVP_MD_CTX_free _cffi_d_EVP_MD_CTX_free
#endif

static EVP_MD_CTX * _cffi_d_EVP_MD_CTX_new(void)
{
  return EVP_MD_CTX_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_MD_CTX_new(PyObject *self, PyObject *noarg)
{
  EVP_MD_CTX * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_MD_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(586));
  return pyresult;
}
#else
#  define _cffi_f_EVP_MD_CTX_new _cffi_d_EVP_MD_CTX_new
#endif

static int _cffi_d_EVP_PKEY_assign_RSA(EVP_PKEY * x0, RSA * x1)
{
  return EVP_PKEY_assign_RSA(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_assign_RSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  RSA * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_PKEY_assign_RSA", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(615), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (RSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(615), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_assign_RSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_assign_RSA _cffi_d_EVP_PKEY_assign_RSA
#endif

static int _cffi_d_EVP_PKEY_bits(EVP_PKEY const * x0)
{
  return EVP_PKEY_bits(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_bits(PyObject *self, PyObject *arg0)
{
  EVP_PKEY const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(618), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(618), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_bits(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_bits _cffi_d_EVP_PKEY_bits
#endif

static void _cffi_d_EVP_PKEY_free(EVP_PKEY * x0)
{
  EVP_PKEY_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_free(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { EVP_PKEY_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_EVP_PKEY_free _cffi_d_EVP_PKEY_free
#endif

static RSA * _cffi_d_EVP_PKEY_get1_RSA(EVP_PKEY * x0)
{
  return EVP_PKEY_get1_RSA(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_get1_RSA(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  RSA * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_get1_RSA(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(615));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_get1_RSA _cffi_d_EVP_PKEY_get1_RSA
#endif

static int _cffi_d_EVP_PKEY_id(EVP_PKEY const * x0)
{
  return EVP_PKEY_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_id(PyObject *self, PyObject *arg0)
{
  EVP_PKEY const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(618), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(618), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_id _cffi_d_EVP_PKEY_id
#endif

static EVP_PKEY * _cffi_d_EVP_PKEY_new(void)
{
  return EVP_PKEY_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_new(PyObject *self, PyObject *noarg)
{
  EVP_PKEY * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_new _cffi_d_EVP_PKEY_new
#endif

static int _cffi_d_EVP_PKEY_set1_DSA(EVP_PKEY * x0, DSA * x1)
{
  return EVP_PKEY_set1_DSA(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_set1_DSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  DSA * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_PKEY_set1_DSA", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(524), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (DSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(524), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_DSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_set1_DSA _cffi_d_EVP_PKEY_set1_DSA
#endif

static int _cffi_d_EVP_PKEY_set1_RSA(EVP_PKEY * x0, RSA * x1)
{
  return EVP_PKEY_set1_RSA(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_set1_RSA(PyObject *self, PyObject *args)
{
  EVP_PKEY * x0;
  RSA * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_PKEY_set1_RSA", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(615), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (RSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(615), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_set1_RSA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_set1_RSA _cffi_d_EVP_PKEY_set1_RSA
#endif

static int _cffi_d_EVP_PKEY_size(EVP_PKEY * x0)
{
  return EVP_PKEY_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_size(PyObject *self, PyObject *arg0)
{
  EVP_PKEY * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_size _cffi_d_EVP_PKEY_size
#endif

static int _cffi_d_EVP_PKEY_type(int x0)
{
  return EVP_PKEY_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_PKEY_type(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_PKEY_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_EVP_PKEY_type _cffi_d_EVP_PKEY_type
#endif

static int _cffi_d_EVP_SignFinal(EVP_MD_CTX * x0, unsigned char * x1, unsigned int * x2, EVP_PKEY * x3)
{
  return EVP_SignFinal(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_SignFinal(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  unsigned char * x1;
  unsigned int * x2;
  EVP_PKEY * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "EVP_SignFinal", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(592), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(592), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignFinal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_SignFinal _cffi_d_EVP_SignFinal
#endif

static int _cffi_d_EVP_SignInit(EVP_MD_CTX * x0, EVP_MD const * x1)
{
  return EVP_SignInit(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_SignInit(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_SignInit", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignInit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_SignInit _cffi_d_EVP_SignInit
#endif

static int _cffi_d_EVP_SignUpdate(EVP_MD_CTX * x0, void const * x1, size_t x2)
{
  return EVP_SignUpdate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_SignUpdate(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "EVP_SignUpdate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_SignUpdate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_SignUpdate _cffi_d_EVP_SignUpdate
#endif

static int _cffi_d_EVP_VerifyFinal(EVP_MD_CTX * x0, unsigned char const * x1, unsigned int x2, EVP_PKEY * x3)
{
  return EVP_VerifyFinal(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_VerifyFinal(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  unsigned char const * x1;
  unsigned int x2;
  EVP_PKEY * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "EVP_VerifyFinal", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyFinal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_VerifyFinal _cffi_d_EVP_VerifyFinal
#endif

static int _cffi_d_EVP_VerifyInit(EVP_MD_CTX * x0, EVP_MD const * x1)
{
  return EVP_VerifyInit(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_VerifyInit(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  EVP_MD const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_VerifyInit", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyInit(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_VerifyInit _cffi_d_EVP_VerifyInit
#endif

static int _cffi_d_EVP_VerifyUpdate(EVP_MD_CTX * x0, void const * x1, size_t x2)
{
  return EVP_VerifyUpdate(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_VerifyUpdate(PyObject *self, PyObject *args)
{
  EVP_MD_CTX * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "EVP_VerifyUpdate", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(586), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (EVP_MD_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(586), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_VerifyUpdate(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_VerifyUpdate _cffi_d_EVP_VerifyUpdate
#endif

static int _cffi_d_EVP_default_properties_enable_fips(OSSL_LIB_CTX * x0, int x1)
{
  return EVP_default_properties_enable_fips(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_default_properties_enable_fips(PyObject *self, PyObject *args)
{
  OSSL_LIB_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "EVP_default_properties_enable_fips", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OSSL_LIB_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_default_properties_enable_fips(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_default_properties_enable_fips _cffi_d_EVP_default_properties_enable_fips
#endif

static EVP_CIPHER const * _cffi_d_EVP_get_cipherbyname(char const * x0)
{
  return EVP_get_cipherbyname(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_get_cipherbyname(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_CIPHER const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_get_cipherbyname(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(444));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_get_cipherbyname _cffi_d_EVP_get_cipherbyname
#endif

static EVP_MD const * _cffi_d_EVP_get_digestbyname(char const * x0)
{
  return EVP_get_digestbyname(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_EVP_get_digestbyname(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_MD const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = EVP_get_digestbyname(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(587));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_EVP_get_digestbyname _cffi_d_EVP_get_digestbyname
#endif

static void _cffi_d_GENERAL_NAMES_free(GENERAL_NAMES * x0)
{
  GENERAL_NAMES_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_GENERAL_NAMES_free(PyObject *self, PyObject *arg0)
{
  GENERAL_NAMES * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(142), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GENERAL_NAMES *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(142), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { GENERAL_NAMES_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_GENERAL_NAMES_free _cffi_d_GENERAL_NAMES_free
#endif

static int _cffi_d_GENERAL_NAME_print(BIO * x0, GENERAL_NAME * x1)
{
  return GENERAL_NAME_print(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_GENERAL_NAME_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  GENERAL_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "GENERAL_NAME_print", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(452), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (GENERAL_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(452), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = GENERAL_NAME_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_GENERAL_NAME_print _cffi_d_GENERAL_NAME_print
#endif

static char * _cffi_d_NETSCAPE_SPKI_b64_encode(NETSCAPE_SPKI * x0)
{
  return NETSCAPE_SPKI_b64_encode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_b64_encode(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_b64_encode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(156));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_b64_encode _cffi_d_NETSCAPE_SPKI_b64_encode
#endif

static void _cffi_d_NETSCAPE_SPKI_free(NETSCAPE_SPKI * x0)
{
  NETSCAPE_SPKI_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_free(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { NETSCAPE_SPKI_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_free _cffi_d_NETSCAPE_SPKI_free
#endif

static EVP_PKEY * _cffi_d_NETSCAPE_SPKI_get_pubkey(NETSCAPE_SPKI * x0)
{
  return NETSCAPE_SPKI_get_pubkey(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_get_pubkey(PyObject *self, PyObject *arg0)
{
  NETSCAPE_SPKI * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_get_pubkey(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_get_pubkey _cffi_d_NETSCAPE_SPKI_get_pubkey
#endif

static NETSCAPE_SPKI * _cffi_d_NETSCAPE_SPKI_new(void)
{
  return NETSCAPE_SPKI_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_new(PyObject *self, PyObject *noarg)
{
  NETSCAPE_SPKI * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(131));
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_new _cffi_d_NETSCAPE_SPKI_new
#endif

static int _cffi_d_NETSCAPE_SPKI_set_pubkey(NETSCAPE_SPKI * x0, EVP_PKEY * x1)
{
  return NETSCAPE_SPKI_set_pubkey(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_set_pubkey(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "NETSCAPE_SPKI_set_pubkey", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_set_pubkey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_set_pubkey _cffi_d_NETSCAPE_SPKI_set_pubkey
#endif

static int _cffi_d_NETSCAPE_SPKI_sign(NETSCAPE_SPKI * x0, EVP_PKEY * x1, EVP_MD const * x2)
{
  return NETSCAPE_SPKI_sign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_sign(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  EVP_MD const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "NETSCAPE_SPKI_sign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_sign _cffi_d_NETSCAPE_SPKI_sign
#endif

static int _cffi_d_NETSCAPE_SPKI_verify(NETSCAPE_SPKI * x0, EVP_PKEY * x1)
{
  return NETSCAPE_SPKI_verify(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_NETSCAPE_SPKI_verify(PyObject *self, PyObject *args)
{
  NETSCAPE_SPKI * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "NETSCAPE_SPKI_verify", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(131), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (NETSCAPE_SPKI *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(131), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = NETSCAPE_SPKI_verify(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_NETSCAPE_SPKI_verify _cffi_d_NETSCAPE_SPKI_verify
#endif

static char const * _cffi_d_OBJ_nid2ln(int x0)
{
  return OBJ_nid2ln(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OBJ_nid2ln(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_nid2ln(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_OBJ_nid2ln _cffi_d_OBJ_nid2ln
#endif

static char const * _cffi_d_OBJ_nid2sn(int x0)
{
  return OBJ_nid2sn(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OBJ_nid2sn(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_nid2sn(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_OBJ_nid2sn _cffi_d_OBJ_nid2sn
#endif

static int _cffi_d_OBJ_obj2nid(ASN1_OBJECT const * x0)
{
  return OBJ_obj2nid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OBJ_obj2nid(PyObject *self, PyObject *arg0)
{
  ASN1_OBJECT const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(392), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OBJECT const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(392), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_obj2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_OBJ_obj2nid _cffi_d_OBJ_obj2nid
#endif

static int _cffi_d_OBJ_txt2nid(char const * x0)
{
  return OBJ_txt2nid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OBJ_txt2nid(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OBJ_txt2nid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_OBJ_txt2nid _cffi_d_OBJ_txt2nid
#endif

static void _cffi_d_OPENSSL_cleanup(void)
{
  OPENSSL_cleanup();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OPENSSL_cleanup(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OPENSSL_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_OPENSSL_cleanup _cffi_d_OPENSSL_cleanup
#endif

static void _cffi_d_OPENSSL_free(void * x0)
{
  OPENSSL_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OPENSSL_free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { OPENSSL_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_OPENSSL_free _cffi_d_OPENSSL_free
#endif

static void * _cffi_d_OPENSSL_malloc(size_t x0)
{
  return OPENSSL_malloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OPENSSL_malloc(PyObject *self, PyObject *arg0)
{
  size_t x0;
  void * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OPENSSL_malloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(87));
  return pyresult;
}
#else
#  define _cffi_f_OPENSSL_malloc _cffi_d_OPENSSL_malloc
#endif

static OSSL_PROVIDER * _cffi_d_OSSL_PROVIDER_load(OSSL_LIB_CTX * x0, char const * x1)
{
  return OSSL_PROVIDER_load(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OSSL_PROVIDER_load(PyObject *self, PyObject *args)
{
  OSSL_LIB_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OSSL_PROVIDER * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "OSSL_PROVIDER_load", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(100), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OSSL_LIB_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(100), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OSSL_PROVIDER_load(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(637));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_OSSL_PROVIDER_load _cffi_d_OSSL_PROVIDER_load
#endif

static int _cffi_d_OSSL_PROVIDER_unload(OSSL_PROVIDER * x0)
{
  return OSSL_PROVIDER_unload(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OSSL_PROVIDER_unload(PyObject *self, PyObject *arg0)
{
  OSSL_PROVIDER * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(637), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OSSL_PROVIDER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(637), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OSSL_PROVIDER_unload(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_OSSL_PROVIDER_unload _cffi_d_OSSL_PROVIDER_unload
#endif

static char const * _cffi_d_OpenSSL_version(int x0)
{
  return OpenSSL_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OpenSSL_version(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OpenSSL_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_OpenSSL_version _cffi_d_OpenSSL_version
#endif

static unsigned long _cffi_d_OpenSSL_version_num(void)
{
  return OpenSSL_version_num();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_OpenSSL_version_num(PyObject *self, PyObject *noarg)
{
  unsigned long result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = OpenSSL_version_num(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  return pyresult;
}
#else
#  define _cffi_f_OpenSSL_version_num _cffi_d_OpenSSL_version_num
#endif

static DH * _cffi_d_PEM_read_bio_DHparams(BIO * x0, DH * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_DHparams(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_DHparams(PyObject *self, PyObject *args)
{
  BIO * x0;
  DH * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  DH * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_DHparams", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(85), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (DH * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(85), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_DHparams(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1123));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_DHparams _cffi_d_PEM_read_bio_DHparams
#endif

static PKCS7 * _cffi_d_PEM_read_bio_PKCS7(BIO * x0, PKCS7 * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_PKCS7(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_PKCS7(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS7 * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PKCS7 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_PKCS7", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(173), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (PKCS7 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(173), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PKCS7(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(656));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_PKCS7 _cffi_d_PEM_read_bio_PKCS7
#endif

static EVP_PKEY * _cffi_d_PEM_read_bio_PUBKEY(BIO * x0, EVP_PKEY * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_PUBKEY(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_PUBKEY", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PUBKEY(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_PUBKEY _cffi_d_PEM_read_bio_PUBKEY
#endif

static EVP_PKEY * _cffi_d_PEM_read_bio_PrivateKey(BIO * x0, EVP_PKEY * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_PrivateKey(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_PrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_PrivateKey", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_PrivateKey(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_PrivateKey _cffi_d_PEM_read_bio_PrivateKey
#endif

static X509 * _cffi_d_PEM_read_bio_X509(BIO * x0, X509 * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_X509(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_X509(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_X509", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(218), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(218), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_X509 _cffi_d_PEM_read_bio_X509
#endif

static X509_CRL * _cffi_d_PEM_read_bio_X509_CRL(BIO * x0, X509_CRL * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_X509_CRL(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_X509_CRL(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_CRL * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_X509_CRL", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509_CRL(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(81));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_X509_CRL _cffi_d_PEM_read_bio_X509_CRL
#endif

static X509_REQ * _cffi_d_PEM_read_bio_X509_REQ(BIO * x0, X509_REQ * * x1, int(* x2)(char *, int, int, void *), void * x3)
{
  return PEM_read_bio_X509_REQ(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_read_bio_X509_REQ(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * * x1;
  int(* x2)(char *, int, int, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_REQ * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "PEM_read_bio_X509_REQ", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(314), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REQ * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(314), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg2, _cffi_type(86));
  if (x2 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_read_bio_X509_REQ(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(137));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_read_bio_X509_REQ _cffi_d_PEM_read_bio_X509_REQ
#endif

static int _cffi_d_PEM_write_bio_PUBKEY(BIO * x0, EVP_PKEY * x1)
{
  return PEM_write_bio_PUBKEY(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_write_bio_PUBKEY(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PEM_write_bio_PUBKEY", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PUBKEY(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_write_bio_PUBKEY _cffi_d_PEM_write_bio_PUBKEY
#endif

static int _cffi_d_PEM_write_bio_PrivateKey(BIO * x0, EVP_PKEY * x1, EVP_CIPHER const * x2, unsigned char * x3, int x4, int(* x5)(char *, int, int, void *), void * x6)
{
  return PEM_write_bio_PrivateKey(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_write_bio_PrivateKey(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  EVP_CIPHER const * x2;
  unsigned char * x3;
  int x4;
  int(* x5)(char *, int, int, void *);
  void * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "PEM_write_bio_PrivateKey", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(444), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(444), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg5, _cffi_type(86));
  if (x5 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_PrivateKey(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_write_bio_PrivateKey _cffi_d_PEM_write_bio_PrivateKey
#endif

static int _cffi_d_PEM_write_bio_X509(BIO * x0, X509 * x1)
{
  return PEM_write_bio_X509(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_write_bio_X509(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PEM_write_bio_X509", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_write_bio_X509 _cffi_d_PEM_write_bio_X509
#endif

static int _cffi_d_PEM_write_bio_X509_CRL(BIO * x0, X509_CRL * x1)
{
  return PEM_write_bio_X509_CRL(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_write_bio_X509_CRL(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PEM_write_bio_X509_CRL", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509_CRL(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_write_bio_X509_CRL _cffi_d_PEM_write_bio_X509_CRL
#endif

static int _cffi_d_PEM_write_bio_X509_REQ(BIO * x0, X509_REQ * x1)
{
  return PEM_write_bio_X509_REQ(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PEM_write_bio_X509_REQ(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "PEM_write_bio_X509_REQ", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PEM_write_bio_X509_REQ(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PEM_write_bio_X509_REQ _cffi_d_PEM_write_bio_X509_REQ
#endif

static PKCS12 * _cffi_d_PKCS12_create(char * x0, char * x1, EVP_PKEY * x2, X509 * x3, Cryptography_STACK_OF_X509 * x4, int x5, int x6, int x7, int x8, int x9)
{
  return PKCS12_create(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS12_create(PyObject *self, PyObject *args)
{
  char * x0;
  char * x1;
  EVP_PKEY * x2;
  X509 * x3;
  Cryptography_STACK_OF_X509 * x4;
  int x5;
  int x6;
  int x7;
  int x8;
  int x9;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PKCS12 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;

  if (!PyArg_UnpackTuple(args, "PKCS12_create", 10, 10, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(156), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(156), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(156), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(156), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  x8 = _cffi_to_c_int(arg8, int);
  if (x8 == (int)-1 && PyErr_Occurred())
    return NULL;

  x9 = _cffi_to_c_int(arg9, int);
  if (x9 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS12_create(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(456));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PKCS12_create _cffi_d_PKCS12_create
#endif

static void _cffi_d_PKCS12_free(PKCS12 * x0)
{
  PKCS12_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS12_free(PyObject *self, PyObject *arg0)
{
  PKCS12 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PKCS12 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { PKCS12_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_PKCS12_free _cffi_d_PKCS12_free
#endif

static int _cffi_d_PKCS12_parse(PKCS12 * x0, char const * x1, EVP_PKEY * * x2, X509 * * x3, Cryptography_STACK_OF_X509 * * x4)
{
  return PKCS12_parse(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS12_parse(PyObject *self, PyObject *args)
{
  PKCS12 * x0;
  char const * x1;
  EVP_PKEY * * x2;
  X509 * * x3;
  Cryptography_STACK_OF_X509 * * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "PKCS12_parse", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PKCS12 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_PKEY * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(218), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (X509 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(218), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(644), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(644), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS12_parse(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PKCS12_parse _cffi_d_PKCS12_parse
#endif

static int _cffi_d_PKCS12_set_mac(PKCS12 * x0, char const * x1, int x2, unsigned char * x3, int x4, int x5, EVP_MD const * x6)
{
  return PKCS12_set_mac(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS12_set_mac(PyObject *self, PyObject *args)
{
  PKCS12 * x0;
  char const * x1;
  int x2;
  unsigned char * x3;
  int x4;
  int x5;
  EVP_MD const * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "PKCS12_set_mac", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PKCS12 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS12_set_mac(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PKCS12_set_mac _cffi_d_PKCS12_set_mac
#endif

static void _cffi_d_PKCS7_free(PKCS7 * x0)
{
  PKCS7_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS7_free(PyObject *self, PyObject *arg0)
{
  PKCS7 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(656), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PKCS7 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(656), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { PKCS7_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_PKCS7_free _cffi_d_PKCS7_free
#endif

static int _cffi_d_PKCS7_verify(PKCS7 * x0, Cryptography_STACK_OF_X509 * x1, X509_STORE * x2, BIO * x3, BIO * x4, int x5)
{
  return PKCS7_verify(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PKCS7_verify(PyObject *self, PyObject *args)
{
  PKCS7 * x0;
  Cryptography_STACK_OF_X509 * x1;
  X509_STORE * x2;
  BIO * x3;
  BIO * x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "PKCS7_verify", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(656), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (PKCS7 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(656), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PKCS7_verify(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PKCS7_verify _cffi_d_PKCS7_verify
#endif

static void _cffi_d_RAND_add(void const * x0, int x1, double x2)
{
  RAND_add(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RAND_add(PyObject *self, PyObject *args)
{
  void const * x0;
  int x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "RAND_add", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RAND_add(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_RAND_add _cffi_d_RAND_add
#endif

static int _cffi_d_RAND_bytes(unsigned char * x0, int x1)
{
  return RAND_bytes(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RAND_bytes(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "RAND_bytes", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_bytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RAND_bytes _cffi_d_RAND_bytes
#endif

static int _cffi_d_RAND_status(void)
{
  return RAND_status();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RAND_status(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAND_status(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_RAND_status _cffi_d_RAND_status
#endif

static int _cffi_d_RSA_check_key(RSA const * x0)
{
  return RSA_check_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RSA_check_key(PyObject *self, PyObject *arg0)
{
  RSA const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(460), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(460), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_check_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RSA_check_key _cffi_d_RSA_check_key
#endif

static void _cffi_d_RSA_free(RSA * x0)
{
  RSA_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RSA_free(PyObject *self, PyObject *arg0)
{
  RSA * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(615), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (RSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(615), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { RSA_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_RSA_free _cffi_d_RSA_free
#endif

static int _cffi_d_RSA_generate_key_ex(RSA * x0, int x1, BIGNUM * x2, BN_GENCB * x3)
{
  return RSA_generate_key_ex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RSA_generate_key_ex(PyObject *self, PyObject *args)
{
  RSA * x0;
  int x1;
  BIGNUM * x2;
  BN_GENCB * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "RSA_generate_key_ex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(615), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (RSA *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(615), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (BIGNUM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(422), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (BN_GENCB *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(422), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_generate_key_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RSA_generate_key_ex _cffi_d_RSA_generate_key_ex
#endif

static RSA * _cffi_d_RSA_new(void)
{
  return RSA_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RSA_new(PyObject *self, PyObject *noarg)
{
  RSA * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(615));
  return pyresult;
}
#else
#  define _cffi_f_RSA_new _cffi_d_RSA_new
#endif

static int _cffi_d_RSA_print(BIO * x0, RSA const * x1, int x2)
{
  return RSA_print(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RSA_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  RSA const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "RSA_print", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(460), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (RSA const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(460), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RSA_print(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RSA_print _cffi_d_RSA_print
#endif

static PKCS7 * _cffi_d_SMIME_read_PKCS7(BIO * x0, BIO * * x1)
{
  return SMIME_read_PKCS7(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SMIME_read_PKCS7(PyObject *self, PyObject *args)
{
  BIO * x0;
  BIO * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PKCS7 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SMIME_read_PKCS7", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(169), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (BIO * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(169), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SMIME_read_PKCS7(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(656));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SMIME_read_PKCS7 _cffi_d_SMIME_read_PKCS7
#endif

static SSL_CIPHER const * _cffi_d_SSL_CIPHER_find(SSL * x0, unsigned char const * x1)
{
  return SSL_CIPHER_find(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CIPHER_find(PyObject *self, PyObject *args)
{
  SSL * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_CIPHER const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CIPHER_find", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CIPHER_find(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(370));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CIPHER_find _cffi_d_SSL_CIPHER_find
#endif

static int _cffi_d_SSL_CIPHER_get_bits(SSL_CIPHER const * x0, int * x1)
{
  return SSL_CIPHER_get_bits(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CIPHER_get_bits(PyObject *self, PyObject *args)
{
  SSL_CIPHER const * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CIPHER_get_bits", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CIPHER_get_bits(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CIPHER_get_bits _cffi_d_SSL_CIPHER_get_bits
#endif

static char const * _cffi_d_SSL_CIPHER_get_name(SSL_CIPHER const * x0)
{
  return SSL_CIPHER_get_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CIPHER_get_name(PyObject *self, PyObject *arg0)
{
  SSL_CIPHER const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CIPHER_get_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CIPHER_get_name _cffi_d_SSL_CIPHER_get_name
#endif

static char const * _cffi_d_SSL_CIPHER_get_version(SSL_CIPHER const * x0)
{
  return SSL_CIPHER_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CIPHER_get_version(PyObject *self, PyObject *arg0)
{
  SSL_CIPHER const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CIPHER_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CIPHER_get_version _cffi_d_SSL_CIPHER_get_version
#endif

static int _cffi_d_SSL_CTX_add_client_CA(SSL_CTX * x0, X509 * x1)
{
  return SSL_CTX_add_client_CA(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_add_client_CA(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_add_client_CA", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_add_client_CA(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_add_client_CA _cffi_d_SSL_CTX_add_client_CA
#endif

static int _cffi_d_SSL_CTX_add_client_custom_ext(SSL_CTX * x0, unsigned int x1, int(* x2)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *), void(* x3)(SSL *, unsigned int, unsigned char const *, void *), void * x4, int(* x5)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *), void * x6)
{
  return SSL_CTX_add_client_custom_ext(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_add_client_custom_ext(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned int x1;
  int(* x2)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *);
  void(* x3)(SSL *, unsigned int, unsigned char const *, void *);
  void * x4;
  int(* x5)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *);
  void * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_add_client_custom_ext", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *))_cffi_to_c_pointer(arg2, _cffi_type(839));
  if (x2 == (int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *))NULL && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(SSL *, unsigned int, unsigned char const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(840));
  if (x3 == (void(*)(SSL *, unsigned int, unsigned char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *))_cffi_to_c_pointer(arg5, _cffi_type(842));
  if (x5 == (int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_add_client_custom_ext(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_add_client_custom_ext _cffi_d_SSL_CTX_add_client_custom_ext
#endif

static long _cffi_d_SSL_CTX_add_extra_chain_cert(SSL_CTX * x0, X509 * x1)
{
  return SSL_CTX_add_extra_chain_cert(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_add_extra_chain_cert(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_add_extra_chain_cert", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_add_extra_chain_cert(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_add_extra_chain_cert _cffi_d_SSL_CTX_add_extra_chain_cert
#endif

static int _cffi_d_SSL_CTX_add_server_custom_ext(SSL_CTX * x0, unsigned int x1, int(* x2)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *), void(* x3)(SSL *, unsigned int, unsigned char const *, void *), void * x4, int(* x5)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *), void * x6)
{
  return SSL_CTX_add_server_custom_ext(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_add_server_custom_ext(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned int x1;
  int(* x2)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *);
  void(* x3)(SSL *, unsigned int, unsigned char const *, void *);
  void * x4;
  int(* x5)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *);
  void * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_add_server_custom_ext", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *))_cffi_to_c_pointer(arg2, _cffi_type(839));
  if (x2 == (int(*)(SSL *, unsigned int, unsigned char const * *, size_t *, int *, void *))NULL && PyErr_Occurred())
    return NULL;

  x3 = (void(*)(SSL *, unsigned int, unsigned char const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(840));
  if (x3 == (void(*)(SSL *, unsigned int, unsigned char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = (int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *))_cffi_to_c_pointer(arg5, _cffi_type(842));
  if (x5 == (int(*)(SSL *, unsigned int, unsigned char const *, size_t, int *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_add_server_custom_ext(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_add_server_custom_ext _cffi_d_SSL_CTX_add_server_custom_ext
#endif

static int _cffi_d_SSL_CTX_check_private_key(SSL_CTX const * x0)
{
  return SSL_CTX_check_private_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_check_private_key(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(334), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(334), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_check_private_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_check_private_key _cffi_d_SSL_CTX_check_private_key
#endif

static long _cffi_d_SSL_CTX_clear_mode(SSL_CTX * x0, long x1)
{
  return SSL_CTX_clear_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_clear_mode(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_clear_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_clear_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_clear_mode _cffi_d_SSL_CTX_clear_mode
#endif

static void _cffi_d_SSL_CTX_free(SSL_CTX * x0)
{
  SSL_CTX_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_free(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_free _cffi_d_SSL_CTX_free
#endif

static X509_VERIFY_PARAM * _cffi_d_SSL_CTX_get0_param(SSL_CTX * x0)
{
  return SSL_CTX_get0_param(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get0_param(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_VERIFY_PARAM * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get0_param(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1016));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get0_param _cffi_d_SSL_CTX_get0_param
#endif

static X509_STORE * _cffi_d_SSL_CTX_get_cert_store(SSL_CTX const * x0)
{
  return SSL_CTX_get_cert_store(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_cert_store(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_STORE * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(334), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(334), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_cert_store(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(78));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_cert_store _cffi_d_SSL_CTX_get_cert_store
#endif

static void(* _cffi_d_SSL_CTX_get_keylog_callback(SSL_CTX * x0))(SSL const *, char const *)
{
  return SSL_CTX_get_keylog_callback(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_keylog_callback(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void(* result)(SSL const *, char const *);
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_keylog_callback(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1423));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_keylog_callback _cffi_d_SSL_CTX_get_keylog_callback
#endif

static uint64_t _cffi_d_SSL_CTX_get_options(SSL_CTX * x0)
{
  return SSL_CTX_get_options(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_options(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_options(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_options _cffi_d_SSL_CTX_get_options
#endif

static long _cffi_d_SSL_CTX_get_session_cache_mode(SSL_CTX * x0)
{
  return SSL_CTX_get_session_cache_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_session_cache_mode(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_session_cache_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_session_cache_mode _cffi_d_SSL_CTX_get_session_cache_mode
#endif

static long _cffi_d_SSL_CTX_get_timeout(SSL_CTX const * x0)
{
  return SSL_CTX_get_timeout(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_timeout(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(334), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(334), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_timeout(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_timeout _cffi_d_SSL_CTX_get_timeout
#endif

static int _cffi_d_SSL_CTX_get_verify_depth(SSL_CTX const * x0)
{
  return SSL_CTX_get_verify_depth(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_verify_depth(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(334), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(334), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_verify_depth(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_verify_depth _cffi_d_SSL_CTX_get_verify_depth
#endif

static int _cffi_d_SSL_CTX_get_verify_mode(SSL_CTX const * x0)
{
  return SSL_CTX_get_verify_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_get_verify_mode(PyObject *self, PyObject *arg0)
{
  SSL_CTX const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(334), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(334), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_get_verify_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_get_verify_mode _cffi_d_SSL_CTX_get_verify_mode
#endif

static int _cffi_d_SSL_CTX_load_verify_locations(SSL_CTX * x0, char const * x1, char const * x2)
{
  return SSL_CTX_load_verify_locations(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_load_verify_locations(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_load_verify_locations", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_load_verify_locations(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_load_verify_locations _cffi_d_SSL_CTX_load_verify_locations
#endif

static SSL_CTX * _cffi_d_SSL_CTX_new(SSL_METHOD * x0)
{
  return SSL_CTX_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_new(PyObject *self, PyObject *arg0)
{
  SSL_METHOD * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_CTX * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(204), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_METHOD *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(204), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_new _cffi_d_SSL_CTX_new
#endif

static long _cffi_d_SSL_CTX_set1_sigalgs_list(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_set1_sigalgs_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set1_sigalgs_list(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set1_sigalgs_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set1_sigalgs_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set1_sigalgs_list _cffi_d_SSL_CTX_set1_sigalgs_list
#endif

static int _cffi_d_SSL_CTX_set_alpn_protos(SSL_CTX * x0, unsigned char const * x1, unsigned int x2)
{
  return SSL_CTX_set_alpn_protos(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_alpn_protos(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned char const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_alpn_protos", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_alpn_protos(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_alpn_protos _cffi_d_SSL_CTX_set_alpn_protos
#endif

static void _cffi_d_SSL_CTX_set_alpn_select_cb(SSL_CTX * x0, int(* x1)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *), void * x2)
{
  SSL_CTX_set_alpn_select_cb(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_alpn_select_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_alpn_select_cb", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *))_cffi_to_c_pointer(arg1, _cffi_type(1380));
  if (x1 == (int(*)(SSL *, unsigned char const * *, unsigned char *, unsigned char const *, unsigned int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_alpn_select_cb(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_alpn_select_cb _cffi_d_SSL_CTX_set_alpn_select_cb
#endif

static void _cffi_d_SSL_CTX_set_cert_cb(SSL_CTX * x0, int(* x1)(SSL *, void *), void * x2)
{
  SSL_CTX_set_cert_cb(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_cert_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_cert_cb", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1139));
  if (x1 == (int(*)(SSL *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_cert_cb(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_cert_cb _cffi_d_SSL_CTX_set_cert_cb
#endif

static void _cffi_d_SSL_CTX_set_cert_store(SSL_CTX * x0, X509_STORE * x1)
{
  SSL_CTX_set_cert_store(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_cert_store(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  X509_STORE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_cert_store", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_cert_store(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_cert_store _cffi_d_SSL_CTX_set_cert_store
#endif

static int _cffi_d_SSL_CTX_set_cipher_list(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_set_cipher_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_cipher_list(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_cipher_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_cipher_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_cipher_list _cffi_d_SSL_CTX_set_cipher_list
#endif

static int _cffi_d_SSL_CTX_set_ciphersuites(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_set_ciphersuites(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_ciphersuites(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_ciphersuites", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_ciphersuites(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_ciphersuites _cffi_d_SSL_CTX_set_ciphersuites
#endif

static void _cffi_d_SSL_CTX_set_client_CA_list(SSL_CTX * x0, Cryptography_STACK_OF_X509_NAME * x1)
{
  SSL_CTX_set_client_CA_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_client_CA_list(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  Cryptography_STACK_OF_X509_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_client_CA_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_client_CA_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_client_CA_list _cffi_d_SSL_CTX_set_client_CA_list
#endif

static int _cffi_d_SSL_CTX_set_client_cert_engine(SSL_CTX * x0, ENGINE * x1)
{
  return SSL_CTX_set_client_cert_engine(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_client_cert_engine(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  ENGINE * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_client_cert_engine", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ENGINE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_client_cert_engine(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_client_cert_engine _cffi_d_SSL_CTX_set_client_cert_engine
#endif

static void _cffi_d_SSL_CTX_set_cookie_generate_cb(SSL_CTX * x0, int(* x1)(SSL *, unsigned char *, unsigned int *))
{
  SSL_CTX_set_cookie_generate_cb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_cookie_generate_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, unsigned char *, unsigned int *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_cookie_generate_cb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, unsigned char *, unsigned int *))_cffi_to_c_pointer(arg1, _cffi_type(1376));
  if (x1 == (int(*)(SSL *, unsigned char *, unsigned int *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_cookie_generate_cb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_cookie_generate_cb _cffi_d_SSL_CTX_set_cookie_generate_cb
#endif

static void _cffi_d_SSL_CTX_set_cookie_verify_cb(SSL_CTX * x0, int(* x1)(SSL *, unsigned char const *, unsigned int))
{
  SSL_CTX_set_cookie_verify_cb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_cookie_verify_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, unsigned char const *, unsigned int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_cookie_verify_cb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, unsigned char const *, unsigned int))_cffi_to_c_pointer(arg1, _cffi_type(1389));
  if (x1 == (int(*)(SSL *, unsigned char const *, unsigned int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_cookie_verify_cb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_cookie_verify_cb _cffi_d_SSL_CTX_set_cookie_verify_cb
#endif

static void _cffi_d_SSL_CTX_set_default_passwd_cb(SSL_CTX * x0, int(* x1)(char *, int, int, void *))
{
  SSL_CTX_set_default_passwd_cb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_default_passwd_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(char *, int, int, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_default_passwd_cb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(char *, int, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(86));
  if (x1 == (int(*)(char *, int, int, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_default_passwd_cb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_default_passwd_cb _cffi_d_SSL_CTX_set_default_passwd_cb
#endif

static int _cffi_d_SSL_CTX_set_default_verify_paths(SSL_CTX * x0)
{
  return SSL_CTX_set_default_verify_paths(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_default_verify_paths(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_default_verify_paths(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_default_verify_paths _cffi_d_SSL_CTX_set_default_verify_paths
#endif

static void _cffi_d_SSL_CTX_set_info_callback(SSL_CTX * x0, void(* x1)(SSL const *, int, int))
{
  SSL_CTX_set_info_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_info_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  void(* x1)(SSL const *, int, int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_info_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(SSL const *, int, int))_cffi_to_c_pointer(arg1, _cffi_type(1427));
  if (x1 == (void(*)(SSL const *, int, int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_info_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_info_callback _cffi_d_SSL_CTX_set_info_callback
#endif

static void _cffi_d_SSL_CTX_set_keylog_callback(SSL_CTX * x0, void(* x1)(SSL const *, char const *))
{
  SSL_CTX_set_keylog_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_keylog_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  void(* x1)(SSL const *, char const *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_keylog_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(SSL const *, char const *))_cffi_to_c_pointer(arg1, _cffi_type(1423));
  if (x1 == (void(*)(SSL const *, char const *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_keylog_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_keylog_callback _cffi_d_SSL_CTX_set_keylog_callback
#endif

static int _cffi_d_SSL_CTX_set_max_early_data(SSL_CTX * x0, uint32_t x1)
{
  return SSL_CTX_set_max_early_data(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_max_early_data(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_max_early_data", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_max_early_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_max_early_data _cffi_d_SSL_CTX_set_max_early_data
#endif

static long _cffi_d_SSL_CTX_set_max_proto_version(SSL_CTX * x0, int x1)
{
  return SSL_CTX_set_max_proto_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_max_proto_version(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_max_proto_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_max_proto_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_max_proto_version _cffi_d_SSL_CTX_set_max_proto_version
#endif

static long _cffi_d_SSL_CTX_set_min_proto_version(SSL_CTX * x0, int x1)
{
  return SSL_CTX_set_min_proto_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_min_proto_version(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_min_proto_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_min_proto_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_min_proto_version _cffi_d_SSL_CTX_set_min_proto_version
#endif

static long _cffi_d_SSL_CTX_set_mode(SSL_CTX * x0, long x1)
{
  return SSL_CTX_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_mode(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_mode _cffi_d_SSL_CTX_set_mode
#endif

static void _cffi_d_SSL_CTX_set_msg_callback(SSL_CTX * x0, void(* x1)(int, int, int, void const *, size_t, SSL *, void *))
{
  SSL_CTX_set_msg_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_msg_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  void(* x1)(int, int, int, void const *, size_t, SSL *, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_msg_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(int, int, int, void const *, size_t, SSL *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1431));
  if (x1 == (void(*)(int, int, int, void const *, size_t, SSL *, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_msg_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_msg_callback _cffi_d_SSL_CTX_set_msg_callback
#endif

static void _cffi_d_SSL_CTX_set_msg_callback_arg(SSL_CTX * x0, void * x1)
{
  SSL_CTX_set_msg_callback_arg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_msg_callback_arg(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_msg_callback_arg", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_msg_callback_arg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_msg_callback_arg _cffi_d_SSL_CTX_set_msg_callback_arg
#endif

static uint64_t _cffi_d_SSL_CTX_set_options(SSL_CTX * x0, uint64_t x1)
{
  return SSL_CTX_set_options(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_options(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_options", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_options(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_options _cffi_d_SSL_CTX_set_options
#endif

static void _cffi_d_SSL_CTX_set_post_handshake_auth(SSL_CTX * x0, int x1)
{
  SSL_CTX_set_post_handshake_auth(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_post_handshake_auth(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_post_handshake_auth", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_post_handshake_auth(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_post_handshake_auth _cffi_d_SSL_CTX_set_post_handshake_auth
#endif

static void _cffi_d_SSL_CTX_set_psk_client_callback(SSL_CTX * x0, unsigned int(* x1)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int))
{
  SSL_CTX_set_psk_client_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_psk_client_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned int(* x1)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_psk_client_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (unsigned int(*)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int))_cffi_to_c_pointer(arg1, _cffi_type(1411));
  if (x1 == (unsigned int(*)(SSL *, char const *, char *, unsigned int, unsigned char *, unsigned int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_psk_client_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_psk_client_callback _cffi_d_SSL_CTX_set_psk_client_callback
#endif

static void _cffi_d_SSL_CTX_set_psk_find_session_callback(SSL_CTX * x0, int(* x1)(SSL *, unsigned char const *, size_t, SSL_SESSION * *))
{
  SSL_CTX_set_psk_find_session_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_psk_find_session_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, unsigned char const *, size_t, SSL_SESSION * *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_psk_find_session_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, unsigned char const *, size_t, SSL_SESSION * *))_cffi_to_c_pointer(arg1, _cffi_type(1385));
  if (x1 == (int(*)(SSL *, unsigned char const *, size_t, SSL_SESSION * *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_psk_find_session_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_psk_find_session_callback _cffi_d_SSL_CTX_set_psk_find_session_callback
#endif

static void _cffi_d_SSL_CTX_set_psk_server_callback(SSL_CTX * x0, unsigned int(* x1)(SSL *, char const *, unsigned char *, unsigned int))
{
  SSL_CTX_set_psk_server_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_psk_server_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned int(* x1)(SSL *, char const *, unsigned char *, unsigned int);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_psk_server_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (unsigned int(*)(SSL *, char const *, unsigned char *, unsigned int))_cffi_to_c_pointer(arg1, _cffi_type(1415));
  if (x1 == (unsigned int(*)(SSL *, char const *, unsigned char *, unsigned int))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_psk_server_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_psk_server_callback _cffi_d_SSL_CTX_set_psk_server_callback
#endif

static void _cffi_d_SSL_CTX_set_psk_use_session_callback(SSL_CTX * x0, int(* x1)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *))
{
  SSL_CTX_set_psk_use_session_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_psk_use_session_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_psk_use_session_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *))_cffi_to_c_pointer(arg1, _cffi_type(1368));
  if (x1 == (int(*)(SSL *, EVP_MD const *, unsigned char const * *, size_t *, SSL_SESSION * *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_psk_use_session_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_psk_use_session_callback _cffi_d_SSL_CTX_set_psk_use_session_callback
#endif

static long _cffi_d_SSL_CTX_set_session_cache_mode(SSL_CTX * x0, long x1)
{
  return SSL_CTX_set_session_cache_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_session_cache_mode(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_session_cache_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_session_cache_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_session_cache_mode _cffi_d_SSL_CTX_set_session_cache_mode
#endif

static int _cffi_d_SSL_CTX_set_session_id_context(SSL_CTX * x0, unsigned char const * x1, unsigned int x2)
{
  return SSL_CTX_set_session_id_context(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_session_id_context(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  unsigned char const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_session_id_context", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_session_id_context(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_session_id_context _cffi_d_SSL_CTX_set_session_id_context
#endif

static long _cffi_d_SSL_CTX_set_timeout(SSL_CTX * x0, long x1)
{
  return SSL_CTX_set_timeout(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_timeout(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_timeout", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_timeout(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_timeout _cffi_d_SSL_CTX_set_timeout
#endif

static void _cffi_d_SSL_CTX_set_tlsext_servername_callback(SSL_CTX * x0, int(* x1)(SSL *, int *, void *))
{
  SSL_CTX_set_tlsext_servername_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tlsext_servername_callback(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, int *, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tlsext_servername_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, int *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1372));
  if (x1 == (int(*)(SSL *, int *, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_tlsext_servername_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_tlsext_servername_callback _cffi_d_SSL_CTX_set_tlsext_servername_callback
#endif

static long _cffi_d_SSL_CTX_set_tlsext_status_arg(SSL_CTX * x0, void * x1)
{
  return SSL_CTX_set_tlsext_status_arg(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tlsext_status_arg(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tlsext_status_arg", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_tlsext_status_arg(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_tlsext_status_arg _cffi_d_SSL_CTX_set_tlsext_status_arg
#endif

static long _cffi_d_SSL_CTX_set_tlsext_status_cb(SSL_CTX * x0, int(* x1)(SSL *, void *))
{
  return SSL_CTX_set_tlsext_status_cb(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tlsext_status_cb(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int(* x1)(SSL *, void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tlsext_status_cb", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1139));
  if (x1 == (int(*)(SSL *, void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_tlsext_status_cb(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_tlsext_status_cb _cffi_d_SSL_CTX_set_tlsext_status_cb
#endif

static int _cffi_d_SSL_CTX_set_tlsext_use_srtp(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_set_tlsext_use_srtp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tlsext_use_srtp(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tlsext_use_srtp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_tlsext_use_srtp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_tlsext_use_srtp _cffi_d_SSL_CTX_set_tlsext_use_srtp
#endif

static long _cffi_d_SSL_CTX_set_tmp_dh(SSL_CTX * x0, DH * x1)
{
  return SSL_CTX_set_tmp_dh(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tmp_dh(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  DH * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tmp_dh", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1123), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (DH *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1123), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_tmp_dh(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_tmp_dh _cffi_d_SSL_CTX_set_tmp_dh
#endif

static long _cffi_d_SSL_CTX_set_tmp_ecdh(SSL_CTX * x0, EC_KEY * x1)
{
  return SSL_CTX_set_tmp_ecdh(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_tmp_ecdh(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  EC_KEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_tmp_ecdh", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1127), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EC_KEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1127), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_set_tmp_ecdh(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_set_tmp_ecdh _cffi_d_SSL_CTX_set_tmp_ecdh
#endif

static void _cffi_d_SSL_CTX_set_verify(SSL_CTX * x0, int x1, int(* x2)(int, X509_STORE_CTX *))
{
  SSL_CTX_set_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_verify(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int x1;
  int(* x2)(int, X509_STORE_CTX *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(int, X509_STORE_CTX *))_cffi_to_c_pointer(arg2, _cffi_type(1333));
  if (x2 == (int(*)(int, X509_STORE_CTX *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_verify _cffi_d_SSL_CTX_set_verify
#endif

static void _cffi_d_SSL_CTX_set_verify_depth(SSL_CTX * x0, int x1)
{
  SSL_CTX_set_verify_depth(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_set_verify_depth(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_set_verify_depth", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_CTX_set_verify_depth(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_CTX_set_verify_depth _cffi_d_SSL_CTX_set_verify_depth
#endif

static int _cffi_d_SSL_CTX_use_PrivateKey(SSL_CTX * x0, EVP_PKEY * x1)
{
  return SSL_CTX_use_PrivateKey(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_PrivateKey(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_PrivateKey", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_PrivateKey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_PrivateKey _cffi_d_SSL_CTX_use_PrivateKey
#endif

static int _cffi_d_SSL_CTX_use_PrivateKey_file(SSL_CTX * x0, char const * x1, int x2)
{
  return SSL_CTX_use_PrivateKey_file(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_PrivateKey_file(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_PrivateKey_file", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_PrivateKey_file(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_PrivateKey_file _cffi_d_SSL_CTX_use_PrivateKey_file
#endif

static int _cffi_d_SSL_CTX_use_certificate(SSL_CTX * x0, X509 * x1)
{
  return SSL_CTX_use_certificate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_certificate(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_certificate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_certificate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_certificate _cffi_d_SSL_CTX_use_certificate
#endif

static int _cffi_d_SSL_CTX_use_certificate_chain_file(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_use_certificate_chain_file(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_certificate_chain_file(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_certificate_chain_file", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_certificate_chain_file(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_certificate_chain_file _cffi_d_SSL_CTX_use_certificate_chain_file
#endif

static int _cffi_d_SSL_CTX_use_certificate_file(SSL_CTX * x0, char const * x1, int x2)
{
  return SSL_CTX_use_certificate_file(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_certificate_file(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_certificate_file", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_certificate_file(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_certificate_file _cffi_d_SSL_CTX_use_certificate_file
#endif

static int _cffi_d_SSL_CTX_use_psk_identity_hint(SSL_CTX * x0, char const * x1)
{
  return SSL_CTX_use_psk_identity_hint(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_CTX_use_psk_identity_hint(PyObject *self, PyObject *args)
{
  SSL_CTX * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_CTX_use_psk_identity_hint", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_CTX_use_psk_identity_hint(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_CTX_use_psk_identity_hint _cffi_d_SSL_CTX_use_psk_identity_hint
#endif

static void _cffi_d_SSL_SESSION_free(SSL_SESSION * x0)
{
  SSL_SESSION_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_free(PyObject *self, PyObject *arg0)
{
  SSL_SESSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_SESSION_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_SESSION_free _cffi_d_SSL_SESSION_free
#endif

static size_t _cffi_d_SSL_SESSION_get_master_key(SSL_SESSION const * x0, unsigned char * x1, size_t x2)
{
  return SSL_SESSION_get_master_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_get_master_key(PyObject *self, PyObject *args)
{
  SSL_SESSION const * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_SESSION_get_master_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1180), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1180), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_SESSION_get_master_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_SESSION_get_master_key _cffi_d_SSL_SESSION_get_master_key
#endif

static uint32_t _cffi_d_SSL_SESSION_get_max_early_data(SSL_SESSION const * x0)
{
  return SSL_SESSION_get_max_early_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_get_max_early_data(PyObject *self, PyObject *arg0)
{
  SSL_SESSION const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1180), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1180), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_SESSION_get_max_early_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_SESSION_get_max_early_data _cffi_d_SSL_SESSION_get_max_early_data
#endif

static int _cffi_d_SSL_SESSION_set1_master_key(SSL_SESSION * x0, unsigned char const * x1, size_t x2)
{
  return SSL_SESSION_set1_master_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_set1_master_key(PyObject *self, PyObject *args)
{
  SSL_SESSION * x0;
  unsigned char const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_SESSION_set1_master_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_SESSION_set1_master_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_SESSION_set1_master_key _cffi_d_SSL_SESSION_set1_master_key
#endif

static int _cffi_d_SSL_SESSION_set_cipher(SSL_SESSION * x0, SSL_CIPHER const * x1)
{
  return SSL_SESSION_set_cipher(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_set_cipher(PyObject *self, PyObject *args)
{
  SSL_SESSION * x0;
  SSL_CIPHER const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_SESSION_set_cipher", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (SSL_CIPHER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_SESSION_set_cipher(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_SESSION_set_cipher _cffi_d_SSL_SESSION_set_cipher
#endif

static int _cffi_d_SSL_SESSION_set_protocol_version(SSL_SESSION * x0, int x1)
{
  return SSL_SESSION_set_protocol_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_SESSION_set_protocol_version(PyObject *self, PyObject *args)
{
  SSL_SESSION * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_SESSION_set_protocol_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_SESSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_SESSION_set_protocol_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_SESSION_set_protocol_version _cffi_d_SSL_SESSION_set_protocol_version
#endif

static long _cffi_d_SSL_clear_mode(SSL * x0, long x1)
{
  return SSL_clear_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_clear_mode(PyObject *self, PyObject *args)
{
  SSL * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_clear_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_clear_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_clear_mode _cffi_d_SSL_clear_mode
#endif

static int _cffi_d_SSL_do_handshake(SSL * x0)
{
  return SSL_do_handshake(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_do_handshake(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_do_handshake(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_do_handshake _cffi_d_SSL_do_handshake
#endif

static int _cffi_d_SSL_export_keying_material(SSL * x0, unsigned char * x1, size_t x2, char const * x3, size_t x4, unsigned char const * x5, size_t x6, int x7)
{
  return SSL_export_keying_material(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_export_keying_material(PyObject *self, PyObject *args)
{
  SSL * x0;
  unsigned char * x1;
  size_t x2;
  char const * x3;
  size_t x4;
  unsigned char const * x5;
  size_t x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "SSL_export_keying_material", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_export_keying_material(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_export_keying_material _cffi_d_SSL_export_keying_material
#endif

static int _cffi_d_SSL_extension_supported(unsigned int x0)
{
  return SSL_extension_supported(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_extension_supported(PyObject *self, PyObject *arg0)
{
  unsigned int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_extension_supported(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_SSL_extension_supported _cffi_d_SSL_extension_supported
#endif

static void _cffi_d_SSL_free(SSL * x0)
{
  SSL_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_free(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_free _cffi_d_SSL_free
#endif

static void _cffi_d_SSL_get0_alpn_selected(SSL const * x0, unsigned char const * * x1, unsigned int * x2)
{
  SSL_get0_alpn_selected(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get0_alpn_selected(PyObject *self, PyObject *args)
{
  SSL const * x0;
  unsigned char const * * x1;
  unsigned int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_get0_alpn_selected", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(682), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(682), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(592), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(592), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_get0_alpn_selected(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_get0_alpn_selected _cffi_d_SSL_get0_alpn_selected
#endif

static X509_VERIFY_PARAM * _cffi_d_SSL_get0_param(SSL * x0)
{
  return SSL_get0_param(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get0_param(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_VERIFY_PARAM * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get0_param(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1016));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get0_param _cffi_d_SSL_get0_param
#endif

static Cryptography_STACK_OF_X509 * _cffi_d_SSL_get0_verified_chain(SSL const * x0)
{
  return SSL_get0_verified_chain(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get0_verified_chain(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get0_verified_chain(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(160));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get0_verified_chain _cffi_d_SSL_get0_verified_chain
#endif

static SSL_SESSION * _cffi_d_SSL_get1_session(SSL * x0)
{
  return SSL_get1_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get1_session(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_SESSION * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get1_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(692));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get1_session _cffi_d_SSL_get1_session
#endif

static X509 * _cffi_d_SSL_get_certificate(SSL const * x0)
{
  return SSL_get_certificate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_certificate(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_certificate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_certificate _cffi_d_SSL_get_certificate
#endif

static char const * _cffi_d_SSL_get_cipher_list(SSL const * x0, int x1)
{
  return SSL_get_cipher_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_cipher_list(PyObject *self, PyObject *args)
{
  SSL const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_get_cipher_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_cipher_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_cipher_list _cffi_d_SSL_get_cipher_list
#endif

static Cryptography_STACK_OF_X509_NAME * _cffi_d_SSL_get_client_CA_list(SSL const * x0)
{
  return SSL_get_client_CA_list(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_client_CA_list(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_client_CA_list(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(287));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_client_CA_list _cffi_d_SSL_get_client_CA_list
#endif

static size_t _cffi_d_SSL_get_client_random(SSL const * x0, unsigned char * x1, size_t x2)
{
  return SSL_get_client_random(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_client_random(PyObject *self, PyObject *args)
{
  SSL const * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_get_client_random", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_client_random(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_client_random _cffi_d_SSL_get_client_random
#endif

static SSL_CIPHER const * _cffi_d_SSL_get_current_cipher(SSL const * x0)
{
  return SSL_get_current_cipher(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_current_cipher(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_CIPHER const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_current_cipher(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(370));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_current_cipher _cffi_d_SSL_get_current_cipher
#endif

static int _cffi_d_SSL_get_error(SSL const * x0, int x1)
{
  return SSL_get_error(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_error(PyObject *self, PyObject *args)
{
  SSL const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_get_error", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_error(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_error _cffi_d_SSL_get_error
#endif

static int _cffi_d_SSL_get_ex_data_X509_STORE_CTX_idx(void)
{
  return SSL_get_ex_data_X509_STORE_CTX_idx();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_ex_data_X509_STORE_CTX_idx(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_ex_data_X509_STORE_CTX_idx(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_ex_data_X509_STORE_CTX_idx _cffi_d_SSL_get_ex_data_X509_STORE_CTX_idx
#endif

static long _cffi_d_SSL_get_extms_support(SSL * x0)
{
  return SSL_get_extms_support(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_extms_support(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_extms_support(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_extms_support _cffi_d_SSL_get_extms_support
#endif

static size_t _cffi_d_SSL_get_finished(SSL const * x0, void * x1, size_t x2)
{
  return SSL_get_finished(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_finished(PyObject *self, PyObject *args)
{
  SSL const * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_get_finished", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_finished(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_finished _cffi_d_SSL_get_finished
#endif

static uint64_t _cffi_d_SSL_get_options(SSL * x0)
{
  return SSL_get_options(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_options(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_options(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_options _cffi_d_SSL_get_options
#endif

static Cryptography_STACK_OF_X509 * _cffi_d_SSL_get_peer_cert_chain(SSL const * x0)
{
  return SSL_get_peer_cert_chain(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_peer_cert_chain(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_peer_cert_chain(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(160));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_peer_cert_chain _cffi_d_SSL_get_peer_cert_chain
#endif

static X509 * _cffi_d_SSL_get_peer_certificate(SSL const * x0)
{
  return SSL_get_peer_certificate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_peer_certificate(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_peer_certificate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_peer_certificate _cffi_d_SSL_get_peer_certificate
#endif

static size_t _cffi_d_SSL_get_peer_finished(SSL const * x0, void * x1, size_t x2)
{
  return SSL_get_peer_finished(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_peer_finished(PyObject *self, PyObject *args)
{
  SSL const * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_get_peer_finished", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_peer_finished(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_peer_finished _cffi_d_SSL_get_peer_finished
#endif

static SRTP_PROTECTION_PROFILE * _cffi_d_SSL_get_selected_srtp_profile(SSL * x0)
{
  return SSL_get_selected_srtp_profile(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_selected_srtp_profile(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SRTP_PROTECTION_PROFILE * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_selected_srtp_profile(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1583));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_selected_srtp_profile _cffi_d_SSL_get_selected_srtp_profile
#endif

static size_t _cffi_d_SSL_get_server_random(SSL const * x0, unsigned char * x1, size_t x2)
{
  return SSL_get_server_random(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_server_random(PyObject *self, PyObject *args)
{
  SSL const * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_get_server_random", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_server_random(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_server_random _cffi_d_SSL_get_server_random
#endif

static char const * _cffi_d_SSL_get_servername(SSL const * x0, int x1)
{
  return SSL_get_servername(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_servername(PyObject *self, PyObject *args)
{
  SSL const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_get_servername", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_servername(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_servername _cffi_d_SSL_get_servername
#endif

static SSL_SESSION * _cffi_d_SSL_get_session(SSL const * x0)
{
  return SSL_get_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_session(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_SESSION * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(692));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_session _cffi_d_SSL_get_session
#endif

static int _cffi_d_SSL_get_shutdown(SSL const * x0)
{
  return SSL_get_shutdown(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_shutdown(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_shutdown(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_shutdown _cffi_d_SSL_get_shutdown
#endif

static long _cffi_d_SSL_get_tlsext_status_ocsp_resp(SSL * x0, unsigned char const * * x1)
{
  return SSL_get_tlsext_status_ocsp_resp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_tlsext_status_ocsp_resp(PyObject *self, PyObject *args)
{
  SSL * x0;
  unsigned char const * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_get_tlsext_status_ocsp_resp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(682), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(682), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_tlsext_status_ocsp_resp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_tlsext_status_ocsp_resp _cffi_d_SSL_get_tlsext_status_ocsp_resp
#endif

static int _cffi_d_SSL_get_verify_mode(SSL const * x0)
{
  return SSL_get_verify_mode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_verify_mode(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_verify_mode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_verify_mode _cffi_d_SSL_get_verify_mode
#endif

static long _cffi_d_SSL_get_verify_result(SSL const * x0)
{
  return SSL_get_verify_result(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_verify_result(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_verify_result(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_verify_result _cffi_d_SSL_get_verify_result
#endif

static char const * _cffi_d_SSL_get_version(SSL const * x0)
{
  return SSL_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_get_version(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_get_version _cffi_d_SSL_get_version
#endif

static Cryptography_STACK_OF_X509_NAME * _cffi_d_SSL_load_client_CA_file(char const * x0)
{
  return SSL_load_client_CA_file(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_load_client_CA_file(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_load_client_CA_file(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(287));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_load_client_CA_file _cffi_d_SSL_load_client_CA_file
#endif

static SSL * _cffi_d_SSL_new(SSL_CTX * x0)
{
  return SSL_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_new(PyObject *self, PyObject *arg0)
{
  SSL_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(187));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_new _cffi_d_SSL_new
#endif

static int _cffi_d_SSL_peek(SSL * x0, void * x1, int x2)
{
  return SSL_peek(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_peek(PyObject *self, PyObject *args)
{
  SSL * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_peek", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_peek(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_peek _cffi_d_SSL_peek
#endif

static int _cffi_d_SSL_pending(SSL const * x0)
{
  return SSL_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_pending(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_pending _cffi_d_SSL_pending
#endif

static int _cffi_d_SSL_read(SSL * x0, void * x1, int x2)
{
  return SSL_read(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_read(PyObject *self, PyObject *args)
{
  SSL * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_read", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_read(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_read _cffi_d_SSL_read
#endif

static int _cffi_d_SSL_read_early_data(SSL * x0, void * x1, size_t x2, size_t * x3)
{
  return SSL_read_early_data(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_read_early_data(PyObject *self, PyObject *args)
{
  SSL * x0;
  void * x1;
  size_t x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "SSL_read_early_data", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(683), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(683), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_read_early_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_read_early_data _cffi_d_SSL_read_early_data
#endif

static int _cffi_d_SSL_renegotiate(SSL * x0)
{
  return SSL_renegotiate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_renegotiate(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_renegotiate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_renegotiate _cffi_d_SSL_renegotiate
#endif

static int _cffi_d_SSL_renegotiate_pending(SSL * x0)
{
  return SSL_renegotiate_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_renegotiate_pending(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_renegotiate_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_renegotiate_pending _cffi_d_SSL_renegotiate_pending
#endif

static int _cffi_d_SSL_session_reused(SSL const * x0)
{
  return SSL_session_reused(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_session_reused(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_session_reused(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_session_reused _cffi_d_SSL_session_reused
#endif

static SSL_CTX * _cffi_d_SSL_set_SSL_CTX(SSL * x0, SSL_CTX * x1)
{
  return SSL_set_SSL_CTX(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_SSL_CTX(PyObject *self, PyObject *args)
{
  SSL * x0;
  SSL_CTX * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SSL_CTX * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_SSL_CTX", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(190), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (SSL_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(190), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_SSL_CTX(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(190));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_SSL_CTX _cffi_d_SSL_set_SSL_CTX
#endif

static void _cffi_d_SSL_set_accept_state(SSL * x0)
{
  SSL_set_accept_state(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_accept_state(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_accept_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_accept_state _cffi_d_SSL_set_accept_state
#endif

static int _cffi_d_SSL_set_alpn_protos(SSL * x0, unsigned char const * x1, unsigned int x2)
{
  return SSL_set_alpn_protos(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_alpn_protos(PyObject *self, PyObject *args)
{
  SSL * x0;
  unsigned char const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_set_alpn_protos", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_alpn_protos(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_alpn_protos _cffi_d_SSL_set_alpn_protos
#endif

static void _cffi_d_SSL_set_bio(SSL * x0, BIO * x1, BIO * x2)
{
  SSL_set_bio(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_bio(PyObject *self, PyObject *args)
{
  SSL * x0;
  BIO * x1;
  BIO * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_set_bio", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_bio(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_bio _cffi_d_SSL_set_bio
#endif

static void _cffi_d_SSL_set_cert_cb(SSL * x0, int(* x1)(SSL *, void *), void * x2)
{
  SSL_set_cert_cb(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_cert_cb(PyObject *self, PyObject *args)
{
  SSL * x0;
  int(* x1)(SSL *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_set_cert_cb", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(SSL *, void *))_cffi_to_c_pointer(arg1, _cffi_type(1139));
  if (x1 == (int(*)(SSL *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_cert_cb(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_cert_cb _cffi_d_SSL_set_cert_cb
#endif

static void _cffi_d_SSL_set_connect_state(SSL * x0)
{
  SSL_set_connect_state(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_connect_state(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_connect_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_connect_state _cffi_d_SSL_set_connect_state
#endif

static int _cffi_d_SSL_set_fd(SSL * x0, int x1)
{
  return SSL_set_fd(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_fd(PyObject *self, PyObject *args)
{
  SSL * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_fd", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_fd(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_fd _cffi_d_SSL_set_fd
#endif

static long _cffi_d_SSL_set_mode(SSL * x0, long x1)
{
  return SSL_set_mode(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_mode(PyObject *self, PyObject *args)
{
  SSL * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_mode", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_mode(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_mode _cffi_d_SSL_set_mode
#endif

static long _cffi_d_SSL_set_mtu(SSL * x0, long x1)
{
  return SSL_set_mtu(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_mtu(PyObject *self, PyObject *args)
{
  SSL * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_mtu", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_mtu(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_mtu _cffi_d_SSL_set_mtu
#endif

static uint64_t _cffi_d_SSL_set_options(SSL * x0, uint64_t x1)
{
  return SSL_set_options(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_options(PyObject *self, PyObject *args)
{
  SSL * x0;
  uint64_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint64_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_options", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint64_t);
  if (x1 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_options(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint64_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_options _cffi_d_SSL_set_options
#endif

static void _cffi_d_SSL_set_post_handshake_auth(SSL * x0, int x1)
{
  SSL_set_post_handshake_auth(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_post_handshake_auth(PyObject *self, PyObject *args)
{
  SSL * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_post_handshake_auth", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_post_handshake_auth(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_post_handshake_auth _cffi_d_SSL_set_post_handshake_auth
#endif

static int _cffi_d_SSL_set_session(SSL * x0, SSL_SESSION * x1)
{
  return SSL_set_session(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_session(PyObject *self, PyObject *args)
{
  SSL * x0;
  SSL_SESSION * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_session", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(692), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (SSL_SESSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(692), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_session(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_session _cffi_d_SSL_set_session
#endif

static void _cffi_d_SSL_set_shutdown(SSL * x0, int x1)
{
  SSL_set_shutdown(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_shutdown(PyObject *self, PyObject *args)
{
  SSL * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_shutdown", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_shutdown(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_shutdown _cffi_d_SSL_set_shutdown
#endif

static void _cffi_d_SSL_set_tlsext_host_name(SSL * x0, char * x1)
{
  SSL_set_tlsext_host_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_tlsext_host_name(PyObject *self, PyObject *args)
{
  SSL * x0;
  char * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_tlsext_host_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(156), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(156), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_tlsext_host_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_tlsext_host_name _cffi_d_SSL_set_tlsext_host_name
#endif

static long _cffi_d_SSL_set_tlsext_status_ocsp_resp(SSL * x0, unsigned char * x1, int x2)
{
  return SSL_set_tlsext_status_ocsp_resp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_tlsext_status_ocsp_resp(PyObject *self, PyObject *args)
{
  SSL * x0;
  unsigned char * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_set_tlsext_status_ocsp_resp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_tlsext_status_ocsp_resp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_tlsext_status_ocsp_resp _cffi_d_SSL_set_tlsext_status_ocsp_resp
#endif

static long _cffi_d_SSL_set_tlsext_status_type(SSL * x0, long x1)
{
  return SSL_set_tlsext_status_type(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_tlsext_status_type(PyObject *self, PyObject *args)
{
  SSL * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_tlsext_status_type", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_tlsext_status_type(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_tlsext_status_type _cffi_d_SSL_set_tlsext_status_type
#endif

static int _cffi_d_SSL_set_tlsext_use_srtp(SSL * x0, char const * x1)
{
  return SSL_set_tlsext_use_srtp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_tlsext_use_srtp(PyObject *self, PyObject *args)
{
  SSL * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_set_tlsext_use_srtp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_set_tlsext_use_srtp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_set_tlsext_use_srtp _cffi_d_SSL_set_tlsext_use_srtp
#endif

static void _cffi_d_SSL_set_verify(SSL * x0, int x1, int(* x2)(int, X509_STORE_CTX *))
{
  SSL_set_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_set_verify(PyObject *self, PyObject *args)
{
  SSL * x0;
  int x1;
  int(* x2)(int, X509_STORE_CTX *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_set_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (int(*)(int, X509_STORE_CTX *))_cffi_to_c_pointer(arg2, _cffi_type(1333));
  if (x2 == (int(*)(int, X509_STORE_CTX *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SSL_set_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SSL_set_verify _cffi_d_SSL_set_verify
#endif

static int _cffi_d_SSL_shutdown(SSL * x0)
{
  return SSL_shutdown(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_shutdown(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_shutdown(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_shutdown _cffi_d_SSL_shutdown
#endif

static char const * _cffi_d_SSL_state_string_long(SSL const * x0)
{
  return SSL_state_string_long(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_state_string_long(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_state_string_long(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_state_string_long _cffi_d_SSL_state_string_long
#endif

static long _cffi_d_SSL_total_renegotiations(SSL * x0)
{
  return SSL_total_renegotiations(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_total_renegotiations(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_total_renegotiations(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_total_renegotiations _cffi_d_SSL_total_renegotiations
#endif

static int _cffi_d_SSL_use_PrivateKey(SSL * x0, EVP_PKEY * x1)
{
  return SSL_use_PrivateKey(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_use_PrivateKey(PyObject *self, PyObject *args)
{
  SSL * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_use_PrivateKey", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_use_PrivateKey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_use_PrivateKey _cffi_d_SSL_use_PrivateKey
#endif

static int _cffi_d_SSL_use_certificate(SSL * x0, X509 * x1)
{
  return SSL_use_certificate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_use_certificate(PyObject *self, PyObject *args)
{
  SSL * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SSL_use_certificate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_use_certificate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_use_certificate _cffi_d_SSL_use_certificate
#endif

static int _cffi_d_SSL_verify_client_post_handshake(SSL * x0)
{
  return SSL_verify_client_post_handshake(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_verify_client_post_handshake(PyObject *self, PyObject *arg0)
{
  SSL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_verify_client_post_handshake(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_verify_client_post_handshake _cffi_d_SSL_verify_client_post_handshake
#endif

static int _cffi_d_SSL_version(SSL const * x0)
{
  return SSL_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_version(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_version _cffi_d_SSL_version
#endif

static int _cffi_d_SSL_want_read(SSL const * x0)
{
  return SSL_want_read(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_want_read(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_want_read(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_want_read _cffi_d_SSL_want_read
#endif

static int _cffi_d_SSL_want_write(SSL const * x0)
{
  return SSL_want_write(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_want_write(PyObject *self, PyObject *arg0)
{
  SSL const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_want_write(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_want_write _cffi_d_SSL_want_write
#endif

static int _cffi_d_SSL_write(SSL * x0, void const * x1, int x2)
{
  return SSL_write(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_write(PyObject *self, PyObject *args)
{
  SSL * x0;
  void const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SSL_write", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_write(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_write _cffi_d_SSL_write
#endif

static int _cffi_d_SSL_write_early_data(SSL * x0, void const * x1, size_t x2, size_t * x3)
{
  return SSL_write_early_data(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SSL_write_early_data(PyObject *self, PyObject *args)
{
  SSL * x0;
  void const * x1;
  size_t x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "SSL_write_early_data", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SSL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(683), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(683), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SSL_write_early_data(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SSL_write_early_data _cffi_d_SSL_write_early_data
#endif

static SSL_METHOD const * _cffi_d_TLS_client_method(void)
{
  return TLS_client_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_TLS_client_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = TLS_client_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_TLS_client_method _cffi_d_TLS_client_method
#endif

static SSL_METHOD const * _cffi_d_TLS_method(void)
{
  return TLS_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_TLS_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = TLS_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_TLS_method _cffi_d_TLS_method
#endif

static SSL_METHOD const * _cffi_d_TLS_server_method(void)
{
  return TLS_server_method();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_TLS_server_method(PyObject *self, PyObject *noarg)
{
  SSL_METHOD const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = TLS_server_method(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1588));
  return pyresult;
}
#else
#  define _cffi_f_TLS_server_method _cffi_d_TLS_server_method
#endif

static void * _cffi_d_X509V3_EXT_d2i(X509_EXTENSION * x0)
{
  return X509V3_EXT_d2i(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509V3_EXT_d2i(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509V3_EXT_d2i(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(87));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509V3_EXT_d2i _cffi_d_X509V3_EXT_d2i
#endif

static X509_EXTENSION * _cffi_d_X509V3_EXT_nconf(CONF * x0, X509V3_CTX * x1, char const * x2, char const * x3)
{
  return X509V3_EXT_nconf(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509V3_EXT_nconf(PyObject *self, PyObject *args)
{
  CONF * x0;
  X509V3_CTX * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509V3_EXT_nconf", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(257), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (CONF *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(257), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(258), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509V3_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(258), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509V3_EXT_nconf(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509V3_EXT_nconf _cffi_d_X509V3_EXT_nconf
#endif

static int _cffi_d_X509V3_EXT_print(BIO * x0, X509_EXTENSION * x1, unsigned long x2, int x3)
{
  return X509V3_EXT_print(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509V3_EXT_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_EXTENSION * x1;
  unsigned long x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509V3_EXT_print", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long);
  if (x2 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509V3_EXT_print(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509V3_EXT_print _cffi_d_X509V3_EXT_print
#endif

static void _cffi_d_X509V3_set_ctx(X509V3_CTX * x0, X509 * x1, X509 * x2, X509_REQ * x3, X509_CRL * x4, int x5)
{
  X509V3_set_ctx(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509V3_set_ctx(PyObject *self, PyObject *args)
{
  X509V3_CTX * x0;
  X509 * x1;
  X509 * x2;
  X509_REQ * x3;
  X509_CRL * x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "X509V3_set_ctx", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(258), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509V3_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(258), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509V3_set_ctx(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509V3_set_ctx _cffi_d_X509V3_set_ctx
#endif

static void _cffi_d_X509V3_set_ctx_nodb(X509V3_CTX * x0)
{
  X509V3_set_ctx_nodb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509V3_set_ctx_nodb(PyObject *self, PyObject *arg0)
{
  X509V3_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(258), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509V3_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(258), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509V3_set_ctx_nodb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509V3_set_ctx_nodb _cffi_d_X509V3_set_ctx_nodb
#endif

static void _cffi_d_X509_ALGOR_get0(ASN1_OBJECT const * * x0, int * x1, void const * * x2, X509_ALGOR const * x3)
{
  X509_ALGOR_get0(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_ALGOR_get0(PyObject *self, PyObject *args)
{
  ASN1_OBJECT const * * x0;
  int * x1;
  void const * * x2;
  X509_ALGOR const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509_ALGOR_get0", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1250), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OBJECT const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1250), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1252), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1252), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1253), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (X509_ALGOR const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1253), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_ALGOR_get0(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_ALGOR_get0 _cffi_d_X509_ALGOR_get0
#endif

static int _cffi_d_X509_CRL_add0_revoked(X509_CRL * x0, X509_REVOKED * x1)
{
  return X509_CRL_add0_revoked(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_add0_revoked(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  X509_REVOKED * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_add0_revoked", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_add0_revoked(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_add0_revoked _cffi_d_X509_CRL_add0_revoked
#endif

static void _cffi_d_X509_CRL_free(X509_CRL * x0)
{
  X509_CRL_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_free(PyObject *self, PyObject *arg0)
{
  X509_CRL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_CRL_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_CRL_free _cffi_d_X509_CRL_free
#endif

static Cryptography_STACK_OF_X509_REVOKED * _cffi_d_X509_CRL_get_REVOKED(X509_CRL * x0)
{
  return X509_CRL_get_REVOKED(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_get_REVOKED(PyObject *self, PyObject *arg0)
{
  X509_CRL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509_REVOKED * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_get_REVOKED(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(325));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_get_REVOKED _cffi_d_X509_CRL_get_REVOKED
#endif

static X509_NAME * _cffi_d_X509_CRL_get_issuer(X509_CRL * x0)
{
  return X509_CRL_get_issuer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_get_issuer(PyObject *self, PyObject *arg0)
{
  X509_CRL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_get_issuer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_get_issuer _cffi_d_X509_CRL_get_issuer
#endif

static X509_CRL * _cffi_d_X509_CRL_new(void)
{
  return X509_CRL_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_new(PyObject *self, PyObject *noarg)
{
  X509_CRL * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(81));
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_new _cffi_d_X509_CRL_new
#endif

static int _cffi_d_X509_CRL_print(BIO * x0, X509_CRL * x1)
{
  return X509_CRL_print(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_print(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_print", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_print(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_print _cffi_d_X509_CRL_print
#endif

static int _cffi_d_X509_CRL_set1_lastUpdate(X509_CRL * x0, ASN1_OCTET_STRING const * x1)
{
  return X509_CRL_set1_lastUpdate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_set1_lastUpdate(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  ASN1_OCTET_STRING const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_set1_lastUpdate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_set1_lastUpdate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_set1_lastUpdate _cffi_d_X509_CRL_set1_lastUpdate
#endif

static int _cffi_d_X509_CRL_set1_nextUpdate(X509_CRL * x0, ASN1_OCTET_STRING const * x1)
{
  return X509_CRL_set1_nextUpdate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_set1_nextUpdate(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  ASN1_OCTET_STRING const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_set1_nextUpdate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_set1_nextUpdate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_set1_nextUpdate _cffi_d_X509_CRL_set1_nextUpdate
#endif

static int _cffi_d_X509_CRL_set_issuer_name(X509_CRL * x0, X509_NAME * x1)
{
  return X509_CRL_set_issuer_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_set_issuer_name(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  X509_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_set_issuer_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_set_issuer_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_set_issuer_name _cffi_d_X509_CRL_set_issuer_name
#endif

static int _cffi_d_X509_CRL_set_version(X509_CRL * x0, long x1)
{
  return X509_CRL_set_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_set_version(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_CRL_set_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_set_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_set_version _cffi_d_X509_CRL_set_version
#endif

static int _cffi_d_X509_CRL_sign(X509_CRL * x0, EVP_PKEY * x1, EVP_MD const * x2)
{
  return X509_CRL_sign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_sign(PyObject *self, PyObject *args)
{
  X509_CRL * x0;
  EVP_PKEY * x1;
  EVP_MD const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_CRL_sign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_sign _cffi_d_X509_CRL_sign
#endif

static int _cffi_d_X509_CRL_sort(X509_CRL * x0)
{
  return X509_CRL_sort(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_CRL_sort(PyObject *self, PyObject *arg0)
{
  X509_CRL * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_CRL_sort(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_CRL_sort _cffi_d_X509_CRL_sort
#endif

static X509_EXTENSION * _cffi_d_X509_EXTENSION_dup(X509_EXTENSION * x0)
{
  return X509_EXTENSION_dup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_EXTENSION_dup(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_EXTENSION_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_EXTENSION_dup _cffi_d_X509_EXTENSION_dup
#endif

static void _cffi_d_X509_EXTENSION_free(X509_EXTENSION * x0)
{
  X509_EXTENSION_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_EXTENSION_free(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_EXTENSION_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_EXTENSION_free _cffi_d_X509_EXTENSION_free
#endif

static int _cffi_d_X509_EXTENSION_get_critical(X509_EXTENSION const * x0)
{
  return X509_EXTENSION_get_critical(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_EXTENSION_get_critical(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(934), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(934), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_EXTENSION_get_critical(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_EXTENSION_get_critical _cffi_d_X509_EXTENSION_get_critical
#endif

static ASN1_OCTET_STRING * _cffi_d_X509_EXTENSION_get_data(X509_EXTENSION * x0)
{
  return X509_EXTENSION_get_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_EXTENSION_get_data(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_EXTENSION_get_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_EXTENSION_get_data _cffi_d_X509_EXTENSION_get_data
#endif

static ASN1_OBJECT * _cffi_d_X509_EXTENSION_get_object(X509_EXTENSION * x0)
{
  return X509_EXTENSION_get_object(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_EXTENSION_get_object(PyObject *self, PyObject *arg0)
{
  X509_EXTENSION * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OBJECT * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_EXTENSION_get_object(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1528));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_EXTENSION_get_object _cffi_d_X509_EXTENSION_get_object
#endif

static void _cffi_d_X509_NAME_ENTRY_free(X509_NAME_ENTRY * x0)
{
  X509_NAME_ENTRY_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_ENTRY_free(PyObject *self, PyObject *arg0)
{
  X509_NAME_ENTRY * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1467), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME_ENTRY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1467), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_NAME_ENTRY_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_NAME_ENTRY_free _cffi_d_X509_NAME_ENTRY_free
#endif

static ASN1_OCTET_STRING * _cffi_d_X509_NAME_ENTRY_get_data(X509_NAME_ENTRY const * x0)
{
  return X509_NAME_ENTRY_get_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_ENTRY_get_data(PyObject *self, PyObject *arg0)
{
  X509_NAME_ENTRY const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME_ENTRY const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_ENTRY_get_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_ENTRY_get_data _cffi_d_X509_NAME_ENTRY_get_data
#endif

static ASN1_OBJECT * _cffi_d_X509_NAME_ENTRY_get_object(X509_NAME_ENTRY const * x0)
{
  return X509_NAME_ENTRY_get_object(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_ENTRY_get_object(PyObject *self, PyObject *arg0)
{
  X509_NAME_ENTRY const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OBJECT * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(20), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME_ENTRY const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(20), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_ENTRY_get_object(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1528));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_ENTRY_get_object _cffi_d_X509_NAME_ENTRY_get_object
#endif

static int _cffi_d_X509_NAME_add_entry_by_NID(X509_NAME * x0, int x1, int x2, unsigned char const * x3, int x4, int x5, int x6)
{
  return X509_NAME_add_entry_by_NID(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_add_entry_by_NID(PyObject *self, PyObject *args)
{
  X509_NAME * x0;
  int x1;
  int x2;
  unsigned char const * x3;
  int x4;
  int x5;
  int x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "X509_NAME_add_entry_by_NID", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, int);
  if (x6 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_add_entry_by_NID(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_add_entry_by_NID _cffi_d_X509_NAME_add_entry_by_NID
#endif

static int _cffi_d_X509_NAME_cmp(X509_NAME const * x0, X509_NAME const * x1)
{
  return X509_NAME_cmp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_cmp(PyObject *self, PyObject *args)
{
  X509_NAME const * x0;
  X509_NAME const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_NAME_cmp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(309), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(309), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(309), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(309), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_cmp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_cmp _cffi_d_X509_NAME_cmp
#endif

static X509_NAME_ENTRY * _cffi_d_X509_NAME_delete_entry(X509_NAME * x0, int x1)
{
  return X509_NAME_delete_entry(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_delete_entry(PyObject *self, PyObject *args)
{
  X509_NAME * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME_ENTRY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_NAME_delete_entry", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_delete_entry(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1467));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_delete_entry _cffi_d_X509_NAME_delete_entry
#endif

static X509_NAME * _cffi_d_X509_NAME_dup(X509_NAME * x0)
{
  return X509_NAME_dup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_dup(PyObject *self, PyObject *arg0)
{
  X509_NAME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_dup _cffi_d_X509_NAME_dup
#endif

static int _cffi_d_X509_NAME_entry_count(X509_NAME const * x0)
{
  return X509_NAME_entry_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_entry_count(PyObject *self, PyObject *arg0)
{
  X509_NAME const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(309), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(309), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_entry_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_entry_count _cffi_d_X509_NAME_entry_count
#endif

static void _cffi_d_X509_NAME_free(X509_NAME * x0)
{
  X509_NAME_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_free(PyObject *self, PyObject *arg0)
{
  X509_NAME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_NAME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_NAME_free _cffi_d_X509_NAME_free
#endif

static X509_NAME_ENTRY * _cffi_d_X509_NAME_get_entry(X509_NAME const * x0, int x1)
{
  return X509_NAME_get_entry(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_get_entry(PyObject *self, PyObject *args)
{
  X509_NAME const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME_ENTRY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_NAME_get_entry", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(309), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(309), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_get_entry(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1467));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_get_entry _cffi_d_X509_NAME_get_entry
#endif

static int _cffi_d_X509_NAME_get_index_by_NID(X509_NAME * x0, int x1, int x2)
{
  return X509_NAME_get_index_by_NID(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_get_index_by_NID(PyObject *self, PyObject *args)
{
  X509_NAME * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_NAME_get_index_by_NID", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_get_index_by_NID(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_get_index_by_NID _cffi_d_X509_NAME_get_index_by_NID
#endif

static unsigned long _cffi_d_X509_NAME_hash(X509_NAME * x0)
{
  return X509_NAME_hash(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_hash(PyObject *self, PyObject *arg0)
{
  X509_NAME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_hash(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_hash _cffi_d_X509_NAME_hash
#endif

static X509_NAME * _cffi_d_X509_NAME_new(void)
{
  return X509_NAME_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_new(PyObject *self, PyObject *noarg)
{
  X509_NAME * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_new _cffi_d_X509_NAME_new
#endif

static char * _cffi_d_X509_NAME_oneline(X509_NAME const * x0, char * x1, int x2)
{
  return X509_NAME_oneline(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_NAME_oneline(PyObject *self, PyObject *args)
{
  X509_NAME const * x0;
  char * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_NAME_oneline", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(309), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(309), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(156), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(156), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_NAME_oneline(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(156));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_NAME_oneline _cffi_d_X509_NAME_oneline
#endif

static int _cffi_d_X509_REQ_add_extensions(X509_REQ * x0, X509_EXTENSIONS * x1)
{
  return X509_REQ_add_extensions(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_add_extensions(PyObject *self, PyObject *args)
{
  X509_REQ * x0;
  X509_EXTENSIONS * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REQ_add_extensions", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_add_extensions(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_add_extensions _cffi_d_X509_REQ_add_extensions
#endif

static void _cffi_d_X509_REQ_free(X509_REQ * x0)
{
  X509_REQ_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_free(PyObject *self, PyObject *arg0)
{
  X509_REQ * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_REQ_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_REQ_free _cffi_d_X509_REQ_free
#endif

static X509_EXTENSIONS * _cffi_d_X509_REQ_get_extensions(X509_REQ * x0)
{
  return X509_REQ_get_extensions(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_get_extensions(PyObject *self, PyObject *arg0)
{
  X509_REQ * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSIONS * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_get_extensions(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(270));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_get_extensions _cffi_d_X509_REQ_get_extensions
#endif

static EVP_PKEY * _cffi_d_X509_REQ_get_pubkey(X509_REQ * x0)
{
  return X509_REQ_get_pubkey(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_get_pubkey(PyObject *self, PyObject *arg0)
{
  X509_REQ * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_get_pubkey(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_get_pubkey _cffi_d_X509_REQ_get_pubkey
#endif

static X509_NAME * _cffi_d_X509_REQ_get_subject_name(X509_REQ * x0)
{
  return X509_REQ_get_subject_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_get_subject_name(PyObject *self, PyObject *arg0)
{
  X509_REQ * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_get_subject_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_get_subject_name _cffi_d_X509_REQ_get_subject_name
#endif

static long _cffi_d_X509_REQ_get_version(X509_REQ * x0)
{
  return X509_REQ_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_get_version(PyObject *self, PyObject *arg0)
{
  X509_REQ * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_get_version _cffi_d_X509_REQ_get_version
#endif

static X509_REQ * _cffi_d_X509_REQ_new(void)
{
  return X509_REQ_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_new(PyObject *self, PyObject *noarg)
{
  X509_REQ * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(137));
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_new _cffi_d_X509_REQ_new
#endif

static int _cffi_d_X509_REQ_print_ex(BIO * x0, X509_REQ * x1, unsigned long x2, unsigned long x3)
{
  return X509_REQ_print_ex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_print_ex(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * x1;
  unsigned long x2;
  unsigned long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509_REQ_print_ex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long);
  if (x2 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long);
  if (x3 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_print_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_print_ex _cffi_d_X509_REQ_print_ex
#endif

static int _cffi_d_X509_REQ_set_pubkey(X509_REQ * x0, EVP_PKEY * x1)
{
  return X509_REQ_set_pubkey(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_set_pubkey(PyObject *self, PyObject *args)
{
  X509_REQ * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REQ_set_pubkey", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_set_pubkey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_set_pubkey _cffi_d_X509_REQ_set_pubkey
#endif

static int _cffi_d_X509_REQ_set_version(X509_REQ * x0, long x1)
{
  return X509_REQ_set_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_set_version(PyObject *self, PyObject *args)
{
  X509_REQ * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REQ_set_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_set_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_set_version _cffi_d_X509_REQ_set_version
#endif

static int _cffi_d_X509_REQ_sign(X509_REQ * x0, EVP_PKEY * x1, EVP_MD const * x2)
{
  return X509_REQ_sign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_sign(PyObject *self, PyObject *args)
{
  X509_REQ * x0;
  EVP_PKEY * x1;
  EVP_MD const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_REQ_sign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_sign _cffi_d_X509_REQ_sign
#endif

static int _cffi_d_X509_REQ_verify(X509_REQ * x0, EVP_PKEY * x1)
{
  return X509_REQ_verify(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REQ_verify(PyObject *self, PyObject *args)
{
  X509_REQ * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REQ_verify", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REQ_verify(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REQ_verify _cffi_d_X509_REQ_verify
#endif

static int _cffi_d_X509_REVOKED_add1_ext_i2d(X509_REVOKED * x0, int x1, void * x2, int x3, unsigned long x4)
{
  return X509_REVOKED_add1_ext_i2d(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_add1_ext_i2d(PyObject *self, PyObject *args)
{
  X509_REVOKED * x0;
  int x1;
  void * x2;
  int x3;
  unsigned long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "X509_REVOKED_add1_ext_i2d", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(87), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(87), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned long);
  if (x4 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_add1_ext_i2d(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_add1_ext_i2d _cffi_d_X509_REVOKED_add1_ext_i2d
#endif

static X509_EXTENSION * _cffi_d_X509_REVOKED_delete_ext(X509_REVOKED * x0, int x1)
{
  return X509_REVOKED_delete_ext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_delete_ext(PyObject *self, PyObject *args)
{
  X509_REVOKED * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REVOKED_delete_ext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_delete_ext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_delete_ext _cffi_d_X509_REVOKED_delete_ext
#endif

static X509_REVOKED * _cffi_d_X509_REVOKED_dup(X509_REVOKED * x0)
{
  return X509_REVOKED_dup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_dup(PyObject *self, PyObject *arg0)
{
  X509_REVOKED * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_REVOKED * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(274));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_dup _cffi_d_X509_REVOKED_dup
#endif

static void _cffi_d_X509_REVOKED_free(X509_REVOKED * x0)
{
  X509_REVOKED_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_free(PyObject *self, PyObject *arg0)
{
  X509_REVOKED * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_REVOKED_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_REVOKED_free _cffi_d_X509_REVOKED_free
#endif

static ASN1_OCTET_STRING const * _cffi_d_X509_REVOKED_get0_revocationDate(X509_REVOKED const * x0)
{
  return X509_REVOKED_get0_revocationDate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_get0_revocationDate(PyObject *self, PyObject *arg0)
{
  X509_REVOKED const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_get0_revocationDate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_get0_revocationDate _cffi_d_X509_REVOKED_get0_revocationDate
#endif

static ASN1_INTEGER const * _cffi_d_X509_REVOKED_get0_serialNumber(X509_REVOKED const * x0)
{
  return X509_REVOKED_get0_serialNumber(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_get0_serialNumber(PyObject *self, PyObject *arg0)
{
  X509_REVOKED const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_INTEGER const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_get0_serialNumber(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(435));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_get0_serialNumber _cffi_d_X509_REVOKED_get0_serialNumber
#endif

static X509_EXTENSION * _cffi_d_X509_REVOKED_get_ext(X509_REVOKED const * x0, int x1)
{
  return X509_REVOKED_get_ext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_get_ext(PyObject *self, PyObject *args)
{
  X509_REVOKED const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REVOKED_get_ext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_get_ext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_get_ext _cffi_d_X509_REVOKED_get_ext
#endif

static int _cffi_d_X509_REVOKED_get_ext_count(X509_REVOKED const * x0)
{
  return X509_REVOKED_get_ext_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_get_ext_count(PyObject *self, PyObject *arg0)
{
  X509_REVOKED const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_get_ext_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_get_ext_count _cffi_d_X509_REVOKED_get_ext_count
#endif

static X509_REVOKED * _cffi_d_X509_REVOKED_new(void)
{
  return X509_REVOKED_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_new(PyObject *self, PyObject *noarg)
{
  X509_REVOKED * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(274));
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_new _cffi_d_X509_REVOKED_new
#endif

static int _cffi_d_X509_REVOKED_set_revocationDate(X509_REVOKED * x0, ASN1_OCTET_STRING * x1)
{
  return X509_REVOKED_set_revocationDate(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_set_revocationDate(PyObject *self, PyObject *args)
{
  X509_REVOKED * x0;
  ASN1_OCTET_STRING * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REVOKED_set_revocationDate", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_set_revocationDate(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_set_revocationDate _cffi_d_X509_REVOKED_set_revocationDate
#endif

static int _cffi_d_X509_REVOKED_set_serialNumber(X509_REVOKED * x0, ASN1_INTEGER * x1)
{
  return X509_REVOKED_set_serialNumber(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_REVOKED_set_serialNumber(PyObject *self, PyObject *args)
{
  X509_REVOKED * x0;
  ASN1_INTEGER * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_REVOKED_set_serialNumber", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(274), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(274), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_REVOKED_set_serialNumber(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_REVOKED_set_serialNumber _cffi_d_X509_REVOKED_set_serialNumber
#endif

static void _cffi_d_X509_STORE_CTX_cleanup(X509_STORE_CTX * x0)
{
  X509_STORE_CTX_cleanup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_cleanup(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_STORE_CTX_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_STORE_CTX_cleanup _cffi_d_X509_STORE_CTX_cleanup
#endif

static void _cffi_d_X509_STORE_CTX_free(X509_STORE_CTX * x0)
{
  X509_STORE_CTX_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_free(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_STORE_CTX_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_STORE_CTX_free _cffi_d_X509_STORE_CTX_free
#endif

static X509 * _cffi_d_X509_STORE_CTX_get0_cert(X509_STORE_CTX * x0)
{
  return X509_STORE_CTX_get0_cert(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get0_cert(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get0_cert(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get0_cert _cffi_d_X509_STORE_CTX_get0_cert
#endif

static Cryptography_STACK_OF_X509 * _cffi_d_X509_STORE_CTX_get1_chain(X509_STORE_CTX * x0)
{
  return X509_STORE_CTX_get1_chain(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get1_chain(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get1_chain(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(160));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get1_chain _cffi_d_X509_STORE_CTX_get1_chain
#endif

static X509 * _cffi_d_X509_STORE_CTX_get_current_cert(X509_STORE_CTX * x0)
{
  return X509_STORE_CTX_get_current_cert(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get_current_cert(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get_current_cert(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get_current_cert _cffi_d_X509_STORE_CTX_get_current_cert
#endif

static int _cffi_d_X509_STORE_CTX_get_error(X509_STORE_CTX * x0)
{
  return X509_STORE_CTX_get_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get_error(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get_error _cffi_d_X509_STORE_CTX_get_error
#endif

static int _cffi_d_X509_STORE_CTX_get_error_depth(X509_STORE_CTX * x0)
{
  return X509_STORE_CTX_get_error_depth(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get_error_depth(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get_error_depth(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get_error_depth _cffi_d_X509_STORE_CTX_get_error_depth
#endif

static void * _cffi_d_X509_STORE_CTX_get_ex_data(X509_STORE_CTX * x0, int x1)
{
  return X509_STORE_CTX_get_ex_data(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_get_ex_data(PyObject *self, PyObject *args)
{
  X509_STORE_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_CTX_get_ex_data", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_get_ex_data(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(87));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_get_ex_data _cffi_d_X509_STORE_CTX_get_ex_data
#endif

static int _cffi_d_X509_STORE_CTX_init(X509_STORE_CTX * x0, X509_STORE * x1, X509 * x2, Cryptography_STACK_OF_X509 * x3)
{
  return X509_STORE_CTX_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_init(PyObject *self, PyObject *args)
{
  X509_STORE_CTX * x0;
  X509_STORE * x1;
  X509 * x2;
  Cryptography_STACK_OF_X509 * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509_STORE_CTX_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_init _cffi_d_X509_STORE_CTX_init
#endif

static X509_STORE_CTX * _cffi_d_X509_STORE_CTX_new(void)
{
  return X509_STORE_CTX_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_new(PyObject *self, PyObject *noarg)
{
  X509_STORE_CTX * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_CTX_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(65));
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_CTX_new _cffi_d_X509_STORE_CTX_new
#endif

static void _cffi_d_X509_STORE_CTX_set_error(X509_STORE_CTX * x0, int x1)
{
  X509_STORE_CTX_set_error(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_CTX_set_error(PyObject *self, PyObject *args)
{
  X509_STORE_CTX * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_CTX_set_error", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_STORE_CTX_set_error(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_STORE_CTX_set_error _cffi_d_X509_STORE_CTX_set_error
#endif

static int _cffi_d_X509_STORE_add_cert(X509_STORE * x0, X509 * x1)
{
  return X509_STORE_add_cert(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_add_cert(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_add_cert", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_add_cert(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_add_cert _cffi_d_X509_STORE_add_cert
#endif

static int _cffi_d_X509_STORE_add_crl(X509_STORE * x0, X509_CRL * x1)
{
  return X509_STORE_add_crl(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_add_crl(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  X509_CRL * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_add_crl", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_add_crl(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_add_crl _cffi_d_X509_STORE_add_crl
#endif

static void _cffi_d_X509_STORE_free(X509_STORE * x0)
{
  X509_STORE_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_free(PyObject *self, PyObject *arg0)
{
  X509_STORE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_STORE_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_STORE_free _cffi_d_X509_STORE_free
#endif

static Cryptography_STACK_OF_X509_OBJECT * _cffi_d_X509_STORE_get0_objects(X509_STORE * x0)
{
  return X509_STORE_get0_objects(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_get0_objects(PyObject *self, PyObject *arg0)
{
  X509_STORE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Cryptography_STACK_OF_X509_OBJECT * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_get0_objects(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(518));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_get0_objects _cffi_d_X509_STORE_get0_objects
#endif

static int _cffi_d_X509_STORE_load_locations(X509_STORE * x0, char const * x1, char const * x2)
{
  return X509_STORE_load_locations(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_load_locations(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_STORE_load_locations", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_load_locations(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_load_locations _cffi_d_X509_STORE_load_locations
#endif

static X509_STORE * _cffi_d_X509_STORE_new(void)
{
  return X509_STORE_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_new(PyObject *self, PyObject *noarg)
{
  X509_STORE * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(78));
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_new _cffi_d_X509_STORE_new
#endif

static int _cffi_d_X509_STORE_set1_param(X509_STORE * x0, X509_VERIFY_PARAM * x1)
{
  return X509_STORE_set1_param(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_set1_param(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  X509_VERIFY_PARAM * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_set1_param", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_set1_param(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_set1_param _cffi_d_X509_STORE_set1_param
#endif

static int _cffi_d_X509_STORE_set_default_paths(X509_STORE * x0)
{
  return X509_STORE_set_default_paths(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_set_default_paths(PyObject *self, PyObject *arg0)
{
  X509_STORE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_set_default_paths(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_set_default_paths _cffi_d_X509_STORE_set_default_paths
#endif

static int _cffi_d_X509_STORE_set_flags(X509_STORE * x0, unsigned long x1)
{
  return X509_STORE_set_flags(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_set_flags(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  unsigned long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_set_flags", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long);
  if (x1 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_set_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_set_flags _cffi_d_X509_STORE_set_flags
#endif

static int _cffi_d_X509_STORE_set_purpose(X509_STORE * x0, int x1)
{
  return X509_STORE_set_purpose(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_set_purpose(PyObject *self, PyObject *args)
{
  X509_STORE * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_STORE_set_purpose", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_set_purpose(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_set_purpose _cffi_d_X509_STORE_set_purpose
#endif

static int _cffi_d_X509_STORE_up_ref(X509_STORE * x0)
{
  return X509_STORE_up_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_STORE_up_ref(PyObject *self, PyObject *arg0)
{
  X509_STORE * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(78), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(78), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_STORE_up_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_STORE_up_ref _cffi_d_X509_STORE_up_ref
#endif

static void _cffi_d_X509_VERIFY_PARAM_free(X509_VERIFY_PARAM * x0)
{
  X509_VERIFY_PARAM_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_free(PyObject *self, PyObject *arg0)
{
  X509_VERIFY_PARAM * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_VERIFY_PARAM_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_free _cffi_d_X509_VERIFY_PARAM_free
#endif

static X509_VERIFY_PARAM * _cffi_d_X509_VERIFY_PARAM_new(void)
{
  return X509_VERIFY_PARAM_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_new(PyObject *self, PyObject *noarg)
{
  X509_VERIFY_PARAM * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_VERIFY_PARAM_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1016));
  return pyresult;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_new _cffi_d_X509_VERIFY_PARAM_new
#endif

static int _cffi_d_X509_VERIFY_PARAM_set1_host(X509_VERIFY_PARAM * x0, char const * x1, size_t x2)
{
  return X509_VERIFY_PARAM_set1_host(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_set1_host(PyObject *self, PyObject *args)
{
  X509_VERIFY_PARAM * x0;
  char const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_VERIFY_PARAM_set1_host", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_VERIFY_PARAM_set1_host(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_set1_host _cffi_d_X509_VERIFY_PARAM_set1_host
#endif

static int _cffi_d_X509_VERIFY_PARAM_set1_ip(X509_VERIFY_PARAM * x0, unsigned char const * x1, size_t x2)
{
  return X509_VERIFY_PARAM_set1_ip(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_set1_ip(PyObject *self, PyObject *args)
{
  X509_VERIFY_PARAM * x0;
  unsigned char const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_VERIFY_PARAM_set1_ip", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_VERIFY_PARAM_set1_ip(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_set1_ip _cffi_d_X509_VERIFY_PARAM_set1_ip
#endif

static int _cffi_d_X509_VERIFY_PARAM_set_flags(X509_VERIFY_PARAM * x0, unsigned long x1)
{
  return X509_VERIFY_PARAM_set_flags(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_set_flags(PyObject *self, PyObject *args)
{
  X509_VERIFY_PARAM * x0;
  unsigned long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_VERIFY_PARAM_set_flags", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long);
  if (x1 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_VERIFY_PARAM_set_flags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_set_flags _cffi_d_X509_VERIFY_PARAM_set_flags
#endif

static void _cffi_d_X509_VERIFY_PARAM_set_hostflags(X509_VERIFY_PARAM * x0, unsigned int x1)
{
  X509_VERIFY_PARAM_set_hostflags(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_set_hostflags(PyObject *self, PyObject *args)
{
  X509_VERIFY_PARAM * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_VERIFY_PARAM_set_hostflags", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_VERIFY_PARAM_set_hostflags(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_set_hostflags _cffi_d_X509_VERIFY_PARAM_set_hostflags
#endif

static void _cffi_d_X509_VERIFY_PARAM_set_time(X509_VERIFY_PARAM * x0, time_t x1)
{
  X509_VERIFY_PARAM_set_time(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_VERIFY_PARAM_set_time(PyObject *self, PyObject *args)
{
  X509_VERIFY_PARAM * x0;
  time_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_VERIFY_PARAM_set_time", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1016), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_VERIFY_PARAM *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1016), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, time_t);
  if (x1 == (time_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_VERIFY_PARAM_set_time(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_VERIFY_PARAM_set_time _cffi_d_X509_VERIFY_PARAM_set_time
#endif

static int _cffi_d_X509_add_ext(X509 * x0, X509_EXTENSION * x1, int x2)
{
  return X509_add_ext(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_add_ext(PyObject *self, PyObject *args)
{
  X509 * x0;
  X509_EXTENSION * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_add_ext", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_add_ext(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_add_ext _cffi_d_X509_add_ext
#endif

static unsigned char * _cffi_d_X509_alias_get0(X509 * x0, int * x1)
{
  return X509_alias_get0(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_alias_get0(PyObject *self, PyObject *args)
{
  X509 * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_alias_get0", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(531), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(531), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_alias_get0(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(445));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_alias_get0 _cffi_d_X509_alias_get0
#endif

static int _cffi_d_X509_alias_set1(X509 * x0, unsigned char const * x1, int x2)
{
  return X509_alias_set1(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_alias_set1(PyObject *self, PyObject *args)
{
  X509 * x0;
  unsigned char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_alias_set1", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(194), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(194), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_alias_set1(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_alias_set1 _cffi_d_X509_alias_set1
#endif

static int _cffi_d_X509_digest(X509 const * x0, EVP_MD const * x1, unsigned char * x2, unsigned int * x3)
{
  return X509_digest(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_digest(PyObject *self, PyObject *args)
{
  X509 const * x0;
  EVP_MD const * x1;
  unsigned char * x2;
  unsigned int * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509_digest", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(592), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(592), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_digest(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_digest _cffi_d_X509_digest
#endif

static X509 * _cffi_d_X509_dup(X509 * x0)
{
  return X509_dup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_dup(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_dup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_dup _cffi_d_X509_dup
#endif

static void _cffi_d_X509_free(X509 * x0)
{
  X509_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_free(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { X509_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_X509_free _cffi_d_X509_free
#endif

static X509_ALGOR const * _cffi_d_X509_get0_tbs_sigalg(X509 const * x0)
{
  return X509_get0_tbs_sigalg(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get0_tbs_sigalg(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_ALGOR const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get0_tbs_sigalg(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1253));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get0_tbs_sigalg _cffi_d_X509_get0_tbs_sigalg
#endif

static char const * _cffi_d_X509_get_default_cert_dir(void)
{
  return X509_get_default_cert_dir();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_default_cert_dir(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_default_cert_dir(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_X509_get_default_cert_dir _cffi_d_X509_get_default_cert_dir
#endif

static char const * _cffi_d_X509_get_default_cert_dir_env(void)
{
  return X509_get_default_cert_dir_env();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_default_cert_dir_env(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_default_cert_dir_env(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_X509_get_default_cert_dir_env _cffi_d_X509_get_default_cert_dir_env
#endif

static char const * _cffi_d_X509_get_default_cert_file(void)
{
  return X509_get_default_cert_file();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_default_cert_file(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_default_cert_file(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_X509_get_default_cert_file _cffi_d_X509_get_default_cert_file
#endif

static char const * _cffi_d_X509_get_default_cert_file_env(void)
{
  return X509_get_default_cert_file_env();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_default_cert_file_env(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_default_cert_file_env(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_X509_get_default_cert_file_env _cffi_d_X509_get_default_cert_file_env
#endif

static X509_EXTENSION * _cffi_d_X509_get_ext(X509 const * x0, int x1)
{
  return X509_get_ext(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_ext(PyObject *self, PyObject *args)
{
  X509 const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_get_ext", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_ext(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_ext _cffi_d_X509_get_ext
#endif

static int _cffi_d_X509_get_ext_count(X509 const * x0)
{
  return X509_get_ext_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_ext_count(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_ext_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_ext_count _cffi_d_X509_get_ext_count
#endif

static X509_NAME * _cffi_d_X509_get_issuer_name(X509 const * x0)
{
  return X509_get_issuer_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_issuer_name(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_issuer_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_issuer_name _cffi_d_X509_get_issuer_name
#endif

static EVP_PKEY * _cffi_d_X509_get_pubkey(X509 * x0)
{
  return X509_get_pubkey(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_pubkey(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_pubkey(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_pubkey _cffi_d_X509_get_pubkey
#endif

static ASN1_INTEGER * _cffi_d_X509_get_serialNumber(X509 * x0)
{
  return X509_get_serialNumber(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_serialNumber(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_INTEGER * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_serialNumber(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(8));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_serialNumber _cffi_d_X509_get_serialNumber
#endif

static X509_NAME * _cffi_d_X509_get_subject_name(X509 const * x0)
{
  return X509_get_subject_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_subject_name(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_subject_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_subject_name _cffi_d_X509_get_subject_name
#endif

static long _cffi_d_X509_get_version(X509 * x0)
{
  return X509_get_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_get_version(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_get_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_get_version _cffi_d_X509_get_version
#endif

static ASN1_OCTET_STRING * _cffi_d_X509_getm_notAfter(X509 const * x0)
{
  return X509_getm_notAfter(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_getm_notAfter(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_getm_notAfter(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_getm_notAfter _cffi_d_X509_getm_notAfter
#endif

static ASN1_OCTET_STRING * _cffi_d_X509_getm_notBefore(X509 const * x0)
{
  return X509_getm_notBefore(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_getm_notBefore(PyObject *self, PyObject *arg0)
{
  X509 const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_getm_notBefore(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_getm_notBefore _cffi_d_X509_getm_notBefore
#endif

static ASN1_OCTET_STRING * _cffi_d_X509_gmtime_adj(ASN1_OCTET_STRING * x0, long x1)
{
  return X509_gmtime_adj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_gmtime_adj(PyObject *self, PyObject *args)
{
  ASN1_OCTET_STRING * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ASN1_OCTET_STRING * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_gmtime_adj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(23), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ASN1_OCTET_STRING *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(23), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_gmtime_adj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_gmtime_adj _cffi_d_X509_gmtime_adj
#endif

static X509 * _cffi_d_X509_new(void)
{
  return X509_new();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_new(PyObject *self, PyObject *noarg)
{
  X509 * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_new(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  return pyresult;
}
#else
#  define _cffi_f_X509_new _cffi_d_X509_new
#endif

static int _cffi_d_X509_print_ex(BIO * x0, X509 * x1, unsigned long x2, unsigned long x3)
{
  return X509_print_ex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_print_ex(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * x1;
  unsigned long x2;
  unsigned long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "X509_print_ex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long);
  if (x2 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long);
  if (x3 == (unsigned long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_print_ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_print_ex _cffi_d_X509_print_ex
#endif

static int _cffi_d_X509_set_issuer_name(X509 * x0, X509_NAME * x1)
{
  return X509_set_issuer_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_set_issuer_name(PyObject *self, PyObject *args)
{
  X509 * x0;
  X509_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_set_issuer_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_set_issuer_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_set_issuer_name _cffi_d_X509_set_issuer_name
#endif

static int _cffi_d_X509_set_pubkey(X509 * x0, EVP_PKEY * x1)
{
  return X509_set_pubkey(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_set_pubkey(PyObject *self, PyObject *args)
{
  X509 * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_set_pubkey", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_set_pubkey(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_set_pubkey _cffi_d_X509_set_pubkey
#endif

static int _cffi_d_X509_set_serialNumber(X509 * x0, ASN1_INTEGER * x1)
{
  return X509_set_serialNumber(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_set_serialNumber(PyObject *self, PyObject *args)
{
  X509 * x0;
  ASN1_INTEGER * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_set_serialNumber", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(8), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(8), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_set_serialNumber(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_set_serialNumber _cffi_d_X509_set_serialNumber
#endif

static int _cffi_d_X509_set_subject_name(X509 * x0, X509_NAME * x1)
{
  return X509_set_subject_name(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_set_subject_name(PyObject *self, PyObject *args)
{
  X509 * x0;
  X509_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_set_subject_name", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_set_subject_name(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_set_subject_name _cffi_d_X509_set_subject_name
#endif

static int _cffi_d_X509_set_version(X509 * x0, long x1)
{
  return X509_set_version(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_set_version(PyObject *self, PyObject *args)
{
  X509 * x0;
  long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "X509_set_version", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, long);
  if (x1 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_set_version(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_set_version _cffi_d_X509_set_version
#endif

static int _cffi_d_X509_sign(X509 * x0, EVP_PKEY * x1, EVP_MD const * x2)
{
  return X509_sign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_sign(PyObject *self, PyObject *args)
{
  X509 * x0;
  EVP_PKEY * x1;
  EVP_MD const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "X509_sign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(587), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (EVP_MD const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(587), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_sign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_sign _cffi_d_X509_sign
#endif

static unsigned long _cffi_d_X509_subject_name_hash(X509 * x0)
{
  return X509_subject_name_hash(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_subject_name_hash(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_subject_name_hash(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_subject_name_hash _cffi_d_X509_subject_name_hash
#endif

static int _cffi_d_X509_up_ref(X509 * x0)
{
  return X509_up_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_up_ref(PyObject *self, PyObject *arg0)
{
  X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_up_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_up_ref _cffi_d_X509_up_ref
#endif

static int _cffi_d_X509_verify_cert(X509_STORE_CTX * x0)
{
  return X509_verify_cert(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_verify_cert(PyObject *self, PyObject *arg0)
{
  X509_STORE_CTX * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(65), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_STORE_CTX *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(65), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_verify_cert(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_X509_verify_cert _cffi_d_X509_verify_cert
#endif

static char const * _cffi_d_X509_verify_cert_error_string(long x0)
{
  return X509_verify_cert_error_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_X509_verify_cert_error_string(PyObject *self, PyObject *arg0)
{
  long x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, long);
  if (x0 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = X509_verify_cert_error_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(50));
  return pyresult;
}
#else
#  define _cffi_f_X509_verify_cert_error_string _cffi_d_X509_verify_cert_error_string
#endif

static PKCS12 * _cffi_d_d2i_PKCS12_bio(BIO * x0, PKCS12 * * x1)
{
  return d2i_PKCS12_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_PKCS12_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS12 * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PKCS12 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_PKCS12_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (PKCS12 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_PKCS12_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(456));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_PKCS12_bio _cffi_d_d2i_PKCS12_bio
#endif

static PKCS7 * _cffi_d_d2i_PKCS7_bio(BIO * x0, PKCS7 * * x1)
{
  return d2i_PKCS7_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_PKCS7_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS7 * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PKCS7 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_PKCS7_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(173), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (PKCS7 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(173), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_PKCS7_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(656));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_PKCS7_bio _cffi_d_d2i_PKCS7_bio
#endif

static EVP_PKEY * _cffi_d_d2i_PUBKEY_bio(BIO * x0, EVP_PKEY * * x1)
{
  return d2i_PUBKEY_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_PUBKEY_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_PUBKEY_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_PUBKEY_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_PUBKEY_bio _cffi_d_d2i_PUBKEY_bio
#endif

static EVP_PKEY * _cffi_d_d2i_PrivateKey_bio(BIO * x0, EVP_PKEY * * x1)
{
  return d2i_PrivateKey_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_PrivateKey_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  EVP_PKEY * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_PrivateKey_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(116), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(116), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_PrivateKey_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(158));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_PrivateKey_bio _cffi_d_d2i_PrivateKey_bio
#endif

static X509_CRL * _cffi_d_d2i_X509_CRL_bio(BIO * x0, X509_CRL * * x1)
{
  return d2i_X509_CRL_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_X509_CRL_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_CRL * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_X509_CRL_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_X509_CRL_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(81));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_X509_CRL_bio _cffi_d_d2i_X509_CRL_bio
#endif

static X509_REQ * _cffi_d_d2i_X509_REQ_bio(BIO * x0, X509_REQ * * x1)
{
  return d2i_X509_REQ_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_X509_REQ_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_REQ * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_X509_REQ_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(314), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REQ * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(314), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_X509_REQ_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(137));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_X509_REQ_bio _cffi_d_d2i_X509_REQ_bio
#endif

static X509 * _cffi_d_d2i_X509_bio(BIO * x0, X509 * * x1)
{
  return d2i_X509_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_d2i_X509_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "d2i_X509_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(218), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(218), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = d2i_X509_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_d2i_X509_bio _cffi_d_d2i_X509_bio
#endif

static int _cffi_d_i2a_ASN1_INTEGER(BIO * x0, ASN1_INTEGER const * x1)
{
  return i2a_ASN1_INTEGER(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2a_ASN1_INTEGER(PyObject *self, PyObject *args)
{
  BIO * x0;
  ASN1_INTEGER const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2a_ASN1_INTEGER", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(435), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ASN1_INTEGER const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(435), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2a_ASN1_INTEGER(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2a_ASN1_INTEGER _cffi_d_i2a_ASN1_INTEGER
#endif

static int _cffi_d_i2d_PKCS12_bio(BIO * x0, PKCS12 * x1)
{
  return i2d_PKCS12_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_PKCS12_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  PKCS12 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_PKCS12_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (PKCS12 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_PKCS12_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_PKCS12_bio _cffi_d_i2d_PKCS12_bio
#endif

static int _cffi_d_i2d_PUBKEY_bio(BIO * x0, EVP_PKEY * x1)
{
  return i2d_PUBKEY_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_PUBKEY_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_PUBKEY_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_PUBKEY_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_PUBKEY_bio _cffi_d_i2d_PUBKEY_bio
#endif

static int _cffi_d_i2d_PrivateKey_bio(BIO * x0, EVP_PKEY * x1)
{
  return i2d_PrivateKey_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_PrivateKey_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  EVP_PKEY * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_PrivateKey_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(158), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (EVP_PKEY *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(158), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_PrivateKey_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_PrivateKey_bio _cffi_d_i2d_PrivateKey_bio
#endif

static int _cffi_d_i2d_X509_CRL_bio(BIO * x0, X509_CRL * x1)
{
  return i2d_X509_CRL_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_X509_CRL_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_CRL * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_X509_CRL_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_CRL *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_X509_CRL_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_X509_CRL_bio _cffi_d_i2d_X509_CRL_bio
#endif

static int _cffi_d_i2d_X509_NAME(X509_NAME * x0, unsigned char * * x1)
{
  return i2d_X509_NAME(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_X509_NAME(PyObject *self, PyObject *args)
{
  X509_NAME * x0;
  unsigned char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_X509_NAME", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(959), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(959), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_X509_NAME(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_X509_NAME _cffi_d_i2d_X509_NAME
#endif

static int _cffi_d_i2d_X509_REQ_bio(BIO * x0, X509_REQ * x1)
{
  return i2d_X509_REQ_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_X509_REQ_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509_REQ * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_X509_REQ_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(137), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_REQ *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(137), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_X509_REQ_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_X509_REQ_bio _cffi_d_i2d_X509_REQ_bio
#endif

static int _cffi_d_i2d_X509_bio(BIO * x0, X509 * x1)
{
  return i2d_X509_bio(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_i2d_X509_bio(PyObject *self, PyObject *args)
{
  BIO * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "i2d_X509_bio", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(84), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (BIO *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(84), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = i2d_X509_bio(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_i2d_X509_bio _cffi_d_i2d_X509_bio
#endif

static int _cffi_d_sk_GENERAL_NAME_num(GENERAL_NAMES * x0)
{
  return sk_GENERAL_NAME_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_GENERAL_NAME_num(PyObject *self, PyObject *arg0)
{
  GENERAL_NAMES * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(142), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GENERAL_NAMES *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(142), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_GENERAL_NAME_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_GENERAL_NAME_num _cffi_d_sk_GENERAL_NAME_num
#endif

static GENERAL_NAME * _cffi_d_sk_GENERAL_NAME_value(GENERAL_NAMES * x0, int x1)
{
  return sk_GENERAL_NAME_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_GENERAL_NAME_value(PyObject *self, PyObject *args)
{
  GENERAL_NAMES * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  GENERAL_NAME * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_GENERAL_NAME_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(142), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (GENERAL_NAMES *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(142), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_GENERAL_NAME_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(452));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_GENERAL_NAME_value _cffi_d_sk_GENERAL_NAME_value
#endif

static void _cffi_d_sk_X509_EXTENSION_free(X509_EXTENSIONS * x0)
{
  sk_X509_EXTENSION_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_free(PyObject *self, PyObject *arg0)
{
  X509_EXTENSIONS * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sk_X509_EXTENSION_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_free _cffi_d_sk_X509_EXTENSION_free
#endif

static X509_EXTENSIONS * _cffi_d_sk_X509_EXTENSION_new_null(void)
{
  return sk_X509_EXTENSION_new_null();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_new_null(PyObject *self, PyObject *noarg)
{
  X509_EXTENSIONS * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_EXTENSION_new_null(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(270));
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_new_null _cffi_d_sk_X509_EXTENSION_new_null
#endif

static int _cffi_d_sk_X509_EXTENSION_num(X509_EXTENSIONS * x0)
{
  return sk_X509_EXTENSION_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_num(PyObject *self, PyObject *arg0)
{
  X509_EXTENSIONS * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_EXTENSION_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_num _cffi_d_sk_X509_EXTENSION_num
#endif

static void _cffi_d_sk_X509_EXTENSION_pop_free(X509_EXTENSIONS * x0, void(* x1)(X509_EXTENSION *))
{
  sk_X509_EXTENSION_pop_free(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_pop_free(PyObject *self, PyObject *args)
{
  X509_EXTENSIONS * x0;
  void(* x1)(X509_EXTENSION *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_EXTENSION_pop_free", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(X509_EXTENSION *))_cffi_to_c_pointer(arg1, _cffi_type(1461));
  if (x1 == (void(*)(X509_EXTENSION *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sk_X509_EXTENSION_pop_free(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_pop_free _cffi_d_sk_X509_EXTENSION_pop_free
#endif

static int _cffi_d_sk_X509_EXTENSION_push(X509_EXTENSIONS * x0, X509_EXTENSION * x1)
{
  return sk_X509_EXTENSION_push(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_push(PyObject *self, PyObject *args)
{
  X509_EXTENSIONS * x0;
  X509_EXTENSION * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_EXTENSION_push", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_EXTENSION *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_EXTENSION_push(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_push _cffi_d_sk_X509_EXTENSION_push
#endif

static X509_EXTENSION * _cffi_d_sk_X509_EXTENSION_value(X509_EXTENSIONS * x0, int x1)
{
  return sk_X509_EXTENSION_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_EXTENSION_value(PyObject *self, PyObject *args)
{
  X509_EXTENSIONS * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_EXTENSION * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_EXTENSION_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(270), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (X509_EXTENSIONS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(270), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_EXTENSION_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_EXTENSION_value _cffi_d_sk_X509_EXTENSION_value
#endif

static void _cffi_d_sk_X509_NAME_free(Cryptography_STACK_OF_X509_NAME * x0)
{
  sk_X509_NAME_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_NAME_free(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509_NAME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sk_X509_NAME_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sk_X509_NAME_free _cffi_d_sk_X509_NAME_free
#endif

static Cryptography_STACK_OF_X509_NAME * _cffi_d_sk_X509_NAME_new_null(void)
{
  return sk_X509_NAME_new_null();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_NAME_new_null(PyObject *self, PyObject *noarg)
{
  Cryptography_STACK_OF_X509_NAME * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_NAME_new_null(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(287));
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_NAME_new_null _cffi_d_sk_X509_NAME_new_null
#endif

static int _cffi_d_sk_X509_NAME_num(Cryptography_STACK_OF_X509_NAME * x0)
{
  return sk_X509_NAME_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_NAME_num(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509_NAME * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_NAME_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_NAME_num _cffi_d_sk_X509_NAME_num
#endif

static int _cffi_d_sk_X509_NAME_push(Cryptography_STACK_OF_X509_NAME * x0, X509_NAME * x1)
{
  return sk_X509_NAME_push(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_NAME_push(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509_NAME * x0;
  X509_NAME * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_NAME_push", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(297), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(297), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_NAME_push(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_NAME_push _cffi_d_sk_X509_NAME_push
#endif

static X509_NAME * _cffi_d_sk_X509_NAME_value(Cryptography_STACK_OF_X509_NAME * x0, int x1)
{
  return sk_X509_NAME_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_NAME_value(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509_NAME * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_NAME * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_NAME_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_NAME *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_NAME_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(297));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_NAME_value _cffi_d_sk_X509_NAME_value
#endif

static int _cffi_d_sk_X509_OBJECT_num(Cryptography_STACK_OF_X509_OBJECT * x0)
{
  return sk_X509_OBJECT_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_OBJECT_num(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509_OBJECT * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(518), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_OBJECT *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(518), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_OBJECT_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_OBJECT_num _cffi_d_sk_X509_OBJECT_num
#endif

static int _cffi_d_sk_X509_REVOKED_num(Cryptography_STACK_OF_X509_REVOKED * x0)
{
  return sk_X509_REVOKED_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_REVOKED_num(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509_REVOKED * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(325), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(325), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_REVOKED_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_REVOKED_num _cffi_d_sk_X509_REVOKED_num
#endif

static X509_REVOKED * _cffi_d_sk_X509_REVOKED_value(Cryptography_STACK_OF_X509_REVOKED * x0, int x1)
{
  return sk_X509_REVOKED_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_REVOKED_value(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509_REVOKED * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509_REVOKED * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_REVOKED_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(325), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509_REVOKED *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(325), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_REVOKED_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(274));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_REVOKED_value _cffi_d_sk_X509_REVOKED_value
#endif

static void _cffi_d_sk_X509_free(Cryptography_STACK_OF_X509 * x0)
{
  sk_X509_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_free(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sk_X509_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sk_X509_free _cffi_d_sk_X509_free
#endif

static Cryptography_STACK_OF_X509 * _cffi_d_sk_X509_new_null(void)
{
  return sk_X509_new_null();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_new_null(PyObject *self, PyObject *noarg)
{
  Cryptography_STACK_OF_X509 * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_new_null(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(160));
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_new_null _cffi_d_sk_X509_new_null
#endif

static int _cffi_d_sk_X509_num(Cryptography_STACK_OF_X509 * x0)
{
  return sk_X509_num(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_num(PyObject *self, PyObject *arg0)
{
  Cryptography_STACK_OF_X509 * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_num(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_num _cffi_d_sk_X509_num
#endif

static int _cffi_d_sk_X509_push(Cryptography_STACK_OF_X509 * x0, X509 * x1)
{
  return sk_X509_push(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_push(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509 * x0;
  X509 * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_push", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(11), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(11), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_push(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_push _cffi_d_sk_X509_push
#endif

static X509 * _cffi_d_sk_X509_value(Cryptography_STACK_OF_X509 * x0, int x1)
{
  return sk_X509_value(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sk_X509_value(PyObject *self, PyObject *args)
{
  Cryptography_STACK_OF_X509 * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  X509 * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sk_X509_value", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(160), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Cryptography_STACK_OF_X509 *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(160), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sk_X509_value(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(11));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_sk_X509_value _cffi_d_sk_X509_value
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld__ASN1_OCTET_STRING(ASN1_OCTET_STRING *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->length) | 0);  /* check that 'ASN1_OCTET_STRING.length' is an integer */
  (void)((p->type) | 0);  /* check that 'ASN1_OCTET_STRING.type' is an integer */
  { unsigned char * *tmp = &p->data; (void)tmp; }
  (void)((p->flags) | 0);  /* check that 'ASN1_OCTET_STRING.flags' is an integer */
}
struct _cffi_align__ASN1_OCTET_STRING { char x; ASN1_OCTET_STRING y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ASN1_ENUMERATED_free", (void *)_cffi_f_ASN1_ENUMERATED_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1240), (void *)_cffi_d_ASN1_ENUMERATED_free },
  { "ASN1_ENUMERATED_new", (void *)_cffi_f_ASN1_ENUMERATED_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_ASN1_ENUMERATED_new },
  { "ASN1_ENUMERATED_set", (void *)_cffi_f_ASN1_ENUMERATED_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ASN1_ENUMERATED_set },
  { "ASN1_GENERALIZEDTIME_free", (void *)_cffi_f_ASN1_GENERALIZEDTIME_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1243), (void *)_cffi_d_ASN1_GENERALIZEDTIME_free },
  { "ASN1_INTEGER_free", (void *)_cffi_f_ASN1_INTEGER_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1246), (void *)_cffi_d_ASN1_INTEGER_free },
  { "ASN1_INTEGER_set", (void *)_cffi_f_ASN1_INTEGER_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 387), (void *)_cffi_d_ASN1_INTEGER_set },
  { "ASN1_INTEGER_to_BN", (void *)_cffi_f_ASN1_INTEGER_to_BN, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_ASN1_INTEGER_to_BN },
  { "ASN1_STRING_get0_data", (void *)_cffi_f_ASN1_STRING_get0_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1205), (void *)_cffi_d_ASN1_STRING_get0_data },
  { "ASN1_STRING_length", (void *)_cffi_f_ASN1_STRING_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 394), (void *)_cffi_d_ASN1_STRING_length },
  { "ASN1_STRING_to_UTF8", (void *)_cffi_f_ASN1_STRING_to_UTF8, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1070), (void *)_cffi_d_ASN1_STRING_to_UTF8 },
  { "ASN1_STRING_type", (void *)_cffi_f_ASN1_STRING_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 401), (void *)_cffi_d_ASN1_STRING_type },
  { "ASN1_TIME_free", (void *)_cffi_f_ASN1_TIME_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1255), (void *)_cffi_d_ASN1_TIME_free },
  { "ASN1_TIME_new", (void *)_cffi_f_ASN1_TIME_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 35), (void *)_cffi_d_ASN1_TIME_new },
  { "ASN1_TIME_set_string", (void *)_cffi_f_ASN1_TIME_set_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 397), (void *)_cffi_d_ASN1_TIME_set_string },
  { "ASN1_TIME_to_generalizedtime", (void *)_cffi_f_ASN1_TIME_to_generalizedtime, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 2), (void *)_cffi_d_ASN1_TIME_to_generalizedtime },
  { "BIO_ADDR_free", (void *)_cffi_f_BIO_ADDR_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1261), (void *)_cffi_d_BIO_ADDR_free },
  { "BIO_ADDR_new", (void *)_cffi_f_BIO_ADDR_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 57), (void *)_cffi_d_BIO_ADDR_new },
  { "BIO_free", (void *)_cffi_f_BIO_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_free },
  { "BIO_get_mem_data", (void *)_cffi_f_BIO_get_mem_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1086), (void *)_cffi_d_BIO_get_mem_data },
  { "BIO_new", (void *)_cffi_f_BIO_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 46), (void *)_cffi_d_BIO_new },
  { "BIO_new_file", (void *)_cffi_f_BIO_new_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_BIO_new_file },
  { "BIO_new_mem_buf", (void *)_cffi_f_BIO_new_mem_buf, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 53), (void *)_cffi_d_BIO_new_mem_buf },
  { "BIO_read", (void *)_cffi_f_BIO_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 493), (void *)_cffi_d_BIO_read },
  { "BIO_reset", (void *)_cffi_f_BIO_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_reset },
  { "BIO_s_mem", (void *)_cffi_f_BIO_s_mem, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 59), (void *)_cffi_d_BIO_s_mem },
  { "BIO_set_mem_eof_return", (void *)_cffi_f_BIO_set_mem_eof_return, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1090), (void *)_cffi_d_BIO_set_mem_eof_return },
  { "BIO_should_io_special", (void *)_cffi_f_BIO_should_io_special, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_should_io_special },
  { "BIO_should_read", (void *)_cffi_f_BIO_should_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_should_read },
  { "BIO_should_retry", (void *)_cffi_f_BIO_should_retry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_should_retry },
  { "BIO_should_write", (void *)_cffi_f_BIO_should_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 430), (void *)_cffi_d_BIO_should_write },
  { "BIO_write", (void *)_cffi_f_BIO_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 498), (void *)_cffi_d_BIO_write },
  { "BN_bn2hex", (void *)_cffi_f_BN_bn2hex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 348), (void *)_cffi_d_BN_bn2hex },
  { "BN_free", (void *)_cffi_f_BN_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1258), (void *)_cffi_d_BN_free },
  { "BN_generate_prime_ex", (void *)_cffi_f_BN_generate_prime_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 416), (void *)_cffi_d_BN_generate_prime_ex },
  { "BN_hex2bn", (void *)_cffi_f_BN_hex2bn, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 404), (void *)_cffi_d_BN_hex2bn },
  { "BN_is_prime_ex", (void *)_cffi_f_BN_is_prime_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 424), (void *)_cffi_d_BN_is_prime_ex },
  { "BN_new", (void *)_cffi_f_BN_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 44), (void *)_cffi_d_BN_new },
  { "BN_prime_checks_for_size", (void *)_cffi_f_BN_prime_checks_for_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1063), (void *)_cffi_d_BN_prime_checks_for_size },
  { "BN_rand_range", (void *)_cffi_f_BN_rand_range, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 408), (void *)_cffi_d_BN_rand_range },
  { "BN_set_word", (void *)_cffi_f_BN_set_word, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 412), (void *)_cffi_d_BN_set_word },
  { "BN_to_ASN1_INTEGER", (void *)_cffi_f_BN_to_ASN1_INTEGER, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 6), (void *)_cffi_d_BN_to_ASN1_INTEGER },
  { "CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH", (void *)_cffi_const_CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_IS_BORINGSSL", (void *)_cffi_const_CRYPTOGRAPHY_IS_BORINGSSL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_IS_LIBRESSL", (void *)_cffi_const_CRYPTOGRAPHY_IS_LIBRESSL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380", (void *)_cffi_const_CRYPTOGRAPHY_LIBRESSL_LESS_THAN_380, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_OPENSSL_300_OR_GREATER", (void *)_cffi_const_CRYPTOGRAPHY_OPENSSL_300_OR_GREATER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_OPENSSL_320_OR_GREATER", (void *)_cffi_const_CRYPTOGRAPHY_OPENSSL_320_OR_GREATER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E", (void *)_cffi_const_CRYPTOGRAPHY_OPENSSL_LESS_THAN_111E, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CRYPTOGRAPHY_PACKAGE_VERSION", (void *)_cffi_const_CRYPTOGRAPHY_PACKAGE_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT, 50), (void *)0 },
  { "Cryptography_DTLSv1_get_timeout", (void *)_cffi_f_Cryptography_DTLSv1_get_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1101), (void *)_cffi_d_Cryptography_DTLSv1_get_timeout },
  { "Cryptography_HAS_300_EVP_CIPHER", (void *)_cffi_const_Cryptography_HAS_300_EVP_CIPHER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_300_FIPS", (void *)_cffi_const_Cryptography_HAS_300_FIPS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_ALPN", (void *)_cffi_const_Cryptography_HAS_ALPN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_CUSTOM_EXT", (void *)_cffi_const_Cryptography_HAS_CUSTOM_EXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_DTLS_GET_DATA_MTU", (void *)_cffi_const_Cryptography_HAS_DTLS_GET_DATA_MTU, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_ED448", (void *)_cffi_const_Cryptography_HAS_ED448, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_ENGINE", (void *)_cffi_const_Cryptography_HAS_ENGINE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_EVP_PKEY_DHX", (void *)_cffi_const_Cryptography_HAS_EVP_PKEY_DHX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_GET_EXTMS_SUPPORT", (void *)_cffi_const_Cryptography_HAS_GET_EXTMS_SUPPORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_IMPLICIT_RSA_REJECTION", (void *)_cffi_const_Cryptography_HAS_IMPLICIT_RSA_REJECTION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_KEYLOG", (void *)_cffi_const_Cryptography_HAS_KEYLOG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_NEXTPROTONEG", (void *)_cffi_const_Cryptography_HAS_NEXTPROTONEG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_OP_NO_RENEGOTIATION", (void *)_cffi_const_Cryptography_HAS_OP_NO_RENEGOTIATION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PKCS12_SET_MAC", (void *)_cffi_const_Cryptography_HAS_PKCS12_SET_MAC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PKCS7_FUNCS", (void *)_cffi_const_Cryptography_HAS_PKCS7_FUNCS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_POLY1305", (void *)_cffi_const_Cryptography_HAS_POLY1305, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PRIME_CHECKS", (void *)_cffi_const_Cryptography_HAS_PRIME_CHECKS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PROVIDERS", (void *)_cffi_const_Cryptography_HAS_PROVIDERS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PSK", (void *)_cffi_const_Cryptography_HAS_PSK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_PSK_TLSv1_3", (void *)_cffi_const_Cryptography_HAS_PSK_TLSv1_3, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SCRYPT", (void *)_cffi_const_Cryptography_HAS_SCRYPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SET_CERT_CB", (void *)_cffi_const_Cryptography_HAS_SET_CERT_CB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SIGALGS", (void *)_cffi_const_Cryptography_HAS_SIGALGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SRTP", (void *)_cffi_const_Cryptography_HAS_SRTP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SSL_COOKIE", (void *)_cffi_const_Cryptography_HAS_SSL_COOKIE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF", (void *)_cffi_const_Cryptography_HAS_SSL_OP_IGNORE_UNEXPECTED_EOF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_SSL_ST", (void *)_cffi_const_Cryptography_HAS_SSL_ST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_TLS_ST", (void *)_cffi_const_Cryptography_HAS_TLS_ST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_TLSv1_3_FUNCTIONS", (void *)_cffi_const_Cryptography_HAS_TLSv1_3_FUNCTIONS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING", (void *)_cffi_const_Cryptography_HAS_UNEXPECTED_EOF_WHILE_READING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_HAS_VERIFIED_CHAIN", (void *)_cffi_const_Cryptography_HAS_VERIFIED_CHAIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Cryptography_SSL_SESSION_new", (void *)_cffi_f_Cryptography_SSL_SESSION_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 214), (void *)_cffi_d_Cryptography_SSL_SESSION_new },
  { "DH_free", (void *)_cffi_f_DH_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1270), (void *)_cffi_d_DH_free },
  { "DSA_free", (void *)_cffi_f_DSA_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1273), (void *)_cffi_d_DSA_free },
  { "DSA_generate_key", (void *)_cffi_f_DSA_generate_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 523), (void *)_cffi_d_DSA_generate_key },
  { "DSA_generate_parameters_ex", (void *)_cffi_f_DSA_generate_parameters_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 526), (void *)_cffi_d_DSA_generate_parameters_ex },
  { "DSA_new", (void *)_cffi_f_DSA_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 89), (void *)_cffi_d_DSA_new },
  { "DTLS_client_method", (void *)_cffi_f_DTLS_client_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_DTLS_client_method },
  { "DTLS_get_data_mtu", (void *)_cffi_f_DTLS_get_data_mtu, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1166), (void *)_cffi_d_DTLS_get_data_mtu },
  { "DTLS_method", (void *)_cffi_f_DTLS_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_DTLS_method },
  { "DTLS_server_method", (void *)_cffi_f_DTLS_server_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_DTLS_server_method },
  { "DTLSv1_handle_timeout", (void *)_cffi_f_DTLSv1_handle_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1094), (void *)_cffi_d_DTLSv1_handle_timeout },
  { "DTLSv1_listen", (void *)_cffi_f_DTLSv1_listen, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 675), (void *)_cffi_d_DTLSv1_listen },
  { "EC_KEY_free", (void *)_cffi_f_EC_KEY_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1276), (void *)_cffi_d_EC_KEY_free },
  { "EC_KEY_new_by_curve_name", (void *)_cffi_f_EC_KEY_new_by_curve_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 91), (void *)_cffi_d_EC_KEY_new_by_curve_name },
  { "EC_curve_nid2nist", (void *)_cffi_f_EC_curve_nid2nist, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 372), (void *)_cffi_d_EC_curve_nid2nist },
  { "EC_get_builtin_curves", (void *)_cffi_f_EC_get_builtin_curves, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1162), (void *)_cffi_d_EC_get_builtin_curves },
  { "ENGINE_by_id", (void *)_cffi_f_ENGINE_by_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 94), (void *)_cffi_d_ENGINE_by_id },
  { "ENGINE_ctrl_cmd", (void *)_cffi_f_ENGINE_ctrl_cmd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 544), (void *)_cffi_d_ENGINE_ctrl_cmd },
  { "ENGINE_ctrl_cmd_string", (void *)_cffi_f_ENGINE_ctrl_cmd_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 538), (void *)_cffi_d_ENGINE_ctrl_cmd_string },
  { "ENGINE_finish", (void *)_cffi_f_ENGINE_finish, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 535), (void *)_cffi_d_ENGINE_finish },
  { "ENGINE_free", (void *)_cffi_f_ENGINE_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 535), (void *)_cffi_d_ENGINE_free },
  { "ENGINE_get_default_RAND", (void *)_cffi_f_ENGINE_get_default_RAND, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 97), (void *)_cffi_d_ENGINE_get_default_RAND },
  { "ENGINE_get_name", (void *)_cffi_f_ENGINE_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 359), (void *)_cffi_d_ENGINE_get_name },
  { "ENGINE_init", (void *)_cffi_f_ENGINE_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 535), (void *)_cffi_d_ENGINE_init },
  { "ENGINE_load_builtin_engines", (void *)_cffi_f_ENGINE_load_builtin_engines, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1520), (void *)_cffi_d_ENGINE_load_builtin_engines },
  { "ENGINE_load_private_key", (void *)_cffi_f_ENGINE_load_private_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 124), (void *)_cffi_d_ENGINE_load_private_key },
  { "ENGINE_load_public_key", (void *)_cffi_f_ENGINE_load_public_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 124), (void *)_cffi_d_ENGINE_load_public_key },
  { "ENGINE_set_default_RAND", (void *)_cffi_f_ENGINE_set_default_RAND, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 535), (void *)_cffi_d_ENGINE_set_default_RAND },
  { "ENGINE_unregister_RAND", (void *)_cffi_f_ENGINE_unregister_RAND, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1279), (void *)_cffi_d_ENGINE_unregister_RAND },
  { "ERR_GET_REASON", (void *)_cffi_f_ERR_GET_REASON, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1081), (void *)_cffi_d_ERR_GET_REASON },
  { "ERR_LIB_EVP", (void *)_cffi_const_ERR_LIB_EVP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ERR_LIB_PKCS12", (void *)_cffi_const_ERR_LIB_PKCS12, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ERR_LIB_PROV", (void *)_cffi_const_ERR_LIB_PROV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ERR_clear_error", (void *)_cffi_f_ERR_clear_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1520), (void *)_cffi_d_ERR_clear_error },
  { "ERR_func_error_string", (void *)_cffi_f_ERR_func_error_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 378), (void *)_cffi_d_ERR_func_error_string },
  { "ERR_get_error", (void *)_cffi_f_ERR_get_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1228), (void *)_cffi_d_ERR_get_error },
  { "ERR_lib_error_string", (void *)_cffi_f_ERR_lib_error_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 378), (void *)_cffi_d_ERR_lib_error_string },
  { "ERR_peek_error", (void *)_cffi_f_ERR_peek_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1228), (void *)_cffi_d_ERR_peek_error },
  { "ERR_put_error", (void *)_cffi_f_ERR_put_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1496), (void *)_cffi_d_ERR_put_error },
  { "ERR_reason_error_string", (void *)_cffi_f_ERR_reason_error_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 378), (void *)_cffi_d_ERR_reason_error_string },
  { "EVP_CIPHER_CTX_ctrl", (void *)_cffi_f_EVP_CIPHER_CTX_ctrl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 567), (void *)_cffi_d_EVP_CIPHER_CTX_ctrl },
  { "EVP_CIPHER_CTX_free", (void *)_cffi_f_EVP_CIPHER_CTX_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1285), (void *)_cffi_d_EVP_CIPHER_CTX_free },
  { "EVP_CIPHER_CTX_new", (void *)_cffi_f_EVP_CIPHER_CTX_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 107), (void *)_cffi_d_EVP_CIPHER_CTX_new },
  { "EVP_CIPHER_CTX_reset", (void *)_cffi_f_EVP_CIPHER_CTX_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 552), (void *)_cffi_d_EVP_CIPHER_CTX_reset },
  { "EVP_CIPHER_CTX_set_key_length", (void *)_cffi_f_EVP_CIPHER_CTX_set_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 563), (void *)_cffi_d_EVP_CIPHER_CTX_set_key_length },
  { "EVP_CIPHER_CTX_set_padding", (void *)_cffi_f_EVP_CIPHER_CTX_set_padding, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 563), (void *)_cffi_d_EVP_CIPHER_CTX_set_padding },
  { "EVP_CIPHER_fetch", (void *)_cffi_f_EVP_CIPHER_fetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 99), (void *)_cffi_d_EVP_CIPHER_fetch },
  { "EVP_CIPHER_free", (void *)_cffi_f_EVP_CIPHER_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1282), (void *)_cffi_d_EVP_CIPHER_free },
  { "EVP_CTRL_AEAD_GET_TAG", (void *)_cffi_const_EVP_CTRL_AEAD_GET_TAG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_CTRL_AEAD_SET_IVLEN", (void *)_cffi_const_EVP_CTRL_AEAD_SET_IVLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_CTRL_AEAD_SET_TAG", (void *)_cffi_const_EVP_CTRL_AEAD_SET_TAG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_CipherFinal_ex", (void *)_cffi_f_EVP_CipherFinal_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 573), (void *)_cffi_d_EVP_CipherFinal_ex },
  { "EVP_CipherInit_ex", (void *)_cffi_f_EVP_CipherInit_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 555), (void *)_cffi_d_EVP_CipherInit_ex },
  { "EVP_CipherUpdate", (void *)_cffi_f_EVP_CipherUpdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 578), (void *)_cffi_d_EVP_CipherUpdate },
  { "EVP_F_EVP_ENCRYPTFINAL_EX", (void *)_cffi_const_EVP_F_EVP_ENCRYPTFINAL_EX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_MAX_MD_SIZE", (void *)_cffi_const_EVP_MAX_MD_SIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_MD_CTX_free", (void *)_cffi_f_EVP_MD_CTX_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1288), (void *)_cffi_d_EVP_MD_CTX_free },
  { "EVP_MD_CTX_new", (void *)_cffi_f_EVP_MD_CTX_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 112), (void *)_cffi_d_EVP_MD_CTX_new },
  { "EVP_PKEY_DH", (void *)_cffi_const_EVP_PKEY_DH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_DSA", (void *)_cffi_const_EVP_PKEY_DSA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_EC", (void *)_cffi_const_EVP_PKEY_EC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_ED25519", (void *)_cffi_const_EVP_PKEY_ED25519, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_ED448", (void *)_cffi_const_EVP_PKEY_ED448, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_RSA", (void *)_cffi_const_EVP_PKEY_RSA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_RSA_PSS", (void *)_cffi_const_EVP_PKEY_RSA_PSS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_X25519", (void *)_cffi_const_EVP_PKEY_X25519, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_X448", (void *)_cffi_const_EVP_PKEY_X448, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_PKEY_assign_RSA", (void *)_cffi_f_EVP_PKEY_assign_RSA, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 613), (void *)_cffi_d_EVP_PKEY_assign_RSA },
  { "EVP_PKEY_bits", (void *)_cffi_f_EVP_PKEY_bits, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 617), (void *)_cffi_d_EVP_PKEY_bits },
  { "EVP_PKEY_free", (void *)_cffi_f_EVP_PKEY_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1291), (void *)_cffi_d_EVP_PKEY_free },
  { "EVP_PKEY_get1_RSA", (void *)_cffi_f_EVP_PKEY_get1_RSA, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 181), (void *)_cffi_d_EVP_PKEY_get1_RSA },
  { "EVP_PKEY_id", (void *)_cffi_f_EVP_PKEY_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 617), (void *)_cffi_d_EVP_PKEY_id },
  { "EVP_PKEY_new", (void *)_cffi_f_EVP_PKEY_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 139), (void *)_cffi_d_EVP_PKEY_new },
  { "EVP_PKEY_set1_DSA", (void *)_cffi_f_EVP_PKEY_set1_DSA, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 609), (void *)_cffi_d_EVP_PKEY_set1_DSA },
  { "EVP_PKEY_set1_RSA", (void *)_cffi_f_EVP_PKEY_set1_RSA, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 613), (void *)_cffi_d_EVP_PKEY_set1_RSA },
  { "EVP_PKEY_size", (void *)_cffi_f_EVP_PKEY_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 606), (void *)_cffi_d_EVP_PKEY_size },
  { "EVP_PKEY_type", (void *)_cffi_f_EVP_PKEY_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1063), (void *)_cffi_d_EVP_PKEY_type },
  { "EVP_R_BAD_DECRYPT", (void *)_cffi_const_EVP_R_BAD_DECRYPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH", (void *)_cffi_const_EVP_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM", (void *)_cffi_const_EVP_R_UNSUPPORTED_PRIVATE_KEY_ALGORITHM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_R_XTS_DUPLICATED_KEYS", (void *)_cffi_const_EVP_R_XTS_DUPLICATED_KEYS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVP_SignFinal", (void *)_cffi_f_EVP_SignFinal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 589), (void *)_cffi_d_EVP_SignFinal },
  { "EVP_SignInit", (void *)_cffi_f_EVP_SignInit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_EVP_SignInit },
  { "EVP_SignUpdate", (void *)_cffi_f_EVP_SignUpdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 601), (void *)_cffi_d_EVP_SignUpdate },
  { "EVP_VerifyFinal", (void *)_cffi_f_EVP_VerifyFinal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 595), (void *)_cffi_d_EVP_VerifyFinal },
  { "EVP_VerifyInit", (void *)_cffi_f_EVP_VerifyInit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_EVP_VerifyInit },
  { "EVP_VerifyUpdate", (void *)_cffi_f_EVP_VerifyUpdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 601), (void *)_cffi_d_EVP_VerifyUpdate },
  { "EVP_default_properties_enable_fips", (void *)_cffi_f_EVP_default_properties_enable_fips, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 632), (void *)_cffi_d_EVP_default_properties_enable_fips },
  { "EVP_get_cipherbyname", (void *)_cffi_f_EVP_get_cipherbyname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 104), (void *)_cffi_d_EVP_get_cipherbyname },
  { "EVP_get_digestbyname", (void *)_cffi_f_EVP_get_digestbyname, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 109), (void *)_cffi_d_EVP_get_digestbyname },
  { "GENERAL_NAMES_free", (void *)_cffi_f_GENERAL_NAMES_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1294), (void *)_cffi_d_GENERAL_NAMES_free },
  { "GENERAL_NAME_print", (void *)_cffi_f_GENERAL_NAME_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 450), (void *)_cffi_d_GENERAL_NAME_print },
  { "GEN_DNS", (void *)_cffi_const_GEN_DNS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GEN_EMAIL", (void *)_cffi_const_GEN_EMAIL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GEN_URI", (void *)_cffi_const_GEN_URI, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "MBSTRING_UTF8", (void *)_cffi_const_MBSTRING_UTF8, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NETSCAPE_SPKI_b64_encode", (void *)_cffi_f_NETSCAPE_SPKI_b64_encode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 351), (void *)_cffi_d_NETSCAPE_SPKI_b64_encode },
  { "NETSCAPE_SPKI_free", (void *)_cffi_f_NETSCAPE_SPKI_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1297), (void *)_cffi_d_NETSCAPE_SPKI_free },
  { "NETSCAPE_SPKI_get_pubkey", (void *)_cffi_f_NETSCAPE_SPKI_get_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_NETSCAPE_SPKI_get_pubkey },
  { "NETSCAPE_SPKI_new", (void *)_cffi_f_NETSCAPE_SPKI_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 145), (void *)_cffi_d_NETSCAPE_SPKI_new },
  { "NETSCAPE_SPKI_set_pubkey", (void *)_cffi_f_NETSCAPE_SPKI_set_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 623), (void *)_cffi_d_NETSCAPE_SPKI_set_pubkey },
  { "NETSCAPE_SPKI_sign", (void *)_cffi_f_NETSCAPE_SPKI_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 627), (void *)_cffi_d_NETSCAPE_SPKI_sign },
  { "NETSCAPE_SPKI_verify", (void *)_cffi_f_NETSCAPE_SPKI_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 623), (void *)_cffi_d_NETSCAPE_SPKI_verify },
  { "NID_aes_256_cbc", (void *)_cffi_const_NID_aes_256_cbc, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NID_crl_reason", (void *)_cffi_const_NID_crl_reason, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NID_pbe_WithSHA1And3_Key_TripleDES_CBC", (void *)_cffi_const_NID_pbe_WithSHA1And3_Key_TripleDES_CBC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NID_pkcs7_signed", (void *)_cffi_const_NID_pkcs7_signed, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NID_subject_alt_name", (void *)_cffi_const_NID_subject_alt_name, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NID_undef", (void *)_cffi_const_NID_undef, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OBJ_nid2ln", (void *)_cffi_f_OBJ_nid2ln, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 372), (void *)_cffi_d_OBJ_nid2ln },
  { "OBJ_nid2sn", (void *)_cffi_f_OBJ_nid2sn, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 372), (void *)_cffi_d_OBJ_nid2sn },
  { "OBJ_obj2nid", (void *)_cffi_f_OBJ_obj2nid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 391), (void *)_cffi_d_OBJ_obj2nid },
  { "OBJ_txt2nid", (void *)_cffi_f_OBJ_txt2nid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1060), (void *)_cffi_d_OBJ_txt2nid },
  { "OPENSSL_BUILT_ON", (void *)_cffi_const_OPENSSL_BUILT_ON, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_CFLAGS", (void *)_cffi_const_OPENSSL_CFLAGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_DIR", (void *)_cffi_const_OPENSSL_DIR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_PLATFORM", (void *)_cffi_const_OPENSSL_PLATFORM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_VERSION", (void *)_cffi_const_OPENSSL_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_VERSION_NUMBER", (void *)_cffi_const_OPENSSL_VERSION_NUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OPENSSL_VERSION_TEXT", (void *)_cffi_const_OPENSSL_VERSION_TEXT, _CFFI_OP(_CFFI_OP_CONSTANT, 50), (void *)0 },
  { "OPENSSL_cleanup", (void *)_cffi_f_OPENSSL_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1520), (void *)_cffi_d_OPENSSL_cleanup },
  { "OPENSSL_free", (void *)_cffi_f_OPENSSL_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1512), (void *)_cffi_d_OPENSSL_free },
  { "OPENSSL_malloc", (void *)_cffi_f_OPENSSL_malloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1237), (void *)_cffi_d_OPENSSL_malloc },
  { "OSSL_PROVIDER_load", (void *)_cffi_f_OSSL_PROVIDER_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 147), (void *)_cffi_d_OSSL_PROVIDER_load },
  { "OSSL_PROVIDER_unload", (void *)_cffi_f_OSSL_PROVIDER_unload, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 636), (void *)_cffi_d_OSSL_PROVIDER_unload },
  { "OpenSSL_version", (void *)_cffi_f_OpenSSL_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 372), (void *)_cffi_d_OpenSSL_version },
  { "OpenSSL_version_num", (void *)_cffi_f_OpenSSL_version_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1228), (void *)_cffi_d_OpenSSL_version_num },
  { "PEM_read_bio_DHparams", (void *)_cffi_f_PEM_read_bio_DHparams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_PEM_read_bio_DHparams },
  { "PEM_read_bio_PKCS7", (void *)_cffi_f_PEM_read_bio_PKCS7, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_PEM_read_bio_PKCS7 },
  { "PEM_read_bio_PUBKEY", (void *)_cffi_f_PEM_read_bio_PUBKEY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_PEM_read_bio_PUBKEY },
  { "PEM_read_bio_PrivateKey", (void *)_cffi_f_PEM_read_bio_PrivateKey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_PEM_read_bio_PrivateKey },
  { "PEM_read_bio_X509", (void *)_cffi_f_PEM_read_bio_X509, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 220), (void *)_cffi_d_PEM_read_bio_X509 },
  { "PEM_read_bio_X509_CRL", (void *)_cffi_f_PEM_read_bio_X509_CRL, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 248), (void *)_cffi_d_PEM_read_bio_X509_CRL },
  { "PEM_read_bio_X509_REQ", (void *)_cffi_f_PEM_read_bio_X509_REQ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 316), (void *)_cffi_d_PEM_read_bio_X509_REQ },
  { "PEM_write_bio_PUBKEY", (void *)_cffi_f_PEM_write_bio_PUBKEY, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 437), (void *)_cffi_d_PEM_write_bio_PUBKEY },
  { "PEM_write_bio_PrivateKey", (void *)_cffi_f_PEM_write_bio_PrivateKey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 441), (void *)_cffi_d_PEM_write_bio_PrivateKey },
  { "PEM_write_bio_X509", (void *)_cffi_f_PEM_write_bio_X509, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 463), (void *)_cffi_d_PEM_write_bio_X509 },
  { "PEM_write_bio_X509_CRL", (void *)_cffi_f_PEM_write_bio_X509_CRL, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 473), (void *)_cffi_d_PEM_write_bio_X509_CRL },
  { "PEM_write_bio_X509_REQ", (void *)_cffi_f_PEM_write_bio_X509_REQ, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 483), (void *)_cffi_d_PEM_write_bio_X509_REQ },
  { "PKCS12_R_PKCS12_CIPHERFINAL_ERROR", (void *)_cffi_const_PKCS12_R_PKCS12_CIPHERFINAL_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PKCS12_create", (void *)_cffi_f_PKCS12_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 155), (void *)_cffi_d_PKCS12_create },
  { "PKCS12_free", (void *)_cffi_f_PKCS12_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1300), (void *)_cffi_d_PKCS12_free },
  { "PKCS12_parse", (void *)_cffi_f_PKCS12_parse, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 639), (void *)_cffi_d_PKCS12_parse },
  { "PKCS12_set_mac", (void *)_cffi_f_PKCS12_set_mac, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 646), (void *)_cffi_d_PKCS12_set_mac },
  { "PKCS7_TEXT", (void *)_cffi_const_PKCS7_TEXT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PKCS7_free", (void *)_cffi_f_PKCS7_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1303), (void *)_cffi_d_PKCS7_free },
  { "PKCS7_verify", (void *)_cffi_f_PKCS7_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 655), (void *)_cffi_d_PKCS7_verify },
  { "PROV_R_BAD_DECRYPT", (void *)_cffi_const_PROV_R_BAD_DECRYPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PROV_R_WRONG_FINAL_BLOCK_LENGTH", (void *)_cffi_const_PROV_R_WRONG_FINAL_BLOCK_LENGTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PROV_R_XTS_DUPLICATED_KEYS", (void *)_cffi_const_PROV_R_XTS_DUPLICATED_KEYS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "RAND_add", (void *)_cffi_f_RAND_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1515), (void *)_cffi_d_RAND_add },
  { "RAND_bytes", (void *)_cffi_f_RAND_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1074), (void *)_cffi_d_RAND_bytes },
  { "RAND_status", (void *)_cffi_f_RAND_status, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1084), (void *)_cffi_d_RAND_status },
  { "RSA_F4", (void *)_cffi_const_RSA_F4, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "RSA_check_key", (void *)_cffi_f_RSA_check_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 669), (void *)_cffi_d_RSA_check_key },
  { "RSA_free", (void *)_cffi_f_RSA_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1306), (void *)_cffi_d_RSA_free },
  { "RSA_generate_key_ex", (void *)_cffi_f_RSA_generate_key_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 663), (void *)_cffi_d_RSA_generate_key_ex },
  { "RSA_new", (void *)_cffi_f_RSA_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 184), (void *)_cffi_d_RSA_new },
  { "RSA_print", (void *)_cffi_f_RSA_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 458), (void *)_cffi_d_RSA_print },
  { "SMIME_read_PKCS7", (void *)_cffi_f_SMIME_read_PKCS7, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_SMIME_read_PKCS7 },
  { "SSL3_VERSION", (void *)_cffi_const_SSL3_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_ACCEPT_EXIT", (void *)_cffi_const_SSL_CB_ACCEPT_EXIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_ACCEPT_LOOP", (void *)_cffi_const_SSL_CB_ACCEPT_LOOP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_ALERT", (void *)_cffi_const_SSL_CB_ALERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_CONNECT_EXIT", (void *)_cffi_const_SSL_CB_CONNECT_EXIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_CONNECT_LOOP", (void *)_cffi_const_SSL_CB_CONNECT_LOOP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_EXIT", (void *)_cffi_const_SSL_CB_EXIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_HANDSHAKE_DONE", (void *)_cffi_const_SSL_CB_HANDSHAKE_DONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_HANDSHAKE_START", (void *)_cffi_const_SSL_CB_HANDSHAKE_START, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_LOOP", (void *)_cffi_const_SSL_CB_LOOP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_READ", (void *)_cffi_const_SSL_CB_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_READ_ALERT", (void *)_cffi_const_SSL_CB_READ_ALERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_WRITE", (void *)_cffi_const_SSL_CB_WRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CB_WRITE_ALERT", (void *)_cffi_const_SSL_CB_WRITE_ALERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_CIPHER_find", (void *)_cffi_f_SSL_CIPHER_find, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 192), (void *)_cffi_d_SSL_CIPHER_find },
  { "SSL_CIPHER_get_bits", (void *)_cffi_f_SSL_CIPHER_get_bits, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 794), (void *)_cffi_d_SSL_CIPHER_get_bits },
  { "SSL_CIPHER_get_name", (void *)_cffi_f_SSL_CIPHER_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 369), (void *)_cffi_d_SSL_CIPHER_get_name },
  { "SSL_CIPHER_get_version", (void *)_cffi_f_SSL_CIPHER_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 369), (void *)_cffi_d_SSL_CIPHER_get_version },
  { "SSL_CTX_add_client_CA", (void *)_cffi_f_SSL_CTX_add_client_CA, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 809), (void *)_cffi_d_SSL_CTX_add_client_CA },
  { "SSL_CTX_add_client_custom_ext", (void *)_cffi_f_SSL_CTX_add_client_custom_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 836), (void *)_cffi_d_SSL_CTX_add_client_custom_ext },
  { "SSL_CTX_add_extra_chain_cert", (void *)_cffi_f_SSL_CTX_add_extra_chain_cert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1129), (void *)_cffi_d_SSL_CTX_add_extra_chain_cert },
  { "SSL_CTX_add_server_custom_ext", (void *)_cffi_f_SSL_CTX_add_server_custom_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 836), (void *)_cffi_d_SSL_CTX_add_server_custom_ext },
  { "SSL_CTX_check_private_key", (void *)_cffi_f_SSL_CTX_check_private_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 845), (void *)_cffi_d_SSL_CTX_check_private_key },
  { "SSL_CTX_clear_mode", (void *)_cffi_f_SSL_CTX_clear_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1145), (void *)_cffi_d_SSL_CTX_clear_mode },
  { "SSL_CTX_free", (void *)_cffi_f_SSL_CTX_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1355), (void *)_cffi_d_SSL_CTX_free },
  { "SSL_CTX_get0_param", (void *)_cffi_f_SSL_CTX_get0_param, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 343), (void *)_cffi_d_SSL_CTX_get0_param },
  { "SSL_CTX_get_cert_store", (void *)_cffi_f_SSL_CTX_get_cert_store, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 333), (void *)_cffi_d_SSL_CTX_get_cert_store },
  { "SSL_CTX_get_keylog_callback", (void *)_cffi_f_SSL_CTX_get_keylog_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1522), (void *)_cffi_d_SSL_CTX_get_keylog_callback },
  { "SSL_CTX_get_options", (void *)_cffi_f_SSL_CTX_get_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1194), (void *)_cffi_d_SSL_CTX_get_options },
  { "SSL_CTX_get_session_cache_mode", (void *)_cffi_f_SSL_CTX_get_session_cache_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1118), (void *)_cffi_d_SSL_CTX_get_session_cache_mode },
  { "SSL_CTX_get_timeout", (void *)_cffi_f_SSL_CTX_get_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1153), (void *)_cffi_d_SSL_CTX_get_timeout },
  { "SSL_CTX_get_verify_depth", (void *)_cffi_f_SSL_CTX_get_verify_depth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 845), (void *)_cffi_d_SSL_CTX_get_verify_depth },
  { "SSL_CTX_get_verify_mode", (void *)_cffi_f_SSL_CTX_get_verify_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 845), (void *)_cffi_d_SSL_CTX_get_verify_mode },
  { "SSL_CTX_load_verify_locations", (void *)_cffi_f_SSL_CTX_load_verify_locations, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 817), (void *)_cffi_d_SSL_CTX_load_verify_locations },
  { "SSL_CTX_new", (void *)_cffi_f_SSL_CTX_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 203), (void *)_cffi_d_SSL_CTX_new },
  { "SSL_CTX_set1_sigalgs_list", (void *)_cffi_f_SSL_CTX_set1_sigalgs_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1133), (void *)_cffi_d_SSL_CTX_set1_sigalgs_list },
  { "SSL_CTX_set_alpn_protos", (void *)_cffi_f_SSL_CTX_set_alpn_protos, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 831), (void *)_cffi_d_SSL_CTX_set_alpn_protos },
  { "SSL_CTX_set_alpn_select_cb", (void *)_cffi_f_SSL_CTX_set_alpn_select_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1378), (void *)_cffi_d_SSL_CTX_set_alpn_select_cb },
  { "SSL_CTX_set_cert_cb", (void *)_cffi_f_SSL_CTX_set_cert_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1391), (void *)_cffi_d_SSL_CTX_set_cert_cb },
  { "SSL_CTX_set_cert_store", (void *)_cffi_f_SSL_CTX_set_cert_store, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1362), (void *)_cffi_d_SSL_CTX_set_cert_store },
  { "SSL_CTX_set_cipher_list", (void *)_cffi_f_SSL_CTX_set_cipher_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 813), (void *)_cffi_d_SSL_CTX_set_cipher_list },
  { "SSL_CTX_set_ciphersuites", (void *)_cffi_f_SSL_CTX_set_ciphersuites, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 813), (void *)_cffi_d_SSL_CTX_set_ciphersuites },
  { "SSL_CTX_set_client_CA_list", (void *)_cffi_f_SSL_CTX_set_client_CA_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1358), (void *)_cffi_d_SSL_CTX_set_client_CA_list },
  { "SSL_CTX_set_client_cert_engine", (void *)_cffi_f_SSL_CTX_set_client_cert_engine, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 801), (void *)_cffi_d_SSL_CTX_set_client_cert_engine },
  { "SSL_CTX_set_cookie_generate_cb", (void *)_cffi_f_SSL_CTX_set_cookie_generate_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1374), (void *)_cffi_d_SSL_CTX_set_cookie_generate_cb },
  { "SSL_CTX_set_cookie_verify_cb", (void *)_cffi_f_SSL_CTX_set_cookie_verify_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1387), (void *)_cffi_d_SSL_CTX_set_cookie_verify_cb },
  { "SSL_CTX_set_default_passwd_cb", (void *)_cffi_f_SSL_CTX_set_default_passwd_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1396), (void *)_cffi_d_SSL_CTX_set_default_passwd_cb },
  { "SSL_CTX_set_default_verify_paths", (void *)_cffi_f_SSL_CTX_set_default_verify_paths, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 798), (void *)_cffi_d_SSL_CTX_set_default_verify_paths },
  { "SSL_CTX_set_info_callback", (void *)_cffi_f_SSL_CTX_set_info_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1425), (void *)_cffi_d_SSL_CTX_set_info_callback },
  { "SSL_CTX_set_keylog_callback", (void *)_cffi_f_SSL_CTX_set_keylog_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1421), (void *)_cffi_d_SSL_CTX_set_keylog_callback },
  { "SSL_CTX_set_max_early_data", (void *)_cffi_f_SSL_CTX_set_max_early_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 827), (void *)_cffi_d_SSL_CTX_set_max_early_data },
  { "SSL_CTX_set_max_proto_version", (void *)_cffi_f_SSL_CTX_set_max_proto_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1141), (void *)_cffi_d_SSL_CTX_set_max_proto_version },
  { "SSL_CTX_set_min_proto_version", (void *)_cffi_f_SSL_CTX_set_min_proto_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1141), (void *)_cffi_d_SSL_CTX_set_min_proto_version },
  { "SSL_CTX_set_mode", (void *)_cffi_f_SSL_CTX_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1145), (void *)_cffi_d_SSL_CTX_set_mode },
  { "SSL_CTX_set_msg_callback", (void *)_cffi_f_SSL_CTX_set_msg_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1429), (void *)_cffi_d_SSL_CTX_set_msg_callback },
  { "SSL_CTX_set_msg_callback_arg", (void *)_cffi_f_SSL_CTX_set_msg_callback_arg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1417), (void *)_cffi_d_SSL_CTX_set_msg_callback_arg },
  { "SSL_CTX_set_options", (void *)_cffi_f_SSL_CTX_set_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1197), (void *)_cffi_d_SSL_CTX_set_options },
  { "SSL_CTX_set_post_handshake_auth", (void *)_cffi_f_SSL_CTX_set_post_handshake_auth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1400), (void *)_cffi_d_SSL_CTX_set_post_handshake_auth },
  { "SSL_CTX_set_psk_client_callback", (void *)_cffi_f_SSL_CTX_set_psk_client_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1409), (void *)_cffi_d_SSL_CTX_set_psk_client_callback },
  { "SSL_CTX_set_psk_find_session_callback", (void *)_cffi_f_SSL_CTX_set_psk_find_session_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1383), (void *)_cffi_d_SSL_CTX_set_psk_find_session_callback },
  { "SSL_CTX_set_psk_server_callback", (void *)_cffi_f_SSL_CTX_set_psk_server_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1413), (void *)_cffi_d_SSL_CTX_set_psk_server_callback },
  { "SSL_CTX_set_psk_use_session_callback", (void *)_cffi_f_SSL_CTX_set_psk_use_session_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1366), (void *)_cffi_d_SSL_CTX_set_psk_use_session_callback },
  { "SSL_CTX_set_session_cache_mode", (void *)_cffi_f_SSL_CTX_set_session_cache_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1145), (void *)_cffi_d_SSL_CTX_set_session_cache_mode },
  { "SSL_CTX_set_session_id_context", (void *)_cffi_f_SSL_CTX_set_session_id_context, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 831), (void *)_cffi_d_SSL_CTX_set_session_id_context },
  { "SSL_CTX_set_timeout", (void *)_cffi_f_SSL_CTX_set_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1145), (void *)_cffi_d_SSL_CTX_set_timeout },
  { "SSL_CTX_set_tlsext_servername_callback", (void *)_cffi_f_SSL_CTX_set_tlsext_servername_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1370), (void *)_cffi_d_SSL_CTX_set_tlsext_servername_callback },
  { "SSL_CTX_set_tlsext_status_arg", (void *)_cffi_f_SSL_CTX_set_tlsext_status_arg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1149), (void *)_cffi_d_SSL_CTX_set_tlsext_status_arg },
  { "SSL_CTX_set_tlsext_status_cb", (void *)_cffi_f_SSL_CTX_set_tlsext_status_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1137), (void *)_cffi_d_SSL_CTX_set_tlsext_status_cb },
  { "SSL_CTX_set_tlsext_use_srtp", (void *)_cffi_f_SSL_CTX_set_tlsext_use_srtp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 813), (void *)_cffi_d_SSL_CTX_set_tlsext_use_srtp },
  { "SSL_CTX_set_tmp_dh", (void *)_cffi_f_SSL_CTX_set_tmp_dh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1121), (void *)_cffi_d_SSL_CTX_set_tmp_dh },
  { "SSL_CTX_set_tmp_ecdh", (void *)_cffi_f_SSL_CTX_set_tmp_ecdh, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1125), (void *)_cffi_d_SSL_CTX_set_tmp_ecdh },
  { "SSL_CTX_set_verify", (void *)_cffi_f_SSL_CTX_set_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1404), (void *)_cffi_d_SSL_CTX_set_verify },
  { "SSL_CTX_set_verify_depth", (void *)_cffi_f_SSL_CTX_set_verify_depth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1400), (void *)_cffi_d_SSL_CTX_set_verify_depth },
  { "SSL_CTX_use_PrivateKey", (void *)_cffi_f_SSL_CTX_use_PrivateKey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 805), (void *)_cffi_d_SSL_CTX_use_PrivateKey },
  { "SSL_CTX_use_PrivateKey_file", (void *)_cffi_f_SSL_CTX_use_PrivateKey_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 822), (void *)_cffi_d_SSL_CTX_use_PrivateKey_file },
  { "SSL_CTX_use_certificate", (void *)_cffi_f_SSL_CTX_use_certificate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 809), (void *)_cffi_d_SSL_CTX_use_certificate },
  { "SSL_CTX_use_certificate_chain_file", (void *)_cffi_f_SSL_CTX_use_certificate_chain_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 813), (void *)_cffi_d_SSL_CTX_use_certificate_chain_file },
  { "SSL_CTX_use_certificate_file", (void *)_cffi_f_SSL_CTX_use_certificate_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 822), (void *)_cffi_d_SSL_CTX_use_certificate_file },
  { "SSL_CTX_use_psk_identity_hint", (void *)_cffi_f_SSL_CTX_use_psk_identity_hint, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 813), (void *)_cffi_d_SSL_CTX_use_psk_identity_hint },
  { "SSL_ERROR_NONE", (void *)_cffi_const_SSL_ERROR_NONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_SSL", (void *)_cffi_const_SSL_ERROR_SSL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_SYSCALL", (void *)_cffi_const_SSL_ERROR_SYSCALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_WANT_READ", (void *)_cffi_const_SSL_ERROR_WANT_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_WANT_WRITE", (void *)_cffi_const_SSL_ERROR_WANT_WRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_WANT_X509_LOOKUP", (void *)_cffi_const_SSL_ERROR_WANT_X509_LOOKUP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ERROR_ZERO_RETURN", (void *)_cffi_const_SSL_ERROR_ZERO_RETURN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_FILETYPE_ASN1", (void *)_cffi_const_SSL_FILETYPE_ASN1, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_FILETYPE_PEM", (void *)_cffi_const_SSL_FILETYPE_PEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER", (void *)_cffi_const_SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_MODE_AUTO_RETRY", (void *)_cffi_const_SSL_MODE_AUTO_RETRY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_MODE_ENABLE_PARTIAL_WRITE", (void *)_cffi_const_SSL_MODE_ENABLE_PARTIAL_WRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_MODE_RELEASE_BUFFERS", (void *)_cffi_const_SSL_MODE_RELEASE_BUFFERS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_ALL", (void *)_cffi_const_SSL_OP_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_CIPHER_SERVER_PREFERENCE", (void *)_cffi_const_SSL_OP_CIPHER_SERVER_PREFERENCE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_COOKIE_EXCHANGE", (void *)_cffi_const_SSL_OP_COOKIE_EXCHANGE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS", (void *)_cffi_const_SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_EPHEMERAL_RSA", (void *)_cffi_const_SSL_OP_EPHEMERAL_RSA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_IGNORE_UNEXPECTED_EOF", (void *)_cffi_const_SSL_OP_IGNORE_UNEXPECTED_EOF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_LEGACY_SERVER_CONNECT", (void *)_cffi_const_SSL_OP_LEGACY_SERVER_CONNECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER", (void *)_cffi_const_SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_MICROSOFT_SESS_ID_BUG", (void *)_cffi_const_SSL_OP_MICROSOFT_SESS_ID_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_MSIE_SSLV2_RSA_PADDING", (void *)_cffi_const_SSL_OP_MSIE_SSLV2_RSA_PADDING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NETSCAPE_CA_DN_BUG", (void *)_cffi_const_SSL_OP_NETSCAPE_CA_DN_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NETSCAPE_CHALLENGE_BUG", (void *)_cffi_const_SSL_OP_NETSCAPE_CHALLENGE_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", (void *)_cffi_const_SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG", (void *)_cffi_const_SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_COMPRESSION", (void *)_cffi_const_SSL_OP_NO_COMPRESSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_QUERY_MTU", (void *)_cffi_const_SSL_OP_NO_QUERY_MTU, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_RENEGOTIATION", (void *)_cffi_const_SSL_OP_NO_RENEGOTIATION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_SSLv2", (void *)_cffi_const_SSL_OP_NO_SSLv2, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_SSLv3", (void *)_cffi_const_SSL_OP_NO_SSLv3, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_TICKET", (void *)_cffi_const_SSL_OP_NO_TICKET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_TLSv1", (void *)_cffi_const_SSL_OP_NO_TLSv1, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_TLSv1_1", (void *)_cffi_const_SSL_OP_NO_TLSv1_1, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_TLSv1_2", (void *)_cffi_const_SSL_OP_NO_TLSv1_2, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_NO_TLSv1_3", (void *)_cffi_const_SSL_OP_NO_TLSv1_3, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_PKCS1_CHECK_1", (void *)_cffi_const_SSL_OP_PKCS1_CHECK_1, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_PKCS1_CHECK_2", (void *)_cffi_const_SSL_OP_PKCS1_CHECK_2, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_SINGLE_DH_USE", (void *)_cffi_const_SSL_OP_SINGLE_DH_USE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_SINGLE_ECDH_USE", (void *)_cffi_const_SSL_OP_SINGLE_ECDH_USE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_SSLEAY_080_CLIENT_DH_BUG", (void *)_cffi_const_SSL_OP_SSLEAY_080_CLIENT_DH_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG", (void *)_cffi_const_SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_TLS_BLOCK_PADDING_BUG", (void *)_cffi_const_SSL_OP_TLS_BLOCK_PADDING_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_TLS_D5_BUG", (void *)_cffi_const_SSL_OP_TLS_D5_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_OP_TLS_ROLLBACK_BUG", (void *)_cffi_const_SSL_OP_TLS_ROLLBACK_BUG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_RECEIVED_SHUTDOWN", (void *)_cffi_const_SSL_RECEIVED_SHUTDOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_R_UNEXPECTED_EOF_WHILE_READING", (void *)_cffi_const_SSL_R_UNEXPECTED_EOF_WHILE_READING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SENT_SHUTDOWN", (void *)_cffi_const_SSL_SENT_SHUTDOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESSION_free", (void *)_cffi_f_SSL_SESSION_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1433), (void *)_cffi_d_SSL_SESSION_free },
  { "SSL_SESSION_get_master_key", (void *)_cffi_f_SSL_SESSION_get_master_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1179), (void *)_cffi_d_SSL_SESSION_get_master_key },
  { "SSL_SESSION_get_max_early_data", (void *)_cffi_f_SSL_SESSION_get_max_early_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1184), (void *)_cffi_d_SSL_SESSION_get_max_early_data },
  { "SSL_SESSION_set1_master_key", (void *)_cffi_f_SSL_SESSION_set1_master_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 856), (void *)_cffi_d_SSL_SESSION_set1_master_key },
  { "SSL_SESSION_set_cipher", (void *)_cffi_f_SSL_SESSION_set_cipher, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 848), (void *)_cffi_d_SSL_SESSION_set_cipher },
  { "SSL_SESSION_set_protocol_version", (void *)_cffi_f_SSL_SESSION_set_protocol_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 852), (void *)_cffi_d_SSL_SESSION_set_protocol_version },
  { "SSL_SESS_CACHE_BOTH", (void *)_cffi_const_SSL_SESS_CACHE_BOTH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_CLIENT", (void *)_cffi_const_SSL_SESS_CACHE_CLIENT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_NO_AUTO_CLEAR", (void *)_cffi_const_SSL_SESS_CACHE_NO_AUTO_CLEAR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_NO_INTERNAL", (void *)_cffi_const_SSL_SESS_CACHE_NO_INTERNAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_NO_INTERNAL_LOOKUP", (void *)_cffi_const_SSL_SESS_CACHE_NO_INTERNAL_LOOKUP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_NO_INTERNAL_STORE", (void *)_cffi_const_SSL_SESS_CACHE_NO_INTERNAL_STORE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_OFF", (void *)_cffi_const_SSL_SESS_CACHE_OFF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_SESS_CACHE_SERVER", (void *)_cffi_const_SSL_SESS_CACHE_SERVER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_ACCEPT", (void *)_cffi_const_SSL_ST_ACCEPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_BEFORE", (void *)_cffi_const_SSL_ST_BEFORE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_CONNECT", (void *)_cffi_const_SSL_ST_CONNECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_INIT", (void *)_cffi_const_SSL_ST_INIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_MASK", (void *)_cffi_const_SSL_ST_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_OK", (void *)_cffi_const_SSL_ST_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_ST_RENEGOTIATE", (void *)_cffi_const_SSL_ST_RENEGOTIATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_TLSEXT_ERR_ALERT_FATAL", (void *)_cffi_const_SSL_TLSEXT_ERR_ALERT_FATAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_TLSEXT_ERR_NOACK", (void *)_cffi_const_SSL_TLSEXT_ERR_NOACK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_TLSEXT_ERR_OK", (void *)_cffi_const_SSL_TLSEXT_ERR_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_VERIFY_CLIENT_ONCE", (void *)_cffi_const_SSL_VERIFY_CLIENT_ONCE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_VERIFY_FAIL_IF_NO_PEER_CERT", (void *)_cffi_const_SSL_VERIFY_FAIL_IF_NO_PEER_CERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_VERIFY_NONE", (void *)_cffi_const_SSL_VERIFY_NONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_VERIFY_PEER", (void *)_cffi_const_SSL_VERIFY_PEER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_VERIFY_POST_HANDSHAKE", (void *)_cffi_const_SSL_VERIFY_POST_HANDSHAKE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SSL_clear_mode", (void *)_cffi_f_SSL_clear_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1097), (void *)_cffi_d_SSL_clear_mode },
  { "SSL_do_handshake", (void *)_cffi_f_SSL_do_handshake, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 672), (void *)_cffi_d_SSL_do_handshake },
  { "SSL_export_keying_material", (void *)_cffi_f_SSL_export_keying_material, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 711), (void *)_cffi_d_SSL_export_keying_material },
  { "SSL_extension_supported", (void *)_cffi_f_SSL_extension_supported, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1078), (void *)_cffi_d_SSL_extension_supported },
  { "SSL_free", (void *)_cffi_f_SSL_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1309), (void *)_cffi_d_SSL_free },
  { "SSL_get0_alpn_selected", (void *)_cffi_f_SSL_get0_alpn_selected, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1350), (void *)_cffi_d_SSL_get0_alpn_selected },
  { "SSL_get0_param", (void *)_cffi_f_SSL_get0_param, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 340), (void *)_cffi_d_SSL_get0_param },
  { "SSL_get0_verified_chain", (void *)_cffi_f_SSL_get0_verified_chain, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 61), (void *)_cffi_d_SSL_get0_verified_chain },
  { "SSL_get1_session", (void *)_cffi_f_SSL_get1_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 208), (void *)_cffi_d_SSL_get1_session },
  { "SSL_get_certificate", (void *)_cffi_f_SSL_get_certificate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 230), (void *)_cffi_d_SSL_get_certificate },
  { "SSL_get_cipher_list", (void *)_cffi_f_SSL_get_cipher_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 365), (void *)_cffi_d_SSL_get_cipher_list },
  { "SSL_get_client_CA_list", (void *)_cffi_f_SSL_get_client_CA_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_SSL_get_client_CA_list },
  { "SSL_get_client_random", (void *)_cffi_f_SSL_get_client_random, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1169), (void *)_cffi_d_SSL_get_client_random },
  { "SSL_get_current_cipher", (void *)_cffi_f_SSL_get_current_cipher, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 196), (void *)_cffi_d_SSL_get_current_cipher },
  { "SSL_get_error", (void *)_cffi_f_SSL_get_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 790), (void *)_cffi_d_SSL_get_error },
  { "SSL_get_ex_data_X509_STORE_CTX_idx", (void *)_cffi_f_SSL_get_ex_data_X509_STORE_CTX_idx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 1084), (void *)_cffi_d_SSL_get_ex_data_X509_STORE_CTX_idx },
  { "SSL_get_extms_support", (void *)_cffi_f_SSL_get_extms_support, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1094), (void *)_cffi_d_SSL_get_extms_support },
  { "SSL_get_finished", (void *)_cffi_f_SSL_get_finished, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1174), (void *)_cffi_d_SSL_get_finished },
  { "SSL_get_options", (void *)_cffi_f_SSL_get_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1187), (void *)_cffi_d_SSL_get_options },
  { "SSL_get_peer_cert_chain", (void *)_cffi_f_SSL_get_peer_cert_chain, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 61), (void *)_cffi_d_SSL_get_peer_cert_chain },
  { "SSL_get_peer_certificate", (void *)_cffi_f_SSL_get_peer_certificate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 230), (void *)_cffi_d_SSL_get_peer_certificate },
  { "SSL_get_peer_finished", (void *)_cffi_f_SSL_get_peer_finished, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1174), (void *)_cffi_d_SSL_get_peer_finished },
  { "SSL_get_selected_srtp_profile", (void *)_cffi_f_SSL_get_selected_srtp_profile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 186), (void *)_cffi_d_SSL_get_selected_srtp_profile },
  { "SSL_get_server_random", (void *)_cffi_f_SSL_get_server_random, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1169), (void *)_cffi_d_SSL_get_server_random },
  { "SSL_get_servername", (void *)_cffi_f_SSL_get_servername, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 365), (void *)_cffi_d_SSL_get_servername },
  { "SSL_get_session", (void *)_cffi_f_SSL_get_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 211), (void *)_cffi_d_SSL_get_session },
  { "SSL_get_shutdown", (void *)_cffi_f_SSL_get_shutdown, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_get_shutdown },
  { "SSL_get_tlsext_status_ocsp_resp", (void *)_cffi_f_SSL_get_tlsext_status_ocsp_resp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1111), (void *)_cffi_d_SSL_get_tlsext_status_ocsp_resp },
  { "SSL_get_verify_mode", (void *)_cffi_f_SSL_get_verify_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_get_verify_mode },
  { "SSL_get_verify_result", (void *)_cffi_f_SSL_get_verify_result, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1115), (void *)_cffi_d_SSL_get_verify_result },
  { "SSL_get_version", (void *)_cffi_f_SSL_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 362), (void *)_cffi_d_SSL_get_version },
  { "SSL_load_client_CA_file", (void *)_cffi_f_SSL_load_client_CA_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_SSL_load_client_CA_file },
  { "SSL_new", (void *)_cffi_f_SSL_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 189), (void *)_cffi_d_SSL_new },
  { "SSL_peek", (void *)_cffi_f_SSL_peek, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 765), (void *)_cffi_d_SSL_peek },
  { "SSL_pending", (void *)_cffi_f_SSL_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_pending },
  { "SSL_read", (void *)_cffi_f_SSL_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 765), (void *)_cffi_d_SSL_read },
  { "SSL_read_early_data", (void *)_cffi_f_SSL_read_early_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 770), (void *)_cffi_d_SSL_read_early_data },
  { "SSL_renegotiate", (void *)_cffi_f_SSL_renegotiate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 672), (void *)_cffi_d_SSL_renegotiate },
  { "SSL_renegotiate_pending", (void *)_cffi_f_SSL_renegotiate_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 672), (void *)_cffi_d_SSL_renegotiate_pending },
  { "SSL_session_reused", (void *)_cffi_f_SSL_session_reused, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_session_reused },
  { "SSL_set_SSL_CTX", (void *)_cffi_f_SSL_set_SSL_CTX, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_SSL_set_SSL_CTX },
  { "SSL_set_accept_state", (void *)_cffi_f_SSL_set_accept_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1309), (void *)_cffi_d_SSL_set_accept_state },
  { "SSL_set_alpn_protos", (void *)_cffi_f_SSL_set_alpn_protos, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 740), (void *)_cffi_d_SSL_set_alpn_protos },
  { "SSL_set_bio", (void *)_cffi_f_SSL_set_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1312), (void *)_cffi_d_SSL_set_bio },
  { "SSL_set_cert_cb", (void *)_cffi_f_SSL_set_cert_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1321), (void *)_cffi_d_SSL_set_cert_cb },
  { "SSL_set_connect_state", (void *)_cffi_f_SSL_set_connect_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1309), (void *)_cffi_d_SSL_set_connect_state },
  { "SSL_set_fd", (void *)_cffi_f_SSL_set_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 707), (void *)_cffi_d_SSL_set_fd },
  { "SSL_set_mode", (void *)_cffi_f_SSL_set_mode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1097), (void *)_cffi_d_SSL_set_mode },
  { "SSL_set_mtu", (void *)_cffi_f_SSL_set_mtu, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1097), (void *)_cffi_d_SSL_set_mtu },
  { "SSL_set_options", (void *)_cffi_f_SSL_set_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1190), (void *)_cffi_d_SSL_set_options },
  { "SSL_set_post_handshake_auth", (void *)_cffi_f_SSL_set_post_handshake_auth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1326), (void *)_cffi_d_SSL_set_post_handshake_auth },
  { "SSL_set_session", (void *)_cffi_f_SSL_set_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 690), (void *)_cffi_d_SSL_set_session },
  { "SSL_set_shutdown", (void *)_cffi_f_SSL_set_shutdown, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1326), (void *)_cffi_d_SSL_set_shutdown },
  { "SSL_set_tlsext_host_name", (void *)_cffi_f_SSL_set_tlsext_host_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1317), (void *)_cffi_d_SSL_set_tlsext_host_name },
  { "SSL_set_tlsext_status_ocsp_resp", (void *)_cffi_f_SSL_set_tlsext_status_ocsp_resp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1106), (void *)_cffi_d_SSL_set_tlsext_status_ocsp_resp },
  { "SSL_set_tlsext_status_type", (void *)_cffi_f_SSL_set_tlsext_status_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1097), (void *)_cffi_d_SSL_set_tlsext_status_type },
  { "SSL_set_tlsext_use_srtp", (void *)_cffi_f_SSL_set_tlsext_use_srtp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 698), (void *)_cffi_d_SSL_set_tlsext_use_srtp },
  { "SSL_set_verify", (void *)_cffi_f_SSL_set_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1330), (void *)_cffi_d_SSL_set_verify },
  { "SSL_shutdown", (void *)_cffi_f_SSL_shutdown, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 672), (void *)_cffi_d_SSL_shutdown },
  { "SSL_state_string_long", (void *)_cffi_f_SSL_state_string_long, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 362), (void *)_cffi_d_SSL_state_string_long },
  { "SSL_total_renegotiations", (void *)_cffi_f_SSL_total_renegotiations, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1094), (void *)_cffi_d_SSL_total_renegotiations },
  { "SSL_use_PrivateKey", (void *)_cffi_f_SSL_use_PrivateKey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 686), (void *)_cffi_d_SSL_use_PrivateKey },
  { "SSL_use_certificate", (void *)_cffi_f_SSL_use_certificate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 694), (void *)_cffi_d_SSL_use_certificate },
  { "SSL_verify_client_post_handshake", (void *)_cffi_f_SSL_verify_client_post_handshake, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 672), (void *)_cffi_d_SSL_verify_client_post_handshake },
  { "SSL_version", (void *)_cffi_f_SSL_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_version },
  { "SSL_want_read", (void *)_cffi_f_SSL_want_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_want_read },
  { "SSL_want_write", (void *)_cffi_f_SSL_want_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 787), (void *)_cffi_d_SSL_want_write },
  { "SSL_write", (void *)_cffi_f_SSL_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 776), (void *)_cffi_d_SSL_write },
  { "SSL_write_early_data", (void *)_cffi_f_SSL_write_early_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 781), (void *)_cffi_d_SSL_write_early_data },
  { "TLS1_1_VERSION", (void *)_cffi_const_TLS1_1_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS1_2_VERSION", (void *)_cffi_const_TLS1_2_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS1_3_VERSION", (void *)_cffi_const_TLS1_3_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS1_VERSION", (void *)_cffi_const_TLS1_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLSEXT_NAMETYPE_host_name", (void *)_cffi_const_TLSEXT_NAMETYPE_host_name, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLSEXT_STATUSTYPE_ocsp", (void *)_cffi_const_TLSEXT_STATUSTYPE_ocsp, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS_ST_BEFORE", (void *)_cffi_const_TLS_ST_BEFORE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS_ST_OK", (void *)_cffi_const_TLS_ST_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TLS_client_method", (void *)_cffi_f_TLS_client_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_TLS_client_method },
  { "TLS_method", (void *)_cffi_f_TLS_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_TLS_method },
  { "TLS_server_method", (void *)_cffi_f_TLS_server_method, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 206), (void *)_cffi_d_TLS_server_method },
  { "V_ASN1_GENERALIZEDTIME", (void *)_cffi_const_V_ASN1_GENERALIZEDTIME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509V3_EXT_ERROR_UNKNOWN", (void *)_cffi_const_X509V3_EXT_ERROR_UNKNOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509V3_EXT_d2i", (void *)_cffi_f_X509V3_EXT_d2i, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1230), (void *)_cffi_d_X509V3_EXT_d2i },
  { "X509V3_EXT_nconf", (void *)_cffi_f_X509V3_EXT_nconf, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 256), (void *)_cffi_d_X509V3_EXT_nconf },
  { "X509V3_EXT_print", (void *)_cffi_f_X509V3_EXT_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 477), (void *)_cffi_d_X509V3_EXT_print },
  { "X509V3_set_ctx", (void *)_cffi_f_X509V3_set_ctx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1442), (void *)_cffi_d_X509V3_set_ctx },
  { "X509V3_set_ctx_nodb", (void *)_cffi_f_X509V3_set_ctx_nodb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1439), (void *)_cffi_d_X509V3_set_ctx_nodb },
  { "X509_ALGOR_get0", (void *)_cffi_f_X509_ALGOR_get0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1249), (void *)_cffi_d_X509_ALGOR_get0 },
  { "X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT", (void *)_cffi_const_X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS", (void *)_cffi_const_X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CHECK_FLAG_NEVER_CHECK_SUBJECT", (void *)_cffi_const_X509_CHECK_FLAG_NEVER_CHECK_SUBJECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS", (void *)_cffi_const_X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CHECK_FLAG_NO_WILDCARDS", (void *)_cffi_const_X509_CHECK_FLAG_NO_WILDCARDS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS", (void *)_cffi_const_X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_CRL_add0_revoked", (void *)_cffi_f_X509_CRL_add0_revoked, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 925), (void *)_cffi_d_X509_CRL_add0_revoked },
  { "X509_CRL_free", (void *)_cffi_f_X509_CRL_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1450), (void *)_cffi_d_X509_CRL_free },
  { "X509_CRL_get_REVOKED", (void *)_cffi_f_X509_CRL_get_REVOKED, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 80), (void *)_cffi_d_X509_CRL_get_REVOKED },
  { "X509_CRL_get_issuer", (void *)_cffi_f_X509_CRL_get_issuer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 293), (void *)_cffi_d_X509_CRL_get_issuer },
  { "X509_CRL_new", (void *)_cffi_f_X509_CRL_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 254), (void *)_cffi_d_X509_CRL_new },
  { "X509_CRL_print", (void *)_cffi_f_X509_CRL_print, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 473), (void *)_cffi_d_X509_CRL_print },
  { "X509_CRL_set1_lastUpdate", (void *)_cffi_f_X509_CRL_set1_lastUpdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 912), (void *)_cffi_d_X509_CRL_set1_lastUpdate },
  { "X509_CRL_set1_nextUpdate", (void *)_cffi_f_X509_CRL_set1_nextUpdate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 912), (void *)_cffi_d_X509_CRL_set1_nextUpdate },
  { "X509_CRL_set_issuer_name", (void *)_cffi_f_X509_CRL_set_issuer_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 921), (void *)_cffi_d_X509_CRL_set_issuer_name },
  { "X509_CRL_set_version", (void *)_cffi_f_X509_CRL_set_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 929), (void *)_cffi_d_X509_CRL_set_version },
  { "X509_CRL_sign", (void *)_cffi_f_X509_CRL_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 916), (void *)_cffi_d_X509_CRL_sign },
  { "X509_CRL_sort", (void *)_cffi_f_X509_CRL_sort, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 909), (void *)_cffi_d_X509_CRL_sort },
  { "X509_EXTENSION_dup", (void *)_cffi_f_X509_EXTENSION_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 266), (void *)_cffi_d_X509_EXTENSION_dup },
  { "X509_EXTENSION_free", (void *)_cffi_f_X509_EXTENSION_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1453), (void *)_cffi_d_X509_EXTENSION_free },
  { "X509_EXTENSION_get_critical", (void *)_cffi_f_X509_EXTENSION_get_critical, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 933), (void *)_cffi_d_X509_EXTENSION_get_critical },
  { "X509_EXTENSION_get_data", (void *)_cffi_f_X509_EXTENSION_get_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d_X509_EXTENSION_get_data },
  { "X509_EXTENSION_get_object", (void *)_cffi_f_X509_EXTENSION_get_object, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 16), (void *)_cffi_d_X509_EXTENSION_get_object },
  { "X509_NAME_ENTRY_free", (void *)_cffi_f_X509_NAME_ENTRY_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1466), (void *)_cffi_d_X509_NAME_ENTRY_free },
  { "X509_NAME_ENTRY_get_data", (void *)_cffi_f_X509_NAME_ENTRY_get_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_X509_NAME_ENTRY_get_data },
  { "X509_NAME_ENTRY_get_object", (void *)_cffi_f_X509_NAME_ENTRY_get_object, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 19), (void *)_cffi_d_X509_NAME_ENTRY_get_object },
  { "X509_NAME_add_entry_by_NID", (void *)_cffi_f_X509_NAME_add_entry_by_NID, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 948), (void *)_cffi_d_X509_NAME_add_entry_by_NID },
  { "X509_NAME_cmp", (void *)_cffi_f_X509_NAME_cmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 964), (void *)_cffi_d_X509_NAME_cmp },
  { "X509_NAME_delete_entry", (void *)_cffi_f_X509_NAME_delete_entry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 304), (void *)_cffi_d_X509_NAME_delete_entry },
  { "X509_NAME_dup", (void *)_cffi_f_X509_NAME_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 296), (void *)_cffi_d_X509_NAME_dup },
  { "X509_NAME_entry_count", (void *)_cffi_f_X509_NAME_entry_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 961), (void *)_cffi_d_X509_NAME_entry_count },
  { "X509_NAME_free", (void *)_cffi_f_X509_NAME_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1463), (void *)_cffi_d_X509_NAME_free },
  { "X509_NAME_get_entry", (void *)_cffi_f_X509_NAME_get_entry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 308), (void *)_cffi_d_X509_NAME_get_entry },
  { "X509_NAME_get_index_by_NID", (void *)_cffi_f_X509_NAME_get_index_by_NID, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 943), (void *)_cffi_d_X509_NAME_get_index_by_NID },
  { "X509_NAME_hash", (void *)_cffi_f_X509_NAME_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1225), (void *)_cffi_d_X509_NAME_hash },
  { "X509_NAME_new", (void *)_cffi_f_X509_NAME_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 302), (void *)_cffi_d_X509_NAME_new },
  { "X509_NAME_oneline", (void *)_cffi_f_X509_NAME_oneline, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 354), (void *)_cffi_d_X509_NAME_oneline },
  { "X509_PURPOSE_ANY", (void *)_cffi_const_X509_PURPOSE_ANY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_CRL_SIGN", (void *)_cffi_const_X509_PURPOSE_CRL_SIGN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_NS_SSL_SERVER", (void *)_cffi_const_X509_PURPOSE_NS_SSL_SERVER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_OCSP_HELPER", (void *)_cffi_const_X509_PURPOSE_OCSP_HELPER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_SMIME_ENCRYPT", (void *)_cffi_const_X509_PURPOSE_SMIME_ENCRYPT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_SMIME_SIGN", (void *)_cffi_const_X509_PURPOSE_SMIME_SIGN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_SSL_CLIENT", (void *)_cffi_const_X509_PURPOSE_SSL_CLIENT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_SSL_SERVER", (void *)_cffi_const_X509_PURPOSE_SSL_SERVER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_PURPOSE_TIMESTAMP_SIGN", (void *)_cffi_const_X509_PURPOSE_TIMESTAMP_SIGN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_REQ_add_extensions", (void *)_cffi_f_X509_REQ_add_extensions, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 977), (void *)_cffi_d_X509_REQ_add_extensions },
  { "X509_REQ_free", (void *)_cffi_f_X509_REQ_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1469), (void *)_cffi_d_X509_REQ_free },
  { "X509_REQ_get_extensions", (void *)_cffi_f_X509_REQ_get_extensions, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 281), (void *)_cffi_d_X509_REQ_get_extensions },
  { "X509_REQ_get_pubkey", (void *)_cffi_f_X509_REQ_get_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 136), (void *)_cffi_d_X509_REQ_get_pubkey },
  { "X509_REQ_get_subject_name", (void *)_cffi_f_X509_REQ_get_subject_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 299), (void *)_cffi_d_X509_REQ_get_subject_name },
  { "X509_REQ_get_version", (void *)_cffi_f_X509_REQ_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1159), (void *)_cffi_d_X509_REQ_get_version },
  { "X509_REQ_new", (void *)_cffi_f_X509_REQ_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 322), (void *)_cffi_d_X509_REQ_new },
  { "X509_REQ_print_ex", (void *)_cffi_f_X509_REQ_print_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 487), (void *)_cffi_d_X509_REQ_print_ex },
  { "X509_REQ_set_pubkey", (void *)_cffi_f_X509_REQ_set_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 968), (void *)_cffi_d_X509_REQ_set_pubkey },
  { "X509_REQ_set_version", (void *)_cffi_f_X509_REQ_set_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 981), (void *)_cffi_d_X509_REQ_set_version },
  { "X509_REQ_sign", (void *)_cffi_f_X509_REQ_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 972), (void *)_cffi_d_X509_REQ_sign },
  { "X509_REQ_verify", (void *)_cffi_f_X509_REQ_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 968), (void *)_cffi_d_X509_REQ_verify },
  { "X509_REVOKED_add1_ext_i2d", (void *)_cffi_f_X509_REVOKED_add1_ext_i2d, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 993), (void *)_cffi_d_X509_REVOKED_add1_ext_i2d },
  { "X509_REVOKED_delete_ext", (void *)_cffi_f_X509_REVOKED_delete_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 273), (void *)_cffi_d_X509_REVOKED_delete_ext },
  { "X509_REVOKED_dup", (void *)_cffi_f_X509_REVOKED_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 328), (void *)_cffi_d_X509_REVOKED_dup },
  { "X509_REVOKED_free", (void *)_cffi_f_X509_REVOKED_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1472), (void *)_cffi_d_X509_REVOKED_free },
  { "X509_REVOKED_get0_revocationDate", (void *)_cffi_f_X509_REVOKED_get0_revocationDate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 37), (void *)_cffi_d_X509_REVOKED_get0_revocationDate },
  { "X509_REVOKED_get0_serialNumber", (void *)_cffi_f_X509_REVOKED_get0_serialNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 13), (void *)_cffi_d_X509_REVOKED_get0_serialNumber },
  { "X509_REVOKED_get_ext", (void *)_cffi_f_X509_REVOKED_get_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 277), (void *)_cffi_d_X509_REVOKED_get_ext },
  { "X509_REVOKED_get_ext_count", (void *)_cffi_f_X509_REVOKED_get_ext_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1000), (void *)_cffi_d_X509_REVOKED_get_ext_count },
  { "X509_REVOKED_new", (void *)_cffi_f_X509_REVOKED_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_X509_REVOKED_new },
  { "X509_REVOKED_set_revocationDate", (void *)_cffi_f_X509_REVOKED_set_revocationDate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 989), (void *)_cffi_d_X509_REVOKED_set_revocationDate },
  { "X509_REVOKED_set_serialNumber", (void *)_cffi_f_X509_REVOKED_set_serialNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 985), (void *)_cffi_d_X509_REVOKED_set_serialNumber },
  { "X509_STORE_CTX_cleanup", (void *)_cffi_f_X509_STORE_CTX_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1478), (void *)_cffi_d_X509_STORE_CTX_cleanup },
  { "X509_STORE_CTX_free", (void *)_cffi_f_X509_STORE_CTX_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1478), (void *)_cffi_d_X509_STORE_CTX_free },
  { "X509_STORE_CTX_get0_cert", (void *)_cffi_f_X509_STORE_CTX_get0_cert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 236), (void *)_cffi_d_X509_STORE_CTX_get0_cert },
  { "X509_STORE_CTX_get1_chain", (void *)_cffi_f_X509_STORE_CTX_get1_chain, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 64), (void *)_cffi_d_X509_STORE_CTX_get1_chain },
  { "X509_STORE_CTX_get_current_cert", (void *)_cffi_f_X509_STORE_CTX_get_current_cert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 236), (void *)_cffi_d_X509_STORE_CTX_get_current_cert },
  { "X509_STORE_CTX_get_error", (void *)_cffi_f_X509_STORE_CTX_get_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1031), (void *)_cffi_d_X509_STORE_CTX_get_error },
  { "X509_STORE_CTX_get_error_depth", (void *)_cffi_f_X509_STORE_CTX_get_error_depth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1031), (void *)_cffi_d_X509_STORE_CTX_get_error_depth },
  { "X509_STORE_CTX_get_ex_data", (void *)_cffi_f_X509_STORE_CTX_get_ex_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1233), (void *)_cffi_d_X509_STORE_CTX_get_ex_data },
  { "X509_STORE_CTX_init", (void *)_cffi_f_X509_STORE_CTX_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1034), (void *)_cffi_d_X509_STORE_CTX_init },
  { "X509_STORE_CTX_new", (void *)_cffi_f_X509_STORE_CTX_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 338), (void *)_cffi_d_X509_STORE_CTX_new },
  { "X509_STORE_CTX_set_error", (void *)_cffi_f_X509_STORE_CTX_set_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1481), (void *)_cffi_d_X509_STORE_CTX_set_error },
  { "X509_STORE_add_cert", (void *)_cffi_f_X509_STORE_add_cert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1006), (void *)_cffi_d_X509_STORE_add_cert },
  { "X509_STORE_add_crl", (void *)_cffi_f_X509_STORE_add_crl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1010), (void *)_cffi_d_X509_STORE_add_crl },
  { "X509_STORE_free", (void *)_cffi_f_X509_STORE_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1475), (void *)_cffi_d_X509_STORE_free },
  { "X509_STORE_get0_objects", (void *)_cffi_f_X509_STORE_get0_objects, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 77), (void *)_cffi_d_X509_STORE_get0_objects },
  { "X509_STORE_load_locations", (void *)_cffi_f_X509_STORE_load_locations, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1018), (void *)_cffi_d_X509_STORE_load_locations },
  { "X509_STORE_new", (void *)_cffi_f_X509_STORE_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 336), (void *)_cffi_d_X509_STORE_new },
  { "X509_STORE_set1_param", (void *)_cffi_f_X509_STORE_set1_param, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1014), (void *)_cffi_d_X509_STORE_set1_param },
  { "X509_STORE_set_default_paths", (void *)_cffi_f_X509_STORE_set_default_paths, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1003), (void *)_cffi_d_X509_STORE_set_default_paths },
  { "X509_STORE_set_flags", (void *)_cffi_f_X509_STORE_set_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1027), (void *)_cffi_d_X509_STORE_set_flags },
  { "X509_STORE_set_purpose", (void *)_cffi_f_X509_STORE_set_purpose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1023), (void *)_cffi_d_X509_STORE_set_purpose },
  { "X509_STORE_up_ref", (void *)_cffi_f_X509_STORE_up_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1003), (void *)_cffi_d_X509_STORE_up_ref },
  { "X509_VERIFY_PARAM_free", (void *)_cffi_f_X509_VERIFY_PARAM_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1485), (void *)_cffi_d_X509_VERIFY_PARAM_free },
  { "X509_VERIFY_PARAM_new", (void *)_cffi_f_X509_VERIFY_PARAM_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 346), (void *)_cffi_d_X509_VERIFY_PARAM_new },
  { "X509_VERIFY_PARAM_set1_host", (void *)_cffi_f_X509_VERIFY_PARAM_set1_host, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1040), (void *)_cffi_d_X509_VERIFY_PARAM_set1_host },
  { "X509_VERIFY_PARAM_set1_ip", (void *)_cffi_f_X509_VERIFY_PARAM_set1_ip, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1045), (void *)_cffi_d_X509_VERIFY_PARAM_set1_ip },
  { "X509_VERIFY_PARAM_set_flags", (void *)_cffi_f_X509_VERIFY_PARAM_set_flags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1050), (void *)_cffi_d_X509_VERIFY_PARAM_set_flags },
  { "X509_VERIFY_PARAM_set_hostflags", (void *)_cffi_f_X509_VERIFY_PARAM_set_hostflags, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1492), (void *)_cffi_d_X509_VERIFY_PARAM_set_hostflags },
  { "X509_VERIFY_PARAM_set_time", (void *)_cffi_f_X509_VERIFY_PARAM_set_time, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1488), (void *)_cffi_d_X509_VERIFY_PARAM_set_time },
  { "X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH", (void *)_cffi_const_X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_AKID_SKID_MISMATCH", (void *)_cffi_const_X509_V_ERR_AKID_SKID_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_APPLICATION_VERIFICATION", (void *)_cffi_const_X509_V_ERR_APPLICATION_VERIFICATION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_CHAIN_TOO_LONG", (void *)_cffi_const_X509_V_ERR_CERT_CHAIN_TOO_LONG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_HAS_EXPIRED", (void *)_cffi_const_X509_V_ERR_CERT_HAS_EXPIRED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_NOT_YET_VALID", (void *)_cffi_const_X509_V_ERR_CERT_NOT_YET_VALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_REJECTED", (void *)_cffi_const_X509_V_ERR_CERT_REJECTED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_REVOKED", (void *)_cffi_const_X509_V_ERR_CERT_REVOKED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_SIGNATURE_FAILURE", (void *)_cffi_const_X509_V_ERR_CERT_SIGNATURE_FAILURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CERT_UNTRUSTED", (void *)_cffi_const_X509_V_ERR_CERT_UNTRUSTED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CRL_HAS_EXPIRED", (void *)_cffi_const_X509_V_ERR_CRL_HAS_EXPIRED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CRL_NOT_YET_VALID", (void *)_cffi_const_X509_V_ERR_CRL_NOT_YET_VALID, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CRL_PATH_VALIDATION_ERROR", (void *)_cffi_const_X509_V_ERR_CRL_PATH_VALIDATION_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_CRL_SIGNATURE_FAILURE", (void *)_cffi_const_X509_V_ERR_CRL_SIGNATURE_FAILURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT", (void *)_cffi_const_X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_DIFFERENT_CRL_SCOPE", (void *)_cffi_const_X509_V_ERR_DIFFERENT_CRL_SCOPE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_EMAIL_MISMATCH", (void *)_cffi_const_X509_V_ERR_EMAIL_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD", (void *)_cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD", (void *)_cffi_const_X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD", (void *)_cffi_const_X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD", (void *)_cffi_const_X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_EXCLUDED_VIOLATION", (void *)_cffi_const_X509_V_ERR_EXCLUDED_VIOLATION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_HOSTNAME_MISMATCH", (void *)_cffi_const_X509_V_ERR_HOSTNAME_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_INVALID_CA", (void *)_cffi_const_X509_V_ERR_INVALID_CA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_INVALID_EXTENSION", (void *)_cffi_const_X509_V_ERR_INVALID_EXTENSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_INVALID_NON_CA", (void *)_cffi_const_X509_V_ERR_INVALID_NON_CA, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_INVALID_POLICY_EXTENSION", (void *)_cffi_const_X509_V_ERR_INVALID_POLICY_EXTENSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_INVALID_PURPOSE", (void *)_cffi_const_X509_V_ERR_INVALID_PURPOSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_IP_ADDRESS_MISMATCH", (void *)_cffi_const_X509_V_ERR_IP_ADDRESS_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_KEYUSAGE_NO_CERTSIGN", (void *)_cffi_const_X509_V_ERR_KEYUSAGE_NO_CERTSIGN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_KEYUSAGE_NO_CRL_SIGN", (void *)_cffi_const_X509_V_ERR_KEYUSAGE_NO_CRL_SIGN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE", (void *)_cffi_const_X509_V_ERR_KEYUSAGE_NO_DIGITAL_SIGNATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_NO_EXPLICIT_POLICY", (void *)_cffi_const_X509_V_ERR_NO_EXPLICIT_POLICY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_OUT_OF_MEM", (void *)_cffi_const_X509_V_ERR_OUT_OF_MEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_PATH_LENGTH_EXCEEDED", (void *)_cffi_const_X509_V_ERR_PATH_LENGTH_EXCEEDED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_PERMITTED_VIOLATION", (void *)_cffi_const_X509_V_ERR_PERMITTED_VIOLATION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED", (void *)_cffi_const_X509_V_ERR_PROXY_CERTIFICATES_NOT_ALLOWED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED", (void *)_cffi_const_X509_V_ERR_PROXY_PATH_LENGTH_EXCEEDED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN", (void *)_cffi_const_X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_SUBJECT_ISSUER_MISMATCH", (void *)_cffi_const_X509_V_ERR_SUBJECT_ISSUER_MISMATCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_SUBTREE_MINMAX", (void *)_cffi_const_X509_V_ERR_SUBTREE_MINMAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_GET_CRL", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_GET_CRL_ISSUER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE", (void *)_cffi_const_X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION", (void *)_cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_CRL_EXTENSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION", (void *)_cffi_const_X509_V_ERR_UNHANDLED_CRITICAL_EXTENSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNNESTED_RESOURCE", (void *)_cffi_const_X509_V_ERR_UNNESTED_RESOURCE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX", (void *)_cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_SYNTAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE", (void *)_cffi_const_X509_V_ERR_UNSUPPORTED_CONSTRAINT_TYPE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE", (void *)_cffi_const_X509_V_ERR_UNSUPPORTED_EXTENSION_FEATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_ERR_UNSUPPORTED_NAME_SYNTAX", (void *)_cffi_const_X509_V_ERR_UNSUPPORTED_NAME_SYNTAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_ALLOW_PROXY_CERTS", (void *)_cffi_const_X509_V_FLAG_ALLOW_PROXY_CERTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_CHECK_SS_SIGNATURE", (void *)_cffi_const_X509_V_FLAG_CHECK_SS_SIGNATURE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_CRL_CHECK", (void *)_cffi_const_X509_V_FLAG_CRL_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_CRL_CHECK_ALL", (void *)_cffi_const_X509_V_FLAG_CRL_CHECK_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_EXPLICIT_POLICY", (void *)_cffi_const_X509_V_FLAG_EXPLICIT_POLICY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_IGNORE_CRITICAL", (void *)_cffi_const_X509_V_FLAG_IGNORE_CRITICAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_INHIBIT_MAP", (void *)_cffi_const_X509_V_FLAG_INHIBIT_MAP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_PARTIAL_CHAIN", (void *)_cffi_const_X509_V_FLAG_PARTIAL_CHAIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_POLICY_CHECK", (void *)_cffi_const_X509_V_FLAG_POLICY_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_FLAG_X509_STRICT", (void *)_cffi_const_X509_V_FLAG_X509_STRICT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_V_OK", (void *)_cffi_const_X509_V_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "X509_add_ext", (void *)_cffi_f_X509_add_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 882), (void *)_cffi_d_X509_add_ext },
  { "X509_alias_get0", (void *)_cffi_f_X509_alias_get0, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1201), (void *)_cffi_d_X509_alias_get0 },
  { "X509_alias_set1", (void *)_cffi_f_X509_alias_set1, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 895), (void *)_cffi_d_X509_alias_set1 },
  { "X509_digest", (void *)_cffi_f_X509_digest, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 903), (void *)_cffi_d_X509_digest },
  { "X509_dup", (void *)_cffi_f_X509_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_X509_dup },
  { "X509_free", (void *)_cffi_f_X509_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1436), (void *)_cffi_d_X509_free },
  { "X509_get0_tbs_sigalg", (void *)_cffi_f_X509_get0_tbs_sigalg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_X509_get0_tbs_sigalg },
  { "X509_get_default_cert_dir", (void *)_cffi_f_X509_get_default_cert_dir, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 381), (void *)_cffi_d_X509_get_default_cert_dir },
  { "X509_get_default_cert_dir_env", (void *)_cffi_f_X509_get_default_cert_dir_env, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 381), (void *)_cffi_d_X509_get_default_cert_dir_env },
  { "X509_get_default_cert_file", (void *)_cffi_f_X509_get_default_cert_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 381), (void *)_cffi_d_X509_get_default_cert_file },
  { "X509_get_default_cert_file_env", (void *)_cffi_f_X509_get_default_cert_file_env, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 381), (void *)_cffi_d_X509_get_default_cert_file_env },
  { "X509_get_ext", (void *)_cffi_f_X509_get_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 262), (void *)_cffi_d_X509_get_ext },
  { "X509_get_ext_count", (void *)_cffi_f_X509_get_ext_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 900), (void *)_cffi_d_X509_get_ext_count },
  { "X509_get_issuer_name", (void *)_cffi_f_X509_get_issuer_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_X509_get_issuer_name },
  { "X509_get_pubkey", (void *)_cffi_f_X509_get_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_X509_get_pubkey },
  { "X509_get_serialNumber", (void *)_cffi_f_X509_get_serialNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 10), (void *)_cffi_d_X509_get_serialNumber },
  { "X509_get_subject_name", (void *)_cffi_f_X509_get_subject_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 290), (void *)_cffi_d_X509_get_subject_name },
  { "X509_get_version", (void *)_cffi_f_X509_get_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1156), (void *)_cffi_d_X509_get_version },
  { "X509_getm_notAfter", (void *)_cffi_f_X509_getm_notAfter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_X509_getm_notAfter },
  { "X509_getm_notBefore", (void *)_cffi_f_X509_getm_notBefore, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_X509_getm_notBefore },
  { "X509_gmtime_adj", (void *)_cffi_f_X509_gmtime_adj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_X509_gmtime_adj },
  { "X509_new", (void *)_cffi_f_X509_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 239), (void *)_cffi_d_X509_new },
  { "X509_print_ex", (void *)_cffi_f_X509_print_ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 467), (void *)_cffi_d_X509_print_ex },
  { "X509_set_issuer_name", (void *)_cffi_f_X509_set_issuer_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 887), (void *)_cffi_d_X509_set_issuer_name },
  { "X509_set_pubkey", (void *)_cffi_f_X509_set_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 873), (void *)_cffi_d_X509_set_pubkey },
  { "X509_set_serialNumber", (void *)_cffi_f_X509_set_serialNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 869), (void *)_cffi_d_X509_set_serialNumber },
  { "X509_set_subject_name", (void *)_cffi_f_X509_set_subject_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 887), (void *)_cffi_d_X509_set_subject_name },
  { "X509_set_version", (void *)_cffi_f_X509_set_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 891), (void *)_cffi_d_X509_set_version },
  { "X509_sign", (void *)_cffi_f_X509_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 877), (void *)_cffi_d_X509_sign },
  { "X509_subject_name_hash", (void *)_cffi_f_X509_subject_name_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1222), (void *)_cffi_d_X509_subject_name_hash },
  { "X509_up_ref", (void *)_cffi_f_X509_up_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 866), (void *)_cffi_d_X509_up_ref },
  { "X509_verify_cert", (void *)_cffi_f_X509_verify_cert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1031), (void *)_cffi_d_X509_verify_cert },
  { "X509_verify_cert_error_string", (void *)_cffi_f_X509_verify_cert_error_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 375), (void *)_cffi_d_X509_verify_cert_error_string },
  { "d2i_PKCS12_bio", (void *)_cffi_f_d2i_PKCS12_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 151), (void *)_cffi_d_d2i_PKCS12_bio },
  { "d2i_PKCS7_bio", (void *)_cffi_f_d2i_PKCS7_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_d2i_PKCS7_bio },
  { "d2i_PUBKEY_bio", (void *)_cffi_f_d2i_PUBKEY_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_d2i_PUBKEY_bio },
  { "d2i_PrivateKey_bio", (void *)_cffi_f_d2i_PrivateKey_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_d2i_PrivateKey_bio },
  { "d2i_X509_CRL_bio", (void *)_cffi_f_d2i_X509_CRL_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 244), (void *)_cffi_d_d2i_X509_CRL_bio },
  { "d2i_X509_REQ_bio", (void *)_cffi_f_d2i_X509_REQ_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 312), (void *)_cffi_d_d2i_X509_REQ_bio },
  { "d2i_X509_bio", (void *)_cffi_f_d2i_X509_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 216), (void *)_cffi_d_d2i_X509_bio },
  { "i2a_ASN1_INTEGER", (void *)_cffi_f_i2a_ASN1_INTEGER, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 433), (void *)_cffi_d_i2a_ASN1_INTEGER },
  { "i2d_PKCS12_bio", (void *)_cffi_f_i2d_PKCS12_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 454), (void *)_cffi_d_i2d_PKCS12_bio },
  { "i2d_PUBKEY_bio", (void *)_cffi_f_i2d_PUBKEY_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 437), (void *)_cffi_d_i2d_PUBKEY_bio },
  { "i2d_PrivateKey_bio", (void *)_cffi_f_i2d_PrivateKey_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 437), (void *)_cffi_d_i2d_PrivateKey_bio },
  { "i2d_X509_CRL_bio", (void *)_cffi_f_i2d_X509_CRL_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 473), (void *)_cffi_d_i2d_X509_CRL_bio },
  { "i2d_X509_NAME", (void *)_cffi_f_i2d_X509_NAME, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 957), (void *)_cffi_d_i2d_X509_NAME },
  { "i2d_X509_REQ_bio", (void *)_cffi_f_i2d_X509_REQ_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 483), (void *)_cffi_d_i2d_X509_REQ_bio },
  { "i2d_X509_bio", (void *)_cffi_f_i2d_X509_bio, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 463), (void *)_cffi_d_i2d_X509_bio },
  { "sk_GENERAL_NAME_num", (void *)_cffi_f_sk_GENERAL_NAME_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 620), (void *)_cffi_d_sk_GENERAL_NAME_num },
  { "sk_GENERAL_NAME_value", (void *)_cffi_f_sk_GENERAL_NAME_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_sk_GENERAL_NAME_value },
  { "sk_X509_EXTENSION_free", (void *)_cffi_f_sk_X509_EXTENSION_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1456), (void *)_cffi_d_sk_X509_EXTENSION_free },
  { "sk_X509_EXTENSION_new_null", (void *)_cffi_f_sk_X509_EXTENSION_new_null, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 284), (void *)_cffi_d_sk_X509_EXTENSION_new_null },
  { "sk_X509_EXTENSION_num", (void *)_cffi_f_sk_X509_EXTENSION_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 936), (void *)_cffi_d_sk_X509_EXTENSION_num },
  { "sk_X509_EXTENSION_pop_free", (void *)_cffi_f_sk_X509_EXTENSION_pop_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 1459), (void *)_cffi_d_sk_X509_EXTENSION_pop_free },
  { "sk_X509_EXTENSION_push", (void *)_cffi_f_sk_X509_EXTENSION_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 939), (void *)_cffi_d_sk_X509_EXTENSION_push },
  { "sk_X509_EXTENSION_value", (void *)_cffi_f_sk_X509_EXTENSION_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 269), (void *)_cffi_d_sk_X509_EXTENSION_value },
  { "sk_X509_NAME_free", (void *)_cffi_f_sk_X509_NAME_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1267), (void *)_cffi_d_sk_X509_NAME_free },
  { "sk_X509_NAME_new_null", (void *)_cffi_f_sk_X509_NAME_new_null, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 75), (void *)_cffi_d_sk_X509_NAME_new_null },
  { "sk_X509_NAME_num", (void *)_cffi_f_sk_X509_NAME_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 510), (void *)_cffi_d_sk_X509_NAME_num },
  { "sk_X509_NAME_push", (void *)_cffi_f_sk_X509_NAME_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 513), (void *)_cffi_d_sk_X509_NAME_push },
  { "sk_X509_NAME_value", (void *)_cffi_f_sk_X509_NAME_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 286), (void *)_cffi_d_sk_X509_NAME_value },
  { "sk_X509_OBJECT_num", (void *)_cffi_f_sk_X509_OBJECT_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 517), (void *)_cffi_d_sk_X509_OBJECT_num },
  { "sk_X509_REVOKED_num", (void *)_cffi_f_sk_X509_REVOKED_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 520), (void *)_cffi_d_sk_X509_REVOKED_num },
  { "sk_X509_REVOKED_value", (void *)_cffi_f_sk_X509_REVOKED_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 324), (void *)_cffi_d_sk_X509_REVOKED_value },
  { "sk_X509_free", (void *)_cffi_f_sk_X509_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 1264), (void *)_cffi_d_sk_X509_free },
  { "sk_X509_new_null", (void *)_cffi_f_sk_X509_new_null, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 67), (void *)_cffi_d_sk_X509_new_null },
  { "sk_X509_num", (void *)_cffi_f_sk_X509_num, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 503), (void *)_cffi_d_sk_X509_num },
  { "sk_X509_push", (void *)_cffi_f_sk_X509_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 506), (void *)_cffi_d_sk_X509_push },
  { "sk_X509_value", (void *)_cffi_f_sk_X509_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_sk_X509_value },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "type", offsetof(ASN1_TYPE, type),
            sizeof(((ASN1_TYPE *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "nid", offsetof(EC_builtin_curve, nid),
           sizeof(((EC_builtin_curve *)0)->nid),
           _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "comment", offsetof(EC_builtin_curve, comment),
               sizeof(((EC_builtin_curve *)0)->comment),
               _CFFI_OP(_CFFI_OP_NOOP, 50) },
  { "type", offsetof(GENERAL_NAME, type),
            sizeof(((GENERAL_NAME *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "d", offsetof(GENERAL_NAME, d),
         sizeof(((GENERAL_NAME *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 1609) },
  { "type", offsetof(PKCS7, type),
            sizeof(((PKCS7 *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 1528) },
  { "d", offsetof(PKCS7, d),
         sizeof(((PKCS7 *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 1610) },
  { "cert", offsetof(PKCS7_SIGNED, cert),
            sizeof(((PKCS7_SIGNED *)0)->cert),
            _CFFI_OP(_CFFI_OP_NOOP, 160) },
  { "name", offsetof(SRTP_PROTECTION_PROFILE, name),
            sizeof(((SRTP_PROTECTION_PROFILE *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 50) },
  { "id", offsetof(SRTP_PROTECTION_PROFILE, id),
          sizeof(((SRTP_PROTECTION_PROFILE *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 379) },
  { "issuer_cert", offsetof(X509V3_CTX, issuer_cert),
                   sizeof(((X509V3_CTX *)0)->issuer_cert),
                   _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "subject_cert", offsetof(X509V3_CTX, subject_cert),
                    sizeof(((X509V3_CTX *)0)->subject_cert),
                    _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "length", offsetof(ASN1_OCTET_STRING, length),
              sizeof(((ASN1_OCTET_STRING *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "type", offsetof(ASN1_OCTET_STRING, type),
            sizeof(((ASN1_OCTET_STRING *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 55) },
  { "data", offsetof(ASN1_OCTET_STRING, data),
            sizeof(((ASN1_OCTET_STRING *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 445) },
  { "flags", offsetof(ASN1_OCTET_STRING, flags),
             sizeof(((ASN1_OCTET_STRING *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 24) },
  { "ia5", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "ptr", (size_t)-1,
           (size_t)-1,
           _CFFI_OP(_CFFI_OP_NOOP, 156) },
  { "data", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 23) },
  { "sign", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 1575) },
  { "enveloped", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1573) },
  { "signed_and_enveloped", (size_t)-1,
                            (size_t)-1,
                            _CFFI_OP(_CFFI_OP_NOOP, 1578) },
  { "digest", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 1569) },
  { "encrypted", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 1571) },
  { "other", (size_t)-1,
             (size_t)-1,
             _CFFI_OP(_CFFI_OP_NOOP, 1531) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 1609, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 16, 1 /* unnamed */ },
  { "$2", 1610, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 17, 8 /* unnamed */ },
  { "$ASN1_ENUMERATED", 1525, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$ASN1_GENERALIZEDTIME", 1526, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$ASN1_INTEGER", 1527, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$ASN1_OBJECT", 1529, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$ASN1_TYPE", 1532, 0,
    sizeof(ASN1_TYPE), offsetof(struct _cffi_align_typedef_ASN1_TYPE, y), 0, 1 },
  { "$BIGNUM", 1533, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BIO", 1534, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BIO_ADDR", 1535, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BIO_METHOD", 1537, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BN_CTX", 1538, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$BN_GENCB", 1539, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$CONF", 1540, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_ASN1_OBJECT", 1541, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509", 1542, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509_CRL", 1543, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509_NAME", 1544, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509_NAME_ENTRY", 1545, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509_OBJECT", 1546, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$Cryptography_STACK_OF_X509_REVOKED", 1547, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$DH", 1548, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$DSA", 1549, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EC_GROUP", 1550, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EC_KEY", 1551, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EC_POINT", 1552, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EC_builtin_curve", 1553, _CFFI_F_CHECK_FIELDS,
    sizeof(EC_builtin_curve), offsetof(struct _cffi_align_typedef_EC_builtin_curve, y), 1, 2 },
  { "$ENGINE", 1554, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_CIPHER", 1555, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_CIPHER_CTX", 1556, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_MD", 1557, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_MD_CTX", 1558, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_PKEY", 1559, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EVP_PKEY_CTX", 1560, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$EXTENDED_KEY_USAGE", 1561, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$GENERAL_NAME", 1562, 0,
    sizeof(GENERAL_NAME), offsetof(struct _cffi_align_typedef_GENERAL_NAME, y), 3, 2 },
  { "$GENERAL_NAMES", 1563, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$NETSCAPE_SPKI", 1564, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$OSSL_LIB_CTX", 1565, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$OSSL_PROVIDER", 1566, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS12", 1567, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS7", 1568, 0,
    sizeof(PKCS7), offsetof(struct _cffi_align_typedef_PKCS7, y), 5, 2 },
  { "$PKCS7_DIGEST", 1570, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS7_ENCRYPT", 1572, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS7_ENVELOPE", 1574, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS7_SIGNED", 1576, 0,
    sizeof(PKCS7_SIGNED), offsetof(struct _cffi_align_typedef_PKCS7_SIGNED, y), 7, 1 },
  { "$PKCS7_SIGNER_INFO", 1577, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS7_SIGN_ENVELOPE", 1579, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$PKCS8_PRIV_KEY_INFO", 1580, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$RAND_METHOD", 1581, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$RSA", 1582, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SRTP_PROTECTION_PROFILE", 1584, _CFFI_F_CHECK_FIELDS,
    sizeof(SRTP_PROTECTION_PROFILE), offsetof(struct _cffi_align_typedef_SRTP_PROTECTION_PROFILE, y), 8, 2 },
  { "$SSL", 1585, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SSL_CIPHER", 1586, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SSL_CTX", 1587, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SSL_METHOD", 1589, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$SSL_SESSION", 1590, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$UI_METHOD", 1591, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509", 1592, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509V3_CTX", 1593, 0,
    sizeof(X509V3_CTX), offsetof(struct _cffi_align_typedef_X509V3_CTX, y), 10, 2 },
  { "$X509_ALGOR", 1594, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_ATTRIBUTE", 1595, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_CRL", 1596, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_EXTENSION", 1597, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_EXTENSIONS", 1598, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_NAME", 1599, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_NAME_ENTRY", 1600, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_OBJECT", 1601, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_REQ", 1602, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_REVOKED", 1603, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_STORE", 1604, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_STORE_CTX", 1605, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$X509_VERIFY_PARAM", 1606, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "asn1_string_st", 1530, _CFFI_F_CHECK_FIELDS,
    sizeof(ASN1_OCTET_STRING), offsetof(struct _cffi_align__ASN1_OCTET_STRING, y), 12, 4 },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ASN1_BIT_STRING", 1530 },
  { "ASN1_ENUMERATED", 1525 },
  { "ASN1_GENERALIZEDTIME", 1526 },
  { "ASN1_IA5STRING", 1530 },
  { "ASN1_INTEGER", 1527 },
  { "ASN1_OBJECT", 1529 },
  { "ASN1_OCTET_STRING", 1530 },
  { "ASN1_STRING", 1530 },
  { "ASN1_TIME", 1530 },
  { "ASN1_TYPE", 1532 },
  { "ASN1_UTF8STRING", 1530 },
  { "BIGNUM", 1533 },
  { "BIO", 1534 },
  { "BIO_ADDR", 1535 },
  { "BIO_METHOD", 1537 },
  { "BN_CTX", 1538 },
  { "BN_GENCB", 1539 },
  { "BN_ULONG", 414 },
  { "CONF", 1540 },
  { "Cryptography_STACK_OF_ASN1_OBJECT", 1541 },
  { "Cryptography_STACK_OF_X509", 1542 },
  { "Cryptography_STACK_OF_X509_CRL", 1543 },
  { "Cryptography_STACK_OF_X509_NAME", 1544 },
  { "Cryptography_STACK_OF_X509_NAME_ENTRY", 1545 },
  { "Cryptography_STACK_OF_X509_OBJECT", 1546 },
  { "Cryptography_STACK_OF_X509_REVOKED", 1547 },
  { "DH", 1548 },
  { "DSA", 1549 },
  { "EC_GROUP", 1550 },
  { "EC_KEY", 1551 },
  { "EC_POINT", 1552 },
  { "EC_builtin_curve", 1553 },
  { "ENGINE", 1554 },
  { "EVP_CIPHER", 1555 },
  { "EVP_CIPHER_CTX", 1556 },
  { "EVP_MD", 1557 },
  { "EVP_MD_CTX", 1558 },
  { "EVP_PKEY", 1559 },
  { "EVP_PKEY_CTX", 1560 },
  { "EXTENDED_KEY_USAGE", 1561 },
  { "GENERAL_NAME", 1562 },
  { "GENERAL_NAMES", 1563 },
  { "NETSCAPE_SPKI", 1564 },
  { "OSSL_LIB_CTX", 1565 },
  { "OSSL_PROVIDER", 1566 },
  { "PKCS12", 1567 },
  { "PKCS7", 1568 },
  { "PKCS7_DIGEST", 1570 },
  { "PKCS7_ENCRYPT", 1572 },
  { "PKCS7_ENVELOPE", 1574 },
  { "PKCS7_SIGNED", 1576 },
  { "PKCS7_SIGNER_INFO", 1577 },
  { "PKCS7_SIGN_ENVELOPE", 1579 },
  { "PKCS8_PRIV_KEY_INFO", 1580 },
  { "RAND_METHOD", 1581 },
  { "RSA", 1582 },
  { "SRTP_PROTECTION_PROFILE", 1584 },
  { "SSL", 1585 },
  { "SSL_CIPHER", 1586 },
  { "SSL_CTX", 1587 },
  { "SSL_METHOD", 1589 },
  { "SSL_SESSION", 1590 },
  { "UI_METHOD", 1591 },
  { "X509", 1592 },
  { "X509V3_CTX", 1593 },
  { "X509_ALGOR", 1594 },
  { "X509_ATTRIBUTE", 1595 },
  { "X509_CRL", 1596 },
  { "X509_EXTENSION", 1597 },
  { "X509_EXTENSIONS", 1598 },
  { "X509_NAME", 1599 },
  { "X509_NAME_ENTRY", 1600 },
  { "X509_OBJECT", 1601 },
  { "X509_REQ", 1602 },
  { "X509_REVOKED", 1603 },
  { "X509_STORE", 1604 },
  { "X509_STORE_CTX", 1605 },
  { "X509_STORE_CTX_get_issuer_fn", 1608 },
  { "X509_VERIFY_PARAM", 1606 },
  { "custom_ext_add_cb", 839 },
  { "custom_ext_free_cb", 840 },
  { "custom_ext_parse_cb", 842 },
  { "pem_password_cb", 1054 },
  { "sk_X509_EXTENSION_freefunc", 1461 },
  { "time_t", 1490 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  720,  /* num_globals */
  74,  /* num_struct_unions */
  0,  /* num_enums */
  85,  /* num_typenames */
  NULL,  /* no includes */
  1613,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__openssl(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__openssl(void) { return NULL; }
#  else
     init_openssl(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__openssl(void)
{
  return _cffi_init("_openssl", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_openssl(void)
{
  _cffi_init("_openssl", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
