__all__: list[str] = []

import cv2
import cv2.typing
import typing as _typing


# Enumerations
SFM_IO_BUNDLER: int
SFM_IO_VISUALSFM: int
SFM_IO_OPENSFM: int
SFM_IO_OPENMVG: int
SFM_IO_THEIASFM: int
SFM_DISTORTION_MODEL_POLYNOMIAL: int
SFM_DISTORTION_MODEL_DIVISION: int
SFM_REFINE_FOCAL_LENGTH: int
SFM_REFINE_PRINCIPAL_POINT: int
SFM_REFINE_RADIAL_DISTORTION_K1: int
SFM_REFINE_RADIAL_DISTORTION_K2: int



# Classes
class libmv_CameraIntrinsicsOptions:
    distortion_model: int
    image_width: int
    image_height: int
    focal_length_x: float
    focal_length_y: float
    principal_point_x: float
    principal_point_y: float
    polynomial_k1: float
    polynomial_k2: float
    polynomial_k3: float
    polynomial_p1: float
    polynomial_p2: float
    division_k1: float
    division_k2: float

    # Functions
    def __init__(self, _distortion_model: int = ..., _focal_length_x: float = ..., _focal_length_y: float = ..., _principal_point_x: float = ..., _principal_point_y: float = ..., _polynomial_k1: float = ..., _polynomial_k2: float = ..., _polynomial_k3: float = ..., _polynomial_p1: float = ..., _polynomial_p2: float = ...) -> None: ...


class libmv_ReconstructionOptions:
    keyframe1: int
    keyframe2: int
    refine_intrinsics: int
    select_keyframes: int
    verbosity_level: int

    # Functions
    def __init__(self, _keyframe1: int = ..., _keyframe2: int = ..., _refine_intrinsics: int = ..., _select_keyframes: int = ..., _verbosity_level: int = ...) -> None: ...


class BaseSFM:
    # Functions
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.typing.MatLike]) -> None: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.UMat]) -> None: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.typing.MatLike], K: cv2.typing.MatLike, Rs: cv2.typing.MatLike | None = ..., Ts: cv2.typing.MatLike | None = ..., points3d: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike, cv2.typing.MatLike, cv2.typing.MatLike]: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.UMat], K: cv2.UMat, Rs: cv2.UMat | None = ..., Ts: cv2.UMat | None = ..., points3d: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat, cv2.UMat, cv2.UMat]: ...

    def getError(self) -> float: ...

    @_typing.overload
    def getPoints(self, points3d: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def getPoints(self, points3d: cv2.UMat | None = ...) -> cv2.UMat: ...

    def getIntrinsics(self) -> cv2.typing.MatLike: ...

    @_typing.overload
    def getCameras(self, Rs: cv2.typing.MatLike | None = ..., Ts: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
    @_typing.overload
    def getCameras(self, Rs: cv2.UMat | None = ..., Ts: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

    def setReconstructionOptions(self, libmv_reconstruction_options: libmv_ReconstructionOptions) -> None: ...

    def setCameraIntrinsicOptions(self, libmv_camera_intrinsics_options: libmv_CameraIntrinsicsOptions) -> None: ...


class SFMLibmvEuclideanReconstruction(BaseSFM):
    # Functions
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.typing.MatLike]) -> None: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.UMat]) -> None: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.typing.MatLike], K: cv2.typing.MatLike, Rs: cv2.typing.MatLike | None = ..., Ts: cv2.typing.MatLike | None = ..., points3d: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike, cv2.typing.MatLike, cv2.typing.MatLike]: ...
    @_typing.overload
    def run(self, points2d: _typing.Sequence[cv2.UMat], K: cv2.UMat, Rs: cv2.UMat | None = ..., Ts: cv2.UMat | None = ..., points3d: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat, cv2.UMat, cv2.UMat]: ...

    def getError(self) -> float: ...

    @_typing.overload
    def getPoints(self, points3d: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
    @_typing.overload
    def getPoints(self, points3d: cv2.UMat | None = ...) -> cv2.UMat: ...

    def getIntrinsics(self) -> cv2.typing.MatLike: ...

    @_typing.overload
    def getCameras(self, Rs: cv2.typing.MatLike | None = ..., Ts: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
    @_typing.overload
    def getCameras(self, Rs: cv2.UMat | None = ..., Ts: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

    def setReconstructionOptions(self, libmv_reconstruction_options: libmv_ReconstructionOptions) -> None: ...

    def setCameraIntrinsicOptions(self, libmv_camera_intrinsics_options: libmv_CameraIntrinsicsOptions) -> None: ...



# Functions
@_typing.overload
def KRtFromProjection(P: cv2.typing.MatLike, K: cv2.typing.MatLike | None = ..., R: cv2.typing.MatLike | None = ..., t: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def KRtFromProjection(P: cv2.UMat, K: cv2.UMat | None = ..., R: cv2.UMat | None = ..., t: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat, cv2.UMat]: ...

@_typing.overload
def applyTransformationToPoints(points: cv2.typing.MatLike, T: cv2.typing.MatLike, transformed_points: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def applyTransformationToPoints(points: cv2.UMat, T: cv2.UMat, transformed_points: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def computeOrientation(x1: _typing.Sequence[cv2.typing.MatLike], x2: _typing.Sequence[cv2.typing.MatLike], s: float, R: cv2.typing.MatLike | None = ..., t: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def computeOrientation(x1: _typing.Sequence[cv2.UMat], x2: _typing.Sequence[cv2.UMat], s: float, R: cv2.UMat | None = ..., t: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def depth(R: cv2.typing.MatLike, t: cv2.typing.MatLike, X: cv2.typing.MatLike) -> float: ...
@_typing.overload
def depth(R: cv2.UMat, t: cv2.UMat, X: cv2.UMat) -> float: ...

@_typing.overload
def essentialFromFundamental(F: cv2.typing.MatLike, K1: cv2.typing.MatLike, K2: cv2.typing.MatLike, E: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def essentialFromFundamental(F: cv2.UMat, K1: cv2.UMat, K2: cv2.UMat, E: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def essentialFromRt(R1: cv2.typing.MatLike, t1: cv2.typing.MatLike, R2: cv2.typing.MatLike, t2: cv2.typing.MatLike, E: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def essentialFromRt(R1: cv2.UMat, t1: cv2.UMat, R2: cv2.UMat, t2: cv2.UMat, E: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def euclideanToHomogeneous(src: cv2.typing.MatLike, dst: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def euclideanToHomogeneous(src: cv2.UMat, dst: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def fundamentalFromCorrespondences7PointRobust(x1: cv2.typing.MatLike, x2: cv2.typing.MatLike, max_error: float, F: cv2.typing.MatLike | None = ..., inliers: cv2.typing.MatLike | None = ..., outliers_probability: float = ...) -> tuple[float, cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def fundamentalFromCorrespondences7PointRobust(x1: cv2.UMat, x2: cv2.UMat, max_error: float, F: cv2.UMat | None = ..., inliers: cv2.UMat | None = ..., outliers_probability: float = ...) -> tuple[float, cv2.UMat, cv2.UMat]: ...

@_typing.overload
def fundamentalFromCorrespondences8PointRobust(x1: cv2.typing.MatLike, x2: cv2.typing.MatLike, max_error: float, F: cv2.typing.MatLike | None = ..., inliers: cv2.typing.MatLike | None = ..., outliers_probability: float = ...) -> tuple[float, cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def fundamentalFromCorrespondences8PointRobust(x1: cv2.UMat, x2: cv2.UMat, max_error: float, F: cv2.UMat | None = ..., inliers: cv2.UMat | None = ..., outliers_probability: float = ...) -> tuple[float, cv2.UMat, cv2.UMat]: ...

@_typing.overload
def fundamentalFromEssential(E: cv2.typing.MatLike, K1: cv2.typing.MatLike, K2: cv2.typing.MatLike, F: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def fundamentalFromEssential(E: cv2.UMat, K1: cv2.UMat, K2: cv2.UMat, F: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def fundamentalFromProjections(P1: cv2.typing.MatLike, P2: cv2.typing.MatLike, F: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def fundamentalFromProjections(P1: cv2.UMat, P2: cv2.UMat, F: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def homogeneousToEuclidean(src: cv2.typing.MatLike, dst: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def homogeneousToEuclidean(src: cv2.UMat, dst: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def importReconstruction(file: str, Rs: _typing.Sequence[cv2.typing.MatLike] | None = ..., Ts: _typing.Sequence[cv2.typing.MatLike] | None = ..., Ks: _typing.Sequence[cv2.typing.MatLike] | None = ..., points3d: _typing.Sequence[cv2.typing.MatLike] | None = ..., file_format: int = ...) -> tuple[_typing.Sequence[cv2.typing.MatLike], _typing.Sequence[cv2.typing.MatLike], _typing.Sequence[cv2.typing.MatLike], _typing.Sequence[cv2.typing.MatLike]]: ...
@_typing.overload
def importReconstruction(file: str, Rs: _typing.Sequence[cv2.UMat] | None = ..., Ts: _typing.Sequence[cv2.UMat] | None = ..., Ks: _typing.Sequence[cv2.UMat] | None = ..., points3d: _typing.Sequence[cv2.UMat] | None = ..., file_format: int = ...) -> tuple[_typing.Sequence[cv2.UMat], _typing.Sequence[cv2.UMat], _typing.Sequence[cv2.UMat], _typing.Sequence[cv2.UMat]]: ...

@_typing.overload
def isotropicPreconditionerFromPoints(points: cv2.typing.MatLike, T: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def isotropicPreconditionerFromPoints(points: cv2.UMat, T: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def meanAndVarianceAlongRows(A: cv2.typing.MatLike, mean: cv2.typing.MatLike | None = ..., variance: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def meanAndVarianceAlongRows(A: cv2.UMat, mean: cv2.UMat | None = ..., variance: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def motionFromEssential(E: cv2.typing.MatLike, Rs: _typing.Sequence[cv2.typing.MatLike] | None = ..., ts: _typing.Sequence[cv2.typing.MatLike] | None = ...) -> tuple[_typing.Sequence[cv2.typing.MatLike], _typing.Sequence[cv2.typing.MatLike]]: ...
@_typing.overload
def motionFromEssential(E: cv2.UMat, Rs: _typing.Sequence[cv2.UMat] | None = ..., ts: _typing.Sequence[cv2.UMat] | None = ...) -> tuple[_typing.Sequence[cv2.UMat], _typing.Sequence[cv2.UMat]]: ...

@_typing.overload
def motionFromEssentialChooseSolution(Rs: _typing.Sequence[cv2.typing.MatLike], ts: _typing.Sequence[cv2.typing.MatLike], K1: cv2.typing.MatLike, x1: cv2.typing.MatLike, K2: cv2.typing.MatLike, x2: cv2.typing.MatLike) -> int: ...
@_typing.overload
def motionFromEssentialChooseSolution(Rs: _typing.Sequence[cv2.UMat], ts: _typing.Sequence[cv2.UMat], K1: cv2.UMat, x1: cv2.UMat, K2: cv2.UMat, x2: cv2.UMat) -> int: ...

@_typing.overload
def normalizeFundamental(F: cv2.typing.MatLike, F_normalized: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def normalizeFundamental(F: cv2.UMat, F_normalized: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def normalizeIsotropicPoints(points: cv2.typing.MatLike, normalized_points: cv2.typing.MatLike | None = ..., T: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def normalizeIsotropicPoints(points: cv2.UMat, normalized_points: cv2.UMat | None = ..., T: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def normalizePoints(points: cv2.typing.MatLike, normalized_points: cv2.typing.MatLike | None = ..., T: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def normalizePoints(points: cv2.UMat, normalized_points: cv2.UMat | None = ..., T: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def normalizedEightPointSolver(x1: cv2.typing.MatLike, x2: cv2.typing.MatLike, F: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def normalizedEightPointSolver(x1: cv2.UMat, x2: cv2.UMat, F: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def preconditionerFromPoints(points: cv2.typing.MatLike, T: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def preconditionerFromPoints(points: cv2.UMat, T: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def projectionFromKRt(K: cv2.typing.MatLike, R: cv2.typing.MatLike, t: cv2.typing.MatLike, P: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def projectionFromKRt(K: cv2.UMat, R: cv2.UMat, t: cv2.UMat, P: cv2.UMat | None = ...) -> cv2.UMat: ...

@_typing.overload
def projectionsFromFundamental(F: cv2.typing.MatLike, P1: cv2.typing.MatLike | None = ..., P2: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def projectionsFromFundamental(F: cv2.UMat, P1: cv2.UMat | None = ..., P2: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def relativeCameraMotion(R1: cv2.typing.MatLike, t1: cv2.typing.MatLike, R2: cv2.typing.MatLike, t2: cv2.typing.MatLike, R: cv2.typing.MatLike | None = ..., t: cv2.typing.MatLike | None = ...) -> tuple[cv2.typing.MatLike, cv2.typing.MatLike]: ...
@_typing.overload
def relativeCameraMotion(R1: cv2.UMat, t1: cv2.UMat, R2: cv2.UMat, t2: cv2.UMat, R: cv2.UMat | None = ..., t: cv2.UMat | None = ...) -> tuple[cv2.UMat, cv2.UMat]: ...

@_typing.overload
def skew(x: cv2.typing.MatLike) -> cv2.typing.MatLike: ...
@_typing.overload
def skew(x: cv2.UMat) -> cv2.typing.MatLike: ...

@_typing.overload
def triangulatePoints(points2d: _typing.Sequence[cv2.typing.MatLike], projection_matrices: _typing.Sequence[cv2.typing.MatLike], points3d: cv2.typing.MatLike | None = ...) -> cv2.typing.MatLike: ...
@_typing.overload
def triangulatePoints(points2d: _typing.Sequence[cv2.UMat], projection_matrices: _typing.Sequence[cv2.UMat], points3d: cv2.UMat | None = ...) -> cv2.UMat: ...


