/*
 * Copyright (C) 2007 OpenedHand Ltd
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 */

#include <gtk/gtk.h>
#include <vte/vte.h>
#include <glib.h>

static void
on_window_title_changed (VteTerminal *terminal, GtkWindow *window)
{
  char *title;

  title = g_strdup_printf ("%s - Terminal",
                           vte_terminal_get_window_title (terminal));
  gtk_window_set_title (window, title);
  g_free (title);
