/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-xnap.c                                                              */
/* asn2wrs.py -L -p xnap -c ./xnap.cnf -s ./packet-xnap-template -D . -O ../.. XnAP-CommonDataTypes.asn XnAP-Constants.asn XnAP-Containers.asn XnAP-IEs.asn XnAP-PDU-Contents.asn XnAP-PDU-Descriptions.asn */

/* packet-xnap.c
 * Routines for dissecting NG-RAN Xn application protocol (XnAP)
 * 3GPP TS 38.423 packet dissection
 * Copyright 2018-2023, Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref:
 * 3GPP TS 38.423 V17.5.0 (2023-06)
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/prefs.h>
#include <epan/sctpppids.h>
#include <epan/proto_data.h>
#include <epan/conversation.h>

#include "packet-xnap.h"
#include "packet-per.h"
#include "packet-lte-rrc.h"
#include "packet-nr-rrc.h"
#include "packet-e212.h"
#include "packet-ngap.h"
#include "packet-s1ap.h"
#include "packet-ranap.h"
#include "packet-ntp.h"
#include "packet-f1ap.h"

#ifdef _MSC_VER
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "NG-RAN Xn Application Protocol (XnAP)"
#define PSNAME "XnAP"
#define PFNAME "xnap"

/* Dissector will use SCTP PPID 61 or SCTP port. IANA assigned port = 38422 */
#define SCTP_PORT_XnAP	38422

#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxEARFCN                      262143
#define maxnoofAllowedAreas            16
#define maxnoofAMFRegions              16
#define maxnoofAoIs                    64
#define maxnoofBluetoothName           4
#define maxnoofBPLMNs                  12
#define maxnoofCAGs                    12
#define maxnoofCAGsperPLMN             256
#define maxnoofCellIDforMDT            32
#define maxnoofCellsinAoI              256
#define maxnoofCellsinUEHistoryInfo    16
#define maxnoofCellsinNG_RANnode       16384
#define maxnoofCellsinRNA              32
#define maxnoofCellsUEMovingTrajectory 16
#define maxnoofDRBs                    32
#define maxnoofEUTRABands              16
#define maxnoofEUTRABPLMNs             6
#define maxnoofEPLMNs                  15
#define maxnoofExtSliceItems           65535
#define maxnoofEPLMNsplus1             16
#define maxnoofForbiddenTACs           4096
#define maxnoofFreqforMDT              8
#define maxnoofMBSFNEUTRA              8
#define maxnoofMDTPLMNs                16
#define maxnoofMultiConnectivityMinusOne 3
#define maxnoofNeighbours              1024
#define maxnoofNeighPCIforMDT          32
#define maxnoofNIDs                    12
#define maxnoofNRCellBands             32
#define maxnoofPLMNs                   16
#define maxnoofPDUSessions             256
#define maxnoofProtectedResourcePatterns 16
#define maxnoofQoSFlows                64
#define maxnoofQoSParaSets             8
#define maxnoofRANAreaCodes            32
#define maxnoofRANAreasinRNA           16
#define maxnoofRANNodesinAoI           64
#define maxnoofSCellGroups             3
#define maxnoofSCellGroupsplus1        4
#define maxnoofSensorName              3
#define maxnoofSliceItems              1024
#define maxnoofSNPNIDs                 12
#define maxnoofsupportedPLMNs          12
#define maxnoofsupportedTACs           256
#define maxnoofTAforMDT                8
#define maxnoofTAI                     16
#define maxnoofTAIsinAoI               16
#define maxnooftimeperiods             2
#define maxnoofTNLAssociations         32
#define maxnoofUEContexts              8192
#define maxNRARFCN                     3279165
#define maxNrOfErrors                  256
#define maxnoofslots                   5120
#define maxnoofExtTLAs                 16
#define maxnoofGTPTLAs                 16
#define maxnoofCHOcells                8
#define maxnoofPC5QoSFlows             2064
#define maxnoofSSBAreas                64
#define maxnoofRACHReports             64
#define maxnoofNRSCSs                  5
#define maxnoofPhysicalResourceBlocks  275
#define maxnoofAdditionalPDCPDuplicationTNL 2
#define maxnoofRLCDuplicationstate     3
#define maxnoofWLANName                4
#define maxnoofNonAnchorCarrierFreqConfig 15
#define maxnoofDataForwardingTunneltoE_UTRAN 256
#define maxnoofMBSFSAs                 256
#define maxnoofUEIDIndicesforMBSPaging 4096
#define maxnoofMBSQoSFlows             64
#define maxnoofMRBs                    32
#define maxnoofCellsforMBS             8192
#define maxnoofMBSServiceAreaInformation 256
#define maxnoofTAIforMBS               1024
#define maxnoofAssociatedMBSSessions   32
#define maxnoofMBSSessions             256
#define maxnoofSuccessfulHOReports     64
#define maxnoofPSCellsPerSN            8
#define maxnoofNR_UChannelIDs          16
#define maxnoofCellsinCHO              8
#define maxnoofCHOexecutioncond        2
#define maxnoofServedCellsIAB          512
#define maxnoofServingCells            32
#define maxnoofBHInfo                  1024
#define maxnoofTrafficIndexEntries     1024
#define maxnoofTLAsIAB                 1024
#define maxnoofBAPControlPDURLCCHs     2
#define maxnoofIABSTCInfo              45
#define maxnoofSymbols                 14
#define maxnoofDUFSlots                320
#define maxnoofHSNASlots               5120
#define maxnoofRBsetsPerCell           8
#define maxnoofRBsetsPerCell1          7
#define maxnoofChildIABNodes           1024
#define maxnoofPSCellCandidates        8
#define maxnoofTargetSNs               8
#define maxnoofUEAppLayerMeas          16
#define maxnoofSNSSAIforQMC            16
#define maxnoofCellIDforQMC            32
#define maxnoofPLMNforQMC              16
#define maxnoofTAforQMC                8
#define maxnoofMTCItems                16
#define maxnoofCSIRSconfigurations     96
#define maxnoofCSIRSneighbourCells     16
#define maxnoofCSIRSneighbourCellsInMTC 16
#define maxnoofNeighbour_NG_RAN_Nodes  256
#define maxnoofSRBs                    5
#define maxnoofSMBR                    8
#define maxnoofNSAGs                   256
#define maxnoofTargetSNsMinusOne       7
#define maxnoofThresholdsForExcessPacketDelay 255

typedef enum _ProcedureCode_enum {
  id_handoverPreparation =   0,
  id_sNStatusTransfer =   1,
  id_handoverCancel =   2,
  id_retrieveUEContext =   3,
  id_rANPaging =   4,
  id_xnUAddressIndication =   5,
  id_uEContextRelease =   6,
  id_sNGRANnodeAdditionPreparation =   7,
  id_sNGRANnodeReconfigurationCompletion =   8,
  id_mNGRANnodeinitiatedSNGRANnodeModificationPreparation =   9,
  id_sNGRANnodeinitiatedSNGRANnodeModificationPreparation =  10,
  id_mNGRANnodeinitiatedSNGRANnodeRelease =  11,
  id_sNGRANnodeinitiatedSNGRANnodeRelease =  12,
  id_sNGRANnodeCounterCheck =  13,
  id_sNGRANnodeChange =  14,
  id_rRCTransfer =  15,
  id_xnRemoval =  16,
  id_xnSetup   =  17,
  id_nGRANnodeConfigurationUpdate =  18,
  id_cellActivation =  19,
  id_reset     =  20,
  id_errorIndication =  21,
  id_privateMessage =  22,
  id_notificationControl =  23,
  id_activityNotification =  24,
  id_e_UTRA_NR_CellResourceCoordination =  25,
  id_secondaryRATDataUsageReport =  26,
  id_deactivateTrace =  27,
  id_traceStart =  28,
  id_handoverSuccess =  29,
  id_conditionalHandoverCancel =  30,
  id_earlyStatusTransfer =  31,
  id_failureIndication =  32,
  id_handoverReport =  33,
  id_resourceStatusReportingInitiation =  34,
  id_resourceStatusReporting =  35,
  id_mobilitySettingsChange =  36,
  id_accessAndMobilityIndication =  37,
  id_cellTrafficTrace =  38,
  id_RANMulticastGroupPaging =  39,
  id_scgFailureInformationReport =  40,
  id_ProcedureCode41_NotToBeUsed =  41,
  id_scgFailureTransfer =  42,
  id_f1CTrafficTransfer =  43,
  id_iABTransportMigrationManagement =  44,
  id_iABTransportMigrationModification =  45,
  id_iABResourceCoordination =  46,
  id_retrieveUEContextConfirm =  47,
  id_cPCCancel =  48,
  id_partialUEContextTransfer =  49
} ProcedureCode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_ActivatedServedCells =   0,
  id_ActivationIDforCellActivation =   1,
  id_admittedSplitSRB =   2,
  id_admittedSplitSRBrelease =   3,
  id_AMF_Region_Information =   4,
  id_AssistanceDataForRANPaging =   5,
  id_BearersSubjectToCounterCheck =   6,
  id_Cause     =   7,
  id_cellAssistanceInfo_NR =   8,
  id_ConfigurationUpdateInitiatingNodeChoice =   9,
  id_CriticalityDiagnostics =  10,
  id_XnUAddressInfoperPDUSession_List =  11,
  id_DRBsSubjectToStatusTransfer_List =  12,
  id_ExpectedUEBehaviour =  13,
  id_GlobalNG_RAN_node_ID =  14,
  id_GUAMI     =  15,
  id_indexToRatFrequSelectionPriority =  16,
  id_initiatingNodeType_ResourceCoordRequest =  17,
  id_List_of_served_cells_E_UTRA =  18,
  id_List_of_served_cells_NR =  19,
  id_LocationReportingInformation =  20,
  id_MAC_I     =  21,
  id_MaskedIMEISV =  22,
  id_M_NG_RANnodeUEXnAPID =  23,
  id_MN_to_SN_Container =  24,
  id_MobilityRestrictionList =  25,
  id_new_NG_RAN_Cell_Identity =  26,
  id_newNG_RANnodeUEXnAPID =  27,
  id_UEReportRRCTransfer =  28,
  id_oldNG_RANnodeUEXnAPID =  29,
  id_OldtoNewNG_RANnodeResumeContainer =  30,
  id_PagingDRX =  31,
  id_PCellID   =  32,
  id_PDCPChangeIndication =  33,
  id_PDUSessionAdmittedAddedAddReqAck =  34,
  id_PDUSessionAdmittedModSNModConfirm =  35,
  id_PDUSessionAdmitted_SNModResponse =  36,
  id_PDUSessionNotAdmittedAddReqAck =  37,
  id_PDUSessionNotAdmitted_SNModResponse =  38,
  id_PDUSessionReleasedList_RelConf =  39,
  id_PDUSessionReleasedSNModConfirm =  40,
  id_PDUSessionResourcesActivityNotifyList =  41,
  id_PDUSessionResourcesAdmitted_List =  42,
  id_PDUSessionResourcesNotAdmitted_List =  43,
  id_PDUSessionResourcesNotifyList =  44,
  id_PDUSession_SNChangeConfirm_List =  45,
  id_PDUSession_SNChangeRequired_List =  46,
  id_PDUSessionToBeAddedAddReq =  47,
  id_PDUSessionToBeModifiedSNModRequired =  48,
  id_PDUSessionToBeReleasedList_RelRqd =  49,
  id_PDUSessionToBeReleased_RelReq =  50,
  id_PDUSessionToBeReleasedSNModRequired =  51,
  id_RANPagingArea =  52,
  id_PagingPriority =  53,
  id_requestedSplitSRB =  54,
  id_requestedSplitSRBrelease =  55,
  id_ResetRequestTypeInfo =  56,
  id_ResetResponseTypeInfo =  57,
  id_RespondingNodeTypeConfigUpdateAck =  58,
  id_respondingNodeType_ResourceCoordResponse =  59,
  id_ResponseInfo_ReconfCompl =  60,
  id_RRCConfigIndication =  61,
  id_RRCResumeCause =  62,
  id_SCGConfigurationQuery =  63,
  id_selectedPLMN =  64,
  id_ServedCellsToActivate =  65,
  id_servedCellsToUpdate_E_UTRA =  66,
  id_ServedCellsToUpdateInitiatingNodeChoice =  67,
  id_servedCellsToUpdate_NR =  68,
  id_s_ng_RANnode_SecurityKey =  69,
  id_S_NG_RANnodeUE_AMBR =  70,
  id_S_NG_RANnodeUEXnAPID =  71,
  id_SN_to_MN_Container =  72,
  id_sourceNG_RANnodeUEXnAPID =  73,
  id_SplitSRB_RRCTransfer =  74,
  id_TAISupport_list =  75,
  id_TimeToWait =  76,
  id_Target2SourceNG_RANnodeTranspContainer =  77,
  id_targetCellGlobalID =  78,
  id_targetNG_RANnodeUEXnAPID =  79,
  id_target_S_NG_RANnodeID =  80,
  id_TraceActivation =  81,
  id_UEContextID =  82,
  id_UEContextInfoHORequest =  83,
  id_UEContextInfoRetrUECtxtResp =  84,
  id_UEContextInfo_SNModRequest =  85,
  id_UEContextKeptIndicator =  86,
  id_UEContextRefAtSN_HORequest =  87,
  id_UEHistoryInformation =  88,
  id_UEIdentityIndexValue =  89,
  id_UERANPagingIdentity =  90,
  id_UESecurityCapabilities =  91,
  id_UserPlaneTrafficActivityReport =  92,
  id_XnRemovalThreshold =  93,
  id_DesiredActNotificationLevel =  94,
  id_AvailableDRBIDs =  95,
  id_AdditionalDRBIDs =  96,
  id_SpareDRBIDs =  97,
  id_RequiredNumberOfDRBIDs =  98,
  id_TNLA_To_Add_List =  99,
  id_TNLA_To_Update_List = 100,
  id_TNLA_To_Remove_List = 101,
  id_TNLA_Setup_List = 102,
  id_TNLA_Failed_To_Setup_List = 103,
  id_PDUSessionToBeReleased_RelReqAck = 104,
  id_S_NG_RANnodeMaxIPDataRate_UL = 105,
  id_Unknown_106 = 106,
  id_PDUSessionResourceSecondaryRATUsageList = 107,
  id_Additional_UL_NG_U_TNLatUPF_List = 108,
  id_SecondarydataForwardingInfoFromTarget_List = 109,
  id_LocationInformationSNReporting = 110,
  id_LocationInformationSN = 111,
  id_LastE_UTRANPLMNIdentity = 112,
  id_S_NG_RANnodeMaxIPDataRate_DL = 113,
  id_MaxIPrate_DL = 114,
  id_SecurityResult = 115,
  id_S_NSSAI   = 116,
  id_MR_DC_ResourceCoordinationInfo = 117,
  id_AMF_Region_Information_To_Add = 118,
  id_AMF_Region_Information_To_Delete = 119,
  id_OldQoSFlowMap_ULendmarkerexpected = 120,
  id_RANPagingFailure = 121,
  id_UERadioCapabilityForPaging = 122,
  id_PDUSessionDataForwarding_SNModResponse = 123,
  id_DRBsNotAdmittedSetupModifyList = 124,
  id_Secondary_MN_Xn_U_TNLInfoatM = 125,
  id_NE_DC_TDM_Pattern = 126,
  id_PDUSessionCommonNetworkInstance = 127,
  id_BPLMN_ID_Info_EUTRA = 128,
  id_BPLMN_ID_Info_NR = 129,
  id_InterfaceInstanceIndication = 130,
  id_S_NG_RANnode_Addition_Trigger_Ind = 131,
  id_DefaultDRB_Allowed = 132,
  id_DRB_IDs_takenintouse = 133,
  id_SplitSessionIndicator = 134,
  id_CNTypeRestrictionsForEquivalent = 135,
  id_CNTypeRestrictionsForServing = 136,
  id_DRBs_transferred_to_MN = 137,
  id_ULForwardingProposal = 138,
  id_EndpointIPAddressAndPort = 139,
  id_IntendedTDD_DL_ULConfiguration_NR = 140,
  id_TNLConfigurationInfo = 141,
  id_PartialListIndicator_NR = 142,
  id_MessageOversizeNotification = 143,
  id_CellAndCapacityAssistanceInfo_NR = 144,
  id_NG_RANTraceID = 145,
  id_NonGBRResources_Offered = 146,
  id_FastMCGRecoveryRRCTransfer_SN_to_MN = 147,
  id_RequestedFastMCGRecoveryViaSRB3 = 148,
  id_AvailableFastMCGRecoveryViaSRB3 = 149,
  id_RequestedFastMCGRecoveryViaSRB3Release = 150,
  id_ReleaseFastMCGRecoveryViaSRB3 = 151,
  id_FastMCGRecoveryRRCTransfer_MN_to_SN = 152,
  id_ExtendedRATRestrictionInformation = 153,
  id_QoSMonitoringRequest = 154,
  id_FiveGCMobilityRestrictionListContainer = 155,
  id_PartialListIndicator_EUTRA = 156,
  id_CellAndCapacityAssistanceInfo_EUTRA = 157,
  id_CHOinformation_Req = 158,
  id_CHOinformation_Ack = 159,
  id_targetCellsToCancel = 160,
  id_requestedTargetCellGlobalID = 161,
  id_procedureStage = 162,
  id_DAPSRequestInfo = 163,
  id_DAPSResponseInfo_List = 164,
  id_CHO_MRDC_Indicator = 165,
  id_OffsetOfNbiotChannelNumberToDL_EARFCN = 166,
  id_OffsetOfNbiotChannelNumberToUL_EARFCN = 167,
  id_NBIoT_UL_DL_AlignmentOffset = 168,
  id_LTEV2XServicesAuthorized = 169,
  id_NRV2XServicesAuthorized = 170,
  id_LTEUESidelinkAggregateMaximumBitRate = 171,
  id_NRUESidelinkAggregateMaximumBitRate = 172,
  id_PC5QoSParameters = 173,
  id_AlternativeQoSParaSetList = 174,
  id_CurrentQoSParaSetIndex = 175,
  id_MobilityInformation = 176,
  id_InitiatingCondition_FailureIndication = 177,
  id_UEHistoryInformationFromTheUE = 178,
  id_HandoverReportType = 179,
  id_HandoverCause = 180,
  id_SourceCellCGI = 181,
  id_TargetCellCGI = 182,
  id_ReEstablishmentCellCGI = 183,
  id_TargetCellinEUTRAN = 184,
  id_SourceCellCRNTI = 185,
  id_UERLFReportContainer = 186,
  id_NGRAN_Node1_Measurement_ID = 187,
  id_NGRAN_Node2_Measurement_ID = 188,
  id_RegistrationRequest = 189,
  id_ReportCharacteristics = 190,
  id_CellToReport = 191,
  id_ReportingPeriodicity = 192,
  id_CellMeasurementResult = 193,
  id_NG_RANnode1CellID = 194,
  id_NG_RANnode2CellID = 195,
  id_NG_RANnode1MobilityParameters = 196,
  id_NG_RANnode2ProposedMobilityParameters = 197,
  id_MobilityParametersModificationRange = 198,
  id_TDDULDLConfigurationCommonNR = 199,
  id_CarrierList = 200,
  id_ULCarrierList = 201,
  id_FrequencyShift7p5khz = 202,
  id_SSB_PositionsInBurst = 203,
  id_NRCellPRACHConfig = 204,
  id_RACHReportInformation = 205,
  id_IABNodeIndication = 206,
  id_Redundant_UL_NG_U_TNLatUPF = 207,
  id_CNPacketDelayBudgetDownlink = 208,
  id_CNPacketDelayBudgetUplink = 209,
  id_Additional_Redundant_UL_NG_U_TNLatUPF_List = 210,
  id_RedundantCommonNetworkInstance = 211,
  id_TSCTrafficCharacteristics = 212,
  id_RedundantQoSFlowIndicator = 213,
  id_Redundant_DL_NG_U_TNLatNG_RAN = 214,
  id_ExtendedPacketDelayBudget = 215,
  id_Additional_PDCP_Duplication_TNL_List = 216,
  id_RedundantPDUSessionInformation = 217,
  id_UsedRSNInformation = 218,
  id_RLCDuplicationInformation = 219,
  id_NPN_Broadcast_Information = 220,
  id_NPNPagingAssistanceInformation = 221,
  id_NPNMobilityInformation = 222,
  id_NPN_Support = 223,
  id_MDT_Configuration = 224,
  id_MDTPLMNList = 225,
  id_TraceCollectionEntityURI = 226,
  id_UERadioCapabilityID = 227,
  id_CSI_RSTransmissionIndication = 228,
  id_SNTriggered = 229,
  id_DLCarrierList = 230,
  id_ExtendedTAISliceSupportList = 231,
  id_cellAssistanceInfo_EUTRA = 232,
  id_ConfiguredTACIndication = 233,
  id_secondary_SN_UL_PDCP_UP_TNLInfo = 234,
  id_pdcpDuplicationConfiguration = 235,
  id_duplicationActivation = 236,
  id_NPRACHConfiguration = 237,
  id_QosMonitoringReportingFrequency = 238,
  id_QoSFlowsMappedtoDRB_SetupResponse_MNterminated = 239,
  id_DL_scheduling_PDCCH_CCE_usage = 240,
  id_UL_scheduling_PDCCH_CCE_usage = 241,
  id_SFN_Offset = 242,
  id_QoSMonitoringDisabled = 243,
  id_ExtendedUEIdentityIndexValue = 244,
  id_EUTRAPagingeDRXInformation = 245,
  id_CHO_MRDC_EarlyDataForwarding = 246,
  id_SCGIndicator = 247,
  id_UESpecificDRX = 248,
  id_PDUSessionExpectedUEActivityBehaviour = 249,
  id_QoS_Mapping_Information = 250,
  id_AdditionLocationInformation = 251,
  id_dataForwardingInfoFromTargetE_UTRANnode = 252,
  id_DirectForwardingPathAvailability = 253,
  id_SourceNG_RAN_node_ID = 254,
  id_SourceDLForwardingIPAddress = 255,
  id_SourceNodeDLForwardingIPAddress = 256,
  id_ExtendedReportIntervalMDT = 257,
  id_SecurityIndication = 258,
  id_RRCConnReestab_Indicator = 259,
  id_TargetNodeID = 260,
  id_ManagementBasedMDTPLMNList = 261,
  id_PrivacyIndicator = 262,
  id_TraceCollectionEntityIPAddress = 263,
  id_M4ReportAmount = 264,
  id_M5ReportAmount = 265,
  id_M6ReportAmount = 266,
  id_M7ReportAmount = 267,
  id_BeamMeasurementIndicationM1 = 268,
  id_MBS_Session_ID = 269,
  id_UEIdentityIndexList_MBSGroupPaging = 270,
  id_MulticastRANPagingArea = 271,
  id_Supported_MBS_FSA_ID_List = 272,
  id_MBS_SessionInformation_List = 273,
  id_MBS_SessionInformationResponse_List = 274,
  id_MBS_SessionAssociatedInformation = 275,
  id_SuccessfulHOReportInformation = 276,
  id_SliceRadioResourceStatus_List = 277,
  id_CompositeAvailableCapacitySupplementaryUplink = 278,
  id_SCGUEHistoryInformation = 279,
  id_SSBOffsets_List = 280,
  id_NG_RANnode2SSBOffsetModificationRange = 281,
  id_Coverage_Modification_List = 282,
  id_NR_U_Channel_List = 283,
  id_SourcePSCellCGI = 284,
  id_FailedPSCellCGI = 285,
  id_SCGFailureReportContainer = 286,
  id_SNMobilityInformation = 287,
  id_SourcePSCellID = 288,
  id_SuitablePSCellCGI = 289,
  id_PSCellChangeHistory = 290,
  id_CHOConfiguration = 291,
  id_NR_U_ChannelInfo_List = 292,
  id_PSCellHistoryInformationRetrieve = 293,
  id_NG_RANnode2SSBOffsetsModificationRange = 294,
  id_MIMOPRBusageInformation = 295,
  id_F1CTrafficContainer = 296,
  id_IAB_MT_Cell_List = 297,
  id_NoPDUSessionIndication = 298,
  id_IAB_TNL_Address_Request = 299,
  id_IAB_TNL_Address_Response = 300,
  id_TrafficToBeAddedList = 301,
  id_TrafficToBeModifiedList = 302,
  id_TrafficToBeReleaseInformation = 303,
  id_TrafficAddedList = 304,
  id_TrafficModifiedList = 305,
  id_TrafficNotAddedList = 306,
  id_TrafficNotModifiedList = 307,
  id_TrafficRequiredToBeModifiedList = 308,
  id_TrafficRequiredModifiedList = 309,
  id_TrafficReleasedList = 310,
  id_IABTNLAddressToBeAdded = 311,
  id_IABTNLAddressToBeReleasedList = 312,
  id_nonF1_Terminating_IAB_DonorUEXnAPID = 313,
  id_F1_Terminating_IAB_DonorUEXnAPID = 314,
  id_BoundaryNodeCellsList = 315,
  id_ParentNodeCellsList = 316,
  id_tdd_GNB_DU_Cell_Resource_Configuration = 317,
  id_UL_GNB_DU_Cell_Resource_Configuration = 318,
  id_DL_GNB_DU_Cell_Resource_Configuration = 319,
  id_permutation = 320,
  id_IABTNLAddressException = 321,
  id_CHOinformation_AddReq = 322,
  id_CHOinformation_ModReq = 323,
  id_SurvivalTime = 324,
  id_TimeSynchronizationAssistanceInformation = 325,
  id_SCGActivationRequest = 326,
  id_SCGActivationStatus = 327,
  id_CPAInformationRequest = 328,
  id_CPAInformationAck = 329,
  id_CPCInformationRequired = 330,
  id_CPCInformationConfirm = 331,
  id_CPAInformationModReq = 332,
  id_CPAInformationModReqAck = 333,
  id_CPC_DataForwarding_Indicator = 334,
  id_CPCInformationUpdate = 335,
  id_CPACInformationModRequired = 336,
  id_QMCConfigInfo = 337,
  id_ProtocolIE_ID338_NotToBeUsed = 338,
  id_Additional_Measurement_Timing_Configuration_List = 339,
  id_PDUSession_PairID = 340,
  id_Local_NG_RAN_Node_Identifier = 341,
  id_Neighbour_NG_RAN_Node_List = 342,
  id_Local_NG_RAN_Node_Identifier_Removal = 343,
  id_FiveGProSeAuthorized = 344,
  id_FiveGProSePC5QoSParameters = 345,
  id_FiveGProSeUEPC5AggregateMaximumBitRate = 346,
  id_ServedCellSpecificInfoReq_NR = 347,
  id_NRPagingeDRXInformation = 348,
  id_NRPagingeDRXInformationforRRCINACTIVE = 349,
  id_Redcap_Bcast_Information = 350,
  id_SDTSupportRequest = 351,
  id_SDT_SRB_between_NewNode_OldNode = 352,
  id_SDT_Termination_Request = 353,
  id_SDTPartialUEContextInfo = 354,
  id_SDTDataForwardingDRBList = 355,
  id_PagingCause = 356,
  id_PEIPSassistanceInformation = 357,
  id_UESliceMaximumBitRateList = 358,
  id_S_NG_RANnodeUE_Slice_MBR = 359,
  id_PositioningInformation = 360,
  id_UEAssistantIdentifier = 361,
  id_ManagementBasedMDTPLMNModificationList = 362,
  id_F1_terminatingIAB_donorIndicator = 363,
  id_TAINSAGSupportList = 364,
  id_SCGreconfigNotification = 365,
  id_earlyMeasurement = 366,
  id_BeamMeasurementsReportConfiguration = 367,
  id_CoverageModificationCause = 368,
  id_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated = 369,
  id_UERLFReportContainerLTEExtension = 370,
  id_ExcessPacketDelayThresholdConfiguration = 371,
  id_HashedUEIdentityIndexValue = 372
} ProtocolIE_ID_enum;

typedef enum _GlobalNG_RANNode_ID_enum {
  GlobalNG_RANNode_ID_gNB =   0,
  GlobalNG_RANNode_ID_ng_eNB =   1,
  GlobalNG_RANNode_ID_choice_extension =   2
} GlobalNG_RANNode_ID_enum;

/* Initialize the protocol and registered fields */
static int proto_xnap = -1;
static int hf_xnap_transportLayerAddressIPv4 = -1;
static int hf_xnap_transportLayerAddressIPv6 = -1;
static int hf_xnap_NG_RANTraceID_TraceID = -1;
static int hf_xnap_NG_RANTraceID_TraceRecordingSessionReference = -1;
static int hf_xnap_primaryRATRestriction_e_UTRA = -1;
static int hf_xnap_primaryRATRestriction_nR = -1;
static int hf_xnap_primaryRATRestriction_nR_unlicensed = -1;
static int hf_xnap_primaryRATRestriction_nR_LEO = -1;
static int hf_xnap_primaryRATRestriction_nR_MEO = -1;
static int hf_xnap_primaryRATRestriction_nR_GEO = -1;
static int hf_xnap_primaryRATRestriction_nR_OTHERSAT = -1;
static int hf_xnap_primaryRATRestriction_reserved = -1;
static int hf_xnap_secondaryRATRestriction_e_UTRA = -1;
static int hf_xnap_secondaryRATRestriction_nR = -1;
static int hf_xnap_secondaryRATRestriction_e_UTRA_unlicensed = -1;
static int hf_xnap_secondaryRATRestriction_nR_unlicensed = -1;
static int hf_xnap_secondaryRATRestriction_reserved = -1;
static int hf_xnap_MDT_Location_Info_GNSS = -1;
static int hf_xnap_MDT_Location_Info_reserved = -1;
static int hf_xnap_MeasurementsToActivate_M1 = -1;
static int hf_xnap_MeasurementsToActivate_M2 = -1;
static int hf_xnap_MeasurementsToActivate_M3 = -1;
static int hf_xnap_MeasurementsToActivate_M4 = -1;
static int hf_xnap_MeasurementsToActivate_M5 = -1;
static int hf_xnap_MeasurementsToActivate_LoggingM1FromEventTriggered = -1;
static int hf_xnap_MeasurementsToActivate_M6 = -1;
static int hf_xnap_MeasurementsToActivate_M7 = -1;
static int hf_xnap_ReportCharacteristics_PRBPeriodic = -1;
static int hf_xnap_ReportCharacteristics_TNLCapacityIndPeriodic = -1;
static int hf_xnap_ReportCharacteristics_CompositeAvailableCapacityPeriodic = -1;
static int hf_xnap_ReportCharacteristics_NumberOfActiveUEs = -1;
static int hf_xnap_ReportCharacteristics_Reserved = -1;
static int hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_PDU = -1;  /* AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_AdditionLocationInformation_PDU = -1;  /* AdditionLocationInformation */
static int hf_xnap_Additional_PDCP_Duplication_TNL_List_PDU = -1;  /* Additional_PDCP_Duplication_TNL_List */
static int hf_xnap_Additional_UL_NG_U_TNLatUPF_List_PDU = -1;  /* Additional_UL_NG_U_TNLatUPF_List */
static int hf_xnap_Additional_Measurement_Timing_Configuration_List_PDU = -1;  /* Additional_Measurement_Timing_Configuration_List */
static int hf_xnap_ActivationIDforCellActivation_PDU = -1;  /* ActivationIDforCellActivation */
static int hf_xnap_AlternativeQoSParaSetList_PDU = -1;  /* AlternativeQoSParaSetList */
static int hf_xnap_AMF_Region_Information_PDU = -1;  /* AMF_Region_Information */
static int hf_xnap_AssistanceDataForRANPaging_PDU = -1;  /* AssistanceDataForRANPaging */
static int hf_xnap_BeamMeasurementIndicationM1_PDU = -1;  /* BeamMeasurementIndicationM1 */
static int hf_xnap_BeamMeasurementsReportConfiguration_PDU = -1;  /* BeamMeasurementsReportConfiguration */
static int hf_xnap_BPLMN_ID_Info_EUTRA_PDU = -1;  /* BPLMN_ID_Info_EUTRA */
static int hf_xnap_BPLMN_ID_Info_NR_PDU = -1;     /* BPLMN_ID_Info_NR */
static int hf_xnap_BitRate_PDU = -1;              /* BitRate */
static int hf_xnap_Cause_PDU = -1;                /* Cause */
static int hf_xnap_CellAssistanceInfo_NR_PDU = -1;  /* CellAssistanceInfo_NR */
static int hf_xnap_CellAndCapacityAssistanceInfo_NR_PDU = -1;  /* CellAndCapacityAssistanceInfo_NR */
static int hf_xnap_CellAndCapacityAssistanceInfo_EUTRA_PDU = -1;  /* CellAndCapacityAssistanceInfo_EUTRA */
static int hf_xnap_CellAssistanceInfo_EUTRA_PDU = -1;  /* CellAssistanceInfo_EUTRA */
static int hf_xnap_CellMeasurementResult_PDU = -1;  /* CellMeasurementResult */
static int hf_xnap_CellToReport_PDU = -1;         /* CellToReport */
static int hf_xnap_CHOConfiguration_PDU = -1;     /* CHOConfiguration */
static int hf_xnap_CompositeAvailableCapacity_PDU = -1;  /* CompositeAvailableCapacity */
static int hf_xnap_CHO_MRDC_EarlyDataForwarding_PDU = -1;  /* CHO_MRDC_EarlyDataForwarding */
static int hf_xnap_CHO_MRDC_Indicator_PDU = -1;   /* CHO_MRDC_Indicator */
static int hf_xnap_CHOinformation_Req_PDU = -1;   /* CHOinformation_Req */
static int hf_xnap_CHOinformation_Ack_PDU = -1;   /* CHOinformation_Ack */
static int hf_xnap_CHOinformation_AddReq_PDU = -1;  /* CHOinformation_AddReq */
static int hf_xnap_CHOinformation_ModReq_PDU = -1;  /* CHOinformation_ModReq */
static int hf_xnap_ConfiguredTACIndication_PDU = -1;  /* ConfiguredTACIndication */
static int hf_xnap_CoverageModificationCause_PDU = -1;  /* CoverageModificationCause */
static int hf_xnap_Coverage_Modification_List_PDU = -1;  /* Coverage_Modification_List */
static int hf_xnap_CPAInformationRequest_PDU = -1;  /* CPAInformationRequest */
static int hf_xnap_CPAInformationAck_PDU = -1;    /* CPAInformationAck */
static int hf_xnap_CPCInformationRequired_PDU = -1;  /* CPCInformationRequired */
static int hf_xnap_CPCInformationConfirm_PDU = -1;  /* CPCInformationConfirm */
static int hf_xnap_CPAInformationModReq_PDU = -1;  /* CPAInformationModReq */
static int hf_xnap_CPAInformationModReqAck_PDU = -1;  /* CPAInformationModReqAck */
static int hf_xnap_CPC_DataForwarding_Indicator_PDU = -1;  /* CPC_DataForwarding_Indicator */
static int hf_xnap_CPACInformationModRequired_PDU = -1;  /* CPACInformationModRequired */
static int hf_xnap_CPCInformationUpdate_PDU = -1;  /* CPCInformationUpdate */
static int hf_xnap_CriticalityDiagnostics_PDU = -1;  /* CriticalityDiagnostics */
static int hf_xnap_C_RNTI_PDU = -1;               /* C_RNTI */
static int hf_xnap_CSI_RSTransmissionIndication_PDU = -1;  /* CSI_RSTransmissionIndication */
static int hf_xnap_XnUAddressInfoperPDUSession_List_PDU = -1;  /* XnUAddressInfoperPDUSession_List */
static int hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_PDU = -1;  /* DataForwardingInfoFromTargetE_UTRANnode */
static int hf_xnap_DAPSRequestInfo_PDU = -1;      /* DAPSRequestInfo */
static int hf_xnap_DAPSResponseInfo_List_PDU = -1;  /* DAPSResponseInfo_List */
static int hf_xnap_DesiredActNotificationLevel_PDU = -1;  /* DesiredActNotificationLevel */
static int hf_xnap_DefaultDRB_Allowed_PDU = -1;   /* DefaultDRB_Allowed */
static int hf_xnap_DirectForwardingPathAvailability_PDU = -1;  /* DirectForwardingPathAvailability */
static int hf_xnap_DRB_List_PDU = -1;             /* DRB_List */
static int hf_xnap_DRB_List_withCause_PDU = -1;   /* DRB_List_withCause */
static int hf_xnap_DRB_Number_PDU = -1;           /* DRB_Number */
static int hf_xnap_DRBsSubjectToStatusTransfer_List_PDU = -1;  /* DRBsSubjectToStatusTransfer_List */
static int hf_xnap_DuplicationActivation_PDU = -1;  /* DuplicationActivation */
static int hf_xnap_EarlyMeasurement_PDU = -1;     /* EarlyMeasurement */
static int hf_xnap_EUTRAPagingeDRXInformation_PDU = -1;  /* EUTRAPagingeDRXInformation */
static int hf_xnap_EndpointIPAddressAndPort_PDU = -1;  /* EndpointIPAddressAndPort */
static int hf_xnap_ExcessPacketDelayThresholdConfiguration_PDU = -1;  /* ExcessPacketDelayThresholdConfiguration */
static int hf_xnap_ExpectedUEActivityBehaviour_PDU = -1;  /* ExpectedUEActivityBehaviour */
static int hf_xnap_ExpectedUEBehaviour_PDU = -1;  /* ExpectedUEBehaviour */
static int hf_xnap_ExtendedRATRestrictionInformation_PDU = -1;  /* ExtendedRATRestrictionInformation */
static int hf_xnap_ExtendedPacketDelayBudget_PDU = -1;  /* ExtendedPacketDelayBudget */
static int hf_xnap_ExtendedSliceSupportList_PDU = -1;  /* ExtendedSliceSupportList */
static int hf_xnap_ExtendedUEIdentityIndexValue_PDU = -1;  /* ExtendedUEIdentityIndexValue */
static int hf_xnap_F1CTrafficContainer_PDU = -1;  /* F1CTrafficContainer */
static int hf_xnap_F1_terminatingIAB_donorIndicator_PDU = -1;  /* F1_terminatingIAB_donorIndicator */
static int hf_xnap_FiveGCMobilityRestrictionListContainer_PDU = -1;  /* FiveGCMobilityRestrictionListContainer */
static int hf_xnap_FiveGProSeAuthorized_PDU = -1;  /* FiveGProSeAuthorized */
static int hf_xnap_FiveGProSePC5QoSParameters_PDU = -1;  /* FiveGProSePC5QoSParameters */
static int hf_xnap_FrequencyShift7p5khz_PDU = -1;  /* FrequencyShift7p5khz */
static int hf_xnap_GNB_DU_Cell_Resource_Configuration_PDU = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_GlobalCell_ID_PDU = -1;        /* GlobalCell_ID */
static int hf_xnap_GlobalNG_RANCell_ID_PDU = -1;  /* GlobalNG_RANCell_ID */
static int hf_xnap_GlobalNG_RANNode_ID_PDU = -1;  /* GlobalNG_RANNode_ID */
static int hf_xnap_GUAMI_PDU = -1;                /* GUAMI */
static int hf_xnap_HandoverReportType_PDU = -1;   /* HandoverReportType */
static int hf_xnap_HashedUEIdentityIndexValue_PDU = -1;  /* HashedUEIdentityIndexValue */
static int hf_xnap_IABNodeIndication_PDU = -1;    /* IABNodeIndication */
static int hf_xnap_IAB_TNL_Address_Request_PDU = -1;  /* IAB_TNL_Address_Request */
static int hf_xnap_IAB_TNL_Address_Response_PDU = -1;  /* IAB_TNL_Address_Response */
static int hf_xnap_IABTNLAddressException_PDU = -1;  /* IABTNLAddressException */
static int hf_xnap_InitiatingCondition_FailureIndication_PDU = -1;  /* InitiatingCondition_FailureIndication */
static int hf_xnap_xnap_IntendedTDD_DL_ULConfiguration_NR_PDU = -1;  /* IntendedTDD_DL_ULConfiguration_NR */
static int hf_xnap_InterfaceInstanceIndication_PDU = -1;  /* InterfaceInstanceIndication */
static int hf_xnap_Local_NG_RAN_Node_Identifier_PDU = -1;  /* Local_NG_RAN_Node_Identifier */
static int hf_xnap_SCGUEHistoryInformation_PDU = -1;  /* SCGUEHistoryInformation */
static int hf_xnap_LocationInformationSNReporting_PDU = -1;  /* LocationInformationSNReporting */
static int hf_xnap_LocationReportingInformation_PDU = -1;  /* LocationReportingInformation */
static int hf_xnap_LTEV2XServicesAuthorized_PDU = -1;  /* LTEV2XServicesAuthorized */
static int hf_xnap_LTEUESidelinkAggregateMaximumBitRate_PDU = -1;  /* LTEUESidelinkAggregateMaximumBitRate */
static int hf_xnap_M4ReportAmountMDT_PDU = -1;    /* M4ReportAmountMDT */
static int hf_xnap_M5ReportAmountMDT_PDU = -1;    /* M5ReportAmountMDT */
static int hf_xnap_M6ReportAmountMDT_PDU = -1;    /* M6ReportAmountMDT */
static int hf_xnap_M7ReportAmountMDT_PDU = -1;    /* M7ReportAmountMDT */
static int hf_xnap_MAC_I_PDU = -1;                /* MAC_I */
static int hf_xnap_MaskedIMEISV_PDU = -1;         /* MaskedIMEISV */
static int hf_xnap_MaxIPrate_PDU = -1;            /* MaxIPrate */
static int hf_xnap_MBS_Session_ID_PDU = -1;       /* MBS_Session_ID */
static int hf_xnap_MBS_SessionAssociatedInformation_PDU = -1;  /* MBS_SessionAssociatedInformation */
static int hf_xnap_MBS_SessionInformation_List_PDU = -1;  /* MBS_SessionInformation_List */
static int hf_xnap_MBS_SessionInformationResponse_List_PDU = -1;  /* MBS_SessionInformationResponse_List */
static int hf_xnap_MDT_Configuration_PDU = -1;    /* MDT_Configuration */
static int hf_xnap_MDTPLMNList_PDU = -1;          /* MDTPLMNList */
static int hf_xnap_MDTPLMNModificationList_PDU = -1;  /* MDTPLMNModificationList */
static int hf_xnap_Measurement_ID_PDU = -1;       /* Measurement_ID */
static int hf_xnap_MIMOPRBusageInformation_PDU = -1;  /* MIMOPRBusageInformation */
static int hf_xnap_MobilityInformation_PDU = -1;  /* MobilityInformation */
static int hf_xnap_MobilityParametersModificationRange_PDU = -1;  /* MobilityParametersModificationRange */
static int hf_xnap_MobilityParametersInformation_PDU = -1;  /* MobilityParametersInformation */
static int hf_xnap_MobilityRestrictionList_PDU = -1;  /* MobilityRestrictionList */
static int hf_xnap_CNTypeRestrictionsForEquivalent_PDU = -1;  /* CNTypeRestrictionsForEquivalent */
static int hf_xnap_CNTypeRestrictionsForServing_PDU = -1;  /* CNTypeRestrictionsForServing */
static int hf_xnap_MR_DC_ResourceCoordinationInfo_PDU = -1;  /* MR_DC_ResourceCoordinationInfo */
static int hf_xnap_MessageOversizeNotification_PDU = -1;  /* MessageOversizeNotification */
static int hf_xnap_NBIoT_UL_DL_AlignmentOffset_PDU = -1;  /* NBIoT_UL_DL_AlignmentOffset */
static int hf_xnap_NE_DC_TDM_Pattern_PDU = -1;    /* NE_DC_TDM_Pattern */
static int hf_xnap_Neighbour_NG_RAN_Node_List_PDU = -1;  /* Neighbour_NG_RAN_Node_List */
static int hf_xnap_NRCarrierList_PDU = -1;        /* NRCarrierList */
static int hf_xnap_NRCellPRACHConfig_PDU = -1;    /* NRCellPRACHConfig */
static int hf_xnap_NG_RAN_Cell_Identity_PDU = -1;  /* NG_RAN_Cell_Identity */
static int hf_xnap_NG_RANnode2SSBOffsetsModificationRange_PDU = -1;  /* NG_RANnode2SSBOffsetsModificationRange */
static int hf_xnap_NG_RANnodeUEXnAPID_PDU = -1;   /* NG_RANnodeUEXnAPID */
static int hf_xnap_DL_scheduling_PDCCH_CCE_usage_PDU = -1;  /* DL_scheduling_PDCCH_CCE_usage */
static int hf_xnap_UL_scheduling_PDCCH_CCE_usage_PDU = -1;  /* UL_scheduling_PDCCH_CCE_usage */
static int hf_xnap_NoPDUSessionIndication_PDU = -1;  /* NoPDUSessionIndication */
static int hf_xnap_NPN_Broadcast_Information_PDU = -1;  /* NPN_Broadcast_Information */
static int hf_xnap_NPNMobilityInformation_PDU = -1;  /* NPNMobilityInformation */
static int hf_xnap_NPNPagingAssistanceInformation_PDU = -1;  /* NPNPagingAssistanceInformation */
static int hf_xnap_NPN_Support_PDU = -1;          /* NPN_Support */
static int hf_xnap_NPRACHConfiguration_PDU = -1;  /* NPRACHConfiguration */
static int hf_xnap_NR_U_Channel_List_PDU = -1;    /* NR_U_Channel_List */
static int hf_xnap_NR_U_ChannelInfo_List_PDU = -1;  /* NR_U_ChannelInfo_List */
static int hf_xnap_NRPagingeDRXInformation_PDU = -1;  /* NRPagingeDRXInformation */
static int hf_xnap_NRPagingeDRXInformationforRRCINACTIVE_PDU = -1;  /* NRPagingeDRXInformationforRRCINACTIVE */
static int hf_xnap_NG_RANTraceID_PDU = -1;        /* NG_RANTraceID */
static int hf_xnap_NonGBRResources_Offered_PDU = -1;  /* NonGBRResources_Offered */
static int hf_xnap_NRV2XServicesAuthorized_PDU = -1;  /* NRV2XServicesAuthorized */
static int hf_xnap_NRUESidelinkAggregateMaximumBitRate_PDU = -1;  /* NRUESidelinkAggregateMaximumBitRate */
static int hf_xnap_OffsetOfNbiotChannelNumberToEARFCN_PDU = -1;  /* OffsetOfNbiotChannelNumberToEARFCN */
static int hf_xnap_PositioningInformation_PDU = -1;  /* PositioningInformation */
static int hf_xnap_PagingCause_PDU = -1;          /* PagingCause */
static int hf_xnap_PEIPSassistanceInformation_PDU = -1;  /* PEIPSassistanceInformation */
static int hf_xnap_PagingDRX_PDU = -1;            /* PagingDRX */
static int hf_xnap_PagingPriority_PDU = -1;       /* PagingPriority */
static int hf_xnap_PartialListIndicator_PDU = -1;  /* PartialListIndicator */
static int hf_xnap_PC5QoSParameters_PDU = -1;     /* PC5QoSParameters */
static int hf_xnap_PDCPChangeIndication_PDU = -1;  /* PDCPChangeIndication */
static int hf_xnap_PDCPDuplicationConfiguration_PDU = -1;  /* PDCPDuplicationConfiguration */
static int hf_xnap_PDUSession_List_withCause_PDU = -1;  /* PDUSession_List_withCause */
static int hf_xnap_PDUSessionResourcesAdmitted_List_PDU = -1;  /* PDUSessionResourcesAdmitted_List */
static int hf_xnap_PDUSessionResourcesNotAdmitted_List_PDU = -1;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_PDU = -1;  /* QoSFlowsMappedtoDRB_SetupResponse_MNterminated */
static int hf_xnap_PDUSessionResourceSecondaryRATUsageList_PDU = -1;  /* PDUSessionResourceSecondaryRATUsageList */
static int hf_xnap_PDUSessionCommonNetworkInstance_PDU = -1;  /* PDUSessionCommonNetworkInstance */
static int hf_xnap_PDUSession_PairID_PDU = -1;    /* PDUSession_PairID */
static int hf_xnap_Permutation_PDU = -1;          /* Permutation */
static int hf_xnap_PLMN_Identity_PDU = -1;        /* PLMN_Identity */
static int hf_xnap_PrivacyIndicator_PDU = -1;     /* PrivacyIndicator */
static int hf_xnap_PSCellChangeHistory_PDU = -1;  /* PSCellChangeHistory */
static int hf_xnap_PSCellHistoryInformationRetrieve_PDU = -1;  /* PSCellHistoryInformationRetrieve */
static int hf_xnap_QMCConfigInfo_PDU = -1;        /* QMCConfigInfo */
static int hf_xnap_QoSFlows_List_PDU = -1;        /* QoSFlows_List */
static int hf_xnap_QoS_Mapping_Information_PDU = -1;  /* QoS_Mapping_Information */
static int hf_xnap_QoSParaSetNotifyIndex_PDU = -1;  /* QoSParaSetNotifyIndex */
static int hf_xnap_QosMonitoringRequest_PDU = -1;  /* QosMonitoringRequest */
static int hf_xnap_QoSMonitoringDisabled_PDU = -1;  /* QoSMonitoringDisabled */
static int hf_xnap_QosMonitoringReportingFrequency_PDU = -1;  /* QosMonitoringReportingFrequency */
static int hf_xnap_RACHReportInformation_PDU = -1;  /* RACHReportInformation */
static int hf_xnap_RANPagingArea_PDU = -1;        /* RANPagingArea */
static int hf_xnap_RANPagingFailure_PDU = -1;     /* RANPagingFailure */
static int hf_xnap_Redcap_Bcast_Information_PDU = -1;  /* Redcap_Bcast_Information */
static int hf_xnap_RedundantQoSFlowIndicator_PDU = -1;  /* RedundantQoSFlowIndicator */
static int hf_xnap_RedundantPDUSessionInformation_PDU = -1;  /* RedundantPDUSessionInformation */
static int hf_xnap_ExtendedReportIntervalMDT_PDU = -1;  /* ExtendedReportIntervalMDT */
static int hf_xnap_ReportCharacteristics_PDU = -1;  /* ReportCharacteristics */
static int hf_xnap_ReportingPeriodicity_PDU = -1;  /* ReportingPeriodicity */
static int hf_xnap_RegistrationRequest_PDU = -1;  /* RegistrationRequest */
static int hf_xnap_ResetRequestTypeInfo_PDU = -1;  /* ResetRequestTypeInfo */
static int hf_xnap_ResetResponseTypeInfo_PDU = -1;  /* ResetResponseTypeInfo */
static int hf_xnap_RLCDuplicationInformation_PDU = -1;  /* RLCDuplicationInformation */
static int hf_xnap_RFSP_Index_PDU = -1;           /* RFSP_Index */
static int hf_xnap_RRCConfigIndication_PDU = -1;  /* RRCConfigIndication */
static int hf_xnap_RRCConnReestab_Indicator_PDU = -1;  /* RRCConnReestab_Indicator */
static int hf_xnap_RRCResumeCause_PDU = -1;       /* RRCResumeCause */
static int hf_xnap_SCGreconfigNotification_PDU = -1;  /* SCGreconfigNotification */
static int hf_xnap_SecondarydataForwardingInfoFromTarget_List_PDU = -1;  /* SecondarydataForwardingInfoFromTarget_List */
static int hf_xnap_SCGActivationRequest_PDU = -1;  /* SCGActivationRequest */
static int hf_xnap_SCGActivationStatus_PDU = -1;  /* SCGActivationStatus */
static int hf_xnap_SCGConfigurationQuery_PDU = -1;  /* SCGConfigurationQuery */
static int hf_xnap_SCGIndicator_PDU = -1;         /* SCGIndicator */
static int hf_xnap_SCGFailureReportContainer_PDU = -1;  /* SCGFailureReportContainer */
static int hf_xnap_SDTSupportRequest_PDU = -1;    /* SDTSupportRequest */
static int hf_xnap_SDT_Termination_Request_PDU = -1;  /* SDT_Termination_Request */
static int hf_xnap_SDTPartialUEContextInfo_PDU = -1;  /* SDTPartialUEContextInfo */
static int hf_xnap_SDTDataForwardingDRBList_PDU = -1;  /* SDTDataForwardingDRBList */
static int hf_xnap_SecurityIndication_PDU = -1;   /* SecurityIndication */
static int hf_xnap_SecurityResult_PDU = -1;       /* SecurityResult */
static int hf_xnap_ServedCells_E_UTRA_PDU = -1;   /* ServedCells_E_UTRA */
static int hf_xnap_ServedCellsToUpdate_E_UTRA_PDU = -1;  /* ServedCellsToUpdate_E_UTRA */
static int hf_xnap_SFN_Offset_PDU = -1;           /* SFN_Offset */
static int hf_xnap_ServedCells_NR_PDU = -1;       /* ServedCells_NR */
static int hf_xnap_ServedCellSpecificInfoReq_NR_PDU = -1;  /* ServedCellSpecificInfoReq_NR */
static int hf_xnap_ServedCellsToUpdate_NR_PDU = -1;  /* ServedCellsToUpdate_NR */
static int hf_xnap_SliceRadioResourceStatus_List_PDU = -1;  /* SliceRadioResourceStatus_List */
static int hf_xnap_S_NG_RANnode_SecurityKey_PDU = -1;  /* S_NG_RANnode_SecurityKey */
static int hf_xnap_S_NG_RANnode_Addition_Trigger_Ind_PDU = -1;  /* S_NG_RANnode_Addition_Trigger_Ind */
static int hf_xnap_S_NSSAI_PDU = -1;              /* S_NSSAI */
static int hf_xnap_SNMobilityInformation_PDU = -1;  /* SNMobilityInformation */
static int hf_xnap_SNTriggered_PDU = -1;          /* SNTriggered */
static int hf_xnap_SplitSessionIndicator_PDU = -1;  /* SplitSessionIndicator */
static int hf_xnap_SplitSRBsTypes_PDU = -1;       /* SplitSRBsTypes */
static int hf_xnap_SSB_PositionsInBurst_PDU = -1;  /* SSB_PositionsInBurst */
static int hf_xnap_SSBOffsets_List_PDU = -1;      /* SSBOffsets_List */
static int hf_xnap_SuccessfulHOReportInformation_PDU = -1;  /* SuccessfulHOReportInformation */
static int hf_xnap_Supported_MBS_FSA_ID_List_PDU = -1;  /* Supported_MBS_FSA_ID_List */
static int hf_xnap_SurvivalTime_PDU = -1;         /* SurvivalTime */
static int hf_xnap_TAINSAGSupportList_PDU = -1;   /* TAINSAGSupportList */
static int hf_xnap_TAISupport_List_PDU = -1;      /* TAISupport_List */
static int hf_xnap_TargetCellinEUTRAN_PDU = -1;   /* TargetCellinEUTRAN */
static int hf_xnap_Target_CGI_PDU = -1;           /* Target_CGI */
static int hf_xnap_TDDULDLConfigurationCommonNR_PDU = -1;  /* TDDULDLConfigurationCommonNR */
static int hf_xnap_TargetCellList_PDU = -1;       /* TargetCellList */
static int hf_xnap_TimeSynchronizationAssistanceInformation_PDU = -1;  /* TimeSynchronizationAssistanceInformation */
static int hf_xnap_TimeToWait_PDU = -1;           /* TimeToWait */
static int hf_xnap_TNLConfigurationInfo_PDU = -1;  /* TNLConfigurationInfo */
static int hf_xnap_TNLA_To_Add_List_PDU = -1;     /* TNLA_To_Add_List */
static int hf_xnap_TNLA_To_Update_List_PDU = -1;  /* TNLA_To_Update_List */
static int hf_xnap_TNLA_To_Remove_List_PDU = -1;  /* TNLA_To_Remove_List */
static int hf_xnap_TNLA_Setup_List_PDU = -1;      /* TNLA_Setup_List */
static int hf_xnap_TNLA_Failed_To_Setup_List_PDU = -1;  /* TNLA_Failed_To_Setup_List */
static int hf_xnap_TransportLayerAddress_PDU = -1;  /* TransportLayerAddress */
static int hf_xnap_TraceActivation_PDU = -1;      /* TraceActivation */
static int hf_xnap_TrafficToBeReleaseInformation_PDU = -1;  /* TrafficToBeReleaseInformation */
static int hf_xnap_TSCTrafficCharacteristics_PDU = -1;  /* TSCTrafficCharacteristics */
static int hf_xnap_UEAggregateMaximumBitRate_PDU = -1;  /* UEAggregateMaximumBitRate */
static int hf_xnap_UEContextKeptIndicator_PDU = -1;  /* UEContextKeptIndicator */
static int hf_xnap_UEContextID_PDU = -1;          /* UEContextID */
static int hf_xnap_UEContextInfoRetrUECtxtResp_PDU = -1;  /* UEContextInfoRetrUECtxtResp */
static int hf_xnap_UEHistoryInformation_PDU = -1;  /* UEHistoryInformation */
static int hf_xnap_UEHistoryInformationFromTheUE_PDU = -1;  /* UEHistoryInformationFromTheUE */
static int hf_xnap_UEIdentityIndexValue_PDU = -1;  /* UEIdentityIndexValue */
static int hf_xnap_UEIdentityIndexList_MBSGroupPaging_PDU = -1;  /* UEIdentityIndexList_MBSGroupPaging */
static int hf_xnap_UERadioCapabilityForPaging_PDU = -1;  /* UERadioCapabilityForPaging */
static int hf_xnap_UERadioCapabilityID_PDU = -1;  /* UERadioCapabilityID */
static int hf_xnap_UERANPagingIdentity_PDU = -1;  /* UERANPagingIdentity */
static int hf_xnap_UERLFReportContainer_PDU = -1;  /* UERLFReportContainer */
static int hf_xnap_UERLFReportContainerLTEExtension_PDU = -1;  /* UERLFReportContainerLTEExtension */
static int hf_xnap_UESliceMaximumBitRateList_PDU = -1;  /* UESliceMaximumBitRateList */
static int hf_xnap_UESecurityCapabilities_PDU = -1;  /* UESecurityCapabilities */
static int hf_xnap_UESpecificDRX_PDU = -1;        /* UESpecificDRX */
static int hf_xnap_ULForwardingProposal_PDU = -1;  /* ULForwardingProposal */
static int hf_xnap_UPTransportLayerInformation_PDU = -1;  /* UPTransportLayerInformation */
static int hf_xnap_UPTransportParameters_PDU = -1;  /* UPTransportParameters */
static int hf_xnap_UserPlaneTrafficActivityReport_PDU = -1;  /* UserPlaneTrafficActivityReport */
static int hf_xnap_URIaddress_PDU = -1;           /* URIaddress */
static int hf_xnap_XnBenefitValue_PDU = -1;       /* XnBenefitValue */
static int hf_xnap_HandoverRequest_PDU = -1;      /* HandoverRequest */
static int hf_xnap_UEContextInfoHORequest_PDU = -1;  /* UEContextInfoHORequest */
static int hf_xnap_UEContextRefAtSN_HORequest_PDU = -1;  /* UEContextRefAtSN_HORequest */
static int hf_xnap_HandoverRequestAcknowledge_PDU = -1;  /* HandoverRequestAcknowledge */
static int hf_xnap_Target2SourceNG_RANnodeTranspContainer_PDU = -1;  /* Target2SourceNG_RANnodeTranspContainer */
static int hf_xnap_HandoverPreparationFailure_PDU = -1;  /* HandoverPreparationFailure */
static int hf_xnap_SNStatusTransfer_PDU = -1;     /* SNStatusTransfer */
static int hf_xnap_UEContextRelease_PDU = -1;     /* UEContextRelease */
static int hf_xnap_HandoverCancel_PDU = -1;       /* HandoverCancel */
static int hf_xnap_HandoverSuccess_PDU = -1;      /* HandoverSuccess */
static int hf_xnap_ConditionalHandoverCancel_PDU = -1;  /* ConditionalHandoverCancel */
static int hf_xnap_EarlyStatusTransfer_PDU = -1;  /* EarlyStatusTransfer */
static int hf_xnap_ProcedureStageChoice_PDU = -1;  /* ProcedureStageChoice */
static int hf_xnap_RANPaging_PDU = -1;            /* RANPaging */
static int hf_xnap_RetrieveUEContextRequest_PDU = -1;  /* RetrieveUEContextRequest */
static int hf_xnap_RetrieveUEContextResponse_PDU = -1;  /* RetrieveUEContextResponse */
static int hf_xnap_RetrieveUEContextConfirm_PDU = -1;  /* RetrieveUEContextConfirm */
static int hf_xnap_RetrieveUEContextFailure_PDU = -1;  /* RetrieveUEContextFailure */
static int hf_xnap_OldtoNewNG_RANnodeResumeContainer_PDU = -1;  /* OldtoNewNG_RANnodeResumeContainer */
static int hf_xnap_XnUAddressIndication_PDU = -1;  /* XnUAddressIndication */
static int hf_xnap_SNodeAdditionRequest_PDU = -1;  /* SNodeAdditionRequest */
static int hf_xnap_MN_to_SN_Container_PDU = -1;   /* MN_to_SN_Container */
static int hf_xnap_PDUSessionToBeAddedAddReq_PDU = -1;  /* PDUSessionToBeAddedAddReq */
static int hf_xnap_RequestedFastMCGRecoveryViaSRB3_PDU = -1;  /* RequestedFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeAdditionRequestAcknowledge_PDU = -1;  /* SNodeAdditionRequestAcknowledge */
static int hf_xnap_SN_to_MN_Container_PDU = -1;   /* SN_to_MN_Container */
static int hf_xnap_PDUSessionAdmittedAddedAddReqAck_PDU = -1;  /* PDUSessionAdmittedAddedAddReqAck */
static int hf_xnap_PDUSessionNotAdmittedAddReqAck_PDU = -1;  /* PDUSessionNotAdmittedAddReqAck */
static int hf_xnap_AvailableFastMCGRecoveryViaSRB3_PDU = -1;  /* AvailableFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeAdditionRequestReject_PDU = -1;  /* SNodeAdditionRequestReject */
static int hf_xnap_SNodeReconfigurationComplete_PDU = -1;  /* SNodeReconfigurationComplete */
static int hf_xnap_ResponseInfo_ReconfCompl_PDU = -1;  /* ResponseInfo_ReconfCompl */
static int hf_xnap_SNodeModificationRequest_PDU = -1;  /* SNodeModificationRequest */
static int hf_xnap_UEContextInfo_SNModRequest_PDU = -1;  /* UEContextInfo_SNModRequest */
static int hf_xnap_RequestedFastMCGRecoveryViaSRB3Release_PDU = -1;  /* RequestedFastMCGRecoveryViaSRB3Release */
static int hf_xnap_SNodeModificationRequestAcknowledge_PDU = -1;  /* SNodeModificationRequestAcknowledge */
static int hf_xnap_PDUSessionAdmitted_SNModResponse_PDU = -1;  /* PDUSessionAdmitted_SNModResponse */
static int hf_xnap_PDUSessionNotAdmitted_SNModResponse_PDU = -1;  /* PDUSessionNotAdmitted_SNModResponse */
static int hf_xnap_PDUSessionDataForwarding_SNModResponse_PDU = -1;  /* PDUSessionDataForwarding_SNModResponse */
static int hf_xnap_ReleaseFastMCGRecoveryViaSRB3_PDU = -1;  /* ReleaseFastMCGRecoveryViaSRB3 */
static int hf_xnap_SNodeModificationRequestReject_PDU = -1;  /* SNodeModificationRequestReject */
static int hf_xnap_SNodeModificationRequired_PDU = -1;  /* SNodeModificationRequired */
static int hf_xnap_PDUSessionToBeModifiedSNModRequired_PDU = -1;  /* PDUSessionToBeModifiedSNModRequired */
static int hf_xnap_PDUSessionToBeReleasedSNModRequired_PDU = -1;  /* PDUSessionToBeReleasedSNModRequired */
static int hf_xnap_SNodeModificationConfirm_PDU = -1;  /* SNodeModificationConfirm */
static int hf_xnap_PDUSessionAdmittedModSNModConfirm_PDU = -1;  /* PDUSessionAdmittedModSNModConfirm */
static int hf_xnap_PDUSessionReleasedSNModConfirm_PDU = -1;  /* PDUSessionReleasedSNModConfirm */
static int hf_xnap_SNodeModificationRefuse_PDU = -1;  /* SNodeModificationRefuse */
static int hf_xnap_SNodeReleaseRequest_PDU = -1;  /* SNodeReleaseRequest */
static int hf_xnap_SNodeReleaseRequestAcknowledge_PDU = -1;  /* SNodeReleaseRequestAcknowledge */
static int hf_xnap_PDUSessionToBeReleasedList_RelReqAck_PDU = -1;  /* PDUSessionToBeReleasedList_RelReqAck */
static int hf_xnap_SNodeReleaseReject_PDU = -1;   /* SNodeReleaseReject */
static int hf_xnap_SNodeReleaseRequired_PDU = -1;  /* SNodeReleaseRequired */
static int hf_xnap_PDUSessionToBeReleasedList_RelRqd_PDU = -1;  /* PDUSessionToBeReleasedList_RelRqd */
static int hf_xnap_SNodeReleaseConfirm_PDU = -1;  /* SNodeReleaseConfirm */
static int hf_xnap_PDUSessionReleasedList_RelConf_PDU = -1;  /* PDUSessionReleasedList_RelConf */
static int hf_xnap_SNodeCounterCheckRequest_PDU = -1;  /* SNodeCounterCheckRequest */
static int hf_xnap_BearersSubjectToCounterCheck_List_PDU = -1;  /* BearersSubjectToCounterCheck_List */
static int hf_xnap_SNodeChangeRequired_PDU = -1;  /* SNodeChangeRequired */
static int hf_xnap_PDUSession_SNChangeRequired_List_PDU = -1;  /* PDUSession_SNChangeRequired_List */
static int hf_xnap_SNodeChangeConfirm_PDU = -1;   /* SNodeChangeConfirm */
static int hf_xnap_PDUSession_SNChangeConfirm_List_PDU = -1;  /* PDUSession_SNChangeConfirm_List */
static int hf_xnap_SNodeChangeRefuse_PDU = -1;    /* SNodeChangeRefuse */
static int hf_xnap_RRCTransfer_PDU = -1;          /* RRCTransfer */
static int hf_xnap_SplitSRB_RRCTransfer_PDU = -1;  /* SplitSRB_RRCTransfer */
static int hf_xnap_UEReportRRCTransfer_PDU = -1;  /* UEReportRRCTransfer */
static int hf_xnap_FastMCGRecoveryRRCTransfer_PDU = -1;  /* FastMCGRecoveryRRCTransfer */
static int hf_xnap_SDT_SRB_between_NewNode_OldNode_PDU = -1;  /* SDT_SRB_between_NewNode_OldNode */
static int hf_xnap_NotificationControlIndication_PDU = -1;  /* NotificationControlIndication */
static int hf_xnap_PDUSessionResourcesNotifyList_PDU = -1;  /* PDUSessionResourcesNotifyList */
static int hf_xnap_ActivityNotification_PDU = -1;  /* ActivityNotification */
static int hf_xnap_PDUSessionResourcesActivityNotifyList_PDU = -1;  /* PDUSessionResourcesActivityNotifyList */
static int hf_xnap_XnSetupRequest_PDU = -1;       /* XnSetupRequest */
static int hf_xnap_XnSetupResponse_PDU = -1;      /* XnSetupResponse */
static int hf_xnap_XnSetupFailure_PDU = -1;       /* XnSetupFailure */
static int hf_xnap_NGRANNodeConfigurationUpdate_PDU = -1;  /* NGRANNodeConfigurationUpdate */
static int hf_xnap_ConfigurationUpdateInitiatingNodeChoice_PDU = -1;  /* ConfigurationUpdateInitiatingNodeChoice */
static int hf_xnap_NGRANNodeConfigurationUpdateAcknowledge_PDU = -1;  /* NGRANNodeConfigurationUpdateAcknowledge */
static int hf_xnap_RespondingNodeTypeConfigUpdateAck_PDU = -1;  /* RespondingNodeTypeConfigUpdateAck */
static int hf_xnap_NGRANNodeConfigurationUpdateFailure_PDU = -1;  /* NGRANNodeConfigurationUpdateFailure */
static int hf_xnap_E_UTRA_NR_CellResourceCoordinationRequest_PDU = -1;  /* E_UTRA_NR_CellResourceCoordinationRequest */
static int hf_xnap_InitiatingNodeType_ResourceCoordRequest_PDU = -1;  /* InitiatingNodeType_ResourceCoordRequest */
static int hf_xnap_E_UTRA_NR_CellResourceCoordinationResponse_PDU = -1;  /* E_UTRA_NR_CellResourceCoordinationResponse */
static int hf_xnap_RespondingNodeType_ResourceCoordResponse_PDU = -1;  /* RespondingNodeType_ResourceCoordResponse */
static int hf_xnap_SecondaryRATDataUsageReport_PDU = -1;  /* SecondaryRATDataUsageReport */
static int hf_xnap_XnRemovalRequest_PDU = -1;     /* XnRemovalRequest */
static int hf_xnap_XnRemovalResponse_PDU = -1;    /* XnRemovalResponse */
static int hf_xnap_XnRemovalFailure_PDU = -1;     /* XnRemovalFailure */
static int hf_xnap_CellActivationRequest_PDU = -1;  /* CellActivationRequest */
static int hf_xnap_ServedCellsToActivate_PDU = -1;  /* ServedCellsToActivate */
static int hf_xnap_CellActivationResponse_PDU = -1;  /* CellActivationResponse */
static int hf_xnap_ActivatedServedCells_PDU = -1;  /* ActivatedServedCells */
static int hf_xnap_CellActivationFailure_PDU = -1;  /* CellActivationFailure */
static int hf_xnap_ResetRequest_PDU = -1;         /* ResetRequest */
static int hf_xnap_ResetResponse_PDU = -1;        /* ResetResponse */
static int hf_xnap_ErrorIndication_PDU = -1;      /* ErrorIndication */
static int hf_xnap_PrivateMessage_PDU = -1;       /* PrivateMessage */
static int hf_xnap_TraceStart_PDU = -1;           /* TraceStart */
static int hf_xnap_DeactivateTrace_PDU = -1;      /* DeactivateTrace */
static int hf_xnap_FailureIndication_PDU = -1;    /* FailureIndication */
static int hf_xnap_HandoverReport_PDU = -1;       /* HandoverReport */
static int hf_xnap_ResourceStatusRequest_PDU = -1;  /* ResourceStatusRequest */
static int hf_xnap_ResourceStatusResponse_PDU = -1;  /* ResourceStatusResponse */
static int hf_xnap_ResourceStatusFailure_PDU = -1;  /* ResourceStatusFailure */
static int hf_xnap_ResourceStatusUpdate_PDU = -1;  /* ResourceStatusUpdate */
static int hf_xnap_MobilityChangeRequest_PDU = -1;  /* MobilityChangeRequest */
static int hf_xnap_MobilityChangeAcknowledge_PDU = -1;  /* MobilityChangeAcknowledge */
static int hf_xnap_MobilityChangeFailure_PDU = -1;  /* MobilityChangeFailure */
static int hf_xnap_AccessAndMobilityIndication_PDU = -1;  /* AccessAndMobilityIndication */
static int hf_xnap_CellTrafficTrace_PDU = -1;     /* CellTrafficTrace */
static int hf_xnap_RANMulticastGroupPaging_PDU = -1;  /* RANMulticastGroupPaging */
static int hf_xnap_ScgFailureInformationReport_PDU = -1;  /* ScgFailureInformationReport */
static int hf_xnap_ScgFailureTransfer_PDU = -1;   /* ScgFailureTransfer */
static int hf_xnap_F1CTrafficTransfer_PDU = -1;   /* F1CTrafficTransfer */
static int hf_xnap_IABTransportMigrationManagementRequest_PDU = -1;  /* IABTransportMigrationManagementRequest */
static int hf_xnap_TrafficToBeAddedList_PDU = -1;  /* TrafficToBeAddedList */
static int hf_xnap_TrafficToBeModifiedList_PDU = -1;  /* TrafficToBeModifiedList */
static int hf_xnap_IABTransportMigrationManagementResponse_PDU = -1;  /* IABTransportMigrationManagementResponse */
static int hf_xnap_TrafficAddedList_PDU = -1;     /* TrafficAddedList */
static int hf_xnap_TrafficModifiedList_PDU = -1;  /* TrafficModifiedList */
static int hf_xnap_TrafficNotAddedList_PDU = -1;  /* TrafficNotAddedList */
static int hf_xnap_TrafficNotModifiedList_PDU = -1;  /* TrafficNotModifiedList */
static int hf_xnap_TrafficReleasedList_PDU = -1;  /* TrafficReleasedList */
static int hf_xnap_IABTransportMigrationManagementReject_PDU = -1;  /* IABTransportMigrationManagementReject */
static int hf_xnap_IABTransportMigrationModificationRequest_PDU = -1;  /* IABTransportMigrationModificationRequest */
static int hf_xnap_TrafficRequiredToBeModifiedList_PDU = -1;  /* TrafficRequiredToBeModifiedList */
static int hf_xnap_IABTNLAddressToBeReleasedList_PDU = -1;  /* IABTNLAddressToBeReleasedList */
static int hf_xnap_IABTransportMigrationModificationResponse_PDU = -1;  /* IABTransportMigrationModificationResponse */
static int hf_xnap_TrafficRequiredModifiedList_PDU = -1;  /* TrafficRequiredModifiedList */
static int hf_xnap_IABResourceCoordinationRequest_PDU = -1;  /* IABResourceCoordinationRequest */
static int hf_xnap_BoundaryNodeCellsList_PDU = -1;  /* BoundaryNodeCellsList */
static int hf_xnap_ParentNodeCellsList_PDU = -1;  /* ParentNodeCellsList */
static int hf_xnap_IABResourceCoordinationResponse_PDU = -1;  /* IABResourceCoordinationResponse */
static int hf_xnap_CPCCancel_PDU = -1;            /* CPCCancel */
static int hf_xnap_PartialUEContextTransfer_PDU = -1;  /* PartialUEContextTransfer */
static int hf_xnap_PartialUEContextTransferAcknowledge_PDU = -1;  /* PartialUEContextTransferAcknowledge */
static int hf_xnap_PartialUEContextTransferFailure_PDU = -1;  /* PartialUEContextTransferFailure */
static int hf_xnap_XnAP_PDU_PDU = -1;             /* XnAP_PDU */
static int hf_xnap_local = -1;                    /* INTEGER_0_maxPrivateIEs */
static int hf_xnap_global = -1;                   /* OBJECT_IDENTIFIER */
static int hf_xnap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_xnap_id = -1;                       /* ProtocolIE_ID */
static int hf_xnap_criticality = -1;              /* Criticality */
static int hf_xnap_protocolIE_Field_value = -1;   /* ProtocolIE_Field_value */
static int hf_xnap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_xnap_extension_id = -1;             /* ProtocolIE_ID */
static int hf_xnap_extensionValue = -1;           /* T_extensionValue */
static int hf_xnap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_xnap_private_id = -1;               /* PrivateIE_ID */
static int hf_xnap_privateIE_Field_value = -1;    /* PrivateIE_Field_value */
static int hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_item = -1;  /* AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item */
static int hf_xnap_pDUSessionResourceChangeConfirmInfo_SNterminated = -1;  /* PDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_iE_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_xnap_Additional_PDCP_Duplication_TNL_List_item = -1;  /* Additional_PDCP_Duplication_TNL_Item */
static int hf_xnap_additional_PDCP_Duplication_UP_TNL_Information = -1;  /* UPTransportLayerInformation */
static int hf_xnap_additional_UL_NG_U_TNLatUPF = -1;  /* UPTransportLayerInformation */
static int hf_xnap_Additional_UL_NG_U_TNLatUPF_List_item = -1;  /* Additional_UL_NG_U_TNLatUPF_Item */
static int hf_xnap_Additional_Measurement_Timing_Configuration_List_item = -1;  /* Additional_Measurement_Timing_Configuration_Item */
static int hf_xnap_additionalMeasurementTimingConfigurationIndex = -1;  /* INTEGER_0_16 */
static int hf_xnap_csi_RS_MTC_Configuration_List = -1;  /* CSI_RS_MTC_Configuration_List */
static int hf_xnap_mBS_QoSFlowsToAdd_List = -1;   /* MBS_QoSFlowsToAdd_List */
static int hf_xnap_mBS_ServiceArea = -1;          /* MBS_ServiceArea */
static int hf_xnap_mBS_MappingandDataForwardingRequestInfofromSource = -1;  /* MBS_MappingandDataForwardingRequestInfofromSource */
static int hf_xnap_priorityLevel = -1;            /* INTEGER_0_15_ */
static int hf_xnap_pre_emption_capability = -1;   /* T_pre_emption_capability */
static int hf_xnap_pre_emption_vulnerability = -1;  /* T_pre_emption_vulnerability */
static int hf_xnap_AllowedCAG_ID_List_perPLMN_item = -1;  /* CAG_Identifier */
static int hf_xnap_AllowedPNI_NPN_ID_List_item = -1;  /* AllowedPNI_NPN_ID_Item */
static int hf_xnap_plmn_id = -1;                  /* PLMN_Identity */
static int hf_xnap_pni_npn_restricted_information = -1;  /* PNI_NPN_Restricted_Information */
static int hf_xnap_allowed_CAG_id_list_per_plmn = -1;  /* AllowedCAG_ID_List_perPLMN */
static int hf_xnap_AlternativeQoSParaSetList_item = -1;  /* AlternativeQoSParaSetItem */
static int hf_xnap_alternativeQoSParaSetIndex = -1;  /* QoSParaSetIndex */
static int hf_xnap_guaranteedFlowBitRateDL = -1;  /* BitRate */
static int hf_xnap_guaranteedFlowBitRateUL = -1;  /* BitRate */
static int hf_xnap_packetDelayBudget = -1;        /* PacketDelayBudget */
static int hf_xnap_packetErrorRate = -1;          /* PacketErrorRate */
static int hf_xnap_AMF_Region_Information_item = -1;  /* GlobalAMF_Region_Information */
static int hf_xnap_plmn_ID = -1;                  /* PLMN_Identity */
static int hf_xnap_amf_region_id = -1;            /* BIT_STRING_SIZE_8 */
static int hf_xnap_AreaOfInterestInformation_item = -1;  /* AreaOfInterest_Item */
static int hf_xnap_listOfTAIsinAoI = -1;          /* ListOfTAIsinAoI */
static int hf_xnap_listOfCellsinAoI = -1;         /* ListOfCells */
static int hf_xnap_listOfRANNodesinAoI = -1;      /* ListOfRANNodesinAoI */
static int hf_xnap_requestReferenceID = -1;       /* RequestReferenceID */
static int hf_xnap_cellBased = -1;                /* CellBasedMDT_NR */
static int hf_xnap_tABased = -1;                  /* TABasedMDT */
static int hf_xnap_tAIBased = -1;                 /* TAIBasedMDT */
static int hf_xnap_choice_extension = -1;         /* ProtocolIE_Single_Container */
static int hf_xnap_cellBased_01 = -1;             /* CellBasedMDT_EUTRA */
static int hf_xnap_AreaScopeOfNeighCellsList_item = -1;  /* AreaScopeOfNeighCellsItem */
static int hf_xnap_nrFrequencyInfo = -1;          /* NRFrequencyInfo */
static int hf_xnap_pciListForMDT = -1;            /* PCIListForMDT */
static int hf_xnap_cellBased_02 = -1;             /* CellBasedQMC */
static int hf_xnap_tABased_01 = -1;               /* TABasedQMC */
static int hf_xnap_tAIBased_01 = -1;              /* TAIBasedQMC */
static int hf_xnap_pLMNAreaBased = -1;            /* PLMNAreaBasedQMC */
static int hf_xnap_key_NG_RAN_Star = -1;          /* BIT_STRING_SIZE_256 */
static int hf_xnap_ncc = -1;                      /* INTEGER_0_7 */
static int hf_xnap_ran_paging_attempt_info = -1;  /* RANPagingAttemptInfo */
static int hf_xnap_Associated_QoSFlowInfo_List_item = -1;  /* Associated_QoSFlowInfo_Item */
static int hf_xnap_mBS_QoSFlowIdentifier = -1;    /* QoSFlowIdentifier */
static int hf_xnap_associatedUnicastQoSFlowIdentifier = -1;  /* QoSFlowIdentifier */
static int hf_xnap_bufferLevel = -1;              /* T_bufferLevel */
static int hf_xnap_playoutDelayForMediaStartup = -1;  /* T_playoutDelayForMediaStartup */
static int hf_xnap_bAPAddress = -1;               /* BAPAddress */
static int hf_xnap_bAPPathID = -1;                /* BAPPathID */
static int hf_xnap_beamMeasurementsReportQuantity = -1;  /* BeamMeasurementsReportQuantity */
static int hf_xnap_maxNrofRS_IndexesToReport = -1;  /* MaxNrofRS_IndexesToReport */
static int hf_xnap_rSRP = -1;                     /* T_rSRP */
static int hf_xnap_rSRQ = -1;                     /* T_rSRQ */
static int hf_xnap_sINR = -1;                     /* T_sINR */
static int hf_xnap_BHInfoList_item = -1;          /* BHInfo_Item */
static int hf_xnap_bHInfoIndex = -1;              /* BHInfoIndex */
static int hf_xnap_BAPControlPDURLCCH_List_item = -1;  /* BAPControlPDURLCCH_Item */
static int hf_xnap_bHRLCCHID = -1;                /* BHRLCChannelID */
static int hf_xnap_nexthopBAPAddress = -1;        /* BAPAddress */
static int hf_xnap_bluetoothMeasConfig = -1;      /* BluetoothMeasConfig */
static int hf_xnap_bluetoothMeasConfigNameList = -1;  /* BluetoothMeasConfigNameList */
static int hf_xnap_bt_rssi = -1;                  /* T_bt_rssi */
static int hf_xnap_BluetoothMeasConfigNameList_item = -1;  /* BluetoothName */
static int hf_xnap_BPLMN_ID_Info_EUTRA_item = -1;  /* BPLMN_ID_Info_EUTRA_Item */
static int hf_xnap_broadcastPLMNs = -1;           /* BroadcastEUTRAPLMNs */
static int hf_xnap_tac = -1;                      /* TAC */
static int hf_xnap_e_utraCI = -1;                 /* E_UTRA_Cell_Identity */
static int hf_xnap_ranac = -1;                    /* RANAC */
static int hf_xnap_iE_Extension = -1;             /* ProtocolExtensionContainer */
static int hf_xnap_BPLMN_ID_Info_NR_item = -1;    /* BPLMN_ID_Info_NR_Item */
static int hf_xnap_broadcastPLMNs_01 = -1;        /* BroadcastPLMNs */
static int hf_xnap_nr_CI = -1;                    /* NR_Cell_Identity */
static int hf_xnap_BroadcastCAG_Identifier_List_item = -1;  /* BroadcastCAG_Identifier_Item */
static int hf_xnap_cag_Identifier = -1;           /* CAG_Identifier */
static int hf_xnap_BroadcastNID_List_item = -1;   /* BroadcastNID_Item */
static int hf_xnap_nid = -1;                      /* NID */
static int hf_xnap_BroadcastPLMNs_item = -1;      /* PLMN_Identity */
static int hf_xnap_BroadcastEUTRAPLMNs_item = -1;  /* PLMN_Identity */
static int hf_xnap_tAISliceSupport_List = -1;     /* SliceSupport_List */
static int hf_xnap_BroadcastPNI_NPN_ID_Information_item = -1;  /* BroadcastPNI_NPN_ID_Information_Item */
static int hf_xnap_broadcastCAG_Identifier_List = -1;  /* BroadcastCAG_Identifier_List */
static int hf_xnap_BroadcastSNPNID_List_item = -1;  /* BroadcastSNPNID */
static int hf_xnap_broadcastNID_List = -1;        /* BroadcastNID_List */
static int hf_xnap_capacityValue = -1;            /* CapacityValue */
static int hf_xnap_ssbAreaCapacityValueList = -1;  /* SSBAreaCapacityValue_List */
static int hf_xnap_radioNetwork = -1;             /* CauseRadioNetworkLayer */
static int hf_xnap_transport = -1;                /* CauseTransportLayer */
static int hf_xnap_protocol = -1;                 /* CauseProtocol */
static int hf_xnap_misc = -1;                     /* CauseMisc */
static int hf_xnap_limitedNR_List = -1;           /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_limitedNR_List_item = -1;      /* NR_CGI */
static int hf_xnap_full_List = -1;                /* T_full_List */
static int hf_xnap_maximumCellListSize = -1;      /* MaximumCellListSize */
static int hf_xnap_cellAssistanceInfo_NR = -1;    /* CellAssistanceInfo_NR */
static int hf_xnap_cellAssistanceInfo_EUTRA = -1;  /* CellAssistanceInfo_EUTRA */
static int hf_xnap_limitedEUTRA_List = -1;        /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_limitedEUTRA_List_item = -1;   /* E_UTRA_CGI */
static int hf_xnap_full_List_01 = -1;             /* T_full_List_01 */
static int hf_xnap_cellIdListforMDT_NR = -1;      /* CellIdListforMDT_NR */
static int hf_xnap_CellIdListforMDT_NR_item = -1;  /* NR_CGI */
static int hf_xnap_cellIdListforQMC = -1;         /* CellIdListforQMC */
static int hf_xnap_CellIdListforQMC_item = -1;    /* GlobalNG_RANCell_ID */
static int hf_xnap_cellIdListforMDT_EUTRA = -1;   /* CellIdListforMDT_EUTRA */
static int hf_xnap_CellIdListforMDT_EUTRA_item = -1;  /* E_UTRA_CGI */
static int hf_xnap_CellMeasurementResult_item = -1;  /* CellMeasurementResult_Item */
static int hf_xnap_cell_ID = -1;                  /* GlobalNG_RANCell_ID */
static int hf_xnap_radioResourceStatus = -1;      /* RadioResourceStatus */
static int hf_xnap_tNLCapacityIndicator = -1;     /* TNLCapacityIndicator */
static int hf_xnap_compositeAvailableCapacityGroup = -1;  /* CompositeAvailableCapacityGroup */
static int hf_xnap_sliceAvailableCapacity = -1;   /* SliceAvailableCapacity */
static int hf_xnap_numberofActiveUEs = -1;        /* NumberofActiveUEs */
static int hf_xnap_rRCConnections = -1;           /* RRCConnections */
static int hf_xnap_replacingCells = -1;           /* ReplacingCells */
static int hf_xnap_CellToReport_item = -1;        /* CellToReport_Item */
static int hf_xnap_sSBToReport_List = -1;         /* SSBToReport_List */
static int hf_xnap_sliceToReport_List = -1;       /* SliceToReport_List */
static int hf_xnap_ng_ran_e_utra = -1;            /* E_UTRA_Cell_Identity */
static int hf_xnap_ng_ran_nr = -1;                /* NR_Cell_Identity */
static int hf_xnap_e_utran = -1;                  /* E_UTRA_Cell_Identity */
static int hf_xnap_choCandidateCell_List = -1;    /* CHOCandidateCell_List */
static int hf_xnap_CHOCandidateCell_List_item = -1;  /* CHOCandidateCell_Item */
static int hf_xnap_choCandidateCellID = -1;       /* GlobalNG_RANCell_ID */
static int hf_xnap_choExecutionCondition_List = -1;  /* CHOExecutionCondition_List */
static int hf_xnap_CHOExecutionCondition_List_item = -1;  /* CHOExecutionCondition_Item */
static int hf_xnap_measObjectContainer = -1;      /* MeasObjectContainer */
static int hf_xnap_reportConfigContainer = -1;    /* ReportConfigContainer */
static int hf_xnap_compositeAvailableCapacityDownlink = -1;  /* CompositeAvailableCapacity */
static int hf_xnap_compositeAvailableCapacityUplink = -1;  /* CompositeAvailableCapacity */
static int hf_xnap_cellCapacityClassValue = -1;   /* CellCapacityClassValue */
static int hf_xnap_capacityValueInfo = -1;        /* CapacityValueInfo */
static int hf_xnap_cho_trigger = -1;              /* CHOtrigger */
static int hf_xnap_targetNG_RANnodeUEXnAPID = -1;  /* NG_RANnodeUEXnAPID */
static int hf_xnap_cHO_EstimatedArrivalProbability = -1;  /* CHO_Probability */
static int hf_xnap_requestedTargetCellGlobalID = -1;  /* Target_CGI */
static int hf_xnap_maxCHOoperations = -1;         /* MaxCHOpreparations */
static int hf_xnap_source_M_NGRAN_node_ID = -1;   /* GlobalNG_RANNode_ID */
static int hf_xnap_source_M_NGRAN_node_UE_XnAP_ID = -1;  /* NG_RANnodeUEXnAPID */
static int hf_xnap_conditionalReconfig = -1;      /* T_conditionalReconfig */
static int hf_xnap_eNDC_Support = -1;             /* T_eNDC_Support */
static int hf_xnap_pdcp_SN12 = -1;                /* INTEGER_0_4095 */
static int hf_xnap_hfn_PDCP_SN12 = -1;            /* INTEGER_0_1048575 */
static int hf_xnap_pdcp_SN18 = -1;                /* INTEGER_0_262143 */
static int hf_xnap_hfn_PDCP_SN18 = -1;            /* INTEGER_0_16383 */
static int hf_xnap_Coverage_Modification_List_item = -1;  /* Coverage_Modification_List_Item */
static int hf_xnap_globalNG_RANCell_ID = -1;      /* GlobalCell_ID */
static int hf_xnap_cellCoverageState = -1;        /* INTEGER_0_63_ */
static int hf_xnap_cellDeploymentStatusIndicator = -1;  /* CellDeploymentStatusIndicator */
static int hf_xnap_cellReplacingInfo = -1;        /* CellReplacingInfo */
static int hf_xnap_sSB_Coverage_Modification_List = -1;  /* SSB_Coverage_Modification_List */
static int hf_xnap_endpointIPAddress = -1;        /* TransportLayerAddress */
static int hf_xnap_CPACcandidatePSCells_list_item = -1;  /* CPACcandidatePSCells_item */
static int hf_xnap_pscell_id = -1;                /* NR_CGI */
static int hf_xnap_max_no_of_pscells = -1;        /* INTEGER_1_maxnoofPSCellCandidates_ */
static int hf_xnap_cpac_EstimatedArrivalProbability = -1;  /* CHO_Probability */
static int hf_xnap_candidate_pscells = -1;        /* CPACcandidatePSCells_list */
static int hf_xnap_cpc_target_sn_required_list = -1;  /* CPC_target_SN_required_list */
static int hf_xnap_CPC_target_SN_required_list_item = -1;  /* CPC_target_SN_required_list_Item */
static int hf_xnap_target_S_NG_RANnodeID = -1;    /* GlobalNG_RANNode_ID */
static int hf_xnap_cpc_indicator = -1;            /* CPCindicator */
static int hf_xnap_sN_to_MN_Container = -1;       /* T_sN_to_MN_Container */
static int hf_xnap_cpc_target_sn_confirm_list = -1;  /* CPC_target_SN_confirm_list */
static int hf_xnap_CPC_target_SN_confirm_list_item = -1;  /* CPC_target_SN_confirm_list_Item */
static int hf_xnap_max_no_of_pscells_01 = -1;     /* INTEGER_1_8_ */
static int hf_xnap_cpc_target_sn_list = -1;       /* CPC_target_SN_mod_list */
static int hf_xnap_CPC_target_SN_mod_list_item = -1;  /* CPC_target_SN_mod_item */
static int hf_xnap_candidate_pscells_01 = -1;     /* CPCInformationUpdatePSCells_list */
static int hf_xnap_CPCInformationUpdatePSCells_list_item = -1;  /* CPCInformationUpdatePSCells_item */
static int hf_xnap_procedureCode = -1;            /* ProcedureCode */
static int hf_xnap_triggeringMessage = -1;        /* TriggeringMessage */
static int hf_xnap_procedureCriticality = -1;     /* Criticality */
static int hf_xnap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_xnap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_List_item */
static int hf_xnap_iECriticality = -1;            /* Criticality */
static int hf_xnap_iE_ID = -1;                    /* ProtocolIE_ID */
static int hf_xnap_typeOfError = -1;              /* TypeOfError */
static int hf_xnap_CSI_RS_MTC_Configuration_List_item = -1;  /* CSI_RS_MTC_Configuration_Item */
static int hf_xnap_csi_RS_Index = -1;             /* INTEGER_0_95 */
static int hf_xnap_csi_RS_Status = -1;            /* T_csi_RS_Status */
static int hf_xnap_csi_RS_Neighbour_List = -1;    /* CSI_RS_Neighbour_List */
static int hf_xnap_CSI_RS_Neighbour_List_item = -1;  /* CSI_RS_Neighbour_Item */
static int hf_xnap_nr_cgi = -1;                   /* NR_CGI */
static int hf_xnap_csi_RS_MTC_Neighbour_List = -1;  /* CSI_RS_MTC_Neighbour_List */
static int hf_xnap_CSI_RS_MTC_Neighbour_List_item = -1;  /* CSI_RS_MTC_Neighbour_Item */
static int hf_xnap_XnUAddressInfoperPDUSession_List_item = -1;  /* XnUAddressInfoperPDUSession_Item */
static int hf_xnap_pduSession_ID = -1;            /* PDUSession_ID */
static int hf_xnap_dataForwardingInfoFromTargetNGRANnode = -1;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_pduSessionResourceSetupCompleteInfo_SNterm = -1;  /* PDUSessionResourceBearerSetupCompleteInfo_SNterminated */
static int hf_xnap_dataForwardingInfoFromTargetE_UTRANnode_List = -1;  /* DataForwardingInfoFromTargetE_UTRANnode_List */
static int hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_List_item = -1;  /* DataForwardingInfoFromTargetE_UTRANnode_Item */
static int hf_xnap_dlForwardingUPTNLInformation = -1;  /* UPTransportLayerInformation */
static int hf_xnap_qosFlowsToBeForwarded_List = -1;  /* QoSFlowsToBeForwarded_List */
static int hf_xnap_QoSFlowsToBeForwarded_List_item = -1;  /* QoSFlowsToBeForwarded_Item */
static int hf_xnap_qosFlowIdentifier = -1;        /* QoSFlowIdentifier */
static int hf_xnap_qosFlowsAcceptedForDataForwarding_List = -1;  /* QoSFLowsAcceptedToBeForwarded_List */
static int hf_xnap_pduSessionLevelDLDataForwardingInfo = -1;  /* UPTransportLayerInformation */
static int hf_xnap_pduSessionLevelULDataForwardingInfo = -1;  /* UPTransportLayerInformation */
static int hf_xnap_dataForwardingResponseDRBItemList = -1;  /* DataForwardingResponseDRBItemList */
static int hf_xnap_QoSFLowsAcceptedToBeForwarded_List_item = -1;  /* QoSFLowsAcceptedToBeForwarded_Item */
static int hf_xnap_qosFlowsToBeForwarded = -1;    /* QoSFLowsToBeForwarded_List */
static int hf_xnap_sourceDRBtoQoSFlowMapping = -1;  /* DRBToQoSFlowMapping_List */
static int hf_xnap_QoSFLowsToBeForwarded_List_item = -1;  /* QoSFLowsToBeForwarded_Item */
static int hf_xnap_dl_dataforwarding = -1;        /* DLForwarding */
static int hf_xnap_ul_dataforwarding = -1;        /* ULForwarding */
static int hf_xnap_DataForwardingResponseDRBItemList_item = -1;  /* DataForwardingResponseDRBItem */
static int hf_xnap_drb_ID = -1;                   /* DRB_ID */
static int hf_xnap_dlForwardingUPTNL = -1;        /* UPTransportLayerInformation */
static int hf_xnap_ulForwardingUPTNL = -1;        /* UPTransportLayerInformation */
static int hf_xnap_activationSFN = -1;            /* ActivationSFN */
static int hf_xnap_sharedResourceType = -1;       /* SharedResourceType */
static int hf_xnap_reservedSubframePattern = -1;  /* ReservedSubframePattern */
static int hf_xnap_dapsIndicator = -1;            /* T_dapsIndicator */
static int hf_xnap_DAPSResponseInfo_List_item = -1;  /* DAPSResponseInfo_Item */
static int hf_xnap_drbID = -1;                    /* DRB_ID */
static int hf_xnap_dapsResponseIndicator = -1;    /* T_dapsResponseIndicator */
static int hf_xnap_count12bits = -1;              /* COUNT_PDCP_SN12 */
static int hf_xnap_count18bits = -1;              /* COUNT_PDCP_SN18 */
static int hf_xnap_egressBAPRoutingID = -1;       /* BAPRoutingID */
static int hf_xnap_egressBHRLCCHID = -1;          /* BHRLCChannelID */
static int hf_xnap_ingressBAPRoutingID = -1;      /* BAPRoutingID */
static int hf_xnap_ingressBHRLCCHID = -1;         /* BHRLCChannelID */
static int hf_xnap_priorhopBAPAddress = -1;       /* BAPAddress */
static int hf_xnap_iabqosMappingInformation = -1;  /* IAB_QoS_Mapping_Information */
static int hf_xnap_DRB_List_item = -1;            /* DRB_ID */
static int hf_xnap_DRB_List_withCause_item = -1;  /* DRB_List_withCause_Item */
static int hf_xnap_drb_id = -1;                   /* DRB_ID */
static int hf_xnap_cause = -1;                    /* Cause */
static int hf_xnap_rLC_Mode = -1;                 /* RLCMode */
static int hf_xnap_DRBsSubjectToDLDiscarding_List_item = -1;  /* DRBsSubjectToDLDiscarding_Item */
static int hf_xnap_dlCount = -1;                  /* DLCountChoice */
static int hf_xnap_DRBsSubjectToEarlyStatusTransfer_List_item = -1;  /* DRBsSubjectToEarlyStatusTransfer_Item */
static int hf_xnap_DRBsSubjectToStatusTransfer_List_item = -1;  /* DRBsSubjectToStatusTransfer_Item */
static int hf_xnap_pdcpStatusTransfer_UL = -1;    /* DRBBStatusTransferChoice */
static int hf_xnap_pdcpStatusTransfer_DL = -1;    /* DRBBStatusTransferChoice */
static int hf_xnap_pdcp_sn_12bits = -1;           /* DRBBStatusTransfer12bitsSN */
static int hf_xnap_pdcp_sn_18bits = -1;           /* DRBBStatusTransfer18bitsSN */
static int hf_xnap_receiveStatusofPDCPSDU = -1;   /* BIT_STRING_SIZE_1_2048 */
static int hf_xnap_cOUNTValue = -1;               /* COUNT_PDCP_SN12 */
static int hf_xnap_receiveStatusofPDCPSDU_01 = -1;  /* BIT_STRING_SIZE_1_131072 */
static int hf_xnap_cOUNTValue_01 = -1;            /* COUNT_PDCP_SN18 */
static int hf_xnap_DRBToQoSFlowMapping_List_item = -1;  /* DRBToQoSFlowMapping_Item */
static int hf_xnap_qosFlows_List = -1;            /* QoSFlows_List */
static int hf_xnap_DUF_Slot_Config_List_item = -1;  /* DUF_Slot_Config_Item */
static int hf_xnap_explicitFormat = -1;           /* ExplicitFormat */
static int hf_xnap_implicitFormat = -1;           /* ImplicitFormat */
static int hf_xnap_priorityLevelQoS = -1;         /* PriorityLevelQoS */
static int hf_xnap_fiveQI = -1;                   /* FiveQI */
static int hf_xnap_delayCritical = -1;            /* T_delayCritical */
static int hf_xnap_averagingWindow = -1;          /* AveragingWindow */
static int hf_xnap_maximumDataBurstVolume = -1;   /* MaximumDataBurstVolume */
static int hf_xnap_e_utra_CI = -1;                /* E_UTRA_Cell_Identity */
static int hf_xnap_E_UTRAMultibandInfoList_item = -1;  /* E_UTRAFrequencyBandIndicator */
static int hf_xnap_eutrapaging_eDRX_Cycle = -1;   /* EUTRAPaging_eDRX_Cycle */
static int hf_xnap_eutrapaging_Time_Window = -1;  /* EUTRAPaging_Time_Window */
static int hf_xnap_rootSequenceIndex = -1;        /* INTEGER_0_837 */
static int hf_xnap_zeroCorrelationIndex = -1;     /* INTEGER_0_15 */
static int hf_xnap_highSpeedFlag = -1;            /* T_highSpeedFlag */
static int hf_xnap_prach_FreqOffset = -1;         /* INTEGER_0_94 */
static int hf_xnap_prach_ConfigIndex = -1;        /* INTEGER_0_63 */
static int hf_xnap_portNumber = -1;               /* PortNumber */
static int hf_xnap_loggedEventTriggeredConfig = -1;  /* LoggedEventTriggeredConfig */
static int hf_xnap_outOfCoverage = -1;            /* T_outOfCoverage */
static int hf_xnap_eventL1 = -1;                  /* EventL1 */
static int hf_xnap_choice_Extensions = -1;        /* ProtocolIE_Single_Container */
static int hf_xnap_l1Threshold = -1;              /* MeasurementThresholdL1LoggedMDT */
static int hf_xnap_hysteresis = -1;               /* Hysteresis */
static int hf_xnap_timeToTrigger = -1;            /* TimeToTrigger */
static int hf_xnap_threshold_RSRP = -1;           /* Threshold_RSRP */
static int hf_xnap_threshold_RSRQ = -1;           /* Threshold_RSRQ */
static int hf_xnap_ExcessPacketDelayThresholdConfiguration_item = -1;  /* ExcessPacketDelayThresholdItem */
static int hf_xnap_excessPacketDelayThresholdValue = -1;  /* ExcessPacketDelayThresholdValue */
static int hf_xnap_expectedActivityPeriod = -1;   /* ExpectedActivityPeriod */
static int hf_xnap_expectedIdlePeriod = -1;       /* ExpectedIdlePeriod */
static int hf_xnap_sourceOfUEActivityBehaviourInformation = -1;  /* SourceOfUEActivityBehaviourInformation */
static int hf_xnap_expectedUEActivityBehaviour = -1;  /* ExpectedUEActivityBehaviour */
static int hf_xnap_expectedHOInterval = -1;       /* ExpectedHOInterval */
static int hf_xnap_expectedUEMobility = -1;       /* ExpectedUEMobility */
static int hf_xnap_expectedUEMovingTrajectory = -1;  /* ExpectedUEMovingTrajectory */
static int hf_xnap_ExpectedUEMovingTrajectory_item = -1;  /* ExpectedUEMovingTrajectoryItem */
static int hf_xnap_nGRAN_CGI = -1;                /* GlobalNG_RANCell_ID */
static int hf_xnap_timeStayedInCell = -1;         /* INTEGER_0_4095 */
static int hf_xnap_permutation = -1;              /* Permutation */
static int hf_xnap_noofDownlinkSymbols = -1;      /* INTEGER_0_14 */
static int hf_xnap_noofUplinkSymbols = -1;        /* INTEGER_0_14 */
static int hf_xnap_primaryRATRestriction = -1;    /* T_primaryRATRestriction */
static int hf_xnap_secondaryRATRestriction = -1;  /* T_secondaryRATRestriction */
static int hf_xnap_ExtendedSliceSupportList_item = -1;  /* S_NSSAI */
static int hf_xnap_ExtTLAs_item = -1;             /* ExtTLA_Item */
static int hf_xnap_iPsecTLA = -1;                 /* TransportLayerAddress */
static int hf_xnap_gTPTransportLayerAddresses = -1;  /* GTPTLAs */
static int hf_xnap_GTPTLAs_item = -1;             /* GTPTLA_Item */
static int hf_xnap_gTPTransportLayerAddresses_01 = -1;  /* TransportLayerAddress */
static int hf_xnap_f1TerminatingBHInformation_List = -1;  /* F1TerminatingBHInformation_List */
static int hf_xnap_F1TerminatingBHInformation_List_item = -1;  /* F1TerminatingBHInformation_Item */
static int hf_xnap_dLTNLAddress = -1;             /* IABTNLAddress */
static int hf_xnap_dlF1TerminatingBHInfo = -1;    /* DLF1Terminating_BHInfo */
static int hf_xnap_ulF1TerminatingBHInfo = -1;    /* ULF1Terminating_BHInfo */
static int hf_xnap_fiveGproSeDirectDiscovery = -1;  /* FiveGProSeDirectDiscovery */
static int hf_xnap_fiveGproSeDirectCommunication = -1;  /* FiveGProSeDirectCommunication */
static int hf_xnap_fiveGnrProSeLayer2UEtoNetworkRelay = -1;  /* FiveGProSeLayer2UEtoNetworkRelay */
static int hf_xnap_fiveGnrProSeLayer3UEtoNetworkRelay = -1;  /* FiveGProSeLayer3UEtoNetworkRelay */
static int hf_xnap_fiveGnrProSeLayer2RemoteUE = -1;  /* FiveGProSeLayer2RemoteUE */
static int hf_xnap_fiveGProSepc5QoSFlowList = -1;  /* FiveGProSePC5QoSFlowList */
static int hf_xnap_fiveGproSepc5LinkAggregateBitRates = -1;  /* BitRate */
static int hf_xnap_FiveGProSePC5QoSFlowList_item = -1;  /* FiveGProSePC5QoSFlowItem */
static int hf_xnap_fiveGproSepQI = -1;            /* FiveQI */
static int hf_xnap_fiveGproSepc5FlowBitRates = -1;  /* FiveGProSePC5FlowBitRates */
static int hf_xnap_fiveGproSerange = -1;          /* Range */
static int hf_xnap_fiveGproSeguaranteedFlowBitRate = -1;  /* BitRate */
static int hf_xnap_fiveGproSemaximumFlowBitRate = -1;  /* BitRate */
static int hf_xnap_Flows_Mapped_To_DRB_List_item = -1;  /* Flows_Mapped_To_DRB_Item */
static int hf_xnap_qoSFlowIdentifier = -1;        /* QoSFlowIdentifier */
static int hf_xnap_qoSFlowLevelQoSParameters = -1;  /* QoSFlowLevelQoSParameters */
static int hf_xnap_qoSFlowMappingIndication = -1;  /* QoSFlowMappingIndication */
static int hf_xnap_FreqDomainHSNAconfiguration_List_item = -1;  /* FreqDomainHSNAconfiguration_List_Item */
static int hf_xnap_rBsetIndex = -1;               /* INTEGER_0_maxnoofRBsetsPerCell1_ */
static int hf_xnap_freqDomainSlotHSNAconfiguration_List = -1;  /* FreqDomainSlotHSNAconfiguration_List */
static int hf_xnap_FreqDomainSlotHSNAconfiguration_List_item = -1;  /* FreqDomainSlotHSNAconfiguration_List_Item */
static int hf_xnap_slotIndex = -1;                /* INTEGER_1_maxnoofHSNASlots */
static int hf_xnap_hSNADownlink = -1;             /* HSNADownlink */
static int hf_xnap_hSNAUplink = -1;               /* HSNAUplink */
static int hf_xnap_hSNAFlexible = -1;             /* HSNAFlexible */
static int hf_xnap_maxFlowBitRateDL = -1;         /* BitRate */
static int hf_xnap_maxFlowBitRateUL = -1;         /* BitRate */
static int hf_xnap_notificationControl = -1;      /* T_notificationControl */
static int hf_xnap_maxPacketLossRateDL = -1;      /* PacketLossRate */
static int hf_xnap_maxPacketLossRateUL = -1;      /* PacketLossRate */
static int hf_xnap_gnb_id = -1;                   /* GNB_ID_Choice */
static int hf_xnap_subcarrierSpacing = -1;        /* SSB_subcarrierSpacing */
static int hf_xnap_dUFTransmissionPeriodicity = -1;  /* DUFTransmissionPeriodicity */
static int hf_xnap_dUF_Slot_Config_List = -1;     /* DUF_Slot_Config_List */
static int hf_xnap_hSNATransmissionPeriodicity = -1;  /* HSNATransmissionPeriodicity */
static int hf_xnap_hNSASlotConfigList = -1;       /* HSNASlotConfigList */
static int hf_xnap_rBsetConfiguration = -1;       /* RBsetConfiguration */
static int hf_xnap_freqDomainHSNAconfiguration_List = -1;  /* FreqDomainHSNAconfiguration_List */
static int hf_xnap_nACellResourceConfigurationList = -1;  /* NACellResourceConfigurationList */
static int hf_xnap_gnb_ID = -1;                   /* BIT_STRING_SIZE_22_32 */
static int hf_xnap_ssbAreaRadioResourceStatus_List = -1;  /* SSBAreaRadioResourceStatus_List */
static int hf_xnap_cell_type = -1;                /* Cell_Type_Choice */
static int hf_xnap_enb_id = -1;                   /* ENB_ID_Choice */
static int hf_xnap_enb_ID_macro = -1;             /* BIT_STRING_SIZE_20 */
static int hf_xnap_enb_ID_shortmacro = -1;        /* BIT_STRING_SIZE_18 */
static int hf_xnap_enb_ID_longmacro = -1;         /* BIT_STRING_SIZE_21 */
static int hf_xnap_ng_RAN_Cell_id = -1;           /* NG_RAN_Cell_Identity */
static int hf_xnap_gNB = -1;                      /* GlobalgNB_ID */
static int hf_xnap_ng_eNB = -1;                   /* GlobalngeNB_ID */
static int hf_xnap_tnl_address = -1;              /* TransportLayerAddress */
static int hf_xnap_gtp_teid = -1;                 /* GTP_TEID */
static int hf_xnap_amf_set_id = -1;               /* BIT_STRING_SIZE_10 */
static int hf_xnap_amf_pointer = -1;              /* BIT_STRING_SIZE_6 */
static int hf_xnap_HSNASlotConfigList_item = -1;  /* HSNASlotConfigItem */
static int hf_xnap_nRCGI = -1;                    /* NR_CGI */
static int hf_xnap_iAB_DU_Cell_Resource_Configuration_Mode_Info = -1;  /* IAB_DU_Cell_Resource_Configuration_Mode_Info */
static int hf_xnap_iAB_STC_Info = -1;             /* IAB_STC_Info */
static int hf_xnap_rACH_Config_Common = -1;       /* RACH_Config_Common */
static int hf_xnap_rACH_Config_Common_IAB = -1;   /* RACH_Config_Common_IAB */
static int hf_xnap_cSI_RS_Configuration = -1;     /* T_cSI_RS_Configuration */
static int hf_xnap_sR_Configuration = -1;         /* T_sR_Configuration */
static int hf_xnap_pDCCH_ConfigSIB1 = -1;         /* T_pDCCH_ConfigSIB1 */
static int hf_xnap_sCS_Common = -1;               /* T_sCS_Common */
static int hf_xnap_multiplexingInfo = -1;         /* MultiplexingInfo */
static int hf_xnap_tDD = -1;                      /* IAB_DU_Cell_Resource_Configuration_TDD_Info */
static int hf_xnap_fDD = -1;                      /* IAB_DU_Cell_Resource_Configuration_FDD_Info */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_UL = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_DL = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_uLFrequencyInfo = -1;          /* NRFrequencyInfo */
static int hf_xnap_dLFrequencyInfo = -1;          /* NRFrequencyInfo */
static int hf_xnap_uLTransmissionBandwidth = -1;  /* NRTransmissionBandwidth */
static int hf_xnap_dlTransmissionBandwidth = -1;  /* NRTransmissionBandwidth */
static int hf_xnap_uLCarrierList = -1;            /* NRCarrierList */
static int hf_xnap_dlCarrierList = -1;            /* NRCarrierList */
static int hf_xnap_gNB_DU_Cell_Resource_Configuration_TDD = -1;  /* GNB_DU_Cell_Resource_Configuration */
static int hf_xnap_frequencyInfo = -1;            /* NRFrequencyInfo */
static int hf_xnap_transmissionBandwidth = -1;    /* NRTransmissionBandwidth */
static int hf_xnap_carrierList = -1;              /* NRCarrierList */
static int hf_xnap_IAB_MT_Cell_List_item = -1;    /* IAB_MT_Cell_List_Item */
static int hf_xnap_nRCellIdentity = -1;           /* NR_Cell_Identity */
static int hf_xnap_dU_RX_MT_RX = -1;              /* DU_RX_MT_RX */
static int hf_xnap_dU_TX_MT_TX = -1;              /* DU_TX_MT_TX */
static int hf_xnap_dU_RX_MT_TX = -1;              /* DU_RX_MT_TX */
static int hf_xnap_dU_TX_MT_RX = -1;              /* DU_TX_MT_RX */
static int hf_xnap_dscp = -1;                     /* BIT_STRING_SIZE_6 */
static int hf_xnap_flow_label = -1;               /* BIT_STRING_SIZE_20 */
static int hf_xnap_iAB_STC_Info_List = -1;        /* IAB_STC_Info_List */
static int hf_xnap_IAB_STC_Info_List_item = -1;   /* IAB_STC_Info_Item */
static int hf_xnap_sSB_freqInfo = -1;             /* SSB_freqInfo */
static int hf_xnap_sSB_subcarrierSpacing = -1;    /* SSB_subcarrierSpacing */
static int hf_xnap_sSB_transmissionPeriodicity = -1;  /* SSB_transmissionPeriodicity */
static int hf_xnap_sSB_transmissionTimingOffset = -1;  /* SSB_transmissionTimingOffset */
static int hf_xnap_sSB_transmissionBitmap = -1;   /* SSB_transmissionBitmap */
static int hf_xnap_iABIPv4AddressesRequested = -1;  /* IABTNLAddressesRequested */
static int hf_xnap_iABIPv6RequestType = -1;       /* IABIPv6RequestType */
static int hf_xnap_iABTNLAddressToRemove_List = -1;  /* IABTNLAddressToRemove_List */
static int hf_xnap_iPv6Address = -1;              /* IABTNLAddressesRequested */
static int hf_xnap_iPv6Prefix = -1;               /* IABTNLAddressesRequested */
static int hf_xnap_iABAllocatedTNLAddress_List = -1;  /* IABAllocatedTNLAddress_List */
static int hf_xnap_IABAllocatedTNLAddress_List_item = -1;  /* IABAllocatedTNLAddress_Item */
static int hf_xnap_iABTNLAddress = -1;            /* IABTNLAddress */
static int hf_xnap_iABTNLAddressUsage = -1;       /* IABTNLAddressUsage */
static int hf_xnap_associatedDonorDUAddress = -1;  /* BAPAddress */
static int hf_xnap_iPv4Address = -1;              /* T_iPv4Address */
static int hf_xnap_iPv6Address_01 = -1;           /* T_iPv6Address */
static int hf_xnap_iPv6Prefix_01 = -1;            /* T_iPv6Prefix */
static int hf_xnap_tNLAddressesOrPrefixesRequestedAllTraffic = -1;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedF1_C = -1;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedF1_U = -1;  /* INTEGER_1_256 */
static int hf_xnap_tNLAddressesOrPrefixesRequestedNoNF1 = -1;  /* INTEGER_1_256 */
static int hf_xnap_IABTNLAddressToRemove_List_item = -1;  /* IABTNLAddressToRemove_Item */
static int hf_xnap_IABTNLAddressException_item = -1;  /* IABTNLAddress_Item */
static int hf_xnap_measurementsToActivate = -1;   /* MeasurementsToActivate */
static int hf_xnap_m1Configuration = -1;          /* M1Configuration */
static int hf_xnap_m4Configuration = -1;          /* M4Configuration */
static int hf_xnap_m5Configuration = -1;          /* M5Configuration */
static int hf_xnap_mDT_Location_Info = -1;        /* MDT_Location_Info */
static int hf_xnap_m6Configuration = -1;          /* M6Configuration */
static int hf_xnap_m7Configuration = -1;          /* M7Configuration */
static int hf_xnap_bluetoothMeasurementConfiguration = -1;  /* BluetoothMeasurementConfiguration */
static int hf_xnap_wLANMeasurementConfiguration = -1;  /* WLANMeasurementConfiguration */
static int hf_xnap_sensorMeasurementConfiguration = -1;  /* SensorMeasurementConfiguration */
static int hf_xnap_dUFSlotformatIndex = -1;       /* DUFSlotformatIndex */
static int hf_xnap_rRCReestab = -1;               /* RRCReestab_initiated */
static int hf_xnap_rRCSetup = -1;                 /* RRCSetup_initiated */
static int hf_xnap_nrscs = -1;                    /* NRSCS */
static int hf_xnap_nrCyclicPrefix = -1;           /* NRCyclicPrefix */
static int hf_xnap_nrDL_ULTransmissionPeriodicity = -1;  /* NRDL_ULTransmissionPeriodicity */
static int hf_xnap_slotConfiguration_List = -1;   /* SlotConfiguration_List */
static int hf_xnap_i_RNTI_full = -1;              /* BIT_STRING_SIZE_40 */
static int hf_xnap_i_RNTI_short = -1;             /* BIT_STRING_SIZE_24 */
static int hf_xnap_full_I_RNTI_Profile_List = -1;  /* Full_I_RNTI_Profile_List */
static int hf_xnap_short_I_RNTI_Profile_List = -1;  /* Short_I_RNTI_Profile_List */
static int hf_xnap_full_I_RNTI_Profile_0 = -1;    /* BIT_STRING_SIZE_21 */
static int hf_xnap_full_I_RNTI_Profile_1 = -1;    /* BIT_STRING_SIZE_18 */
static int hf_xnap_full_I_RNTI_Profile_2 = -1;    /* BIT_STRING_SIZE_15 */
static int hf_xnap_full_I_RNTI_Profile_3 = -1;    /* BIT_STRING_SIZE_12 */
static int hf_xnap_short_I_RNTI_Profile_0 = -1;   /* BIT_STRING_SIZE_8 */
static int hf_xnap_short_I_RNTI_Profile_1 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_xnap_nG_RAN_Cell = -1;              /* LastVisitedNGRANCellInformation */
static int hf_xnap_e_UTRAN_Cell = -1;             /* LastVisitedEUTRANCellInformation */
static int hf_xnap_uTRAN_Cell = -1;               /* LastVisitedUTRANCellInformation */
static int hf_xnap_gERAN_Cell = -1;               /* LastVisitedGERANCellInformation */
static int hf_xnap_LastVisitedPSCellList_item = -1;  /* LastVisitedPSCellList_Item */
static int hf_xnap_lastVisitedPSCellInformation = -1;  /* LastVisitedPSCellInformation */
static int hf_xnap_lastVisitedPSCellList = -1;    /* LastVisitedPSCellList */
static int hf_xnap_ListOfCells_item = -1;         /* CellsinAoI_Item */
static int hf_xnap_pLMN_Identity = -1;            /* PLMN_Identity */
static int hf_xnap_ng_ran_cell_id = -1;           /* NG_RAN_Cell_Identity */
static int hf_xnap_ListOfRANNodesinAoI_item = -1;  /* GlobalNG_RANNodesinAoI_Item */
static int hf_xnap_global_NG_RAN_Node_ID = -1;    /* GlobalNG_RANNode_ID */
static int hf_xnap_ListOfTAIsinAoI_item = -1;     /* TAIsinAoI_Item */
static int hf_xnap_tAC = -1;                      /* TAC */
static int hf_xnap_eventType = -1;                /* EventType */
static int hf_xnap_reportArea = -1;               /* ReportArea */
static int hf_xnap_areaOfInterest = -1;           /* AreaOfInterestInformation */
static int hf_xnap_eventTypeTrigger = -1;         /* EventTypeTrigger */
static int hf_xnap_loggingInterval = -1;          /* LoggingInterval */
static int hf_xnap_loggingDuration = -1;          /* LoggingDuration */
static int hf_xnap_reportType = -1;               /* ReportType */
static int hf_xnap_areaScopeOfNeighCellsList = -1;  /* AreaScopeOfNeighCellsList */
static int hf_xnap_vehicleUE = -1;                /* VehicleUE */
static int hf_xnap_pedestrianUE = -1;             /* PedestrianUE */
static int hf_xnap_uESidelinkAggregateMaximumBitRate = -1;  /* BitRate */
static int hf_xnap_s_BasedMDT = -1;               /* S_BasedMDT */
static int hf_xnap_m1reportingTrigger = -1;       /* M1ReportingTrigger */
static int hf_xnap_m1thresholdeventA2 = -1;       /* M1ThresholdEventA2 */
static int hf_xnap_m1periodicReporting = -1;      /* M1PeriodicReporting */
static int hf_xnap_reportInterval = -1;           /* ReportIntervalMDT */
static int hf_xnap_reportAmount = -1;             /* ReportAmountMDT */
static int hf_xnap_measurementThreshold = -1;     /* MeasurementThresholdA2 */
static int hf_xnap_m4period = -1;                 /* M4period */
static int hf_xnap_m4_links_to_log = -1;          /* Links_to_log */
static int hf_xnap_m5period = -1;                 /* M5period */
static int hf_xnap_m5_links_to_log = -1;          /* Links_to_log */
static int hf_xnap_m6report_Interval = -1;        /* M6report_Interval */
static int hf_xnap_m6_links_to_log = -1;          /* Links_to_log */
static int hf_xnap_m7period = -1;                 /* M7period */
static int hf_xnap_m7_links_to_log = -1;          /* Links_to_log */
static int hf_xnap_maxIPrate_UL = -1;             /* MaxIPrate */
static int hf_xnap_oneframe = -1;                 /* BIT_STRING_SIZE_6 */
static int hf_xnap_fourframes = -1;               /* BIT_STRING_SIZE_24 */
static int hf_xnap_MBSFNSubframeInfo_E_UTRA_item = -1;  /* MBSFNSubframeInfo_E_UTRA_Item */
static int hf_xnap_radioframeAllocationPeriod = -1;  /* T_radioframeAllocationPeriod */
static int hf_xnap_radioframeAllocationOffset = -1;  /* INTEGER_0_7_ */
static int hf_xnap_subframeAllocation = -1;       /* MBSFNSubframeAllocation_E_UTRA */
static int hf_xnap_MBS_MappingandDataForwardingRequestInfofromSource_item = -1;  /* MBS_MappingandDataForwardingRequestInfofromSource_Item */
static int hf_xnap_mRB_ID = -1;                   /* MRB_ID */
static int hf_xnap_mBS_QoSFlow_List = -1;         /* MBS_QoSFlow_List */
static int hf_xnap_mRB_ProgressInformation = -1;  /* MRB_ProgressInformation */
static int hf_xnap_MBS_DataForwardingResponseInfofromTarget_item = -1;  /* MBS_DataForwardingResponseInfofromTarget_Item */
static int hf_xnap_MBS_QoSFlow_List_item = -1;    /* QoSFlowIdentifier */
static int hf_xnap_MBS_QoSFlowsToAdd_List_item = -1;  /* MBS_QoSFlowsToAdd_Item */
static int hf_xnap_mBS_QosFlowIdentifier = -1;    /* QoSFlowIdentifier */
static int hf_xnap_mBS_QosFlowLevelQosParameters = -1;  /* QoSFlowLevelQoSParameters */
static int hf_xnap_locationindependent = -1;      /* MBS_ServiceAreaInformation */
static int hf_xnap_locationdependent = -1;        /* MBS_ServiceAreaInformationList */
static int hf_xnap_MBS_ServiceAreaCell_List_item = -1;  /* NR_CGI */
static int hf_xnap_mBS_ServiceAreaCell_List = -1;  /* MBS_ServiceAreaCell_List */
static int hf_xnap_mBS_ServiceAreaTAI_List = -1;  /* MBS_ServiceAreaTAI_List */
static int hf_xnap_MBS_ServiceAreaInformationList_item = -1;  /* MBS_ServiceAreaInformation_Item */
static int hf_xnap_mBS_Area_Session_ID = -1;      /* MBS_Area_Session_ID */
static int hf_xnap_mBS_ServiceAreaInformation = -1;  /* MBS_ServiceAreaInformation */
static int hf_xnap_MBS_ServiceAreaTAI_List_item = -1;  /* MBS_ServiceAreaTAI_Item */
static int hf_xnap_tMGI = -1;                     /* TMGI */
static int hf_xnap_nID = -1;                      /* NID */
static int hf_xnap_MBS_SessionAssociatedInformation_item = -1;  /* MBS_SessionAssociatedInformation_Item */
static int hf_xnap_mBS_Session_ID = -1;           /* MBS_Session_ID */
static int hf_xnap_associated_QoSFlowInfo_List = -1;  /* Associated_QoSFlowInfo_List */
static int hf_xnap_MBS_SessionInformation_List_item = -1;  /* MBS_SessionInformation_Item */
static int hf_xnap_active_MBS_SessioInformation = -1;  /* Active_MBS_SessionInformation */
static int hf_xnap_MBS_SessionInformationResponse_List_item = -1;  /* MBS_SessionInformationResponse_Item */
static int hf_xnap_mBS_DataForwardingResponseInfofromTarget = -1;  /* MBS_DataForwardingResponseInfofromTarget */
static int hf_xnap_mDT_Configuration_NR = -1;     /* MDT_Configuration_NR */
static int hf_xnap_mDT_Configuration_EUTRA = -1;  /* MDT_Configuration_EUTRA */
static int hf_xnap_mdt_Activation = -1;           /* MDT_Activation */
static int hf_xnap_areaScopeOfMDT_NR = -1;        /* AreaScopeOfMDT_NR */
static int hf_xnap_mDTMode_NR = -1;               /* MDTMode_NR */
static int hf_xnap_signallingBasedMDTPLMNList = -1;  /* MDTPLMNList */
static int hf_xnap_areaScopeOfMDT_EUTRA = -1;     /* AreaScopeOfMDT_EUTRA */
static int hf_xnap_mDTMode_EUTRA = -1;            /* MDTMode_EUTRA */
static int hf_xnap_MDTPLMNList_item = -1;         /* PLMN_Identity */
static int hf_xnap_MDTPLMNModificationList_item = -1;  /* PLMN_Identity */
static int hf_xnap_immediateMDT = -1;             /* ImmediateMDT_NR */
static int hf_xnap_loggedMDT = -1;                /* LoggedMDT_NR */
static int hf_xnap_mDTMode_NR_Extension = -1;     /* MDTMode_NR_Extension */
static int hf_xnap_threshold_SINR = -1;           /* Threshold_SINR */
static int hf_xnap_dl_GBR_PRB_usage_for_MIMO = -1;  /* DL_GBR_PRB_usage_for_MIMO */
static int hf_xnap_ul_GBR_PRB_usage_for_MIMO = -1;  /* UL_GBR_PRB_usage_for_MIMO */
static int hf_xnap_dl_non_GBR_PRB_usage_for_MIMO = -1;  /* DL_non_GBR_PRB_usage_for_MIMO */
static int hf_xnap_ul_non_GBR_PRB_usage_for_MIMO = -1;  /* UL_non_GBR_PRB_usage_for_MIMO */
static int hf_xnap_dl_Total_PRB_usage_for_MIMO = -1;  /* DL_Total_PRB_usage_for_MIMO */
static int hf_xnap_ul_Total_PRB_usage_for_MIMO = -1;  /* UL_Total_PRB_usage_for_MIMO */
static int hf_xnap_handoverTriggerChangeLowerLimit = -1;  /* INTEGER_M20_20 */
static int hf_xnap_handoverTriggerChangeUpperLimit = -1;  /* INTEGER_M20_20 */
static int hf_xnap_handoverTriggerChange = -1;    /* INTEGER_M20_20 */
static int hf_xnap_serving_PLMN = -1;             /* PLMN_Identity */
static int hf_xnap_equivalent_PLMNs = -1;         /* SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity */
static int hf_xnap_equivalent_PLMNs_item = -1;    /* PLMN_Identity */
static int hf_xnap_rat_Restrictions = -1;         /* RAT_RestrictionsList */
static int hf_xnap_forbiddenAreaInformation = -1;  /* ForbiddenAreaList */
static int hf_xnap_serviceAreaInformation = -1;   /* ServiceAreaList */
static int hf_xnap_CNTypeRestrictionsForEquivalent_item = -1;  /* CNTypeRestrictionsForEquivalentItem */
static int hf_xnap_plmn_Identity = -1;            /* PLMN_Identity */
static int hf_xnap_cn_Type = -1;                  /* T_cn_Type */
static int hf_xnap_RAT_RestrictionsList_item = -1;  /* RAT_RestrictionsItem */
static int hf_xnap_rat_RestrictionInformation = -1;  /* RAT_RestrictionInformation */
static int hf_xnap_ForbiddenAreaList_item = -1;   /* ForbiddenAreaItem */
static int hf_xnap_forbidden_TACs = -1;           /* SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC */
static int hf_xnap_forbidden_TACs_item = -1;      /* TAC */
static int hf_xnap_ServiceAreaList_item = -1;     /* ServiceAreaItem */
static int hf_xnap_allowed_TACs_ServiceArea = -1;  /* SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC */
static int hf_xnap_allowed_TACs_ServiceArea_item = -1;  /* TAC */
static int hf_xnap_not_allowed_TACs_ServiceArea = -1;  /* SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC */
static int hf_xnap_not_allowed_TACs_ServiceArea_item = -1;  /* TAC */
static int hf_xnap_ng_RAN_Node_ResourceCoordinationInfo = -1;  /* NG_RAN_Node_ResourceCoordinationInfo */
static int hf_xnap_eutra_resource_coordination_info = -1;  /* E_UTRA_ResourceCoordinationInfo */
static int hf_xnap_nr_resource_coordination_info = -1;  /* NR_ResourceCoordinationInfo */
static int hf_xnap_e_utra_cell = -1;              /* E_UTRA_CGI */
static int hf_xnap_ul_coordination_info = -1;     /* BIT_STRING_SIZE_6_4400 */
static int hf_xnap_dl_coordination_info = -1;     /* BIT_STRING_SIZE_6_4400 */
static int hf_xnap_nr_cell = -1;                  /* NR_CGI */
static int hf_xnap_e_utra_coordination_assistance_info = -1;  /* E_UTRA_CoordinationAssistanceInfo */
static int hf_xnap_nr_coordination_assistance_info = -1;  /* NR_CoordinationAssistanceInfo */
static int hf_xnap_iAB_MT_Cell_List = -1;         /* IAB_MT_Cell_List */
static int hf_xnap_NACellResourceConfigurationList_item = -1;  /* NACellResourceConfiguration_Item */
static int hf_xnap_nAdownlin = -1;                /* T_nAdownlin */
static int hf_xnap_nAuplink = -1;                 /* T_nAuplink */
static int hf_xnap_nAflexible = -1;               /* T_nAflexible */
static int hf_xnap_subframeAssignment = -1;       /* T_subframeAssignment */
static int hf_xnap_harqOffset = -1;               /* INTEGER_0_9 */
static int hf_xnap_NeighbourInformation_E_UTRA_item = -1;  /* NeighbourInformation_E_UTRA_Item */
static int hf_xnap_e_utra_PCI = -1;               /* E_UTRAPCI */
static int hf_xnap_e_utra_cgi = -1;               /* E_UTRA_CGI */
static int hf_xnap_earfcn = -1;                   /* E_UTRAARFCN */
static int hf_xnap_NeighbourInformation_NR_item = -1;  /* NeighbourInformation_NR_Item */
static int hf_xnap_nr_PCI = -1;                   /* NRPCI */
static int hf_xnap_nr_mode_info = -1;             /* NeighbourInformation_NR_ModeInfo */
static int hf_xnap_connectivitySupport = -1;      /* Connectivity_Support */
static int hf_xnap_measurementTimingConfiguration = -1;  /* T_measurementTimingConfiguration */
static int hf_xnap_fdd_info = -1;                 /* NeighbourInformation_NR_ModeFDDInfo */
static int hf_xnap_tdd_info = -1;                 /* NeighbourInformation_NR_ModeTDDInfo */
static int hf_xnap_ul_NR_FreqInfo = -1;           /* NRFrequencyInfo */
static int hf_xnap_dl_NR_FequInfo = -1;           /* NRFrequencyInfo */
static int hf_xnap_ie_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_xnap_nr_FreqInfo = -1;              /* NRFrequencyInfo */
static int hf_xnap_Neighbour_NG_RAN_Node_List_item = -1;  /* Neighbour_NG_RAN_Node_Item */
static int hf_xnap_globalNG_RANNodeID = -1;       /* GlobalNG_RANNode_ID */
static int hf_xnap_local_NG_RAN_Node_Identifier = -1;  /* Local_NG_RAN_Node_Identifier */
static int hf_xnap_NRCarrierList_item = -1;       /* NRCarrierItem */
static int hf_xnap_carrierSCS = -1;               /* NRSCS */
static int hf_xnap_offsetToCarrier = -1;          /* INTEGER_0_2199_ */
static int hf_xnap_carrierBandwidth = -1;         /* INTEGER_0_maxnoofPhysicalResourceBlocks_ */
static int hf_xnap_nr = -1;                       /* NR_Cell_Identity */
static int hf_xnap_e_utra = -1;                   /* E_UTRA_Cell_Identity */
static int hf_xnap_nr_01 = -1;                    /* NRPCI */
static int hf_xnap_e_utra_01 = -1;                /* E_UTRAPCI */
static int hf_xnap_NG_RANnode2SSBOffsetsModificationRange_item = -1;  /* SSBOffsetModificationRange */
static int hf_xnap_dL_GBR_PRB_usage = -1;         /* DL_GBR_PRB_usage */
static int hf_xnap_uL_GBR_PRB_usage = -1;         /* UL_GBR_PRB_usage */
static int hf_xnap_dL_non_GBR_PRB_usage = -1;     /* DL_non_GBR_PRB_usage */
static int hf_xnap_uL_non_GBR_PRB_usage = -1;     /* UL_non_GBR_PRB_usage */
static int hf_xnap_dL_Total_PRB_usage = -1;       /* DL_Total_PRB_usage */
static int hf_xnap_uL_Total_PRB_usage = -1;       /* UL_Total_PRB_usage */
static int hf_xnap_dLTNLOfferedCapacity = -1;     /* OfferedCapacity */
static int hf_xnap_dLTNLAvailableCapacity = -1;   /* AvailableCapacity */
static int hf_xnap_uLTNLOfferedCapacity = -1;     /* OfferedCapacity */
static int hf_xnap_uLTNLAvailableCapacity = -1;   /* AvailableCapacity */
static int hf_xnap_nonF1TerminatingBHInformation_List = -1;  /* NonF1TerminatingBHInformation_List */
static int hf_xnap_bAPControlPDURLCCH_List = -1;  /* BAPControlPDURLCCH_List */
static int hf_xnap_NonF1TerminatingBHInformation_List_item = -1;  /* NonF1TerminatingBHInformation_Item */
static int hf_xnap_dlNon_F1TerminatingBHInfo = -1;  /* DLNonF1Terminating_BHInfo */
static int hf_xnap_ulNon_F1TerminatingBHInfo = -1;  /* ULNonF1Terminating_BHInfo */
static int hf_xnap_nonUPTrafficType = -1;         /* NonUPTrafficType */
static int hf_xnap_controlPlaneTrafficType = -1;  /* ControlPlaneTrafficType */
static int hf_xnap_snpn_Information = -1;         /* NPN_Broadcast_Information_SNPN */
static int hf_xnap_pni_npn_Information = -1;      /* NPN_Broadcast_Information_PNI_NPN */
static int hf_xnap_broadcastSNPNID_List = -1;     /* BroadcastSNPNID_List */
static int hf_xnap_broadcastPNI_NPN_ID_Information = -1;  /* BroadcastPNI_NPN_ID_Information */
static int hf_xnap_snpn_mobility_information = -1;  /* NPNMobilityInformation_SNPN */
static int hf_xnap_pni_npn_mobility_information = -1;  /* NPNMobilityInformation_PNI_NPN */
static int hf_xnap_serving_NID = -1;              /* NID */
static int hf_xnap_allowedPNI_NPN_ID_List = -1;   /* AllowedPNI_NPN_ID_List */
static int hf_xnap_pni_npn_Information_01 = -1;   /* NPNPagingAssistanceInformation_PNI_NPN */
static int hf_xnap_sNPN = -1;                     /* NPN_Support_SNPN */
static int hf_xnap_ie_Extension = -1;             /* ProtocolExtensionContainer */
static int hf_xnap_fdd_or_tdd = -1;               /* T_fdd_or_tdd */
static int hf_xnap_fdd = -1;                      /* NPRACHConfiguration_FDD */
static int hf_xnap_tdd = -1;                      /* NPRACHConfiguration_TDD */
static int hf_xnap_nprach_CP_length = -1;         /* NPRACH_CP_Length */
static int hf_xnap_anchorCarrier_NPRACHConfig = -1;  /* T_anchorCarrier_NPRACHConfig */
static int hf_xnap_anchorCarrier_EDT_NPRACHConfig = -1;  /* T_anchorCarrier_EDT_NPRACHConfig */
static int hf_xnap_anchorCarrier_Format2_NPRACHConfig = -1;  /* T_anchorCarrier_Format2_NPRACHConfig */
static int hf_xnap_anchorCarrier_Format2_EDT_NPRACHConfig = -1;  /* T_anchorCarrier_Format2_EDT_NPRACHConfig */
static int hf_xnap_non_anchorCarrier_NPRACHConfig = -1;  /* T_non_anchorCarrier_NPRACHConfig */
static int hf_xnap_non_anchorCarrier_Format2_NPRACHConfig = -1;  /* T_non_anchorCarrier_Format2_NPRACHConfig */
static int hf_xnap_nprach_preambleFormat = -1;    /* NPRACH_preambleFormat */
static int hf_xnap_anchorCarrier_NPRACHConfigTDD = -1;  /* T_anchorCarrier_NPRACHConfigTDD */
static int hf_xnap_non_anchorCarrierFequencyConfiglist = -1;  /* Non_AnchorCarrierFrequencylist */
static int hf_xnap_non_anchorCarrier_NPRACHConfigTDD = -1;  /* T_non_anchorCarrier_NPRACHConfigTDD */
static int hf_xnap_Non_AnchorCarrierFrequencylist_item = -1;  /* Non_AnchorCarrierFrequencylist_item */
static int hf_xnap_non_anchorCarrierFrquency = -1;  /* T_non_anchorCarrierFrquency */
static int hf_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea_item = -1;  /* NG_RAN_Cell_Identity */
static int hf_xnap_NR_U_Channel_List_item = -1;   /* NR_U_Channel_Item */
static int hf_xnap_nR_U_ChannelID = -1;           /* NR_U_ChannelID */
static int hf_xnap_channelOccupancyTimePercentageDL = -1;  /* ChannelOccupancyTimePercentage */
static int hf_xnap_energyDetectionThreshold = -1;  /* EnergyDetectionThreshold */
static int hf_xnap_NR_U_ChannelInfo_List_item = -1;  /* NR_U_ChannelInfo_Item */
static int hf_xnap_nRARFCN = -1;                  /* NRARFCN */
static int hf_xnap_bandwidth = -1;                /* Bandwidth */
static int hf_xnap_NRFrequencyBand_List_item = -1;  /* NRFrequencyBandItem */
static int hf_xnap_nr_frequency_band = -1;        /* NRFrequencyBand */
static int hf_xnap_supported_SUL_Band_List = -1;  /* SupportedSULBandList */
static int hf_xnap_nrARFCN = -1;                  /* NRARFCN */
static int hf_xnap_sul_information = -1;          /* SUL_Information */
static int hf_xnap_frequencyBand_List = -1;       /* NRFrequencyBand_List */
static int hf_xnap_fdd_01 = -1;                   /* NRModeInfoFDD */
static int hf_xnap_tdd_01 = -1;                   /* NRModeInfoTDD */
static int hf_xnap_ulNRFrequencyInfo = -1;        /* NRFrequencyInfo */
static int hf_xnap_dlNRFrequencyInfo = -1;        /* NRFrequencyInfo */
static int hf_xnap_ulNRTransmissonBandwidth = -1;  /* NRTransmissionBandwidth */
static int hf_xnap_dlNRTransmissonBandwidth = -1;  /* NRTransmissionBandwidth */
static int hf_xnap_nrTransmissonBandwidth = -1;   /* NRTransmissionBandwidth */
static int hf_xnap_nRPaging_eDRX_Cycle = -1;      /* NRPaging_eDRX_Cycle */
static int hf_xnap_nRPaging_Time_Window = -1;     /* NRPaging_Time_Window */
static int hf_xnap_nRPaging_eDRX_Cycle_Inactive = -1;  /* NRPaging_eDRX_Cycle_Inactive */
static int hf_xnap_nRSCS = -1;                    /* NRSCS */
static int hf_xnap_nRNRB = -1;                    /* NRNRB */
static int hf_xnap_requestedSRSTransmissionCharacteristics = -1;  /* RequestedSRSTransmissionCharacteristics */
static int hf_xnap_routingID = -1;                /* RoutingID */
static int hf_xnap_nRPPaTransactionID = -1;       /* INTEGER_0_32767 */
static int hf_xnap_pER_Scalar = -1;               /* PER_Scalar */
static int hf_xnap_pER_Exponent = -1;             /* PER_Exponent */
static int hf_xnap_cNsubgroupID = -1;             /* CNsubgroupID */
static int hf_xnap_pc5QoSFlowList = -1;           /* PC5QoSFlowList */
static int hf_xnap_pc5LinkAggregateBitRates = -1;  /* BitRate */
static int hf_xnap_PC5QoSFlowList_item = -1;      /* PC5QoSFlowItem */
static int hf_xnap_pQI = -1;                      /* FiveQI */
static int hf_xnap_pc5FlowBitRates = -1;          /* PC5FlowBitRates */
static int hf_xnap_range = -1;                    /* Range */
static int hf_xnap_guaranteedFlowBitRate = -1;    /* BitRate */
static int hf_xnap_maximumFlowBitRate = -1;       /* BitRate */
static int hf_xnap_from_S_NG_RAN_node = -1;       /* T_from_S_NG_RAN_node */
static int hf_xnap_from_M_NG_RAN_node = -1;       /* T_from_M_NG_RAN_node */
static int hf_xnap_ulPDCPSNLength = -1;           /* T_ulPDCPSNLength */
static int hf_xnap_dlPDCPSNLength = -1;           /* T_dlPDCPSNLength */
static int hf_xnap_downlink_session_AMBR = -1;    /* BitRate */
static int hf_xnap_uplink_session_AMBR = -1;      /* BitRate */
static int hf_xnap_PDUSession_List_item = -1;     /* PDUSession_ID */
static int hf_xnap_PDUSession_List_withCause_item = -1;  /* PDUSession_List_withCause_Item */
static int hf_xnap_pduSessionId = -1;             /* PDUSession_ID */
static int hf_xnap_PDUSession_List_withDataForwardingFromTarget_item = -1;  /* PDUSession_List_withDataForwardingFromTarget_Item */
static int hf_xnap_dataforwardinginfoTarget = -1;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_PDUSession_List_withDataForwardingRequest_item = -1;  /* PDUSession_List_withDataForwardingRequest_Item */
static int hf_xnap_dataforwardingInfofromSource = -1;  /* DataforwardingandOffloadingInfofromSource */
static int hf_xnap_dRBtoBeReleasedList = -1;      /* DRBToQoSFlowMapping_List */
static int hf_xnap_PDUSessionResourcesAdmitted_List_item = -1;  /* PDUSessionResourcesAdmitted_Item */
static int hf_xnap_pduSessionResourceAdmittedInfo = -1;  /* PDUSessionResourceAdmittedInfo */
static int hf_xnap_dL_NG_U_TNL_Information_Unchanged = -1;  /* T_dL_NG_U_TNL_Information_Unchanged */
static int hf_xnap_qosFlowsAdmitted_List = -1;    /* QoSFlowsAdmitted_List */
static int hf_xnap_qosFlowsNotAdmitted_List = -1;  /* QoSFlows_List_withCause */
static int hf_xnap_dataForwardingInfoFromTarget = -1;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_PDUSessionResourcesNotAdmitted_List_item = -1;  /* PDUSessionResourcesNotAdmitted_Item */
static int hf_xnap_PDUSessionResourcesToBeSetup_List_item = -1;  /* PDUSessionResourcesToBeSetup_Item */
static int hf_xnap_s_NSSAI = -1;                  /* S_NSSAI */
static int hf_xnap_pduSessionAMBR = -1;           /* PDUSessionAggregateMaximumBitRate */
static int hf_xnap_uL_NG_U_TNLatUPF = -1;         /* UPTransportLayerInformation */
static int hf_xnap_source_DL_NG_U_TNL_Information = -1;  /* UPTransportLayerInformation */
static int hf_xnap_securityIndication = -1;       /* SecurityIndication */
static int hf_xnap_pduSessionType = -1;           /* PDUSessionType */
static int hf_xnap_pduSessionNetworkInstance = -1;  /* PDUSessionNetworkInstance */
static int hf_xnap_qosFlowsToBeSetup_List = -1;   /* QoSFlowsToBeSetup_List */
static int hf_xnap_dataforwardinginfofromSource = -1;  /* DataforwardingandOffloadingInfofromSource */
static int hf_xnap_qosFlowsToBeSetup_List_01 = -1;  /* QoSFlowsToBeSetup_List_Setup_SNterminated */
static int hf_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_item = -1;  /* QoSFlowsToBeSetup_List_Setup_SNterminated_Item */
static int hf_xnap_qfi = -1;                      /* QoSFlowIdentifier */
static int hf_xnap_qosFlowLevelQoSParameters = -1;  /* QoSFlowLevelQoSParameters */
static int hf_xnap_offeredGBRQoSFlowInfo = -1;    /* GBRQoSFlowInfo */
static int hf_xnap_dL_NG_U_TNLatNG_RAN = -1;      /* UPTransportLayerInformation */
static int hf_xnap_dRBsToBeSetup = -1;            /* DRBsToBeSetupList_SetupResponse_SNterminated */
static int hf_xnap_qosFlowsNotAdmittedList = -1;  /* QoSFlows_List_withCause */
static int hf_xnap_securityResult = -1;           /* SecurityResult */
static int hf_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_item = -1;  /* DRBsToBeSetupList_SetupResponse_SNterminated_Item */
static int hf_xnap_sN_UL_PDCP_UP_TNLInfo = -1;    /* UPTransportParameters */
static int hf_xnap_dRB_QoS = -1;                  /* QoSFlowLevelQoSParameters */
static int hf_xnap_pDCP_SNLength = -1;            /* PDCPSNLength */
static int hf_xnap_uL_Configuration = -1;         /* ULConfiguration */
static int hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo = -1;  /* UPTransportParameters */
static int hf_xnap_duplicationActivation = -1;    /* DuplicationActivation */
static int hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated = -1;  /* QoSFlowsMappedtoDRB_SetupResponse_SNterminated */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_item = -1;  /* QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item */
static int hf_xnap_mCGRequestedGBRQoSFlowInfo = -1;  /* GBRQoSFlowInfo */
static int hf_xnap_qosFlowMappingIndication = -1;  /* QoSFlowMappingIndication */
static int hf_xnap_dRBsToBeSetup_01 = -1;         /* DRBsToBeSetupList_Setup_MNterminated */
static int hf_xnap_DRBsToBeSetupList_Setup_MNterminated_item = -1;  /* DRBsToBeSetupList_Setup_MNterminated_Item */
static int hf_xnap_mN_UL_PDCP_UP_TNLInfo = -1;    /* UPTransportParameters */
static int hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo = -1;  /* UPTransportParameters */
static int hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated = -1;  /* QoSFlowsMappedtoDRB_Setup_MNterminated */
static int hf_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_item = -1;  /* QoSFlowsMappedtoDRB_Setup_MNterminated_Item */
static int hf_xnap_dRBsAdmittedList = -1;         /* DRBsAdmittedList_SetupResponse_MNterminated */
static int hf_xnap_DRBsAdmittedList_SetupResponse_MNterminated_item = -1;  /* DRBsAdmittedList_SetupResponse_MNterminated_Item */
static int hf_xnap_sN_DL_SCG_UP_TNLInfo = -1;     /* UPTransportParameters */
static int hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo = -1;  /* UPTransportParameters */
static int hf_xnap_lCID = -1;                     /* LCID */
static int hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_item = -1;  /* QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item */
static int hf_xnap_currentQoSParaSetIndex = -1;   /* QoSParaSetIndex */
static int hf_xnap_qosFlowsToBeModified_List = -1;  /* QoSFlowsToBeSetup_List_Modified_SNterminated */
static int hf_xnap_qoSFlowsToBeReleased_List = -1;  /* QoSFlows_List_withCause */
static int hf_xnap_drbsToBeModifiedList = -1;     /* DRBsToBeModified_List_Modified_SNterminated */
static int hf_xnap_dRBsToBeReleased = -1;         /* DRB_List_withCause */
static int hf_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_item = -1;  /* QoSFlowsToBeSetup_List_Modified_SNterminated_Item */
static int hf_xnap_DRBsToBeModified_List_Modified_SNterminated_item = -1;  /* DRBsToBeModified_List_Modified_SNterminated_Item */
static int hf_xnap_mN_DL_SCG_UP_TNLInfo = -1;     /* UPTransportParameters */
static int hf_xnap_secondary_MN_DL_SCG_UP_TNLInfo = -1;  /* UPTransportParameters */
static int hf_xnap_rlc_status = -1;               /* RLC_Status */
static int hf_xnap_dRBsToBeModified = -1;         /* DRBsToBeModifiedList_ModificationResponse_SNterminated */
static int hf_xnap_qosFlowsNotAdmittedTBAdded = -1;  /* QoSFlows_List_withCause */
static int hf_xnap_qosFlowsReleased = -1;         /* QoSFlows_List_withCause */
static int hf_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_item = -1;  /* DRBsToBeModifiedList_ModificationResponse_SNterminated_Item */
static int hf_xnap_dRBsToBeModified_01 = -1;      /* DRBsToBeModifiedList_Modification_MNterminated */
static int hf_xnap_DRBsToBeModifiedList_Modification_MNterminated_item = -1;  /* DRBsToBeModifiedList_Modification_MNterminated_Item */
static int hf_xnap_pdcpDuplicationConfiguration = -1;  /* PDCPDuplicationConfiguration */
static int hf_xnap_dRBsAdmittedList_01 = -1;      /* DRBsAdmittedList_ModificationResponse_MNterminated */
static int hf_xnap_dRBsReleasedList = -1;         /* DRB_List */
static int hf_xnap_dRBsNotAdmittedSetupModifyList = -1;  /* DRB_List_withCause */
static int hf_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_item = -1;  /* DRBsAdmittedList_ModificationResponse_MNterminated_Item */
static int hf_xnap_drbsToBeSetupList = -1;        /* DRBsToBeSetup_List_ModRqd_SNterminated */
static int hf_xnap_drbsToBeModifiedList_01 = -1;  /* DRBsToBeModified_List_ModRqd_SNterminated */
static int hf_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_item = -1;  /* DRBsToBeSetup_List_ModRqd_SNterminated_Item */
static int hf_xnap_sn_UL_PDCP_UPTNLinfo = -1;     /* UPTransportParameters */
static int hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated = -1;  /* QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated */
static int hf_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_item = -1;  /* QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item */
static int hf_xnap_DRBsToBeModified_List_ModRqd_SNterminated_item = -1;  /* DRBsToBeModified_List_ModRqd_SNterminated_Item */
static int hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated_01 = -1;  /* QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated */
static int hf_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_item = -1;  /* QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item */
static int hf_xnap_dRBsAdmittedList_02 = -1;      /* DRBsAdmittedList_ModConfirm_SNterminated */
static int hf_xnap_DRBsAdmittedList_ModConfirm_SNterminated_item = -1;  /* DRBsAdmittedList_ModConfirm_SNterminated_Item */
static int hf_xnap_mN_DL_CG_UP_TNLInfo = -1;      /* UPTransportParameters */
static int hf_xnap_secondary_MN_DL_CG_UP_TNLInfo = -1;  /* UPTransportParameters */
static int hf_xnap_dRBsToBeModified_02 = -1;      /* DRBsToBeModified_List_ModRqd_MNterminated */
static int hf_xnap_DRBsToBeModified_List_ModRqd_MNterminated_item = -1;  /* DRBsToBeModified_List_ModRqd_MNterminated_Item */
static int hf_xnap_sN_DL_SCG_UP_TNLInfo_01 = -1;  /* UPTransportLayerInformation */
static int hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo_01 = -1;  /* UPTransportLayerInformation */
static int hf_xnap_dRBsToBeSetupList = -1;        /* SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item */
static int hf_xnap_dRBsToBeSetupList_item = -1;   /* DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item */
static int hf_xnap_dRB_ID = -1;                   /* DRB_ID */
static int hf_xnap_mN_Xn_U_TNLInfoatM = -1;       /* UPTransportLayerInformation */
static int hf_xnap_PDUSessionResourceSecondaryRATUsageList_item = -1;  /* PDUSessionResourceSecondaryRATUsageItem */
static int hf_xnap_pDUSessionID = -1;             /* PDUSession_ID */
static int hf_xnap_secondaryRATUsageInformation = -1;  /* SecondaryRATUsageInformation */
static int hf_xnap_rATType = -1;                  /* T_rATType */
static int hf_xnap_pDUSessionTimedReportList = -1;  /* VolumeTimedReportList */
static int hf_xnap_plmnListforQMC = -1;           /* PLMNListforQMC */
static int hf_xnap_PLMNListforQMC_item = -1;      /* PLMN_Identity */
static int hf_xnap_PCIListForMDT_item = -1;       /* NRPCI */
static int hf_xnap_protectedResourceList = -1;    /* ProtectedE_UTRAResourceList */
static int hf_xnap_mbsfnControlRegionLength = -1;  /* MBSFNControlRegionLength */
static int hf_xnap_pDCCHRegionLength = -1;        /* INTEGER_1_3 */
static int hf_xnap_ProtectedE_UTRAResourceList_item = -1;  /* ProtectedE_UTRAResource_Item */
static int hf_xnap_resourceType = -1;             /* T_resourceType */
static int hf_xnap_intra_PRBProtectedResourceFootprint = -1;  /* BIT_STRING_SIZE_84_ */
static int hf_xnap_protectedFootprintFrequencyPattern = -1;  /* BIT_STRING_SIZE_6_110_ */
static int hf_xnap_protectedFootprintTimePattern = -1;  /* ProtectedE_UTRAFootprintTimePattern */
static int hf_xnap_protectedFootprintTimeperiodicity = -1;  /* INTEGER_1_320_ */
static int hf_xnap_protectedFootrpintStartTime = -1;  /* INTEGER_1_20_ */
static int hf_xnap_uEAppLayerMeasInfoList = -1;   /* UEAppLayerMeasInfoList */
static int hf_xnap_UEAppLayerMeasInfoList_item = -1;  /* UEAppLayerMeasInfo_Item */
static int hf_xnap_uEAppLayerMeasConfigInfo = -1;  /* UEAppLayerMeasConfigInfo */
static int hf_xnap_non_dynamic = -1;              /* NonDynamic5QIDescriptor */
static int hf_xnap_dynamic = -1;                  /* Dynamic5QIDescriptor */
static int hf_xnap_qos_characteristics = -1;      /* QoSCharacteristics */
static int hf_xnap_allocationAndRetentionPrio = -1;  /* AllocationandRetentionPriority */
static int hf_xnap_gBRQoSFlowInfo = -1;           /* GBRQoSFlowInfo */
static int hf_xnap_reflectiveQoS = -1;            /* ReflectiveQoSAttribute */
static int hf_xnap_additionalQoSflowInfo = -1;    /* T_additionalQoSflowInfo */
static int hf_xnap_QoSFlowNotificationControlIndicationInfo_item = -1;  /* QoSFlowNotify_Item */
static int hf_xnap_notificationInformation = -1;  /* T_notificationInformation */
static int hf_xnap_QoSFlows_List_item = -1;       /* QoSFlow_Item */
static int hf_xnap_QoSFlows_List_withCause_item = -1;  /* QoSFlowwithCause_Item */
static int hf_xnap_QoSFlowsAdmitted_List_item = -1;  /* QoSFlowsAdmitted_Item */
static int hf_xnap_QoSFlowsToBeSetup_List_item = -1;  /* QoSFlowsToBeSetup_Item */
static int hf_xnap_e_RAB_ID = -1;                 /* E_RAB_ID */
static int hf_xnap_QoSFlowsUsageReportList_item = -1;  /* QoSFlowsUsageReport_Item */
static int hf_xnap_rATType_01 = -1;               /* T_rATType_01 */
static int hf_xnap_qoSFlowsTimedReportList = -1;  /* VolumeTimedReportList */
static int hf_xnap_RACHReportInformation_item = -1;  /* RACHReportList_Item */
static int hf_xnap_rACHReport = -1;               /* RACHReportContainer */
static int hf_xnap_ng_eNB_RadioResourceStatus = -1;  /* NG_eNB_RadioResourceStatus */
static int hf_xnap_gNB_RadioResourceStatus = -1;  /* GNB_RadioResourceStatus */
static int hf_xnap_rANAC = -1;                    /* RANAC */
static int hf_xnap_RANAreaID_List_item = -1;      /* RANAreaID */
static int hf_xnap_rANPagingAreaChoice = -1;      /* RANPagingAreaChoice */
static int hf_xnap_cell_List = -1;                /* NG_RAN_Cell_Identity_ListinRANPagingArea */
static int hf_xnap_rANAreaID_List = -1;           /* RANAreaID_List */
static int hf_xnap_pagingAttemptCount = -1;       /* INTEGER_1_16_ */
static int hf_xnap_intendedNumberOfPagingAttempts = -1;  /* INTEGER_1_16_ */
static int hf_xnap_nextPagingAreaScope = -1;      /* T_nextPagingAreaScope */
static int hf_xnap_rBsetSize = -1;                /* T_rBsetSize */
static int hf_xnap_numberofRBSets = -1;           /* INTEGER_1_maxnoofRBsetsPerCell */
static int hf_xnap_rSN = -1;                      /* RSN */
static int hf_xnap_ReplacingCells_item = -1;      /* ReplacingCells_Item */
static int hf_xnap_periodical = -1;               /* Periodical */
static int hf_xnap_eventTriggered = -1;           /* EventTriggered */
static int hf_xnap_subframeType = -1;             /* T_subframeType */
static int hf_xnap_reservedSubframePattern_01 = -1;  /* BIT_STRING_SIZE_10_160 */
static int hf_xnap_fullReset = -1;                /* ResetRequestTypeInfo_Full */
static int hf_xnap_partialReset = -1;             /* ResetRequestTypeInfo_Partial */
static int hf_xnap_ue_contexts_ToBeReleasedList = -1;  /* ResetRequestPartialReleaseList */
static int hf_xnap_ResetRequestPartialReleaseList_item = -1;  /* ResetRequestPartialReleaseItem */
static int hf_xnap_ng_ran_node1UEXnAPID = -1;     /* NG_RANnodeUEXnAPID */
static int hf_xnap_ng_ran_node2UEXnAPID = -1;     /* NG_RANnodeUEXnAPID */
static int hf_xnap_fullReset_01 = -1;             /* ResetResponseTypeInfo_Full */
static int hf_xnap_partialReset_01 = -1;          /* ResetResponseTypeInfo_Partial */
static int hf_xnap_ue_contexts_AdmittedToBeReleasedList = -1;  /* ResetResponsePartialReleaseList */
static int hf_xnap_ResetResponsePartialReleaseList_item = -1;  /* ResetResponsePartialReleaseItem */
static int hf_xnap_reestablishment_Indication = -1;  /* Reestablishment_Indication */
static int hf_xnap_rLCDuplicationStateList = -1;  /* RLCDuplicationStateList */
static int hf_xnap_rLC_PrimaryIndicator = -1;     /* T_rLC_PrimaryIndicator */
static int hf_xnap_RLCDuplicationStateList_item = -1;  /* RLCDuplicationState_Item */
static int hf_xnap_duplicationState = -1;         /* T_duplicationState */
static int hf_xnap_noofRRCConnections = -1;       /* NoofRRCConnections */
static int hf_xnap_availableRRCConnectionCapacityValue = -1;  /* AvailableRRCConnectionCapacityValue */
static int hf_xnap_rRRCReestab_initiated_reporting = -1;  /* RRCReestab_Initiated_Reporting */
static int hf_xnap_rRCReestab_reporting_wo_UERLFReport = -1;  /* RRCReestab_Initiated_Reporting_wo_UERLFReport */
static int hf_xnap_rRCReestab_reporting_with_UERLFReport = -1;  /* RRCReestab_Initiated_Reporting_with_UERLFReport */
static int hf_xnap_failureCellPCI = -1;           /* NG_RAN_CellPCI */
static int hf_xnap_reestabCellCGI = -1;           /* GlobalNG_RANCell_ID */
static int hf_xnap_c_RNTI = -1;                   /* C_RNTI */
static int hf_xnap_shortMAC_I = -1;               /* MAC_I */
static int hf_xnap_uERLFReportContainer = -1;     /* UERLFReportContainer */
static int hf_xnap_rRRCSetup_Initiated_Reporting = -1;  /* RRCSetup_Initiated_Reporting */
static int hf_xnap_rRCSetup_reporting_with_UERLFReport = -1;  /* RRCSetup_Initiated_Reporting_with_UERLFReport */
static int hf_xnap_S_NSSAIListQoE_item = -1;      /* S_NSSAI */
static int hf_xnap_ng_ran_TraceID = -1;           /* NG_RANTraceID */
static int hf_xnap_secondarydataForwardingInfoFromTarget = -1;  /* DataForwardingInfoFromTargetNGRANnode */
static int hf_xnap_SecondarydataForwardingInfoFromTarget_List_item = -1;  /* SecondarydataForwardingInfoFromTarget_Item */
static int hf_xnap_sdtindicator = -1;             /* SDTIndicator */
static int hf_xnap_sdtAssistantInfo = -1;         /* SDTAssistantInfo */
static int hf_xnap_dRBsToBeSetup_02 = -1;         /* SDT_DRBsToBeSetupList */
static int hf_xnap_sRBsToBeSetup = -1;            /* SDT_SRBsToBeSetupList */
static int hf_xnap_SDT_DRBsToBeSetupList_item = -1;  /* SDT_DRBsToBeSetupList_Item */
static int hf_xnap_uL_TNLInfo = -1;               /* UPTransportLayerInformation */
static int hf_xnap_dRB_RLC_Bearer_Configuration = -1;  /* T_dRB_RLC_Bearer_Configuration */
static int hf_xnap_s_nssai = -1;                  /* S_NSSAI */
static int hf_xnap_flows_Mapped_To_DRB_List = -1;  /* Flows_Mapped_To_DRB_List */
static int hf_xnap_SDT_SRBsToBeSetupList_item = -1;  /* SDT_SRBsToBeSetupList_Item */
static int hf_xnap_srb_ID = -1;                   /* SRB_ID */
static int hf_xnap_sRB_RLC_Bearer_Configuration = -1;  /* T_sRB_RLC_Bearer_Configuration */
static int hf_xnap_SDTDataForwardingDRBList_item = -1;  /* SDTDataForwardingDRBList_Item */
static int hf_xnap_dL_TNLInfo = -1;               /* UPTransportLayerInformation */
static int hf_xnap_pDUSessionUsageReport = -1;    /* PDUSessionUsageReport */
static int hf_xnap_qosFlowsUsageReportList = -1;  /* QoSFlowsUsageReportList */
static int hf_xnap_integrityProtectionIndication = -1;  /* T_integrityProtectionIndication */
static int hf_xnap_confidentialityProtectionIndication = -1;  /* T_confidentialityProtectionIndication */
static int hf_xnap_maximumIPdatarate = -1;        /* MaximumIPdatarate */
static int hf_xnap_integrityProtectionResult = -1;  /* T_integrityProtectionResult */
static int hf_xnap_confidentialityProtectionResult = -1;  /* T_confidentialityProtectionResult */
static int hf_xnap_sensorMeasConfig = -1;         /* SensorMeasConfig */
static int hf_xnap_sensorMeasConfigNameList = -1;  /* SensorMeasConfigNameList */
static int hf_xnap_SensorMeasConfigNameList_item = -1;  /* SensorName */
static int hf_xnap_uncompensatedBarometricConfig = -1;  /* T_uncompensatedBarometricConfig */
static int hf_xnap_ueSpeedConfig = -1;            /* T_ueSpeedConfig */
static int hf_xnap_ueOrientationConfig = -1;      /* T_ueOrientationConfig */
static int hf_xnap_e_utra_pci = -1;               /* E_UTRAPCI */
static int hf_xnap_broadcastPLMNs_02 = -1;        /* SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN */
static int hf_xnap_broadcastPLMNs_item = -1;      /* ServedCellInformation_E_UTRA_perBPLMN */
static int hf_xnap_e_utra_mode_info = -1;         /* ServedCellInformation_E_UTRA_ModeInfo */
static int hf_xnap_numberofAntennaPorts = -1;     /* NumberOfAntennaPorts_E_UTRA */
static int hf_xnap_prach_configuration = -1;      /* E_UTRAPRACHConfiguration */
static int hf_xnap_mBSFNsubframeInfo = -1;        /* MBSFNSubframeInfo_E_UTRA */
static int hf_xnap_multibandInfo = -1;            /* E_UTRAMultibandInfoList */
static int hf_xnap_freqBandIndicatorPriority = -1;  /* T_freqBandIndicatorPriority */
static int hf_xnap_bandwidthReducedSI = -1;       /* T_bandwidthReducedSI */
static int hf_xnap_protectedE_UTRAResourceIndication = -1;  /* ProtectedE_UTRAResourceIndication */
static int hf_xnap_fdd_02 = -1;                   /* ServedCellInformation_E_UTRA_FDDInfo */
static int hf_xnap_tdd_02 = -1;                   /* ServedCellInformation_E_UTRA_TDDInfo */
static int hf_xnap_ul_earfcn = -1;                /* E_UTRAARFCN */
static int hf_xnap_dl_earfcn = -1;                /* E_UTRAARFCN */
static int hf_xnap_ul_e_utraTxBW = -1;            /* E_UTRATransmissionBandwidth */
static int hf_xnap_dl_e_utraTxBW = -1;            /* E_UTRATransmissionBandwidth */
static int hf_xnap_e_utraTxBW = -1;               /* E_UTRATransmissionBandwidth */
static int hf_xnap_subframeAssignmnet = -1;       /* T_subframeAssignmnet */
static int hf_xnap_specialSubframeInfo = -1;      /* SpecialSubframeInfo_E_UTRA */
static int hf_xnap_ServedCells_E_UTRA_item = -1;  /* ServedCells_E_UTRA_Item */
static int hf_xnap_served_cell_info_E_UTRA = -1;  /* ServedCellInformation_E_UTRA */
static int hf_xnap_neighbour_info_NR = -1;        /* NeighbourInformation_NR */
static int hf_xnap_neighbour_info_E_UTRA = -1;    /* NeighbourInformation_E_UTRA */
static int hf_xnap_served_Cells_ToAdd_E_UTRA = -1;  /* ServedCells_E_UTRA */
static int hf_xnap_served_Cells_ToModify_E_UTRA = -1;  /* ServedCells_ToModify_E_UTRA */
static int hf_xnap_served_Cells_ToDelete_E_UTRA = -1;  /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_served_Cells_ToDelete_E_UTRA_item = -1;  /* E_UTRA_CGI */
static int hf_xnap_ServedCells_ToModify_E_UTRA_item = -1;  /* ServedCells_ToModify_E_UTRA_Item */
static int hf_xnap_old_ECGI = -1;                 /* E_UTRA_CGI */
static int hf_xnap_deactivation_indication = -1;  /* T_deactivation_indication */
static int hf_xnap_nrPCI = -1;                    /* NRPCI */
static int hf_xnap_cellID = -1;                   /* NR_CGI */
static int hf_xnap_broadcastPLMN = -1;            /* BroadcastPLMNs */
static int hf_xnap_nrModeInfo = -1;               /* NRModeInfo */
static int hf_xnap_measurementTimingConfiguration_01 = -1;  /* T_measurementTimingConfiguration_01 */
static int hf_xnap_sFN_Time_Offset = -1;          /* BIT_STRING_SIZE_24 */
static int hf_xnap_ServedCells_NR_item = -1;      /* ServedCells_NR_Item */
static int hf_xnap_served_cell_info_NR = -1;      /* ServedCellInformation_NR */
static int hf_xnap_ServedCells_ToModify_NR_item = -1;  /* ServedCells_ToModify_NR_Item */
static int hf_xnap_old_NR_CGI = -1;               /* NR_CGI */
static int hf_xnap_deactivation_indication_01 = -1;  /* T_deactivation_indication_01 */
static int hf_xnap_ServedCellSpecificInfoReq_NR_item = -1;  /* ServedCellSpecificInfoReq_NR_Item */
static int hf_xnap_additionalMTCListRequestIndicator = -1;  /* T_additionalMTCListRequestIndicator */
static int hf_xnap_served_Cells_ToAdd_NR = -1;    /* ServedCells_NR */
static int hf_xnap_served_Cells_ToModify_NR = -1;  /* ServedCells_ToModify_NR */
static int hf_xnap_served_Cells_ToDelete_NR = -1;  /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_served_Cells_ToDelete_NR_item = -1;  /* NR_CGI */
static int hf_xnap_ul_onlySharing = -1;           /* SharedResourceType_UL_OnlySharing */
static int hf_xnap_ul_and_dl_Sharing = -1;        /* SharedResourceType_ULDL_Sharing */
static int hf_xnap_ul_resourceBitmap = -1;        /* DataTrafficResources */
static int hf_xnap_ul_resources = -1;             /* SharedResourceType_ULDL_Sharing_UL_Resources */
static int hf_xnap_dl_resources = -1;             /* SharedResourceType_ULDL_Sharing_DL_Resources */
static int hf_xnap_unchanged = -1;                /* NULL */
static int hf_xnap_changed = -1;                  /* SharedResourceType_ULDL_Sharing_UL_ResourcesChanged */
static int hf_xnap_changed_01 = -1;               /* SharedResourceType_ULDL_Sharing_DL_ResourcesChanged */
static int hf_xnap_dl_resourceBitmap = -1;        /* DataTrafficResources */
static int hf_xnap_SliceAvailableCapacity_item = -1;  /* SliceAvailableCapacity_Item */
static int hf_xnap_pLMNIdentity = -1;             /* PLMN_Identity */
static int hf_xnap_sNSSAIAvailableCapacity_List = -1;  /* SNSSAIAvailableCapacity_List */
static int hf_xnap_SNSSAIAvailableCapacity_List_item = -1;  /* SNSSAIAvailableCapacity_Item */
static int hf_xnap_sNSSAI = -1;                   /* S_NSSAI */
static int hf_xnap_sliceAvailableCapacityValueDownlink = -1;  /* INTEGER_0_100 */
static int hf_xnap_sliceAvailableCapacityValueUplink = -1;  /* INTEGER_0_100 */
static int hf_xnap_SliceRadioResourceStatus_List_item = -1;  /* SliceRadioResourceStatus_Item */
static int hf_xnap_sNSSAIRadioResourceStatus_List = -1;  /* SNSSAIRadioResourceStatus_List */
static int hf_xnap_SNSSAIRadioResourceStatus_List_item = -1;  /* SNSSAIRadioResourceStatus_Item */
static int hf_xnap_slice_DL_GBR_PRB_Usage = -1;   /* Slice_DL_GBR_PRB_Usage */
static int hf_xnap_slice_UL_GBR_PRB_Usage = -1;   /* Slice_UL_GBR_PRB_Usage */
static int hf_xnap_slice_DL_non_GBR_PRB_Usage = -1;  /* Slice_DL_non_GBR_PRB_Usage */
static int hf_xnap_slice_UL_non_GBR_PRB_Usage = -1;  /* Slice_UL_non_GBR_PRB_Usage */
static int hf_xnap_slice_DL_Total_PRB_Allocation = -1;  /* Slice_DL_Total_PRB_Allocation */
static int hf_xnap_slice_UL_Total_PRB_Allocation = -1;  /* Slice_UL_Total_PRB_Allocation */
static int hf_xnap_SliceSupport_List_item = -1;   /* S_NSSAI */
static int hf_xnap_SliceToReport_List_item = -1;  /* SliceToReport_List_Item */
static int hf_xnap_sNSSAIlist = -1;               /* SNSSAI_list */
static int hf_xnap_SNSSAI_list_item = -1;         /* SNSSAI_Item */
static int hf_xnap_SlotConfiguration_List_item = -1;  /* SlotConfiguration_List_Item */
static int hf_xnap_slotIndex_01 = -1;             /* INTEGER_0_5119 */
static int hf_xnap_symbolAllocation_in_Slot = -1;  /* SymbolAllocation_in_Slot */
static int hf_xnap_sst = -1;                      /* OCTET_STRING_SIZE_1 */
static int hf_xnap_sd = -1;                       /* OCTET_STRING_SIZE_3 */
static int hf_xnap_specialSubframePattern = -1;   /* SpecialSubframePatterns_E_UTRA */
static int hf_xnap_cyclicPrefixDL = -1;           /* CyclicPrefix_E_UTRA_DL */
static int hf_xnap_cyclicPrefixUL = -1;           /* CyclicPrefix_E_UTRA_UL */
static int hf_xnap_SSBAreaCapacityValue_List_item = -1;  /* SSBAreaCapacityValue_List_Item */
static int hf_xnap_sSBIndex = -1;                 /* INTEGER_0_63 */
static int hf_xnap_ssbAreaCapacityValue = -1;     /* INTEGER_0_100 */
static int hf_xnap_SSBAreaRadioResourceStatus_List_item = -1;  /* SSBAreaRadioResourceStatus_List_Item */
static int hf_xnap_ssb_Area_DL_GBR_PRB_usage = -1;  /* DL_GBR_PRB_usage */
static int hf_xnap_ssb_Area_UL_GBR_PRB_usage = -1;  /* UL_GBR_PRB_usage */
static int hf_xnap_ssb_Area_dL_non_GBR_PRB_usage = -1;  /* DL_non_GBR_PRB_usage */
static int hf_xnap_ssb_Area_uL_non_GBR_PRB_usage = -1;  /* UL_non_GBR_PRB_usage */
static int hf_xnap_ssb_Area_dL_Total_PRB_usage = -1;  /* DL_Total_PRB_usage */
static int hf_xnap_ssb_Area_uL_Total_PRB_usage = -1;  /* UL_Total_PRB_usage */
static int hf_xnap_SSB_Coverage_Modification_List_item = -1;  /* SSB_Coverage_Modification_List_Item */
static int hf_xnap_sSBCoverageState = -1;         /* INTEGER_0_15_ */
static int hf_xnap_shortBitmap = -1;              /* BIT_STRING_SIZE_4 */
static int hf_xnap_mediumBitmap = -1;             /* BIT_STRING_SIZE_8 */
static int hf_xnap_longBitmap = -1;               /* BIT_STRING_SIZE_64 */
static int hf_xnap_SSBOffsets_List_item = -1;     /* SSBOffsets_Item */
static int hf_xnap_nG_RANnode1SSBOffsets = -1;    /* SSBOffsetInformation */
static int hf_xnap_nG_RANnode2ProposedSSBOffsets = -1;  /* SSBOffsetInformation */
static int hf_xnap_sSBTriggeringOffset = -1;      /* MobilityParametersInformation */
static int hf_xnap_sSBobilityParametersModificationRange = -1;  /* MobilityParametersModificationRange */
static int hf_xnap_SSBToReport_List_item = -1;    /* SSBToReport_List_Item */
static int hf_xnap_SuccessfulHOReportInformation_item = -1;  /* SuccessfulHOReportList_Item */
static int hf_xnap_successfulHOReport = -1;       /* SuccessfulHOReportContainer */
static int hf_xnap_sulFrequencyInfo = -1;         /* NRARFCN */
static int hf_xnap_sulTransmissionBandwidth = -1;  /* NRTransmissionBandwidth */
static int hf_xnap_Supported_MBS_FSA_ID_List_item = -1;  /* MBS_FrequencySelectionArea_Identity */
static int hf_xnap_SupportedSULBandList_item = -1;  /* SupportedSULBandItem */
static int hf_xnap_sulBandItem = -1;              /* SUL_FrequencyBand */
static int hf_xnap_allDL = -1;                    /* SymbolAllocation_in_Slot_AllDL */
static int hf_xnap_allUL = -1;                    /* SymbolAllocation_in_Slot_AllUL */
static int hf_xnap_bothDLandUL = -1;              /* SymbolAllocation_in_Slot_BothDLandUL */
static int hf_xnap_numberofDLSymbols = -1;        /* INTEGER_0_13 */
static int hf_xnap_numberofULSymbols = -1;        /* INTEGER_0_13 */
static int hf_xnap_tAListforMDT = -1;             /* TAListforMDT */
static int hf_xnap_tAIListforMDT = -1;            /* TAIListforMDT */
static int hf_xnap_TAIListforMDT_item = -1;       /* TAIforMDT_Item */
static int hf_xnap_TAINSAGSupportList_item = -1;  /* TAINSAGSupportItem */
static int hf_xnap_nSAG_ID = -1;                  /* NSAG_ID */
static int hf_xnap_nSAGSliceSupportList = -1;     /* ExtendedSliceSupportList */
static int hf_xnap_TAISupport_List_item = -1;     /* TAISupport_Item */
static int hf_xnap_broadcastPLMNs_03 = -1;        /* SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item */
static int hf_xnap_broadcastPLMNs_item_01 = -1;   /* BroadcastPLMNinTAISupport_Item */
static int hf_xnap_TAListforMDT_item = -1;        /* TAC */
static int hf_xnap_tAListforQMC = -1;             /* TAListforQMC */
static int hf_xnap_TAListforQMC_item = -1;        /* TAC */
static int hf_xnap_tAIListforQMC = -1;            /* TAIListforQMC */
static int hf_xnap_TAIListforQMC_item = -1;       /* TAI_Item */
static int hf_xnap_nr_02 = -1;                    /* NR_CGI */
static int hf_xnap_e_utra_02 = -1;                /* E_UTRA_CGI */
static int hf_xnap_TargetCellList_item = -1;      /* TargetCellList_Item */
static int hf_xnap_target_cell = -1;              /* Target_CGI */
static int hf_xnap_timeDistributionIndication = -1;  /* T_timeDistributionIndication */
static int hf_xnap_uuTimeSynchronizationErrorBudget = -1;  /* INTEGER_0_1000000_ */
static int hf_xnap_extendedUPTransportLayerAddressesToAdd = -1;  /* ExtTLAs */
static int hf_xnap_extendedUPTransportLayerAddressesToRemove = -1;  /* ExtTLAs */
static int hf_xnap_TNLA_To_Add_List_item = -1;    /* TNLA_To_Add_Item */
static int hf_xnap_tNLAssociationTransportLayerAddress = -1;  /* CPTransportLayerInformation */
static int hf_xnap_tNLAssociationUsage = -1;      /* TNLAssociationUsage */
static int hf_xnap_TNLA_To_Update_List_item = -1;  /* TNLA_To_Update_Item */
static int hf_xnap_TNLA_To_Remove_List_item = -1;  /* TNLA_To_Remove_Item */
static int hf_xnap_TNLA_Setup_List_item = -1;     /* TNLA_Setup_Item */
static int hf_xnap_TNLA_Failed_To_Setup_List_item = -1;  /* TNLA_Failed_To_Setup_Item */
static int hf_xnap_interfaces_to_trace = -1;      /* T_interfaces_to_trace */
static int hf_xnap_trace_depth = -1;              /* Trace_Depth */
static int hf_xnap_trace_coll_address = -1;       /* TransportLayerAddress */
static int hf_xnap_uPTraffic = -1;                /* QoSFlowLevelQoSParameters */
static int hf_xnap_nonUPTraffic = -1;             /* NonUPTraffic */
static int hf_xnap_fullRelease = -1;              /* AllTrafficIndication */
static int hf_xnap_partialRelease = -1;           /* TrafficToBeRelease_List */
static int hf_xnap_releaseType = -1;              /* TrafficReleaseType */
static int hf_xnap_TrafficToBeRelease_List_item = -1;  /* TrafficToBeRelease_Item */
static int hf_xnap_trafficIndex = -1;             /* TrafficIndex */
static int hf_xnap_bHInfoList = -1;               /* BHInfoList */
static int hf_xnap_tSCAssistanceInformationDownlink = -1;  /* TSCAssistanceInformation */
static int hf_xnap_tSCAssistanceInformationUplink = -1;  /* TSCAssistanceInformation */
static int hf_xnap_periodicity = -1;              /* INTEGER_0_640000_ */
static int hf_xnap_burstArrivalTime = -1;         /* T_burstArrivalTime */
static int hf_xnap_dl_UE_AMBR = -1;               /* BitRate */
static int hf_xnap_ul_UE_AMBR = -1;               /* BitRate */
static int hf_xnap_qOEReference = -1;             /* QOEReference */
static int hf_xnap_qOEMeasConfigAppLayerID = -1;  /* QOEMeasConfAppLayerID */
static int hf_xnap_serviceType = -1;              /* ServiceType */
static int hf_xnap_qOEMeasStatus = -1;            /* QOEMeasStatus */
static int hf_xnap_containerAppLayerMeasConfig = -1;  /* ContainerAppLayerMeasConfig */
static int hf_xnap_mDTAlignmentInfo = -1;         /* MDTAlignmentInfo */
static int hf_xnap_measCollectionEntityIPAddress = -1;  /* MeasCollectionEntityIPAddress */
static int hf_xnap_areaScopeOfQMC = -1;           /* AreaScopeOfQMC */
static int hf_xnap_s_NSSAIListQoE = -1;           /* S_NSSAIListQoE */
static int hf_xnap_availableRVQoEMetrics = -1;    /* AvailableRVQoEMetrics */
static int hf_xnap_rRCResume = -1;                /* UEContextIDforRRCResume */
static int hf_xnap_rRRCReestablishment = -1;      /* UEContextIDforRRCReestablishment */
static int hf_xnap_i_rnti = -1;                   /* I_RNTI */
static int hf_xnap_allocated_c_rnti = -1;         /* C_RNTI */
static int hf_xnap_accessPCI = -1;                /* NG_RAN_CellPCI */
static int hf_xnap_c_rnti = -1;                   /* C_RNTI */
static int hf_xnap_ng_c_UE_signalling_ref = -1;   /* AMF_UE_NGAP_ID */
static int hf_xnap_signalling_TNL_at_source = -1;  /* CPTransportLayerInformation */
static int hf_xnap_ueSecurityCapabilities = -1;   /* UESecurityCapabilities */
static int hf_xnap_securityInformation = -1;      /* AS_SecurityInformation */
static int hf_xnap_ue_AMBR = -1;                  /* UEAggregateMaximumBitRate */
static int hf_xnap_pduSessionResourcesToBeSetup_List = -1;  /* PDUSessionResourcesToBeSetup_List */
static int hf_xnap_rrc_Context = -1;              /* T_rrc_Context */
static int hf_xnap_mobilityRestrictionList = -1;  /* MobilityRestrictionList */
static int hf_xnap_indexToRatFrequencySelectionPriority = -1;  /* RFSP_Index */
static int hf_xnap_UEHistoryInformation_item = -1;  /* LastVisitedCell_Item */
static int hf_xnap_nR = -1;                       /* NRMobilityHistoryReport */
static int hf_xnap_indexLength10 = -1;            /* BIT_STRING_SIZE_10 */
static int hf_xnap_UEIdentityIndexList_MBSGroupPaging_item = -1;  /* UEIdentityIndexList_MBSGroupPaging_Item */
static int hf_xnap_ueIdentityIndexList_MBSGroupPagingValue = -1;  /* UEIdentityIndexList_MBSGroupPagingValue */
static int hf_xnap_pagingDRX = -1;                /* UESpecificDRX */
static int hf_xnap_uEIdentityIndexValueMBSGroupPaging = -1;  /* BIT_STRING_SIZE_10 */
static int hf_xnap_uERadioCapabilityForPagingOfNR = -1;  /* UERadioCapabilityForPagingOfNR */
static int hf_xnap_uERadioCapabilityForPagingOfEUTRA = -1;  /* UERadioCapabilityForPagingOfEUTRA */
static int hf_xnap_nR_UERLFReportContainer = -1;  /* UERLFReportContainerNR */
static int hf_xnap_lTE_UERLFReportContainer = -1;  /* UERLFReportContainerLTE */
static int hf_xnap_choice_Extension = -1;         /* ProtocolIE_Single_Container */
static int hf_xnap_ueRLFReportContainerLTE = -1;  /* UERLFReportContainerLTE */
static int hf_xnap_ueRLFReportContainerLTEExtendBand = -1;  /* UERLFReportContainerLTEExtendBand */
static int hf_xnap_UESliceMaximumBitRateList_item = -1;  /* UESliceMaximumBitRate_Item */
static int hf_xnap_dl_UE_Slice_MBR = -1;          /* BitRate */
static int hf_xnap_ul_UE_Slice_MBR = -1;          /* BitRate */
static int hf_xnap_nr_EncyptionAlgorithms = -1;   /* T_nr_EncyptionAlgorithms */
static int hf_xnap_nr_IntegrityProtectionAlgorithms = -1;  /* T_nr_IntegrityProtectionAlgorithms */
static int hf_xnap_e_utra_EncyptionAlgorithms = -1;  /* T_e_utra_EncyptionAlgorithms */
static int hf_xnap_e_utra_IntegrityProtectionAlgorithms = -1;  /* T_e_utra_IntegrityProtectionAlgorithms */
static int hf_xnap_uL_PDCP = -1;                  /* UL_UE_Configuration */
static int hf_xnap_gtpTunnel = -1;                /* GTPtunnelTransportLayerInformation */
static int hf_xnap_UPTransportParameters_item = -1;  /* UPTransportParametersItem */
static int hf_xnap_upTNLInfo = -1;                /* UPTransportLayerInformation */
static int hf_xnap_cellGroupID = -1;              /* CellGroupID */
static int hf_xnap_VolumeTimedReportList_item = -1;  /* VolumeTimedReport_Item */
static int hf_xnap_startTimeStamp = -1;           /* T_startTimeStamp */
static int hf_xnap_endTimeStamp = -1;             /* T_endTimeStamp */
static int hf_xnap_usageCountUL = -1;             /* INTEGER_0_18446744073709551615 */
static int hf_xnap_usageCountDL = -1;             /* INTEGER_0_18446744073709551615 */
static int hf_xnap_wlanMeasConfig = -1;           /* WLANMeasConfig */
static int hf_xnap_wlanMeasConfigNameList = -1;   /* WLANMeasConfigNameList */
static int hf_xnap_wlan_rssi = -1;                /* T_wlan_rssi */
static int hf_xnap_wlan_rtt = -1;                 /* T_wlan_rtt */
static int hf_xnap_WLANMeasConfigNameList_item = -1;  /* WLANName */
static int hf_xnap_protocolIEs = -1;              /* ProtocolIE_Container */
static int hf_xnap_ng_c_UE_reference = -1;        /* AMF_UE_NGAP_ID */
static int hf_xnap_cp_TNL_info_source = -1;       /* CPTransportLayerInformation */
static int hf_xnap_rrc_Context_01 = -1;           /* T_rrc_Context_01 */
static int hf_xnap_locationReportingInformation = -1;  /* LocationReportingInformation */
static int hf_xnap_mrl = -1;                      /* MobilityRestrictionList */
static int hf_xnap_globalNG_RANNode_ID = -1;      /* GlobalNG_RANNode_ID */
static int hf_xnap_sN_NG_RANnodeUEXnAPID = -1;    /* NG_RANnodeUEXnAPID */
static int hf_xnap_first_dl_count = -1;           /* FirstDLCount */
static int hf_xnap_dl_discarding = -1;            /* DLDiscarding */
static int hf_xnap_dRBsSubjectToEarlyStatusTransfer = -1;  /* DRBsSubjectToEarlyStatusTransfer_List */
static int hf_xnap_dRBsSubjectToDLDiscarding = -1;  /* DRBsSubjectToDLDiscarding_List */
static int hf_xnap_PDUSessionToBeAddedAddReq_item = -1;  /* PDUSessionToBeAddedAddReq_Item */
static int hf_xnap_sN_PDUSessionAMBR = -1;        /* PDUSessionAggregateMaximumBitRate */
static int hf_xnap_sn_terminated = -1;            /* PDUSessionResourceSetupInfo_SNterminated */
static int hf_xnap_mn_terminated = -1;            /* PDUSessionResourceSetupInfo_MNterminated */
static int hf_xnap_PDUSessionAdmittedAddedAddReqAck_item = -1;  /* PDUSessionAdmittedAddedAddReqAck_Item */
static int hf_xnap_sn_terminated_01 = -1;         /* PDUSessionResourceSetupResponseInfo_SNterminated */
static int hf_xnap_mn_terminated_01 = -1;         /* PDUSessionResourceSetupResponseInfo_MNterminated */
static int hf_xnap_pduSessionResourcesNotAdmitted_SNterminated = -1;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_pduSessionResourcesNotAdmitted_MNterminated = -1;  /* PDUSessionResourcesNotAdmitted_List */
static int hf_xnap_responseType_ReconfComplete = -1;  /* ResponseType_ReconfComplete */
static int hf_xnap_configuration_successfully_applied = -1;  /* Configuration_successfully_applied */
static int hf_xnap_configuration_rejected_by_M_NG_RANNode = -1;  /* Configuration_rejected_by_M_NG_RANNode */
static int hf_xnap_m_NG_RANNode_to_S_NG_RANNode_Container = -1;  /* T_m_NG_RANNode_to_S_NG_RANNode_Container */
static int hf_xnap_m_NG_RANNode_to_S_NG_RANNode_Container_01 = -1;  /* T_m_NG_RANNode_to_S_NG_RANNode_Container_01 */
static int hf_xnap_s_ng_RANnode_SecurityKey = -1;  /* S_NG_RANnode_SecurityKey */
static int hf_xnap_s_ng_RANnodeUE_AMBR = -1;      /* UEAggregateMaximumBitRate */
static int hf_xnap_lowerLayerPresenceStatusChange = -1;  /* LowerLayerPresenceStatusChange */
static int hf_xnap_pduSessionResourceToBeAdded = -1;  /* PDUSessionsToBeAdded_SNModRequest_List */
static int hf_xnap_pduSessionResourceToBeModified = -1;  /* PDUSessionsToBeModified_SNModRequest_List */
static int hf_xnap_pduSessionResourceToBeReleased = -1;  /* PDUSessionsToBeReleased_SNModRequest_List */
static int hf_xnap_PDUSessionsToBeAdded_SNModRequest_List_item = -1;  /* PDUSessionsToBeAdded_SNModRequest_Item */
static int hf_xnap_PDUSessionsToBeModified_SNModRequest_List_item = -1;  /* PDUSessionsToBeModified_SNModRequest_Item */
static int hf_xnap_sn_terminated_02 = -1;         /* PDUSessionResourceModificationInfo_SNterminated */
static int hf_xnap_mn_terminated_02 = -1;         /* PDUSessionResourceModificationInfo_MNterminated */
static int hf_xnap_pdu_session_list = -1;         /* PDUSession_List_withCause */
static int hf_xnap_pduSessionResourcesAdmittedToBeAdded = -1;  /* PDUSessionAdmittedToBeAddedSNModResponse */
static int hf_xnap_pduSessionResourcesAdmittedToBeModified = -1;  /* PDUSessionAdmittedToBeModifiedSNModResponse */
static int hf_xnap_pduSessionResourcesAdmittedToBeReleased = -1;  /* PDUSessionAdmittedToBeReleasedSNModResponse */
static int hf_xnap_PDUSessionAdmittedToBeAddedSNModResponse_item = -1;  /* PDUSessionAdmittedToBeAddedSNModResponse_Item */
static int hf_xnap_PDUSessionAdmittedToBeModifiedSNModResponse_item = -1;  /* PDUSessionAdmittedToBeModifiedSNModResponse_Item */
static int hf_xnap_sn_terminated_03 = -1;         /* PDUSessionResourceModificationResponseInfo_SNterminated */
static int hf_xnap_mn_terminated_03 = -1;         /* PDUSessionResourceModificationResponseInfo_MNterminated */
static int hf_xnap_sn_terminated_04 = -1;         /* PDUSession_List_withDataForwardingRequest */
static int hf_xnap_mn_terminated_04 = -1;         /* PDUSession_List_withCause */
static int hf_xnap_pdu_Session_List = -1;         /* PDUSession_List */
static int hf_xnap_PDUSessionToBeModifiedSNModRequired_item = -1;  /* PDUSessionToBeModifiedSNModRequired_Item */
static int hf_xnap_sn_terminated_05 = -1;         /* PDUSessionResourceModRqdInfo_SNterminated */
static int hf_xnap_mn_terminated_05 = -1;         /* PDUSessionResourceModRqdInfo_MNterminated */
static int hf_xnap_PDUSessionAdmittedModSNModConfirm_item = -1;  /* PDUSessionAdmittedModSNModConfirm_Item */
static int hf_xnap_sn_terminated_06 = -1;         /* PDUSessionResourceModConfirmInfo_SNterminated */
static int hf_xnap_mn_terminated_06 = -1;         /* PDUSessionResourceModConfirmInfo_MNterminated */
static int hf_xnap_sn_terminated_07 = -1;         /* PDUSession_List_withDataForwardingFromTarget */
static int hf_xnap_mn_terminated_07 = -1;         /* PDUSession_List */
static int hf_xnap_pduSessionsToBeReleasedList_SNterminated = -1;  /* PDUSession_List_withDataForwardingRequest */
static int hf_xnap_pduSessionsReleasedList_SNterminated = -1;  /* PDUSession_List_withDataForwardingFromTarget */
static int hf_xnap_BearersSubjectToCounterCheck_List_item = -1;  /* BearersSubjectToCounterCheck_Item */
static int hf_xnap_ul_count = -1;                 /* INTEGER_0_4294967295 */
static int hf_xnap_dl_count = -1;                 /* INTEGER_0_4294967295 */
static int hf_xnap_PDUSession_SNChangeRequired_List_item = -1;  /* PDUSession_SNChangeRequired_Item */
static int hf_xnap_sn_terminated_08 = -1;         /* PDUSessionResourceChangeRequiredInfo_SNterminated */
static int hf_xnap_mn_terminated_08 = -1;         /* PDUSessionResourceChangeRequiredInfo_MNterminated */
static int hf_xnap_PDUSession_SNChangeConfirm_List_item = -1;  /* PDUSession_SNChangeConfirm_Item */
static int hf_xnap_sn_terminated_09 = -1;         /* PDUSessionResourceChangeConfirmInfo_SNterminated */
static int hf_xnap_mn_terminated_09 = -1;         /* PDUSessionResourceChangeConfirmInfo_MNterminated */
static int hf_xnap_rrcContainer = -1;             /* OCTET_STRING */
static int hf_xnap_srbType = -1;                  /* T_srbType */
static int hf_xnap_deliveryStatus = -1;           /* DeliveryStatus */
static int hf_xnap_PDUSessionResourcesNotifyList_item = -1;  /* PDUSessionResourcesNotify_Item */
static int hf_xnap_qosFlowsNotificationContrIndInfo = -1;  /* QoSFlowNotificationControlIndicationInfo */
static int hf_xnap_PDUSessionResourcesActivityNotifyList_item = -1;  /* PDUSessionResourcesActivityNotify_Item */
static int hf_xnap_pduSessionLevelUPactivityreport = -1;  /* UserPlaneTrafficActivityReport */
static int hf_xnap_qosFlowsActivityNotifyList = -1;  /* QoSFlowsActivityNotifyList */
static int hf_xnap_QoSFlowsActivityNotifyList_item = -1;  /* QoSFlowsActivityNotifyItem */
static int hf_xnap_gNB_01 = -1;                   /* ProtocolIE_Container */
static int hf_xnap_ng_eNB_01 = -1;                /* ProtocolIE_Container */
static int hf_xnap_ng_eNB_02 = -1;                /* RespondingNodeTypeConfigUpdateAck_ng_eNB */
static int hf_xnap_gNB_02 = -1;                   /* RespondingNodeTypeConfigUpdateAck_gNB */
static int hf_xnap_served_NR_Cells = -1;          /* ServedCells_NR */
static int hf_xnap_ng_eNB_03 = -1;                /* ResourceCoordRequest_ng_eNB_initiated */
static int hf_xnap_gNB_03 = -1;                   /* ResourceCoordRequest_gNB_initiated */
static int hf_xnap_dataTrafficResourceIndication = -1;  /* DataTrafficResourceIndication */
static int hf_xnap_spectrumSharingGroupID = -1;   /* SpectrumSharingGroupID */
static int hf_xnap_listofE_UTRACells = -1;        /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_listofE_UTRACells_item = -1;   /* E_UTRA_CGI */
static int hf_xnap_listofNRCells = -1;            /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_listofNRCells_item = -1;       /* NR_CGI */
static int hf_xnap_ng_eNB_04 = -1;                /* ResourceCoordResponse_ng_eNB_initiated */
static int hf_xnap_gNB_04 = -1;                   /* ResourceCoordResponse_gNB_initiated */
static int hf_xnap_nr_cells = -1;                 /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI */
static int hf_xnap_nr_cells_item = -1;            /* NR_CGI */
static int hf_xnap_e_utra_cells = -1;             /* SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI */
static int hf_xnap_e_utra_cells_item = -1;        /* E_UTRA_CGI */
static int hf_xnap_privateIEs = -1;               /* PrivateIE_Container */
static int hf_xnap_TrafficToBeAddedList_item = -1;  /* TrafficToBeAdded_Item */
static int hf_xnap_trafficProfile = -1;           /* TrafficProfile */
static int hf_xnap_f1_TerminatingTopologyBHInformation = -1;  /* F1_TerminatingTopologyBHInformation */
static int hf_xnap_TrafficToBeModifiedList_item = -1;  /* TrafficToBeModified_Item */
static int hf_xnap_TrafficAddedList_item = -1;    /* TrafficAdded_Item */
static int hf_xnap_non_F1_TerminatingTopologyBHInformation = -1;  /* Non_F1_TerminatingTopologyBHInformation */
static int hf_xnap_TrafficModifiedList_item = -1;  /* TrafficModified_Item */
static int hf_xnap_TrafficNotAddedList_item = -1;  /* TrafficNotAdded_Item */
static int hf_xnap_casue = -1;                    /* Cause */
static int hf_xnap_TrafficNotModifiedList_item = -1;  /* TrafficNotModified_Item */
static int hf_xnap_TrafficReleasedList_item = -1;  /* TrafficReleased_Item */
static int hf_xnap_TrafficRequiredToBeModifiedList_item = -1;  /* TrafficRequiredToBeModified_Item */
static int hf_xnap_non_f1_TerminatingTopologyBHInformation = -1;  /* Non_F1_TerminatingTopologyBHInformation */
static int hf_xnap_IABTNLAddressToBeReleasedList_item = -1;  /* IABTNLAddressToBeReleased_Item */
static int hf_xnap_iabTNLAddress = -1;            /* IABTNLAddress */
static int hf_xnap_TrafficRequiredModifiedList_item = -1;  /* TrafficRequiredModified_Item */
static int hf_xnap_BoundaryNodeCellsList_item = -1;  /* BoundaryNodeCellsList_Item */
static int hf_xnap_boundaryNodeCellInformation = -1;  /* IABCellInformation */
static int hf_xnap_ParentNodeCellsList_item = -1;  /* ParentNodeCellsList_Item */
static int hf_xnap_parentNodeCellInformation = -1;  /* IABCellInformation */
static int hf_xnap_initiatingMessage = -1;        /* InitiatingMessage */
static int hf_xnap_successfulOutcome = -1;        /* SuccessfulOutcome */
static int hf_xnap_unsuccessfulOutcome = -1;      /* UnsuccessfulOutcome */
static int hf_xnap_initiatingMessage_value = -1;  /* InitiatingMessage_value */
static int hf_xnap_successfulOutcome_value = -1;  /* SuccessfulOutcome_value */
static int hf_xnap_value = -1;                    /* UnsuccessfulOutcome_value */
/* named bits */
static int hf_xnap_RAT_RestrictionInformation_e_UTRA = -1;
static int hf_xnap_RAT_RestrictionInformation_nR = -1;
static int hf_xnap_RAT_RestrictionInformation_nR_unlicensed = -1;
static int hf_xnap_RAT_RestrictionInformation_nR_LEO = -1;
static int hf_xnap_RAT_RestrictionInformation_nR_MEO = -1;
static int hf_xnap_RAT_RestrictionInformation_nR_GEO = -1;
static int hf_xnap_RAT_RestrictionInformation_nR_OTHERSAT = -1;
static int hf_xnap_T_interfaces_to_trace_ng_c = -1;
static int hf_xnap_T_interfaces_to_trace_x_nc = -1;
static int hf_xnap_T_interfaces_to_trace_uu = -1;
static int hf_xnap_T_interfaces_to_trace_f1_c = -1;
static int hf_xnap_T_interfaces_to_trace_e1 = -1;
static int hf_xnap_T_nr_EncyptionAlgorithms_spare_bit0 = -1;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea1_128 = -1;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea2_128 = -1;
static int hf_xnap_T_nr_EncyptionAlgorithms_nea3_128 = -1;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_spare_bit0 = -1;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia1_128 = -1;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia2_128 = -1;
static int hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia3_128 = -1;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_spare_bit0 = -1;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea1_128 = -1;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea2_128 = -1;
static int hf_xnap_T_e_utra_EncyptionAlgorithms_eea3_128 = -1;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_spare_bit0 = -1;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia1_128 = -1;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia2_128 = -1;
static int hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia3_128 = -1;

/* Initialize the subtree pointers */
static gint ett_xnap = -1;
static gint ett_xnap_RRC_Context = -1;
static gint ett_nxap_container = -1;
static gint ett_xnap_PLMN_Identity = -1;
static gint ett_xnap_measurementTimingConfiguration = -1;
static gint ett_xnap_TransportLayerAddress = -1;
static gint ett_xnap_NG_RANTraceID = -1;
static gint ett_xnap_LastVisitedEUTRANCellInformation = -1;
static gint ett_xnap_LastVisitedNGRANCellInformation = -1;
static gint ett_xnap_LastVisitedUTRANCellInformation = -1;
static gint ett_xnap_LastVisitedGERANCellInformation = -1;
static gint ett_xnap_UERadioCapabilityForPagingOfNR = -1;
static gint ett_xnap_UERadioCapabilityForPagingOfEUTRA = -1;
static gint ett_xnap_FiveGCMobilityRestrictionListContainer = -1;
static gint ett_xnap_primaryRATRestriction = -1;
static gint ett_xnap_secondaryRATRestriction = -1;
static gint ett_xnap_ImmediateMDT_EUTRA = -1;
static gint ett_xnap_MDT_Location_Info = -1;
static gint ett_xnap_MeasurementsToActivate = -1;
static gint ett_xnap_NRMobilityHistoryReport = -1;
static gint ett_xnap_RACHReportContainer = -1;
static gint ett_xnap_TargetCellinEUTRAN = -1;
static gint ett_xnap_TDDULDLConfigurationCommonNR = -1;
static gint ett_xnap_UERLFReportContainerLTE = -1;
static gint ett_xnap_UERLFReportContainerNR = -1;
static gint ett_xnap_burstArrivalTime = -1;
static gint ett_xnap_ReportCharacteristics = -1;
static gint ett_xnap_NRCellPRACHConfig = -1;
static gint ett_xnap_anchorCarrier_NPRACHConfig = -1;
static gint ett_xnap_anchorCarrier_EDT_NPRACHConfig = -1;
static gint ett_xnap_anchorCarrier_Format2_NPRACHConfig = -1;
static gint ett_xnap_anchorCarrier_Format2_EDT_NPRACHConfig = -1;
static gint ett_xnap_non_anchorCarrier_NPRACHConfig = -1;
static gint ett_xnap_non_anchorCarrier_Format2_NPRACHConfig = -1;
static gint ett_xnap_anchorCarrier_NPRACHConfigTDD = -1;
static gint ett_xnap_non_anchorCarrier_NPRACHConfigTDD = -1;
static gint ett_xnap_non_anchorCarrierFrequency = -1;
static gint ett_xnap_cSI_RS_Configuration = -1;
static gint ett_xnap_sR_Configuration = -1;
static gint ett_xnap_pDCCH_ConfigSIB1 = -1;
static gint ett_xnap_sCS_Common = -1;
static gint ett_xnap_LastVisitedPSCellInformation = -1;
static gint ett_xnap_MeasObjectContainer = -1;
static gint ett_xnap_RACH_Config_Common = -1;
static gint ett_xnap_RACH_Config_Common_IAB = -1;
static gint ett_xnap_ReportConfigContainer = -1;
static gint ett_xnap_RLC_Bearer_Configuration = -1;
static gint ett_xnap_SuccessfulHOReportContainer = -1;
static gint ett_xnap_UERLFReportContainerLTEExtendBand = -1;
static gint ett_xnap_MDTMode_EUTRA = -1;
static gint ett_xnap_PrivateIE_ID = -1;
static gint ett_xnap_ProtocolIE_Container = -1;
static gint ett_xnap_ProtocolIE_Field = -1;
static gint ett_xnap_ProtocolExtensionContainer = -1;
static gint ett_xnap_ProtocolExtensionField = -1;
static gint ett_xnap_PrivateIE_Container = -1;
static gint ett_xnap_PrivateIE_Field = -1;
static gint ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated = -1;
static gint ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item = -1;
static gint ett_xnap_Additional_PDCP_Duplication_TNL_List = -1;
static gint ett_xnap_Additional_PDCP_Duplication_TNL_Item = -1;
static gint ett_xnap_Additional_UL_NG_U_TNLatUPF_Item = -1;
static gint ett_xnap_Additional_UL_NG_U_TNLatUPF_List = -1;
static gint ett_xnap_Additional_Measurement_Timing_Configuration_List = -1;
static gint ett_xnap_Additional_Measurement_Timing_Configuration_Item = -1;
static gint ett_xnap_Active_MBS_SessionInformation = -1;
static gint ett_xnap_AllocationandRetentionPriority = -1;
static gint ett_xnap_AllowedCAG_ID_List_perPLMN = -1;
static gint ett_xnap_AllowedPNI_NPN_ID_List = -1;
static gint ett_xnap_AllowedPNI_NPN_ID_Item = -1;
static gint ett_xnap_AlternativeQoSParaSetList = -1;
static gint ett_xnap_AlternativeQoSParaSetItem = -1;
static gint ett_xnap_AMF_Region_Information = -1;
static gint ett_xnap_GlobalAMF_Region_Information = -1;
static gint ett_xnap_AreaOfInterestInformation = -1;
static gint ett_xnap_AreaOfInterest_Item = -1;
static gint ett_xnap_AreaScopeOfMDT_NR = -1;
static gint ett_xnap_AreaScopeOfMDT_EUTRA = -1;
static gint ett_xnap_AreaScopeOfNeighCellsList = -1;
static gint ett_xnap_AreaScopeOfNeighCellsItem = -1;
static gint ett_xnap_AreaScopeOfQMC = -1;
static gint ett_xnap_AS_SecurityInformation = -1;
static gint ett_xnap_AssistanceDataForRANPaging = -1;
static gint ett_xnap_Associated_QoSFlowInfo_List = -1;
static gint ett_xnap_Associated_QoSFlowInfo_Item = -1;
static gint ett_xnap_AvailableRVQoEMetrics = -1;
static gint ett_xnap_BAPRoutingID = -1;
static gint ett_xnap_BeamMeasurementsReportConfiguration = -1;
static gint ett_xnap_BeamMeasurementsReportQuantity = -1;
static gint ett_xnap_BHInfoList = -1;
static gint ett_xnap_BHInfo_Item = -1;
static gint ett_xnap_BAPControlPDURLCCH_List = -1;
static gint ett_xnap_BAPControlPDURLCCH_Item = -1;
static gint ett_xnap_BluetoothMeasurementConfiguration = -1;
static gint ett_xnap_BluetoothMeasConfigNameList = -1;
static gint ett_xnap_BPLMN_ID_Info_EUTRA = -1;
static gint ett_xnap_BPLMN_ID_Info_EUTRA_Item = -1;
static gint ett_xnap_BPLMN_ID_Info_NR = -1;
static gint ett_xnap_BPLMN_ID_Info_NR_Item = -1;
static gint ett_xnap_BroadcastCAG_Identifier_List = -1;
static gint ett_xnap_BroadcastCAG_Identifier_Item = -1;
static gint ett_xnap_BroadcastNID_List = -1;
static gint ett_xnap_BroadcastNID_Item = -1;
static gint ett_xnap_BroadcastPLMNs = -1;
static gint ett_xnap_BroadcastEUTRAPLMNs = -1;
static gint ett_xnap_BroadcastPLMNinTAISupport_Item = -1;
static gint ett_xnap_BroadcastPNI_NPN_ID_Information = -1;
static gint ett_xnap_BroadcastPNI_NPN_ID_Information_Item = -1;
static gint ett_xnap_BroadcastSNPNID_List = -1;
static gint ett_xnap_BroadcastSNPNID = -1;
static gint ett_xnap_CapacityValueInfo = -1;
static gint ett_xnap_Cause = -1;
static gint ett_xnap_CellAssistanceInfo_NR = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI = -1;
static gint ett_xnap_CellAndCapacityAssistanceInfo_NR = -1;
static gint ett_xnap_CellAndCapacityAssistanceInfo_EUTRA = -1;
static gint ett_xnap_CellAssistanceInfo_EUTRA = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI = -1;
static gint ett_xnap_CellBasedMDT_NR = -1;
static gint ett_xnap_CellIdListforMDT_NR = -1;
static gint ett_xnap_CellBasedQMC = -1;
static gint ett_xnap_CellIdListforQMC = -1;
static gint ett_xnap_CellBasedMDT_EUTRA = -1;
static gint ett_xnap_CellIdListforMDT_EUTRA = -1;
static gint ett_xnap_CellMeasurementResult = -1;
static gint ett_xnap_CellMeasurementResult_Item = -1;
static gint ett_xnap_CellReplacingInfo = -1;
static gint ett_xnap_CellToReport = -1;
static gint ett_xnap_CellToReport_Item = -1;
static gint ett_xnap_Cell_Type_Choice = -1;
static gint ett_xnap_CHOConfiguration = -1;
static gint ett_xnap_CHOCandidateCell_List = -1;
static gint ett_xnap_CHOCandidateCell_Item = -1;
static gint ett_xnap_CHOExecutionCondition_List = -1;
static gint ett_xnap_CHOExecutionCondition_Item = -1;
static gint ett_xnap_CompositeAvailableCapacityGroup = -1;
static gint ett_xnap_CompositeAvailableCapacity = -1;
static gint ett_xnap_CHOinformation_Req = -1;
static gint ett_xnap_CHOinformation_Ack = -1;
static gint ett_xnap_CHOinformation_AddReq = -1;
static gint ett_xnap_CHOinformation_ModReq = -1;
static gint ett_xnap_Connectivity_Support = -1;
static gint ett_xnap_COUNT_PDCP_SN12 = -1;
static gint ett_xnap_COUNT_PDCP_SN18 = -1;
static gint ett_xnap_Coverage_Modification_List = -1;
static gint ett_xnap_Coverage_Modification_List_Item = -1;
static gint ett_xnap_CPTransportLayerInformation = -1;
static gint ett_xnap_CPACcandidatePSCells_list = -1;
static gint ett_xnap_CPACcandidatePSCells_item = -1;
static gint ett_xnap_CPAInformationRequest = -1;
static gint ett_xnap_CPAInformationAck = -1;
static gint ett_xnap_CPCInformationRequired = -1;
static gint ett_xnap_CPC_target_SN_required_list = -1;
static gint ett_xnap_CPC_target_SN_required_list_Item = -1;
static gint ett_xnap_CPCInformationConfirm = -1;
static gint ett_xnap_CPC_target_SN_confirm_list = -1;
static gint ett_xnap_CPC_target_SN_confirm_list_Item = -1;
static gint ett_xnap_CPAInformationModReq = -1;
static gint ett_xnap_CPAInformationModReqAck = -1;
static gint ett_xnap_CPACInformationModRequired = -1;
static gint ett_xnap_CPCInformationUpdate = -1;
static gint ett_xnap_CPC_target_SN_mod_list = -1;
static gint ett_xnap_CPC_target_SN_mod_item = -1;
static gint ett_xnap_CPCInformationUpdatePSCells_list = -1;
static gint ett_xnap_CPCInformationUpdatePSCells_item = -1;
static gint ett_xnap_CriticalityDiagnostics = -1;
static gint ett_xnap_CriticalityDiagnostics_IE_List = -1;
static gint ett_xnap_CriticalityDiagnostics_IE_List_item = -1;
static gint ett_xnap_CSI_RS_MTC_Configuration_List = -1;
static gint ett_xnap_CSI_RS_MTC_Configuration_Item = -1;
static gint ett_xnap_CSI_RS_Neighbour_List = -1;
static gint ett_xnap_CSI_RS_Neighbour_Item = -1;
static gint ett_xnap_CSI_RS_MTC_Neighbour_List = -1;
static gint ett_xnap_CSI_RS_MTC_Neighbour_Item = -1;
static gint ett_xnap_XnUAddressInfoperPDUSession_List = -1;
static gint ett_xnap_XnUAddressInfoperPDUSession_Item = -1;
static gint ett_xnap_DataForwardingInfoFromTargetE_UTRANnode = -1;
static gint ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_List = -1;
static gint ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item = -1;
static gint ett_xnap_QoSFlowsToBeForwarded_List = -1;
static gint ett_xnap_QoSFlowsToBeForwarded_Item = -1;
static gint ett_xnap_DataForwardingInfoFromTargetNGRANnode = -1;
static gint ett_xnap_QoSFLowsAcceptedToBeForwarded_List = -1;
static gint ett_xnap_QoSFLowsAcceptedToBeForwarded_Item = -1;
static gint ett_xnap_DataforwardingandOffloadingInfofromSource = -1;
static gint ett_xnap_QoSFLowsToBeForwarded_List = -1;
static gint ett_xnap_QoSFLowsToBeForwarded_Item = -1;
static gint ett_xnap_DataForwardingResponseDRBItemList = -1;
static gint ett_xnap_DataForwardingResponseDRBItem = -1;
static gint ett_xnap_DataTrafficResourceIndication = -1;
static gint ett_xnap_DAPSRequestInfo = -1;
static gint ett_xnap_DAPSResponseInfo_List = -1;
static gint ett_xnap_DAPSResponseInfo_Item = -1;
static gint ett_xnap_DLCountChoice = -1;
static gint ett_xnap_DLF1Terminating_BHInfo = -1;
static gint ett_xnap_DLNonF1Terminating_BHInfo = -1;
static gint ett_xnap_DRB_List = -1;
static gint ett_xnap_DRB_List_withCause = -1;
static gint ett_xnap_DRB_List_withCause_Item = -1;
static gint ett_xnap_DRBsSubjectToDLDiscarding_List = -1;
static gint ett_xnap_DRBsSubjectToDLDiscarding_Item = -1;
static gint ett_xnap_DRBsSubjectToEarlyStatusTransfer_List = -1;
static gint ett_xnap_DRBsSubjectToEarlyStatusTransfer_Item = -1;
static gint ett_xnap_DRBsSubjectToStatusTransfer_List = -1;
static gint ett_xnap_DRBsSubjectToStatusTransfer_Item = -1;
static gint ett_xnap_DRBBStatusTransferChoice = -1;
static gint ett_xnap_DRBBStatusTransfer12bitsSN = -1;
static gint ett_xnap_DRBBStatusTransfer18bitsSN = -1;
static gint ett_xnap_DRBToQoSFlowMapping_List = -1;
static gint ett_xnap_DRBToQoSFlowMapping_Item = -1;
static gint ett_xnap_DUF_Slot_Config_List = -1;
static gint ett_xnap_DUF_Slot_Config_Item = -1;
static gint ett_xnap_Dynamic5QIDescriptor = -1;
static gint ett_xnap_E_UTRA_CGI = -1;
static gint ett_xnap_E_UTRAMultibandInfoList = -1;
static gint ett_xnap_EUTRAPagingeDRXInformation = -1;
static gint ett_xnap_E_UTRAPRACHConfiguration = -1;
static gint ett_xnap_EndpointIPAddressAndPort = -1;
static gint ett_xnap_EventTriggered = -1;
static gint ett_xnap_EventTypeTrigger = -1;
static gint ett_xnap_EventL1 = -1;
static gint ett_xnap_MeasurementThresholdL1LoggedMDT = -1;
static gint ett_xnap_ExcessPacketDelayThresholdConfiguration = -1;
static gint ett_xnap_ExcessPacketDelayThresholdItem = -1;
static gint ett_xnap_ExpectedUEActivityBehaviour = -1;
static gint ett_xnap_ExpectedUEBehaviour = -1;
static gint ett_xnap_ExpectedUEMovingTrajectory = -1;
static gint ett_xnap_ExpectedUEMovingTrajectoryItem = -1;
static gint ett_xnap_ExplicitFormat = -1;
static gint ett_xnap_ExtendedRATRestrictionInformation = -1;
static gint ett_xnap_ExtendedSliceSupportList = -1;
static gint ett_xnap_ExtTLAs = -1;
static gint ett_xnap_ExtTLA_Item = -1;
static gint ett_xnap_GTPTLAs = -1;
static gint ett_xnap_GTPTLA_Item = -1;
static gint ett_xnap_F1_TerminatingTopologyBHInformation = -1;
static gint ett_xnap_F1TerminatingBHInformation_List = -1;
static gint ett_xnap_F1TerminatingBHInformation_Item = -1;
static gint ett_xnap_FiveGProSeAuthorized = -1;
static gint ett_xnap_FiveGProSePC5QoSParameters = -1;
static gint ett_xnap_FiveGProSePC5QoSFlowList = -1;
static gint ett_xnap_FiveGProSePC5QoSFlowItem = -1;
static gint ett_xnap_FiveGProSePC5FlowBitRates = -1;
static gint ett_xnap_Flows_Mapped_To_DRB_List = -1;
static gint ett_xnap_Flows_Mapped_To_DRB_Item = -1;
static gint ett_xnap_FreqDomainHSNAconfiguration_List = -1;
static gint ett_xnap_FreqDomainHSNAconfiguration_List_Item = -1;
static gint ett_xnap_FreqDomainSlotHSNAconfiguration_List = -1;
static gint ett_xnap_FreqDomainSlotHSNAconfiguration_List_Item = -1;
static gint ett_xnap_GBRQoSFlowInfo = -1;
static gint ett_xnap_GlobalgNB_ID = -1;
static gint ett_xnap_GNB_DU_Cell_Resource_Configuration = -1;
static gint ett_xnap_GNB_ID_Choice = -1;
static gint ett_xnap_GNB_RadioResourceStatus = -1;
static gint ett_xnap_GlobalCell_ID = -1;
static gint ett_xnap_GlobalngeNB_ID = -1;
static gint ett_xnap_ENB_ID_Choice = -1;
static gint ett_xnap_GlobalNG_RANCell_ID = -1;
static gint ett_xnap_GlobalNG_RANNode_ID = -1;
static gint ett_xnap_GTPtunnelTransportLayerInformation = -1;
static gint ett_xnap_GUAMI = -1;
static gint ett_xnap_HSNASlotConfigList = -1;
static gint ett_xnap_HSNASlotConfigItem = -1;
static gint ett_xnap_IABCellInformation = -1;
static gint ett_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info = -1;
static gint ett_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info = -1;
static gint ett_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info = -1;
static gint ett_xnap_IAB_MT_Cell_List = -1;
static gint ett_xnap_IAB_MT_Cell_List_Item = -1;
static gint ett_xnap_IAB_QoS_Mapping_Information = -1;
static gint ett_xnap_IAB_STC_Info = -1;
static gint ett_xnap_IAB_STC_Info_List = -1;
static gint ett_xnap_IAB_STC_Info_Item = -1;
static gint ett_xnap_IAB_TNL_Address_Request = -1;
static gint ett_xnap_IABIPv6RequestType = -1;
static gint ett_xnap_IAB_TNL_Address_Response = -1;
static gint ett_xnap_IABAllocatedTNLAddress_List = -1;
static gint ett_xnap_IABAllocatedTNLAddress_Item = -1;
static gint ett_xnap_IABTNLAddress = -1;
static gint ett_xnap_IABTNLAddressesRequested = -1;
static gint ett_xnap_IABTNLAddressToRemove_List = -1;
static gint ett_xnap_IABTNLAddressToRemove_Item = -1;
static gint ett_xnap_IABTNLAddressException = -1;
static gint ett_xnap_IABTNLAddress_Item = -1;
static gint ett_xnap_ImmediateMDT_NR = -1;
static gint ett_xnap_ImplicitFormat = -1;
static gint ett_xnap_InitiatingCondition_FailureIndication = -1;
static gint ett_xnap_IntendedTDD_DL_ULConfiguration_NR = -1;
static gint ett_xnap_I_RNTI = -1;
static gint ett_xnap_Local_NG_RAN_Node_Identifier = -1;
static gint ett_xnap_Full_I_RNTI_Profile_List = -1;
static gint ett_xnap_Short_I_RNTI_Profile_List = -1;
static gint ett_xnap_LastVisitedCell_Item = -1;
static gint ett_xnap_LastVisitedPSCellList = -1;
static gint ett_xnap_LastVisitedPSCellList_Item = -1;
static gint ett_xnap_SCGUEHistoryInformation = -1;
static gint ett_xnap_ListOfCells = -1;
static gint ett_xnap_CellsinAoI_Item = -1;
static gint ett_xnap_ListOfRANNodesinAoI = -1;
static gint ett_xnap_GlobalNG_RANNodesinAoI_Item = -1;
static gint ett_xnap_ListOfTAIsinAoI = -1;
static gint ett_xnap_TAIsinAoI_Item = -1;
static gint ett_xnap_LocationReportingInformation = -1;
static gint ett_xnap_LoggedEventTriggeredConfig = -1;
static gint ett_xnap_LoggedMDT_NR = -1;
static gint ett_xnap_LTEV2XServicesAuthorized = -1;
static gint ett_xnap_LTEUESidelinkAggregateMaximumBitRate = -1;
static gint ett_xnap_MDTAlignmentInfo = -1;
static gint ett_xnap_M1Configuration = -1;
static gint ett_xnap_M1PeriodicReporting = -1;
static gint ett_xnap_M1ThresholdEventA2 = -1;
static gint ett_xnap_M4Configuration = -1;
static gint ett_xnap_M5Configuration = -1;
static gint ett_xnap_M6Configuration = -1;
static gint ett_xnap_M7Configuration = -1;
static gint ett_xnap_MaximumIPdatarate = -1;
static gint ett_xnap_MBSFNSubframeAllocation_E_UTRA = -1;
static gint ett_xnap_MBSFNSubframeInfo_E_UTRA = -1;
static gint ett_xnap_MBSFNSubframeInfo_E_UTRA_Item = -1;
static gint ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource = -1;
static gint ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item = -1;
static gint ett_xnap_MBS_DataForwardingResponseInfofromTarget = -1;
static gint ett_xnap_MBS_DataForwardingResponseInfofromTarget_Item = -1;
static gint ett_xnap_MBS_QoSFlow_List = -1;
static gint ett_xnap_MBS_QoSFlowsToAdd_List = -1;
static gint ett_xnap_MBS_QoSFlowsToAdd_Item = -1;
static gint ett_xnap_MBS_ServiceArea = -1;
static gint ett_xnap_MBS_ServiceAreaCell_List = -1;
static gint ett_xnap_MBS_ServiceAreaInformation = -1;
static gint ett_xnap_MBS_ServiceAreaInformationList = -1;
static gint ett_xnap_MBS_ServiceAreaInformation_Item = -1;
static gint ett_xnap_MBS_ServiceAreaTAI_List = -1;
static gint ett_xnap_MBS_ServiceAreaTAI_Item = -1;
static gint ett_xnap_MBS_Session_ID = -1;
static gint ett_xnap_MBS_SessionAssociatedInformation = -1;
static gint ett_xnap_MBS_SessionAssociatedInformation_Item = -1;
static gint ett_xnap_MBS_SessionInformation_List = -1;
static gint ett_xnap_MBS_SessionInformation_Item = -1;
static gint ett_xnap_MBS_SessionInformationResponse_List = -1;
static gint ett_xnap_MBS_SessionInformationResponse_Item = -1;
static gint ett_xnap_MRB_ProgressInformation = -1;
static gint ett_xnap_MDT_Configuration = -1;
static gint ett_xnap_MDT_Configuration_NR = -1;
static gint ett_xnap_MDT_Configuration_EUTRA = -1;
static gint ett_xnap_MDTPLMNList = -1;
static gint ett_xnap_MDTPLMNModificationList = -1;
static gint ett_xnap_MDTMode_NR = -1;
static gint ett_xnap_MeasurementThresholdA2 = -1;
static gint ett_xnap_MIMOPRBusageInformation = -1;
static gint ett_xnap_MobilityParametersModificationRange = -1;
static gint ett_xnap_MobilityParametersInformation = -1;
static gint ett_xnap_MobilityRestrictionList = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity = -1;
static gint ett_xnap_CNTypeRestrictionsForEquivalent = -1;
static gint ett_xnap_CNTypeRestrictionsForEquivalentItem = -1;
static gint ett_xnap_RAT_RestrictionsList = -1;
static gint ett_xnap_RAT_RestrictionsItem = -1;
static gint ett_xnap_RAT_RestrictionInformation = -1;
static gint ett_xnap_ForbiddenAreaList = -1;
static gint ett_xnap_ForbiddenAreaItem = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC = -1;
static gint ett_xnap_ServiceAreaList = -1;
static gint ett_xnap_ServiceAreaItem = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC = -1;
static gint ett_xnap_MR_DC_ResourceCoordinationInfo = -1;
static gint ett_xnap_NG_RAN_Node_ResourceCoordinationInfo = -1;
static gint ett_xnap_E_UTRA_ResourceCoordinationInfo = -1;
static gint ett_xnap_NR_ResourceCoordinationInfo = -1;
static gint ett_xnap_MessageOversizeNotification = -1;
static gint ett_xnap_MultiplexingInfo = -1;
static gint ett_xnap_NACellResourceConfigurationList = -1;
static gint ett_xnap_NACellResourceConfiguration_Item = -1;
static gint ett_xnap_NE_DC_TDM_Pattern = -1;
static gint ett_xnap_NeighbourInformation_E_UTRA = -1;
static gint ett_xnap_NeighbourInformation_E_UTRA_Item = -1;
static gint ett_xnap_NeighbourInformation_NR = -1;
static gint ett_xnap_NeighbourInformation_NR_Item = -1;
static gint ett_xnap_NeighbourInformation_NR_ModeInfo = -1;
static gint ett_xnap_NeighbourInformation_NR_ModeFDDInfo = -1;
static gint ett_xnap_NeighbourInformation_NR_ModeTDDInfo = -1;
static gint ett_xnap_Neighbour_NG_RAN_Node_List = -1;
static gint ett_xnap_Neighbour_NG_RAN_Node_Item = -1;
static gint ett_xnap_NRCarrierList = -1;
static gint ett_xnap_NRCarrierItem = -1;
static gint ett_xnap_NG_RAN_Cell_Identity = -1;
static gint ett_xnap_NG_RAN_CellPCI = -1;
static gint ett_xnap_NG_RANnode2SSBOffsetsModificationRange = -1;
static gint ett_xnap_NonDynamic5QIDescriptor = -1;
static gint ett_xnap_NG_eNB_RadioResourceStatus = -1;
static gint ett_xnap_TNLCapacityIndicator = -1;
static gint ett_xnap_Non_F1_TerminatingTopologyBHInformation = -1;
static gint ett_xnap_NonF1TerminatingBHInformation_List = -1;
static gint ett_xnap_NonF1TerminatingBHInformation_Item = -1;
static gint ett_xnap_NonUPTraffic = -1;
static gint ett_xnap_NPN_Broadcast_Information = -1;
static gint ett_xnap_NPN_Broadcast_Information_SNPN = -1;
static gint ett_xnap_NPN_Broadcast_Information_PNI_NPN = -1;
static gint ett_xnap_NPNMobilityInformation = -1;
static gint ett_xnap_NPNMobilityInformation_SNPN = -1;
static gint ett_xnap_NPNMobilityInformation_PNI_NPN = -1;
static gint ett_xnap_NPNPagingAssistanceInformation = -1;
static gint ett_xnap_NPNPagingAssistanceInformation_PNI_NPN = -1;
static gint ett_xnap_NPN_Support = -1;
static gint ett_xnap_NPN_Support_SNPN = -1;
static gint ett_xnap_NPRACHConfiguration = -1;
static gint ett_xnap_T_fdd_or_tdd = -1;
static gint ett_xnap_NPRACHConfiguration_FDD = -1;
static gint ett_xnap_NPRACHConfiguration_TDD = -1;
static gint ett_xnap_Non_AnchorCarrierFrequencylist = -1;
static gint ett_xnap_Non_AnchorCarrierFrequencylist_item = -1;
static gint ett_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea = -1;
static gint ett_xnap_NR_CGI = -1;
static gint ett_xnap_NR_U_Channel_List = -1;
static gint ett_xnap_NR_U_Channel_Item = -1;
static gint ett_xnap_NR_U_ChannelInfo_List = -1;
static gint ett_xnap_NR_U_ChannelInfo_Item = -1;
static gint ett_xnap_NRFrequencyBand_List = -1;
static gint ett_xnap_NRFrequencyBandItem = -1;
static gint ett_xnap_NRFrequencyInfo = -1;
static gint ett_xnap_NRModeInfo = -1;
static gint ett_xnap_NRModeInfoFDD = -1;
static gint ett_xnap_NRModeInfoTDD = -1;
static gint ett_xnap_NRPagingeDRXInformation = -1;
static gint ett_xnap_NRPagingeDRXInformationforRRCINACTIVE = -1;
static gint ett_xnap_NRTransmissionBandwidth = -1;
static gint ett_xnap_NRV2XServicesAuthorized = -1;
static gint ett_xnap_NRUESidelinkAggregateMaximumBitRate = -1;
static gint ett_xnap_PositioningInformation = -1;
static gint ett_xnap_PacketErrorRate = -1;
static gint ett_xnap_PEIPSassistanceInformation = -1;
static gint ett_xnap_PC5QoSParameters = -1;
static gint ett_xnap_PC5QoSFlowList = -1;
static gint ett_xnap_PC5QoSFlowItem = -1;
static gint ett_xnap_PC5FlowBitRates = -1;
static gint ett_xnap_PDCPChangeIndication = -1;
static gint ett_xnap_PDCPSNLength = -1;
static gint ett_xnap_PDUSessionAggregateMaximumBitRate = -1;
static gint ett_xnap_PDUSession_List = -1;
static gint ett_xnap_PDUSession_List_withCause = -1;
static gint ett_xnap_PDUSession_List_withCause_Item = -1;
static gint ett_xnap_PDUSession_List_withDataForwardingFromTarget = -1;
static gint ett_xnap_PDUSession_List_withDataForwardingFromTarget_Item = -1;
static gint ett_xnap_PDUSession_List_withDataForwardingRequest = -1;
static gint ett_xnap_PDUSession_List_withDataForwardingRequest_Item = -1;
static gint ett_xnap_PDUSessionResourcesAdmitted_List = -1;
static gint ett_xnap_PDUSessionResourcesAdmitted_Item = -1;
static gint ett_xnap_PDUSessionResourceAdmittedInfo = -1;
static gint ett_xnap_PDUSessionResourcesNotAdmitted_List = -1;
static gint ett_xnap_PDUSessionResourcesNotAdmitted_Item = -1;
static gint ett_xnap_PDUSessionResourcesToBeSetup_List = -1;
static gint ett_xnap_PDUSessionResourcesToBeSetup_Item = -1;
static gint ett_xnap_PDUSessionResourceSetupInfo_SNterminated = -1;
static gint ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated = -1;
static gint ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceSetupResponseInfo_SNterminated = -1;
static gint ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated = -1;
static gint ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceSetupInfo_MNterminated = -1;
static gint ett_xnap_DRBsToBeSetupList_Setup_MNterminated = -1;
static gint ett_xnap_DRBsToBeSetupList_Setup_MNterminated_Item = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceSetupResponseInfo_MNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated = -1;
static gint ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModificationInfo_SNterminated = -1;
static gint ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated = -1;
static gint ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item = -1;
static gint ett_xnap_DRBsToBeModified_List_Modified_SNterminated = -1;
static gint ett_xnap_DRBsToBeModified_List_Modified_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModificationResponseInfo_SNterminated = -1;
static gint ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated = -1;
static gint ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModificationInfo_MNterminated = -1;
static gint ett_xnap_DRBsToBeModifiedList_Modification_MNterminated = -1;
static gint ett_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModificationResponseInfo_MNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated = -1;
static gint ett_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated = -1;
static gint ett_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated = -1;
static gint ett_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated = -1;
static gint ett_xnap_PDUSessionResourceModRqdInfo_SNterminated = -1;
static gint ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated = -1;
static gint ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item = -1;
static gint ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated = -1;
static gint ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item = -1;
static gint ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated = -1;
static gint ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item = -1;
static gint ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated = -1;
static gint ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModConfirmInfo_SNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated = -1;
static gint ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModRqdInfo_MNterminated = -1;
static gint ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated = -1;
static gint ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceModConfirmInfo_MNterminated = -1;
static gint ett_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item = -1;
static gint ett_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item = -1;
static gint ett_xnap_PDUSessionResourceSecondaryRATUsageList = -1;
static gint ett_xnap_PDUSessionResourceSecondaryRATUsageItem = -1;
static gint ett_xnap_PDUSessionUsageReport = -1;
static gint ett_xnap_Periodical = -1;
static gint ett_xnap_PLMNAreaBasedQMC = -1;
static gint ett_xnap_PLMNListforQMC = -1;
static gint ett_xnap_PCIListForMDT = -1;
static gint ett_xnap_ProtectedE_UTRAResourceIndication = -1;
static gint ett_xnap_ProtectedE_UTRAResourceList = -1;
static gint ett_xnap_ProtectedE_UTRAResource_Item = -1;
static gint ett_xnap_ProtectedE_UTRAFootprintTimePattern = -1;
static gint ett_xnap_QMCConfigInfo = -1;
static gint ett_xnap_UEAppLayerMeasInfoList = -1;
static gint ett_xnap_UEAppLayerMeasInfo_Item = -1;
static gint ett_xnap_QoSCharacteristics = -1;
static gint ett_xnap_QoSFlowLevelQoSParameters = -1;
static gint ett_xnap_QoSFlowNotificationControlIndicationInfo = -1;
static gint ett_xnap_QoSFlowNotify_Item = -1;
static gint ett_xnap_QoSFlows_List = -1;
static gint ett_xnap_QoSFlow_Item = -1;
static gint ett_xnap_QoSFlows_List_withCause = -1;
static gint ett_xnap_QoSFlowwithCause_Item = -1;
static gint ett_xnap_QoS_Mapping_Information = -1;
static gint ett_xnap_QoSFlowsAdmitted_List = -1;
static gint ett_xnap_QoSFlowsAdmitted_Item = -1;
static gint ett_xnap_QoSFlowsToBeSetup_List = -1;
static gint ett_xnap_QoSFlowsToBeSetup_Item = -1;
static gint ett_xnap_QoSFlowsUsageReportList = -1;
static gint ett_xnap_QoSFlowsUsageReport_Item = -1;
static gint ett_xnap_RACHReportInformation = -1;
static gint ett_xnap_RACHReportList_Item = -1;
static gint ett_xnap_RadioResourceStatus = -1;
static gint ett_xnap_RANAreaID = -1;
static gint ett_xnap_RANAreaID_List = -1;
static gint ett_xnap_RANPagingArea = -1;
static gint ett_xnap_RANPagingAreaChoice = -1;
static gint ett_xnap_RANPagingAttemptInfo = -1;
static gint ett_xnap_RBsetConfiguration = -1;
static gint ett_xnap_RedundantPDUSessionInformation = -1;
static gint ett_xnap_ReplacingCells = -1;
static gint ett_xnap_ReplacingCells_Item = -1;
static gint ett_xnap_ReportType = -1;
static gint ett_xnap_ReservedSubframePattern = -1;
static gint ett_xnap_ResetRequestTypeInfo = -1;
static gint ett_xnap_ResetRequestTypeInfo_Full = -1;
static gint ett_xnap_ResetRequestTypeInfo_Partial = -1;
static gint ett_xnap_ResetRequestPartialReleaseList = -1;
static gint ett_xnap_ResetRequestPartialReleaseItem = -1;
static gint ett_xnap_ResetResponseTypeInfo = -1;
static gint ett_xnap_ResetResponseTypeInfo_Full = -1;
static gint ett_xnap_ResetResponseTypeInfo_Partial = -1;
static gint ett_xnap_ResetResponsePartialReleaseList = -1;
static gint ett_xnap_ResetResponsePartialReleaseItem = -1;
static gint ett_xnap_RLC_Status = -1;
static gint ett_xnap_RLCDuplicationInformation = -1;
static gint ett_xnap_RLCDuplicationStateList = -1;
static gint ett_xnap_RLCDuplicationState_Item = -1;
static gint ett_xnap_RRCConnections = -1;
static gint ett_xnap_RRCReestab_initiated = -1;
static gint ett_xnap_RRCReestab_Initiated_Reporting = -1;
static gint ett_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport = -1;
static gint ett_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport = -1;
static gint ett_xnap_RRCSetup_initiated = -1;
static gint ett_xnap_RRCSetup_Initiated_Reporting = -1;
static gint ett_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport = -1;
static gint ett_xnap_S_NSSAIListQoE = -1;
static gint ett_xnap_S_BasedMDT = -1;
static gint ett_xnap_SecondarydataForwardingInfoFromTarget_Item = -1;
static gint ett_xnap_SecondarydataForwardingInfoFromTarget_List = -1;
static gint ett_xnap_SDTSupportRequest = -1;
static gint ett_xnap_SDTPartialUEContextInfo = -1;
static gint ett_xnap_SDT_DRBsToBeSetupList = -1;
static gint ett_xnap_SDT_DRBsToBeSetupList_Item = -1;
static gint ett_xnap_SDT_SRBsToBeSetupList = -1;
static gint ett_xnap_SDT_SRBsToBeSetupList_Item = -1;
static gint ett_xnap_SDTDataForwardingDRBList = -1;
static gint ett_xnap_SDTDataForwardingDRBList_Item = -1;
static gint ett_xnap_SecondaryRATUsageInformation = -1;
static gint ett_xnap_SecurityIndication = -1;
static gint ett_xnap_SecurityResult = -1;
static gint ett_xnap_SensorMeasurementConfiguration = -1;
static gint ett_xnap_SensorMeasConfigNameList = -1;
static gint ett_xnap_SensorName = -1;
static gint ett_xnap_ServedCellInformation_E_UTRA = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN = -1;
static gint ett_xnap_ServedCellInformation_E_UTRA_perBPLMN = -1;
static gint ett_xnap_ServedCellInformation_E_UTRA_ModeInfo = -1;
static gint ett_xnap_ServedCellInformation_E_UTRA_FDDInfo = -1;
static gint ett_xnap_ServedCellInformation_E_UTRA_TDDInfo = -1;
static gint ett_xnap_ServedCells_E_UTRA = -1;
static gint ett_xnap_ServedCells_E_UTRA_Item = -1;
static gint ett_xnap_ServedCellsToUpdate_E_UTRA = -1;
static gint ett_xnap_ServedCells_ToModify_E_UTRA = -1;
static gint ett_xnap_ServedCells_ToModify_E_UTRA_Item = -1;
static gint ett_xnap_ServedCellInformation_NR = -1;
static gint ett_xnap_SFN_Offset = -1;
static gint ett_xnap_ServedCells_NR = -1;
static gint ett_xnap_ServedCells_NR_Item = -1;
static gint ett_xnap_ServedCells_ToModify_NR = -1;
static gint ett_xnap_ServedCells_ToModify_NR_Item = -1;
static gint ett_xnap_ServedCellSpecificInfoReq_NR = -1;
static gint ett_xnap_ServedCellSpecificInfoReq_NR_Item = -1;
static gint ett_xnap_ServedCellsToUpdate_NR = -1;
static gint ett_xnap_SharedResourceType = -1;
static gint ett_xnap_SharedResourceType_UL_OnlySharing = -1;
static gint ett_xnap_SharedResourceType_ULDL_Sharing = -1;
static gint ett_xnap_SharedResourceType_ULDL_Sharing_UL_Resources = -1;
static gint ett_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged = -1;
static gint ett_xnap_SharedResourceType_ULDL_Sharing_DL_Resources = -1;
static gint ett_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged = -1;
static gint ett_xnap_SliceAvailableCapacity = -1;
static gint ett_xnap_SliceAvailableCapacity_Item = -1;
static gint ett_xnap_SNSSAIAvailableCapacity_List = -1;
static gint ett_xnap_SNSSAIAvailableCapacity_Item = -1;
static gint ett_xnap_SliceRadioResourceStatus_List = -1;
static gint ett_xnap_SliceRadioResourceStatus_Item = -1;
static gint ett_xnap_SNSSAIRadioResourceStatus_List = -1;
static gint ett_xnap_SNSSAIRadioResourceStatus_Item = -1;
static gint ett_xnap_SliceSupport_List = -1;
static gint ett_xnap_SliceToReport_List = -1;
static gint ett_xnap_SliceToReport_List_Item = -1;
static gint ett_xnap_SNSSAI_list = -1;
static gint ett_xnap_SNSSAI_Item = -1;
static gint ett_xnap_SlotConfiguration_List = -1;
static gint ett_xnap_SlotConfiguration_List_Item = -1;
static gint ett_xnap_S_NSSAI = -1;
static gint ett_xnap_SpecialSubframeInfo_E_UTRA = -1;
static gint ett_xnap_SSBAreaCapacityValue_List = -1;
static gint ett_xnap_SSBAreaCapacityValue_List_Item = -1;
static gint ett_xnap_SSBAreaRadioResourceStatus_List = -1;
static gint ett_xnap_SSBAreaRadioResourceStatus_List_Item = -1;
static gint ett_xnap_SSB_Coverage_Modification_List = -1;
static gint ett_xnap_SSB_Coverage_Modification_List_Item = -1;
static gint ett_xnap_SSB_PositionsInBurst = -1;
static gint ett_xnap_SSBOffsets_List = -1;
static gint ett_xnap_SSBOffsets_Item = -1;
static gint ett_xnap_SSBOffsetInformation = -1;
static gint ett_xnap_SSBOffsetModificationRange = -1;
static gint ett_xnap_SSBToReport_List = -1;
static gint ett_xnap_SSBToReport_List_Item = -1;
static gint ett_xnap_SSB_transmissionBitmap = -1;
static gint ett_xnap_SuccessfulHOReportInformation = -1;
static gint ett_xnap_SuccessfulHOReportList_Item = -1;
static gint ett_xnap_SUL_Information = -1;
static gint ett_xnap_Supported_MBS_FSA_ID_List = -1;
static gint ett_xnap_SupportedSULBandList = -1;
static gint ett_xnap_SupportedSULBandItem = -1;
static gint ett_xnap_SymbolAllocation_in_Slot = -1;
static gint ett_xnap_SymbolAllocation_in_Slot_AllDL = -1;
static gint ett_xnap_SymbolAllocation_in_Slot_AllUL = -1;
static gint ett_xnap_SymbolAllocation_in_Slot_BothDLandUL = -1;
static gint ett_xnap_TABasedMDT = -1;
static gint ett_xnap_TAIBasedMDT = -1;
static gint ett_xnap_TAIListforMDT = -1;
static gint ett_xnap_TAIforMDT_Item = -1;
static gint ett_xnap_TAINSAGSupportList = -1;
static gint ett_xnap_TAINSAGSupportItem = -1;
static gint ett_xnap_TAISupport_List = -1;
static gint ett_xnap_TAISupport_Item = -1;
static gint ett_xnap_SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item = -1;
static gint ett_xnap_TAListforMDT = -1;
static gint ett_xnap_TABasedQMC = -1;
static gint ett_xnap_TAListforQMC = -1;
static gint ett_xnap_TAIBasedQMC = -1;
static gint ett_xnap_TAIListforQMC = -1;
static gint ett_xnap_TAI_Item = -1;
static gint ett_xnap_Target_CGI = -1;
static gint ett_xnap_TargetCellList = -1;
static gint ett_xnap_TargetCellList_Item = -1;
static gint ett_xnap_TimeSynchronizationAssistanceInformation = -1;
static gint ett_xnap_TNLConfigurationInfo = -1;
static gint ett_xnap_TNLA_To_Add_List = -1;
static gint ett_xnap_TNLA_To_Add_Item = -1;
static gint ett_xnap_TNLA_To_Update_List = -1;
static gint ett_xnap_TNLA_To_Update_Item = -1;
static gint ett_xnap_TNLA_To_Remove_List = -1;
static gint ett_xnap_TNLA_To_Remove_Item = -1;
static gint ett_xnap_TNLA_Setup_List = -1;
static gint ett_xnap_TNLA_Setup_Item = -1;
static gint ett_xnap_TNLA_Failed_To_Setup_List = -1;
static gint ett_xnap_TNLA_Failed_To_Setup_Item = -1;
static gint ett_xnap_TraceActivation = -1;
static gint ett_xnap_T_interfaces_to_trace = -1;
static gint ett_xnap_TrafficProfile = -1;
static gint ett_xnap_TrafficReleaseType = -1;
static gint ett_xnap_TrafficToBeReleaseInformation = -1;
static gint ett_xnap_TrafficToBeRelease_List = -1;
static gint ett_xnap_TrafficToBeRelease_Item = -1;
static gint ett_xnap_TSCTrafficCharacteristics = -1;
static gint ett_xnap_TSCAssistanceInformation = -1;
static gint ett_xnap_UEAggregateMaximumBitRate = -1;
static gint ett_xnap_UEAppLayerMeasConfigInfo = -1;
static gint ett_xnap_UEContextID = -1;
static gint ett_xnap_UEContextIDforRRCResume = -1;
static gint ett_xnap_UEContextIDforRRCReestablishment = -1;
static gint ett_xnap_UEContextInfoRetrUECtxtResp = -1;
static gint ett_xnap_UEHistoryInformation = -1;
static gint ett_xnap_UEHistoryInformationFromTheUE = -1;
static gint ett_xnap_UEIdentityIndexValue = -1;
static gint ett_xnap_UEIdentityIndexList_MBSGroupPaging = -1;
static gint ett_xnap_UEIdentityIndexList_MBSGroupPaging_Item = -1;
static gint ett_xnap_UEIdentityIndexList_MBSGroupPagingValue = -1;
static gint ett_xnap_UERadioCapabilityForPaging = -1;
static gint ett_xnap_UERANPagingIdentity = -1;
static gint ett_xnap_UERLFReportContainer = -1;
static gint ett_xnap_UERLFReportContainerLTEExtension = -1;
static gint ett_xnap_UESliceMaximumBitRateList = -1;
static gint ett_xnap_UESliceMaximumBitRate_Item = -1;
static gint ett_xnap_UESecurityCapabilities = -1;
static gint ett_xnap_T_nr_EncyptionAlgorithms = -1;
static gint ett_xnap_T_nr_IntegrityProtectionAlgorithms = -1;
static gint ett_xnap_T_e_utra_EncyptionAlgorithms = -1;
static gint ett_xnap_T_e_utra_IntegrityProtectionAlgorithms = -1;
static gint ett_xnap_ULConfiguration = -1;
static gint ett_xnap_ULF1Terminating_BHInfo = -1;
static gint ett_xnap_ULNonF1Terminating_BHInfo = -1;
static gint ett_xnap_UPTransportLayerInformation = -1;
static gint ett_xnap_UPTransportParameters = -1;
static gint ett_xnap_UPTransportParametersItem = -1;
static gint ett_xnap_VolumeTimedReportList = -1;
static gint ett_xnap_VolumeTimedReport_Item = -1;
static gint ett_xnap_WLANMeasurementConfiguration = -1;
static gint ett_xnap_WLANMeasConfigNameList = -1;
static gint ett_xnap_HandoverRequest = -1;
static gint ett_xnap_UEContextInfoHORequest = -1;
static gint ett_xnap_UEContextRefAtSN_HORequest = -1;
static gint ett_xnap_HandoverRequestAcknowledge = -1;
static gint ett_xnap_HandoverPreparationFailure = -1;
static gint ett_xnap_SNStatusTransfer = -1;
static gint ett_xnap_UEContextRelease = -1;
static gint ett_xnap_HandoverCancel = -1;
static gint ett_xnap_HandoverSuccess = -1;
static gint ett_xnap_ConditionalHandoverCancel = -1;
static gint ett_xnap_EarlyStatusTransfer = -1;
static gint ett_xnap_ProcedureStageChoice = -1;
static gint ett_xnap_FirstDLCount = -1;
static gint ett_xnap_DLDiscarding = -1;
static gint ett_xnap_RANPaging = -1;
static gint ett_xnap_RetrieveUEContextRequest = -1;
static gint ett_xnap_RetrieveUEContextResponse = -1;
static gint ett_xnap_RetrieveUEContextConfirm = -1;
static gint ett_xnap_RetrieveUEContextFailure = -1;
static gint ett_xnap_XnUAddressIndication = -1;
static gint ett_xnap_SNodeAdditionRequest = -1;
static gint ett_xnap_PDUSessionToBeAddedAddReq = -1;
static gint ett_xnap_PDUSessionToBeAddedAddReq_Item = -1;
static gint ett_xnap_SNodeAdditionRequestAcknowledge = -1;
static gint ett_xnap_PDUSessionAdmittedAddedAddReqAck = -1;
static gint ett_xnap_PDUSessionAdmittedAddedAddReqAck_Item = -1;
static gint ett_xnap_PDUSessionNotAdmittedAddReqAck = -1;
static gint ett_xnap_SNodeAdditionRequestReject = -1;
static gint ett_xnap_SNodeReconfigurationComplete = -1;
static gint ett_xnap_ResponseInfo_ReconfCompl = -1;
static gint ett_xnap_ResponseType_ReconfComplete = -1;
static gint ett_xnap_Configuration_successfully_applied = -1;
static gint ett_xnap_Configuration_rejected_by_M_NG_RANNode = -1;
static gint ett_xnap_SNodeModificationRequest = -1;
static gint ett_xnap_UEContextInfo_SNModRequest = -1;
static gint ett_xnap_PDUSessionsToBeAdded_SNModRequest_List = -1;
static gint ett_xnap_PDUSessionsToBeAdded_SNModRequest_Item = -1;
static gint ett_xnap_PDUSessionsToBeModified_SNModRequest_List = -1;
static gint ett_xnap_PDUSessionsToBeModified_SNModRequest_Item = -1;
static gint ett_xnap_PDUSessionsToBeReleased_SNModRequest_List = -1;
static gint ett_xnap_SNodeModificationRequestAcknowledge = -1;
static gint ett_xnap_PDUSessionAdmitted_SNModResponse = -1;
static gint ett_xnap_PDUSessionAdmittedToBeAddedSNModResponse = -1;
static gint ett_xnap_PDUSessionAdmittedToBeAddedSNModResponse_Item = -1;
static gint ett_xnap_PDUSessionAdmittedToBeModifiedSNModResponse = -1;
static gint ett_xnap_PDUSessionAdmittedToBeModifiedSNModResponse_Item = -1;
static gint ett_xnap_PDUSessionAdmittedToBeReleasedSNModResponse = -1;
static gint ett_xnap_PDUSessionNotAdmitted_SNModResponse = -1;
static gint ett_xnap_PDUSessionDataForwarding_SNModResponse = -1;
static gint ett_xnap_SNodeModificationRequestReject = -1;
static gint ett_xnap_SNodeModificationRequired = -1;
static gint ett_xnap_PDUSessionToBeModifiedSNModRequired = -1;
static gint ett_xnap_PDUSessionToBeModifiedSNModRequired_Item = -1;
static gint ett_xnap_PDUSessionToBeReleasedSNModRequired = -1;
static gint ett_xnap_SNodeModificationConfirm = -1;
static gint ett_xnap_PDUSessionAdmittedModSNModConfirm = -1;
static gint ett_xnap_PDUSessionAdmittedModSNModConfirm_Item = -1;
static gint ett_xnap_PDUSessionReleasedSNModConfirm = -1;
static gint ett_xnap_SNodeModificationRefuse = -1;
static gint ett_xnap_SNodeReleaseRequest = -1;
static gint ett_xnap_SNodeReleaseRequestAcknowledge = -1;
static gint ett_xnap_PDUSessionToBeReleasedList_RelReqAck = -1;
static gint ett_xnap_SNodeReleaseReject = -1;
static gint ett_xnap_SNodeReleaseRequired = -1;
static gint ett_xnap_PDUSessionToBeReleasedList_RelRqd = -1;
static gint ett_xnap_SNodeReleaseConfirm = -1;
static gint ett_xnap_PDUSessionReleasedList_RelConf = -1;
static gint ett_xnap_SNodeCounterCheckRequest = -1;
static gint ett_xnap_BearersSubjectToCounterCheck_List = -1;
static gint ett_xnap_BearersSubjectToCounterCheck_Item = -1;
static gint ett_xnap_SNodeChangeRequired = -1;
static gint ett_xnap_PDUSession_SNChangeRequired_List = -1;
static gint ett_xnap_PDUSession_SNChangeRequired_Item = -1;
static gint ett_xnap_SNodeChangeConfirm = -1;
static gint ett_xnap_PDUSession_SNChangeConfirm_List = -1;
static gint ett_xnap_PDUSession_SNChangeConfirm_Item = -1;
static gint ett_xnap_SNodeChangeRefuse = -1;
static gint ett_xnap_RRCTransfer = -1;
static gint ett_xnap_SplitSRB_RRCTransfer = -1;
static gint ett_xnap_UEReportRRCTransfer = -1;
static gint ett_xnap_FastMCGRecoveryRRCTransfer = -1;
static gint ett_xnap_SDT_SRB_between_NewNode_OldNode = -1;
static gint ett_xnap_NotificationControlIndication = -1;
static gint ett_xnap_PDUSessionResourcesNotifyList = -1;
static gint ett_xnap_PDUSessionResourcesNotify_Item = -1;
static gint ett_xnap_ActivityNotification = -1;
static gint ett_xnap_PDUSessionResourcesActivityNotifyList = -1;
static gint ett_xnap_PDUSessionResourcesActivityNotify_Item = -1;
static gint ett_xnap_QoSFlowsActivityNotifyList = -1;
static gint ett_xnap_QoSFlowsActivityNotifyItem = -1;
static gint ett_xnap_XnSetupRequest = -1;
static gint ett_xnap_XnSetupResponse = -1;
static gint ett_xnap_XnSetupFailure = -1;
static gint ett_xnap_NGRANNodeConfigurationUpdate = -1;
static gint ett_xnap_ConfigurationUpdateInitiatingNodeChoice = -1;
static gint ett_xnap_NGRANNodeConfigurationUpdateAcknowledge = -1;
static gint ett_xnap_RespondingNodeTypeConfigUpdateAck = -1;
static gint ett_xnap_RespondingNodeTypeConfigUpdateAck_ng_eNB = -1;
static gint ett_xnap_RespondingNodeTypeConfigUpdateAck_gNB = -1;
static gint ett_xnap_NGRANNodeConfigurationUpdateFailure = -1;
static gint ett_xnap_E_UTRA_NR_CellResourceCoordinationRequest = -1;
static gint ett_xnap_InitiatingNodeType_ResourceCoordRequest = -1;
static gint ett_xnap_ResourceCoordRequest_ng_eNB_initiated = -1;
static gint ett_xnap_ResourceCoordRequest_gNB_initiated = -1;
static gint ett_xnap_E_UTRA_NR_CellResourceCoordinationResponse = -1;
static gint ett_xnap_RespondingNodeType_ResourceCoordResponse = -1;
static gint ett_xnap_ResourceCoordResponse_ng_eNB_initiated = -1;
static gint ett_xnap_ResourceCoordResponse_gNB_initiated = -1;
static gint ett_xnap_SecondaryRATDataUsageReport = -1;
static gint ett_xnap_XnRemovalRequest = -1;
static gint ett_xnap_XnRemovalResponse = -1;
static gint ett_xnap_XnRemovalFailure = -1;
static gint ett_xnap_CellActivationRequest = -1;
static gint ett_xnap_ServedCellsToActivate = -1;
static gint ett_xnap_CellActivationResponse = -1;
static gint ett_xnap_ActivatedServedCells = -1;
static gint ett_xnap_CellActivationFailure = -1;
static gint ett_xnap_ResetRequest = -1;
static gint ett_xnap_ResetResponse = -1;
static gint ett_xnap_ErrorIndication = -1;
static gint ett_xnap_PrivateMessage = -1;
static gint ett_xnap_TraceStart = -1;
static gint ett_xnap_DeactivateTrace = -1;
static gint ett_xnap_FailureIndication = -1;
static gint ett_xnap_HandoverReport = -1;
static gint ett_xnap_ResourceStatusRequest = -1;
static gint ett_xnap_ResourceStatusResponse = -1;
static gint ett_xnap_ResourceStatusFailure = -1;
static gint ett_xnap_ResourceStatusUpdate = -1;
static gint ett_xnap_MobilityChangeRequest = -1;
static gint ett_xnap_MobilityChangeAcknowledge = -1;
static gint ett_xnap_MobilityChangeFailure = -1;
static gint ett_xnap_AccessAndMobilityIndication = -1;
static gint ett_xnap_CellTrafficTrace = -1;
static gint ett_xnap_RANMulticastGroupPaging = -1;
static gint ett_xnap_ScgFailureInformationReport = -1;
static gint ett_xnap_ScgFailureTransfer = -1;
static gint ett_xnap_F1CTrafficTransfer = -1;
static gint ett_xnap_IABTransportMigrationManagementRequest = -1;
static gint ett_xnap_TrafficToBeAddedList = -1;
static gint ett_xnap_TrafficToBeAdded_Item = -1;
static gint ett_xnap_TrafficToBeModifiedList = -1;
static gint ett_xnap_TrafficToBeModified_Item = -1;
static gint ett_xnap_IABTransportMigrationManagementResponse = -1;
static gint ett_xnap_TrafficAddedList = -1;
static gint ett_xnap_TrafficAdded_Item = -1;
static gint ett_xnap_TrafficModifiedList = -1;
static gint ett_xnap_TrafficModified_Item = -1;
static gint ett_xnap_TrafficNotAddedList = -1;
static gint ett_xnap_TrafficNotAdded_Item = -1;
static gint ett_xnap_TrafficNotModifiedList = -1;
static gint ett_xnap_TrafficNotModified_Item = -1;
static gint ett_xnap_TrafficReleasedList = -1;
static gint ett_xnap_TrafficReleased_Item = -1;
static gint ett_xnap_IABTransportMigrationManagementReject = -1;
static gint ett_xnap_IABTransportMigrationModificationRequest = -1;
static gint ett_xnap_TrafficRequiredToBeModifiedList = -1;
static gint ett_xnap_TrafficRequiredToBeModified_Item = -1;
static gint ett_xnap_IABTNLAddressToBeReleasedList = -1;
static gint ett_xnap_IABTNLAddressToBeReleased_Item = -1;
static gint ett_xnap_IABTransportMigrationModificationResponse = -1;
static gint ett_xnap_TrafficRequiredModifiedList = -1;
static gint ett_xnap_TrafficRequiredModified_Item = -1;
static gint ett_xnap_IABResourceCoordinationRequest = -1;
static gint ett_xnap_BoundaryNodeCellsList = -1;
static gint ett_xnap_BoundaryNodeCellsList_Item = -1;
static gint ett_xnap_ParentNodeCellsList = -1;
static gint ett_xnap_ParentNodeCellsList_Item = -1;
static gint ett_xnap_IABResourceCoordinationResponse = -1;
static gint ett_xnap_CPCCancel = -1;
static gint ett_xnap_PartialUEContextTransfer = -1;
static gint ett_xnap_PartialUEContextTransferAcknowledge = -1;
static gint ett_xnap_PartialUEContextTransferFailure = -1;
static gint ett_xnap_XnAP_PDU = -1;
static gint ett_xnap_InitiatingMessage = -1;
static gint ett_xnap_SuccessfulOutcome = -1;
static gint ett_xnap_UnsuccessfulOutcome = -1;

enum {
  XNAP_NG_RAN_CONTAINER_AUTOMATIC,
  XNAP_NG_RAN_CONTAINER_GNB,
  XNAP_NG_RAN_CONTAINER_NG_ENB
};

static const enum_val_t xnap_target_ng_ran_container_vals[] = {
  {"automatic", "automatic", XNAP_NG_RAN_CONTAINER_AUTOMATIC},
  {"gnb", "gNB", XNAP_NG_RAN_CONTAINER_GNB},
  {"ng-enb","ng-eNB", XNAP_NG_RAN_CONTAINER_NG_ENB},
  {NULL, NULL, -1}
};

enum {
  XNAP_LTE_RRC_CONTEXT_LTE,
  XNAP_LTE_RRC_CONTEXT_NBIOT
};

static const enum_val_t xnap_lte_rrc_context_vals[] = {
  {"lte", "LTE", XNAP_LTE_RRC_CONTEXT_LTE},
  {"nb-iot","NB-IoT", XNAP_LTE_RRC_CONTEXT_NBIOT},
  {NULL, NULL, -1}
};

/* Global variables */
static gint xnap_dissect_target_ng_ran_container_as = XNAP_NG_RAN_CONTAINER_AUTOMATIC;
static gint xnap_dissect_lte_rrc_context_as = XNAP_LTE_RRC_CONTEXT_LTE;

/* Dissector tables */
static dissector_table_t xnap_ies_dissector_table;
static dissector_table_t xnap_extension_dissector_table;
static dissector_table_t xnap_proc_imsg_dissector_table;
static dissector_table_t xnap_proc_sout_dissector_table;
static dissector_table_t xnap_proc_uout_dissector_table;

void proto_register_xnap(void);
void proto_reg_handoff_xnap(void);
static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_XnAP_PDU_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static dissector_handle_t xnap_handle;

static void
xnap_PacketLossRate_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1f%% (%u)", (float)v/10, v);
}

static void
xnap_PacketDelayBudget_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
xnap_ExtendedPacketDelayBudget_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.2fms (%u)", (float)v/100, v);
}

static void
xnap_handoverTriggerChange_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%d)", ((float)v)/2, (gint32)v);
}

static void
xnap_Threshold_RSRP_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%ddBm (%u)", (gint32)v-156, v);
}

static void
xnap_Threshold_RSRQ_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-43, v);
}

static void
xnap_Threshold_SINR_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB (%u)", ((float)v/2)-23, v);
}

static const true_false_string xnap_tfs_activate_do_not_activate = {
  "Activate",
  "Do not activate"
};

typedef enum {
  INITIATING_MESSAGE,
  SUCCESSFUL_OUTCOME,
  UNSUCCESSFUL_OUTCOME
} xnap_message_type;

struct xnap_conv_info {
  address addr_a;
  guint32 port_a;
  GlobalNG_RANNode_ID_enum ranmode_id_a;
  address addr_b;
  guint32 port_b;
  GlobalNG_RANNode_ID_enum ranmode_id_b;
};

struct xnap_private_data {
  struct xnap_conv_info *xnap_conv;
  xnap_message_type message_type;
  guint32 procedure_code;
  guint32 protocol_ie_id;
  e212_number_type_t number_type;
};

static struct xnap_private_data*
xnap_get_private_data(packet_info *pinfo)
{
  struct xnap_private_data *xnap_data = (struct xnap_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_xnap, 0);
  if (!xnap_data) {
    xnap_data = wmem_new0(pinfo->pool, struct xnap_private_data);
    p_add_proto_data(pinfo->pool, pinfo, proto_xnap, 0, xnap_data);
  }
  return xnap_data;
}

static GlobalNG_RANNode_ID_enum
xnap_get_ranmode_id(address *addr, guint32 port, packet_info *pinfo)
{
  struct xnap_private_data *xnap_data = xnap_get_private_data(pinfo);
  GlobalNG_RANNode_ID_enum ranmode_id = (GlobalNG_RANNode_ID_enum)-1;

  if (xnap_data->xnap_conv) {
    if (addresses_equal(addr, &xnap_data->xnap_conv->addr_a) && port == xnap_data->xnap_conv->port_a) {
      ranmode_id = xnap_data->xnap_conv->ranmode_id_a;
    } else if (addresses_equal(addr, &xnap_data->xnap_conv->addr_b) && port == xnap_data->xnap_conv->port_b) {
      ranmode_id = xnap_data->xnap_conv->ranmode_id_b;
    }
  }
  return ranmode_id;
}


static const value_string xnap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_xnap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxPrivateIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPrivateIEs, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string xnap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_xnap_local          , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_maxPrivateIEs },
  {   1, &hf_xnap_global         , ASN1_NO_EXTENSIONS     , dissect_xnap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_ProcedureCode_vals[] = {
  { id_handoverPreparation, "id-handoverPreparation" },
  { id_sNStatusTransfer, "id-sNStatusTransfer" },
  { id_handoverCancel, "id-handoverCancel" },
  { id_retrieveUEContext, "id-retrieveUEContext" },
  { id_rANPaging, "id-rANPaging" },
  { id_xnUAddressIndication, "id-xnUAddressIndication" },
  { id_uEContextRelease, "id-uEContextRelease" },
  { id_sNGRANnodeAdditionPreparation, "id-sNGRANnodeAdditionPreparation" },
  { id_sNGRANnodeReconfigurationCompletion, "id-sNGRANnodeReconfigurationCompletion" },
  { id_mNGRANnodeinitiatedSNGRANnodeModificationPreparation, "id-mNGRANnodeinitiatedSNGRANnodeModificationPreparation" },
  { id_sNGRANnodeinitiatedSNGRANnodeModificationPreparation, "id-sNGRANnodeinitiatedSNGRANnodeModificationPreparation" },
  { id_mNGRANnodeinitiatedSNGRANnodeRelease, "id-mNGRANnodeinitiatedSNGRANnodeRelease" },
  { id_sNGRANnodeinitiatedSNGRANnodeRelease, "id-sNGRANnodeinitiatedSNGRANnodeRelease" },
  { id_sNGRANnodeCounterCheck, "id-sNGRANnodeCounterCheck" },
  { id_sNGRANnodeChange, "id-sNGRANnodeChange" },
  { id_rRCTransfer, "id-rRCTransfer" },
  { id_xnRemoval, "id-xnRemoval" },
  { id_xnSetup, "id-xnSetup" },
  { id_nGRANnodeConfigurationUpdate, "id-nGRANnodeConfigurationUpdate" },
  { id_cellActivation, "id-cellActivation" },
  { id_reset, "id-reset" },
  { id_errorIndication, "id-errorIndication" },
  { id_privateMessage, "id-privateMessage" },
  { id_notificationControl, "id-notificationControl" },
  { id_activityNotification, "id-activityNotification" },
  { id_e_UTRA_NR_CellResourceCoordination, "id-e-UTRA-NR-CellResourceCoordination" },
  { id_secondaryRATDataUsageReport, "id-secondaryRATDataUsageReport" },
  { id_deactivateTrace, "id-deactivateTrace" },
  { id_traceStart, "id-traceStart" },
  { id_handoverSuccess, "id-handoverSuccess" },
  { id_conditionalHandoverCancel, "id-conditionalHandoverCancel" },
  { id_earlyStatusTransfer, "id-earlyStatusTransfer" },
  { id_failureIndication, "id-failureIndication" },
  { id_handoverReport, "id-handoverReport" },
  { id_resourceStatusReportingInitiation, "id-resourceStatusReportingInitiation" },
  { id_resourceStatusReporting, "id-resourceStatusReporting" },
  { id_mobilitySettingsChange, "id-mobilitySettingsChange" },
  { id_accessAndMobilityIndication, "id-accessAndMobilityIndication" },
  { id_cellTrafficTrace, "id-cellTrafficTrace" },
  { id_RANMulticastGroupPaging, "id-RANMulticastGroupPaging" },
  { id_scgFailureInformationReport, "id-scgFailureInformationReport" },
  { id_ProcedureCode41_NotToBeUsed, "id-ProcedureCode41-NotToBeUsed" },
  { id_scgFailureTransfer, "id-scgFailureTransfer" },
  { id_f1CTrafficTransfer, "id-f1CTrafficTransfer" },
  { id_iABTransportMigrationManagement, "id-iABTransportMigrationManagement" },
  { id_iABTransportMigrationModification, "id-iABTransportMigrationModification" },
  { id_iABResourceCoordination, "id-iABResourceCoordination" },
  { id_retrieveUEContextConfirm, "id-retrieveUEContextConfirm" },
  { id_cPCCancel, "id-cPCCancel" },
  { id_partialUEContextTransfer, "id-partialUEContextTransfer" },
  { 0, NULL }
};

static value_string_ext xnap_ProcedureCode_vals_ext = VALUE_STRING_EXT_INIT(xnap_ProcedureCode_vals);


static int
dissect_xnap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &xnap_data->procedure_code, FALSE);



  return offset;
}


static const value_string xnap_ProtocolIE_ID_vals[] = {
  { id_ActivatedServedCells, "id-ActivatedServedCells" },
  { id_ActivationIDforCellActivation, "id-ActivationIDforCellActivation" },
  { id_admittedSplitSRB, "id-admittedSplitSRB" },
  { id_admittedSplitSRBrelease, "id-admittedSplitSRBrelease" },
  { id_AMF_Region_Information, "id-AMF-Region-Information" },
  { id_AssistanceDataForRANPaging, "id-AssistanceDataForRANPaging" },
  { id_BearersSubjectToCounterCheck, "id-BearersSubjectToCounterCheck" },
  { id_Cause, "id-Cause" },
  { id_cellAssistanceInfo_NR, "id-cellAssistanceInfo-NR" },
  { id_ConfigurationUpdateInitiatingNodeChoice, "id-ConfigurationUpdateInitiatingNodeChoice" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_XnUAddressInfoperPDUSession_List, "id-XnUAddressInfoperPDUSession-List" },
  { id_DRBsSubjectToStatusTransfer_List, "id-DRBsSubjectToStatusTransfer-List" },
  { id_ExpectedUEBehaviour, "id-ExpectedUEBehaviour" },
  { id_GlobalNG_RAN_node_ID, "id-GlobalNG-RAN-node-ID" },
  { id_GUAMI, "id-GUAMI" },
  { id_indexToRatFrequSelectionPriority, "id-indexToRatFrequSelectionPriority" },
  { id_initiatingNodeType_ResourceCoordRequest, "id-initiatingNodeType-ResourceCoordRequest" },
  { id_List_of_served_cells_E_UTRA, "id-List-of-served-cells-E-UTRA" },
  { id_List_of_served_cells_NR, "id-List-of-served-cells-NR" },
  { id_LocationReportingInformation, "id-LocationReportingInformation" },
  { id_MAC_I, "id-MAC-I" },
  { id_MaskedIMEISV, "id-MaskedIMEISV" },
  { id_M_NG_RANnodeUEXnAPID, "id-M-NG-RANnodeUEXnAPID" },
  { id_MN_to_SN_Container, "id-MN-to-SN-Container" },
  { id_MobilityRestrictionList, "id-MobilityRestrictionList" },
  { id_new_NG_RAN_Cell_Identity, "id-new-NG-RAN-Cell-Identity" },
  { id_newNG_RANnodeUEXnAPID, "id-newNG-RANnodeUEXnAPID" },
  { id_UEReportRRCTransfer, "id-UEReportRRCTransfer" },
  { id_oldNG_RANnodeUEXnAPID, "id-oldNG-RANnodeUEXnAPID" },
  { id_OldtoNewNG_RANnodeResumeContainer, "id-OldtoNewNG-RANnodeResumeContainer" },
  { id_PagingDRX, "id-PagingDRX" },
  { id_PCellID, "id-PCellID" },
  { id_PDCPChangeIndication, "id-PDCPChangeIndication" },
  { id_PDUSessionAdmittedAddedAddReqAck, "id-PDUSessionAdmittedAddedAddReqAck" },
  { id_PDUSessionAdmittedModSNModConfirm, "id-PDUSessionAdmittedModSNModConfirm" },
  { id_PDUSessionAdmitted_SNModResponse, "id-PDUSessionAdmitted-SNModResponse" },
  { id_PDUSessionNotAdmittedAddReqAck, "id-PDUSessionNotAdmittedAddReqAck" },
  { id_PDUSessionNotAdmitted_SNModResponse, "id-PDUSessionNotAdmitted-SNModResponse" },
  { id_PDUSessionReleasedList_RelConf, "id-PDUSessionReleasedList-RelConf" },
  { id_PDUSessionReleasedSNModConfirm, "id-PDUSessionReleasedSNModConfirm" },
  { id_PDUSessionResourcesActivityNotifyList, "id-PDUSessionResourcesActivityNotifyList" },
  { id_PDUSessionResourcesAdmitted_List, "id-PDUSessionResourcesAdmitted-List" },
  { id_PDUSessionResourcesNotAdmitted_List, "id-PDUSessionResourcesNotAdmitted-List" },
  { id_PDUSessionResourcesNotifyList, "id-PDUSessionResourcesNotifyList" },
  { id_PDUSession_SNChangeConfirm_List, "id-PDUSession-SNChangeConfirm-List" },
  { id_PDUSession_SNChangeRequired_List, "id-PDUSession-SNChangeRequired-List" },
  { id_PDUSessionToBeAddedAddReq, "id-PDUSessionToBeAddedAddReq" },
  { id_PDUSessionToBeModifiedSNModRequired, "id-PDUSessionToBeModifiedSNModRequired" },
  { id_PDUSessionToBeReleasedList_RelRqd, "id-PDUSessionToBeReleasedList-RelRqd" },
  { id_PDUSessionToBeReleased_RelReq, "id-PDUSessionToBeReleased-RelReq" },
  { id_PDUSessionToBeReleasedSNModRequired, "id-PDUSessionToBeReleasedSNModRequired" },
  { id_RANPagingArea, "id-RANPagingArea" },
  { id_PagingPriority, "id-PagingPriority" },
  { id_requestedSplitSRB, "id-requestedSplitSRB" },
  { id_requestedSplitSRBrelease, "id-requestedSplitSRBrelease" },
  { id_ResetRequestTypeInfo, "id-ResetRequestTypeInfo" },
  { id_ResetResponseTypeInfo, "id-ResetResponseTypeInfo" },
  { id_RespondingNodeTypeConfigUpdateAck, "id-RespondingNodeTypeConfigUpdateAck" },
  { id_respondingNodeType_ResourceCoordResponse, "id-respondingNodeType-ResourceCoordResponse" },
  { id_ResponseInfo_ReconfCompl, "id-ResponseInfo-ReconfCompl" },
  { id_RRCConfigIndication, "id-RRCConfigIndication" },
  { id_RRCResumeCause, "id-RRCResumeCause" },
  { id_SCGConfigurationQuery, "id-SCGConfigurationQuery" },
  { id_selectedPLMN, "id-selectedPLMN" },
  { id_ServedCellsToActivate, "id-ServedCellsToActivate" },
  { id_servedCellsToUpdate_E_UTRA, "id-servedCellsToUpdate-E-UTRA" },
  { id_ServedCellsToUpdateInitiatingNodeChoice, "id-ServedCellsToUpdateInitiatingNodeChoice" },
  { id_servedCellsToUpdate_NR, "id-servedCellsToUpdate-NR" },
  { id_s_ng_RANnode_SecurityKey, "id-s-ng-RANnode-SecurityKey" },
  { id_S_NG_RANnodeUE_AMBR, "id-S-NG-RANnodeUE-AMBR" },
  { id_S_NG_RANnodeUEXnAPID, "id-S-NG-RANnodeUEXnAPID" },
  { id_SN_to_MN_Container, "id-SN-to-MN-Container" },
  { id_sourceNG_RANnodeUEXnAPID, "id-sourceNG-RANnodeUEXnAPID" },
  { id_SplitSRB_RRCTransfer, "id-SplitSRB-RRCTransfer" },
  { id_TAISupport_list, "id-TAISupport-list" },
  { id_TimeToWait, "id-TimeToWait" },
  { id_Target2SourceNG_RANnodeTranspContainer, "id-Target2SourceNG-RANnodeTranspContainer" },
  { id_targetCellGlobalID, "id-targetCellGlobalID" },
  { id_targetNG_RANnodeUEXnAPID, "id-targetNG-RANnodeUEXnAPID" },
  { id_target_S_NG_RANnodeID, "id-target-S-NG-RANnodeID" },
  { id_TraceActivation, "id-TraceActivation" },
  { id_UEContextID, "id-UEContextID" },
  { id_UEContextInfoHORequest, "id-UEContextInfoHORequest" },
  { id_UEContextInfoRetrUECtxtResp, "id-UEContextInfoRetrUECtxtResp" },
  { id_UEContextInfo_SNModRequest, "id-UEContextInfo-SNModRequest" },
  { id_UEContextKeptIndicator, "id-UEContextKeptIndicator" },
  { id_UEContextRefAtSN_HORequest, "id-UEContextRefAtSN-HORequest" },
  { id_UEHistoryInformation, "id-UEHistoryInformation" },
  { id_UEIdentityIndexValue, "id-UEIdentityIndexValue" },
  { id_UERANPagingIdentity, "id-UERANPagingIdentity" },
  { id_UESecurityCapabilities, "id-UESecurityCapabilities" },
  { id_UserPlaneTrafficActivityReport, "id-UserPlaneTrafficActivityReport" },
  { id_XnRemovalThreshold, "id-XnRemovalThreshold" },
  { id_DesiredActNotificationLevel, "id-DesiredActNotificationLevel" },
  { id_AvailableDRBIDs, "id-AvailableDRBIDs" },
  { id_AdditionalDRBIDs, "id-AdditionalDRBIDs" },
  { id_SpareDRBIDs, "id-SpareDRBIDs" },
  { id_RequiredNumberOfDRBIDs, "id-RequiredNumberOfDRBIDs" },
  { id_TNLA_To_Add_List, "id-TNLA-To-Add-List" },
  { id_TNLA_To_Update_List, "id-TNLA-To-Update-List" },
  { id_TNLA_To_Remove_List, "id-TNLA-To-Remove-List" },
  { id_TNLA_Setup_List, "id-TNLA-Setup-List" },
  { id_TNLA_Failed_To_Setup_List, "id-TNLA-Failed-To-Setup-List" },
  { id_PDUSessionToBeReleased_RelReqAck, "id-PDUSessionToBeReleased-RelReqAck" },
  { id_S_NG_RANnodeMaxIPDataRate_UL, "id-S-NG-RANnodeMaxIPDataRate-UL" },
  { id_Unknown_106, "id-Unknown-106" },
  { id_PDUSessionResourceSecondaryRATUsageList, "id-PDUSessionResourceSecondaryRATUsageList" },
  { id_Additional_UL_NG_U_TNLatUPF_List, "id-Additional-UL-NG-U-TNLatUPF-List" },
  { id_SecondarydataForwardingInfoFromTarget_List, "id-SecondarydataForwardingInfoFromTarget-List" },
  { id_LocationInformationSNReporting, "id-LocationInformationSNReporting" },
  { id_LocationInformationSN, "id-LocationInformationSN" },
  { id_LastE_UTRANPLMNIdentity, "id-LastE-UTRANPLMNIdentity" },
  { id_S_NG_RANnodeMaxIPDataRate_DL, "id-S-NG-RANnodeMaxIPDataRate-DL" },
  { id_MaxIPrate_DL, "id-MaxIPrate-DL" },
  { id_SecurityResult, "id-SecurityResult" },
  { id_S_NSSAI, "id-S-NSSAI" },
  { id_MR_DC_ResourceCoordinationInfo, "id-MR-DC-ResourceCoordinationInfo" },
  { id_AMF_Region_Information_To_Add, "id-AMF-Region-Information-To-Add" },
  { id_AMF_Region_Information_To_Delete, "id-AMF-Region-Information-To-Delete" },
  { id_OldQoSFlowMap_ULendmarkerexpected, "id-OldQoSFlowMap-ULendmarkerexpected" },
  { id_RANPagingFailure, "id-RANPagingFailure" },
  { id_UERadioCapabilityForPaging, "id-UERadioCapabilityForPaging" },
  { id_PDUSessionDataForwarding_SNModResponse, "id-PDUSessionDataForwarding-SNModResponse" },
  { id_DRBsNotAdmittedSetupModifyList, "id-DRBsNotAdmittedSetupModifyList" },
  { id_Secondary_MN_Xn_U_TNLInfoatM, "id-Secondary-MN-Xn-U-TNLInfoatM" },
  { id_NE_DC_TDM_Pattern, "id-NE-DC-TDM-Pattern" },
  { id_PDUSessionCommonNetworkInstance, "id-PDUSessionCommonNetworkInstance" },
  { id_BPLMN_ID_Info_EUTRA, "id-BPLMN-ID-Info-EUTRA" },
  { id_BPLMN_ID_Info_NR, "id-BPLMN-ID-Info-NR" },
  { id_InterfaceInstanceIndication, "id-InterfaceInstanceIndication" },
  { id_S_NG_RANnode_Addition_Trigger_Ind, "id-S-NG-RANnode-Addition-Trigger-Ind" },
  { id_DefaultDRB_Allowed, "id-DefaultDRB-Allowed" },
  { id_DRB_IDs_takenintouse, "id-DRB-IDs-takenintouse" },
  { id_SplitSessionIndicator, "id-SplitSessionIndicator" },
  { id_CNTypeRestrictionsForEquivalent, "id-CNTypeRestrictionsForEquivalent" },
  { id_CNTypeRestrictionsForServing, "id-CNTypeRestrictionsForServing" },
  { id_DRBs_transferred_to_MN, "id-DRBs-transferred-to-MN" },
  { id_ULForwardingProposal, "id-ULForwardingProposal" },
  { id_EndpointIPAddressAndPort, "id-EndpointIPAddressAndPort" },
  { id_IntendedTDD_DL_ULConfiguration_NR, "id-IntendedTDD-DL-ULConfiguration-NR" },
  { id_TNLConfigurationInfo, "id-TNLConfigurationInfo" },
  { id_PartialListIndicator_NR, "id-PartialListIndicator-NR" },
  { id_MessageOversizeNotification, "id-MessageOversizeNotification" },
  { id_CellAndCapacityAssistanceInfo_NR, "id-CellAndCapacityAssistanceInfo-NR" },
  { id_NG_RANTraceID, "id-NG-RANTraceID" },
  { id_NonGBRResources_Offered, "id-NonGBRResources-Offered" },
  { id_FastMCGRecoveryRRCTransfer_SN_to_MN, "id-FastMCGRecoveryRRCTransfer-SN-to-MN" },
  { id_RequestedFastMCGRecoveryViaSRB3, "id-RequestedFastMCGRecoveryViaSRB3" },
  { id_AvailableFastMCGRecoveryViaSRB3, "id-AvailableFastMCGRecoveryViaSRB3" },
  { id_RequestedFastMCGRecoveryViaSRB3Release, "id-RequestedFastMCGRecoveryViaSRB3Release" },
  { id_ReleaseFastMCGRecoveryViaSRB3, "id-ReleaseFastMCGRecoveryViaSRB3" },
  { id_FastMCGRecoveryRRCTransfer_MN_to_SN, "id-FastMCGRecoveryRRCTransfer-MN-to-SN" },
  { id_ExtendedRATRestrictionInformation, "id-ExtendedRATRestrictionInformation" },
  { id_QoSMonitoringRequest, "id-QoSMonitoringRequest" },
  { id_FiveGCMobilityRestrictionListContainer, "id-FiveGCMobilityRestrictionListContainer" },
  { id_PartialListIndicator_EUTRA, "id-PartialListIndicator-EUTRA" },
  { id_CellAndCapacityAssistanceInfo_EUTRA, "id-CellAndCapacityAssistanceInfo-EUTRA" },
  { id_CHOinformation_Req, "id-CHOinformation-Req" },
  { id_CHOinformation_Ack, "id-CHOinformation-Ack" },
  { id_targetCellsToCancel, "id-targetCellsToCancel" },
  { id_requestedTargetCellGlobalID, "id-requestedTargetCellGlobalID" },
  { id_procedureStage, "id-procedureStage" },
  { id_DAPSRequestInfo, "id-DAPSRequestInfo" },
  { id_DAPSResponseInfo_List, "id-DAPSResponseInfo-List" },
  { id_CHO_MRDC_Indicator, "id-CHO-MRDC-Indicator" },
  { id_OffsetOfNbiotChannelNumberToDL_EARFCN, "id-OffsetOfNbiotChannelNumberToDL-EARFCN" },
  { id_OffsetOfNbiotChannelNumberToUL_EARFCN, "id-OffsetOfNbiotChannelNumberToUL-EARFCN" },
  { id_NBIoT_UL_DL_AlignmentOffset, "id-NBIoT-UL-DL-AlignmentOffset" },
  { id_LTEV2XServicesAuthorized, "id-LTEV2XServicesAuthorized" },
  { id_NRV2XServicesAuthorized, "id-NRV2XServicesAuthorized" },
  { id_LTEUESidelinkAggregateMaximumBitRate, "id-LTEUESidelinkAggregateMaximumBitRate" },
  { id_NRUESidelinkAggregateMaximumBitRate, "id-NRUESidelinkAggregateMaximumBitRate" },
  { id_PC5QoSParameters, "id-PC5QoSParameters" },
  { id_AlternativeQoSParaSetList, "id-AlternativeQoSParaSetList" },
  { id_CurrentQoSParaSetIndex, "id-CurrentQoSParaSetIndex" },
  { id_MobilityInformation, "id-MobilityInformation" },
  { id_InitiatingCondition_FailureIndication, "id-InitiatingCondition-FailureIndication" },
  { id_UEHistoryInformationFromTheUE, "id-UEHistoryInformationFromTheUE" },
  { id_HandoverReportType, "id-HandoverReportType" },
  { id_HandoverCause, "id-HandoverCause" },
  { id_SourceCellCGI, "id-SourceCellCGI" },
  { id_TargetCellCGI, "id-TargetCellCGI" },
  { id_ReEstablishmentCellCGI, "id-ReEstablishmentCellCGI" },
  { id_TargetCellinEUTRAN, "id-TargetCellinEUTRAN" },
  { id_SourceCellCRNTI, "id-SourceCellCRNTI" },
  { id_UERLFReportContainer, "id-UERLFReportContainer" },
  { id_NGRAN_Node1_Measurement_ID, "id-NGRAN-Node1-Measurement-ID" },
  { id_NGRAN_Node2_Measurement_ID, "id-NGRAN-Node2-Measurement-ID" },
  { id_RegistrationRequest, "id-RegistrationRequest" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_CellToReport, "id-CellToReport" },
  { id_ReportingPeriodicity, "id-ReportingPeriodicity" },
  { id_CellMeasurementResult, "id-CellMeasurementResult" },
  { id_NG_RANnode1CellID, "id-NG-RANnode1CellID" },
  { id_NG_RANnode2CellID, "id-NG-RANnode2CellID" },
  { id_NG_RANnode1MobilityParameters, "id-NG-RANnode1MobilityParameters" },
  { id_NG_RANnode2ProposedMobilityParameters, "id-NG-RANnode2ProposedMobilityParameters" },
  { id_MobilityParametersModificationRange, "id-MobilityParametersModificationRange" },
  { id_TDDULDLConfigurationCommonNR, "id-TDDULDLConfigurationCommonNR" },
  { id_CarrierList, "id-CarrierList" },
  { id_ULCarrierList, "id-ULCarrierList" },
  { id_FrequencyShift7p5khz, "id-FrequencyShift7p5khz" },
  { id_SSB_PositionsInBurst, "id-SSB-PositionsInBurst" },
  { id_NRCellPRACHConfig, "id-NRCellPRACHConfig" },
  { id_RACHReportInformation, "id-RACHReportInformation" },
  { id_IABNodeIndication, "id-IABNodeIndication" },
  { id_Redundant_UL_NG_U_TNLatUPF, "id-Redundant-UL-NG-U-TNLatUPF" },
  { id_CNPacketDelayBudgetDownlink, "id-CNPacketDelayBudgetDownlink" },
  { id_CNPacketDelayBudgetUplink, "id-CNPacketDelayBudgetUplink" },
  { id_Additional_Redundant_UL_NG_U_TNLatUPF_List, "id-Additional-Redundant-UL-NG-U-TNLatUPF-List" },
  { id_RedundantCommonNetworkInstance, "id-RedundantCommonNetworkInstance" },
  { id_TSCTrafficCharacteristics, "id-TSCTrafficCharacteristics" },
  { id_RedundantQoSFlowIndicator, "id-RedundantQoSFlowIndicator" },
  { id_Redundant_DL_NG_U_TNLatNG_RAN, "id-Redundant-DL-NG-U-TNLatNG-RAN" },
  { id_ExtendedPacketDelayBudget, "id-ExtendedPacketDelayBudget" },
  { id_Additional_PDCP_Duplication_TNL_List, "id-Additional-PDCP-Duplication-TNL-List" },
  { id_RedundantPDUSessionInformation, "id-RedundantPDUSessionInformation" },
  { id_UsedRSNInformation, "id-UsedRSNInformation" },
  { id_RLCDuplicationInformation, "id-RLCDuplicationInformation" },
  { id_NPN_Broadcast_Information, "id-NPN-Broadcast-Information" },
  { id_NPNPagingAssistanceInformation, "id-NPNPagingAssistanceInformation" },
  { id_NPNMobilityInformation, "id-NPNMobilityInformation" },
  { id_NPN_Support, "id-NPN-Support" },
  { id_MDT_Configuration, "id-MDT-Configuration" },
  { id_MDTPLMNList, "id-MDTPLMNList" },
  { id_TraceCollectionEntityURI, "id-TraceCollectionEntityURI" },
  { id_UERadioCapabilityID, "id-UERadioCapabilityID" },
  { id_CSI_RSTransmissionIndication, "id-CSI-RSTransmissionIndication" },
  { id_SNTriggered, "id-SNTriggered" },
  { id_DLCarrierList, "id-DLCarrierList" },
  { id_ExtendedTAISliceSupportList, "id-ExtendedTAISliceSupportList" },
  { id_cellAssistanceInfo_EUTRA, "id-cellAssistanceInfo-EUTRA" },
  { id_ConfiguredTACIndication, "id-ConfiguredTACIndication" },
  { id_secondary_SN_UL_PDCP_UP_TNLInfo, "id-secondary-SN-UL-PDCP-UP-TNLInfo" },
  { id_pdcpDuplicationConfiguration, "id-pdcpDuplicationConfiguration" },
  { id_duplicationActivation, "id-duplicationActivation" },
  { id_NPRACHConfiguration, "id-NPRACHConfiguration" },
  { id_QosMonitoringReportingFrequency, "id-QosMonitoringReportingFrequency" },
  { id_QoSFlowsMappedtoDRB_SetupResponse_MNterminated, "id-QoSFlowsMappedtoDRB-SetupResponse-MNterminated" },
  { id_DL_scheduling_PDCCH_CCE_usage, "id-DL-scheduling-PDCCH-CCE-usage" },
  { id_UL_scheduling_PDCCH_CCE_usage, "id-UL-scheduling-PDCCH-CCE-usage" },
  { id_SFN_Offset, "id-SFN-Offset" },
  { id_QoSMonitoringDisabled, "id-QoSMonitoringDisabled" },
  { id_ExtendedUEIdentityIndexValue, "id-ExtendedUEIdentityIndexValue" },
  { id_EUTRAPagingeDRXInformation, "id-EUTRAPagingeDRXInformation" },
  { id_CHO_MRDC_EarlyDataForwarding, "id-CHO-MRDC-EarlyDataForwarding" },
  { id_SCGIndicator, "id-SCGIndicator" },
  { id_UESpecificDRX, "id-UESpecificDRX" },
  { id_PDUSessionExpectedUEActivityBehaviour, "id-PDUSessionExpectedUEActivityBehaviour" },
  { id_QoS_Mapping_Information, "id-QoS-Mapping-Information" },
  { id_AdditionLocationInformation, "id-AdditionLocationInformation" },
  { id_dataForwardingInfoFromTargetE_UTRANnode, "id-dataForwardingInfoFromTargetE-UTRANnode" },
  { id_DirectForwardingPathAvailability, "id-DirectForwardingPathAvailability" },
  { id_SourceNG_RAN_node_ID, "id-SourceNG-RAN-node-ID" },
  { id_SourceDLForwardingIPAddress, "id-SourceDLForwardingIPAddress" },
  { id_SourceNodeDLForwardingIPAddress, "id-SourceNodeDLForwardingIPAddress" },
  { id_ExtendedReportIntervalMDT, "id-ExtendedReportIntervalMDT" },
  { id_SecurityIndication, "id-SecurityIndication" },
  { id_RRCConnReestab_Indicator, "id-RRCConnReestab-Indicator" },
  { id_TargetNodeID, "id-TargetNodeID" },
  { id_ManagementBasedMDTPLMNList, "id-ManagementBasedMDTPLMNList" },
  { id_PrivacyIndicator, "id-PrivacyIndicator" },
  { id_TraceCollectionEntityIPAddress, "id-TraceCollectionEntityIPAddress" },
  { id_M4ReportAmount, "id-M4ReportAmount" },
  { id_M5ReportAmount, "id-M5ReportAmount" },
  { id_M6ReportAmount, "id-M6ReportAmount" },
  { id_M7ReportAmount, "id-M7ReportAmount" },
  { id_BeamMeasurementIndicationM1, "id-BeamMeasurementIndicationM1" },
  { id_MBS_Session_ID, "id-MBS-Session-ID" },
  { id_UEIdentityIndexList_MBSGroupPaging, "id-UEIdentityIndexList-MBSGroupPaging" },
  { id_MulticastRANPagingArea, "id-MulticastRANPagingArea" },
  { id_Supported_MBS_FSA_ID_List, "id-Supported-MBS-FSA-ID-List" },
  { id_MBS_SessionInformation_List, "id-MBS-SessionInformation-List" },
  { id_MBS_SessionInformationResponse_List, "id-MBS-SessionInformationResponse-List" },
  { id_MBS_SessionAssociatedInformation, "id-MBS-SessionAssociatedInformation" },
  { id_SuccessfulHOReportInformation, "id-SuccessfulHOReportInformation" },
  { id_SliceRadioResourceStatus_List, "id-SliceRadioResourceStatus-List" },
  { id_CompositeAvailableCapacitySupplementaryUplink, "id-CompositeAvailableCapacitySupplementaryUplink" },
  { id_SCGUEHistoryInformation, "id-SCGUEHistoryInformation" },
  { id_SSBOffsets_List, "id-SSBOffsets-List" },
  { id_NG_RANnode2SSBOffsetModificationRange, "id-NG-RANnode2SSBOffsetModificationRange" },
  { id_Coverage_Modification_List, "id-Coverage-Modification-List" },
  { id_NR_U_Channel_List, "id-NR-U-Channel-List" },
  { id_SourcePSCellCGI, "id-SourcePSCellCGI" },
  { id_FailedPSCellCGI, "id-FailedPSCellCGI" },
  { id_SCGFailureReportContainer, "id-SCGFailureReportContainer" },
  { id_SNMobilityInformation, "id-SNMobilityInformation" },
  { id_SourcePSCellID, "id-SourcePSCellID" },
  { id_SuitablePSCellCGI, "id-SuitablePSCellCGI" },
  { id_PSCellChangeHistory, "id-PSCellChangeHistory" },
  { id_CHOConfiguration, "id-CHOConfiguration" },
  { id_NR_U_ChannelInfo_List, "id-NR-U-ChannelInfo-List" },
  { id_PSCellHistoryInformationRetrieve, "id-PSCellHistoryInformationRetrieve" },
  { id_NG_RANnode2SSBOffsetsModificationRange, "id-NG-RANnode2SSBOffsetsModificationRange" },
  { id_MIMOPRBusageInformation, "id-MIMOPRBusageInformation" },
  { id_F1CTrafficContainer, "id-F1CTrafficContainer" },
  { id_IAB_MT_Cell_List, "id-IAB-MT-Cell-List" },
  { id_NoPDUSessionIndication, "id-NoPDUSessionIndication" },
  { id_IAB_TNL_Address_Request, "id-IAB-TNL-Address-Request" },
  { id_IAB_TNL_Address_Response, "id-IAB-TNL-Address-Response" },
  { id_TrafficToBeAddedList, "id-TrafficToBeAddedList" },
  { id_TrafficToBeModifiedList, "id-TrafficToBeModifiedList" },
  { id_TrafficToBeReleaseInformation, "id-TrafficToBeReleaseInformation" },
  { id_TrafficAddedList, "id-TrafficAddedList" },
  { id_TrafficModifiedList, "id-TrafficModifiedList" },
  { id_TrafficNotAddedList, "id-TrafficNotAddedList" },
  { id_TrafficNotModifiedList, "id-TrafficNotModifiedList" },
  { id_TrafficRequiredToBeModifiedList, "id-TrafficRequiredToBeModifiedList" },
  { id_TrafficRequiredModifiedList, "id-TrafficRequiredModifiedList" },
  { id_TrafficReleasedList, "id-TrafficReleasedList" },
  { id_IABTNLAddressToBeAdded, "id-IABTNLAddressToBeAdded" },
  { id_IABTNLAddressToBeReleasedList, "id-IABTNLAddressToBeReleasedList" },
  { id_nonF1_Terminating_IAB_DonorUEXnAPID, "id-nonF1-Terminating-IAB-DonorUEXnAPID" },
  { id_F1_Terminating_IAB_DonorUEXnAPID, "id-F1-Terminating-IAB-DonorUEXnAPID" },
  { id_BoundaryNodeCellsList, "id-BoundaryNodeCellsList" },
  { id_ParentNodeCellsList, "id-ParentNodeCellsList" },
  { id_tdd_GNB_DU_Cell_Resource_Configuration, "id-tdd-GNB-DU-Cell-Resource-Configuration" },
  { id_UL_GNB_DU_Cell_Resource_Configuration, "id-UL-GNB-DU-Cell-Resource-Configuration" },
  { id_DL_GNB_DU_Cell_Resource_Configuration, "id-DL-GNB-DU-Cell-Resource-Configuration" },
  { id_permutation, "id-permutation" },
  { id_IABTNLAddressException, "id-IABTNLAddressException" },
  { id_CHOinformation_AddReq, "id-CHOinformation-AddReq" },
  { id_CHOinformation_ModReq, "id-CHOinformation-ModReq" },
  { id_SurvivalTime, "id-SurvivalTime" },
  { id_TimeSynchronizationAssistanceInformation, "id-TimeSynchronizationAssistanceInformation" },
  { id_SCGActivationRequest, "id-SCGActivationRequest" },
  { id_SCGActivationStatus, "id-SCGActivationStatus" },
  { id_CPAInformationRequest, "id-CPAInformationRequest" },
  { id_CPAInformationAck, "id-CPAInformationAck" },
  { id_CPCInformationRequired, "id-CPCInformationRequired" },
  { id_CPCInformationConfirm, "id-CPCInformationConfirm" },
  { id_CPAInformationModReq, "id-CPAInformationModReq" },
  { id_CPAInformationModReqAck, "id-CPAInformationModReqAck" },
  { id_CPC_DataForwarding_Indicator, "id-CPC-DataForwarding-Indicator" },
  { id_CPCInformationUpdate, "id-CPCInformationUpdate" },
  { id_CPACInformationModRequired, "id-CPACInformationModRequired" },
  { id_QMCConfigInfo, "id-QMCConfigInfo" },
  { id_ProtocolIE_ID338_NotToBeUsed, "id-ProtocolIE-ID338-NotToBeUsed" },
  { id_Additional_Measurement_Timing_Configuration_List, "id-Additional-Measurement-Timing-Configuration-List" },
  { id_PDUSession_PairID, "id-PDUSession-PairID" },
  { id_Local_NG_RAN_Node_Identifier, "id-Local-NG-RAN-Node-Identifier" },
  { id_Neighbour_NG_RAN_Node_List, "id-Neighbour-NG-RAN-Node-List" },
  { id_Local_NG_RAN_Node_Identifier_Removal, "id-Local-NG-RAN-Node-Identifier-Removal" },
  { id_FiveGProSeAuthorized, "id-FiveGProSeAuthorized" },
  { id_FiveGProSePC5QoSParameters, "id-FiveGProSePC5QoSParameters" },
  { id_FiveGProSeUEPC5AggregateMaximumBitRate, "id-FiveGProSeUEPC5AggregateMaximumBitRate" },
  { id_ServedCellSpecificInfoReq_NR, "id-ServedCellSpecificInfoReq-NR" },
  { id_NRPagingeDRXInformation, "id-NRPagingeDRXInformation" },
  { id_NRPagingeDRXInformationforRRCINACTIVE, "id-NRPagingeDRXInformationforRRCINACTIVE" },
  { id_Redcap_Bcast_Information, "id-Redcap-Bcast-Information" },
  { id_SDTSupportRequest, "id-SDTSupportRequest" },
  { id_SDT_SRB_between_NewNode_OldNode, "id-SDT-SRB-between-NewNode-OldNode" },
  { id_SDT_Termination_Request, "id-SDT-Termination-Request" },
  { id_SDTPartialUEContextInfo, "id-SDTPartialUEContextInfo" },
  { id_SDTDataForwardingDRBList, "id-SDTDataForwardingDRBList" },
  { id_PagingCause, "id-PagingCause" },
  { id_PEIPSassistanceInformation, "id-PEIPSassistanceInformation" },
  { id_UESliceMaximumBitRateList, "id-UESliceMaximumBitRateList" },
  { id_S_NG_RANnodeUE_Slice_MBR, "id-S-NG-RANnodeUE-Slice-MBR" },
  { id_PositioningInformation, "id-PositioningInformation" },
  { id_UEAssistantIdentifier, "id-UEAssistantIdentifier" },
  { id_ManagementBasedMDTPLMNModificationList, "id-ManagementBasedMDTPLMNModificationList" },
  { id_F1_terminatingIAB_donorIndicator, "id-F1-terminatingIAB-donorIndicator" },
  { id_TAINSAGSupportList, "id-TAINSAGSupportList" },
  { id_SCGreconfigNotification, "id-SCGreconfigNotification" },
  { id_earlyMeasurement, "id-earlyMeasurement" },
  { id_BeamMeasurementsReportConfiguration, "id-BeamMeasurementsReportConfiguration" },
  { id_CoverageModificationCause, "id-CoverageModificationCause" },
  { id_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated, "id-AdditionalListofPDUSessionResourceChangeConfirmInfo-SNterminated" },
  { id_UERLFReportContainerLTEExtension, "id-UERLFReportContainerLTEExtension" },
  { id_ExcessPacketDelayThresholdConfiguration, "id-ExcessPacketDelayThresholdConfiguration" },
  { id_HashedUEIdentityIndexValue, "id-HashedUEIdentityIndexValue" },
  { 0, NULL }
};

static value_string_ext xnap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(xnap_ProtocolIE_ID_vals);


static int
dissect_xnap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxProtocolIEs, &xnap_data->protocol_ie_id, FALSE);


  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s", val_to_str_ext(xnap_data->protocol_ie_id, &xnap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }
  return offset;
}


static const value_string xnap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessful-outcome" },
  { 0, NULL }
};


static int
dissect_xnap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_xnap_ProtocolIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_xnap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_protocolIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_xnap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_Field },
};

static int
dissect_xnap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, FALSE);

  return offset;
}



static int
dissect_xnap_ProtocolIE_Single_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_xnap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_xnap_extension_id   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_xnap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolExtensionField },
};

static int
dissect_xnap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, FALSE);

  return offset;
}



static int
dissect_xnap_PrivateIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_xnap_private_id     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_ID },
  { &hf_xnap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_privateIE_Field_value, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_xnap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PrivateIE_Field },
};

static int
dissect_xnap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, FALSE);

  return offset;
}



static int
dissect_xnap_QoSFlowIdentifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, TRUE);

  return offset;
}


static const per_sequence_t QoSFLowsAcceptedToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFLowsAcceptedToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFLowsAcceptedToBeForwarded_Item, QoSFLowsAcceptedToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFLowsAcceptedToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFLowsAcceptedToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsAcceptedToBeForwarded_Item },
};

static int
dissect_xnap_QoSFLowsAcceptedToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFLowsAcceptedToBeForwarded_List, QoSFLowsAcceptedToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}



static int
dissect_xnap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  int len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, NULL, 0, &parameter_tvb, &len);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_TransportLayerAddress);
  if (len == 32) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
  } else if (len == 128) {
    /* IPv6 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv6, parameter_tvb, 0, 16, ENC_NA);
  } else if (len == 160) {
    /* IPv4 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv4, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);
    /* IPv6 */
     proto_tree_add_item(subtree, hf_xnap_transportLayerAddressIPv6, parameter_tvb, 4, 16, ENC_NA);
  }


  return offset;
}



static int
dissect_xnap_GTP_TEID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, NULL);

  return offset;
}


static const per_sequence_t GTPtunnelTransportLayerInformation_sequence[] = {
  { &hf_xnap_tnl_address    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_gtp_teid       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GTP_TEID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GTPtunnelTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GTPtunnelTransportLayerInformation, GTPtunnelTransportLayerInformation_sequence);

  return offset;
}


static const value_string xnap_UPTransportLayerInformation_vals[] = {
  {   0, "gtpTunnel" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UPTransportLayerInformation_choice[] = {
  {   0, &hf_xnap_gtpTunnel      , ASN1_NO_EXTENSIONS     , dissect_xnap_GTPtunnelTransportLayerInformation },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UPTransportLayerInformation, UPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_DRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBItem_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_ulForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingResponseDRBItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingResponseDRBItem, DataForwardingResponseDRBItem_sequence);

  return offset;
}


static const per_sequence_t DataForwardingResponseDRBItemList_sequence_of[1] = {
  { &hf_xnap_DataForwardingResponseDRBItemList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingResponseDRBItem },
};

static int
dissect_xnap_DataForwardingResponseDRBItemList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DataForwardingResponseDRBItemList, DataForwardingResponseDRBItemList_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetNGRANnode_sequence[] = {
  { &hf_xnap_qosFlowsAcceptedForDataForwarding_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsAcceptedToBeForwarded_List },
  { &hf_xnap_pduSessionLevelDLDataForwardingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionLevelULDataForwardingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dataForwardingResponseDRBItemList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingResponseDRBItemList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetNGRANnode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetNGRANnode, DataForwardingInfoFromTargetNGRANnode_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeConfirmInfo_SNterminated_sequence[] = {
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated, PDUSessionResourceChangeConfirmInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item_sequence[] = {
  { &hf_xnap_pDUSessionResourceChangeConfirmInfo_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceChangeConfirmInfo_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item, AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_sequence_of[1] = {
  { &hf_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_Item },
};

static int
dissect_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated, AdditionalListofPDUSessionResourceChangeConfirmInfo_SNterminated_sequence_of,
                                                  1, maxnoofTargetSNsMinusOne, FALSE);

  return offset;
}


static const value_string xnap_AdditionLocationInformation_vals[] = {
  {   0, "includePSCell" },
  { 0, NULL }
};


static int
dissect_xnap_AdditionLocationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Additional_PDCP_Duplication_TNL_Item_sequence[] = {
  { &hf_xnap_additional_PDCP_Duplication_UP_TNL_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_PDCP_Duplication_TNL_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_PDCP_Duplication_TNL_Item, Additional_PDCP_Duplication_TNL_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_PDCP_Duplication_TNL_List_sequence_of[1] = {
  { &hf_xnap_Additional_PDCP_Duplication_TNL_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_PDCP_Duplication_TNL_Item },
};

static int
dissect_xnap_Additional_PDCP_Duplication_TNL_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_PDCP_Duplication_TNL_List, Additional_PDCP_Duplication_TNL_List_sequence_of,
                                                  1, maxnoofAdditionalPDCPDuplicationTNL, FALSE);

  return offset;
}


static const per_sequence_t Additional_UL_NG_U_TNLatUPF_Item_sequence[] = {
  { &hf_xnap_additional_UL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_UL_NG_U_TNLatUPF_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_UL_NG_U_TNLatUPF_Item, Additional_UL_NG_U_TNLatUPF_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_UL_NG_U_TNLatUPF_List_sequence_of[1] = {
  { &hf_xnap_Additional_UL_NG_U_TNLatUPF_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_UL_NG_U_TNLatUPF_Item },
};

static int
dissect_xnap_Additional_UL_NG_U_TNLatUPF_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_UL_NG_U_TNLatUPF_List, Additional_UL_NG_U_TNLatUPF_List_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_95(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 95U, NULL, FALSE);

  return offset;
}


static const value_string xnap_T_csi_RS_Status_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_T_csi_RS_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  e212_number_type_t number_type = xnap_data->number_type;
  xnap_data->number_type = E212_NONE;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;

  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_PLMN_Identity);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, number_type, FALSE);


  return offset;
}



static int
dissect_xnap_NR_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     36, 36, FALSE, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 5, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t NR_CGI_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_nr_CI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_NRCGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_CGI, NR_CGI_sequence);



  return offset;
}


static const per_sequence_t CSI_RS_MTC_Neighbour_Item_sequence[] = {
  { &hf_xnap_csi_RS_Index   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_95 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_MTC_Neighbour_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_MTC_Neighbour_Item, CSI_RS_MTC_Neighbour_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Neighbour_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_MTC_Neighbour_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Neighbour_Item },
};

static int
dissect_xnap_CSI_RS_MTC_Neighbour_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_MTC_Neighbour_List, CSI_RS_MTC_Neighbour_List_sequence_of,
                                                  1, maxnoofCSIRSneighbourCellsInMTC, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_Neighbour_Item_sequence[] = {
  { &hf_xnap_nr_cgi         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_csi_RS_MTC_Neighbour_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CSI_RS_MTC_Neighbour_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_Neighbour_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_Neighbour_Item, CSI_RS_Neighbour_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_Neighbour_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_Neighbour_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_Neighbour_Item },
};

static int
dissect_xnap_CSI_RS_Neighbour_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_Neighbour_List, CSI_RS_Neighbour_List_sequence_of,
                                                  1, maxnoofCSIRSneighbourCells, FALSE);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Configuration_Item_sequence[] = {
  { &hf_xnap_csi_RS_Index   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_95 },
  { &hf_xnap_csi_RS_Status  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_csi_RS_Status },
  { &hf_xnap_csi_RS_Neighbour_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CSI_RS_Neighbour_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CSI_RS_MTC_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CSI_RS_MTC_Configuration_Item, CSI_RS_MTC_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t CSI_RS_MTC_Configuration_List_sequence_of[1] = {
  { &hf_xnap_CSI_RS_MTC_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Configuration_Item },
};

static int
dissect_xnap_CSI_RS_MTC_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CSI_RS_MTC_Configuration_List, CSI_RS_MTC_Configuration_List_sequence_of,
                                                  1, maxnoofCSIRSconfigurations, FALSE);

  return offset;
}


static const per_sequence_t Additional_Measurement_Timing_Configuration_Item_sequence[] = {
  { &hf_xnap_additionalMeasurementTimingConfigurationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_16 },
  { &hf_xnap_csi_RS_MTC_Configuration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CSI_RS_MTC_Configuration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Additional_Measurement_Timing_Configuration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Additional_Measurement_Timing_Configuration_Item, Additional_Measurement_Timing_Configuration_Item_sequence);

  return offset;
}


static const per_sequence_t Additional_Measurement_Timing_Configuration_List_sequence_of[1] = {
  { &hf_xnap_Additional_Measurement_Timing_Configuration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Additional_Measurement_Timing_Configuration_Item },
};

static int
dissect_xnap_Additional_Measurement_Timing_Configuration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Additional_Measurement_Timing_Configuration_List, Additional_Measurement_Timing_Configuration_List_sequence_of,
                                                  1, maxnoofMTCItems, FALSE);

  return offset;
}



static int
dissect_xnap_ActivationIDforCellActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_FiveQI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_PriorityLevelQoS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 127U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_AveragingWindow(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_MaximumDataBurstVolume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}


static const per_sequence_t NonDynamic5QIDescriptor_sequence[] = {
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_priorityLevelQoS, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PriorityLevelQoS },
  { &hf_xnap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AveragingWindow },
  { &hf_xnap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumDataBurstVolume },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NonDynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NonDynamic5QIDescriptor, NonDynamic5QIDescriptor_sequence);

  return offset;
}



static int
dissect_xnap_PacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_PER_Scalar(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_PER_Exponent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}


static const per_sequence_t PacketErrorRate_sequence[] = {
  { &hf_xnap_pER_Scalar     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PER_Scalar },
  { &hf_xnap_pER_Exponent   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PER_Exponent },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PacketErrorRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PacketErrorRate, PacketErrorRate_sequence);

  return offset;
}


static const value_string xnap_T_delayCritical_vals[] = {
  {   0, "delay-critical" },
  {   1, "non-delay-critical" },
  { 0, NULL }
};


static int
dissect_xnap_T_delayCritical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Dynamic5QIDescriptor_sequence[] = {
  { &hf_xnap_priorityLevelQoS, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PriorityLevelQoS },
  { &hf_xnap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PacketDelayBudget },
  { &hf_xnap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PacketErrorRate },
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveQI },
  { &hf_xnap_delayCritical  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_delayCritical },
  { &hf_xnap_averagingWindow, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AveragingWindow },
  { &hf_xnap_maximumDataBurstVolume, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumDataBurstVolume },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Dynamic5QIDescriptor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Dynamic5QIDescriptor, Dynamic5QIDescriptor_sequence);

  return offset;
}


static const value_string xnap_QoSCharacteristics_vals[] = {
  {   0, "non-dynamic" },
  {   1, "dynamic" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t QoSCharacteristics_choice[] = {
  {   0, &hf_xnap_non_dynamic    , ASN1_NO_EXTENSIONS     , dissect_xnap_NonDynamic5QIDescriptor },
  {   1, &hf_xnap_dynamic        , ASN1_NO_EXTENSIONS     , dissect_xnap_Dynamic5QIDescriptor },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_QoSCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_QoSCharacteristics, QoSCharacteristics_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_15_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}


static const value_string xnap_T_pre_emption_capability_vals[] = {
  {   0, "shall-not-trigger-preemption" },
  {   1, "may-trigger-preemption" },
  { 0, NULL }
};


static int
dissect_xnap_T_pre_emption_capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_pre_emption_vulnerability_vals[] = {
  {   0, "not-preemptable" },
  {   1, "preemptable" },
  { 0, NULL }
};


static int
dissect_xnap_T_pre_emption_vulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationandRetentionPriority_sequence[] = {
  { &hf_xnap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15_ },
  { &hf_xnap_pre_emption_capability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_pre_emption_capability },
  { &hf_xnap_pre_emption_vulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_pre_emption_vulnerability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AllocationandRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AllocationandRetentionPriority, AllocationandRetentionPriority_sequence);

  return offset;
}



static int
dissect_xnap_BitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(4000000000000), NULL, TRUE);

  return offset;
}


static const value_string xnap_T_notificationControl_vals[] = {
  {   0, "notification-requested" },
  { 0, NULL }
};


static int
dissect_xnap_T_notificationControl(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_PacketLossRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t GBRQoSFlowInfo_sequence[] = {
  { &hf_xnap_maxFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_maxFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_notificationControl, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_notificationControl },
  { &hf_xnap_maxPacketLossRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketLossRate },
  { &hf_xnap_maxPacketLossRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketLossRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GBRQoSFlowInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GBRQoSFlowInfo, GBRQoSFlowInfo_sequence);

  return offset;
}


static const value_string xnap_ReflectiveQoSAttribute_vals[] = {
  {   0, "subject-to-reflective-QoS" },
  { 0, NULL }
};


static int
dissect_xnap_ReflectiveQoSAttribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_additionalQoSflowInfo_vals[] = {
  {   0, "more-likely" },
  { 0, NULL }
};


static int
dissect_xnap_T_additionalQoSflowInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowLevelQoSParameters_sequence[] = {
  { &hf_xnap_qos_characteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSCharacteristics },
  { &hf_xnap_allocationAndRetentionPrio, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllocationandRetentionPriority },
  { &hf_xnap_gBRQoSFlowInfo , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_reflectiveQoS  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ReflectiveQoSAttribute },
  { &hf_xnap_additionalQoSflowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_additionalQoSflowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowLevelQoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowLevelQoSParameters, QoSFlowLevelQoSParameters_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToAdd_Item_sequence[] = {
  { &hf_xnap_mBS_QosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mBS_QosFlowLevelQosParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_QoSFlowsToAdd_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_QoSFlowsToAdd_Item, MBS_QoSFlowsToAdd_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_QoSFlowsToAdd_List_sequence_of[1] = {
  { &hf_xnap_MBS_QoSFlowsToAdd_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlowsToAdd_Item },
};

static int
dissect_xnap_MBS_QoSFlowsToAdd_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_QoSFlowsToAdd_List, MBS_QoSFlowsToAdd_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaCell_List_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_MBS_ServiceAreaCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaCell_List, MBS_ServiceAreaCell_List_sequence_of,
                                                  1, maxnoofCellsforMBS, FALSE);

  return offset;
}



static int
dissect_xnap_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       3, 3, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 3, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t MBS_ServiceAreaTAI_Item_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaTAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaTAI_Item, MBS_ServiceAreaTAI_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaTAI_List_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaTAI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaTAI_Item },
};

static int
dissect_xnap_MBS_ServiceAreaTAI_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaTAI_List, MBS_ServiceAreaTAI_List_sequence_of,
                                                  1, maxnoofTAIforMBS, FALSE);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformation_sequence[] = {
  { &hf_xnap_mBS_ServiceAreaCell_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceAreaCell_List },
  { &hf_xnap_mBS_ServiceAreaTAI_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceAreaTAI_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaInformation, MBS_ServiceAreaInformation_sequence);

  return offset;
}



static int
dissect_xnap_MBS_Area_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, TRUE);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Area_Session_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Area_Session_ID },
  { &hf_xnap_mBS_ServiceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceAreaInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_ServiceAreaInformation_Item, MBS_ServiceAreaInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_ServiceAreaInformationList_sequence_of[1] = {
  { &hf_xnap_MBS_ServiceAreaInformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_ServiceAreaInformation_Item },
};

static int
dissect_xnap_MBS_ServiceAreaInformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_ServiceAreaInformationList, MBS_ServiceAreaInformationList_sequence_of,
                                                  1, maxnoofMBSServiceAreaInformation, FALSE);

  return offset;
}


static const value_string xnap_MBS_ServiceArea_vals[] = {
  {   0, "locationindependent" },
  {   1, "locationdependent" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MBS_ServiceArea_choice[] = {
  {   0, &hf_xnap_locationindependent, ASN1_NO_EXTENSIONS     , dissect_xnap_MBS_ServiceAreaInformation },
  {   1, &hf_xnap_locationdependent, ASN1_NO_EXTENSIONS     , dissect_xnap_MBS_ServiceAreaInformationList },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MBS_ServiceArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MBS_ServiceArea, MBS_ServiceArea_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, TRUE);

  return offset;
}


static const per_sequence_t MBS_QoSFlow_List_sequence_of[1] = {
  { &hf_xnap_MBS_QoSFlow_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
};

static int
dissect_xnap_MBS_QoSFlow_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_QoSFlow_List, MBS_QoSFlow_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_262143(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 262143U, NULL, FALSE);

  return offset;
}


static const value_string xnap_MRB_ProgressInformation_vals[] = {
  {   0, "pdcp-SN12" },
  {   1, "pdcp-SN18" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MRB_ProgressInformation_choice[] = {
  {   0, &hf_xnap_pdcp_SN12      , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_4095 },
  {   1, &hf_xnap_pdcp_SN18      , ASN1_NO_EXTENSIONS     , dissect_xnap_INTEGER_0_262143 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MRB_ProgressInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MRB_ProgressInformation, MRB_ProgressInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestInfofromSource_Item_sequence[] = {
  { &hf_xnap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MRB_ID },
  { &hf_xnap_mBS_QoSFlow_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlow_List },
  { &hf_xnap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MRB_ProgressInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item, MBS_MappingandDataForwardingRequestInfofromSource_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_MappingandDataForwardingRequestInfofromSource_sequence_of[1] = {
  { &hf_xnap_MBS_MappingandDataForwardingRequestInfofromSource_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource_Item },
};

static int
dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_MappingandDataForwardingRequestInfofromSource, MBS_MappingandDataForwardingRequestInfofromSource_sequence_of,
                                                  1, maxnoofMRBs, FALSE);

  return offset;
}


static const per_sequence_t Active_MBS_SessionInformation_sequence[] = {
  { &hf_xnap_mBS_QoSFlowsToAdd_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_QoSFlowsToAdd_List },
  { &hf_xnap_mBS_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_ServiceArea },
  { &hf_xnap_mBS_MappingandDataForwardingRequestInfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_MappingandDataForwardingRequestInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Active_MBS_SessionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Active_MBS_SessionInformation, Active_MBS_SessionInformation_sequence);

  return offset;
}



static int
dissect_xnap_ActivationSFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_CAG_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t AllowedCAG_ID_List_perPLMN_sequence_of[1] = {
  { &hf_xnap_AllowedCAG_ID_List_perPLMN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CAG_Identifier },
};

static int
dissect_xnap_AllowedCAG_ID_List_perPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AllowedCAG_ID_List_perPLMN, AllowedCAG_ID_List_perPLMN_sequence_of,
                                                  1, maxnoofCAGsperPLMN, FALSE);

  return offset;
}


static const value_string xnap_PNI_NPN_Restricted_Information_vals[] = {
  {   0, "restriced" },
  {   1, "not-restricted" },
  { 0, NULL }
};


static int
dissect_xnap_PNI_NPN_Restricted_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AllowedPNI_NPN_ID_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_pni_npn_restricted_information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PNI_NPN_Restricted_Information },
  { &hf_xnap_allowed_CAG_id_list_per_plmn, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedCAG_ID_List_perPLMN },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AllowedPNI_NPN_ID_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AllowedPNI_NPN_ID_Item, AllowedPNI_NPN_ID_Item_sequence);

  return offset;
}


static const per_sequence_t AllowedPNI_NPN_ID_List_sequence_of[1] = {
  { &hf_xnap_AllowedPNI_NPN_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_Item },
};

static int
dissect_xnap_AllowedPNI_NPN_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AllowedPNI_NPN_ID_List, AllowedPNI_NPN_ID_List_sequence_of,
                                                  1, maxnoofEPLMNsplus1, FALSE);

  return offset;
}


static const value_string xnap_AllTrafficIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_AllTrafficIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_QoSParaSetIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetItem_sequence[] = {
  { &hf_xnap_alternativeQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSParaSetIndex },
  { &hf_xnap_guaranteedFlowBitRateDL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_guaranteedFlowBitRateUL, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_packetDelayBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketDelayBudget },
  { &hf_xnap_packetErrorRate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PacketErrorRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AlternativeQoSParaSetItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AlternativeQoSParaSetItem, AlternativeQoSParaSetItem_sequence);

  return offset;
}


static const per_sequence_t AlternativeQoSParaSetList_sequence_of[1] = {
  { &hf_xnap_AlternativeQoSParaSetList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AlternativeQoSParaSetItem },
};

static int
dissect_xnap_AlternativeQoSParaSetList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AlternativeQoSParaSetList, AlternativeQoSParaSetList_sequence_of,
                                                  1, maxnoofQoSParaSets, FALSE);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GlobalAMF_Region_Information_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_amf_region_id  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_8 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalAMF_Region_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalAMF_Region_Information, GlobalAMF_Region_Information_sequence);

  return offset;
}


static const per_sequence_t AMF_Region_Information_sequence_of[1] = {
  { &hf_xnap_AMF_Region_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalAMF_Region_Information },
};

static int
dissect_xnap_AMF_Region_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AMF_Region_Information, AMF_Region_Information_sequence_of,
                                                  1, maxnoofAMFRegions, FALSE);

  return offset;
}



static int
dissect_xnap_AMF_UE_NGAP_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(1099511627775), NULL, FALSE);

  return offset;
}


static const per_sequence_t TAIsinAoI_Item_sequence[] = {
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIsinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_5GSTAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIsinAoI_Item, TAIsinAoI_Item_sequence);



  return offset;
}


static const per_sequence_t ListOfTAIsinAoI_sequence_of[1] = {
  { &hf_xnap_ListOfTAIsinAoI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAIsinAoI_Item },
};

static int
dissect_xnap_ListOfTAIsinAoI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfTAIsinAoI, ListOfTAIsinAoI_sequence_of,
                                                  1, maxnoofTAIsinAoI, FALSE);

  return offset;
}



static int
dissect_xnap_E_UTRA_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *cell_id_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     28, 28, FALSE, NULL, 0, &cell_id_tvb, NULL);

  if (cell_id_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, cell_id_tvb, 0, 4, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_NG_RAN_Cell_Identity_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_Cell_Identity_choice[] = {
  {   0, &hf_xnap_nr             , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_Cell_Identity },
  {   1, &hf_xnap_e_utra         , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_Cell_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_Cell_Identity, NG_RAN_Cell_Identity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellsinAoI_Item_sequence[] = {
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_ng_ran_cell_id , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellsinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellsinAoI_Item, CellsinAoI_Item_sequence);

  return offset;
}


static const per_sequence_t ListOfCells_sequence_of[1] = {
  { &hf_xnap_ListOfCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellsinAoI_Item },
};

static int
dissect_xnap_ListOfCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfCells, ListOfCells_sequence_of,
                                                  1, maxnoofCellsinAoI, FALSE);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_22_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     22, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_GNB_ID_Choice_vals[] = {
  {   0, "gnb-ID" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GNB_ID_Choice_choice[] = {
  {   0, &hf_xnap_gnb_ID         , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_22_32 },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_GNB_ID_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_GNB_ID_Choice, GNB_ID_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalgNB_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_gnb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_ID_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalgNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalgNB_ID, GlobalgNB_ID_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     20, 20, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     18, 18, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_21(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     21, 21, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_ENB_ID_Choice_vals[] = {
  {   0, "enb-ID-macro" },
  {   1, "enb-ID-shortmacro" },
  {   2, "enb-ID-longmacro" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ENB_ID_Choice_choice[] = {
  {   0, &hf_xnap_enb_ID_macro   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_20 },
  {   1, &hf_xnap_enb_ID_shortmacro, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_18 },
  {   2, &hf_xnap_enb_ID_longmacro, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_21 },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ENB_ID_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ENB_ID_Choice, ENB_ID_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalngeNB_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_enb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ENB_ID_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalngeNB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalngeNB_ID, GlobalngeNB_ID_sequence);

  return offset;
}


static const value_string xnap_GlobalNG_RANNode_ID_vals[] = {
  { GlobalNG_RANNode_ID_gNB, "gNB" },
  { GlobalNG_RANNode_ID_ng_eNB, "ng-eNB" },
  { GlobalNG_RANNode_ID_choice_extension, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t GlobalNG_RANNode_ID_choice[] = {
  { GlobalNG_RANNode_ID_gNB, &hf_xnap_gNB            , ASN1_NO_EXTENSIONS     , dissect_xnap_GlobalgNB_ID },
  { GlobalNG_RANNode_ID_ng_eNB, &hf_xnap_ng_eNB         , ASN1_NO_EXTENSIONS     , dissect_xnap_GlobalngeNB_ID },
  { GlobalNG_RANNode_ID_choice_extension, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANNode_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  gint value;
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);

  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_GlobalNG_RANNode_ID, GlobalNG_RANNode_ID_choice,
                                 &value);

  if (xnap_data->xnap_conv && xnap_data->procedure_code == id_xnSetup) {
    if (addresses_equal(&actx->pinfo->src, &xnap_data->xnap_conv->addr_a) &&
        actx->pinfo->srcport == xnap_data->xnap_conv->port_a) {
      xnap_data->xnap_conv->ranmode_id_a = (GlobalNG_RANNode_ID_enum)value;
    } else if (addresses_equal(&actx->pinfo->src, &xnap_data->xnap_conv->addr_b) &&
               actx->pinfo->srcport == xnap_data->xnap_conv->port_b) {
      xnap_data->xnap_conv->ranmode_id_b = (GlobalNG_RANNode_ID_enum)value;
    }
  }


  return offset;
}


static const per_sequence_t GlobalNG_RANNodesinAoI_Item_sequence[] = {
  { &hf_xnap_global_NG_RAN_Node_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANNodesinAoI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalNG_RANNodesinAoI_Item, GlobalNG_RANNodesinAoI_Item_sequence);

  return offset;
}


static const per_sequence_t ListOfRANNodesinAoI_sequence_of[1] = {
  { &hf_xnap_ListOfRANNodesinAoI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNodesinAoI_Item },
};

static int
dissect_xnap_ListOfRANNodesinAoI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ListOfRANNodesinAoI, ListOfRANNodesinAoI_sequence_of,
                                                  1, maxnoofRANNodesinAoI, FALSE);

  return offset;
}



static int
dissect_xnap_RequestReferenceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, TRUE);

  return offset;
}


static const per_sequence_t AreaOfInterest_Item_sequence[] = {
  { &hf_xnap_listOfTAIsinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfTAIsinAoI },
  { &hf_xnap_listOfCellsinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfCells },
  { &hf_xnap_listOfRANNodesinAoI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ListOfRANNodesinAoI },
  { &hf_xnap_requestReferenceID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RequestReferenceID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AreaOfInterest_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AreaOfInterest_Item, AreaOfInterest_Item_sequence);

  return offset;
}


static const per_sequence_t AreaOfInterestInformation_sequence_of[1] = {
  { &hf_xnap_AreaOfInterestInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AreaOfInterest_Item },
};

static int
dissect_xnap_AreaOfInterestInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AreaOfInterestInformation, AreaOfInterestInformation_sequence_of,
                                                  1, maxnoofAoIs, FALSE);

  return offset;
}


static const per_sequence_t CellIdListforMDT_NR_sequence_of[1] = {
  { &hf_xnap_CellIdListforMDT_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_CellIdListforMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforMDT_NR, CellIdListforMDT_NR_sequence_of,
                                                  1, maxnoofCellIDforMDT, FALSE);

  return offset;
}


static const per_sequence_t CellBasedMDT_NR_sequence[] = {
  { &hf_xnap_cellIdListforMDT_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforMDT_NR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedMDT_NR, CellBasedMDT_NR_sequence);

  return offset;
}


static const per_sequence_t TAListforMDT_sequence_of[1] = {
  { &hf_xnap_TAListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_TAListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAListforMDT, TAListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, FALSE);

  return offset;
}


static const per_sequence_t TABasedMDT_sequence[] = {
  { &hf_xnap_tAListforMDT   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TABasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TABasedMDT, TABasedMDT_sequence);

  return offset;
}


static const per_sequence_t TAIforMDT_Item_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIforMDT_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_5GSTAI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIforMDT_Item, TAIforMDT_Item_sequence);



  return offset;
}


static const per_sequence_t TAIListforMDT_sequence_of[1] = {
  { &hf_xnap_TAIListforMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAIforMDT_Item },
};

static int
dissect_xnap_TAIListforMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAIListforMDT, TAIListforMDT_sequence_of,
                                                  1, maxnoofTAforMDT, FALSE);

  return offset;
}


static const per_sequence_t TAIBasedMDT_sequence[] = {
  { &hf_xnap_tAIListforMDT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAIListforMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIBasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIBasedMDT, TAIBasedMDT_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfMDT_NR_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_NR_choice[] = {
  {   0, &hf_xnap_cellBased      , ASN1_EXTENSION_ROOT    , dissect_xnap_CellBasedMDT_NR },
  {   1, &hf_xnap_tABased        , ASN1_EXTENSION_ROOT    , dissect_xnap_TABasedMDT },
  {   2, &hf_xnap_tAIBased       , ASN1_EXTENSION_ROOT    , dissect_xnap_TAIBasedMDT },
  {   3, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfMDT_NR, AreaScopeOfMDT_NR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_UTRA_CGI_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_e_utra_CI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_Cell_Identity },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRA_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_ECGI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRA_CGI, E_UTRA_CGI_sequence);



  return offset;
}


static const per_sequence_t CellIdListforMDT_EUTRA_sequence_of[1] = {
  { &hf_xnap_CellIdListforMDT_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
};

static int
dissect_xnap_CellIdListforMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforMDT_EUTRA, CellIdListforMDT_EUTRA_sequence_of,
                                                  1, maxnoofCellIDforMDT, FALSE);

  return offset;
}


static const per_sequence_t CellBasedMDT_EUTRA_sequence[] = {
  { &hf_xnap_cellIdListforMDT_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforMDT_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedMDT_EUTRA, CellBasedMDT_EUTRA_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfMDT_EUTRA_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfMDT_EUTRA_choice[] = {
  {   0, &hf_xnap_cellBased_01   , ASN1_EXTENSION_ROOT    , dissect_xnap_CellBasedMDT_EUTRA },
  {   1, &hf_xnap_tABased        , ASN1_EXTENSION_ROOT    , dissect_xnap_TABasedMDT },
  {   2, &hf_xnap_tAIBased       , ASN1_EXTENSION_ROOT    , dissect_xnap_TAIBasedMDT },
  {   3, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfMDT_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfMDT_EUTRA, AreaScopeOfMDT_EUTRA_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_NRARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, FALSE);

  return offset;
}


static const value_string xnap_NRSCS_vals[] = {
  {   0, "scs15" },
  {   1, "scs30" },
  {   2, "scs60" },
  {   3, "scs120" },
  {   4, "scs480" },
  {   5, "scs960" },
  { 0, NULL }
};


static int
dissect_xnap_NRSCS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string xnap_NRNRB_vals[] = {
  {   0, "nrb11" },
  {   1, "nrb18" },
  {   2, "nrb24" },
  {   3, "nrb25" },
  {   4, "nrb31" },
  {   5, "nrb32" },
  {   6, "nrb38" },
  {   7, "nrb51" },
  {   8, "nrb52" },
  {   9, "nrb65" },
  {  10, "nrb66" },
  {  11, "nrb78" },
  {  12, "nrb79" },
  {  13, "nrb93" },
  {  14, "nrb106" },
  {  15, "nrb107" },
  {  16, "nrb121" },
  {  17, "nrb132" },
  {  18, "nrb133" },
  {  19, "nrb135" },
  {  20, "nrb160" },
  {  21, "nrb162" },
  {  22, "nrb189" },
  {  23, "nrb216" },
  {  24, "nrb217" },
  {  25, "nrb245" },
  {  26, "nrb264" },
  {  27, "nrb270" },
  {  28, "nrb273" },
  {  29, "nrb33" },
  {  30, "nrb62" },
  {  31, "nrb124" },
  {  32, "nrb148" },
  {  33, "nrb248" },
  {  34, "nrb44" },
  {  35, "nrb58" },
  {  36, "nrb92" },
  {  37, "nrb119" },
  {  38, "nrb188" },
  {  39, "nrb242" },
  { 0, NULL }
};

static value_string_ext xnap_NRNRB_vals_ext = VALUE_STRING_EXT_INIT(xnap_NRNRB_vals);


static int
dissect_xnap_NRNRB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     29, NULL, TRUE, 11, NULL);

  return offset;
}


static const per_sequence_t NRTransmissionBandwidth_sequence[] = {
  { &hf_xnap_nRSCS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_nRNRB          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRNRB },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRTransmissionBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRTransmissionBandwidth, NRTransmissionBandwidth_sequence);

  return offset;
}


static const per_sequence_t SUL_Information_sequence[] = {
  { &hf_xnap_sulFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_sulTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SUL_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SUL_Information, SUL_Information_sequence);

  return offset;
}



static int
dissect_xnap_NRFrequencyBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_SUL_FrequencyBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SupportedSULBandItem_sequence[] = {
  { &hf_xnap_sulBandItem    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SUL_FrequencyBand },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SupportedSULBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SupportedSULBandItem, SupportedSULBandItem_sequence);

  return offset;
}


static const per_sequence_t SupportedSULBandList_sequence_of[1] = {
  { &hf_xnap_SupportedSULBandList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SupportedSULBandItem },
};

static int
dissect_xnap_SupportedSULBandList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SupportedSULBandList, SupportedSULBandList_sequence_of,
                                                  1, maxnoofNRCellBands, FALSE);

  return offset;
}


static const per_sequence_t NRFrequencyBandItem_sequence[] = {
  { &hf_xnap_nr_frequency_band, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBand },
  { &hf_xnap_supported_SUL_Band_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SupportedSULBandList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRFrequencyBandItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRFrequencyBandItem, NRFrequencyBandItem_sequence);

  return offset;
}


static const per_sequence_t NRFrequencyBand_List_sequence_of[1] = {
  { &hf_xnap_NRFrequencyBand_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBandItem },
};

static int
dissect_xnap_NRFrequencyBand_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NRFrequencyBand_List, NRFrequencyBand_List_sequence_of,
                                                  1, maxnoofNRCellBands, FALSE);

  return offset;
}


static const per_sequence_t NRFrequencyInfo_sequence[] = {
  { &hf_xnap_nrARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_sul_information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SUL_Information },
  { &hf_xnap_frequencyBand_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyBand_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRFrequencyInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRFrequencyInfo, NRFrequencyInfo_sequence);

  return offset;
}



static int
dissect_xnap_NRPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, TRUE);

  return offset;
}


static const per_sequence_t PCIListForMDT_sequence_of[1] = {
  { &hf_xnap_PCIListForMDT_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRPCI },
};

static int
dissect_xnap_PCIListForMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PCIListForMDT, PCIListForMDT_sequence_of,
                                                  1, maxnoofNeighPCIforMDT, FALSE);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsItem_sequence[] = {
  { &hf_xnap_nrFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_pciListForMDT  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PCIListForMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfNeighCellsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AreaScopeOfNeighCellsItem, AreaScopeOfNeighCellsItem_sequence);

  return offset;
}


static const per_sequence_t AreaScopeOfNeighCellsList_sequence_of[1] = {
  { &hf_xnap_AreaScopeOfNeighCellsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_AreaScopeOfNeighCellsItem },
};

static int
dissect_xnap_AreaScopeOfNeighCellsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_AreaScopeOfNeighCellsList, AreaScopeOfNeighCellsList_sequence_of,
                                                  1, maxnoofFreqforMDT, FALSE);

  return offset;
}


static const per_sequence_t GlobalNG_RANCell_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_ng_RAN_Cell_id , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalNG_RANCell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalNG_RANCell_ID, GlobalNG_RANCell_ID_sequence);

  return offset;
}


static const per_sequence_t CellIdListforQMC_sequence_of[1] = {
  { &hf_xnap_CellIdListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
};

static int
dissect_xnap_CellIdListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellIdListforQMC, CellIdListforQMC_sequence_of,
                                                  1, maxnoofCellIDforQMC, FALSE);

  return offset;
}


static const per_sequence_t CellBasedQMC_sequence[] = {
  { &hf_xnap_cellIdListforQMC, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellIdListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellBasedQMC, CellBasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAListforQMC_sequence_of[1] = {
  { &hf_xnap_TAListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_TAListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAListforQMC, TAListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, FALSE);

  return offset;
}


static const per_sequence_t TABasedQMC_sequence[] = {
  { &hf_xnap_tAListforQMC   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TABasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TABasedQMC, TABasedQMC_sequence);

  return offset;
}


static const per_sequence_t TAI_Item_sequence[] = {
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAI_Item, TAI_Item_sequence);

  return offset;
}


static const per_sequence_t TAIListforQMC_sequence_of[1] = {
  { &hf_xnap_TAIListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAI_Item },
};

static int
dissect_xnap_TAIListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAIListforQMC, TAIListforQMC_sequence_of,
                                                  1, maxnoofTAforQMC, FALSE);

  return offset;
}


static const per_sequence_t TAIBasedQMC_sequence[] = {
  { &hf_xnap_tAIListforQMC  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAIListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAIBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAIBasedQMC, TAIBasedQMC_sequence);

  return offset;
}


static const per_sequence_t PLMNListforQMC_sequence_of[1] = {
  { &hf_xnap_PLMNListforQMC_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_PLMNListforQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PLMNListforQMC, PLMNListforQMC_sequence_of,
                                                  1, maxnoofPLMNforQMC, FALSE);

  return offset;
}


static const per_sequence_t PLMNAreaBasedQMC_sequence[] = {
  { &hf_xnap_plmnListforQMC , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMNListforQMC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PLMNAreaBasedQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PLMNAreaBasedQMC, PLMNAreaBasedQMC_sequence);

  return offset;
}


static const value_string xnap_AreaScopeOfQMC_vals[] = {
  {   0, "cellBased" },
  {   1, "tABased" },
  {   2, "tAIBased" },
  {   3, "pLMNAreaBased" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t AreaScopeOfQMC_choice[] = {
  {   0, &hf_xnap_cellBased_02   , ASN1_NO_EXTENSIONS     , dissect_xnap_CellBasedQMC },
  {   1, &hf_xnap_tABased_01     , ASN1_NO_EXTENSIONS     , dissect_xnap_TABasedQMC },
  {   2, &hf_xnap_tAIBased_01    , ASN1_NO_EXTENSIONS     , dissect_xnap_TAIBasedQMC },
  {   3, &hf_xnap_pLMNAreaBased  , ASN1_NO_EXTENSIONS     , dissect_xnap_PLMNAreaBasedQMC },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_AreaScopeOfQMC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_AreaScopeOfQMC, AreaScopeOfQMC_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AS_SecurityInformation_sequence[] = {
  { &hf_xnap_key_NG_RAN_Star, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_256 },
  { &hf_xnap_ncc            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_7 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AS_SecurityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AS_SecurityInformation, AS_SecurityInformation_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_1_16_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16U, NULL, TRUE);

  return offset;
}


static const value_string xnap_T_nextPagingAreaScope_vals[] = {
  {   0, "same" },
  {   1, "changed" },
  { 0, NULL }
};


static int
dissect_xnap_T_nextPagingAreaScope(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RANPagingAttemptInfo_sequence[] = {
  { &hf_xnap_pagingAttemptCount, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_16_ },
  { &hf_xnap_intendedNumberOfPagingAttempts, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_16_ },
  { &hf_xnap_nextPagingAreaScope, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nextPagingAreaScope },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RANPagingAttemptInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RANPagingAttemptInfo, RANPagingAttemptInfo_sequence);

  return offset;
}


static const per_sequence_t AssistanceDataForRANPaging_sequence[] = {
  { &hf_xnap_ran_paging_attempt_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANPagingAttemptInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AssistanceDataForRANPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AssistanceDataForRANPaging, AssistanceDataForRANPaging_sequence);

  return offset;
}


static const per_sequence_t Associated_QoSFlowInfo_Item_sequence[] = {
  { &hf_xnap_mBS_QoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_associatedUnicastQoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Associated_QoSFlowInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Associated_QoSFlowInfo_Item, Associated_QoSFlowInfo_Item_sequence);

  return offset;
}


static const per_sequence_t Associated_QoSFlowInfo_List_sequence_of[1] = {
  { &hf_xnap_Associated_QoSFlowInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Associated_QoSFlowInfo_Item },
};

static int
dissect_xnap_Associated_QoSFlowInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Associated_QoSFlowInfo_List, Associated_QoSFlowInfo_List_sequence_of,
                                                  1, maxnoofMBSQoSFlows, FALSE);

  return offset;
}



static int
dissect_xnap_AvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_AvailableRRCConnectionCapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const value_string xnap_T_bufferLevel_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_bufferLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_playoutDelayForMediaStartup_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_playoutDelayForMediaStartup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t AvailableRVQoEMetrics_sequence[] = {
  { &hf_xnap_bufferLevel    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_bufferLevel },
  { &hf_xnap_playoutDelayForMediaStartup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_playoutDelayForMediaStartup },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_AvailableRVQoEMetrics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_AvailableRVQoEMetrics, AvailableRVQoEMetrics_sequence);

  return offset;
}



static int
dissect_xnap_BAPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BAPPathID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPRoutingID_sequence[] = {
  { &hf_xnap_bAPAddress     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_bAPPathID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPPathID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BAPRoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BAPRoutingID, BAPRoutingID_sequence);

  return offset;
}


static const value_string xnap_BeamMeasurementIndicationM1_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_BeamMeasurementIndicationM1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_rSRP_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_rSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_rSRQ_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_rSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_sINR_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_sINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportQuantity_sequence[] = {
  { &hf_xnap_rSRP           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rSRP },
  { &hf_xnap_rSRQ           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rSRQ },
  { &hf_xnap_sINR           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_sINR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BeamMeasurementsReportQuantity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BeamMeasurementsReportQuantity, BeamMeasurementsReportQuantity_sequence);

  return offset;
}



static int
dissect_xnap_MaxNrofRS_IndexesToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, TRUE);

  return offset;
}


static const per_sequence_t BeamMeasurementsReportConfiguration_sequence[] = {
  { &hf_xnap_beamMeasurementsReportQuantity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BeamMeasurementsReportQuantity },
  { &hf_xnap_maxNrofRS_IndexesToReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaxNrofRS_IndexesToReport },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BeamMeasurementsReportConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BeamMeasurementsReportConfiguration, BeamMeasurementsReportConfiguration_sequence);

  return offset;
}



static int
dissect_xnap_BHInfoIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofBHInfo, NULL, FALSE);

  return offset;
}


static const per_sequence_t BHInfo_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BHInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BHInfo_Item, BHInfo_Item_sequence);

  return offset;
}


static const per_sequence_t BHInfoList_sequence_of[1] = {
  { &hf_xnap_BHInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfo_Item },
};

static int
dissect_xnap_BHInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BHInfoList, BHInfoList_sequence_of,
                                                  1, maxnoofBHInfo, FALSE);

  return offset;
}



static int
dissect_xnap_BHRLCChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BAPControlPDURLCCH_Item_sequence[] = {
  { &hf_xnap_bHRLCCHID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_nexthopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BAPControlPDURLCCH_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BAPControlPDURLCCH_Item, BAPControlPDURLCCH_Item_sequence);

  return offset;
}


static const per_sequence_t BAPControlPDURLCCH_List_sequence_of[1] = {
  { &hf_xnap_BAPControlPDURLCCH_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BAPControlPDURLCCH_Item },
};

static int
dissect_xnap_BAPControlPDURLCCH_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BAPControlPDURLCCH_List, BAPControlPDURLCCH_List_sequence_of,
                                                  1, maxnoofBAPControlPDURLCCHs, FALSE);

  return offset;
}


static const value_string xnap_BluetoothMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_BluetoothMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_BluetoothName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 248, FALSE, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t BluetoothMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_BluetoothMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BluetoothName },
};

static int
dissect_xnap_BluetoothMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BluetoothMeasConfigNameList, BluetoothMeasConfigNameList_sequence_of,
                                                  1, maxnoofBluetoothName, FALSE);

  return offset;
}


static const value_string xnap_T_bt_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_bt_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t BluetoothMeasurementConfiguration_sequence[] = {
  { &hf_xnap_bluetoothMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BluetoothMeasConfig },
  { &hf_xnap_bluetoothMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasConfigNameList },
  { &hf_xnap_bt_rssi        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_bt_rssi },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BluetoothMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BluetoothMeasurementConfiguration, BluetoothMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t BroadcastEUTRAPLMNs_sequence_of[1] = {
  { &hf_xnap_BroadcastEUTRAPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_BroadcastEUTRAPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastEUTRAPLMNs, BroadcastEUTRAPLMNs_sequence_of,
                                                  1, maxnoofEUTRABPLMNs, FALSE);

  return offset;
}



static int
dissect_xnap_RANAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_Item_sequence[] = {
  { &hf_xnap_broadcastPLMNs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastEUTRAPLMNs },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_e_utraCI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_Cell_Identity },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BPLMN_ID_Info_EUTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BPLMN_ID_Info_EUTRA_Item, BPLMN_ID_Info_EUTRA_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_EUTRA_sequence_of[1] = {
  { &hf_xnap_BPLMN_ID_Info_EUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BPLMN_ID_Info_EUTRA_Item },
};

static int
dissect_xnap_BPLMN_ID_Info_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BPLMN_ID_Info_EUTRA, BPLMN_ID_Info_EUTRA_sequence_of,
                                                  1, maxnoofEUTRABPLMNs, FALSE);

  return offset;
}


static const per_sequence_t BroadcastPLMNs_sequence_of[1] = {
  { &hf_xnap_BroadcastPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_BroadcastPLMNs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastPLMNs, BroadcastPLMNs_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_Item_sequence[] = {
  { &hf_xnap_broadcastPLMNs_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPLMNs },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_nr_CI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BPLMN_ID_Info_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BPLMN_ID_Info_NR_Item, BPLMN_ID_Info_NR_Item_sequence);

  return offset;
}


static const per_sequence_t BPLMN_ID_Info_NR_sequence_of[1] = {
  { &hf_xnap_BPLMN_ID_Info_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BPLMN_ID_Info_NR_Item },
};

static int
dissect_xnap_BPLMN_ID_Info_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BPLMN_ID_Info_NR, BPLMN_ID_Info_NR_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t BroadcastCAG_Identifier_Item_sequence[] = {
  { &hf_xnap_cag_Identifier , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CAG_Identifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastCAG_Identifier_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastCAG_Identifier_Item, BroadcastCAG_Identifier_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastCAG_Identifier_List_sequence_of[1] = {
  { &hf_xnap_BroadcastCAG_Identifier_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastCAG_Identifier_Item },
};

static int
dissect_xnap_BroadcastCAG_Identifier_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastCAG_Identifier_List, BroadcastCAG_Identifier_List_sequence_of,
                                                  1, maxnoofCAGs, FALSE);

  return offset;
}



static int
dissect_xnap_NID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     44, 44, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t BroadcastNID_Item_sequence[] = {
  { &hf_xnap_nid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastNID_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastNID_Item, BroadcastNID_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastNID_List_sequence_of[1] = {
  { &hf_xnap_BroadcastNID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastNID_Item },
};

static int
dissect_xnap_BroadcastNID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastNID_List, BroadcastNID_List_sequence_of,
                                                  1, maxnoofNIDs, FALSE);

  return offset;
}



static int
dissect_xnap_OCTET_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 1, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_OCTET_STRING_SIZE_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t S_NSSAI_sequence[] = {
  { &hf_xnap_sst            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OCTET_STRING_SIZE_1 },
  { &hf_xnap_sd             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_OCTET_STRING_SIZE_3 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_S_NSSAI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_S_NSSAI, S_NSSAI_sequence);

  return offset;
}


static const per_sequence_t SliceSupport_List_sequence_of[1] = {
  { &hf_xnap_SliceSupport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_SliceSupport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceSupport_List, SliceSupport_List_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t BroadcastPLMNinTAISupport_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_tAISliceSupport_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SliceSupport_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastPLMNinTAISupport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastPLMNinTAISupport_Item, BroadcastPLMNinTAISupport_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_Information_Item_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_broadcastCAG_Identifier_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastCAG_Identifier_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastPNI_NPN_ID_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastPNI_NPN_ID_Information_Item, BroadcastPNI_NPN_ID_Information_Item_sequence);

  return offset;
}


static const per_sequence_t BroadcastPNI_NPN_ID_Information_sequence_of[1] = {
  { &hf_xnap_BroadcastPNI_NPN_ID_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPNI_NPN_ID_Information_Item },
};

static int
dissect_xnap_BroadcastPNI_NPN_ID_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastPNI_NPN_ID_Information, BroadcastPNI_NPN_ID_Information_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t BroadcastSNPNID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_broadcastNID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastNID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_BroadcastSNPNID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_BroadcastSNPNID, BroadcastSNPNID_sequence);

  return offset;
}


static const per_sequence_t BroadcastSNPNID_List_sequence_of[1] = {
  { &hf_xnap_BroadcastSNPNID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastSNPNID },
};

static int
dissect_xnap_BroadcastSNPNID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_BroadcastSNPNID_List, BroadcastSNPNID_List_sequence_of,
                                                  1, maxnoofSNPNIDs, FALSE);

  return offset;
}



static int
dissect_xnap_CapacityValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_ssbAreaCapacityValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBAreaCapacityValue_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBAreaCapacityValue_List_Item, SSBAreaCapacityValue_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaCapacityValue_List_sequence_of[1] = {
  { &hf_xnap_SSBAreaCapacityValue_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaCapacityValue_List_Item },
};

static int
dissect_xnap_SSBAreaCapacityValue_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBAreaCapacityValue_List, SSBAreaCapacityValue_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t CapacityValueInfo_sequence[] = {
  { &hf_xnap_capacityValue  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CapacityValue },
  { &hf_xnap_ssbAreaCapacityValueList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SSBAreaCapacityValue_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CapacityValueInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CapacityValueInfo, CapacityValueInfo_sequence);

  return offset;
}


static const value_string xnap_CauseRadioNetworkLayer_vals[] = {
  {   0, "cell-not-available" },
  {   1, "handover-desirable-for-radio-reasons" },
  {   2, "handover-target-not-allowed" },
  {   3, "invalid-AMF-Set-ID" },
  {   4, "no-radio-resources-available-in-target-cell" },
  {   5, "partial-handover" },
  {   6, "reduce-load-in-serving-cell" },
  {   7, "resource-optimisation-handover" },
  {   8, "time-critical-handover" },
  {   9, "tXnRELOCoverall-expiry" },
  {  10, "tXnRELOCprep-expiry" },
  {  11, "unknown-GUAMI-ID" },
  {  12, "unknown-local-NG-RAN-node-UE-XnAP-ID" },
  {  13, "inconsistent-remote-NG-RAN-node-UE-XnAP-ID" },
  {  14, "encryption-and-or-integrity-protection-algorithms-not-supported" },
  {  15, "not-used-causes-value-1" },
  {  16, "multiple-PDU-session-ID-instances" },
  {  17, "unknown-PDU-session-ID" },
  {  18, "unknown-QoS-Flow-ID" },
  {  19, "multiple-QoS-Flow-ID-instances" },
  {  20, "switch-off-ongoing" },
  {  21, "not-supported-5QI-value" },
  {  22, "tXnDCoverall-expiry" },
  {  23, "tXnDCprep-expiry" },
  {  24, "action-desirable-for-radio-reasons" },
  {  25, "reduce-load" },
  {  26, "resource-optimisation" },
  {  27, "time-critical-action" },
  {  28, "target-not-allowed" },
  {  29, "no-radio-resources-available" },
  {  30, "invalid-QoS-combination" },
  {  31, "encryption-algorithms-not-supported" },
  {  32, "procedure-cancelled" },
  {  33, "rRM-purpose" },
  {  34, "improve-user-bit-rate" },
  {  35, "user-inactivity" },
  {  36, "radio-connection-with-UE-lost" },
  {  37, "failure-in-the-radio-interface-procedure" },
  {  38, "bearer-option-not-supported" },
  {  39, "up-integrity-protection-not-possible" },
  {  40, "up-confidentiality-protection-not-possible" },
  {  41, "resources-not-available-for-the-slice-s" },
  {  42, "ue-max-IP-data-rate-reason" },
  {  43, "cP-integrity-protection-failure" },
  {  44, "uP-integrity-protection-failure" },
  {  45, "slice-not-supported-by-NG-RAN" },
  {  46, "mN-Mobility" },
  {  47, "sN-Mobility" },
  {  48, "count-reaches-max-value" },
  {  49, "unknown-old-NG-RAN-node-UE-XnAP-ID" },
  {  50, "pDCP-Overload" },
  {  51, "drb-id-not-available" },
  {  52, "unspecified" },
  {  53, "ue-context-id-not-known" },
  {  54, "non-relocation-of-context" },
  {  55, "cho-cpc-resources-tobechanged" },
  {  56, "rSN-not-available-for-the-UP" },
  {  57, "npn-access-denied" },
  {  58, "report-characteristics-empty" },
  {  59, "existing-measurement-ID" },
  {  60, "measurement-temporarily-not-available" },
  {  61, "measurement-not-supported-for-the-object" },
  {  62, "ue-power-saving" },
  {  63, "unknown-NG-RAN-node2-Measurement-ID" },
  {  64, "insufficient-ue-capabilities" },
  {  65, "normal-release" },
  {  66, "value-out-of-allowed-range" },
  {  67, "scg-activation-deactivation-failure" },
  {  68, "scg-deactivation-failure-due-to-data-transmission" },
  { 0, NULL }
};

static value_string_ext xnap_CauseRadioNetworkLayer_vals_ext = VALUE_STRING_EXT_INIT(xnap_CauseRadioNetworkLayer_vals);


static int
dissect_xnap_CauseRadioNetworkLayer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     53, NULL, TRUE, 16, NULL);

  return offset;
}


static const value_string xnap_CauseTransportLayer_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseTransportLayer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "abstract-syntax-error-falsely-constructed-message" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "o-and-M-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_xnap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_xnap_radioNetwork   , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseRadioNetworkLayer },
  {   1, &hf_xnap_transport      , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseTransportLayer },
  {   2, &hf_xnap_protocol       , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseProtocol },
  {   3, &hf_xnap_misc           , ASN1_NO_EXTENSIONS     , dissect_xnap_CauseMisc },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI_sequence_of[1] = {
  { &hf_xnap_limitedNR_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI, SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_T_full_List_vals[] = {
  {   0, "all-served-cells-NR" },
  { 0, NULL }
};


static int
dissect_xnap_T_full_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CellAssistanceInfo_NR_vals[] = {
  {   0, "limitedNR-List" },
  {   1, "full-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CellAssistanceInfo_NR_choice[] = {
  {   0, &hf_xnap_limitedNR_List , ASN1_NO_EXTENSIONS     , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI },
  {   1, &hf_xnap_full_List      , ASN1_NO_EXTENSIONS     , dissect_xnap_T_full_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CellAssistanceInfo_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CellAssistanceInfo_NR, CellAssistanceInfo_NR_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MaximumCellListSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16384U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CellAndCapacityAssistanceInfo_NR_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumCellListSize },
  { &hf_xnap_cellAssistanceInfo_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellAssistanceInfo_NR },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellAndCapacityAssistanceInfo_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellAndCapacityAssistanceInfo_NR, CellAndCapacityAssistanceInfo_NR_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI_sequence_of[1] = {
  { &hf_xnap_limitedEUTRA_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI, SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_T_full_List_01_vals[] = {
  {   0, "all-served-cells-E-UTRA" },
  { 0, NULL }
};


static int
dissect_xnap_T_full_List_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CellAssistanceInfo_EUTRA_vals[] = {
  {   0, "limitedEUTRA-List" },
  {   1, "full-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CellAssistanceInfo_EUTRA_choice[] = {
  {   0, &hf_xnap_limitedEUTRA_List, ASN1_NO_EXTENSIONS     , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI },
  {   1, &hf_xnap_full_List_01   , ASN1_NO_EXTENSIONS     , dissect_xnap_T_full_List_01 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CellAssistanceInfo_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CellAssistanceInfo_EUTRA, CellAssistanceInfo_EUTRA_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellAndCapacityAssistanceInfo_EUTRA_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumCellListSize },
  { &hf_xnap_cellAssistanceInfo_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellAssistanceInfo_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellAndCapacityAssistanceInfo_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellAndCapacityAssistanceInfo_EUTRA, CellAndCapacityAssistanceInfo_EUTRA_sequence);

  return offset;
}



static int
dissect_xnap_CellCapacityClassValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, TRUE);

  return offset;
}


static const value_string xnap_CellDeploymentStatusIndicator_vals[] = {
  {   0, "pre-change-notification" },
  { 0, NULL }
};


static int
dissect_xnap_CellDeploymentStatusIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_CellGroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofSCellGroups, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_DL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_DL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_non_GBR_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_DL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_Total_PRB_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NG_eNB_RadioResourceStatus_sequence[] = {
  { &hf_xnap_dL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage },
  { &hf_xnap_uL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage },
  { &hf_xnap_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage },
  { &hf_xnap_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage },
  { &hf_xnap_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage },
  { &hf_xnap_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NG_eNB_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NG_eNB_RadioResourceStatus, NG_eNB_RadioResourceStatus_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_ssb_Area_DL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_UL_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_dL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_uL_non_GBR_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage },
  { &hf_xnap_ssb_Area_dL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage },
  { &hf_xnap_ssb_Area_uL_Total_PRB_usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBAreaRadioResourceStatus_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBAreaRadioResourceStatus_List_Item, SSBAreaRadioResourceStatus_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBAreaRadioResourceStatus_List_sequence_of[1] = {
  { &hf_xnap_SSBAreaRadioResourceStatus_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaRadioResourceStatus_List_Item },
};

static int
dissect_xnap_SSBAreaRadioResourceStatus_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBAreaRadioResourceStatus_List, SSBAreaRadioResourceStatus_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t GNB_RadioResourceStatus_sequence[] = {
  { &hf_xnap_ssbAreaRadioResourceStatus_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSBAreaRadioResourceStatus_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GNB_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GNB_RadioResourceStatus, GNB_RadioResourceStatus_sequence);

  return offset;
}


static const value_string xnap_RadioResourceStatus_vals[] = {
  {   0, "ng-eNB-RadioResourceStatus" },
  {   1, "gNB-RadioResourceStatus" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RadioResourceStatus_choice[] = {
  {   0, &hf_xnap_ng_eNB_RadioResourceStatus, ASN1_NO_EXTENSIONS     , dissect_xnap_NG_eNB_RadioResourceStatus },
  {   1, &hf_xnap_gNB_RadioResourceStatus, ASN1_NO_EXTENSIONS     , dissect_xnap_GNB_RadioResourceStatus },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RadioResourceStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RadioResourceStatus, RadioResourceStatus_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_OfferedCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 16777216U, NULL, TRUE);

  return offset;
}


static const per_sequence_t TNLCapacityIndicator_sequence[] = {
  { &hf_xnap_dLTNLOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OfferedCapacity },
  { &hf_xnap_dLTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableCapacity },
  { &hf_xnap_uLTNLOfferedCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_OfferedCapacity },
  { &hf_xnap_uLTNLAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableCapacity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLCapacityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLCapacityIndicator, TNLCapacityIndicator_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacity_sequence[] = {
  { &hf_xnap_cellCapacityClassValue, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellCapacityClassValue },
  { &hf_xnap_capacityValueInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CapacityValueInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CompositeAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CompositeAvailableCapacity, CompositeAvailableCapacity_sequence);

  return offset;
}


static const per_sequence_t CompositeAvailableCapacityGroup_sequence[] = {
  { &hf_xnap_compositeAvailableCapacityDownlink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CompositeAvailableCapacity },
  { &hf_xnap_compositeAvailableCapacityUplink, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CompositeAvailableCapacity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CompositeAvailableCapacityGroup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CompositeAvailableCapacityGroup, CompositeAvailableCapacityGroup_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_Item_sequence[] = {
  { &hf_xnap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_sliceAvailableCapacityValueDownlink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_sliceAvailableCapacityValueUplink, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_100 },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNSSAIAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNSSAIAvailableCapacity_Item, SNSSAIAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAIAvailableCapacity_List_sequence_of[1] = {
  { &hf_xnap_SNSSAIAvailableCapacity_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIAvailableCapacity_Item },
};

static int
dissect_xnap_SNSSAIAvailableCapacity_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SNSSAIAvailableCapacity_List, SNSSAIAvailableCapacity_List_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_Item_sequence[] = {
  { &hf_xnap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_sNSSAIAvailableCapacity_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIAvailableCapacity_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SliceAvailableCapacity_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SliceAvailableCapacity_Item, SliceAvailableCapacity_Item_sequence);

  return offset;
}


static const per_sequence_t SliceAvailableCapacity_sequence_of[1] = {
  { &hf_xnap_SliceAvailableCapacity_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SliceAvailableCapacity_Item },
};

static int
dissect_xnap_SliceAvailableCapacity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceAvailableCapacity, SliceAvailableCapacity_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}



static int
dissect_xnap_NumberofActiveUEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_NoofRRCConnections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 65536U, NULL, TRUE);

  return offset;
}


static const per_sequence_t RRCConnections_sequence[] = {
  { &hf_xnap_noofRRCConnections, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NoofRRCConnections },
  { &hf_xnap_availableRRCConnectionCapacityValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AvailableRRCConnectionCapacityValue },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCConnections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCConnections, RRCConnections_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_Item_sequence[] = {
  { &hf_xnap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_radioResourceStatus, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RadioResourceStatus },
  { &hf_xnap_tNLCapacityIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TNLCapacityIndicator },
  { &hf_xnap_compositeAvailableCapacityGroup, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CompositeAvailableCapacityGroup },
  { &hf_xnap_sliceAvailableCapacity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SliceAvailableCapacity },
  { &hf_xnap_numberofActiveUEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NumberofActiveUEs },
  { &hf_xnap_rRCConnections , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RRCConnections },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellMeasurementResult_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellMeasurementResult_Item, CellMeasurementResult_Item_sequence);

  return offset;
}


static const per_sequence_t CellMeasurementResult_sequence_of[1] = {
  { &hf_xnap_CellMeasurementResult_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellMeasurementResult_Item },
};

static int
dissect_xnap_CellMeasurementResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellMeasurementResult, CellMeasurementResult_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_Cell_Type_Choice_vals[] = {
  {   0, "ng-ran-e-utra" },
  {   1, "ng-ran-nr" },
  {   2, "e-utran" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Cell_Type_Choice_choice[] = {
  {   0, &hf_xnap_ng_ran_e_utra  , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   1, &hf_xnap_ng_ran_nr      , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_Cell_Identity },
  {   2, &hf_xnap_e_utran        , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_Cell_Identity },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Cell_Type_Choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Cell_Type_Choice, Cell_Type_Choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GlobalCell_ID_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_cell_type      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cell_Type_Choice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GlobalCell_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GlobalCell_ID, GlobalCell_ID_sequence);

  return offset;
}


static const per_sequence_t ReplacingCells_Item_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalCell_ID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ReplacingCells_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ReplacingCells_Item, ReplacingCells_Item_sequence);

  return offset;
}


static const per_sequence_t ReplacingCells_sequence_of[1] = {
  { &hf_xnap_ReplacingCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ReplacingCells_Item },
};

static int
dissect_xnap_ReplacingCells(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ReplacingCells, ReplacingCells_sequence_of,
                                                  0, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const per_sequence_t CellReplacingInfo_sequence[] = {
  { &hf_xnap_replacingCells , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReplacingCells },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellReplacingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellReplacingInfo, CellReplacingInfo_sequence);

  return offset;
}


static const per_sequence_t SSBToReport_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBToReport_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBToReport_List_Item, SSBToReport_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSBToReport_List_sequence_of[1] = {
  { &hf_xnap_SSBToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBToReport_List_Item },
};

static int
dissect_xnap_SSBToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBToReport_List, SSBToReport_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t SNSSAI_Item_sequence[] = {
  { &hf_xnap_sNSSAI         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNSSAI_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNSSAI_Item, SNSSAI_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAI_list_sequence_of[1] = {
  { &hf_xnap_SNSSAI_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAI_Item },
};

static int
dissect_xnap_SNSSAI_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SNSSAI_list, SNSSAI_list_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t SliceToReport_List_Item_sequence[] = {
  { &hf_xnap_pLMNIdentity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_sNSSAIlist     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAI_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SliceToReport_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SliceToReport_List_Item, SliceToReport_List_Item_sequence);

  return offset;
}


static const per_sequence_t SliceToReport_List_sequence_of[1] = {
  { &hf_xnap_SliceToReport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SliceToReport_List_Item },
};

static int
dissect_xnap_SliceToReport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceToReport_List, SliceToReport_List_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t CellToReport_Item_sequence[] = {
  { &hf_xnap_cell_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_sSBToReport_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SSBToReport_List },
  { &hf_xnap_sliceToReport_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SliceToReport_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CellToReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CellToReport_Item, CellToReport_Item_sequence);

  return offset;
}


static const per_sequence_t CellToReport_sequence_of[1] = {
  { &hf_xnap_CellToReport_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CellToReport_Item },
};

static int
dissect_xnap_CellToReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CellToReport, CellToReport_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}



static int
dissect_xnap_MeasObjectContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MeasObjectContainer);
    dissect_nr_rrc_MeasObjectToAddMod_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_ReportConfigContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_ReportConfigContainer);
    dissect_nr_rrc_ReportConfigToAddMod_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CHOExecutionCondition_Item_sequence[] = {
  { &hf_xnap_measObjectContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasObjectContainer },
  { &hf_xnap_reportConfigContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportConfigContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOExecutionCondition_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOExecutionCondition_Item, CHOExecutionCondition_Item_sequence);

  return offset;
}


static const per_sequence_t CHOExecutionCondition_List_sequence_of[1] = {
  { &hf_xnap_CHOExecutionCondition_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHOExecutionCondition_Item },
};

static int
dissect_xnap_CHOExecutionCondition_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHOExecutionCondition_List, CHOExecutionCondition_List_sequence_of,
                                                  1, maxnoofCHOexecutioncond, FALSE);

  return offset;
}


static const per_sequence_t CHOCandidateCell_Item_sequence[] = {
  { &hf_xnap_choCandidateCellID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_choExecutionCondition_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOExecutionCondition_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOCandidateCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOCandidateCell_Item, CHOCandidateCell_Item_sequence);

  return offset;
}


static const per_sequence_t CHOCandidateCell_List_sequence_of[1] = {
  { &hf_xnap_CHOCandidateCell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CHOCandidateCell_Item },
};

static int
dissect_xnap_CHOCandidateCell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CHOCandidateCell_List, CHOCandidateCell_List_sequence_of,
                                                  1, maxnoofCellsinCHO, FALSE);

  return offset;
}


static const per_sequence_t CHOConfiguration_sequence[] = {
  { &hf_xnap_choCandidateCell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOCandidateCell_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOConfiguration, CHOConfiguration_sequence);

  return offset;
}



static int
dissect_xnap_ControlPlaneTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, TRUE);

  return offset;
}


static const value_string xnap_CHO_MRDC_EarlyDataForwarding_vals[] = {
  {   0, "stop" },
  { 0, NULL }
};


static int
dissect_xnap_CHO_MRDC_EarlyDataForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CHO_MRDC_Indicator_vals[] = {
  {   0, "true" },
  {   1, "coordination-only" },
  { 0, NULL }
};


static int
dissect_xnap_CHO_MRDC_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 1, NULL);

  return offset;
}


static const value_string xnap_CHOtrigger_vals[] = {
  {   0, "cho-initiation" },
  {   1, "cho-replace" },
  { 0, NULL }
};


static int
dissect_xnap_CHOtrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_NG_RANnodeUEXnAPID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_CHO_Probability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CHOinformation_Req_sequence[] = {
  { &hf_xnap_cho_trigger    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CHOtrigger },
  { &hf_xnap_targetNG_RANnodeUEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_Req(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_Req, CHOinformation_Req_sequence);

  return offset;
}


static const value_string xnap_Target_CGI_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Target_CGI_choice[] = {
  {   0, &hf_xnap_nr_02          , ASN1_NO_EXTENSIONS     , dissect_xnap_NR_CGI },
  {   1, &hf_xnap_e_utra_02      , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_CGI },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Target_CGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Target_CGI, Target_CGI_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MaxCHOpreparations(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CHOinformation_Ack_sequence[] = {
  { &hf_xnap_requestedTargetCellGlobalID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Target_CGI },
  { &hf_xnap_maxCHOoperations, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaxCHOpreparations },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_Ack(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_Ack, CHOinformation_Ack_sequence);

  return offset;
}


static const per_sequence_t CHOinformation_AddReq_sequence[] = {
  { &hf_xnap_source_M_NGRAN_node_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_source_M_NGRAN_node_UE_XnAP_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_AddReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_AddReq, CHOinformation_AddReq_sequence);

  return offset;
}


static const value_string xnap_T_conditionalReconfig_vals[] = {
  {   0, "intra-mn-cho" },
  { 0, NULL }
};


static int
dissect_xnap_T_conditionalReconfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CHOinformation_ModReq_sequence[] = {
  { &hf_xnap_conditionalReconfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_conditionalReconfig },
  { &hf_xnap_cHO_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CHOinformation_ModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CHOinformation_ModReq, CHOinformation_ModReq_sequence);

  return offset;
}



static int
dissect_xnap_CNsubgroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const value_string xnap_ConfiguredTACIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_ConfiguredTACIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_eNDC_Support_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  { 0, NULL }
};


static int
dissect_xnap_T_eNDC_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Connectivity_Support_sequence[] = {
  { &hf_xnap_eNDC_Support   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_eNDC_Support },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Connectivity_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Connectivity_Support, Connectivity_Support_sequence);

  return offset;
}



static int
dissect_xnap_ContainerAppLayerMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 8000, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, FALSE);

  return offset;
}


static const per_sequence_t COUNT_PDCP_SN12_sequence[] = {
  { &hf_xnap_pdcp_SN12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_hfn_PDCP_SN12  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_1048575 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_COUNT_PDCP_SN12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_COUNT_PDCP_SN12, COUNT_PDCP_SN12_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t COUNT_PDCP_SN18_sequence[] = {
  { &hf_xnap_pdcp_SN18      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_262143 },
  { &hf_xnap_hfn_PDCP_SN18  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_16383 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_COUNT_PDCP_SN18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_COUNT_PDCP_SN18, COUNT_PDCP_SN18_sequence);

  return offset;
}


static const value_string xnap_CoverageModificationCause_vals[] = {
  {   0, "coverage" },
  {   1, "cell-edge-capacity" },
  { 0, NULL }
};


static int
dissect_xnap_CoverageModificationCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_63_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, TRUE);

  return offset;
}


static const per_sequence_t SSB_Coverage_Modification_List_Item_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_sSBCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15_ },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSB_Coverage_Modification_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSB_Coverage_Modification_List_Item, SSB_Coverage_Modification_List_Item_sequence);

  return offset;
}


static const per_sequence_t SSB_Coverage_Modification_List_sequence_of[1] = {
  { &hf_xnap_SSB_Coverage_Modification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_Coverage_Modification_List_Item },
};

static int
dissect_xnap_SSB_Coverage_Modification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSB_Coverage_Modification_List, SSB_Coverage_Modification_List_sequence_of,
                                                  0, maxnoofSSBAreas, FALSE);

  return offset;
}


static const per_sequence_t Coverage_Modification_List_Item_sequence[] = {
  { &hf_xnap_globalNG_RANCell_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalCell_ID },
  { &hf_xnap_cellCoverageState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63_ },
  { &hf_xnap_cellDeploymentStatusIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellDeploymentStatusIndicator },
  { &hf_xnap_cellReplacingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CellReplacingInfo },
  { &hf_xnap_sSB_Coverage_Modification_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_Coverage_Modification_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Coverage_Modification_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Coverage_Modification_List_Item, Coverage_Modification_List_Item_sequence);

  return offset;
}


static const per_sequence_t Coverage_Modification_List_sequence_of[1] = {
  { &hf_xnap_Coverage_Modification_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Coverage_Modification_List_Item },
};

static int
dissect_xnap_Coverage_Modification_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Coverage_Modification_List, Coverage_Modification_List_sequence_of,
                                                  0, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_CPTransportLayerInformation_vals[] = {
  {   0, "endpointIPAddress" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t CPTransportLayerInformation_choice[] = {
  {   0, &hf_xnap_endpointIPAddress, ASN1_NO_EXTENSIONS     , dissect_xnap_TransportLayerAddress },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_CPTransportLayerInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_CPTransportLayerInformation, CPTransportLayerInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACcandidatePSCells_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACcandidatePSCells_item, CPACcandidatePSCells_item_sequence);

  return offset;
}


static const per_sequence_t CPACcandidatePSCells_list_sequence_of[1] = {
  { &hf_xnap_CPACcandidatePSCells_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_item },
};

static int
dissect_xnap_CPACcandidatePSCells_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPACcandidatePSCells_list, CPACcandidatePSCells_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, FALSE);

  return offset;
}


static const value_string xnap_CPCindicator_vals[] = {
  {   0, "cpc-initiation" },
  {   1, "cpc-modification" },
  {   2, "cpc-cancellation" },
  { 0, NULL }
};


static int
dissect_xnap_CPCindicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofPSCellCandidates, NULL, TRUE);

  return offset;
}


static const per_sequence_t CPAInformationRequest_sequence[] = {
  { &hf_xnap_max_no_of_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationRequest, CPAInformationRequest_sequence);

  return offset;
}


static const per_sequence_t CPAInformationAck_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationAck, CPAInformationAck_sequence);

  return offset;
}



static int
dissect_xnap_T_sN_to_MN_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;

    subtree = proto_item_add_subtree(actx->created_item, ett_nxap_container);
    dissect_nr_rrc_CG_ConfigInfo_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t CPC_target_SN_required_list_Item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_cpc_indicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPCindicator },
  { &hf_xnap_max_no_of_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofPSCellCandidates_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_sN_to_MN_Container, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_sN_to_MN_Container },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_required_list_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_required_list_Item, CPC_target_SN_required_list_Item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_required_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_required_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_required_list_Item },
};

static int
dissect_xnap_CPC_target_SN_required_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_required_list, CPC_target_SN_required_list_sequence_of,
                                                  1, maxnoofTargetSNs, FALSE);

  return offset;
}


static const per_sequence_t CPCInformationRequired_sequence[] = {
  { &hf_xnap_cpc_target_sn_required_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_required_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationRequired, CPCInformationRequired_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_confirm_list_Item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_confirm_list_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_confirm_list_Item, CPC_target_SN_confirm_list_Item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_confirm_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_confirm_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_confirm_list_Item },
};

static int
dissect_xnap_CPC_target_SN_confirm_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_confirm_list, CPC_target_SN_confirm_list_sequence_of,
                                                  1, maxnoofTargetSNs, FALSE);

  return offset;
}


static const per_sequence_t CPCInformationConfirm_sequence[] = {
  { &hf_xnap_cpc_target_sn_confirm_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_confirm_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationConfirm(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationConfirm, CPCInformationConfirm_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_1_8_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t CPAInformationModReq_sequence[] = {
  { &hf_xnap_max_no_of_pscells_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_8_ },
  { &hf_xnap_cpac_EstimatedArrivalProbability, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CHO_Probability },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationModReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationModReq, CPAInformationModReq_sequence);

  return offset;
}


static const per_sequence_t CPAInformationModReqAck_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPAInformationModReqAck(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPAInformationModReqAck, CPAInformationModReqAck_sequence);

  return offset;
}


static const value_string xnap_CPC_DataForwarding_Indicator_vals[] = {
  {   0, "triggered" },
  {   1, "early-data-transmission-stop" },
  {   2, "coordination-only" },
  { 0, NULL }
};


static int
dissect_xnap_CPC_DataForwarding_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t CPACInformationModRequired_sequence[] = {
  { &hf_xnap_candidate_pscells, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPACcandidatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPACInformationModRequired(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPACInformationModRequired, CPACInformationModRequired_sequence);

  return offset;
}


static const per_sequence_t CPCInformationUpdatePSCells_item_sequence[] = {
  { &hf_xnap_pscell_id      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationUpdatePSCells_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationUpdatePSCells_item, CPCInformationUpdatePSCells_item_sequence);

  return offset;
}


static const per_sequence_t CPCInformationUpdatePSCells_list_sequence_of[1] = {
  { &hf_xnap_CPCInformationUpdatePSCells_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPCInformationUpdatePSCells_item },
};

static int
dissect_xnap_CPCInformationUpdatePSCells_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPCInformationUpdatePSCells_list, CPCInformationUpdatePSCells_list_sequence_of,
                                                  1, maxnoofPSCellCandidates, FALSE);

  return offset;
}


static const per_sequence_t CPC_target_SN_mod_item_sequence[] = {
  { &hf_xnap_target_S_NG_RANnodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_candidate_pscells_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPCInformationUpdatePSCells_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPC_target_SN_mod_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPC_target_SN_mod_item, CPC_target_SN_mod_item_sequence);

  return offset;
}


static const per_sequence_t CPC_target_SN_mod_list_sequence_of[1] = {
  { &hf_xnap_CPC_target_SN_mod_list_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_mod_item },
};

static int
dissect_xnap_CPC_target_SN_mod_list(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CPC_target_SN_mod_list, CPC_target_SN_mod_list_sequence_of,
                                                  1, maxnoofTargetSNs, FALSE);

  return offset;
}


static const per_sequence_t CPCInformationUpdate_sequence[] = {
  { &hf_xnap_cpc_target_sn_list, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPC_target_SN_mod_list },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CPCInformationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CPCInformationUpdate, CPCInformationUpdate_sequence);

  return offset;
}


static const value_string xnap_TypeOfError_vals[] = {
  {   0, "not-understood" },
  {   1, "missing" },
  { 0, NULL }
};


static int
dissect_xnap_TypeOfError(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_xnap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Criticality },
  { &hf_xnap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_ID },
  { &hf_xnap_typeOfError    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TypeOfError },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_xnap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_xnap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxNrOfErrors, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_xnap_procedureCode  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProcedureCode },
  { &hf_xnap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TriggeringMessage },
  { &hf_xnap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Criticality },
  { &hf_xnap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_CriticalityDiagnostics_IE_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_xnap_C_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_CyclicPrefix_E_UTRA_DL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_CyclicPrefix_E_UTRA_DL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CyclicPrefix_E_UTRA_UL_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_CyclicPrefix_E_UTRA_UL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_CSI_RSTransmissionIndication_vals[] = {
  {   0, "activated" },
  {   1, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_CSI_RSTransmissionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_PDUSession_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence[] = {
  { &hf_xnap_dRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_Xn_U_TNLInfoatM, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item, DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence_of[1] = {
  { &hf_xnap_dRBsToBeSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item, SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceBearerSetupCompleteInfo_SNterminated_sequence[] = {
  { &hf_xnap_dRBsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofDRBs_OF_DRBsToBeSetupList_BearerSetupComplete_SNterminated_Item },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated, PDUSessionResourceBearerSetupCompleteInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t XnUAddressInfoperPDUSession_Item_sequence[] = {
  { &hf_xnap_pduSession_ID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataForwardingInfoFromTargetNGRANnode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_pduSessionResourceSetupCompleteInfo_SNterm, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionResourceBearerSetupCompleteInfo_SNterminated },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_XnUAddressInfoperPDUSession_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_XnUAddressInfoperPDUSession_Item, XnUAddressInfoperPDUSession_Item_sequence);

  return offset;
}


static const per_sequence_t XnUAddressInfoperPDUSession_List_sequence_of[1] = {
  { &hf_xnap_XnUAddressInfoperPDUSession_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_XnUAddressInfoperPDUSession_Item },
};

static int
dissect_xnap_XnUAddressInfoperPDUSession_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_XnUAddressInfoperPDUSession_List, XnUAddressInfoperPDUSession_List_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t QoSFlowsToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeForwarded_Item, QoSFlowsToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeForwarded_Item },
};

static int
dissect_xnap_QoSFlowsToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeForwarded_List, QoSFlowsToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_Item_sequence[] = {
  { &hf_xnap_dlForwardingUPTNLInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_qosFlowsToBeForwarded_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeForwarded_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item, DataForwardingInfoFromTargetE_UTRANnode_Item_sequence);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_List_sequence_of[1] = {
  { &hf_xnap_DataForwardingInfoFromTargetE_UTRANnode_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_Item },
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DataForwardingInfoFromTargetE_UTRANnode_List, DataForwardingInfoFromTargetE_UTRANnode_List_sequence_of,
                                                  1, maxnoofDataForwardingTunneltoE_UTRAN, FALSE);

  return offset;
}


static const per_sequence_t DataForwardingInfoFromTargetE_UTRANnode_sequence[] = {
  { &hf_xnap_dataForwardingInfoFromTargetE_UTRANnode_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataForwardingInfoFromTargetE_UTRANnode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataForwardingInfoFromTargetE_UTRANnode, DataForwardingInfoFromTargetE_UTRANnode_sequence);

  return offset;
}


static const value_string xnap_DLForwarding_vals[] = {
  {   0, "dl-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_xnap_DLForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_ULForwarding_vals[] = {
  {   0, "ul-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_xnap_ULForwarding(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFLowsToBeForwarded_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_dl_dataforwarding, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLForwarding },
  { &hf_xnap_ul_dataforwarding, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ULForwarding },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFLowsToBeForwarded_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFLowsToBeForwarded_Item, QoSFLowsToBeForwarded_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFLowsToBeForwarded_List_sequence_of[1] = {
  { &hf_xnap_QoSFLowsToBeForwarded_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsToBeForwarded_Item },
};

static int
dissect_xnap_QoSFLowsToBeForwarded_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFLowsToBeForwarded_List, QoSFLowsToBeForwarded_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const value_string xnap_QoSFlowMappingIndication_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  { 0, NULL }
};


static int
dissect_xnap_QoSFlowMappingIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlow_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlow_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlow_Item, QoSFlow_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlows_List_sequence_of[1] = {
  { &hf_xnap_QoSFlows_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlow_Item },
};

static int
dissect_xnap_QoSFlows_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlows_List, QoSFlows_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const value_string xnap_RLCMode_vals[] = {
  {   0, "rlc-am" },
  {   1, "rlc-um-bidirectional" },
  {   2, "rlc-um-unidirectional-ul" },
  {   3, "rlc-um-unidirectional-dl" },
  { 0, NULL }
};


static int
dissect_xnap_RLCMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DRBToQoSFlowMapping_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_qosFlows_List  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlows_List },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBToQoSFlowMapping_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBToQoSFlowMapping_Item, DRBToQoSFlowMapping_Item_sequence);

  return offset;
}


static const per_sequence_t DRBToQoSFlowMapping_List_sequence_of[1] = {
  { &hf_xnap_DRBToQoSFlowMapping_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBToQoSFlowMapping_Item },
};

static int
dissect_xnap_DRBToQoSFlowMapping_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBToQoSFlowMapping_List, DRBToQoSFlowMapping_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DataforwardingandOffloadingInfofromSource_sequence[] = {
  { &hf_xnap_qosFlowsToBeForwarded, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFLowsToBeForwarded_List },
  { &hf_xnap_sourceDRBtoQoSFlowMapping, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBToQoSFlowMapping_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataforwardingandOffloadingInfofromSource(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataforwardingandOffloadingInfofromSource, DataforwardingandOffloadingInfofromSource_sequence);

  return offset;
}



static int
dissect_xnap_DataTrafficResources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 17600, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SharedResourceType_UL_OnlySharing_sequence[] = {
  { &hf_xnap_ul_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_UL_OnlySharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_UL_OnlySharing, SharedResourceType_UL_OnlySharing_sequence);

  return offset;
}



static int
dissect_xnap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t SharedResourceType_ULDL_Sharing_UL_ResourcesChanged_sequence[] = {
  { &hf_xnap_ul_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged, SharedResourceType_ULDL_Sharing_UL_ResourcesChanged_sequence);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_UL_Resources_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_UL_Resources_choice[] = {
  {   0, &hf_xnap_unchanged      , ASN1_NO_EXTENSIONS     , dissect_xnap_NULL },
  {   1, &hf_xnap_changed        , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_UL_ResourcesChanged },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_UL_Resources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing_UL_Resources, SharedResourceType_ULDL_Sharing_UL_Resources_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SharedResourceType_ULDL_Sharing_DL_ResourcesChanged_sequence[] = {
  { &hf_xnap_dl_resourceBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataTrafficResources },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged, SharedResourceType_ULDL_Sharing_DL_ResourcesChanged_sequence);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_DL_Resources_vals[] = {
  {   0, "unchanged" },
  {   1, "changed" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_DL_Resources_choice[] = {
  {   0, &hf_xnap_unchanged      , ASN1_NO_EXTENSIONS     , dissect_xnap_NULL },
  {   1, &hf_xnap_changed_01     , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_DL_ResourcesChanged },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing_DL_Resources(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing_DL_Resources, SharedResourceType_ULDL_Sharing_DL_Resources_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_SharedResourceType_ULDL_Sharing_vals[] = {
  {   0, "ul-resources" },
  {   1, "dl-resources" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_ULDL_Sharing_choice[] = {
  {   0, &hf_xnap_ul_resources   , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_UL_Resources },
  {   1, &hf_xnap_dl_resources   , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing_DL_Resources },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType_ULDL_Sharing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType_ULDL_Sharing, SharedResourceType_ULDL_Sharing_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_SharedResourceType_vals[] = {
  {   0, "ul-onlySharing" },
  {   1, "ul-and-dl-Sharing" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SharedResourceType_choice[] = {
  {   0, &hf_xnap_ul_onlySharing , ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_UL_OnlySharing },
  {   1, &hf_xnap_ul_and_dl_Sharing, ASN1_NO_EXTENSIONS     , dissect_xnap_SharedResourceType_ULDL_Sharing },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SharedResourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SharedResourceType, SharedResourceType_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_subframeType_vals[] = {
  {   0, "mbsfn" },
  {   1, "non-mbsfn" },
  { 0, NULL }
};


static int
dissect_xnap_T_subframeType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_10_160(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 160, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_MBSFNControlRegionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ReservedSubframePattern_sequence[] = {
  { &hf_xnap_subframeType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_subframeType },
  { &hf_xnap_reservedSubframePattern_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_10_160 },
  { &hf_xnap_mbsfnControlRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBSFNControlRegionLength },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ReservedSubframePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ReservedSubframePattern, ReservedSubframePattern_sequence);

  return offset;
}


static const per_sequence_t DataTrafficResourceIndication_sequence[] = {
  { &hf_xnap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ActivationSFN },
  { &hf_xnap_sharedResourceType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SharedResourceType },
  { &hf_xnap_reservedSubframePattern, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ReservedSubframePattern },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DataTrafficResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DataTrafficResourceIndication, DataTrafficResourceIndication_sequence);

  return offset;
}


static const value_string xnap_T_dapsIndicator_vals[] = {
  {   0, "daps-HO-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_dapsIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSRequestInfo_sequence[] = {
  { &hf_xnap_dapsIndicator  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dapsIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DAPSRequestInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DAPSRequestInfo, DAPSRequestInfo_sequence);

  return offset;
}


static const value_string xnap_T_dapsResponseIndicator_vals[] = {
  {   0, "daps-HO-accepted" },
  {   1, "daps-HO-not-accepted" },
  { 0, NULL }
};


static int
dissect_xnap_T_dapsResponseIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dapsResponseIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dapsResponseIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DAPSResponseInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DAPSResponseInfo_Item, DAPSResponseInfo_Item_sequence);

  return offset;
}


static const per_sequence_t DAPSResponseInfo_List_sequence_of[1] = {
  { &hf_xnap_DAPSResponseInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DAPSResponseInfo_Item },
};

static int
dissect_xnap_DAPSResponseInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DAPSResponseInfo_List, DAPSResponseInfo_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}



static int
dissect_xnap_DeliveryStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, TRUE);

  return offset;
}


static const value_string xnap_DesiredActNotificationLevel_vals[] = {
  {   0, "none" },
  {   1, "qos-flow" },
  {   2, "pdu-session" },
  {   3, "ue-level" },
  { 0, NULL }
};


static int
dissect_xnap_DesiredActNotificationLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DefaultDRB_Allowed_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_DefaultDRB_Allowed(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DirectForwardingPathAvailability_vals[] = {
  {   0, "direct-path-available" },
  { 0, NULL }
};


static int
dissect_xnap_DirectForwardingPathAvailability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DLCountChoice_vals[] = {
  {   0, "count12bits" },
  {   1, "count18bits" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DLCountChoice_choice[] = {
  {   0, &hf_xnap_count12bits    , ASN1_NO_EXTENSIONS     , dissect_xnap_COUNT_PDCP_SN12 },
  {   1, &hf_xnap_count18bits    , ASN1_NO_EXTENSIONS     , dissect_xnap_COUNT_PDCP_SN18 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DLCountChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DLCountChoice, DLCountChoice_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_DL_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_DL_non_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DLF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_egressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_egressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DLF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DLF1Terminating_BHInfo, DLF1Terminating_BHInfo_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t IAB_QoS_Mapping_Information_sequence[] = {
  { &hf_xnap_dscp           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6 },
  { &hf_xnap_flow_label     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_20 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_QoS_Mapping_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_QoS_Mapping_Information, IAB_QoS_Mapping_Information_sequence);

  return offset;
}


static const per_sequence_t DLNonF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_ingressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_ingressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_priorhopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iabqosMappingInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_QoS_Mapping_Information },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DLNonF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DLNonF1Terminating_BHInfo, DLNonF1Terminating_BHInfo_sequence);

  return offset;
}



static int
dissect_xnap_DL_Total_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DRB_List_sequence_of[1] = {
  { &hf_xnap_DRB_List_item  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
};

static int
dissect_xnap_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRB_List, DRB_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DRB_List_withCause_Item_sequence[] = {
  { &hf_xnap_drb_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Cause },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRB_List_withCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRB_List_withCause_Item, DRB_List_withCause_Item_sequence);

  return offset;
}


static const per_sequence_t DRB_List_withCause_sequence_of[1] = {
  { &hf_xnap_DRB_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_List_withCause_Item },
};

static int
dissect_xnap_DRB_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRB_List_withCause, DRB_List_withCause_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}



static int
dissect_xnap_DRB_Number(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlCount        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLCountChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToDLDiscarding_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToDLDiscarding_Item, DRBsSubjectToDLDiscarding_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToDLDiscarding_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToDLDiscarding_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToDLDiscarding_Item },
};

static int
dissect_xnap_DRBsSubjectToDLDiscarding_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToDLDiscarding_List, DRBsSubjectToDLDiscarding_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dlCount        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DLCountChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToEarlyStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToEarlyStatusTransfer_Item, DRBsSubjectToEarlyStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToEarlyStatusTransfer_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToEarlyStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToEarlyStatusTransfer_Item },
};

static int
dissect_xnap_DRBsSubjectToEarlyStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToEarlyStatusTransfer_List, DRBsSubjectToEarlyStatusTransfer_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_1_2048(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 2048, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBBStatusTransfer12bitsSN_sequence[] = {
  { &hf_xnap_receiveStatusofPDCPSDU, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_1_2048 },
  { &hf_xnap_cOUNTValue     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_COUNT_PDCP_SN12 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransfer12bitsSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBBStatusTransfer12bitsSN, DRBBStatusTransfer12bitsSN_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_1_131072(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 131072, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t DRBBStatusTransfer18bitsSN_sequence[] = {
  { &hf_xnap_receiveStatusofPDCPSDU_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_1_131072 },
  { &hf_xnap_cOUNTValue_01  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_COUNT_PDCP_SN18 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransfer18bitsSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBBStatusTransfer18bitsSN, DRBBStatusTransfer18bitsSN_sequence);

  return offset;
}


static const value_string xnap_DRBBStatusTransferChoice_vals[] = {
  {   0, "pdcp-sn-12bits" },
  {   1, "pdcp-sn-18bits" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DRBBStatusTransferChoice_choice[] = {
  {   0, &hf_xnap_pdcp_sn_12bits , ASN1_NO_EXTENSIONS     , dissect_xnap_DRBBStatusTransfer12bitsSN },
  {   1, &hf_xnap_pdcp_sn_18bits , ASN1_NO_EXTENSIONS     , dissect_xnap_DRBBStatusTransfer18bitsSN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DRBBStatusTransferChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DRBBStatusTransferChoice, DRBBStatusTransferChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransfer_Item_sequence[] = {
  { &hf_xnap_drbID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_pdcpStatusTransfer_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBBStatusTransferChoice },
  { &hf_xnap_pdcpStatusTransfer_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBBStatusTransferChoice },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsSubjectToStatusTransfer_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsSubjectToStatusTransfer_Item, DRBsSubjectToStatusTransfer_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsSubjectToStatusTransfer_List_sequence_of[1] = {
  { &hf_xnap_DRBsSubjectToStatusTransfer_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsSubjectToStatusTransfer_Item },
};

static int
dissect_xnap_DRBsSubjectToStatusTransfer_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsSubjectToStatusTransfer_List, DRBsSubjectToStatusTransfer_List_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const value_string xnap_Permutation_vals[] = {
  {   0, "dfu" },
  {   1, "ufd" },
  { 0, NULL }
};


static int
dissect_xnap_Permutation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ExplicitFormat_sequence[] = {
  { &hf_xnap_permutation    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Permutation },
  { &hf_xnap_noofDownlinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_14 },
  { &hf_xnap_noofUplinkSymbols, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_14 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExplicitFormat, ExplicitFormat_sequence);

  return offset;
}



static int
dissect_xnap_DUFSlotformatIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ImplicitFormat_sequence[] = {
  { &hf_xnap_dUFSlotformatIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DUFSlotformatIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ImplicitFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ImplicitFormat, ImplicitFormat_sequence);

  return offset;
}


static const value_string xnap_DUF_Slot_Config_Item_vals[] = {
  {   0, "explicitFormat" },
  {   1, "implicitFormat" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t DUF_Slot_Config_Item_choice[] = {
  {   0, &hf_xnap_explicitFormat , ASN1_NO_EXTENSIONS     , dissect_xnap_ExplicitFormat },
  {   1, &hf_xnap_implicitFormat , ASN1_NO_EXTENSIONS     , dissect_xnap_ImplicitFormat },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_DUF_Slot_Config_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_DUF_Slot_Config_Item, DUF_Slot_Config_Item_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DUF_Slot_Config_List_sequence_of[1] = {
  { &hf_xnap_DUF_Slot_Config_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DUF_Slot_Config_Item },
};

static int
dissect_xnap_DUF_Slot_Config_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DUF_Slot_Config_List, DUF_Slot_Config_List_sequence_of,
                                                  1, maxnoofDUFSlots, FALSE);

  return offset;
}


static const value_string xnap_DUFTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  { 0, NULL }
};


static int
dissect_xnap_DUFTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DU_RX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_RX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DU_TX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_TX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DU_RX_MT_TX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_RX_MT_TX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DU_TX_MT_RX_vals[] = {
  {   0, "supported" },
  {   1, "not-supported" },
  {   2, "supported-FDM-required" },
  { 0, NULL }
};


static int
dissect_xnap_DU_TX_MT_RX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_DuplicationActivation_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_xnap_DuplicationActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_EarlyMeasurement_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_EarlyMeasurement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_E_RAB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_E_UTRAARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_E_UTRAFrequencyBandIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}


static const per_sequence_t E_UTRAMultibandInfoList_sequence_of[1] = {
  { &hf_xnap_E_UTRAMultibandInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAFrequencyBandIndicator },
};

static int
dissect_xnap_E_UTRAMultibandInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_E_UTRAMultibandInfoList, E_UTRAMultibandInfoList_sequence_of,
                                                  1, maxnoofEUTRABands, FALSE);

  return offset;
}


static const value_string xnap_EUTRAPaging_eDRX_Cycle_vals[] = {
  {   0, "hfhalf" },
  {   1, "hf1" },
  {   2, "hf2" },
  {   3, "hf4" },
  {   4, "hf6" },
  {   5, "hf8" },
  {   6, "hf10" },
  {   7, "hf12" },
  {   8, "hf14" },
  {   9, "hf16" },
  {  10, "hf32" },
  {  11, "hf64" },
  {  12, "hf128" },
  {  13, "hf256" },
  { 0, NULL }
};


static int
dissect_xnap_EUTRAPaging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_EUTRAPaging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  { 0, NULL }
};


static int
dissect_xnap_EUTRAPaging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t EUTRAPagingeDRXInformation_sequence[] = {
  { &hf_xnap_eutrapaging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EUTRAPaging_eDRX_Cycle },
  { &hf_xnap_eutrapaging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_EUTRAPaging_Time_Window },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EUTRAPagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EUTRAPagingeDRXInformation, EUTRAPagingeDRXInformation_sequence);

  return offset;
}



static int
dissect_xnap_E_UTRAPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_837(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 837U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string xnap_T_highSpeedFlag_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_highSpeedFlag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_94(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 94U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_UTRAPRACHConfiguration_sequence[] = {
  { &hf_xnap_rootSequenceIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_837 },
  { &hf_xnap_zeroCorrelationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_15 },
  { &hf_xnap_highSpeedFlag  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_highSpeedFlag },
  { &hf_xnap_prach_FreqOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_94 },
  { &hf_xnap_prach_ConfigIndex, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRAPRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRAPRACHConfiguration, E_UTRAPRACHConfiguration_sequence);

  return offset;
}


static const value_string xnap_E_UTRATransmissionBandwidth_vals[] = {
  {   0, "bw6" },
  {   1, "bw15" },
  {   2, "bw25" },
  {   3, "bw50" },
  {   4, "bw75" },
  {   5, "bw100" },
  {   6, "bw1" },
  { 0, NULL }
};


static int
dissect_xnap_E_UTRATransmissionBandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_xnap_PortNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     16, 16, FALSE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 2, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t EndpointIPAddressAndPort_sequence[] = {
  { &hf_xnap_endpointIPAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_portNumber     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PortNumber },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EndpointIPAddressAndPort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EndpointIPAddressAndPort, EndpointIPAddressAndPort_sequence);

  return offset;
}


static const value_string xnap_T_outOfCoverage_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_outOfCoverage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_Threshold_RSRP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Threshold_RSRQ(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const value_string xnap_MeasurementThresholdL1LoggedMDT_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdL1LoggedMDT_choice[] = {
  {   0, &hf_xnap_threshold_RSRP , ASN1_EXTENSION_ROOT    , dissect_xnap_Threshold_RSRP },
  {   1, &hf_xnap_threshold_RSRQ , ASN1_EXTENSION_ROOT    , dissect_xnap_Threshold_RSRQ },
  {   2, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MeasurementThresholdL1LoggedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MeasurementThresholdL1LoggedMDT, MeasurementThresholdL1LoggedMDT_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_Hysteresis(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, FALSE);

  return offset;
}


static const value_string xnap_TimeToTrigger_vals[] = {
  {   0, "ms0" },
  {   1, "ms40" },
  {   2, "ms64" },
  {   3, "ms80" },
  {   4, "ms100" },
  {   5, "ms128" },
  {   6, "ms160" },
  {   7, "ms256" },
  {   8, "ms320" },
  {   9, "ms480" },
  {  10, "ms512" },
  {  11, "ms640" },
  {  12, "ms1024" },
  {  13, "ms1280" },
  {  14, "ms2560" },
  {  15, "ms5120" },
  { 0, NULL }
};


static int
dissect_xnap_TimeToTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EventL1_sequence[] = {
  { &hf_xnap_l1Threshold    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementThresholdL1LoggedMDT },
  { &hf_xnap_hysteresis     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Hysteresis },
  { &hf_xnap_timeToTrigger  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TimeToTrigger },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EventL1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EventL1, EventL1_sequence);

  return offset;
}


static const value_string xnap_EventTypeTrigger_vals[] = {
  {   0, "outOfCoverage" },
  {   1, "eventL1" },
  {   2, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t EventTypeTrigger_choice[] = {
  {   0, &hf_xnap_outOfCoverage  , ASN1_NO_EXTENSIONS     , dissect_xnap_T_outOfCoverage },
  {   1, &hf_xnap_eventL1        , ASN1_NO_EXTENSIONS     , dissect_xnap_EventL1 },
  {   2, &hf_xnap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_EventTypeTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_EventTypeTrigger, EventTypeTrigger_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedEventTriggeredConfig_sequence[] = {
  { &hf_xnap_eventTypeTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EventTypeTrigger },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LoggedEventTriggeredConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LoggedEventTriggeredConfig, LoggedEventTriggeredConfig_sequence);

  return offset;
}


static const per_sequence_t EventTriggered_sequence[] = {
  { &hf_xnap_loggedEventTriggeredConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggedEventTriggeredConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_EventTriggered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_EventTriggered, EventTriggered_sequence);

  return offset;
}


static const value_string xnap_EventType_vals[] = {
  {   0, "report-upon-change-of-serving-cell" },
  {   1, "report-UE-moving-presence-into-or-out-of-the-Area-of-Interest" },
  {   2, "report-upon-change-of-serving-cell-and-Area-of-Interest" },
  { 0, NULL }
};


static int
dissect_xnap_EventType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 1, NULL);

  return offset;
}


static const value_string xnap_ExcessPacketDelayThresholdValue_vals[] = {
  {   0, "ms0dot25" },
  {   1, "ms0dot5" },
  {   2, "ms1" },
  {   3, "ms2" },
  {   4, "ms4" },
  {   5, "ms5" },
  {   6, "ms10" },
  {   7, "ms20" },
  {   8, "ms30" },
  {   9, "ms40" },
  {  10, "ms50" },
  {  11, "ms60" },
  {  12, "ms70" },
  {  13, "ms80" },
  {  14, "ms90" },
  {  15, "ms100" },
  {  16, "ms150" },
  {  17, "ms300" },
  {  18, "ms500" },
  { 0, NULL }
};


static int
dissect_xnap_ExcessPacketDelayThresholdValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     19, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdItem_sequence[] = {
  { &hf_xnap_fiveQI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_excessPacketDelayThresholdValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ExcessPacketDelayThresholdValue },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExcessPacketDelayThresholdItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExcessPacketDelayThresholdItem, ExcessPacketDelayThresholdItem_sequence);

  return offset;
}


static const per_sequence_t ExcessPacketDelayThresholdConfiguration_sequence_of[1] = {
  { &hf_xnap_ExcessPacketDelayThresholdConfiguration_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExcessPacketDelayThresholdItem },
};

static int
dissect_xnap_ExcessPacketDelayThresholdConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExcessPacketDelayThresholdConfiguration, ExcessPacketDelayThresholdConfiguration_sequence_of,
                                                  1, maxnoofThresholdsForExcessPacketDelay, FALSE);

  return offset;
}



static int
dissect_xnap_ExpectedActivityPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, TRUE);

  return offset;
}


static const value_string xnap_ExpectedHOInterval_vals[] = {
  {   0, "sec15" },
  {   1, "sec30" },
  {   2, "sec60" },
  {   3, "sec90" },
  {   4, "sec120" },
  {   5, "sec180" },
  {   6, "long-time" },
  { 0, NULL }
};


static int
dissect_xnap_ExpectedHOInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_ExpectedIdlePeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 181U, NULL, TRUE);

  return offset;
}


static const value_string xnap_SourceOfUEActivityBehaviourInformation_vals[] = {
  {   0, "subscription-information" },
  {   1, "statistics" },
  { 0, NULL }
};


static int
dissect_xnap_SourceOfUEActivityBehaviourInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEActivityBehaviour_sequence[] = {
  { &hf_xnap_expectedActivityPeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedActivityPeriod },
  { &hf_xnap_expectedIdlePeriod, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedIdlePeriod },
  { &hf_xnap_sourceOfUEActivityBehaviourInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SourceOfUEActivityBehaviourInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEActivityBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEActivityBehaviour, ExpectedUEActivityBehaviour_sequence);

  return offset;
}


static const value_string xnap_ExpectedUEMobility_vals[] = {
  {   0, "stationary" },
  {   1, "mobile" },
  { 0, NULL }
};


static int
dissect_xnap_ExpectedUEMobility(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectoryItem_sequence[] = {
  { &hf_xnap_nGRAN_CGI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_timeStayedInCell, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_4095 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEMovingTrajectoryItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEMovingTrajectoryItem, ExpectedUEMovingTrajectoryItem_sequence);

  return offset;
}


static const per_sequence_t ExpectedUEMovingTrajectory_sequence_of[1] = {
  { &hf_xnap_ExpectedUEMovingTrajectory_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExpectedUEMovingTrajectoryItem },
};

static int
dissect_xnap_ExpectedUEMovingTrajectory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExpectedUEMovingTrajectory, ExpectedUEMovingTrajectory_sequence_of,
                                                  1, maxnoofCellsUEMovingTrajectory, FALSE);

  return offset;
}


static const per_sequence_t ExpectedUEBehaviour_sequence[] = {
  { &hf_xnap_expectedUEActivityBehaviour, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEActivityBehaviour },
  { &hf_xnap_expectedHOInterval, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedHOInterval },
  { &hf_xnap_expectedUEMobility, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEMobility },
  { &hf_xnap_expectedUEMovingTrajectory, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExpectedUEMovingTrajectory },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExpectedUEBehaviour(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExpectedUEBehaviour, ExpectedUEBehaviour_sequence);

  return offset;
}



static int
dissect_xnap_T_primaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, TRUE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_primaryRATRestriction_e_UTRA,
      &hf_xnap_primaryRATRestriction_nR,
      &hf_xnap_primaryRATRestriction_nR_unlicensed,
      &hf_xnap_primaryRATRestriction_nR_LEO,
      &hf_xnap_primaryRATRestriction_nR_MEO,
      &hf_xnap_primaryRATRestriction_nR_GEO,
      &hf_xnap_primaryRATRestriction_nR_OTHERSAT,
      &hf_xnap_primaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_primaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}



static int
dissect_xnap_T_secondaryRATRestriction(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, TRUE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_secondaryRATRestriction_e_UTRA,
      &hf_xnap_secondaryRATRestriction_nR,
      &hf_xnap_secondaryRATRestriction_e_UTRA_unlicensed,
      &hf_xnap_secondaryRATRestriction_nR_unlicensed,
      &hf_xnap_secondaryRATRestriction_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_secondaryRATRestriction);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const per_sequence_t ExtendedRATRestrictionInformation_sequence[] = {
  { &hf_xnap_primaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_primaryRATRestriction },
  { &hf_xnap_secondaryRATRestriction, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_secondaryRATRestriction },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExtendedRATRestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExtendedRATRestrictionInformation, ExtendedRATRestrictionInformation_sequence);

  return offset;
}



static int
dissect_xnap_ExtendedPacketDelayBudget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ExtendedSliceSupportList_sequence_of[1] = {
  { &hf_xnap_ExtendedSliceSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_ExtendedSliceSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExtendedSliceSupportList, ExtendedSliceSupportList_sequence_of,
                                                  1, maxnoofExtSliceItems, FALSE);

  return offset;
}



static int
dissect_xnap_ExtendedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GTPTLA_Item_sequence[] = {
  { &hf_xnap_gTPTransportLayerAddresses_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GTPTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GTPTLA_Item, GTPTLA_Item_sequence);

  return offset;
}


static const per_sequence_t GTPTLAs_sequence_of[1] = {
  { &hf_xnap_GTPTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_GTPTLA_Item },
};

static int
dissect_xnap_GTPTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_GTPTLAs, GTPTLAs_sequence_of,
                                                  1, maxnoofGTPTLAs, FALSE);

  return offset;
}


static const per_sequence_t ExtTLA_Item_sequence[] = {
  { &hf_xnap_iPsecTLA       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TransportLayerAddress },
  { &hf_xnap_gTPTransportLayerAddresses, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GTPTLAs },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ExtTLA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ExtTLA_Item, ExtTLA_Item_sequence);

  return offset;
}


static const per_sequence_t ExtTLAs_sequence_of[1] = {
  { &hf_xnap_ExtTLAs_item   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ExtTLA_Item },
};

static int
dissect_xnap_ExtTLAs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ExtTLAs, ExtTLAs_sequence_of,
                                                  1, maxnoofExtTLAs, FALSE);

  return offset;
}



static int
dissect_xnap_F1CTrafficContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const value_string xnap_F1_terminatingIAB_donorIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_F1_terminatingIAB_donorIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_iPv4Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 4, ENC_BIG_ENDIAN);


  return offset;
}



static int
dissect_xnap_T_iPv6Address(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     128, 128, FALSE, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 16, ENC_BIG_ENDIAN);


  return offset;
}



static int
dissect_xnap_T_iPv6Prefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     64, 64, FALSE, NULL, 0, &parameter_tvb, NULL);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, 8, ENC_NA);


  return offset;
}


static const value_string xnap_IABTNLAddress_vals[] = {
  {   0, "iPv4Address" },
  {   1, "iPv6Address" },
  {   2, "iPv6Prefix" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABTNLAddress_choice[] = {
  {   0, &hf_xnap_iPv4Address    , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv4Address },
  {   1, &hf_xnap_iPv6Address_01 , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv6Address },
  {   2, &hf_xnap_iPv6Prefix_01  , ASN1_NO_EXTENSIONS     , dissect_xnap_T_iPv6Prefix },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IABTNLAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IABTNLAddress, IABTNLAddress_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ULF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_ingressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_ingressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULF1Terminating_BHInfo, ULF1Terminating_BHInfo_sequence);

  return offset;
}


static const per_sequence_t F1TerminatingBHInformation_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_dLTNLAddress   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_dlF1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DLF1Terminating_BHInfo },
  { &hf_xnap_ulF1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULF1Terminating_BHInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_F1TerminatingBHInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_F1TerminatingBHInformation_Item, F1TerminatingBHInformation_Item_sequence);

  return offset;
}


static const per_sequence_t F1TerminatingBHInformation_List_sequence_of[1] = {
  { &hf_xnap_F1TerminatingBHInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_F1TerminatingBHInformation_Item },
};

static int
dissect_xnap_F1TerminatingBHInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_F1TerminatingBHInformation_List, F1TerminatingBHInformation_List_sequence_of,
                                                  1, maxnoofBHInfo, FALSE);

  return offset;
}


static const per_sequence_t F1_TerminatingTopologyBHInformation_sequence[] = {
  { &hf_xnap_f1TerminatingBHInformation_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_F1TerminatingBHInformation_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_F1_TerminatingTopologyBHInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_F1_TerminatingTopologyBHInformation, F1_TerminatingTopologyBHInformation_sequence);

  return offset;
}



static int
dissect_xnap_FiveGCMobilityRestrictionListContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_FiveGCMobilityRestrictionListContainer);
    dissect_ngap_MobilityRestrictionList_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_FiveGProSeDirectDiscovery_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeDirectDiscovery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeDirectCommunication_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeDirectCommunication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer3UEtoNetworkRelay_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer3UEtoNetworkRelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_FiveGProSeLayer2RemoteUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_FiveGProSeLayer2RemoteUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSeAuthorized_sequence[] = {
  { &hf_xnap_fiveGproSeDirectDiscovery, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeDirectDiscovery },
  { &hf_xnap_fiveGproSeDirectCommunication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeDirectCommunication },
  { &hf_xnap_fiveGnrProSeLayer2UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer2UEtoNetworkRelay },
  { &hf_xnap_fiveGnrProSeLayer3UEtoNetworkRelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer3UEtoNetworkRelay },
  { &hf_xnap_fiveGnrProSeLayer2RemoteUE, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSeLayer2RemoteUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSeAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSeAuthorized, FiveGProSeAuthorized_sequence);

  return offset;
}


static const per_sequence_t FiveGProSePC5FlowBitRates_sequence[] = {
  { &hf_xnap_fiveGproSeguaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_fiveGproSemaximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5FlowBitRates, FiveGProSePC5FlowBitRates_sequence);

  return offset;
}


static const value_string xnap_Range_vals[] = {
  {   0, "m50" },
  {   1, "m80" },
  {   2, "m180" },
  {   3, "m200" },
  {   4, "m350" },
  {   5, "m400" },
  {   6, "m500" },
  {   7, "m700" },
  {   8, "m1000" },
  { 0, NULL }
};


static int
dissect_xnap_Range(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowItem_sequence[] = {
  { &hf_xnap_fiveGproSepQI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_fiveGproSepc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FiveGProSePC5FlowBitRates },
  { &hf_xnap_fiveGproSerange, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Range },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5QoSFlowItem, FiveGProSePC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSFlowList_sequence_of[1] = {
  { &hf_xnap_FiveGProSePC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FiveGProSePC5QoSFlowItem },
};

static int
dissect_xnap_FiveGProSePC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FiveGProSePC5QoSFlowList, FiveGProSePC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, FALSE);

  return offset;
}


static const per_sequence_t FiveGProSePC5QoSParameters_sequence[] = {
  { &hf_xnap_fiveGProSepc5QoSFlowList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveGProSePC5QoSFlowList },
  { &hf_xnap_fiveGproSepc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FiveGProSePC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FiveGProSePC5QoSParameters, FiveGProSePC5QoSParameters_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qoSFlowLevelQoSParameters, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qoSFlowMappingIndication, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Flows_Mapped_To_DRB_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Flows_Mapped_To_DRB_Item, Flows_Mapped_To_DRB_Item_sequence);

  return offset;
}


static const per_sequence_t Flows_Mapped_To_DRB_List_sequence_of[1] = {
  { &hf_xnap_Flows_Mapped_To_DRB_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Flows_Mapped_To_DRB_Item },
};

static int
dissect_xnap_Flows_Mapped_To_DRB_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Flows_Mapped_To_DRB_List, Flows_Mapped_To_DRB_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxnoofRBsetsPerCell1_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofRBsetsPerCell1, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofHSNASlots(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofHSNASlots, NULL, FALSE);

  return offset;
}


static const value_string xnap_HSNADownlink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNADownlink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string xnap_HSNAUplink_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNAUplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string xnap_HSNAFlexible_vals[] = {
  {   0, "hard" },
  {   1, "soft" },
  {   2, "notavailable" },
  { 0, NULL }
};


static int
dissect_xnap_HSNAFlexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FreqDomainSlotHSNAconfiguration_List_Item_sequence[] = {
  { &hf_xnap_slotIndex      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofHSNASlots },
  { &hf_xnap_hSNADownlink   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNADownlink },
  { &hf_xnap_hSNAUplink     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAUplink },
  { &hf_xnap_hSNAFlexible   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAFlexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FreqDomainSlotHSNAconfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FreqDomainSlotHSNAconfiguration_List_Item, FreqDomainSlotHSNAconfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t FreqDomainSlotHSNAconfiguration_List_sequence_of[1] = {
  { &hf_xnap_FreqDomainSlotHSNAconfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainSlotHSNAconfiguration_List_Item },
};

static int
dissect_xnap_FreqDomainSlotHSNAconfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FreqDomainSlotHSNAconfiguration_List, FreqDomainSlotHSNAconfiguration_List_sequence_of,
                                                  1, maxnoofHSNASlots, FALSE);

  return offset;
}


static const per_sequence_t FreqDomainHSNAconfiguration_List_Item_sequence[] = {
  { &hf_xnap_rBsetIndex     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_maxnoofRBsetsPerCell1_ },
  { &hf_xnap_freqDomainSlotHSNAconfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainSlotHSNAconfiguration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_FreqDomainHSNAconfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_FreqDomainHSNAconfiguration_List_Item, FreqDomainHSNAconfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t FreqDomainHSNAconfiguration_List_sequence_of[1] = {
  { &hf_xnap_FreqDomainHSNAconfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_FreqDomainHSNAconfiguration_List_Item },
};

static int
dissect_xnap_FreqDomainHSNAconfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_FreqDomainHSNAconfiguration_List, FreqDomainHSNAconfiguration_List_sequence_of,
                                                  1, maxnoofHSNASlots, FALSE);

  return offset;
}


static const value_string xnap_FrequencyShift7p5khz_vals[] = {
  {   0, "false" },
  {   1, "true" },
  { 0, NULL }
};


static int
dissect_xnap_FrequencyShift7p5khz(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SSB_subcarrierSpacing_vals[] = {
  {   0, "kHz15" },
  {   1, "kHz30" },
  {   2, "kHz120" },
  {   3, "kHz240" },
  {   4, "spare3" },
  {   5, "spare2" },
  {   6, "spare1" },
  { 0, NULL }
};


static int
dissect_xnap_SSB_subcarrierSpacing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_HSNATransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms5" },
  {   7, "ms10" },
  {   8, "ms20" },
  {   9, "ms40" },
  {  10, "ms80" },
  {  11, "ms160" },
  { 0, NULL }
};


static int
dissect_xnap_HSNATransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t HSNASlotConfigItem_sequence[] = {
  { &hf_xnap_hSNADownlink   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNADownlink },
  { &hf_xnap_hSNAUplink     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAUplink },
  { &hf_xnap_hSNAFlexible   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNAFlexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_HSNASlotConfigItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_HSNASlotConfigItem, HSNASlotConfigItem_sequence);

  return offset;
}


static const per_sequence_t HSNASlotConfigList_sequence_of[1] = {
  { &hf_xnap_HSNASlotConfigList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_HSNASlotConfigItem },
};

static int
dissect_xnap_HSNASlotConfigList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_HSNASlotConfigList, HSNASlotConfigList_sequence_of,
                                                  1, maxnoofHSNASlots, FALSE);

  return offset;
}


static const value_string xnap_T_rBsetSize_vals[] = {
  {   0, "rb2" },
  {   1, "rb4" },
  {   2, "rb8" },
  {   3, "rb16" },
  {   4, "rb32" },
  {   5, "rb64" },
  { 0, NULL }
};


static int
dissect_xnap_T_rBsetSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_maxnoofRBsetsPerCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofRBsetsPerCell, NULL, FALSE);

  return offset;
}


static const per_sequence_t RBsetConfiguration_sequence[] = {
  { &hf_xnap_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_rBsetSize      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rBsetSize },
  { &hf_xnap_numberofRBSets , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_maxnoofRBsetsPerCell },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RBsetConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RBsetConfiguration, RBsetConfiguration_sequence);

  return offset;
}


static const value_string xnap_T_nAdownlin_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAdownlin(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_nAuplink_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAuplink(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_nAflexible_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_nAflexible(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NACellResourceConfiguration_Item_sequence[] = {
  { &hf_xnap_nAdownlin      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAdownlin },
  { &hf_xnap_nAuplink       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAuplink },
  { &hf_xnap_nAflexible     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_nAflexible },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NACellResourceConfiguration_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NACellResourceConfiguration_Item, NACellResourceConfiguration_Item_sequence);

  return offset;
}


static const per_sequence_t NACellResourceConfigurationList_sequence_of[1] = {
  { &hf_xnap_NACellResourceConfigurationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NACellResourceConfiguration_Item },
};

static int
dissect_xnap_NACellResourceConfigurationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NACellResourceConfigurationList, NACellResourceConfigurationList_sequence_of,
                                                  1, maxnoofHSNASlots, FALSE);

  return offset;
}


static const per_sequence_t GNB_DU_Cell_Resource_Configuration_sequence[] = {
  { &hf_xnap_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_dUFTransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DUFTransmissionPeriodicity },
  { &hf_xnap_dUF_Slot_Config_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DUF_Slot_Config_List },
  { &hf_xnap_hSNATransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_HSNATransmissionPeriodicity },
  { &hf_xnap_hNSASlotConfigList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_HSNASlotConfigList },
  { &hf_xnap_rBsetConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RBsetConfiguration },
  { &hf_xnap_freqDomainHSNAconfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_FreqDomainHSNAconfiguration_List },
  { &hf_xnap_nACellResourceConfigurationList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NACellResourceConfigurationList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GNB_DU_Cell_Resource_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GNB_DU_Cell_Resource_Configuration, GNB_DU_Cell_Resource_Configuration_sequence);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GUAMI_sequence[] = {
  { &hf_xnap_plmn_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_amf_region_id  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_8 },
  { &hf_xnap_amf_set_id     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_10 },
  { &hf_xnap_amf_pointer    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_GUAMI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  struct xnap_private_data *xnap_data = xnap_get_private_data(actx->pinfo);
  xnap_data->number_type = E212_GUAMI;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_GUAMI, GUAMI_sequence);



  return offset;
}


static const value_string xnap_HandoverReportType_vals[] = {
  {   0, "hoTooEarly" },
  {   1, "hoToWrongCell" },
  {   2, "intersystempingpong" },
  { 0, NULL }
};


static int
dissect_xnap_HandoverReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_HashedUEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     13, 13, TRUE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_2199_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2199U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_INTEGER_0_maxnoofPhysicalResourceBlocks_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxnoofPhysicalResourceBlocks, NULL, TRUE);

  return offset;
}


static const per_sequence_t NRCarrierItem_sequence[] = {
  { &hf_xnap_carrierSCS     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_offsetToCarrier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_2199_ },
  { &hf_xnap_carrierBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_maxnoofPhysicalResourceBlocks_ },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRCarrierItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRCarrierItem, NRCarrierItem_sequence);

  return offset;
}


static const per_sequence_t NRCarrierList_sequence_of[1] = {
  { &hf_xnap_NRCarrierList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NRCarrierItem },
};

static int
dissect_xnap_NRCarrierList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NRCarrierList, NRCarrierList_sequence_of,
                                                  1, maxnoofNRSCSs, FALSE);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence[] = {
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_TDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_frequencyInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_transmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_carrierList    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info, IAB_DU_Cell_Resource_Configuration_TDD_Info_sequence);

  return offset;
}


static const per_sequence_t IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence[] = {
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_UL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_gNB_DU_Cell_Resource_Configuration_FDD_DL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GNB_DU_Cell_Resource_Configuration },
  { &hf_xnap_uLFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dLFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_uLTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_dlTransmissionBandwidth, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_uLCarrierList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_dlCarrierList  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRCarrierList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info, IAB_DU_Cell_Resource_Configuration_FDD_Info_sequence);

  return offset;
}


static const value_string xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info_vals[] = {
  {   0, "tDD" },
  {   1, "fDD" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IAB_DU_Cell_Resource_Configuration_Mode_Info_choice[] = {
  {   0, &hf_xnap_tDD            , ASN1_NO_EXTENSIONS     , dissect_xnap_IAB_DU_Cell_Resource_Configuration_TDD_Info },
  {   1, &hf_xnap_fDD            , ASN1_NO_EXTENSIONS     , dissect_xnap_IAB_DU_Cell_Resource_Configuration_FDD_Info },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info, IAB_DU_Cell_Resource_Configuration_Mode_Info_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_SSB_freqInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNRARFCN, NULL, FALSE);

  return offset;
}


static const value_string xnap_SSB_transmissionPeriodicity_vals[] = {
  {   0, "sf10" },
  {   1, "sf20" },
  {   2, "sf40" },
  {   3, "sf80" },
  {   4, "sf160" },
  {   5, "sf320" },
  {   6, "sf640" },
  { 0, NULL }
};


static int
dissect_xnap_SSB_transmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_SSB_transmissionTimingOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_SSB_transmissionBitmap_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_transmissionBitmap_choice[] = {
  {   0, &hf_xnap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_4 },
  {   1, &hf_xnap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_8 },
  {   2, &hf_xnap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_64 },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SSB_transmissionBitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SSB_transmissionBitmap, SSB_transmissionBitmap_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IAB_STC_Info_Item_sequence[] = {
  { &hf_xnap_sSB_freqInfo   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_freqInfo },
  { &hf_xnap_sSB_subcarrierSpacing, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_subcarrierSpacing },
  { &hf_xnap_sSB_transmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionPeriodicity },
  { &hf_xnap_sSB_transmissionTimingOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionTimingOffset },
  { &hf_xnap_sSB_transmissionBitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSB_transmissionBitmap },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_STC_Info_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_STC_Info_Item, IAB_STC_Info_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_STC_Info_List_sequence_of[1] = {
  { &hf_xnap_IAB_STC_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_STC_Info_Item },
};

static int
dissect_xnap_IAB_STC_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IAB_STC_Info_List, IAB_STC_Info_List_sequence_of,
                                                  1, maxnoofIABSTCInfo, FALSE);

  return offset;
}


static const per_sequence_t IAB_STC_Info_sequence[] = {
  { &hf_xnap_iAB_STC_Info_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_STC_Info_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_STC_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_STC_Info, IAB_STC_Info_sequence);

  return offset;
}



static int
dissect_xnap_RACH_Config_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RACH_Config_Common);
    dissect_nr_rrc_RACH_ConfigCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_RACH_Config_Common_IAB(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RACH_Config_Common_IAB);
    dissect_nr_rrc_rach_ConfigCommonIAB_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_cSI_RS_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_cSI_RS_Configuration);
    dissect_nr_rrc_NZP_CSI_RS_Resource_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_sR_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_sR_Configuration);
    dissect_nr_rrc_SchedulingRequestResourceConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_pDCCH_ConfigSIB1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_pDCCH_ConfigSIB1);
    dissect_nr_rrc_PDCCH_ConfigSIB1_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_sCS_Common(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_sCS_Common);
    dissect_nr_rrc_subCarrierSpacingCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_Item_sequence[] = {
  { &hf_xnap_nRCellIdentity , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_Cell_Identity },
  { &hf_xnap_dU_RX_MT_RX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_RX_MT_RX },
  { &hf_xnap_dU_TX_MT_TX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_TX_MT_TX },
  { &hf_xnap_dU_RX_MT_TX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_RX_MT_TX },
  { &hf_xnap_dU_TX_MT_RX    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DU_TX_MT_RX },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_MT_Cell_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_MT_Cell_List_Item, IAB_MT_Cell_List_Item_sequence);

  return offset;
}


static const per_sequence_t IAB_MT_Cell_List_sequence_of[1] = {
  { &hf_xnap_IAB_MT_Cell_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_MT_Cell_List_Item },
};

static int
dissect_xnap_IAB_MT_Cell_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IAB_MT_Cell_List, IAB_MT_Cell_List_sequence_of,
                                                  1, maxnoofServingCells, FALSE);

  return offset;
}


static const per_sequence_t MultiplexingInfo_sequence[] = {
  { &hf_xnap_iAB_MT_Cell_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IAB_MT_Cell_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MultiplexingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MultiplexingInfo, MultiplexingInfo_sequence);

  return offset;
}


static const per_sequence_t IABCellInformation_sequence[] = {
  { &hf_xnap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_iAB_DU_Cell_Resource_Configuration_Mode_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IAB_DU_Cell_Resource_Configuration_Mode_Info },
  { &hf_xnap_iAB_STC_Info   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IAB_STC_Info },
  { &hf_xnap_rACH_Config_Common, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RACH_Config_Common },
  { &hf_xnap_rACH_Config_Common_IAB, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RACH_Config_Common_IAB },
  { &hf_xnap_cSI_RS_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_cSI_RS_Configuration },
  { &hf_xnap_sR_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_sR_Configuration },
  { &hf_xnap_pDCCH_ConfigSIB1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_pDCCH_ConfigSIB1 },
  { &hf_xnap_sCS_Common     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_sCS_Common },
  { &hf_xnap_multiplexingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MultiplexingInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABCellInformation, IABCellInformation_sequence);

  return offset;
}


static const value_string xnap_IABNodeIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_IABNodeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const per_sequence_t IABTNLAddressesRequested_sequence[] = {
  { &hf_xnap_tNLAddressesOrPrefixesRequestedAllTraffic, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedF1_C, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedF1_U, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_tNLAddressesOrPrefixesRequestedNoNF1, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_INTEGER_1_256 },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddressesRequested(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddressesRequested, IABTNLAddressesRequested_sequence);

  return offset;
}


static const value_string xnap_IABIPv6RequestType_vals[] = {
  {   0, "iPv6Address" },
  {   1, "iPv6Prefix" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t IABIPv6RequestType_choice[] = {
  {   0, &hf_xnap_iPv6Address    , ASN1_NO_EXTENSIONS     , dissect_xnap_IABTNLAddressesRequested },
  {   1, &hf_xnap_iPv6Prefix     , ASN1_NO_EXTENSIONS     , dissect_xnap_IABTNLAddressesRequested },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_IABIPv6RequestType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_IABIPv6RequestType, IABIPv6RequestType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t IABTNLAddressToRemove_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddressToRemove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddressToRemove_Item, IABTNLAddressToRemove_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressToRemove_List_sequence_of[1] = {
  { &hf_xnap_IABTNLAddressToRemove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressToRemove_Item },
};

static int
dissect_xnap_IABTNLAddressToRemove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABTNLAddressToRemove_List, IABTNLAddressToRemove_List_sequence_of,
                                                  1, maxnoofTLAsIAB, FALSE);

  return offset;
}


static const per_sequence_t IAB_TNL_Address_Request_sequence[] = {
  { &hf_xnap_iABIPv4AddressesRequested, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressesRequested },
  { &hf_xnap_iABIPv6RequestType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABIPv6RequestType },
  { &hf_xnap_iABTNLAddressToRemove_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddressToRemove_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_TNL_Address_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_TNL_Address_Request, IAB_TNL_Address_Request_sequence);

  return offset;
}


static const value_string xnap_IABTNLAddressUsage_vals[] = {
  {   0, "f1-c" },
  {   1, "f1-u" },
  {   2, "non-f1" },
  {   3, "all" },
  { 0, NULL }
};


static int
dissect_xnap_IABTNLAddressUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 1, NULL);

  return offset;
}


static const per_sequence_t IABAllocatedTNLAddress_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iABTNLAddressUsage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_IABTNLAddressUsage },
  { &hf_xnap_associatedDonorDUAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABAllocatedTNLAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABAllocatedTNLAddress_Item, IABAllocatedTNLAddress_Item_sequence);

  return offset;
}


static const per_sequence_t IABAllocatedTNLAddress_List_sequence_of[1] = {
  { &hf_xnap_IABAllocatedTNLAddress_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABAllocatedTNLAddress_Item },
};

static int
dissect_xnap_IABAllocatedTNLAddress_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABAllocatedTNLAddress_List, IABAllocatedTNLAddress_List_sequence_of,
                                                  1, maxnoofTLAsIAB, FALSE);

  return offset;
}


static const per_sequence_t IAB_TNL_Address_Response_sequence[] = {
  { &hf_xnap_iABAllocatedTNLAddress_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABAllocatedTNLAddress_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IAB_TNL_Address_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IAB_TNL_Address_Response, IAB_TNL_Address_Response_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddress_Item_sequence[] = {
  { &hf_xnap_iABTNLAddress  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IABTNLAddress_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IABTNLAddress_Item, IABTNLAddress_Item_sequence);

  return offset;
}


static const per_sequence_t IABTNLAddressException_sequence_of[1] = {
  { &hf_xnap_IABTNLAddressException_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_IABTNLAddress_Item },
};

static int
dissect_xnap_IABTNLAddressException(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_IABTNLAddressException, IABTNLAddressException_sequence_of,
                                                  1, maxnoofTLAsIAB, FALSE);

  return offset;
}



static int
dissect_xnap_MeasurementsToActivate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_xnap_MeasurementsToActivate_M1,
      &hf_xnap_MeasurementsToActivate_M2,
      &hf_xnap_MeasurementsToActivate_M3,
      &hf_xnap_MeasurementsToActivate_M4,
      &hf_xnap_MeasurementsToActivate_M5,
      &hf_xnap_MeasurementsToActivate_LoggingM1FromEventTriggered,
      &hf_xnap_MeasurementsToActivate_M6,
      &hf_xnap_MeasurementsToActivate_M7,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MeasurementsToActivate);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_M1ReportingTrigger_vals[] = {
  {   0, "periodic" },
  {   1, "a2eventtriggered" },
  {   2, "a2eventtriggered-periodic" },
  { 0, NULL }
};


static int
dissect_xnap_M1ReportingTrigger(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_Threshold_SINR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const value_string xnap_MeasurementThresholdA2_vals[] = {
  {   0, "threshold-RSRP" },
  {   1, "threshold-RSRQ" },
  {   2, "threshold-SINR" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MeasurementThresholdA2_choice[] = {
  {   0, &hf_xnap_threshold_RSRP , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_RSRP },
  {   1, &hf_xnap_threshold_RSRQ , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_RSRQ },
  {   2, &hf_xnap_threshold_SINR , ASN1_NO_EXTENSIONS     , dissect_xnap_Threshold_SINR },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MeasurementThresholdA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MeasurementThresholdA2, MeasurementThresholdA2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t M1ThresholdEventA2_sequence[] = {
  { &hf_xnap_measurementThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementThresholdA2 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1ThresholdEventA2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1ThresholdEventA2, M1ThresholdEventA2_sequence);

  return offset;
}


static const value_string xnap_ReportIntervalMDT_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "min1" },
  {   9, "min6" },
  {  10, "min12" },
  {  11, "min30" },
  {  12, "min60" },
  { 0, NULL }
};


static int
dissect_xnap_ReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M1PeriodicReporting_sequence[] = {
  { &hf_xnap_reportInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportIntervalMDT },
  { &hf_xnap_reportAmount   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportAmountMDT },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1PeriodicReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1PeriodicReporting, M1PeriodicReporting_sequence);

  return offset;
}


static const per_sequence_t M1Configuration_sequence[] = {
  { &hf_xnap_m1reportingTrigger, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M1ReportingTrigger },
  { &hf_xnap_m1thresholdeventA2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1ThresholdEventA2 },
  { &hf_xnap_m1periodicReporting, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1PeriodicReporting },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M1Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M1Configuration, M1Configuration_sequence);

  return offset;
}


static const value_string xnap_M4period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_xnap_M4period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_Links_to_log_vals[] = {
  {   0, "uplink" },
  {   1, "downlink" },
  {   2, "both-uplink-and-downlink" },
  { 0, NULL }
};


static int
dissect_xnap_Links_to_log(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M4Configuration_sequence[] = {
  { &hf_xnap_m4period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M4period },
  { &hf_xnap_m4_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M4Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M4Configuration, M4Configuration_sequence);

  return offset;
}


static const value_string xnap_M5period_vals[] = {
  {   0, "ms1024" },
  {   1, "ms2048" },
  {   2, "ms5120" },
  {   3, "ms10240" },
  {   4, "min1" },
  { 0, NULL }
};


static int
dissect_xnap_M5period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M5Configuration_sequence[] = {
  { &hf_xnap_m5period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M5period },
  { &hf_xnap_m5_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M5Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M5Configuration, M5Configuration_sequence);

  return offset;
}



static int
dissect_xnap_MDT_Location_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, &parameter_tvb, NULL);

  if (parameter_tvb) {
    static int * const fields[] = {
      &hf_xnap_MDT_Location_Info_GNSS,
      &hf_xnap_MDT_Location_Info_reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MDT_Location_Info);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 1, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_M6report_Interval_vals[] = {
  {   0, "ms120" },
  {   1, "ms240" },
  {   2, "ms480" },
  {   3, "ms640" },
  {   4, "ms1024" },
  {   5, "ms2048" },
  {   6, "ms5120" },
  {   7, "ms10240" },
  {   8, "ms20480" },
  {   9, "ms40960" },
  {  10, "min1" },
  {  11, "min6" },
  {  12, "min12" },
  {  13, "min30" },
  { 0, NULL }
};


static int
dissect_xnap_M6report_Interval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     14, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t M6Configuration_sequence[] = {
  { &hf_xnap_m6report_Interval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M6report_Interval },
  { &hf_xnap_m6_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M6Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M6Configuration, M6Configuration_sequence);

  return offset;
}



static int
dissect_xnap_M7period(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 60U, NULL, TRUE);

  return offset;
}


static const per_sequence_t M7Configuration_sequence[] = {
  { &hf_xnap_m7period       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_M7period },
  { &hf_xnap_m7_links_to_log, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Links_to_log },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_M7Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_M7Configuration, M7Configuration_sequence);

  return offset;
}


static const value_string xnap_WLANMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_WLANMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_WLANName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, FALSE, &parameter_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, parameter_tvb, 0, -1, ENC_UTF_8|ENC_NA);


  return offset;
}


static const per_sequence_t WLANMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_WLANMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_WLANName },
};

static int
dissect_xnap_WLANMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_WLANMeasConfigNameList, WLANMeasConfigNameList_sequence_of,
                                                  1, maxnoofWLANName, FALSE);

  return offset;
}


static const value_string xnap_T_wlan_rssi_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_wlan_rssi(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_wlan_rtt_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_wlan_rtt(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t WLANMeasurementConfiguration_sequence[] = {
  { &hf_xnap_wlanMeasConfig , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_WLANMeasConfig },
  { &hf_xnap_wlanMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasConfigNameList },
  { &hf_xnap_wlan_rssi      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_wlan_rssi },
  { &hf_xnap_wlan_rtt       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_wlan_rtt },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_WLANMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_WLANMeasurementConfiguration, WLANMeasurementConfiguration_sequence);

  return offset;
}


static const value_string xnap_SensorMeasConfig_vals[] = {
  {   0, "setup" },
  { 0, NULL }
};


static int
dissect_xnap_SensorMeasConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_uncompensatedBarometricConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_uncompensatedBarometricConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_ueSpeedConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_ueSpeedConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_ueOrientationConfig_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_ueOrientationConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SensorName_sequence[] = {
  { &hf_xnap_uncompensatedBarometricConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_uncompensatedBarometricConfig },
  { &hf_xnap_ueSpeedConfig  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_ueSpeedConfig },
  { &hf_xnap_ueOrientationConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_ueOrientationConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SensorName(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SensorName, SensorName_sequence);

  return offset;
}


static const per_sequence_t SensorMeasConfigNameList_sequence_of[1] = {
  { &hf_xnap_SensorMeasConfigNameList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SensorName },
};

static int
dissect_xnap_SensorMeasConfigNameList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SensorMeasConfigNameList, SensorMeasConfigNameList_sequence_of,
                                                  1, maxnoofSensorName, FALSE);

  return offset;
}


static const per_sequence_t SensorMeasurementConfiguration_sequence[] = {
  { &hf_xnap_sensorMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SensorMeasConfig },
  { &hf_xnap_sensorMeasConfigNameList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasConfigNameList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SensorMeasurementConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SensorMeasurementConfiguration, SensorMeasurementConfiguration_sequence);

  return offset;
}


static const per_sequence_t ImmediateMDT_NR_sequence[] = {
  { &hf_xnap_measurementsToActivate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MeasurementsToActivate },
  { &hf_xnap_m1Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M1Configuration },
  { &hf_xnap_m4Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M4Configuration },
  { &hf_xnap_m5Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M5Configuration },
  { &hf_xnap_mDT_Location_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Location_Info },
  { &hf_xnap_m6Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M6Configuration },
  { &hf_xnap_m7Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_M7Configuration },
  { &hf_xnap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasurementConfiguration },
  { &hf_xnap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasurementConfiguration },
  { &hf_xnap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasurementConfiguration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ImmediateMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ImmediateMDT_NR, ImmediateMDT_NR_sequence);

  return offset;
}


static const value_string xnap_NG_RAN_CellPCI_vals[] = {
  {   0, "nr" },
  {   1, "e-utra" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_CellPCI_choice[] = {
  {   0, &hf_xnap_nr_01          , ASN1_NO_EXTENSIONS     , dissect_xnap_NRPCI },
  {   1, &hf_xnap_e_utra_01      , ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRAPCI },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_CellPCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_CellPCI, NG_RAN_CellPCI_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MAC_I(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t RRCReestab_Initiated_Reporting_wo_UERLFReport_sequence[] = {
  { &hf_xnap_failureCellPCI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_CellPCI },
  { &hf_xnap_reestabCellCGI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANCell_ID },
  { &hf_xnap_c_RNTI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_C_RNTI },
  { &hf_xnap_shortMAC_I     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MAC_I },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport, RRCReestab_Initiated_Reporting_wo_UERLFReport_sequence);

  return offset;
}



static int
dissect_xnap_UERLFReportContainerNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERLFReportContainerNR);
    dissect_nr_rrc_nr_RLF_Report_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_UERLFReportContainerLTE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERLFReportContainerLTE);
    dissect_lte_rrc_RLF_Report_r9_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_UERLFReportContainer_vals[] = {
  {   0, "nR-UERLFReportContainer" },
  {   1, "lTE-UERLFReportContainer" },
  {   2, "choice-Extension" },
  { 0, NULL }
};

static const per_choice_t UERLFReportContainer_choice[] = {
  {   0, &hf_xnap_nR_UERLFReportContainer, ASN1_NO_EXTENSIONS     , dissect_xnap_UERLFReportContainerNR },
  {   1, &hf_xnap_lTE_UERLFReportContainer, ASN1_NO_EXTENSIONS     , dissect_xnap_UERLFReportContainerLTE },
  {   2, &hf_xnap_choice_Extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UERLFReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UERLFReportContainer, UERLFReportContainer_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestab_Initiated_Reporting_with_UERLFReport_sequence[] = {
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport, RRCReestab_Initiated_Reporting_with_UERLFReport_sequence);

  return offset;
}


static const value_string xnap_RRCReestab_Initiated_Reporting_vals[] = {
  {   0, "rRCReestab-reporting-wo-UERLFReport" },
  {   1, "rRCReestab-reporting-with-UERLFReport" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RRCReestab_Initiated_Reporting_choice[] = {
  {   0, &hf_xnap_rRCReestab_reporting_wo_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_Initiated_Reporting_wo_UERLFReport },
  {   1, &hf_xnap_rRCReestab_reporting_with_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_Initiated_Reporting_with_UERLFReport },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RRCReestab_Initiated_Reporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RRCReestab_Initiated_Reporting, RRCReestab_Initiated_Reporting_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCReestab_initiated_sequence[] = {
  { &hf_xnap_rRRCReestab_initiated_reporting, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RRCReestab_Initiated_Reporting },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCReestab_initiated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCReestab_initiated, RRCReestab_initiated_sequence);

  return offset;
}


static const per_sequence_t RRCSetup_Initiated_Reporting_with_UERLFReport_sequence[] = {
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport, RRCSetup_Initiated_Reporting_with_UERLFReport_sequence);

  return offset;
}


static const value_string xnap_RRCSetup_Initiated_Reporting_vals[] = {
  {   0, "rRCSetup-reporting-with-UERLFReport" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RRCSetup_Initiated_Reporting_choice[] = {
  {   0, &hf_xnap_rRCSetup_reporting_with_UERLFReport, ASN1_NO_EXTENSIONS     , dissect_xnap_RRCSetup_Initiated_Reporting_with_UERLFReport },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RRCSetup_Initiated_Reporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RRCSetup_Initiated_Reporting, RRCSetup_Initiated_Reporting_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RRCSetup_initiated_sequence[] = {
  { &hf_xnap_rRRCSetup_Initiated_Reporting, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RRCSetup_Initiated_Reporting },
  { &hf_xnap_uERLFReportContainer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UERLFReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RRCSetup_initiated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RRCSetup_initiated, RRCSetup_initiated_sequence);

  return offset;
}


static const value_string xnap_InitiatingCondition_FailureIndication_vals[] = {
  {   0, "rRCReestab" },
  {   1, "rRCSetup" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t InitiatingCondition_FailureIndication_choice[] = {
  {   0, &hf_xnap_rRCReestab     , ASN1_NO_EXTENSIONS     , dissect_xnap_RRCReestab_initiated },
  {   1, &hf_xnap_rRCSetup       , ASN1_NO_EXTENSIONS     , dissect_xnap_RRCSetup_initiated },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_InitiatingCondition_FailureIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_InitiatingCondition_FailureIndication, InitiatingCondition_FailureIndication_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NRCyclicPrefix_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_xnap_NRCyclicPrefix(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_NRDL_ULTransmissionPeriodicity_vals[] = {
  {   0, "ms0p5" },
  {   1, "ms0p625" },
  {   2, "ms1" },
  {   3, "ms1p25" },
  {   4, "ms2" },
  {   5, "ms2p5" },
  {   6, "ms3" },
  {   7, "ms4" },
  {   8, "ms5" },
  {   9, "ms10" },
  {  10, "ms20" },
  {  11, "ms40" },
  {  12, "ms60" },
  {  13, "ms80" },
  {  14, "ms100" },
  {  15, "ms120" },
  {  16, "ms140" },
  {  17, "ms160" },
  { 0, NULL }
};


static int
dissect_xnap_NRDL_ULTransmissionPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_5119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5119U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_AllDL_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_AllDL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_AllDL, SymbolAllocation_in_Slot_AllDL_sequence);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_AllUL_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_AllUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_AllUL, SymbolAllocation_in_Slot_AllUL_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_0_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 13U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SymbolAllocation_in_Slot_BothDLandUL_sequence[] = {
  { &hf_xnap_numberofDLSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_13 },
  { &hf_xnap_numberofULSymbols, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_13 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot_BothDLandUL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SymbolAllocation_in_Slot_BothDLandUL, SymbolAllocation_in_Slot_BothDLandUL_sequence);

  return offset;
}


static const value_string xnap_SymbolAllocation_in_Slot_vals[] = {
  {   0, "allDL" },
  {   1, "allUL" },
  {   2, "bothDLandUL" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SymbolAllocation_in_Slot_choice[] = {
  {   0, &hf_xnap_allDL          , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_AllDL },
  {   1, &hf_xnap_allUL          , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_AllUL },
  {   2, &hf_xnap_bothDLandUL    , ASN1_NO_EXTENSIONS     , dissect_xnap_SymbolAllocation_in_Slot_BothDLandUL },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SymbolAllocation_in_Slot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SymbolAllocation_in_Slot, SymbolAllocation_in_Slot_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SlotConfiguration_List_Item_sequence[] = {
  { &hf_xnap_slotIndex_01   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_5119 },
  { &hf_xnap_symbolAllocation_in_Slot, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SymbolAllocation_in_Slot },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SlotConfiguration_List_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SlotConfiguration_List_Item, SlotConfiguration_List_Item_sequence);

  return offset;
}


static const per_sequence_t SlotConfiguration_List_sequence_of[1] = {
  { &hf_xnap_SlotConfiguration_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SlotConfiguration_List_Item },
};

static int
dissect_xnap_SlotConfiguration_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SlotConfiguration_List, SlotConfiguration_List_sequence_of,
                                                  1, maxnoofslots, FALSE);

  return offset;
}


static const per_sequence_t IntendedTDD_DL_ULConfiguration_NR_sequence[] = {
  { &hf_xnap_nrscs          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRSCS },
  { &hf_xnap_nrCyclicPrefix , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRCyclicPrefix },
  { &hf_xnap_nrDL_ULTransmissionPeriodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRDL_ULTransmissionPeriodicity },
  { &hf_xnap_slotConfiguration_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SlotConfiguration_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_IntendedTDD_DL_ULConfiguration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_IntendedTDD_DL_ULConfiguration_NR, IntendedTDD_DL_ULConfiguration_NR_sequence);

  return offset;
}



static int
dissect_xnap_InterfaceInstanceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_40(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     40, 40, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_I_RNTI_vals[] = {
  {   0, "i-RNTI-full" },
  {   1, "i-RNTI-short" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t I_RNTI_choice[] = {
  {   0, &hf_xnap_i_RNTI_full    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_40 },
  {   1, &hf_xnap_i_RNTI_short   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_24 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_I_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_I_RNTI, I_RNTI_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     15, 15, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     12, 12, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_Full_I_RNTI_Profile_List_vals[] = {
  {   0, "full-I-RNTI-Profile-0" },
  {   1, "full-I-RNTI-Profile-1" },
  {   2, "full-I-RNTI-Profile-2" },
  {   3, "full-I-RNTI-Profile-3" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Full_I_RNTI_Profile_List_choice[] = {
  {   0, &hf_xnap_full_I_RNTI_Profile_0, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_21 },
  {   1, &hf_xnap_full_I_RNTI_Profile_1, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_18 },
  {   2, &hf_xnap_full_I_RNTI_Profile_2, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_15 },
  {   3, &hf_xnap_full_I_RNTI_Profile_3, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_12 },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Full_I_RNTI_Profile_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Full_I_RNTI_Profile_List, Full_I_RNTI_Profile_List_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_Short_I_RNTI_Profile_List_vals[] = {
  {   0, "short-I-RNTI-Profile-0" },
  {   1, "short-I-RNTI-Profile-1" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Short_I_RNTI_Profile_List_choice[] = {
  {   0, &hf_xnap_short_I_RNTI_Profile_0, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_8 },
  {   1, &hf_xnap_short_I_RNTI_Profile_1, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_6 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Short_I_RNTI_Profile_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Short_I_RNTI_Profile_List, Short_I_RNTI_Profile_List_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_Local_NG_RAN_Node_Identifier_vals[] = {
  {   0, "full-I-RNTI-Profile-List" },
  {   1, "short-I-RNTI-Profile-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t Local_NG_RAN_Node_Identifier_choice[] = {
  {   0, &hf_xnap_full_I_RNTI_Profile_List, ASN1_NO_EXTENSIONS     , dissect_xnap_Full_I_RNTI_Profile_List },
  {   1, &hf_xnap_short_I_RNTI_Profile_List, ASN1_NO_EXTENSIONS     , dissect_xnap_Short_I_RNTI_Profile_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_Local_NG_RAN_Node_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_Local_NG_RAN_Node_Identifier, Local_NG_RAN_Node_Identifier_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_LastVisitedNGRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedNGRANCellInformation);
    dissect_ngap_LastVisitedNGRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedEUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedEUTRANCellInformation);
    dissect_s1ap_LastVisitedEUTRANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedUTRANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedUTRANCellInformation);
    dissect_ranap_LastVisitedUTRANCell_Item_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_LastVisitedGERANCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedGERANCellInformation);
    dissect_s1ap_LastVisitedGERANCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const value_string xnap_LastVisitedCell_Item_vals[] = {
  {   0, "nG-RAN-Cell" },
  {   1, "e-UTRAN-Cell" },
  {   2, "uTRAN-Cell" },
  {   3, "gERAN-Cell" },
  {   4, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t LastVisitedCell_Item_choice[] = {
  {   0, &hf_xnap_nG_RAN_Cell    , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedNGRANCellInformation },
  {   1, &hf_xnap_e_UTRAN_Cell   , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedEUTRANCellInformation },
  {   2, &hf_xnap_uTRAN_Cell     , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedUTRANCellInformation },
  {   3, &hf_xnap_gERAN_Cell     , ASN1_NO_EXTENSIONS     , dissect_xnap_LastVisitedGERANCellInformation },
  {   4, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_LastVisitedCell_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_LastVisitedCell_Item, LastVisitedCell_Item_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_LastVisitedPSCellInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_LastVisitedPSCellInformation);
    dissect_ngap_LastVisitedPSCellInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t LastVisitedPSCellList_Item_sequence[] = {
  { &hf_xnap_lastVisitedPSCellInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LastVisitedPSCellInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LastVisitedPSCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LastVisitedPSCellList_Item, LastVisitedPSCellList_Item_sequence);

  return offset;
}


static const per_sequence_t LastVisitedPSCellList_sequence_of[1] = {
  { &hf_xnap_LastVisitedPSCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_LastVisitedPSCellList_Item },
};

static int
dissect_xnap_LastVisitedPSCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_LastVisitedPSCellList, LastVisitedPSCellList_sequence_of,
                                                  1, maxnoofPSCellsPerSN, FALSE);

  return offset;
}


static const per_sequence_t SCGUEHistoryInformation_sequence[] = {
  { &hf_xnap_lastVisitedPSCellList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LastVisitedPSCellList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SCGUEHistoryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SCGUEHistoryInformation, SCGUEHistoryInformation_sequence);

  return offset;
}



static int
dissect_xnap_LCID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, TRUE);

  return offset;
}


static const value_string xnap_LocationInformationSNReporting_vals[] = {
  {   0, "pSCell" },
  { 0, NULL }
};


static int
dissect_xnap_LocationInformationSNReporting(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_ReportArea_vals[] = {
  {   0, "cell" },
  { 0, NULL }
};


static int
dissect_xnap_ReportArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t LocationReportingInformation_sequence[] = {
  { &hf_xnap_eventType      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EventType },
  { &hf_xnap_reportArea     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportArea },
  { &hf_xnap_areaOfInterest , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaOfInterestInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LocationReportingInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LocationReportingInformation, LocationReportingInformation_sequence);

  return offset;
}


static const value_string xnap_LoggingInterval_vals[] = {
  {   0, "ms320" },
  {   1, "ms640" },
  {   2, "ms1280" },
  {   3, "ms2560" },
  {   4, "ms5120" },
  {   5, "ms10240" },
  {   6, "ms20480" },
  {   7, "ms30720" },
  {   8, "ms40960" },
  {   9, "ms61440" },
  {  10, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_LoggingInterval(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_LoggingDuration_vals[] = {
  {   0, "m10" },
  {   1, "m20" },
  {   2, "m40" },
  {   3, "m60" },
  {   4, "m90" },
  {   5, "m120" },
  { 0, NULL }
};


static int
dissect_xnap_LoggingDuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Periodical_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Periodical(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Periodical, Periodical_sequence);

  return offset;
}


static const value_string xnap_ReportType_vals[] = {
  {   0, "periodical" },
  {   1, "eventTriggered" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ReportType_choice[] = {
  {   0, &hf_xnap_periodical     , ASN1_EXTENSION_ROOT    , dissect_xnap_Periodical },
  {   1, &hf_xnap_eventTriggered , ASN1_EXTENSION_ROOT    , dissect_xnap_EventTriggered },
  {   2, &hf_xnap_choice_extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ReportType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ReportType, ReportType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t LoggedMDT_NR_sequence[] = {
  { &hf_xnap_loggingInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggingInterval },
  { &hf_xnap_loggingDuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_LoggingDuration },
  { &hf_xnap_reportType     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ReportType },
  { &hf_xnap_bluetoothMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BluetoothMeasurementConfiguration },
  { &hf_xnap_wLANMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_WLANMeasurementConfiguration },
  { &hf_xnap_sensorMeasurementConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SensorMeasurementConfiguration },
  { &hf_xnap_areaScopeOfNeighCellsList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfNeighCellsList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LoggedMDT_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LoggedMDT_NR, LoggedMDT_NR_sequence);

  return offset;
}


static const value_string xnap_LowerLayerPresenceStatusChange_vals[] = {
  {   0, "release-lower-layers" },
  {   1, "re-establish-lower-layers" },
  {   2, "suspend-lower-layers" },
  {   3, "resume-lower-layers" },
  { 0, NULL }
};


static int
dissect_xnap_LowerLayerPresenceStatusChange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string xnap_VehicleUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_VehicleUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_PedestrianUE_vals[] = {
  {   0, "authorized" },
  {   1, "not-authorized" },
  { 0, NULL }
};


static int
dissect_xnap_PedestrianUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t LTEV2XServicesAuthorized_sequence[] = {
  { &hf_xnap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_VehicleUE },
  { &hf_xnap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PedestrianUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LTEV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LTEV2XServicesAuthorized, LTEV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t LTEUESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_LTEUESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_LTEUESidelinkAggregateMaximumBitRate, LTEUESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}



static int
dissect_xnap_NG_RANTraceID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb;
  proto_tree *subtree = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       8, 8, FALSE, &parameter_tvb);

  if (!parameter_tvb)
    return offset;
  subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NG_RANTraceID);
  dissect_e212_mcc_mnc(parameter_tvb, actx->pinfo, subtree, 0, E212_NONE, FALSE);
  proto_tree_add_item(subtree, hf_xnap_NG_RANTraceID_TraceID, parameter_tvb, 3, 3, ENC_BIG_ENDIAN);
  proto_tree_add_item(subtree, hf_xnap_NG_RANTraceID_TraceRecordingSessionReference, parameter_tvb, 6, 2, ENC_BIG_ENDIAN);


  return offset;
}


static const per_sequence_t S_BasedMDT_sequence[] = {
  { &hf_xnap_ng_ran_TraceID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANTraceID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_S_BasedMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_S_BasedMDT, S_BasedMDT_sequence);

  return offset;
}


static const value_string xnap_MDTAlignmentInfo_vals[] = {
  {   0, "s-BasedMDT" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MDTAlignmentInfo_choice[] = {
  {   0, &hf_xnap_s_BasedMDT     , ASN1_NO_EXTENSIONS     , dissect_xnap_S_BasedMDT },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MDTAlignmentInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MDTAlignmentInfo, MDTAlignmentInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_MeasCollectionEntityIPAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_TransportLayerAddress(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string xnap_M4ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M4ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_M5ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M5ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_M6ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M6ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_M7ReportAmountMDT_vals[] = {
  {   0, "r1" },
  {   1, "r2" },
  {   2, "r4" },
  {   3, "r8" },
  {   4, "r16" },
  {   5, "r32" },
  {   6, "r64" },
  {   7, "infinity" },
  { 0, NULL }
};


static int
dissect_xnap_M7ReportAmountMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_MaskedIMEISV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_MaxIPrate_vals[] = {
  {   0, "bitrate64kbs" },
  {   1, "max-UErate" },
  { 0, NULL }
};


static int
dissect_xnap_MaxIPrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MaximumIPdatarate_sequence[] = {
  { &hf_xnap_maxIPrate_UL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MaxIPrate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MaximumIPdatarate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MaximumIPdatarate, MaximumIPdatarate_sequence);

  return offset;
}


static const value_string xnap_MBSFNSubframeAllocation_E_UTRA_vals[] = {
  {   0, "oneframe" },
  {   1, "fourframes" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t MBSFNSubframeAllocation_E_UTRA_choice[] = {
  {   0, &hf_xnap_oneframe       , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_6 },
  {   1, &hf_xnap_fourframes     , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_24 },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MBSFNSubframeAllocation_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MBSFNSubframeAllocation_E_UTRA, MBSFNSubframeAllocation_E_UTRA_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_radioframeAllocationPeriod_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_xnap_T_radioframeAllocationPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_7_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const per_sequence_t MBSFNSubframeInfo_E_UTRA_Item_sequence[] = {
  { &hf_xnap_radioframeAllocationPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_radioframeAllocationPeriod },
  { &hf_xnap_radioframeAllocationOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_7_ },
  { &hf_xnap_subframeAllocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBSFNSubframeAllocation_E_UTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBSFNSubframeInfo_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBSFNSubframeInfo_E_UTRA_Item, MBSFNSubframeInfo_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t MBSFNSubframeInfo_E_UTRA_sequence_of[1] = {
  { &hf_xnap_MBSFNSubframeInfo_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBSFNSubframeInfo_E_UTRA_Item },
};

static int
dissect_xnap_MBSFNSubframeInfo_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBSFNSubframeInfo_E_UTRA, MBSFNSubframeInfo_E_UTRA_sequence_of,
                                                  1, maxnoofMBSFNEUTRA, FALSE);

  return offset;
}



static int
dissect_xnap_MBS_FrequencySelectionArea_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       3, 3, FALSE, NULL);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseInfofromTarget_Item_sequence[] = {
  { &hf_xnap_mRB_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MRB_ID },
  { &hf_xnap_dlForwardingUPTNL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_mRB_ProgressInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MRB_ProgressInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_DataForwardingResponseInfofromTarget_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_DataForwardingResponseInfofromTarget_Item, MBS_DataForwardingResponseInfofromTarget_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_DataForwardingResponseInfofromTarget_sequence_of[1] = {
  { &hf_xnap_MBS_DataForwardingResponseInfofromTarget_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_DataForwardingResponseInfofromTarget_Item },
};

static int
dissect_xnap_MBS_DataForwardingResponseInfofromTarget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_DataForwardingResponseInfofromTarget, MBS_DataForwardingResponseInfofromTarget_sequence_of,
                                                  1, maxnoofMRBs, FALSE);

  return offset;
}



static int
dissect_xnap_TMGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, FALSE, NULL);

  return offset;
}


static const per_sequence_t MBS_Session_ID_sequence[] = {
  { &hf_xnap_tMGI           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TMGI },
  { &hf_xnap_nID            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_Session_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_Session_ID, MBS_Session_ID_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionAssociatedInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_associated_QoSFlowInfo_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Associated_QoSFlowInfo_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionAssociatedInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionAssociatedInformation_Item, MBS_SessionAssociatedInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionAssociatedInformation_sequence_of[1] = {
  { &hf_xnap_MBS_SessionAssociatedInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionAssociatedInformation_Item },
};

static int
dissect_xnap_MBS_SessionAssociatedInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionAssociatedInformation, MBS_SessionAssociatedInformation_sequence_of,
                                                  1, maxnoofAssociatedMBSSessions, FALSE);

  return offset;
}


static const per_sequence_t MBS_SessionInformation_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_mBS_Area_Session_ID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_Area_Session_ID },
  { &hf_xnap_active_MBS_SessioInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Active_MBS_SessionInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionInformation_Item, MBS_SessionInformation_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionInformation_List_sequence_of[1] = {
  { &hf_xnap_MBS_SessionInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionInformation_Item },
};

static int
dissect_xnap_MBS_SessionInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionInformation_List, MBS_SessionInformation_List_sequence_of,
                                                  1, maxnoofMBSSessions, FALSE);

  return offset;
}


static const per_sequence_t MBS_SessionInformationResponse_Item_sequence[] = {
  { &hf_xnap_mBS_Session_ID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_Session_ID },
  { &hf_xnap_mBS_DataForwardingResponseInfofromTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBS_DataForwardingResponseInfofromTarget },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MBS_SessionInformationResponse_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MBS_SessionInformationResponse_Item, MBS_SessionInformationResponse_Item_sequence);

  return offset;
}


static const per_sequence_t MBS_SessionInformationResponse_List_sequence_of[1] = {
  { &hf_xnap_MBS_SessionInformationResponse_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_SessionInformationResponse_Item },
};

static int
dissect_xnap_MBS_SessionInformationResponse_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MBS_SessionInformationResponse_List, MBS_SessionInformationResponse_List_sequence_of,
                                                  1, maxnoofMBSSessions, FALSE);

  return offset;
}


static const value_string xnap_MDT_Activation_vals[] = {
  {   0, "immediate-MDT-only" },
  {   1, "immediate-MDT-and-Trace" },
  {   2, "logged-MDT-only" },
  { 0, NULL }
};


static int
dissect_xnap_MDT_Activation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_MDTMode_NR_Extension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_xnap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string xnap_MDTMode_NR_vals[] = {
  {   0, "immediateMDT" },
  {   1, "loggedMDT" },
  {   2, "mDTMode-NR-Extension" },
  { 0, NULL }
};

static const per_choice_t MDTMode_NR_choice[] = {
  {   0, &hf_xnap_immediateMDT   , ASN1_EXTENSION_ROOT    , dissect_xnap_ImmediateMDT_NR },
  {   1, &hf_xnap_loggedMDT      , ASN1_EXTENSION_ROOT    , dissect_xnap_LoggedMDT_NR },
  {   2, &hf_xnap_mDTMode_NR_Extension, ASN1_NOT_EXTENSION_ROOT, dissect_xnap_MDTMode_NR_Extension },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_MDTMode_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_MDTMode_NR, MDTMode_NR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MDTPLMNList_sequence_of[1] = {
  { &hf_xnap_MDTPLMNList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_MDTPLMNList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MDTPLMNList, MDTPLMNList_sequence_of,
                                                  1, maxnoofMDTPLMNs, FALSE);

  return offset;
}


static const per_sequence_t MDT_Configuration_NR_sequence[] = {
  { &hf_xnap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDT_Activation },
  { &hf_xnap_areaScopeOfMDT_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfMDT_NR },
  { &hf_xnap_mDTMode_NR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTMode_NR },
  { &hf_xnap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDTPLMNList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration_NR, MDT_Configuration_NR_sequence);

  return offset;
}



static int
dissect_xnap_MDTMode_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *mdt_mode_eutra_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &mdt_mode_eutra_tvb);

  if (mdt_mode_eutra_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_MDTMode_EUTRA);
    dissect_s1ap_MDTMode_PDU(mdt_mode_eutra_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t MDT_Configuration_EUTRA_sequence[] = {
  { &hf_xnap_mdt_Activation , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDT_Activation },
  { &hf_xnap_areaScopeOfMDT_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfMDT_EUTRA },
  { &hf_xnap_mDTMode_EUTRA  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTMode_EUTRA },
  { &hf_xnap_signallingBasedMDTPLMNList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MDTPLMNList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration_EUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration_EUTRA, MDT_Configuration_EUTRA_sequence);

  return offset;
}


static const per_sequence_t MDT_Configuration_sequence[] = {
  { &hf_xnap_mDT_Configuration_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Configuration_NR },
  { &hf_xnap_mDT_Configuration_EUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDT_Configuration_EUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MDT_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MDT_Configuration, MDT_Configuration_sequence);

  return offset;
}


static const per_sequence_t MDTPLMNModificationList_sequence_of[1] = {
  { &hf_xnap_MDTPLMNModificationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_MDTPLMNModificationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_MDTPLMNModificationList, MDTPLMNModificationList_sequence_of,
                                                  0, maxnoofMDTPLMNs, FALSE);

  return offset;
}



static int
dissect_xnap_Measurement_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4095U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_UL_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_non_GBR_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_Total_PRB_usage_for_MIMO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MIMOPRBusageInformation_sequence[] = {
  { &hf_xnap_dl_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_ul_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_dl_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_non_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_ul_non_GBR_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_non_GBR_PRB_usage_for_MIMO },
  { &hf_xnap_dl_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DL_Total_PRB_usage_for_MIMO },
  { &hf_xnap_ul_Total_PRB_usage_for_MIMO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_Total_PRB_usage_for_MIMO },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MIMOPRBusageInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MIMOPRBusageInformation, MIMOPRBusageInformation_sequence);

  return offset;
}



static int
dissect_xnap_MobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_M20_20(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -20, 20U, NULL, FALSE);

  return offset;
}


static const per_sequence_t MobilityParametersModificationRange_sequence[] = {
  { &hf_xnap_handoverTriggerChangeLowerLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { &hf_xnap_handoverTriggerChangeUpperLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityParametersModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityParametersModificationRange, MobilityParametersModificationRange_sequence);

  return offset;
}


static const per_sequence_t MobilityParametersInformation_sequence[] = {
  { &hf_xnap_handoverTriggerChange, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_M20_20 },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityParametersInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityParametersInformation, MobilityParametersInformation_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity_sequence_of[1] = {
  { &hf_xnap_equivalent_PLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity, SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity_sequence_of,
                                                  1, maxnoofEPLMNs, FALSE);

  return offset;
}


static int * const RAT_RestrictionInformation_bits[] = {
  &hf_xnap_RAT_RestrictionInformation_e_UTRA,
  &hf_xnap_RAT_RestrictionInformation_nR,
  &hf_xnap_RAT_RestrictionInformation_nR_unlicensed,
  &hf_xnap_RAT_RestrictionInformation_nR_LEO,
  &hf_xnap_RAT_RestrictionInformation_nR_MEO,
  &hf_xnap_RAT_RestrictionInformation_nR_GEO,
  &hf_xnap_RAT_RestrictionInformation_nR_OTHERSAT,
  NULL
};

static int
dissect_xnap_RAT_RestrictionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, TRUE, RAT_RestrictionInformation_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t RAT_RestrictionsItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_rat_RestrictionInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RAT_RestrictionInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RAT_RestrictionsItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RAT_RestrictionsItem, RAT_RestrictionsItem_sequence);

  return offset;
}


static const per_sequence_t RAT_RestrictionsList_sequence_of[1] = {
  { &hf_xnap_RAT_RestrictionsList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RAT_RestrictionsItem },
};

static int
dissect_xnap_RAT_RestrictionsList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_RAT_RestrictionsList, RAT_RestrictionsList_sequence_of,
                                                  1, maxnoofPLMNs, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC_sequence_of[1] = {
  { &hf_xnap_forbidden_TACs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC, SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC_sequence_of,
                                                  1, maxnoofForbiddenTACs, FALSE);

  return offset;
}


static const per_sequence_t ForbiddenAreaItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_forbidden_TACs , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofForbiddenTACs_OF_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ForbiddenAreaItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ForbiddenAreaItem, ForbiddenAreaItem_sequence);

  return offset;
}


static const per_sequence_t ForbiddenAreaList_sequence_of[1] = {
  { &hf_xnap_ForbiddenAreaList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ForbiddenAreaItem },
};

static int
dissect_xnap_ForbiddenAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ForbiddenAreaList, ForbiddenAreaList_sequence_of,
                                                  1, maxnoofPLMNs, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC_sequence_of[1] = {
  { &hf_xnap_allowed_TACs_ServiceArea_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC, SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC_sequence_of,
                                                  1, maxnoofAllowedAreas, FALSE);

  return offset;
}


static const per_sequence_t ServiceAreaItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_allowed_TACs_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC },
  { &hf_xnap_not_allowed_TACs_ServiceArea, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofAllowedAreas_OF_TAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServiceAreaItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServiceAreaItem, ServiceAreaItem_sequence);

  return offset;
}


static const per_sequence_t ServiceAreaList_sequence_of[1] = {
  { &hf_xnap_ServiceAreaList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServiceAreaItem },
};

static int
dissect_xnap_ServiceAreaList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServiceAreaList, ServiceAreaList_sequence_of,
                                                  1, maxnoofPLMNs, FALSE);

  return offset;
}


static const per_sequence_t MobilityRestrictionList_sequence[] = {
  { &hf_xnap_serving_PLMN   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_equivalent_PLMNs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofEPLMNs_OF_PLMN_Identity },
  { &hf_xnap_rat_Restrictions, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RAT_RestrictionsList },
  { &hf_xnap_forbiddenAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ForbiddenAreaList },
  { &hf_xnap_serviceAreaInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServiceAreaList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MobilityRestrictionList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MobilityRestrictionList, MobilityRestrictionList_sequence);

  return offset;
}


static const value_string xnap_T_cn_Type_vals[] = {
  {   0, "epc-forbidden" },
  {   1, "fiveGC-forbidden" },
  { 0, NULL }
};


static int
dissect_xnap_T_cn_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalentItem_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_cn_Type        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_cn_Type },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_CNTypeRestrictionsForEquivalentItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_CNTypeRestrictionsForEquivalentItem, CNTypeRestrictionsForEquivalentItem_sequence);

  return offset;
}


static const per_sequence_t CNTypeRestrictionsForEquivalent_sequence_of[1] = {
  { &hf_xnap_CNTypeRestrictionsForEquivalent_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CNTypeRestrictionsForEquivalentItem },
};

static int
dissect_xnap_CNTypeRestrictionsForEquivalent(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_CNTypeRestrictionsForEquivalent, CNTypeRestrictionsForEquivalent_sequence_of,
                                                  1, maxnoofEPLMNs, FALSE);

  return offset;
}


static const value_string xnap_CNTypeRestrictionsForServing_vals[] = {
  {   0, "epc-forbidden" },
  { 0, NULL }
};


static int
dissect_xnap_CNTypeRestrictionsForServing(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6_4400(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 4400, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_E_UTRA_CoordinationAssistanceInfo_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_xnap_E_UTRA_CoordinationAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t E_UTRA_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_e_utra_cell    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_ul_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_dl_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_nr_cell        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NR_CGI },
  { &hf_xnap_e_utra_coordination_assistance_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRA_CoordinationAssistanceInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_E_UTRA_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_E_UTRA_ResourceCoordinationInfo, E_UTRA_ResourceCoordinationInfo_sequence);

  return offset;
}


static const value_string xnap_NR_CoordinationAssistanceInfo_vals[] = {
  {   0, "coordination-not-required" },
  { 0, NULL }
};


static int
dissect_xnap_NR_CoordinationAssistanceInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_nr_cell        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_ul_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_dl_coordination_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6_4400 },
  { &hf_xnap_e_utra_cell    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_nr_coordination_assistance_info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NR_CoordinationAssistanceInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_ResourceCoordinationInfo, NR_ResourceCoordinationInfo_sequence);

  return offset;
}


static const value_string xnap_NG_RAN_Node_ResourceCoordinationInfo_vals[] = {
  {   0, "eutra-resource-coordination-info" },
  {   1, "nr-resource-coordination-info" },
  { 0, NULL }
};

static const per_choice_t NG_RAN_Node_ResourceCoordinationInfo_choice[] = {
  {   0, &hf_xnap_eutra_resource_coordination_info, ASN1_NO_EXTENSIONS     , dissect_xnap_E_UTRA_ResourceCoordinationInfo },
  {   1, &hf_xnap_nr_resource_coordination_info, ASN1_NO_EXTENSIONS     , dissect_xnap_NR_ResourceCoordinationInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NG_RAN_Node_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NG_RAN_Node_ResourceCoordinationInfo, NG_RAN_Node_ResourceCoordinationInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t MR_DC_ResourceCoordinationInfo_sequence[] = {
  { &hf_xnap_ng_RAN_Node_ResourceCoordinationInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Node_ResourceCoordinationInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MR_DC_ResourceCoordinationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MR_DC_ResourceCoordinationInfo, MR_DC_ResourceCoordinationInfo_sequence);

  return offset;
}


static const per_sequence_t MessageOversizeNotification_sequence[] = {
  { &hf_xnap_maximumCellListSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MaximumCellListSize },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_MessageOversizeNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_MessageOversizeNotification, MessageOversizeNotification_sequence);

  return offset;
}


static const value_string xnap_NBIoT_UL_DL_AlignmentOffset_vals[] = {
  {   0, "khz-7dot5" },
  {   1, "khz0" },
  {   2, "khz7dot5" },
  { 0, NULL }
};


static int
dissect_xnap_NBIoT_UL_DL_AlignmentOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_subframeAssignment_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_xnap_T_subframeAssignment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NE_DC_TDM_Pattern_sequence[] = {
  { &hf_xnap_subframeAssignment, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_subframeAssignment },
  { &hf_xnap_harqOffset     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_9 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NE_DC_TDM_Pattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NE_DC_TDM_Pattern, NE_DC_TDM_Pattern_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_E_UTRA_Item_sequence[] = {
  { &hf_xnap_e_utra_PCI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAPCI },
  { &hf_xnap_e_utra_cgi     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_earfcn         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAARFCN },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_E_UTRA_Item, NeighbourInformation_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_E_UTRA_sequence_of[1] = {
  { &hf_xnap_NeighbourInformation_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_E_UTRA_Item },
};

static int
dissect_xnap_NeighbourInformation_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NeighbourInformation_E_UTRA, NeighbourInformation_E_UTRA_sequence_of,
                                                  1, maxnoofNeighbours, FALSE);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_ModeFDDInfo_sequence[] = {
  { &hf_xnap_ul_NR_FreqInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dl_NR_FequInfo , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeFDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_ModeFDDInfo, NeighbourInformation_NR_ModeFDDInfo_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_ModeTDDInfo_sequence[] = {
  { &hf_xnap_nr_FreqInfo    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeTDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_ModeTDDInfo, NeighbourInformation_NR_ModeTDDInfo_sequence);

  return offset;
}


static const value_string xnap_NeighbourInformation_NR_ModeInfo_vals[] = {
  {   0, "fdd-info" },
  {   1, "tdd-info" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NeighbourInformation_NR_ModeInfo_choice[] = {
  {   0, &hf_xnap_fdd_info       , ASN1_NO_EXTENSIONS     , dissect_xnap_NeighbourInformation_NR_ModeFDDInfo },
  {   1, &hf_xnap_tdd_info       , ASN1_NO_EXTENSIONS     , dissect_xnap_NeighbourInformation_NR_ModeTDDInfo },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_ModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NeighbourInformation_NR_ModeInfo, NeighbourInformation_NR_ModeInfo_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_T_measurementTimingConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NeighbourInformation_NR_Item_sequence[] = {
  { &hf_xnap_nr_PCI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPCI },
  { &hf_xnap_nr_cgi         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_nr_mode_info   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_NR_ModeInfo },
  { &hf_xnap_connectivitySupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Connectivity_Support },
  { &hf_xnap_measurementTimingConfiguration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_measurementTimingConfiguration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NeighbourInformation_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NeighbourInformation_NR_Item, NeighbourInformation_NR_Item_sequence);

  return offset;
}


static const per_sequence_t NeighbourInformation_NR_sequence_of[1] = {
  { &hf_xnap_NeighbourInformation_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NeighbourInformation_NR_Item },
};

static int
dissect_xnap_NeighbourInformation_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NeighbourInformation_NR, NeighbourInformation_NR_sequence_of,
                                                  1, maxnoofNeighbours, FALSE);

  return offset;
}


static const per_sequence_t Neighbour_NG_RAN_Node_Item_sequence[] = {
  { &hf_xnap_globalNG_RANNodeID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_GlobalNG_RANNode_ID },
  { &hf_xnap_local_NG_RAN_Node_Identifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Local_NG_RAN_Node_Identifier },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Neighbour_NG_RAN_Node_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Neighbour_NG_RAN_Node_Item, Neighbour_NG_RAN_Node_Item_sequence);

  return offset;
}


static const per_sequence_t Neighbour_NG_RAN_Node_List_sequence_of[1] = {
  { &hf_xnap_Neighbour_NG_RAN_Node_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Neighbour_NG_RAN_Node_Item },
};

static int
dissect_xnap_Neighbour_NG_RAN_Node_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Neighbour_NG_RAN_Node_List, Neighbour_NG_RAN_Node_List_sequence_of,
                                                  0, maxnoofNeighbour_NG_RAN_Nodes, FALSE);

  return offset;
}



static int
dissect_xnap_NRCellPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NRCellPRACHConfig);
    dissect_f1ap_NRPRACHConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SSBOffsetModificationRange_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_sSBobilityParametersModificationRange, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MobilityParametersModificationRange },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBOffsetModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBOffsetModificationRange, SSBOffsetModificationRange_sequence);

  return offset;
}


static const per_sequence_t NG_RANnode2SSBOffsetsModificationRange_sequence_of[1] = {
  { &hf_xnap_NG_RANnode2SSBOffsetsModificationRange_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBOffsetModificationRange },
};

static int
dissect_xnap_NG_RANnode2SSBOffsetsModificationRange(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NG_RANnode2SSBOffsetsModificationRange, NG_RANnode2SSBOffsetsModificationRange_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}



static int
dissect_xnap_DL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_UL_scheduling_PDCCH_CCE_usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ULNonF1Terminating_BHInfo_sequence[] = {
  { &hf_xnap_egressBAPRoutingID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPRoutingID },
  { &hf_xnap_egressBHRLCCHID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHRLCChannelID },
  { &hf_xnap_nexthopBAPAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BAPAddress },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULNonF1Terminating_BHInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULNonF1Terminating_BHInfo, ULNonF1Terminating_BHInfo_sequence);

  return offset;
}


static const per_sequence_t NonF1TerminatingBHInformation_Item_sequence[] = {
  { &hf_xnap_bHInfoIndex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BHInfoIndex },
  { &hf_xnap_dlNon_F1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DLNonF1Terminating_BHInfo },
  { &hf_xnap_ulNon_F1TerminatingBHInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULNonF1Terminating_BHInfo },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NonF1TerminatingBHInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NonF1TerminatingBHInformation_Item, NonF1TerminatingBHInformation_Item_sequence);

  return offset;
}


static const per_sequence_t NonF1TerminatingBHInformation_List_sequence_of[1] = {
  { &hf_xnap_NonF1TerminatingBHInformation_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NonF1TerminatingBHInformation_Item },
};

static int
dissect_xnap_NonF1TerminatingBHInformation_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NonF1TerminatingBHInformation_List, NonF1TerminatingBHInformation_List_sequence_of,
                                                  1, maxnoofBHInfo, FALSE);

  return offset;
}


static const per_sequence_t Non_F1_TerminatingTopologyBHInformation_sequence[] = {
  { &hf_xnap_nonF1TerminatingBHInformation_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NonF1TerminatingBHInformation_List },
  { &hf_xnap_bAPControlPDURLCCH_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BAPControlPDURLCCH_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Non_F1_TerminatingTopologyBHInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Non_F1_TerminatingTopologyBHInformation, Non_F1_TerminatingTopologyBHInformation_sequence);

  return offset;
}


static const value_string xnap_NonUPTrafficType_vals[] = {
  {   0, "ueassociatedf1ap" },
  {   1, "nonueassociatedf1ap" },
  {   2, "nonf1" },
  { 0, NULL }
};


static int
dissect_xnap_NonUPTrafficType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_NonUPTraffic_vals[] = {
  {   0, "nonUPTrafficType" },
  {   1, "controlPlaneTrafficType" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NonUPTraffic_choice[] = {
  {   0, &hf_xnap_nonUPTrafficType, ASN1_NO_EXTENSIONS     , dissect_xnap_NonUPTrafficType },
  {   1, &hf_xnap_controlPlaneTrafficType, ASN1_NO_EXTENSIONS     , dissect_xnap_ControlPlaneTrafficType },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NonUPTraffic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NonUPTraffic, NonUPTraffic_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NoPDUSessionIndication_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_NoPDUSessionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_SNPN_sequence[] = {
  { &hf_xnap_broadcastSNPNID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastSNPNID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Broadcast_Information_SNPN, NPN_Broadcast_Information_SNPN_sequence);

  return offset;
}


static const per_sequence_t NPN_Broadcast_Information_PNI_NPN_sequence[] = {
  { &hf_xnap_broadcastPNI_NPN_ID_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPNI_NPN_ID_Information },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Broadcast_Information_PNI_NPN, NPN_Broadcast_Information_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPN_Broadcast_Information_vals[] = {
  {   0, "snpn-Information" },
  {   1, "pni-npn-Information" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPN_Broadcast_Information_choice[] = {
  {   0, &hf_xnap_snpn_Information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Broadcast_Information_SNPN },
  {   1, &hf_xnap_pni_npn_Information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Broadcast_Information_PNI_NPN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPN_Broadcast_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPN_Broadcast_Information, NPN_Broadcast_Information_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPNMobilityInformation_SNPN_sequence[] = {
  { &hf_xnap_serving_NID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNMobilityInformation_SNPN, NPNMobilityInformation_SNPN_sequence);

  return offset;
}


static const per_sequence_t NPNMobilityInformation_PNI_NPN_sequence[] = {
  { &hf_xnap_allowedPNI_NPN_ID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNMobilityInformation_PNI_NPN, NPNMobilityInformation_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPNMobilityInformation_vals[] = {
  {   0, "snpn-mobility-information" },
  {   1, "pni-npn-mobility-information" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNMobilityInformation_choice[] = {
  {   0, &hf_xnap_snpn_mobility_information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNMobilityInformation_SNPN },
  {   1, &hf_xnap_pni_npn_mobility_information, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNMobilityInformation_PNI_NPN },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPNMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPNMobilityInformation, NPNMobilityInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPNPagingAssistanceInformation_PNI_NPN_sequence[] = {
  { &hf_xnap_allowedPNI_NPN_ID_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AllowedPNI_NPN_ID_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPNPagingAssistanceInformation_PNI_NPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPNPagingAssistanceInformation_PNI_NPN, NPNPagingAssistanceInformation_PNI_NPN_sequence);

  return offset;
}


static const value_string xnap_NPNPagingAssistanceInformation_vals[] = {
  {   0, "pni-npn-Information" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NPNPagingAssistanceInformation_choice[] = {
  {   0, &hf_xnap_pni_npn_Information_01, ASN1_NO_EXTENSIONS     , dissect_xnap_NPNPagingAssistanceInformation_PNI_NPN },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPNPagingAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPNPagingAssistanceInformation, NPNPagingAssistanceInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPN_Support_SNPN_sequence[] = {
  { &hf_xnap_nid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NID },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPN_Support_SNPN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPN_Support_SNPN, NPN_Support_SNPN_sequence);

  return offset;
}


static const value_string xnap_NPN_Support_vals[] = {
  {   0, "sNPN" },
  {   1, "choice-Extensions" },
  { 0, NULL }
};

static const per_choice_t NPN_Support_choice[] = {
  {   0, &hf_xnap_sNPN           , ASN1_NO_EXTENSIONS     , dissect_xnap_NPN_Support_SNPN },
  {   1, &hf_xnap_choice_Extensions, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NPN_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NPN_Support, NPN_Support_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NPRACH_CP_Length_vals[] = {
  {   0, "us66dot7" },
  {   1, "us266dot7" },
  { 0, NULL }
};


static int
dissect_xnap_NPRACH_CP_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r13_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_anchorCarrier_Format2_EDT_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_Format2_EDT_NPRACHConfig);
    dissect_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_Format2_NPRACHConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_Format2_NPRACHConfig);
    dissect_lte_rrc_UL_ConfigCommonList_NB_v1530_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NPRACHConfiguration_FDD_sequence[] = {
  { &hf_xnap_nprach_CP_length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NPRACH_CP_Length },
  { &hf_xnap_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_anchorCarrier_NPRACHConfig },
  { &hf_xnap_anchorCarrier_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_EDT_NPRACHConfig },
  { &hf_xnap_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_Format2_NPRACHConfig },
  { &hf_xnap_anchorCarrier_Format2_EDT_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_anchorCarrier_Format2_EDT_NPRACHConfig },
  { &hf_xnap_non_anchorCarrier_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_NPRACHConfig },
  { &hf_xnap_non_anchorCarrier_Format2_NPRACHConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_Format2_NPRACHConfig },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration_FDD, NPRACHConfiguration_FDD_sequence);

  return offset;
}


static const value_string xnap_NPRACH_preambleFormat_vals[] = {
  {   0, "fmt0" },
  {   1, "fmt1" },
  {   2, "fmt2" },
  {   3, "fmt0a" },
  {   4, "fmt1a" },
  { 0, NULL }
};


static int
dissect_xnap_NPRACH_preambleFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_NPRACH_ParametersListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_T_non_anchorCarrierFrquency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrierFrequency);
    dissect_lte_rrc_DL_CarrierConfigCommon_NB_r14_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_item_sequence[] = {
  { &hf_xnap_non_anchorCarrierFrquency, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_non_anchorCarrierFrquency },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_Non_AnchorCarrierFrequencylist_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_Non_AnchorCarrierFrequencylist_item, Non_AnchorCarrierFrequencylist_item_sequence);

  return offset;
}


static const per_sequence_t Non_AnchorCarrierFrequencylist_sequence_of[1] = {
  { &hf_xnap_Non_AnchorCarrierFrequencylist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Non_AnchorCarrierFrequencylist_item },
};

static int
dissect_xnap_Non_AnchorCarrierFrequencylist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Non_AnchorCarrierFrequencylist, Non_AnchorCarrierFrequencylist_sequence_of,
                                                  1, maxnoofNonAnchorCarrierFreqConfig, FALSE);

  return offset;
}



static int
dissect_xnap_T_non_anchorCarrier_NPRACHConfigTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_non_anchorCarrier_NPRACHConfigTDD);
    dissect_lte_rrc_UL_ConfigCommonListTDD_NB_r15_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NPRACHConfiguration_TDD_sequence[] = {
  { &hf_xnap_nprach_preambleFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NPRACH_preambleFormat },
  { &hf_xnap_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_anchorCarrier_NPRACHConfigTDD },
  { &hf_xnap_non_anchorCarrierFequencyConfiglist, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Non_AnchorCarrierFrequencylist },
  { &hf_xnap_non_anchorCarrier_NPRACHConfigTDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_non_anchorCarrier_NPRACHConfigTDD },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration_TDD, NPRACHConfiguration_TDD_sequence);

  return offset;
}


static const value_string xnap_T_fdd_or_tdd_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t T_fdd_or_tdd_choice[] = {
  {   0, &hf_xnap_fdd            , ASN1_NO_EXTENSIONS     , dissect_xnap_NPRACHConfiguration_FDD },
  {   1, &hf_xnap_tdd            , ASN1_NO_EXTENSIONS     , dissect_xnap_NPRACHConfiguration_TDD },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_T_fdd_or_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_T_fdd_or_tdd, T_fdd_or_tdd_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NPRACHConfiguration_sequence[] = {
  { &hf_xnap_fdd_or_tdd     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_fdd_or_tdd },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NPRACHConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NPRACHConfiguration, NPRACHConfiguration_sequence);

  return offset;
}


static const per_sequence_t NG_RAN_Cell_Identity_ListinRANPagingArea_sequence_of[1] = {
  { &hf_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_Cell_Identity },
};

static int
dissect_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea, NG_RAN_Cell_Identity_ListinRANPagingArea_sequence_of,
                                                  1, maxnoofCellsinRNA, FALSE);

  return offset;
}



static int
dissect_xnap_NR_U_ChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofNR_UChannelIDs, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_ChannelOccupancyTimePercentage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_EnergyDetectionThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -100, -50, NULL, TRUE);

  return offset;
}


static const per_sequence_t NR_U_Channel_Item_sequence[] = {
  { &hf_xnap_nR_U_ChannelID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelID },
  { &hf_xnap_channelOccupancyTimePercentageDL, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ChannelOccupancyTimePercentage },
  { &hf_xnap_energyDetectionThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_EnergyDetectionThreshold },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_U_Channel_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_U_Channel_Item, NR_U_Channel_Item_sequence);

  return offset;
}


static const per_sequence_t NR_U_Channel_List_sequence_of[1] = {
  { &hf_xnap_NR_U_Channel_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_Channel_Item },
};

static int
dissect_xnap_NR_U_Channel_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NR_U_Channel_List, NR_U_Channel_List_sequence_of,
                                                  1, maxnoofNR_UChannelIDs, FALSE);

  return offset;
}


static const value_string xnap_Bandwidth_vals[] = {
  {   0, "mhz10" },
  {   1, "mhz20" },
  {   2, "mhz40" },
  {   3, "mhz60" },
  {   4, "mhz80" },
  { 0, NULL }
};


static int
dissect_xnap_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_U_ChannelInfo_Item_sequence[] = {
  { &hf_xnap_nR_U_ChannelID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelID },
  { &hf_xnap_nRARFCN        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRARFCN },
  { &hf_xnap_bandwidth      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Bandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NR_U_ChannelInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NR_U_ChannelInfo_Item, NR_U_ChannelInfo_Item_sequence);

  return offset;
}


static const per_sequence_t NR_U_ChannelInfo_List_sequence_of[1] = {
  { &hf_xnap_NR_U_ChannelInfo_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_NR_U_ChannelInfo_Item },
};

static int
dissect_xnap_NR_U_ChannelInfo_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_NR_U_ChannelInfo_List, NR_U_ChannelInfo_List_sequence_of,
                                                  1, maxnoofNR_UChannelIDs, FALSE);

  return offset;
}



static int
dissect_xnap_NRMobilityHistoryReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_NRMobilityHistoryReport);
    dissect_nr_rrc_VisitedCellInfoList_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t NRModeInfoFDD_sequence[] = {
  { &hf_xnap_ulNRFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_dlNRFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_ulNRTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_dlNRTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRModeInfoFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRModeInfoFDD, NRModeInfoFDD_sequence);

  return offset;
}


static const per_sequence_t NRModeInfoTDD_sequence[] = {
  { &hf_xnap_nrFrequencyInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRFrequencyInfo },
  { &hf_xnap_nrTransmissonBandwidth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRTransmissionBandwidth },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRModeInfoTDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRModeInfoTDD, NRModeInfoTDD_sequence);

  return offset;
}


static const value_string xnap_NRModeInfo_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t NRModeInfo_choice[] = {
  {   0, &hf_xnap_fdd_01         , ASN1_NO_EXTENSIONS     , dissect_xnap_NRModeInfoFDD },
  {   1, &hf_xnap_tdd_01         , ASN1_NO_EXTENSIONS     , dissect_xnap_NRModeInfoTDD },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_NRModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_NRModeInfo, NRModeInfo_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_NRPaging_eDRX_Cycle_vals[] = {
  {   0, "hfquarter" },
  {   1, "hfhalf" },
  {   2, "hf1" },
  {   3, "hf2" },
  {   4, "hf4" },
  {   5, "hf8" },
  {   6, "hf16" },
  {   7, "hf32" },
  {   8, "hf64" },
  {   9, "hf128" },
  {  10, "hf256" },
  {  11, "hf512" },
  {  12, "hf1024" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_eDRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_NRPaging_Time_Window_vals[] = {
  {   0, "s1" },
  {   1, "s2" },
  {   2, "s3" },
  {   3, "s4" },
  {   4, "s5" },
  {   5, "s6" },
  {   6, "s7" },
  {   7, "s8" },
  {   8, "s9" },
  {   9, "s10" },
  {  10, "s11" },
  {  11, "s12" },
  {  12, "s13" },
  {  13, "s14" },
  {  14, "s15" },
  {  15, "s16" },
  {  16, "s17" },
  {  17, "s18" },
  {  18, "s19" },
  {  19, "s20" },
  {  20, "s21" },
  {  21, "s22" },
  {  22, "s23" },
  {  23, "s24" },
  {  24, "s25" },
  {  25, "s26" },
  {  26, "s27" },
  {  27, "s28" },
  {  28, "s29" },
  {  29, "s30" },
  {  30, "s31" },
  {  31, "s32" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_Time_Window(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 16, NULL);

  return offset;
}


static const per_sequence_t NRPagingeDRXInformation_sequence[] = {
  { &hf_xnap_nRPaging_eDRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_eDRX_Cycle },
  { &hf_xnap_nRPaging_Time_Window, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NRPaging_Time_Window },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRPagingeDRXInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRPagingeDRXInformation, NRPagingeDRXInformation_sequence);

  return offset;
}


static const value_string xnap_NRPaging_eDRX_Cycle_Inactive_vals[] = {
  {   0, "hfquarter" },
  {   1, "hfhalf" },
  {   2, "hf1" },
  { 0, NULL }
};


static int
dissect_xnap_NRPaging_eDRX_Cycle_Inactive(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NRPagingeDRXInformationforRRCINACTIVE_sequence[] = {
  { &hf_xnap_nRPaging_eDRX_Cycle_Inactive, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPaging_eDRX_Cycle_Inactive },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRPagingeDRXInformationforRRCINACTIVE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRPagingeDRXInformationforRRCINACTIVE, NRPagingeDRXInformationforRRCINACTIVE_sequence);

  return offset;
}


static const value_string xnap_NumberOfAntennaPorts_E_UTRA_vals[] = {
  {   0, "an1" },
  {   1, "an2" },
  {   2, "an4" },
  { 0, NULL }
};


static int
dissect_xnap_NumberOfAntennaPorts_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_NonGBRResources_Offered_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_NonGBRResources_Offered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NRV2XServicesAuthorized_sequence[] = {
  { &hf_xnap_vehicleUE      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_VehicleUE },
  { &hf_xnap_pedestrianUE   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PedestrianUE },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRV2XServicesAuthorized(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRV2XServicesAuthorized, NRV2XServicesAuthorized_sequence);

  return offset;
}


static const per_sequence_t NRUESidelinkAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_uESidelinkAggregateMaximumBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_NRUESidelinkAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_NRUESidelinkAggregateMaximumBitRate, NRUESidelinkAggregateMaximumBitRate_sequence);

  return offset;
}



static int
dissect_xnap_NSAG_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}


static const value_string xnap_OffsetOfNbiotChannelNumberToEARFCN_vals[] = {
  {   0, "minusTen" },
  {   1, "minusNine" },
  {   2, "minusEightDotFive" },
  {   3, "minusEight" },
  {   4, "minusSeven" },
  {   5, "minusSix" },
  {   6, "minusFive" },
  {   7, "minusFourDotFive" },
  {   8, "minusFour" },
  {   9, "minusThree" },
  {  10, "minusTwo" },
  {  11, "minusOne" },
  {  12, "minusZeroDotFive" },
  {  13, "zero" },
  {  14, "one" },
  {  15, "two" },
  {  16, "three" },
  {  17, "threeDotFive" },
  {  18, "four" },
  {  19, "five" },
  {  20, "six" },
  {  21, "seven" },
  {  22, "sevenDotFive" },
  {  23, "eight" },
  {  24, "nine" },
  { 0, NULL }
};


static int
dissect_xnap_OffsetOfNbiotChannelNumberToEARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     25, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_RequestedSRSTransmissionCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_RoutingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PositioningInformation_sequence[] = {
  { &hf_xnap_requestedSRSTransmissionCharacteristics, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RequestedSRSTransmissionCharacteristics },
  { &hf_xnap_routingID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RoutingID },
  { &hf_xnap_nRPPaTransactionID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_32767 },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PositioningInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PositioningInformation, PositioningInformation_sequence);

  return offset;
}


static const value_string xnap_PagingCause_vals[] = {
  {   0, "voice" },
  { 0, NULL }
};


static int
dissect_xnap_PagingCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PEIPSassistanceInformation_sequence[] = {
  { &hf_xnap_cNsubgroupID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CNsubgroupID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PEIPSassistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PEIPSassistanceInformation, PEIPSassistanceInformation_sequence);

  return offset;
}


static const value_string xnap_PagingDRX_vals[] = {
  {   0, "v32" },
  {   1, "v64" },
  {   2, "v128" },
  {   3, "v256" },
  {   4, "v512" },
  {   5, "v1024" },
  { 0, NULL }
};


static int
dissect_xnap_PagingDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 2, NULL);

  return offset;
}


static const value_string xnap_PagingPriority_vals[] = {
  {   0, "priolevel1" },
  {   1, "priolevel2" },
  {   2, "priolevel3" },
  {   3, "priolevel4" },
  {   4, "priolevel5" },
  {   5, "priolevel6" },
  {   6, "priolevel7" },
  {   7, "priolevel8" },
  { 0, NULL }
};


static int
dissect_xnap_PagingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_PartialListIndicator_vals[] = {
  {   0, "partial" },
  { 0, NULL }
};


static int
dissect_xnap_PartialListIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PC5FlowBitRates_sequence[] = {
  { &hf_xnap_guaranteedFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_maximumFlowBitRate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5FlowBitRates(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5FlowBitRates, PC5FlowBitRates_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowItem_sequence[] = {
  { &hf_xnap_pQI            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_FiveQI },
  { &hf_xnap_pc5FlowBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PC5FlowBitRates },
  { &hf_xnap_range          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Range },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5QoSFlowItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5QoSFlowItem, PC5QoSFlowItem_sequence);

  return offset;
}


static const per_sequence_t PC5QoSFlowList_sequence_of[1] = {
  { &hf_xnap_PC5QoSFlowList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PC5QoSFlowItem },
};

static int
dissect_xnap_PC5QoSFlowList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PC5QoSFlowList, PC5QoSFlowList_sequence_of,
                                                  1, maxnoofPC5QoSFlows, FALSE);

  return offset;
}


static const per_sequence_t PC5QoSParameters_sequence[] = {
  { &hf_xnap_pc5QoSFlowList , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PC5QoSFlowList },
  { &hf_xnap_pc5LinkAggregateBitRates, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PC5QoSParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PC5QoSParameters, PC5QoSParameters_sequence);

  return offset;
}


static const value_string xnap_T_from_S_NG_RAN_node_vals[] = {
  {   0, "s-ng-ran-node-key-update-required" },
  {   1, "pdcp-data-recovery-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_from_S_NG_RAN_node(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_from_M_NG_RAN_node_vals[] = {
  {   0, "pdcp-data-recovery-required" },
  { 0, NULL }
};


static int
dissect_xnap_T_from_M_NG_RAN_node(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_PDCPChangeIndication_vals[] = {
  {   0, "from-S-NG-RAN-node" },
  {   1, "from-M-NG-RAN-node" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t PDCPChangeIndication_choice[] = {
  {   0, &hf_xnap_from_S_NG_RAN_node, ASN1_NO_EXTENSIONS     , dissect_xnap_T_from_S_NG_RAN_node },
  {   1, &hf_xnap_from_M_NG_RAN_node, ASN1_NO_EXTENSIONS     , dissect_xnap_T_from_M_NG_RAN_node },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_PDCPChangeIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_PDCPChangeIndication, PDCPChangeIndication_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_PDCPDuplicationConfiguration_vals[] = {
  {   0, "configured" },
  {   1, "de-configured" },
  { 0, NULL }
};


static int
dissect_xnap_PDCPDuplicationConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_ulPDCPSNLength_vals[] = {
  {   0, "v12bits" },
  {   1, "v18bits" },
  { 0, NULL }
};


static int
dissect_xnap_T_ulPDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_dlPDCPSNLength_vals[] = {
  {   0, "v12bits" },
  {   1, "v18bits" },
  { 0, NULL }
};


static int
dissect_xnap_T_dlPDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t PDCPSNLength_sequence[] = {
  { &hf_xnap_ulPDCPSNLength , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_ulPDCPSNLength },
  { &hf_xnap_dlPDCPSNLength , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dlPDCPSNLength },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDCPSNLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDCPSNLength, PDCPSNLength_sequence);

  return offset;
}


static const per_sequence_t PDUSessionAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_downlink_session_AMBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_uplink_session_AMBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionAggregateMaximumBitRate, PDUSessionAggregateMaximumBitRate_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
};

static int
dissect_xnap_PDUSession_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List, PDUSession_List_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t PDUSession_List_withCause_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withCause_Item, PDUSession_List_withCause_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withCause_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withCause_Item },
};

static int
dissect_xnap_PDUSession_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withCause, PDUSession_List_withCause_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingFromTarget_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withDataForwardingFromTarget_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withDataForwardingFromTarget_Item, PDUSession_List_withDataForwardingFromTarget_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingFromTarget_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withDataForwardingFromTarget_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withDataForwardingFromTarget_Item },
};

static int
dissect_xnap_PDUSession_List_withDataForwardingFromTarget(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withDataForwardingFromTarget, PDUSession_List_withDataForwardingFromTarget_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingRequest_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_dataforwardingInfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_dRBtoBeReleasedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBToQoSFlowMapping_List },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSession_List_withDataForwardingRequest_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSession_List_withDataForwardingRequest_Item, PDUSession_List_withDataForwardingRequest_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSession_List_withDataForwardingRequest_sequence_of[1] = {
  { &hf_xnap_PDUSession_List_withDataForwardingRequest_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_List_withDataForwardingRequest_Item },
};

static int
dissect_xnap_PDUSession_List_withDataForwardingRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSession_List_withDataForwardingRequest, PDUSession_List_withDataForwardingRequest_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const value_string xnap_T_dL_NG_U_TNL_Information_Unchanged_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_T_dL_NG_U_TNL_Information_Unchanged(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowsAdmitted_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsAdmitted_Item, QoSFlowsAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsAdmitted_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsAdmitted_Item },
};

static int
dissect_xnap_QoSFlowsAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsAdmitted_List, QoSFlowsAdmitted_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t QoSFlowwithCause_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowwithCause_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowwithCause_Item, QoSFlowwithCause_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlows_List_withCause_sequence_of[1] = {
  { &hf_xnap_QoSFlows_List_withCause_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowwithCause_Item },
};

static int
dissect_xnap_QoSFlows_List_withCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlows_List_withCause, QoSFlows_List_withCause_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceAdmittedInfo_sequence[] = {
  { &hf_xnap_dL_NG_U_TNL_Information_Unchanged, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_dL_NG_U_TNL_Information_Unchanged },
  { &hf_xnap_qosFlowsAdmitted_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsAdmitted_List },
  { &hf_xnap_qosFlowsNotAdmitted_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_dataForwardingInfoFromTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceAdmittedInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceAdmittedInfo, PDUSessionResourceAdmittedInfo_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesAdmitted_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_pduSessionResourceAdmittedInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceAdmittedInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesAdmitted_Item, PDUSessionResourcesAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesAdmitted_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesAdmitted_Item },
};

static int
dissect_xnap_PDUSessionResourcesAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesAdmitted_List, PDUSessionResourcesAdmitted_List_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourcesNotAdmitted_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_cause          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_Cause },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesNotAdmitted_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesNotAdmitted_Item, PDUSessionResourcesNotAdmitted_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesNotAdmitted_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesNotAdmitted_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesNotAdmitted_Item },
};

static int
dissect_xnap_PDUSessionResourcesNotAdmitted_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesNotAdmitted_List, PDUSessionResourcesNotAdmitted_List_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const value_string xnap_T_integrityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_xnap_T_integrityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_confidentialityProtectionIndication_vals[] = {
  {   0, "required" },
  {   1, "preferred" },
  {   2, "not-needed" },
  { 0, NULL }
};


static int
dissect_xnap_T_confidentialityProtectionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityIndication_sequence[] = {
  { &hf_xnap_integrityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_integrityProtectionIndication },
  { &hf_xnap_confidentialityProtectionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_confidentialityProtectionIndication },
  { &hf_xnap_maximumIPdatarate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MaximumIPdatarate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecurityIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecurityIndication, SecurityIndication_sequence);

  return offset;
}


static const value_string xnap_PDUSessionType_vals[] = {
  {   0, "ipv4" },
  {   1, "ipv6" },
  {   2, "ipv4v6" },
  {   3, "ethernet" },
  {   4, "unstructured" },
  { 0, NULL }
};


static int
dissect_xnap_PDUSessionType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_PDUSessionNetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, TRUE);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_e_RAB_ID       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_RAB_ID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_Item, QoSFlowsToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List, QoSFlowsToBeSetup_List_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourcesToBeSetup_Item_sequence[] = {
  { &hf_xnap_pduSessionId   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_pduSessionAMBR , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionAggregateMaximumBitRate },
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_source_DL_NG_U_TNL_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityIndication },
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourcesToBeSetup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourcesToBeSetup_Item, PDUSessionResourcesToBeSetup_Item_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourcesToBeSetup_List_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourcesToBeSetup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesToBeSetup_Item },
};

static int
dissect_xnap_PDUSessionResourcesToBeSetup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourcesToBeSetup_List, PDUSessionResourcesToBeSetup_List_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Setup_SNterminated_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_offeredGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item, QoSFlowsToBeSetup_List_Setup_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Setup_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated, QoSFlowsToBeSetup_List_Setup_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_securityIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupInfo_SNterminated, PDUSessionResourceSetupInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t UPTransportParametersItem_sequence[] = {
  { &hf_xnap_upTNLInfo      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_cellGroupID    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CellGroupID },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UPTransportParametersItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UPTransportParametersItem, UPTransportParametersItem_sequence);

  return offset;
}


static const per_sequence_t UPTransportParameters_sequence_of[1] = {
  { &hf_xnap_UPTransportParameters_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParametersItem },
};

static int
dissect_xnap_UPTransportParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UPTransportParameters, UPTransportParameters_sequence_of,
                                                  1, maxnoofSCellGroupsplus1, FALSE);

  return offset;
}


static const value_string xnap_UL_UE_Configuration_vals[] = {
  {   0, "no-data" },
  {   1, "shared" },
  {   2, "only" },
  { 0, NULL }
};


static int
dissect_xnap_UL_UE_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ULConfiguration_sequence[] = {
  { &hf_xnap_uL_PDCP        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UL_UE_Configuration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ULConfiguration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ULConfiguration, ULConfiguration_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item, QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated, QoSFlowsMappedtoDRB_SetupResponse_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_SetupResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item, DRBsToBeSetupList_SetupResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_SetupResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetupList_SetupResponse_SNterminated, DRBsToBeSetupList_SetupResponse_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const value_string xnap_T_integrityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_xnap_T_integrityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_confidentialityProtectionResult_vals[] = {
  {   0, "performed" },
  {   1, "not-performed" },
  { 0, NULL }
};


static int
dissect_xnap_T_confidentialityProtectionResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SecurityResult_sequence[] = {
  { &hf_xnap_integrityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_integrityProtectionResult },
  { &hf_xnap_confidentialityProtectionResult, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_confidentialityProtectionResult },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecurityResult(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecurityResult, SecurityResult_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupResponseInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsToBeSetup  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_qosFlowsNotAdmittedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_securityResult , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SecurityResult },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupResponseInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupResponseInfo_SNterminated, PDUSessionResourceSetupResponseInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_Setup_MNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qoSFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item, QoSFlowsMappedtoDRB_Setup_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_Setup_MNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated, QoSFlowsMappedtoDRB_Setup_MNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_Setup_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetupList_Setup_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetupList_Setup_MNterminated_Item, DRBsToBeSetupList_Setup_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetupList_Setup_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetupList_Setup_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_Setup_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetupList_Setup_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetupList_Setup_MNterminated, DRBsToBeSetupList_Setup_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupInfo_MNterminated_sequence[] = {
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_dRBsToBeSetup_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetupList_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupInfo_MNterminated, PDUSessionResourceSetupInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_SetupResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item, DRBsAdmittedList_SetupResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_SetupResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_SetupResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_SetupResponse_MNterminated, DRBsAdmittedList_SetupResponse_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceSetupResponseInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsAdmittedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_SetupResponse_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSetupResponseInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSetupResponseInfo_MNterminated, PDUSessionResourceSetupResponseInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_currentQoSParaSetIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSParaSetIndex },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item, QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsMappedtoDRB_SetupResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated_Item },
};

static int
dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsMappedtoDRB_SetupResponse_MNterminated, QoSFlowsMappedtoDRB_SetupResponse_MNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Modified_SNterminated_Item_sequence[] = {
  { &hf_xnap_qfi            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_qosFlowLevelQoSParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_offeredGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_qosFlowMappingIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowMappingIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item, QoSFlowsToBeSetup_List_Modified_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsToBeSetup_List_Modified_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated, QoSFlowsToBeSetup_List_Modified_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const value_string xnap_Reestablishment_Indication_vals[] = {
  {   0, "reestablished" },
  { 0, NULL }
};


static int
dissect_xnap_Reestablishment_Indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RLC_Status_sequence[] = {
  { &hf_xnap_reestablishment_Indication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Reestablishment_Indication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RLC_Status(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RLC_Status, RLC_Status_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_Modified_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_MN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_rlc_status     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLC_Status },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_Modified_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_Modified_SNterminated_Item, DRBsToBeModified_List_Modified_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_Modified_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_Modified_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_Modified_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_Modified_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_Modified_SNterminated, DRBsToBeModified_List_Modified_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_pduSessionNetworkInstance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionNetworkInstance },
  { &hf_xnap_qosFlowsToBeSetup_List_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsToBeSetup_List_Setup_SNterminated },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_qosFlowsToBeModified_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsToBeSetup_List_Modified_SNterminated },
  { &hf_xnap_qoSFlowsToBeReleased_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_drbsToBeModifiedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_Modified_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationInfo_SNterminated, PDUSessionResourceModificationInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_ModificationResponse_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_qoSFlowsMappedtoDRB_SetupResponse_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsMappedtoDRB_SetupResponse_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item, DRBsToBeModifiedList_ModificationResponse_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_ModificationResponse_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated, DRBsToBeModifiedList_ModificationResponse_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationResponseInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsToBeSetup  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_SetupResponse_SNterminated },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_dRBsToBeModified, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModifiedList_ModificationResponse_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_qosFlowsNotAdmittedTBAdded, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_qosFlowsReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationResponseInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationResponseInfo_SNterminated, PDUSessionResourceModificationResponseInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_Modification_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_MN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_pdcpDuplicationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPDuplicationConfiguration },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_Setup_MNterminated, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsMappedtoDRB_Setup_MNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item, DRBsToBeModifiedList_Modification_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModifiedList_Modification_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModifiedList_Modification_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModifiedList_Modification_MNterminated, DRBsToBeModifiedList_Modification_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationInfo_MNterminated_sequence[] = {
  { &hf_xnap_pduSessionType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionType },
  { &hf_xnap_dRBsToBeSetup_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetupList_Setup_MNterminated },
  { &hf_xnap_dRBsToBeModified_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModifiedList_Modification_MNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationInfo_MNterminated, PDUSessionResourceModificationInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModificationResponse_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item, DRBsAdmittedList_ModificationResponse_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModificationResponse_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_ModificationResponse_MNterminated, DRBsAdmittedList_ModificationResponse_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModificationResponseInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsAdmittedList_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModificationResponse_MNterminated },
  { &hf_xnap_dRBsReleasedList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List },
  { &hf_xnap_dRBsNotAdmittedSetupModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModificationResponseInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModificationResponseInfo_MNterminated, PDUSessionResourceModificationResponseInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeRequiredInfo_SNterminated_sequence[] = {
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeRequiredInfo_SNterminated, PDUSessionResourceChangeRequiredInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeRequiredInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeRequiredInfo_MNterminated, PDUSessionResourceChangeRequiredInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceChangeConfirmInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceChangeConfirmInfo_MNterminated, PDUSessionResourceChangeConfirmInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item, QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated, QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DRBsToBeSetup_List_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPSNLength },
  { &hf_xnap_sn_UL_PDCP_UPTNLinfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsSetupMappedtoDRB_ModRqd_SNterminated },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item, DRBsToBeSetup_List_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeSetup_List_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeSetup_List_ModRqd_SNterminated, DRBsToBeSetup_List_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_qoSFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_mCGRequestedGBRQoSFlowInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_GBRQoSFlowInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item, QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated, QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_secondary_SN_UL_PDCP_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_uL_Configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ULConfiguration },
  { &hf_xnap_pdcpDuplicationConfiguration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDCPDuplicationConfiguration },
  { &hf_xnap_duplicationActivation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DuplicationActivation },
  { &hf_xnap_qoSFlowsMappedtoDRB_ModRqd_SNterminated_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsModifiedMappedtoDRB_ModRqd_SNterminated },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item, DRBsToBeModified_List_ModRqd_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_ModRqd_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_ModRqd_SNterminated, DRBsToBeModified_List_ModRqd_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModRqdInfo_SNterminated_sequence[] = {
  { &hf_xnap_dL_NG_U_TNLatNG_RAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_qoSFlowsToBeReleased_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlows_List_withCause },
  { &hf_xnap_dataforwardinginfofromSource, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataforwardingandOffloadingInfofromSource },
  { &hf_xnap_drbsToBeSetupList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeSetup_List_ModRqd_SNterminated },
  { &hf_xnap_drbsToBeModifiedList_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_ModRqd_SNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModRqdInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModRqdInfo_SNterminated, PDUSessionResourceModRqdInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModConfirm_SNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_mN_DL_CG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_secondary_MN_DL_CG_UP_TNLInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportParameters },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item, DRBsAdmittedList_ModConfirm_SNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsAdmittedList_ModConfirm_SNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsAdmittedList_ModConfirm_SNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated_Item },
};

static int
dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsAdmittedList_ModConfirm_SNterminated, DRBsAdmittedList_ModConfirm_SNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModConfirmInfo_SNterminated_sequence[] = {
  { &hf_xnap_uL_NG_U_TNLatUPF, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRBsAdmittedList_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsAdmittedList_ModConfirm_SNterminated },
  { &hf_xnap_dRBsNotAdmittedSetupModifyList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_dataforwardinginfoTarget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModConfirmInfo_SNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModConfirmInfo_SNterminated, PDUSessionResourceModConfirmInfo_SNterminated_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_MNterminated_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_sN_DL_SCG_UP_TNLInfo_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_secondary_SN_DL_SCG_UP_TNLInfo_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_lCID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_LCID },
  { &hf_xnap_rlc_status     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RLC_Status },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item, DRBsToBeModified_List_ModRqd_MNterminated_Item_sequence);

  return offset;
}


static const per_sequence_t DRBsToBeModified_List_ModRqd_MNterminated_sequence_of[1] = {
  { &hf_xnap_DRBsToBeModified_List_ModRqd_MNterminated_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated_Item },
};

static int
dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_DRBsToBeModified_List_ModRqd_MNterminated, DRBsToBeModified_List_ModRqd_MNterminated_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionResourceModRqdInfo_MNterminated_sequence[] = {
  { &hf_xnap_dRBsToBeModified_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRBsToBeModified_List_ModRqd_MNterminated },
  { &hf_xnap_dRBsToBeReleased, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_DRB_List_withCause },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModRqdInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModRqdInfo_MNterminated, PDUSessionResourceModRqdInfo_MNterminated_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceModConfirmInfo_MNterminated_sequence[] = {
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceModConfirmInfo_MNterminated(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceModConfirmInfo_MNterminated, PDUSessionResourceModConfirmInfo_MNterminated_sequence);

  return offset;
}


static const value_string xnap_T_rATType_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_xnap_T_rATType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}



static int
dissect_xnap_T_startTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_xnap_T_endTimeStamp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *timestamp_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       4, 4, FALSE, &timestamp_tvb);



  if (timestamp_tvb) {
    proto_item_append_text(actx->created_item, " (%s)", tvb_ntp_fmt_ts_sec(timestamp_tvb, 0));
  }

  return offset;
}



static int
dissect_xnap_INTEGER_0_18446744073709551615(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(18446744073709551615), NULL, FALSE);

  return offset;
}


static const per_sequence_t VolumeTimedReport_Item_sequence[] = {
  { &hf_xnap_startTimeStamp , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_startTimeStamp },
  { &hf_xnap_endTimeStamp   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_endTimeStamp },
  { &hf_xnap_usageCountUL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_18446744073709551615 },
  { &hf_xnap_usageCountDL   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_18446744073709551615 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_VolumeTimedReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_VolumeTimedReport_Item, VolumeTimedReport_Item_sequence);

  return offset;
}


static const per_sequence_t VolumeTimedReportList_sequence_of[1] = {
  { &hf_xnap_VolumeTimedReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReport_Item },
};

static int
dissect_xnap_VolumeTimedReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_VolumeTimedReportList, VolumeTimedReportList_sequence_of,
                                                  1, maxnooftimeperiods, FALSE);

  return offset;
}


static const per_sequence_t PDUSessionUsageReport_sequence[] = {
  { &hf_xnap_rATType        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rATType },
  { &hf_xnap_pDUSessionTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReportList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionUsageReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionUsageReport, PDUSessionUsageReport_sequence);

  return offset;
}


static const value_string xnap_T_rATType_01_vals[] = {
  {   0, "nr" },
  {   1, "eutra" },
  {   2, "nr-unlicensed" },
  {   3, "e-utra-unlicensed" },
  { 0, NULL }
};


static int
dissect_xnap_T_rATType_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 2, NULL);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReport_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_rATType_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rATType_01 },
  { &hf_xnap_qoSFlowsTimedReportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_VolumeTimedReportList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowsUsageReport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowsUsageReport_Item, QoSFlowsUsageReport_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowsUsageReportList_sequence_of[1] = {
  { &hf_xnap_QoSFlowsUsageReportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowsUsageReport_Item },
};

static int
dissect_xnap_QoSFlowsUsageReportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowsUsageReportList, QoSFlowsUsageReportList_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t SecondaryRATUsageInformation_sequence[] = {
  { &hf_xnap_pDUSessionUsageReport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_PDUSessionUsageReport },
  { &hf_xnap_qosFlowsUsageReportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QoSFlowsUsageReportList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecondaryRATUsageInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecondaryRATUsageInformation, SecondaryRATUsageInformation_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageItem_sequence[] = {
  { &hf_xnap_pDUSessionID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSession_ID },
  { &hf_xnap_secondaryRATUsageInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SecondaryRATUsageInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_PDUSessionResourceSecondaryRATUsageItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_PDUSessionResourceSecondaryRATUsageItem, PDUSessionResourceSecondaryRATUsageItem_sequence);

  return offset;
}


static const per_sequence_t PDUSessionResourceSecondaryRATUsageList_sequence_of[1] = {
  { &hf_xnap_PDUSessionResourceSecondaryRATUsageList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourceSecondaryRATUsageItem },
};

static int
dissect_xnap_PDUSessionResourceSecondaryRATUsageList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_PDUSessionResourceSecondaryRATUsageList, PDUSessionResourceSecondaryRATUsageList_sequence_of,
                                                  1, maxnoofPDUSessions, FALSE);

  return offset;
}



static int
dissect_xnap_PDUSessionCommonNetworkInstance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_PDUSession_PairID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}


static const value_string xnap_T_resourceType_vals[] = {
  {   0, "downlinknonCRS" },
  {   1, "cRS" },
  {   2, "uplink" },
  { 0, NULL }
};


static int
dissect_xnap_T_resourceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_84_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     84, 84, TRUE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_BIT_STRING_SIZE_6_110_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 110, TRUE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_1_320_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 320U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_INTEGER_1_20_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 20U, NULL, TRUE);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAFootprintTimePattern_sequence[] = {
  { &hf_xnap_protectedFootprintTimeperiodicity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_320_ },
  { &hf_xnap_protectedFootrpintStartTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_20_ },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAFootprintTimePattern(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAFootprintTimePattern, ProtectedE_UTRAFootprintTimePattern_sequence);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResource_Item_sequence[] = {
  { &hf_xnap_resourceType   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_resourceType },
  { &hf_xnap_intra_PRBProtectedResourceFootprint, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_84_ },
  { &hf_xnap_protectedFootprintFrequencyPattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_6_110_ },
  { &hf_xnap_protectedFootprintTimePattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAFootprintTimePattern },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAResource_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAResource_Item, ProtectedE_UTRAResource_Item_sequence);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResourceList_sequence_of[1] = {
  { &hf_xnap_ProtectedE_UTRAResourceList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAResource_Item },
};

static int
dissect_xnap_ProtectedE_UTRAResourceList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ProtectedE_UTRAResourceList, ProtectedE_UTRAResourceList_sequence_of,
                                                  1, maxnoofProtectedResourcePatterns, FALSE);

  return offset;
}



static int
dissect_xnap_INTEGER_1_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ProtectedE_UTRAResourceIndication_sequence[] = {
  { &hf_xnap_activationSFN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ActivationSFN },
  { &hf_xnap_protectedResourceList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtectedE_UTRAResourceList },
  { &hf_xnap_mbsfnControlRegionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBSFNControlRegionLength },
  { &hf_xnap_pDCCHRegionLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_1_3 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ProtectedE_UTRAResourceIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ProtectedE_UTRAResourceIndication, ProtectedE_UTRAResourceIndication_sequence);

  return offset;
}


static const value_string xnap_PrivacyIndicator_vals[] = {
  {   0, "immediate-MDT" },
  {   1, "logged-MDT" },
  { 0, NULL }
};


static int
dissect_xnap_PrivacyIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_PSCellChangeHistory_vals[] = {
  {   0, "reporting-full-history" },
  { 0, NULL }
};


static int
dissect_xnap_PSCellChangeHistory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_PSCellHistoryInformationRetrieve_vals[] = {
  {   0, "query" },
  { 0, NULL }
};


static int
dissect_xnap_PSCellHistoryInformationRetrieve(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_QOEReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, FALSE, NULL);

  return offset;
}



static int
dissect_xnap_QOEMeasConfAppLayerID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, TRUE);

  return offset;
}


static const value_string xnap_ServiceType_vals[] = {
  {   0, "qMC-for-streaming-service" },
  {   1, "qMC-for-MTSI-service" },
  {   2, "qMC-for-VR-service" },
  { 0, NULL }
};


static int
dissect_xnap_ServiceType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_QOEMeasStatus_vals[] = {
  {   0, "ongoing" },
  { 0, NULL }
};


static int
dissect_xnap_QOEMeasStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t S_NSSAIListQoE_sequence_of[1] = {
  { &hf_xnap_S_NSSAIListQoE_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
};

static int
dissect_xnap_S_NSSAIListQoE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_S_NSSAIListQoE, S_NSSAIListQoE_sequence_of,
                                                  1, maxnoofSNSSAIforQMC, FALSE);

  return offset;
}


static const per_sequence_t UEAppLayerMeasConfigInfo_sequence[] = {
  { &hf_xnap_qOEReference   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QOEReference },
  { &hf_xnap_qOEMeasConfigAppLayerID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasConfAppLayerID },
  { &hf_xnap_serviceType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServiceType },
  { &hf_xnap_qOEMeasStatus  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_QOEMeasStatus },
  { &hf_xnap_containerAppLayerMeasConfig, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ContainerAppLayerMeasConfig },
  { &hf_xnap_mDTAlignmentInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MDTAlignmentInfo },
  { &hf_xnap_measCollectionEntityIPAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MeasCollectionEntityIPAddress },
  { &hf_xnap_areaScopeOfQMC , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AreaScopeOfQMC },
  { &hf_xnap_s_NSSAIListQoE , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_S_NSSAIListQoE },
  { &hf_xnap_availableRVQoEMetrics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_AvailableRVQoEMetrics },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEAppLayerMeasConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEAppLayerMeasConfigInfo, UEAppLayerMeasConfigInfo_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfo_Item_sequence[] = {
  { &hf_xnap_uEAppLayerMeasConfigInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasConfigInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEAppLayerMeasInfo_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEAppLayerMeasInfo_Item, UEAppLayerMeasInfo_Item_sequence);

  return offset;
}


static const per_sequence_t UEAppLayerMeasInfoList_sequence_of[1] = {
  { &hf_xnap_UEAppLayerMeasInfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasInfo_Item },
};

static int
dissect_xnap_UEAppLayerMeasInfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UEAppLayerMeasInfoList, UEAppLayerMeasInfoList_sequence_of,
                                                  1, maxnoofUEAppLayerMeas, FALSE);

  return offset;
}


static const per_sequence_t QMCConfigInfo_sequence[] = {
  { &hf_xnap_uEAppLayerMeasInfoList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEAppLayerMeasInfoList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QMCConfigInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QMCConfigInfo, QMCConfigInfo_sequence);

  return offset;
}


static const value_string xnap_T_notificationInformation_vals[] = {
  {   0, "fulfilled" },
  {   1, "not-fulfilled" },
  { 0, NULL }
};


static int
dissect_xnap_T_notificationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t QoSFlowNotify_Item_sequence[] = {
  { &hf_xnap_qosFlowIdentifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowIdentifier },
  { &hf_xnap_notificationInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_notificationInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoSFlowNotify_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoSFlowNotify_Item, QoSFlowNotify_Item_sequence);

  return offset;
}


static const per_sequence_t QoSFlowNotificationControlIndicationInfo_sequence_of[1] = {
  { &hf_xnap_QoSFlowNotificationControlIndicationInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowNotify_Item },
};

static int
dissect_xnap_QoSFlowNotificationControlIndicationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_QoSFlowNotificationControlIndicationInfo, QoSFlowNotificationControlIndicationInfo_sequence_of,
                                                  1, maxnoofQoSFlows, FALSE);

  return offset;
}


static const per_sequence_t QoS_Mapping_Information_sequence[] = {
  { &hf_xnap_dscp           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_6 },
  { &hf_xnap_flow_label     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BIT_STRING_SIZE_20 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_QoS_Mapping_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_QoS_Mapping_Information, QoS_Mapping_Information_sequence);

  return offset;
}



static int
dissect_xnap_QoSParaSetNotifyIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}


static const value_string xnap_QosMonitoringRequest_vals[] = {
  {   0, "ul" },
  {   1, "dl" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_xnap_QosMonitoringRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string xnap_QoSMonitoringDisabled_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_QoSMonitoringDisabled(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_QosMonitoringReportingFrequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1800U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_RACHReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RACHReportContainer);
    dissect_nr_rrc_RA_ReportList_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t RACHReportList_Item_sequence[] = {
  { &hf_xnap_rACHReport     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RACHReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RACHReportList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RACHReportList_Item, RACHReportList_Item_sequence);

  return offset;
}


static const per_sequence_t RACHReportInformation_sequence_of[1] = {
  { &hf_xnap_RACHReportInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RACHReportList_Item },
};

static int
dissect_xnap_RACHReportInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_RACHReportInformation, RACHReportInformation_sequence_of,
                                                  1, maxnoofRACHReports, FALSE);

  return offset;
}


static const per_sequence_t RANAreaID_sequence[] = {
  { &hf_xnap_tAC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_rANAC          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RANAreaID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RANAreaID, RANAreaID_sequence);

  return offset;
}


static const per_sequence_t RANAreaID_List_sequence_of[1] = {
  { &hf_xnap_RANAreaID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RANAreaID },
};

static int
dissect_xnap_RANAreaID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_RANAreaID_List, RANAreaID_List_sequence_of,
                                                  1, maxnoofRANAreasinRNA, FALSE);

  return offset;
}


static const value_string xnap_RANPagingAreaChoice_vals[] = {
  {   0, "cell-List" },
  {   1, "rANAreaID-List" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t RANPagingAreaChoice_choice[] = {
  {   0, &hf_xnap_cell_List      , ASN1_NO_EXTENSIONS     , dissect_xnap_NG_RAN_Cell_Identity_ListinRANPagingArea },
  {   1, &hf_xnap_rANAreaID_List , ASN1_NO_EXTENSIONS     , dissect_xnap_RANAreaID_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_RANPagingAreaChoice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_RANPagingAreaChoice, RANPagingAreaChoice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RANPagingArea_sequence[] = {
  { &hf_xnap_pLMN_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_rANPagingAreaChoice, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RANPagingAreaChoice },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RANPagingArea(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RANPagingArea, RANPagingArea_sequence);

  return offset;
}


static const value_string xnap_RANPagingFailure_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_RANPagingFailure(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_Redcap_Bcast_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_RedundantQoSFlowIndicator_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_RedundantQoSFlowIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string xnap_RSN_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  { 0, NULL }
};


static int
dissect_xnap_RSN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RedundantPDUSessionInformation_sequence[] = {
  { &hf_xnap_rSN            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RSN },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RedundantPDUSessionInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RedundantPDUSessionInformation, RedundantPDUSessionInformation_sequence);

  return offset;
}


static const value_string xnap_ExtendedReportIntervalMDT_vals[] = {
  {   0, "ms20480" },
  {   1, "ms40960" },
  { 0, NULL }
};


static int
dissect_xnap_ExtendedReportIntervalMDT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_ReportCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, &parameter_tvb, NULL);

  if(parameter_tvb){
    static int * const fields[] = {
      &hf_xnap_ReportCharacteristics_PRBPeriodic,
      &hf_xnap_ReportCharacteristics_TNLCapacityIndPeriodic,
      &hf_xnap_ReportCharacteristics_CompositeAvailableCapacityPeriodic,
      &hf_xnap_ReportCharacteristics_NumberOfActiveUEs,
      &hf_xnap_ReportCharacteristics_Reserved,
      NULL
    };
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_ReportCharacteristics);
    proto_tree_add_bitmask_list(subtree, parameter_tvb, 0, 4, fields, ENC_BIG_ENDIAN);
  }


  return offset;
}


static const value_string xnap_ReportingPeriodicity_vals[] = {
  {   0, "half-thousand-ms" },
  {   1, "one-thousand-ms" },
  {   2, "two-thousand-ms" },
  {   3, "five-thousand-ms" },
  {   4, "ten-thousand-ms" },
  { 0, NULL }
};


static int
dissect_xnap_ReportingPeriodicity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_RegistrationRequest_vals[] = {
  {   0, "start" },
  {   1, "stop" },
  {   2, "add" },
  { 0, NULL }
};


static int
dissect_xnap_RegistrationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ResetRequestTypeInfo_Full_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetRequestTypeInfo_Full(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetRequestTypeInfo_Full, ResetRequestTypeInfo_Full_sequence);

  return offset;
}


static const per_sequence_t ResetRequestPartialReleaseItem_sequence[] = {
  { &hf_xnap_ng_ran_node1UEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_ng_ran_node2UEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetRequestPartialReleaseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetRequestPartialReleaseItem, ResetRequestPartialReleaseItem_sequence);

  return offset;
}


static const per_sequence_t ResetRequestPartialReleaseList_sequence_of[1] = {
  { &hf_xnap_ResetRequestPartialReleaseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ResetRequestPartialReleaseItem },
};

static int
dissect_xnap_ResetRequestPartialReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ResetRequestPartialReleaseList, ResetRequestPartialReleaseList_sequence_of,
                                                  1, maxnoofUEContexts, FALSE);

  return offset;
}


static const per_sequence_t ResetRequestTypeInfo_Partial_sequence[] = {
  { &hf_xnap_ue_contexts_ToBeReleasedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ResetRequestPartialReleaseList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetRequestTypeInfo_Partial(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetRequestTypeInfo_Partial, ResetRequestTypeInfo_Partial_sequence);

  return offset;
}


static const value_string xnap_ResetRequestTypeInfo_vals[] = {
  {   0, "fullReset" },
  {   1, "partialReset" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResetRequestTypeInfo_choice[] = {
  {   0, &hf_xnap_fullReset      , ASN1_NO_EXTENSIONS     , dissect_xnap_ResetRequestTypeInfo_Full },
  {   1, &hf_xnap_partialReset   , ASN1_NO_EXTENSIONS     , dissect_xnap_ResetRequestTypeInfo_Partial },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ResetRequestTypeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ResetRequestTypeInfo, ResetRequestTypeInfo_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ResetResponseTypeInfo_Full_sequence[] = {
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetResponseTypeInfo_Full(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetResponseTypeInfo_Full, ResetResponseTypeInfo_Full_sequence);

  return offset;
}


static const per_sequence_t ResetResponsePartialReleaseItem_sequence[] = {
  { &hf_xnap_ng_ran_node1UEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_ng_ran_node2UEXnAPID, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NG_RANnodeUEXnAPID },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetResponsePartialReleaseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetResponsePartialReleaseItem, ResetResponsePartialReleaseItem_sequence);

  return offset;
}


static const per_sequence_t ResetResponsePartialReleaseList_sequence_of[1] = {
  { &hf_xnap_ResetResponsePartialReleaseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ResetResponsePartialReleaseItem },
};

static int
dissect_xnap_ResetResponsePartialReleaseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ResetResponsePartialReleaseList, ResetResponsePartialReleaseList_sequence_of,
                                                  1, maxnoofUEContexts, FALSE);

  return offset;
}


static const per_sequence_t ResetResponseTypeInfo_Partial_sequence[] = {
  { &hf_xnap_ue_contexts_AdmittedToBeReleasedList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ResetResponsePartialReleaseList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ResetResponseTypeInfo_Partial(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ResetResponseTypeInfo_Partial, ResetResponseTypeInfo_Partial_sequence);

  return offset;
}


static const value_string xnap_ResetResponseTypeInfo_vals[] = {
  {   0, "fullReset" },
  {   1, "partialReset" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ResetResponseTypeInfo_choice[] = {
  {   0, &hf_xnap_fullReset_01   , ASN1_NO_EXTENSIONS     , dissect_xnap_ResetResponseTypeInfo_Full },
  {   1, &hf_xnap_partialReset_01, ASN1_NO_EXTENSIONS     , dissect_xnap_ResetResponseTypeInfo_Partial },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ResetResponseTypeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ResetResponseTypeInfo, ResetResponseTypeInfo_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_duplicationState_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_xnap_T_duplicationState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RLCDuplicationState_Item_sequence[] = {
  { &hf_xnap_duplicationState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_duplicationState },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RLCDuplicationState_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RLCDuplicationState_Item, RLCDuplicationState_Item_sequence);

  return offset;
}


static const per_sequence_t RLCDuplicationStateList_sequence_of[1] = {
  { &hf_xnap_RLCDuplicationStateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RLCDuplicationState_Item },
};

static int
dissect_xnap_RLCDuplicationStateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_RLCDuplicationStateList, RLCDuplicationStateList_sequence_of,
                                                  1, maxnoofRLCDuplicationstate, FALSE);

  return offset;
}


static const value_string xnap_T_rLC_PrimaryIndicator_vals[] = {
  {   0, "true" },
  {   1, "false" },
  { 0, NULL }
};


static int
dissect_xnap_T_rLC_PrimaryIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t RLCDuplicationInformation_sequence[] = {
  { &hf_xnap_rLCDuplicationStateList, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_RLCDuplicationStateList },
  { &hf_xnap_rLC_PrimaryIndicator, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_T_rLC_PrimaryIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_RLCDuplicationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_RLCDuplicationInformation, RLCDuplicationInformation_sequence);

  return offset;
}



static int
dissect_xnap_RFSP_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}


static const value_string xnap_RRCConfigIndication_vals[] = {
  {   0, "full-config" },
  {   1, "delta-config" },
  { 0, NULL }
};


static int
dissect_xnap_RRCConfigIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_RRCConnReestab_Indicator_vals[] = {
  {   0, "reconfigurationFailure" },
  {   1, "handoverFailure" },
  {   2, "otherFailure" },
  { 0, NULL }
};


static int
dissect_xnap_RRCConnReestab_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_RRCResumeCause_vals[] = {
  {   0, "rna-Update" },
  { 0, NULL }
};


static int
dissect_xnap_RRCResumeCause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SCGreconfigNotification_vals[] = {
  {   0, "executed" },
  {   1, "executed-deleted" },
  {   2, "deleted" },
  { 0, NULL }
};


static int
dissect_xnap_SCGreconfigNotification(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 2, NULL);

  return offset;
}


static const per_sequence_t SecondarydataForwardingInfoFromTarget_Item_sequence[] = {
  { &hf_xnap_secondarydataForwardingInfoFromTarget, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DataForwardingInfoFromTargetNGRANnode },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SecondarydataForwardingInfoFromTarget_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SecondarydataForwardingInfoFromTarget_Item, SecondarydataForwardingInfoFromTarget_Item_sequence);

  return offset;
}


static const per_sequence_t SecondarydataForwardingInfoFromTarget_List_sequence_of[1] = {
  { &hf_xnap_SecondarydataForwardingInfoFromTarget_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SecondarydataForwardingInfoFromTarget_Item },
};

static int
dissect_xnap_SecondarydataForwardingInfoFromTarget_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SecondarydataForwardingInfoFromTarget_List, SecondarydataForwardingInfoFromTarget_List_sequence_of,
                                                  1, maxnoofMultiConnectivityMinusOne, FALSE);

  return offset;
}


static const value_string xnap_SCGActivationRequest_vals[] = {
  {   0, "activate-scg" },
  {   1, "deactivate-scg" },
  { 0, NULL }
};


static int
dissect_xnap_SCGActivationRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SCGActivationStatus_vals[] = {
  {   0, "scg-activated" },
  {   1, "scg-deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_SCGActivationStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SCGConfigurationQuery_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_SCGConfigurationQuery(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SCGIndicator_vals[] = {
  {   0, "released" },
  { 0, NULL }
};


static int
dissect_xnap_SCGIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_SCGFailureReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const value_string xnap_SDTIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_SDTIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SDTAssistantInfo_vals[] = {
  {   0, "single-packet" },
  {   1, "multiple-packets" },
  { 0, NULL }
};


static int
dissect_xnap_SDTAssistantInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SDTSupportRequest_sequence[] = {
  { &hf_xnap_sdtindicator   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SDTIndicator },
  { &hf_xnap_sdtAssistantInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SDTAssistantInfo },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SDTSupportRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SDTSupportRequest, SDTSupportRequest_sequence);

  return offset;
}


static const value_string xnap_SDT_Termination_Request_vals[] = {
  {   0, "radio-link-problem" },
  {   1, "normal" },
  { 0, NULL }
};


static int
dissect_xnap_SDT_Termination_Request(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_T_dRB_RLC_Bearer_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RLC_Bearer_Configuration);
    dissect_nr_rrc_RLC_BearerConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SDT_DRBsToBeSetupList_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_uL_TNLInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_dRB_RLC_Bearer_Configuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_dRB_RLC_Bearer_Configuration },
  { &hf_xnap_dRB_QoS        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_QoSFlowLevelQoSParameters },
  { &hf_xnap_rLC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_RLCMode },
  { &hf_xnap_s_nssai        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_pDCP_SNLength  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDCPSNLength },
  { &hf_xnap_flows_Mapped_To_DRB_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Flows_Mapped_To_DRB_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SDT_DRBsToBeSetupList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SDT_DRBsToBeSetupList_Item, SDT_DRBsToBeSetupList_Item_sequence);

  return offset;
}


static const per_sequence_t SDT_DRBsToBeSetupList_sequence_of[1] = {
  { &hf_xnap_SDT_DRBsToBeSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SDT_DRBsToBeSetupList_Item },
};

static int
dissect_xnap_SDT_DRBsToBeSetupList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SDT_DRBsToBeSetupList, SDT_DRBsToBeSetupList_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}



static int
dissect_xnap_SRB_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_T_sRB_RLC_Bearer_Configuration(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RLC_Bearer_Configuration);
    dissect_nr_rrc_RLC_BearerConfig_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SDT_SRBsToBeSetupList_Item_sequence[] = {
  { &hf_xnap_srb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SRB_ID },
  { &hf_xnap_sRB_RLC_Bearer_Configuration, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_sRB_RLC_Bearer_Configuration },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SDT_SRBsToBeSetupList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SDT_SRBsToBeSetupList_Item, SDT_SRBsToBeSetupList_Item_sequence);

  return offset;
}


static const per_sequence_t SDT_SRBsToBeSetupList_sequence_of[1] = {
  { &hf_xnap_SDT_SRBsToBeSetupList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SDT_SRBsToBeSetupList_Item },
};

static int
dissect_xnap_SDT_SRBsToBeSetupList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SDT_SRBsToBeSetupList, SDT_SRBsToBeSetupList_sequence_of,
                                                  1, maxnoofSRBs, FALSE);

  return offset;
}


static const per_sequence_t SDTPartialUEContextInfo_sequence[] = {
  { &hf_xnap_dRBsToBeSetup_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SDT_DRBsToBeSetupList },
  { &hf_xnap_sRBsToBeSetup  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SDT_SRBsToBeSetupList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SDTPartialUEContextInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SDTPartialUEContextInfo, SDTPartialUEContextInfo_sequence);

  return offset;
}


static const per_sequence_t SDTDataForwardingDRBList_Item_sequence[] = {
  { &hf_xnap_drb_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_DRB_ID },
  { &hf_xnap_dL_TNLInfo     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SDTDataForwardingDRBList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SDTDataForwardingDRBList_Item, SDTDataForwardingDRBList_Item_sequence);

  return offset;
}


static const per_sequence_t SDTDataForwardingDRBList_sequence_of[1] = {
  { &hf_xnap_SDTDataForwardingDRBList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SDTDataForwardingDRBList_Item },
};

static int
dissect_xnap_SDTDataForwardingDRBList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SDTDataForwardingDRBList, SDTDataForwardingDRBList_sequence_of,
                                                  1, maxnoofDRBs, FALSE);

  return offset;
}


static const per_sequence_t ServedCellInformation_E_UTRA_perBPLMN_sequence[] = {
  { &hf_xnap_plmn_id        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_E_UTRA_perBPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellInformation_E_UTRA_perBPLMN, ServedCellInformation_E_UTRA_perBPLMN_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN_sequence_of[1] = {
  { &hf_xnap_broadcastPLMNs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_E_UTRA_perBPLMN },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN, SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}


static const per_sequence_t ServedCellInformation_E_UTRA_FDDInfo_sequence[] = {
  { &hf_xnap_ul_earfcn      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAARFCN },
  { &hf_xnap_dl_earfcn      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAARFCN },
  { &hf_xnap_ul_e_utraTxBW  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRATransmissionBandwidth },
  { &hf_xnap_dl_e_utraTxBW  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRATransmissionBandwidth },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_E_UTRA_FDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellInformation_E_UTRA_FDDInfo, ServedCellInformation_E_UTRA_FDDInfo_sequence);

  return offset;
}


static const value_string xnap_T_subframeAssignmnet_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_xnap_T_subframeAssignmnet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SpecialSubframePatterns_E_UTRA_vals[] = {
  {   0, "ssp0" },
  {   1, "ssp1" },
  {   2, "ssp2" },
  {   3, "ssp3" },
  {   4, "ssp4" },
  {   5, "ssp5" },
  {   6, "ssp6" },
  {   7, "ssp7" },
  {   8, "ssp8" },
  {   9, "ssp9" },
  {  10, "ssp10" },
  { 0, NULL }
};


static int
dissect_xnap_SpecialSubframePatterns_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SpecialSubframeInfo_E_UTRA_sequence[] = {
  { &hf_xnap_specialSubframePattern, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SpecialSubframePatterns_E_UTRA },
  { &hf_xnap_cyclicPrefixDL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CyclicPrefix_E_UTRA_DL },
  { &hf_xnap_cyclicPrefixUL , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CyclicPrefix_E_UTRA_UL },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SpecialSubframeInfo_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SpecialSubframeInfo_E_UTRA, SpecialSubframeInfo_E_UTRA_sequence);

  return offset;
}


static const per_sequence_t ServedCellInformation_E_UTRA_TDDInfo_sequence[] = {
  { &hf_xnap_earfcn         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAARFCN },
  { &hf_xnap_e_utraTxBW     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRATransmissionBandwidth },
  { &hf_xnap_subframeAssignmnet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_subframeAssignmnet },
  { &hf_xnap_specialSubframeInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SpecialSubframeInfo_E_UTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_E_UTRA_TDDInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellInformation_E_UTRA_TDDInfo, ServedCellInformation_E_UTRA_TDDInfo_sequence);

  return offset;
}


static const value_string xnap_ServedCellInformation_E_UTRA_ModeInfo_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t ServedCellInformation_E_UTRA_ModeInfo_choice[] = {
  {   0, &hf_xnap_fdd_02         , ASN1_NO_EXTENSIONS     , dissect_xnap_ServedCellInformation_E_UTRA_FDDInfo },
  {   1, &hf_xnap_tdd_02         , ASN1_NO_EXTENSIONS     , dissect_xnap_ServedCellInformation_E_UTRA_TDDInfo },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_E_UTRA_ModeInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_ServedCellInformation_E_UTRA_ModeInfo, ServedCellInformation_E_UTRA_ModeInfo_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_T_freqBandIndicatorPriority_vals[] = {
  {   0, "not-broadcast" },
  {   1, "broadcast" },
  { 0, NULL }
};


static int
dissect_xnap_T_freqBandIndicatorPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_T_bandwidthReducedSI_vals[] = {
  {   0, "scheduled" },
  { 0, NULL }
};


static int
dissect_xnap_T_bandwidthReducedSI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ServedCellInformation_E_UTRA_sequence[] = {
  { &hf_xnap_e_utra_pci     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRAPCI },
  { &hf_xnap_e_utra_cgi     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_broadcastPLMNs_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofBPLMNs_OF_ServedCellInformation_E_UTRA_perBPLMN },
  { &hf_xnap_e_utra_mode_info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_E_UTRA_ModeInfo },
  { &hf_xnap_numberofAntennaPorts, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NumberOfAntennaPorts_E_UTRA },
  { &hf_xnap_prach_configuration, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRAPRACHConfiguration },
  { &hf_xnap_mBSFNsubframeInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MBSFNSubframeInfo_E_UTRA },
  { &hf_xnap_multibandInfo  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_E_UTRAMultibandInfoList },
  { &hf_xnap_freqBandIndicatorPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_freqBandIndicatorPriority },
  { &hf_xnap_bandwidthReducedSI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_bandwidthReducedSI },
  { &hf_xnap_protectedE_UTRAResourceIndication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtectedE_UTRAResourceIndication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellInformation_E_UTRA, ServedCellInformation_E_UTRA_sequence);

  return offset;
}


static const per_sequence_t ServedCells_E_UTRA_Item_sequence[] = {
  { &hf_xnap_served_cell_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_E_UTRA },
  { &hf_xnap_neighbour_info_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_NR },
  { &hf_xnap_neighbour_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_E_UTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCells_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCells_E_UTRA_Item, ServedCells_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCells_E_UTRA_sequence_of[1] = {
  { &hf_xnap_ServedCells_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCells_E_UTRA_Item },
};

static int
dissect_xnap_ServedCells_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServedCells_E_UTRA, ServedCells_E_UTRA_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_T_deactivation_indication_vals[] = {
  {   0, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_T_deactivation_indication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ServedCells_ToModify_E_UTRA_Item_sequence[] = {
  { &hf_xnap_old_ECGI       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_E_UTRA_CGI },
  { &hf_xnap_served_cell_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_E_UTRA },
  { &hf_xnap_neighbour_info_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_NR },
  { &hf_xnap_neighbour_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_E_UTRA },
  { &hf_xnap_deactivation_indication, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_deactivation_indication },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCells_ToModify_E_UTRA_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCells_ToModify_E_UTRA_Item, ServedCells_ToModify_E_UTRA_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCells_ToModify_E_UTRA_sequence_of[1] = {
  { &hf_xnap_ServedCells_ToModify_E_UTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCells_ToModify_E_UTRA_Item },
};

static int
dissect_xnap_ServedCells_ToModify_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServedCells_ToModify_E_UTRA, ServedCells_ToModify_E_UTRA_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const per_sequence_t ServedCellsToUpdate_E_UTRA_sequence[] = {
  { &hf_xnap_served_Cells_ToAdd_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServedCells_E_UTRA },
  { &hf_xnap_served_Cells_ToModify_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServedCells_ToModify_E_UTRA },
  { &hf_xnap_served_Cells_ToDelete_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_E_UTRA_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellsToUpdate_E_UTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellsToUpdate_E_UTRA, ServedCellsToUpdate_E_UTRA_sequence);

  return offset;
}



static int
dissect_xnap_T_measurementTimingConfiguration_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_measurementTimingConfiguration);
    dissect_nr_rrc_MeasurementTimingConfiguration_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t ServedCellInformation_NR_sequence[] = {
  { &hf_xnap_nrPCI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRPCI },
  { &hf_xnap_cellID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_ranac          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RANAC },
  { &hf_xnap_broadcastPLMN  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPLMNs },
  { &hf_xnap_nrModeInfo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NRModeInfo },
  { &hf_xnap_measurementTimingConfiguration_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_measurementTimingConfiguration_01 },
  { &hf_xnap_connectivitySupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Connectivity_Support },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellInformation_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellInformation_NR, ServedCellInformation_NR_sequence);

  return offset;
}


static const per_sequence_t SFN_Offset_sequence[] = {
  { &hf_xnap_sFN_Time_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BIT_STRING_SIZE_24 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SFN_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SFN_Offset, SFN_Offset_sequence);

  return offset;
}


static const per_sequence_t ServedCells_NR_Item_sequence[] = {
  { &hf_xnap_served_cell_info_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_NR },
  { &hf_xnap_neighbour_info_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_NR },
  { &hf_xnap_neighbour_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_E_UTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCells_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCells_NR_Item, ServedCells_NR_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCells_NR_sequence_of[1] = {
  { &hf_xnap_ServedCells_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCells_NR_Item },
};

static int
dissect_xnap_ServedCells_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServedCells_NR, ServedCells_NR_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_T_deactivation_indication_01_vals[] = {
  {   0, "deactivated" },
  { 0, NULL }
};


static int
dissect_xnap_T_deactivation_indication_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ServedCells_ToModify_NR_Item_sequence[] = {
  { &hf_xnap_old_NR_CGI     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_served_cell_info_NR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellInformation_NR },
  { &hf_xnap_neighbour_info_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_NR },
  { &hf_xnap_neighbour_info_E_UTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_NeighbourInformation_E_UTRA },
  { &hf_xnap_deactivation_indication_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_deactivation_indication_01 },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCells_ToModify_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCells_ToModify_NR_Item, ServedCells_ToModify_NR_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCells_ToModify_NR_sequence_of[1] = {
  { &hf_xnap_ServedCells_ToModify_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCells_ToModify_NR_Item },
};

static int
dissect_xnap_ServedCells_ToModify_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServedCells_ToModify_NR, ServedCells_ToModify_NR_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const value_string xnap_T_additionalMTCListRequestIndicator_vals[] = {
  {   0, "additionalMTCListRequested" },
  { 0, NULL }
};


static int
dissect_xnap_T_additionalMTCListRequestIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ServedCellSpecificInfoReq_NR_Item_sequence[] = {
  { &hf_xnap_nRCGI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NR_CGI },
  { &hf_xnap_additionalMTCListRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_additionalMTCListRequestIndicator },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellSpecificInfoReq_NR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellSpecificInfoReq_NR_Item, ServedCellSpecificInfoReq_NR_Item_sequence);

  return offset;
}


static const per_sequence_t ServedCellSpecificInfoReq_NR_sequence_of[1] = {
  { &hf_xnap_ServedCellSpecificInfoReq_NR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_ServedCellSpecificInfoReq_NR_Item },
};

static int
dissect_xnap_ServedCellSpecificInfoReq_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_ServedCellSpecificInfoReq_NR, ServedCellSpecificInfoReq_NR_sequence_of,
                                                  1, maxnoofCellsinNG_RANnode, FALSE);

  return offset;
}


static const per_sequence_t ServedCellsToUpdate_NR_sequence[] = {
  { &hf_xnap_served_Cells_ToAdd_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServedCells_NR },
  { &hf_xnap_served_Cells_ToModify_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ServedCells_ToModify_NR },
  { &hf_xnap_served_Cells_ToDelete_NR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SEQUENCE_SIZE_1_maxnoofCellsinNG_RANnode_OF_NR_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_ServedCellsToUpdate_NR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_ServedCellsToUpdate_NR, ServedCellsToUpdate_NR_sequence);

  return offset;
}



static int
dissect_xnap_Slice_DL_GBR_PRB_Usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Slice_UL_GBR_PRB_Usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Slice_DL_non_GBR_PRB_Usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Slice_UL_non_GBR_PRB_Usage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Slice_DL_Total_PRB_Allocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_xnap_Slice_UL_Total_PRB_Allocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SNSSAIRadioResourceStatus_Item_sequence[] = {
  { &hf_xnap_sNSSAI         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_slice_DL_GBR_PRB_Usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_DL_GBR_PRB_Usage },
  { &hf_xnap_slice_UL_GBR_PRB_Usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_UL_GBR_PRB_Usage },
  { &hf_xnap_slice_DL_non_GBR_PRB_Usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_DL_non_GBR_PRB_Usage },
  { &hf_xnap_slice_UL_non_GBR_PRB_Usage, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_UL_non_GBR_PRB_Usage },
  { &hf_xnap_slice_DL_Total_PRB_Allocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_DL_Total_PRB_Allocation },
  { &hf_xnap_slice_UL_Total_PRB_Allocation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Slice_UL_Total_PRB_Allocation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SNSSAIRadioResourceStatus_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SNSSAIRadioResourceStatus_Item, SNSSAIRadioResourceStatus_Item_sequence);

  return offset;
}


static const per_sequence_t SNSSAIRadioResourceStatus_List_sequence_of[1] = {
  { &hf_xnap_SNSSAIRadioResourceStatus_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIRadioResourceStatus_Item },
};

static int
dissect_xnap_SNSSAIRadioResourceStatus_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SNSSAIRadioResourceStatus_List, SNSSAIRadioResourceStatus_List_sequence_of,
                                                  1, maxnoofSliceItems, FALSE);

  return offset;
}


static const per_sequence_t SliceRadioResourceStatus_Item_sequence[] = {
  { &hf_xnap_plmn_Identity  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PLMN_Identity },
  { &hf_xnap_sNSSAIRadioResourceStatus_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SNSSAIRadioResourceStatus_List },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SliceRadioResourceStatus_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SliceRadioResourceStatus_Item, SliceRadioResourceStatus_Item_sequence);

  return offset;
}


static const per_sequence_t SliceRadioResourceStatus_List_sequence_of[1] = {
  { &hf_xnap_SliceRadioResourceStatus_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SliceRadioResourceStatus_Item },
};

static int
dissect_xnap_SliceRadioResourceStatus_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SliceRadioResourceStatus_List, SliceRadioResourceStatus_List_sequence_of,
                                                  1, maxnoofBPLMNs, FALSE);

  return offset;
}



static int
dissect_xnap_S_NG_RANnode_SecurityKey(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_S_NG_RANnode_Addition_Trigger_Ind_vals[] = {
  {   0, "sn-change" },
  {   1, "inter-MN-HO" },
  {   2, "intra-MN-HO" },
  { 0, NULL }
};


static int
dissect_xnap_S_NG_RANnode_Addition_Trigger_Ind(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_SNMobilityInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string xnap_SNTriggered_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_SNTriggered(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_SpectrumSharingGroupID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxnoofCellsinNG_RANnode, NULL, FALSE);

  return offset;
}


static const value_string xnap_SplitSessionIndicator_vals[] = {
  {   0, "split" },
  { 0, NULL }
};


static int
dissect_xnap_SplitSessionIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SplitSRBsTypes_vals[] = {
  {   0, "srb1" },
  {   1, "srb2" },
  {   2, "srb1and2" },
  { 0, NULL }
};


static int
dissect_xnap_SplitSRBsTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_SSB_PositionsInBurst_vals[] = {
  {   0, "shortBitmap" },
  {   1, "mediumBitmap" },
  {   2, "longBitmap" },
  {   3, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t SSB_PositionsInBurst_choice[] = {
  {   0, &hf_xnap_shortBitmap    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_4 },
  {   1, &hf_xnap_mediumBitmap   , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_8 },
  {   2, &hf_xnap_longBitmap     , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_64 },
  {   3, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_SSB_PositionsInBurst(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_SSB_PositionsInBurst, SSB_PositionsInBurst_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SSBOffsetInformation_sequence[] = {
  { &hf_xnap_sSBIndex       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_63 },
  { &hf_xnap_sSBTriggeringOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_MobilityParametersInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBOffsetInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBOffsetInformation, SSBOffsetInformation_sequence);

  return offset;
}


static const per_sequence_t SSBOffsets_Item_sequence[] = {
  { &hf_xnap_nG_RANnode1SSBOffsets, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_SSBOffsetInformation },
  { &hf_xnap_nG_RANnode2ProposedSSBOffsets, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SSBOffsetInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SSBOffsets_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SSBOffsets_Item, SSBOffsets_Item_sequence);

  return offset;
}


static const per_sequence_t SSBOffsets_List_sequence_of[1] = {
  { &hf_xnap_SSBOffsets_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SSBOffsets_Item },
};

static int
dissect_xnap_SSBOffsets_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SSBOffsets_List, SSBOffsets_List_sequence_of,
                                                  1, maxnoofSSBAreas, FALSE);

  return offset;
}



static int
dissect_xnap_SuccessfulHOReportContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &param_tvb);

  if (param_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_SuccessfulHOReportContainer);
    dissect_nr_rrc_SuccessHO_Report_r17_PDU(param_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t SuccessfulHOReportList_Item_sequence[] = {
  { &hf_xnap_successfulHOReport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SuccessfulHOReportContainer },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_SuccessfulHOReportList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_SuccessfulHOReportList_Item, SuccessfulHOReportList_Item_sequence);

  return offset;
}


static const per_sequence_t SuccessfulHOReportInformation_sequence_of[1] = {
  { &hf_xnap_SuccessfulHOReportInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_SuccessfulHOReportList_Item },
};

static int
dissect_xnap_SuccessfulHOReportInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SuccessfulHOReportInformation, SuccessfulHOReportInformation_sequence_of,
                                                  1, maxnoofSuccessfulHOReports, FALSE);

  return offset;
}


static const per_sequence_t Supported_MBS_FSA_ID_List_sequence_of[1] = {
  { &hf_xnap_Supported_MBS_FSA_ID_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_MBS_FrequencySelectionArea_Identity },
};

static int
dissect_xnap_Supported_MBS_FSA_ID_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_Supported_MBS_FSA_ID_List, Supported_MBS_FSA_ID_List_sequence_of,
                                                  1, maxnoofMBSFSAs, FALSE);

  return offset;
}



static int
dissect_xnap_SurvivalTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1920000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t TAINSAGSupportItem_sequence[] = {
  { &hf_xnap_nSAG_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NSAG_ID },
  { &hf_xnap_nSAGSliceSupportList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ExtendedSliceSupportList },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAINSAGSupportItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAINSAGSupportItem, TAINSAGSupportItem_sequence);

  return offset;
}


static const per_sequence_t TAINSAGSupportList_sequence_of[1] = {
  { &hf_xnap_TAINSAGSupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAINSAGSupportItem },
};

static int
dissect_xnap_TAINSAGSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAINSAGSupportList, TAINSAGSupportList_sequence_of,
                                                  1, maxnoofNSAGs, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item_sequence_of[1] = {
  { &hf_xnap_broadcastPLMNs_item_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_BroadcastPLMNinTAISupport_Item },
};

static int
dissect_xnap_SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item, SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item_sequence_of,
                                                  1, maxnoofsupportedPLMNs, FALSE);

  return offset;
}


static const per_sequence_t TAISupport_Item_sequence[] = {
  { &hf_xnap_tac            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TAC },
  { &hf_xnap_broadcastPLMNs_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_SEQUENCE_SIZE_1_maxnoofsupportedPLMNs_OF_BroadcastPLMNinTAISupport_Item },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TAISupport_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TAISupport_Item, TAISupport_Item_sequence);

  return offset;
}


static const per_sequence_t TAISupport_List_sequence_of[1] = {
  { &hf_xnap_TAISupport_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TAISupport_Item },
};

static int
dissect_xnap_TAISupport_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TAISupport_List, TAISupport_List_sequence_of,
                                                  1, maxnoofsupportedTACs, FALSE);

  return offset;
}



static int
dissect_xnap_TargetCellinEUTRAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_TargetCellinEUTRAN);
    dissect_s1ap_EUTRAN_CGI_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_TDDULDLConfigurationCommonNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_TDDULDLConfigurationCommonNR);
    dissect_nr_rrc_TDD_UL_DL_ConfigCommon_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t TargetCellList_Item_sequence[] = {
  { &hf_xnap_target_cell    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Target_CGI },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TargetCellList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TargetCellList_Item, TargetCellList_Item_sequence);

  return offset;
}


static const per_sequence_t TargetCellList_sequence_of[1] = {
  { &hf_xnap_TargetCellList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TargetCellList_Item },
};

static int
dissect_xnap_TargetCellList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TargetCellList, TargetCellList_sequence_of,
                                                  1, maxnoofCHOcells, FALSE);

  return offset;
}


static const value_string xnap_T_timeDistributionIndication_vals[] = {
  {   0, "enabled" },
  {   1, "disabled" },
  { 0, NULL }
};


static int
dissect_xnap_T_timeDistributionIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_INTEGER_0_1000000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1000000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t TimeSynchronizationAssistanceInformation_sequence[] = {
  { &hf_xnap_timeDistributionIndication, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_timeDistributionIndication },
  { &hf_xnap_uuTimeSynchronizationErrorBudget, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_INTEGER_0_1000000_ },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TimeSynchronizationAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TimeSynchronizationAssistanceInformation, TimeSynchronizationAssistanceInformation_sequence);

  return offset;
}


static const value_string xnap_TimeToWait_vals[] = {
  {   0, "v1s" },
  {   1, "v2s" },
  {   2, "v5s" },
  {   3, "v10s" },
  {   4, "v20s" },
  {   5, "v60s" },
  { 0, NULL }
};


static int
dissect_xnap_TimeToWait(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TNLConfigurationInfo_sequence[] = {
  { &hf_xnap_extendedUPTransportLayerAddressesToAdd, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExtTLAs },
  { &hf_xnap_extendedUPTransportLayerAddressesToRemove, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ExtTLAs },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLConfigurationInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLConfigurationInfo, TNLConfigurationInfo_sequence);

  return offset;
}


static const value_string xnap_TNLAssociationUsage_vals[] = {
  {   0, "ue" },
  {   1, "non-ue" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_xnap_TNLAssociationUsage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TNLA_To_Add_Item_sequence[] = {
  { &hf_xnap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLAssociationUsage },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLA_To_Add_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLA_To_Add_Item, TNLA_To_Add_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Add_List_sequence_of[1] = {
  { &hf_xnap_TNLA_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLA_To_Add_Item },
};

static int
dissect_xnap_TNLA_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TNLA_To_Add_List, TNLA_To_Add_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_To_Update_Item_sequence[] = {
  { &hf_xnap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_tNLAssociationUsage, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_TNLAssociationUsage },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLA_To_Update_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLA_To_Update_Item, TNLA_To_Update_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Update_List_sequence_of[1] = {
  { &hf_xnap_TNLA_To_Update_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLA_To_Update_Item },
};

static int
dissect_xnap_TNLA_To_Update_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TNLA_To_Update_List, TNLA_To_Update_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_To_Remove_Item_sequence[] = {
  { &hf_xnap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLA_To_Remove_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLA_To_Remove_Item, TNLA_To_Remove_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_To_Remove_List_sequence_of[1] = {
  { &hf_xnap_TNLA_To_Remove_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLA_To_Remove_Item },
};

static int
dissect_xnap_TNLA_To_Remove_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TNLA_To_Remove_List, TNLA_To_Remove_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_Setup_Item_sequence[] = {
  { &hf_xnap_tNLAssociationTransportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLA_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLA_Setup_Item, TNLA_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_Setup_List_sequence_of[1] = {
  { &hf_xnap_TNLA_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLA_Setup_Item },
};

static int
dissect_xnap_TNLA_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TNLA_Setup_List, TNLA_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static const per_sequence_t TNLA_Failed_To_Setup_Item_sequence[] = {
  { &hf_xnap_tNLAssociationTransportLayerAddress, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_cause          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_Cause },
  { &hf_xnap_iE_Extensions  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TNLA_Failed_To_Setup_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TNLA_Failed_To_Setup_Item, TNLA_Failed_To_Setup_Item_sequence);

  return offset;
}


static const per_sequence_t TNLA_Failed_To_Setup_List_sequence_of[1] = {
  { &hf_xnap_TNLA_Failed_To_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TNLA_Failed_To_Setup_Item },
};

static int
dissect_xnap_TNLA_Failed_To_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TNLA_Failed_To_Setup_List, TNLA_Failed_To_Setup_List_sequence_of,
                                                  1, maxnoofTNLAssociations, FALSE);

  return offset;
}


static int * const T_interfaces_to_trace_bits[] = {
  &hf_xnap_T_interfaces_to_trace_ng_c,
  &hf_xnap_T_interfaces_to_trace_x_nc,
  &hf_xnap_T_interfaces_to_trace_uu,
  &hf_xnap_T_interfaces_to_trace_f1_c,
  &hf_xnap_T_interfaces_to_trace_e1,
  NULL
};

static int
dissect_xnap_T_interfaces_to_trace(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, T_interfaces_to_trace_bits, 5, NULL, NULL);

  return offset;
}


static const value_string xnap_Trace_Depth_vals[] = {
  {   0, "minimum" },
  {   1, "medium" },
  {   2, "maximum" },
  {   3, "minimumWithoutVendorSpecificExtension" },
  {   4, "mediumWithoutVendorSpecificExtension" },
  {   5, "maximumWithoutVendorSpecificExtension" },
  { 0, NULL }
};


static int
dissect_xnap_Trace_Depth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TraceActivation_sequence[] = {
  { &hf_xnap_ng_ran_TraceID , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RANTraceID },
  { &hf_xnap_interfaces_to_trace, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_interfaces_to_trace },
  { &hf_xnap_trace_depth    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_Trace_Depth },
  { &hf_xnap_trace_coll_address, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TransportLayerAddress },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TraceActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TraceActivation, TraceActivation_sequence);

  return offset;
}



static int
dissect_xnap_TrafficIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, TRUE);

  return offset;
}


static const value_string xnap_TrafficProfile_vals[] = {
  {   0, "uPTraffic" },
  {   1, "nonUPTraffic" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TrafficProfile_choice[] = {
  {   0, &hf_xnap_uPTraffic      , ASN1_NO_EXTENSIONS     , dissect_xnap_QoSFlowLevelQoSParameters },
  {   1, &hf_xnap_nonUPTraffic   , ASN1_NO_EXTENSIONS     , dissect_xnap_NonUPTraffic },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_TrafficProfile(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_TrafficProfile, TrafficProfile_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TrafficToBeRelease_Item_sequence[] = {
  { &hf_xnap_trafficIndex   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TrafficIndex },
  { &hf_xnap_bHInfoList     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_BHInfoList },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TrafficToBeRelease_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TrafficToBeRelease_Item, TrafficToBeRelease_Item_sequence);

  return offset;
}


static const per_sequence_t TrafficToBeRelease_List_sequence_of[1] = {
  { &hf_xnap_TrafficToBeRelease_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_TrafficToBeRelease_Item },
};

static int
dissect_xnap_TrafficToBeRelease_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_TrafficToBeRelease_List, TrafficToBeRelease_List_sequence_of,
                                                  1, maxnoofTrafficIndexEntries, FALSE);

  return offset;
}


static const value_string xnap_TrafficReleaseType_vals[] = {
  {   0, "fullRelease" },
  {   1, "partialRelease" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t TrafficReleaseType_choice[] = {
  {   0, &hf_xnap_fullRelease    , ASN1_NO_EXTENSIONS     , dissect_xnap_AllTrafficIndication },
  {   1, &hf_xnap_partialRelease , ASN1_NO_EXTENSIONS     , dissect_xnap_TrafficToBeRelease_List },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_TrafficReleaseType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_TrafficReleaseType, TrafficReleaseType_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TrafficToBeReleaseInformation_sequence[] = {
  { &hf_xnap_releaseType    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_TrafficReleaseType },
  { &hf_xnap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TrafficToBeReleaseInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TrafficToBeReleaseInformation, TrafficToBeReleaseInformation_sequence);

  return offset;
}



static int
dissect_xnap_INTEGER_0_640000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 640000U, NULL, TRUE);

  return offset;
}



static int
dissect_xnap_T_burstArrivalTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_burstArrivalTime);
    dissect_nr_rrc_ReferenceTime_r16_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t TSCAssistanceInformation_sequence[] = {
  { &hf_xnap_periodicity    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_INTEGER_0_640000_ },
  { &hf_xnap_burstArrivalTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_T_burstArrivalTime },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TSCAssistanceInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TSCAssistanceInformation, TSCAssistanceInformation_sequence);

  return offset;
}


static const per_sequence_t TSCTrafficCharacteristics_sequence[] = {
  { &hf_xnap_tSCAssistanceInformationDownlink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TSCAssistanceInformation },
  { &hf_xnap_tSCAssistanceInformationUplink, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_TSCAssistanceInformation },
  { &hf_xnap_ie_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_TSCTrafficCharacteristics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_TSCTrafficCharacteristics, TSCTrafficCharacteristics_sequence);

  return offset;
}


static const per_sequence_t UEAggregateMaximumBitRate_sequence[] = {
  { &hf_xnap_dl_UE_AMBR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_ul_UE_AMBR     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEAggregateMaximumBitRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEAggregateMaximumBitRate, UEAggregateMaximumBitRate_sequence);

  return offset;
}


static const value_string xnap_UEContextKeptIndicator_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_xnap_UEContextKeptIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UEContextIDforRRCResume_sequence[] = {
  { &hf_xnap_i_rnti         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_I_RNTI },
  { &hf_xnap_allocated_c_rnti, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_C_RNTI },
  { &hf_xnap_accessPCI      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_CellPCI },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEContextIDforRRCResume(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEContextIDforRRCResume, UEContextIDforRRCResume_sequence);

  return offset;
}


static const per_sequence_t UEContextIDforRRCReestablishment_sequence[] = {
  { &hf_xnap_c_rnti         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_C_RNTI },
  { &hf_xnap_failureCellPCI , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_NG_RAN_CellPCI },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEContextIDforRRCReestablishment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEContextIDforRRCReestablishment, UEContextIDforRRCReestablishment_sequence);

  return offset;
}


static const value_string xnap_UEContextID_vals[] = {
  {   0, "rRCResume" },
  {   1, "rRRCReestablishment" },
  {   2, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UEContextID_choice[] = {
  {   0, &hf_xnap_rRCResume      , ASN1_NO_EXTENSIONS     , dissect_xnap_UEContextIDforRRCResume },
  {   1, &hf_xnap_rRRCReestablishment, ASN1_NO_EXTENSIONS     , dissect_xnap_UEContextIDforRRCReestablishment },
  {   2, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UEContextID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UEContextID, UEContextID_choice,
                                 NULL);

  return offset;
}


static int * const T_nr_EncyptionAlgorithms_bits[] = {
  &hf_xnap_T_nr_EncyptionAlgorithms_spare_bit0,
  &hf_xnap_T_nr_EncyptionAlgorithms_nea1_128,
  &hf_xnap_T_nr_EncyptionAlgorithms_nea2_128,
  &hf_xnap_T_nr_EncyptionAlgorithms_nea3_128,
  NULL
};

static int
dissect_xnap_T_nr_EncyptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, T_nr_EncyptionAlgorithms_bits, 4, NULL, NULL);

  return offset;
}


static int * const T_nr_IntegrityProtectionAlgorithms_bits[] = {
  &hf_xnap_T_nr_IntegrityProtectionAlgorithms_spare_bit0,
  &hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia1_128,
  &hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia2_128,
  &hf_xnap_T_nr_IntegrityProtectionAlgorithms_nia3_128,
  NULL
};

static int
dissect_xnap_T_nr_IntegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, T_nr_IntegrityProtectionAlgorithms_bits, 4, NULL, NULL);

  return offset;
}


static int * const T_e_utra_EncyptionAlgorithms_bits[] = {
  &hf_xnap_T_e_utra_EncyptionAlgorithms_spare_bit0,
  &hf_xnap_T_e_utra_EncyptionAlgorithms_eea1_128,
  &hf_xnap_T_e_utra_EncyptionAlgorithms_eea2_128,
  &hf_xnap_T_e_utra_EncyptionAlgorithms_eea3_128,
  NULL
};

static int
dissect_xnap_T_e_utra_EncyptionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, T_e_utra_EncyptionAlgorithms_bits, 4, NULL, NULL);

  return offset;
}


static int * const T_e_utra_IntegrityProtectionAlgorithms_bits[] = {
  &hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_spare_bit0,
  &hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia1_128,
  &hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia2_128,
  &hf_xnap_T_e_utra_IntegrityProtectionAlgorithms_eia3_128,
  NULL
};

static int
dissect_xnap_T_e_utra_IntegrityProtectionAlgorithms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, TRUE, T_e_utra_IntegrityProtectionAlgorithms_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t UESecurityCapabilities_sequence[] = {
  { &hf_xnap_nr_EncyptionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_nr_EncyptionAlgorithms },
  { &hf_xnap_nr_IntegrityProtectionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_nr_IntegrityProtectionAlgorithms },
  { &hf_xnap_e_utra_EncyptionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_e_utra_EncyptionAlgorithms },
  { &hf_xnap_e_utra_IntegrityProtectionAlgorithms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_e_utra_IntegrityProtectionAlgorithms },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UESecurityCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UESecurityCapabilities, UESecurityCapabilities_sequence);

  return offset;
}



static int
dissect_xnap_T_rrc_Context(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;
    GlobalNG_RANNode_ID_enum target_ranmode_id = xnap_get_ranmode_id(&actx->pinfo->dst, actx->pinfo->destport, actx->pinfo);

    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RRC_Context);
    if ((xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_AUTOMATIC &&
         target_ranmode_id == GlobalNG_RANNode_ID_gNB) ||
        (xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_GNB)) {
      dissect_nr_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
    } else if ((xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_AUTOMATIC &&
                target_ranmode_id == GlobalNG_RANNode_ID_ng_eNB) ||
               (xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_NG_ENB)) {
      dissect_lte_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
    }
  }


  return offset;
}


static const per_sequence_t UEContextInfoRetrUECtxtResp_sequence[] = {
  { &hf_xnap_ng_c_UE_signalling_ref, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AMF_UE_NGAP_ID },
  { &hf_xnap_signalling_TNL_at_source, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_CPTransportLayerInformation },
  { &hf_xnap_ueSecurityCapabilities, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UESecurityCapabilities },
  { &hf_xnap_securityInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_AS_SecurityInformation },
  { &hf_xnap_ue_AMBR        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEAggregateMaximumBitRate },
  { &hf_xnap_pduSessionResourcesToBeSetup_List, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_PDUSessionResourcesToBeSetup_List },
  { &hf_xnap_rrc_Context    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_T_rrc_Context },
  { &hf_xnap_mobilityRestrictionList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_MobilityRestrictionList },
  { &hf_xnap_indexToRatFrequencySelectionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_RFSP_Index },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEContextInfoRetrUECtxtResp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEContextInfoRetrUECtxtResp, UEContextInfoRetrUECtxtResp_sequence);

  return offset;
}


static const per_sequence_t UEHistoryInformation_sequence_of[1] = {
  { &hf_xnap_UEHistoryInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_LastVisitedCell_Item },
};

static int
dissect_xnap_UEHistoryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UEHistoryInformation, UEHistoryInformation_sequence_of,
                                                  1, maxnoofCellsinUEHistoryInfo, FALSE);

  return offset;
}


static const value_string xnap_UEHistoryInformationFromTheUE_vals[] = {
  {   0, "nR" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UEHistoryInformationFromTheUE_choice[] = {
  {   0, &hf_xnap_nR             , ASN1_NO_EXTENSIONS     , dissect_xnap_NRMobilityHistoryReport },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UEHistoryInformationFromTheUE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UEHistoryInformationFromTheUE, UEHistoryInformationFromTheUE_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_UEIdentityIndexValue_vals[] = {
  {   0, "indexLength10" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UEIdentityIndexValue_choice[] = {
  {   0, &hf_xnap_indexLength10  , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_10 },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UEIdentityIndexValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UEIdentityIndexValue, UEIdentityIndexValue_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_UEIdentityIndexList_MBSGroupPagingValue_vals[] = {
  {   0, "uEIdentityIndexValueMBSGroupPaging" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UEIdentityIndexList_MBSGroupPagingValue_choice[] = {
  {   0, &hf_xnap_uEIdentityIndexValueMBSGroupPaging, ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_10 },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UEIdentityIndexList_MBSGroupPagingValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UEIdentityIndexList_MBSGroupPagingValue, UEIdentityIndexList_MBSGroupPagingValue_choice,
                                 NULL);

  return offset;
}


static const value_string xnap_UESpecificDRX_vals[] = {
  {   0, "v32" },
  {   1, "v64" },
  {   2, "v128" },
  {   3, "v256" },
  { 0, NULL }
};


static int
dissect_xnap_UESpecificDRX(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t UEIdentityIndexList_MBSGroupPaging_Item_sequence[] = {
  { &hf_xnap_ueIdentityIndexList_MBSGroupPagingValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UEIdentityIndexList_MBSGroupPagingValue },
  { &hf_xnap_pagingDRX      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UESpecificDRX },
  { &hf_xnap_iE_Extension   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UEIdentityIndexList_MBSGroupPaging_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UEIdentityIndexList_MBSGroupPaging_Item, UEIdentityIndexList_MBSGroupPaging_Item_sequence);

  return offset;
}


static const per_sequence_t UEIdentityIndexList_MBSGroupPaging_sequence_of[1] = {
  { &hf_xnap_UEIdentityIndexList_MBSGroupPaging_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UEIdentityIndexList_MBSGroupPaging_Item },
};

static int
dissect_xnap_UEIdentityIndexList_MBSGroupPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UEIdentityIndexList_MBSGroupPaging, UEIdentityIndexList_MBSGroupPaging_sequence_of,
                                                  1, maxnoofUEIDIndicesforMBSPaging, FALSE);

  return offset;
}



static int
dissect_xnap_UERadioCapabilityForPagingOfNR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERadioCapabilityForPagingOfNR);
    dissect_nr_rrc_UERadioPagingInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}



static int
dissect_xnap_UERadioCapabilityForPagingOfEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERadioCapabilityForPagingOfEUTRA);
    dissect_lte_rrc_UERadioPagingInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t UERadioCapabilityForPaging_sequence[] = {
  { &hf_xnap_uERadioCapabilityForPagingOfNR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UERadioCapabilityForPagingOfNR },
  { &hf_xnap_uERadioCapabilityForPagingOfEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_UERadioCapabilityForPagingOfEUTRA },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UERadioCapabilityForPaging(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UERadioCapabilityForPaging, UERadioCapabilityForPaging_sequence);

  return offset;
}



static int
dissect_xnap_UERadioCapabilityID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, NULL);

  return offset;
}


static const value_string xnap_UERANPagingIdentity_vals[] = {
  {   0, "i-RNTI-full" },
  {   1, "choice-extension" },
  { 0, NULL }
};

static const per_choice_t UERANPagingIdentity_choice[] = {
  {   0, &hf_xnap_i_RNTI_full    , ASN1_NO_EXTENSIONS     , dissect_xnap_BIT_STRING_SIZE_40 },
  {   1, &hf_xnap_choice_extension, ASN1_NO_EXTENSIONS     , dissect_xnap_ProtocolIE_Single_Container },
  { 0, NULL, 0, NULL }
};

static int
dissect_xnap_UERANPagingIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_xnap_UERANPagingIdentity, UERANPagingIdentity_choice,
                                 NULL);

  return offset;
}



static int
dissect_xnap_UERLFReportContainerLTEExtendBand(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_UERLFReportContainerLTEExtendBand);
    dissect_lte_rrc_RLF_Report_v9e0_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
  }


  return offset;
}


static const per_sequence_t UERLFReportContainerLTEExtension_sequence[] = {
  { &hf_xnap_ueRLFReportContainerLTE, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainerLTE },
  { &hf_xnap_ueRLFReportContainerLTEExtendBand, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_UERLFReportContainerLTEExtendBand },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UERLFReportContainerLTEExtension(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UERLFReportContainerLTEExtension, UERLFReportContainerLTEExtension_sequence);

  return offset;
}


static const per_sequence_t UESliceMaximumBitRate_Item_sequence[] = {
  { &hf_xnap_s_NSSAI        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_S_NSSAI },
  { &hf_xnap_dl_UE_Slice_MBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_ul_UE_Slice_MBR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_BitRate },
  { &hf_xnap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_xnap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_UESliceMaximumBitRate_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_UESliceMaximumBitRate_Item, UESliceMaximumBitRate_Item_sequence);

  return offset;
}


static const per_sequence_t UESliceMaximumBitRateList_sequence_of[1] = {
  { &hf_xnap_UESliceMaximumBitRateList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_xnap_UESliceMaximumBitRate_Item },
};

static int
dissect_xnap_UESliceMaximumBitRateList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_xnap_UESliceMaximumBitRateList, UESliceMaximumBitRateList_sequence_of,
                                                  1, maxnoofSMBR, FALSE);

  return offset;
}


static const value_string xnap_ULForwardingProposal_vals[] = {
  {   0, "ul-forwarding-proposed" },
  { 0, NULL }
};


static int
dissect_xnap_ULForwardingProposal(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string xnap_UserPlaneTrafficActivityReport_vals[] = {
  {   0, "inactive" },
  {   1, "re-activated" },
  { 0, NULL }
};


static int
dissect_xnap_UserPlaneTrafficActivityReport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_xnap_URIaddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          NO_BOUND, NO_BOUND, FALSE,
                                          NULL);

  return offset;
}



static int
dissect_xnap_XnBenefitValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, TRUE);

  return offset;
}


static const per_sequence_t HandoverRequest_sequence[] = {
  { &hf_xnap_protocolIEs    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_xnap_ProtocolIE_Container },
  { NULL, 0, 0, NULL }
};

static int
dissect_xnap_HandoverRequest(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "HandoverRequest");
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_xnap_HandoverRequest, HandoverRequest_sequence);

  return offset;
}



static int
dissect_xnap_T_rrc_Context_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *parameter_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &parameter_tvb);

  if (parameter_tvb) {
    proto_tree *subtree;
    GlobalNG_RANNode_ID_enum target_ranmode_id = xnap_get_ranmode_id(&actx->pinfo->dst, actx->pinfo->destport, actx->pinfo);

    subtree = proto_item_add_subtree(actx->created_item, ett_xnap_RRC_Context);
    if ((xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_AUTOMATIC &&
         target_ranmode_id == GlobalNG_RANNode_ID_gNB) ||
        (xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_GNB)) {
      dissect_nr_rrc_HandoverPreparationInformation_PDU(parameter_tvb, actx->pinfo, subtree, NULL);
    } else if ((xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_AUTOMATIC &&
                target_ranmode_id == GlobalNG_RANNode_ID_ng_eNB) ||
               (xnap_dissect_target_ng_ran_container_as == XNAP_NG_RAN_CONTAINER_NG_ENB)) {
      if (xnap_dissect_lte_rrc_context_as == XNAP_LTE_RRC_CONTEXT_NBIOT) {
        disse