/* This file is automatically generated by Lemon from input grammar

/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser

**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
/************ Begin %include sections from the grammar ************************/
#include "config.h"
#define WS_LOG_DOMAIN LOG_DOMAIN_DFILTER

#include <assert.h>

#include "dfilter-int.h"
#include "syntax-tree.h"
#include "sttype-field.h"
#include "sttype-slice.h"
#include "sttype-op.h"
#include "sttype-function.h"
#include "sttype-set.h"
#include "drange.h"

#include "grammar.h"

#ifdef _MSC_VER
#pragma warning(disable:4671)
#endif

static stnode_t *
new_function(dfsyntax_t *dfs, stnode_t *node);

#define FAIL(dfs, node, ...) \
    do { \
        ws_noisy("Parsing failed here."); \
        dfilter_fail(dfs, DF_ERROR_GENERIC, stnode_location(node), __VA_ARGS__); \
    } while (0)

DIAG_OFF_LEMON()
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef TOKEN_TEST_OR
#define TOKEN_TEST_OR                         1
#define TOKEN_TEST_XOR                        2
#define TOKEN_TEST_AND                        3
#define TOKEN_TEST_NOT                        4
#define TOKEN_TEST_ALL_EQ                     5
#define TOKEN_TEST_ANY_EQ                     6
#define TOKEN_TEST_ALL_NE                     7
#define TOKEN_TEST_ANY_NE                     8
#define TOKEN_TEST_LT                         9
#define TOKEN_TEST_LE                        10
#define TOKEN_TEST_GT                        11
#define TOKEN_TEST_GE                        12
#define TOKEN_TEST_CONTAINS                  13
#define TOKEN_TEST_MATCHES                   14
#define TOKEN_BITWISE_AND                    15
#define TOKEN_PLUS                           16
#define TOKEN_MINUS                          17
#define TOKEN_STAR                           18
#define TOKEN_RSLASH                         19
#define TOKEN_PERCENT                        20
#define TOKEN_UNARY_PLUS                     21
#define TOKEN_UNARY_MINUS                    22
#define TOKEN_LPAREN                         23
#define TOKEN_RPAREN                         24
#define TOKEN_STRING                         25
#define TOKEN_CHARCONST                      26
#define TOKEN_LITERAL                        27
#define TOKEN_CONSTANT                       28
#define TOKEN_FIELD                          29
#define TOKEN_IDENTIFIER                     30
#define TOKEN_HASH                           31
#define TOKEN_LBRACKET                       32
#define TOKEN_RBRACKET                       33
#define TOKEN_INTEGER                        34
#define TOKEN_ATSIGN                         35
#define TOKEN_DOLLAR                         36
#define TOKEN_LBRACE                         37
#define TOKEN_RBRACE                         38
#define TOKEN_TEST_IN                        39
#define TOKEN_ANY                            40
#define TOKEN_ALL                            41
#define TOKEN_DOTDOT                         42
#define TOKEN_COMMA                          43
#define TOKEN_RANGE_NODE                     44
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    DfilterTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is DfilterTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    DfilterARG_SDECL     A static variable declaration for the %extra_argument
**    DfilterARG_PDECL     A parameter declaration for the %extra_argument
**    DfilterARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    DfilterARG_STORE     Code to store %extra_argument into yypParser
**    DfilterARG_FETCH     Code to extract %extra_argument from yypParser
**    DfilterCTX_*         As DfilterARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 65
#define YYACTIONTYPE unsigned char
#define DfilterTOKENTYPE stnode_t*
typedef union {
  int yyinit;
  DfilterTOKENTYPE yy0;
  GSList* yy53;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define DfilterARG_SDECL dfsyntax_t *dfs;
#define DfilterARG_PDECL ,dfsyntax_t *dfs
#define DfilterARG_PARAM ,dfs
#define DfilterARG_FETCH dfsyntax_t *dfs=yypParser->dfs;
#define DfilterARG_STORE yypParser->dfs=dfs;
#define DfilterCTX_SDECL
#define DfilterCTX_PDECL
#define DfilterCTX_PARAM
#define DfilterCTX_FETCH
#define DfilterCTX_STORE
#define YYNSTATE             64
#define YYNRULE              68
#define YYNRULE_WITH_ACTION  68
#define YYNTOKEN             45
#define YY_MAX_SHIFT         63
#define YY_MIN_SHIFTREDUCE   114
#define YY_MAX_SHIFTREDUCE   181
#define YY_ERROR_ACTION      182
#define YY_ACCEPT_ACTION     183
#define YY_NO_ACTION         184
#define YY_MIN_REDUCE        185
#define YY_MAX_REDUCE        252
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (480)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   186,   46,  241,   12,    2,  235,   35,  206,   61,  203,
 /*    10 */   209,  210,   57,  207,  208,  234,   22,   20,   21,   19,
 /*    20 */    18,   17,   16,    1,   50,  123,  124,  125,   63,  127,
 /*    30 */    62,    2,  127,  128,   51,   27,   59,   15,   27,   33,
 /*    40 */     7,    6,    8,   22,   20,  174,    4,    3,    5,   31,
 /*    50 */     1,    5,  123,  124,  125,   63,  127,   62,  185,    4,
 /*    60 */     3,    5,   27,   59,   15,  127,  128,    7,    6,  122,
 /*    70 */   134,   61,  204,  183,   43,  187,   30,  206,   61,  203,
 /*    80 */   209,  210,   40,  207,  208,  175,  231,  236,  150,  151,
 /*    90 */   152,  153,  156,  157,  154,  155,    3,    5,   23,   21,
 /*   100 */    19,   18,   17,   16,   42,  187,   30,  206,   61,  203,
 /*   110 */   209,  210,   40,  207,  208,   26,  231,  236,  192,  187,
 /*   120 */    30,  206,   61,  203,  209,  210,   40,  207,  208,   52,
 /*   130 */   231,  236,   56,  187,   30,  206,   61,  203,  209,  210,
 /*   140 */    40,  207,  208,    9,  231,  236,   47,  187,   30,  206,
 /*   150 */    61,  203,  209,  210,   40,  207,  208,   10,  231,  236,
 /*   160 */   189,  187,   30,  206,   61,  203,  209,  210,   40,  207,
 /*   170 */   208,  184,  231,  236,  177,   22,   20,   23,   21,   19,
 /*   180 */    18,   17,   16,  178,  123,  124,  125,   63,  127,   62,
 /*   190 */    22,   20,  172,   14,   27,   59,   15,   11,  179,  123,
 /*   200 */   124,  125,   63,  127,   62,   22,   20,  184,  176,   27,
 /*   210 */    59,   15,  184,  173,  123,  124,  125,   63,  127,   62,
 /*   220 */    61,  203,   58,   60,   27,   59,   15,   14,   28,  206,
 /*   230 */    61,  203,  209,  210,   40,  207,  208,  184,  231,  238,
 /*   240 */    28,  206,   61,  203,  209,  210,   40,  207,  208,   49,
 /*   250 */   231,  237,   18,   17,   16,   39,  206,   61,  203,  209,
 /*   260 */   210,   57,  207,  208,   48,   34,  184,  131,  184,  184,
 /*   270 */    39,  206,   61,  203,  209,  210,   57,  207,  208,  242,
 /*   280 */   184,  184,  184,   35,  206,   61,  203,  209,  210,   57,
 /*   290 */   207,  208,   29,  206,   61,  203,  209,  210,   57,  207,
 /*   300 */   208,  184,  230,   37,  206,   61,  203,  209,  210,   57,
 /*   310 */   207,  208,   38,  206,   61,  203,  209,  210,   57,  207,
 /*   320 */   208,  184,  184,   36,  206,   61,  203,  209,  210,   57,
 /*   330 */   207,  208,  219,  206,   61,  203,  209,  210,   57,  207,
 /*   340 */   208,  218,  206,   61,  203,  209,  210,   57,  207,  208,
 /*   350 */   217,  206,   61,  203,  209,  210,   57,  207,  208,   45,
 /*   360 */   206,   61,  203,  209,  210,   57,  207,  208,  213,  206,
 /*   370 */    61,  203,  209,  210,   57,  207,  208,   44,  206,   61,
 /*   380 */   203,  209,  210,   57,  207,  208,  212,  206,   61,  203,
 /*   390 */   209,  210,   57,  207,  208,   41,  206,   61,  203,  209,
 /*   400 */   210,   57,  207,  208,  123,  124,  125,   63,  127,   62,
 /*   410 */   184,  184,  184,  184,   27,   59,  206,   61,  203,  209,
 /*   420 */   210,   54,  207,  208,  206,   61,  203,  209,  210,   55,
 /*   430 */   207,  208,   23,   21,   19,   18,   17,   16,   23,   21,
 /*   440 */    19,   18,   17,   16,   53,  184,  184,  184,  130,  184,
 /*   450 */   184,  184,  184,   25,   24,  184,  184,  184,   60,   13,
 /*   460 */   184,  149,  184,  184,  184,  184,  184,  184,  184,  184,
 /*   470 */   184,  184,   33,  184,  184,  184,  184,  184,  184,   32,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     0,   47,   48,   61,    4,   64,   52,   53,   54,   55,
 /*    10 */    56,   57,   58,   59,   60,   64,   16,   17,   16,   17,
 /*    20 */    18,   19,   20,   23,   45,   25,   26,   27,   28,   29,
 /*    30 */    30,    4,   29,   30,   45,   35,   36,   37,   35,   32,
 /*    40 */    40,   41,   37,   16,   17,   44,    1,    2,    3,   39,
 /*    50 */    23,    3,   25,   26,   27,   28,   29,   30,    0,    1,
 /*    60 */     2,    3,   35,   36,   37,   29,   30,   40,   41,   24,
 /*    70 */    38,   54,   55,   49,   50,   51,   52,   53,   54,   55,
 /*    80 */    56,   57,   58,   59,   60,   44,   62,   63,    5,    6,
 /*    90 */     7,    8,    9,   10,   11,   12,    2,    3,   15,   16,
 /*   100 */    17,   18,   19,   20,   50,   51,   52,   53,   54,   55,
 /*   110 */    56,   57,   58,   59,   60,   37,   62,   63,   50,   51,
 /*   120 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   31,
 /*   130 */    62,   63,   50,   51,   52,   53,   54,   55,   56,   57,
 /*   140 */    58,   59,   60,   23,   62,   63,   50,   51,   52,   53,
 /*   150 */    54,   55,   56,   57,   58,   59,   60,   23,   62,   63,
 /*   160 */    50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
 /*   170 */    60,   65,   62,   63,   24,   16,   17,   15,   16,   17,
 /*   180 */    18,   19,   20,   24,   25,   26,   27,   28,   29,   30,
 /*   190 */    16,   17,   38,   43,   35,   36,   37,   43,   24,   25,
 /*   200 */    26,   27,   28,   29,   30,   16,   17,   65,   24,   35,
 /*   210 */    36,   37,   65,   33,   25,   26,   27,   28,   29,   30,
 /*   220 */    54,   55,   56,   43,   35,   36,   37,   43,   52,   53,
 /*   230 */    54,   55,   56,   57,   58,   59,   60,   65,   62,   63,
 /*   240 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   46,
 /*   250 */    62,   63,   18,   19,   20,   52,   53,   54,   55,   56,
 /*   260 */    57,   58,   59,   60,   46,   32,   65,   34,   65,   65,
 /*   270 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   48,
 /*   280 */    65,   65,   65,   52,   53,   54,   55,   56,   57,   58,
 /*   290 */    59,   60,   52,   53,   54,   55,   56,   57,   58,   59,
 /*   300 */    60,   65,   62,   52,   53,   54,   55,   56,   57,   58,
 /*   310 */    59,   60,   52,   53,   54,   55,   56,   57,   58,   59,
 /*   320 */    60,   65,   65,   52,   53,   54,   55,   56,   57,   58,
 /*   330 */    59,   60,   52,   53,   54,   55,   56,   57,   58,   59,
 /*   340 */    60,   52,   53,   54,   55,   56,   57,   58,   59,   60,
 /*   350 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   52,
 /*   360 */    53,   54,   55,   56,   57,   58,   59,   60,   52,   53,
 /*   370 */    54,   55,   56,   57,   58,   59,   60,   52,   53,   54,
 /*   380 */    55,   56,   57,   58,   59,   60,   52,   53,   54,   55,
 /*   390 */    56,   57,   58,   59,   60,   52,   53,   54,   55,   56,
 /*   400 */    57,   58,   59,   60,   25,   26,   27,   28,   29,   30,
 /*   410 */    65,   65,   65,   65,   35,   36,   53,   54,   55,   56,
 /*   420 */    57,   58,   59,   60,   53,   54,   55,   56,   57,   58,
 /*   430 */    59,   60,   15,   16,   17,   18,   19,   20,   15,   16,
 /*   440 */    17,   18,   19,   20,    4,   65,   65,   65,   33,   65,
 /*   450 */    65,   65,   65,   13,   14,   65,   65,   65,   43,   42,
 /*   460 */    65,   38,   65,   65,   65,   65,   65,   65,   65,   65,
 /*   470 */    65,   65,   32,   65,   65,   65,   65,   65,   65,   39,
 /*   480 */    65,   65,   65,   65,   65,   65,   65,   65,   65,   65,
 /*   490 */    65,   65,   65,   65,   45,   45,   45,   45,   45,   45,
 /*   500 */    45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
 /*   510 */    45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
 /*   520 */    45,   45,   45,   45,   45,
};
#define YY_SHIFT_COUNT    (63)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (440)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,   27,   27,   27,   27,   27,  189,  189,  189,  159,
 /*    10 */   174,  189,  189,  189,  189,  189,  189,  189,  189,  189,
 /*    20 */   189,  189,  189,  189,  379,  379,    3,   36,   83,   83,
 /*    30 */    83,    5,    5,    1,    1,  417,  423,  162,  162,  162,
 /*    40 */   440,    2,   45,   58,  234,  234,  154,   94,  150,  184,
 /*    50 */   180,  415,  233,   10,    7,    7,   48,    7,   32,   78,
 /*    60 */    41,   98,  120,  134,
};
#define YY_REDUCE_COUNT (34)
#define YY_REDUCE_MIN   (-59)
#define YY_REDUCE_MAX   (371)
static const short yy_reduce_ofst[] = {
 /*     0 */    24,   54,   68,   82,   96,  110,  176,  188,  -46,  203,
 /*    10 */   218,  231,  240,  251,  260,  271,  280,  289,  298,  307,
 /*    20 */   316,  325,  334,  343,  363,  371,  166,   17,  -58,  -58,
 /*    30 */   -58,  -59,  -49,  -21,  -11,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
 /*    10 */   182,  182,  182,  182,  182,  182,  182,  182,  182,  182,
 /*    20 */   182,  182,  182,  182,  182,  182,  182,  182,  182,  229,
 /*    30 */   188,  182,  182,  182,  182,  239,  182,  240,  252,  251,
 /*    40 */   211,  214,  182,  182,  215,  216,  182,  190,  182,  182,
 /*    50 */   182,  182,  182,  182,  233,  232,  191,  211,  182,  182,
 /*    60 */   182,  200,  199,  197,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.
** If a construct like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  DfilterARG_SDECL                /* A place to hold %extra_argument */
  DfilterCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#include <assert.h>
#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void DfilterTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  /*    0 */ "$",
  /*    1 */ "TEST_OR",
  /*    2 */ "TEST_XOR",
  /*    3 */ "TEST_AND",
  /*    4 */ "TEST_NOT",
  /*    5 */ "TEST_ALL_EQ",
  /*    6 */ "TEST_ANY_EQ",
  /*    7 */ "TEST_ALL_NE",
  /*    8 */ "TEST_ANY_NE",
  /*    9 */ "TEST_LT",
  /*   10 */ "TEST_LE",
  /*   11 */ "TEST_GT",
  /*   12 */ "TEST_GE",
  /*   13 */ "TEST_CONTAINS",
  /*   14 */ "TEST_MATCHES",
  /*   15 */ "BITWISE_AND",
  /*   16 */ "PLUS",
  /*   17 */ "MINUS",
  /*   18 */ "STAR",
  /*   19 */ "RSLASH",
  /*   20 */ "PERCENT",
  /*   21 */ "UNARY_PLUS",
  /*   22 */ "UNARY_MINUS",
  /*   23 */ "LPAREN",
  /*   24 */ "RPAREN",
  /*   25 */ "STRING",
  /*   26 */ "CHARCONST",
  /*   27 */ "LITERAL",
  /*   28 */ "CONSTANT",
  /*   29 */ "FIELD",
  /*   30 */ "IDENTIFIER",
  /*   31 */ "HASH",
  /*   32 */ "LBRACKET",
  /*   33 */ "RBRACKET",
  /*   34 */ "INTEGER",
  /*   35 */ "ATSIGN",
  /*   36 */ "DOLLAR",
  /*   37 */ "LBRACE",
  /*   38 */ "RBRACE",
  /*   39 */ "TEST_IN",
  /*   40 */ "ANY",
  /*   41 */ "ALL",
  /*   42 */ "DOTDOT",
  /*   43 */ "COMMA",
  /*   44 */ "RANGE_NODE",
  /*   45 */ "range_node_list",
  /*   46 */ "func_params_list",
  /*   47 */ "set_list",
  /*   48 */ "set_element_list",
  /*   49 */ "sentence",
  /*   50 */ "expr",
  /*   51 */ "relation",
  /*   52 */ "arithmetic_expr",
  /*   53 */ "atom",
  /*   54 */ "named_field",
  /*   55 */ "layered_field",
  /*   56 */ "rawable_field",
  /*   57 */ "reference",
  /*   58 */ "entity",
  /*   59 */ "slice",
  /*   60 */ "function",
  /*   61 */ "cmp_op",
  /*   62 */ "comparison_test",
  /*   63 */ "relation_test",
  /*   64 */ "set",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "sentence ::= expr",
 /*   1 */ "sentence ::=",
 /*   2 */ "expr ::= relation",
 /*   3 */ "expr ::= arithmetic_expr",
 /*   4 */ "expr ::= expr TEST_AND expr",
 /*   5 */ "expr ::= expr TEST_OR expr",
 /*   6 */ "expr ::= expr TEST_XOR expr",
 /*   7 */ "expr ::= TEST_NOT expr",
 /*   8 */ "expr ::= LPAREN expr RPAREN",
 /*   9 */ "atom ::= STRING",
 /*  10 */ "atom ::= CHARCONST",
 /*  11 */ "atom ::= LITERAL",
 /*  12 */ "atom ::= CONSTANT",
 /*  13 */ "named_field ::= FIELD",
 /*  14 */ "named_field ::= IDENTIFIER",
 /*  15 */ "layered_field ::= named_field",
 /*  16 */ "layered_field ::= named_field HASH LBRACKET range_node_list RBRACKET",
 /*  17 */ "layered_field ::= named_field HASH INTEGER",
 /*  18 */ "rawable_field ::= layered_field",
 /*  19 */ "rawable_field ::= ATSIGN layered_field",
 /*  20 */ "reference ::= DOLLAR LBRACE rawable_field RBRACE",
 /*  21 */ "entity ::= atom",
 /*  22 */ "entity ::= slice",
 /*  23 */ "entity ::= function",
 /*  24 */ "entity ::= rawable_field",
 /*  25 */ "entity ::= reference",
 /*  26 */ "arithmetic_expr ::= entity",
 /*  27 */ "arithmetic_expr ::= PLUS arithmetic_expr",
 /*  28 */ "arithmetic_expr ::= MINUS arithmetic_expr",
 /*  29 */ "arithmetic_expr ::= arithmetic_expr BITWISE_AND arithmetic_expr",
 /*  30 */ "arithmetic_expr ::= arithmetic_expr PLUS arithmetic_expr",
 /*  31 */ "arithmetic_expr ::= arithmetic_expr MINUS arithmetic_expr",
 /*  32 */ "arithmetic_expr ::= arithmetic_expr STAR arithmetic_expr",
 /*  33 */ "arithmetic_expr ::= arithmetic_expr RSLASH arithmetic_expr",
 /*  34 */ "arithmetic_expr ::= arithmetic_expr PERCENT arithmetic_expr",
 /*  35 */ "arithmetic_expr ::= LBRACE arithmetic_expr RBRACE",
 /*  36 */ "cmp_op ::= TEST_ALL_EQ",
 /*  37 */ "cmp_op ::= TEST_ANY_EQ",
 /*  38 */ "cmp_op ::= TEST_ALL_NE",
 /*  39 */ "cmp_op ::= TEST_ANY_NE",
 /*  40 */ "cmp_op ::= TEST_GT",
 /*  41 */ "cmp_op ::= TEST_GE",
 /*  42 */ "cmp_op ::= TEST_LT",
 /*  43 */ "cmp_op ::= TEST_LE",
 /*  44 */ "comparison_test ::= arithmetic_expr cmp_op arithmetic_expr",
 /*  45 */ "comparison_test ::= arithmetic_expr cmp_op comparison_test",
 /*  46 */ "relation_test ::= comparison_test",
 /*  47 */ "relation_test ::= entity TEST_CONTAINS entity",
 /*  48 */ "relation_test ::= entity TEST_MATCHES entity",
 /*  49 */ "relation_test ::= entity TEST_IN set",
 /*  50 */ "relation_test ::= entity TEST_NOT TEST_IN set",
 /*  51 */ "relation ::= relation_test",
 /*  52 */ "relation ::= ANY relation_test",
 /*  53 */ "relation ::= ALL relation_test",
 /*  54 */ "set_element_list ::= arithmetic_expr",
 /*  55 */ "set_element_list ::= arithmetic_expr DOTDOT arithmetic_expr",
 /*  56 */ "set_list ::= set_element_list",
 /*  57 */ "set_list ::= set_list COMMA set_element_list",
 /*  58 */ "set ::= LBRACE set_list RBRACE",
 /*  59 */ "slice ::= entity LBRACKET range_node_list RBRACKET",
 /*  60 */ "range_node_list ::= RANGE_NODE",
 /*  61 */ "range_node_list ::= range_node_list COMMA RANGE_NODE",
 /*  62 */ "function ::= IDENTIFIER LPAREN func_params_list RPAREN",
 /*  63 */ "function ::= CONSTANT LPAREN func_params_list RPAREN",
 /*  64 */ "function ::= IDENTIFIER LPAREN RPAREN",
 /*  65 */ "function ::= CONSTANT LPAREN RPAREN",
 /*  66 */ "func_params_list ::= arithmetic_expr",
 /*  67 */ "func_params_list ::= func_params_list COMMA arithmetic_expr",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0;
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to DfilterAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void DfilterInit(void *yypRawParser DfilterCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  DfilterCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Dfilter_ENGINEALWAYSONSTACK
/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Dfilter and DfilterFree.
*/
void *DfilterAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) DfilterCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    DfilterCTX_STORE
    DfilterInit(yypParser DfilterCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Dfilter_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  DfilterARG_FETCH
  DfilterCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* TERMINAL Destructor */
    case 1: /* TEST_OR */
    case 2: /* TEST_XOR */
    case 3: /* TEST_AND */
    case 4: /* TEST_NOT */
    case 5: /* TEST_ALL_EQ */
    case 6: /* TEST_ANY_EQ */
    case 7: /* TEST_ALL_NE */
    case 8: /* TEST_ANY_NE */
    case 9: /* TEST_LT */
    case 10: /* TEST_LE */
    case 11: /* TEST_GT */
    case 12: /* TEST_GE */
    case 13: /* TEST_CONTAINS */
    case 14: /* TEST_MATCHES */
    case 15: /* BITWISE_AND */
    case 16: /* PLUS */
    case 17: /* MINUS */
    case 18: /* STAR */
    case 19: /* RSLASH */
    case 20: /* PERCENT */
    case 21: /* UNARY_PLUS */
    case 22: /* UNARY_MINUS */
    case 23: /* LPAREN */
    case 24: /* RPAREN */
    case 25: /* STRING */
    case 26: /* CHARCONST */
    case 27: /* LITERAL */
    case 28: /* CONSTANT */
    case 29: /* FIELD */
    case 30: /* IDENTIFIER */
    case 31: /* HASH */
    case 32: /* LBRACKET */
    case 33: /* RBRACKET */
    case 34: /* INTEGER */
    case 35: /* ATSIGN */
    case 36: /* DOLLAR */
    case 37: /* LBRACE */
    case 38: /* RBRACE */
    case 39: /* TEST_IN */
    case 40: /* ANY */
    case 41: /* ALL */
    case 42: /* DOTDOT */
    case 43: /* COMMA */
    case 44: /* RANGE_NODE */
{

    (void)dfs;
    stnode_free((yypminor->yy0));

}
      break;
      /* Default NON-TERMINAL Destructor */
    case 49: /* sentence */
    case 50: /* expr */
    case 51: /* relation */
    case 52: /* arithmetic_expr */
    case 53: /* atom */
    case 54: /* named_field */
    case 55: /* layered_field */
    case 56: /* rawable_field */
    case 57: /* reference */
    case 58: /* entity */
    case 59: /* slice */
    case 60: /* function */
    case 61: /* cmp_op */
    case 62: /* comparison_test */
    case 63: /* relation_test */
    case 64: /* set */
{
stnode_free((yypminor->yy0));
}
      break;
    case 45: /* range_node_list */
{
drange_node_free_list((yypminor->yy53));
}
      break;
    case 46: /* func_params_list */
{
st_funcparams_free((yypminor->yy53));
}
      break;
    case 47: /* set_list */
    case 48: /* set_element_list */
{
set_nodelist_free((yypminor->yy53));
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void DfilterFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Dfilter_ENGINEALWAYSONSTACK
/*
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void DfilterFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  DfilterFinalize(p);
  (*freeProc)(p);
}
#endif /* Dfilter_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int DfilterStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int DfilterCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   DfilterARG_FETCH
   DfilterCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   DfilterARG_STORE /* Suppress warning about unused %extra_argument var */
   DfilterCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  DfilterTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    49,  /* (0) sentence ::= expr */
    49,  /* (1) sentence ::= */
    50,  /* (2) expr ::= relation */
    50,  /* (3) expr ::= arithmetic_expr */
    50,  /* (4) expr ::= expr TEST_AND expr */
    50,  /* (5) expr ::= expr TEST_OR expr */
    50,  /* (6) expr ::= expr TEST_XOR expr */
    50,  /* (7) expr ::= TEST_NOT expr */
    50,  /* (8) expr ::= LPAREN expr RPAREN */
    53,  /* (9) atom ::= STRING */
    53,  /* (10) atom ::= CHARCONST */
    53,  /* (11) atom ::= LITERAL */
    53,  /* (12) atom ::= CONSTANT */
    54,  /* (13) named_field ::= FIELD */
    54,  /* (14) named_field ::= IDENTIFIER */
    55,  /* (15) layered_field ::= named_field */
    55,  /* (16) layered_field ::= named_field HASH LBRACKET range_node_list RBRACKET */
    55,  /* (17) layered_field ::= named_field HASH INTEGER */
    56,  /* (18) rawable_field ::= layered_field */
    56,  /* (19) rawable_field ::= ATSIGN layered_field */
    57,  /* (20) reference ::= DOLLAR LBRACE rawable_field RBRACE */
    58,  /* (21) entity ::= atom */
    58,  /* (22) entity ::= slice */
    58,  /* (23) entity ::= function */
    58,  /* (24) entity ::= rawable_field */
    58,  /* (25) entity ::= reference */
    52,  /* (26) arithmetic_expr ::= entity */
    52,  /* (27) arithmetic_expr ::= PLUS arithmetic_expr */
    52,  /* (28) arithmetic_expr ::= MINUS arithmetic_expr */
    52,  /* (29) arithmetic_expr ::= arithmetic_expr BITWISE_AND arithmetic_expr */
    52,  /* (30) arithmetic_expr ::= arithmetic_expr PLUS arithmetic_expr */
    52,  /* (31) arithmetic_expr ::= arithmetic_expr MINUS arithmetic_expr */
    52,  /* (32) arithmetic_expr ::= arithmetic_expr STAR arithmetic_expr */
    52,  /* (33) arithmetic_expr ::= arithmetic_expr RSLASH arithmetic_expr */
    52,  /* (34) arithmetic_expr ::= arithmetic_expr PERCENT arithmetic_expr */
    52,  /* (35) arithmetic_expr ::= LBRACE arithmetic_expr RBRACE */
    61,  /* (36) cmp_op ::= TEST_ALL_EQ */
    61,  /* (37) cmp_op ::= TEST_ANY_EQ */
    61,  /* (38) cmp_op ::= TEST_ALL_NE */
    61,  /* (39) cmp_op ::= TEST_ANY_NE */
    61,  /* (40) cmp_op ::= TEST_GT */
    61,  /* (41) cmp_op ::= TEST_GE */
    61,  /* (42) cmp_op ::= TEST_LT */
    61,  /* (43) cmp_op ::= TEST_LE */
    62,  /* (44) comparison_test ::= arithmetic_expr cmp_op arithmetic_expr */
    62,  /* (45) comparison_test ::= arithmetic_expr cmp_op comparison_test */
    63,  /* (46) relation_test ::= comparison_test */
    63,  /* (47) relation_test ::= entity TEST_CONTAINS entity */
    63,  /* (48) relation_test ::= entity TEST_MATCHES entity */
    63,  /* (49) relation_test ::= entity TEST_IN set */
    63,  /* (50) relation_test ::= entity TEST_NOT TEST_IN set */
    51,  /* (51) relation ::= relation_test */
    51,  /* (52) relation ::= ANY relation_test */
    51,  /* (53) relation ::= ALL relation_test */
    48,  /* (54) set_element_list ::= arithmetic_expr */
    48,  /* (55) set_element_list ::= arithmetic_expr DOTDOT arithmetic_expr */
    47,  /* (56) set_list ::= set_element_list */
    47,  /* (57) set_list ::= set_list COMMA set_element_list */
    64,  /* (58) set ::= LBRACE set_list RBRACE */
    59,  /* (59) slice ::= entity LBRACKET range_node_list RBRACKET */
    45,  /* (60) range_node_list ::= RANGE_NODE */
    45,  /* (61) range_node_list ::= range_node_list COMMA RANGE_NODE */
    60,  /* (62) function ::= IDENTIFIER LPAREN func_params_list RPAREN */
    60,  /* (63) function ::= CONSTANT LPAREN func_params_list RPAREN */
    60,  /* (64) function ::= IDENTIFIER LPAREN RPAREN */
    60,  /* (65) function ::= CONSTANT LPAREN RPAREN */
    46,  /* (66) func_params_list ::= arithmetic_expr */
    46,  /* (67) func_params_list ::= func_params_list COMMA arithmetic_expr */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -1,  /* (0) sentence ::= expr */
    0,  /* (1) sentence ::= */
   -1,  /* (2) expr ::= relation */
   -1,  /* (3) expr ::= arithmetic_expr */
   -3,  /* (4) expr ::= expr TEST_AND expr */
   -3,  /* (5) expr ::= expr TEST_OR expr */
   -3,  /* (6) expr ::= expr TEST_XOR expr */
   -2,  /* (7) expr ::= TEST_NOT expr */
   -3,  /* (8) expr ::= LPAREN expr RPAREN */
   -1,  /* (9) atom ::= STRING */
   -1,  /* (10) atom ::= CHARCONST */
   -1,  /* (11) atom ::= LITERAL */
   -1,  /* (12) atom ::= CONSTANT */
   -1,  /* (13) named_field ::= FIELD */
   -1,  /* (14) named_field ::= IDENTIFIER */
   -1,  /* (15) layered_field ::= named_field */
   -5,  /* (16) layered_field ::= named_field HASH LBRACKET range_node_list RBRACKET */
   -3,  /* (17) layered_field ::= named_field HASH INTEGER */
   -1,  /* (18) rawable_field ::= layered_field */
   -2,  /* (19) rawable_field ::= ATSIGN layered_field */
   -4,  /* (20) reference ::= DOLLAR LBRACE rawable_field RBRACE */
   -1,  /* (21) entity ::= atom */
   -1,  /* (22) entity ::= slice */
   -1,  /* (23) entity ::= function */
   -1,  /* (24) entity ::= rawable_field */
   -1,  /* (25) entity ::= reference */
   -1,  /* (26) arithmetic_expr ::= entity */
   -2,  /* (27) arithmetic_expr ::= PLUS arithmetic_expr */
   -2,  /* (28) arithmetic_expr ::= MINUS arithmetic_expr */
   -3,  /* (29) arithmetic_expr ::= arithmetic_expr BITWISE_AND arithmetic_expr */
   -3,  /* (30) arithmetic_expr ::= arithmetic_expr PLUS arithmetic_expr */
   -3,  /* (31) arithmetic_expr ::= arithmetic_expr MINUS arithmetic_expr */
   -3,  /* (32) arithmetic_expr ::= arithmetic_expr STAR arithmetic_expr */
   -3,  /* (33) arithmetic_expr ::= arithmetic_expr RSLASH arithmetic_expr */
   -3,  /* (34) arithmetic_expr ::= arithmetic_expr PERCENT arithmetic_expr */
   -3,  /* (35) arithmetic_expr ::= LBRACE arithmetic_expr RBRACE */
   -1,  /* (36) cmp_op ::= TEST_ALL_EQ */
   -1,  /* (37) cmp_op ::= TEST_ANY_EQ */
   -1,  /* (38) cmp_op ::= TEST_ALL_NE */
   -1,  /* (39) cmp_op ::= TEST_ANY_NE */
   -1,  /* (40) cmp_op ::= TEST_GT */
   -1,  /* (41) cmp_op ::= TEST_GE */
   -1,  /* (42) cmp_op ::= TEST_LT */
   -1,  /* (43) cmp_op ::= TEST_LE */
   -3,  /* (44) comparison_test ::= arithmetic_expr cmp_op arithmetic_expr */
   -3,  /* (45) comparison_test ::= arithmetic_expr cmp_op comparison_test */
   -1,  /* (46) relation_test ::= comparison_test */
   -3,  /* (47) relation_test ::= entity TEST_CONTAINS entity */
   -3,  /* (48) relation_test ::= entity TEST_MATCHES entity */
   -3,  /* (49) relation_test ::= entity TEST_IN set */
   -4,  /* (50) relation_test ::= entity TEST_NOT TEST_IN set */
   -1,  /* (51) relation ::= relation_test */
   -2,  /* (52) relation ::= ANY relation_test */
   -2,  /* (53) relation ::= ALL relation_test */
   -1,  /* (54) set_element_list ::= arithmetic_expr */
   -3,  /* (55) set_element_list ::= arithmetic_expr DOTDOT arithmetic_expr */
   -1,  /* (56) set_list ::= set_element_list */
   -3,  /* (57) set_list ::= set_list COMMA set_element_list */
   -3,  /* (58) set ::= LBRACE set_list RBRACE */
   -4,  /* (59) slice ::= entity LBRACKET range_node_list RBRACKET */
   -1,  /* (60) range_node_list ::= RANGE_NODE */
   -3,  /* (61) range_node_list ::= range_node_list COMMA RANGE_NODE */
   -4,  /* (62) function ::= IDENTIFIER LPAREN func_params_list RPAREN */
   -4,  /* (63) function ::= CONSTANT LPAREN func_params_list RPAREN */
   -3,  /* (64) function ::= IDENTIFIER LPAREN RPAREN */
   -3,  /* (65) function ::= CONSTANT LPAREN RPAREN */
   -1,  /* (66) func_params_list ::= arithmetic_expr */
   -3,  /* (67) func_params_list ::= func_params_list COMMA arithmetic_expr */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  DfilterTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  DfilterCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  DfilterARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* sentence ::= expr */
{ dfs->st_root = yymsp[0].minor.yy0; }
        break;
      case 1: /* sentence ::= */
{ dfs->st_root = NULL; }
        break;
      case 2: /* expr ::= relation */
      case 3: /* expr ::= arithmetic_expr */ yytestcase(yyruleno==3);
      case 9: /* atom ::= STRING */ yytestcase(yyruleno==9);
      case 10: /* atom ::= CHARCONST */ yytestcase(yyruleno==10);
      case 11: /* atom ::= LITERAL */ yytestcase(yyruleno==11);
      case 12: /* atom ::= CONSTANT */ yytestcase(yyruleno==12);
      case 21: /* entity ::= atom */ yytestcase(yyruleno==21);
      case 22: /* entity ::= slice */ yytestcase(yyruleno==22);
      case 23: /* entity ::= function */ yytestcase(yyruleno==23);
      case 24: /* entity ::= rawable_field */ yytestcase(yyruleno==24);
      case 25: /* entity ::= reference */ yytestcase(yyruleno==25);
      case 46: /* relation_test ::= comparison_test */ yytestcase(yyruleno==46);
      case 51: /* relation ::= relation_test */ yytestcase(yyruleno==51);
{ yylhsminor.yy0 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 4: /* expr ::= expr TEST_AND expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_AND, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 5: /* expr ::= expr TEST_OR expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_OR, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 6: /* expr ::= expr TEST_XOR expr */
{
    stnode_t *A = stnode_new(STTYPE_TEST, NULL, NULL, DFILTER_LOC_EMPTY);
    sttype_oper_set2(A, STNODE_OP_OR, stnode_dup(yymsp[-2].minor.yy0), stnode_dup(yymsp[0].minor.yy0));

    stnode_t *B = stnode_new(STTYPE_TEST, NULL, NULL, DFILTER_LOC_EMPTY);
    sttype_oper_set2(B, STNODE_OP_AND, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);

    stnode_t *C = stnode_new(STTYPE_TEST, NULL, NULL, DFILTER_LOC_EMPTY);
    sttype_oper_set1(C, STNODE_OP_NOT, B);

    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_AND, A, C);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 7: /* expr ::= TEST_NOT expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set1(yylhsminor.yy0, STNODE_OP_NOT, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 8: /* expr ::= LPAREN expr RPAREN */
      case 35: /* arithmetic_expr ::= LBRACE arithmetic_expr RBRACE */ yytestcase(yyruleno==35);
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-2].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 13: /* named_field ::= FIELD */
      case 15: /* layered_field ::= named_field */ yytestcase(yyruleno==15);
      case 18: /* rawable_field ::= layered_field */ yytestcase(yyruleno==18);
      case 26: /* arithmetic_expr ::= entity */ yytestcase(yyruleno==26);
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 14: /* named_field ::= IDENTIFIER */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    const char *name = stnode_token(yymsp[0].minor.yy0);
    header_field_info *hfinfo = dfilter_resolve_unparsed(dfs, name);
    if (hfinfo == NULL) {
        stnode_replace(yylhsminor.yy0, STTYPE_LITERAL, g_strdup(name));
    }
    else {
        stnode_replace(yylhsminor.yy0, STTYPE_FIELD, hfinfo);
    }
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 16: /* layered_field ::= named_field HASH LBRACKET range_node_list RBRACKET */
{
    yylhsminor.yy0 = yymsp[-4].minor.yy0;
    if (stnode_type_id(yylhsminor.yy0) != STTYPE_FIELD) {
        FAIL(dfs, yylhsminor.yy0, "\"%s\" is not a valid protocol or protocol field.", stnode_token(yylhsminor.yy0));
    }
    else {
        sttype_field_set_range(yylhsminor.yy0, yymsp[-1].minor.yy53);
    }
    g_slist_free(yymsp[-1].minor.yy53);
    stnode_merge_location(yylhsminor.yy0, yymsp[-4].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,31,&yymsp[-3].minor);
  yy_destructor(yypParser,32,&yymsp[-2].minor);
  yymsp[-4].minor.yy0 = yylhsminor.yy0;
        break;
      case 17: /* layered_field ::= named_field HASH INTEGER */
{
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
    if (stnode_type_id(yylhsminor.yy0) != STTYPE_FIELD) {
        FAIL(dfs, yylhsminor.yy0, "\"%s\" is not a valid protocol or protocol field.", stnode_token(yylhsminor.yy0));
    }
    else {
        char *err_msg = NULL;
        drange_node *range = drange_node_from_str(stnode_token(yymsp[0].minor.yy0), &err_msg);
        if (err_msg != NULL) {
            FAIL(dfs, yymsp[0].minor.yy0, "%s", err_msg);
            g_free(err_msg);
        }
        sttype_field_set_range1(yylhsminor.yy0, range);
    }
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,31,&yymsp[-1].minor);
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 19: /* rawable_field ::= ATSIGN layered_field */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    if (stnode_type_id(yylhsminor.yy0) != STTYPE_FIELD) {
        FAIL(dfs, yylhsminor.yy0, "\"%s\" is not a valid protocol or protocol field.", stnode_token(yylhsminor.yy0));
    }
    else {
        sttype_field_set_raw(yylhsminor.yy0, true);
    }
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-1].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 20: /* reference ::= DOLLAR LBRACE rawable_field RBRACE */
{
    /* convert field to reference */
    if (stnode_type_id(yymsp[-1].minor.yy0) != STTYPE_FIELD) {
        yylhsminor.yy0 = stnode_new(STTYPE_REFERENCE, NULL, NULL, stnode_location(yymsp[-1].minor.yy0));
        FAIL(dfs, yymsp[-1].minor.yy0, "\"%s\" is not a valid protocol or protocol field.", stnode_token(yymsp[-1].minor.yy0));
    }
    else {
        yylhsminor.yy0 = stnode_new(STTYPE_REFERENCE, sttype_field_hfinfo(yymsp[-1].minor.yy0), NULL, stnode_location(yymsp[-1].minor.yy0));
        sttype_field_set_drange(yylhsminor.yy0, sttype_field_drange_steal(yymsp[-1].minor.yy0));
        sttype_field_set_raw(yylhsminor.yy0, sttype_field_raw(yymsp[-1].minor.yy0));
    }
    stnode_merge_location(yylhsminor.yy0, yymsp[-3].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-1].minor.yy0);
    stnode_free(yymsp[-3].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,37,&yymsp[-2].minor);
  yymsp[-3].minor.yy0 = yylhsminor.yy0;
        break;
      case 27: /* arithmetic_expr ::= PLUS arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-1].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 28: /* arithmetic_expr ::= MINUS arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set1(yylhsminor.yy0, STNODE_OP_UNARY_MINUS, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 29: /* arithmetic_expr ::= arithmetic_expr BITWISE_AND arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_BITWISE_AND, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 30: /* arithmetic_expr ::= arithmetic_expr PLUS arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_ADD, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 31: /* arithmetic_expr ::= arithmetic_expr MINUS arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_SUBTRACT, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 32: /* arithmetic_expr ::= arithmetic_expr STAR arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_MULTIPLY, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 33: /* arithmetic_expr ::= arithmetic_expr RSLASH arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_DIVIDE, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 34: /* arithmetic_expr ::= arithmetic_expr PERCENT arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_MODULO, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 36: /* cmp_op ::= TEST_ALL_EQ */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_ALL_EQ);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 37: /* cmp_op ::= TEST_ANY_EQ */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_ANY_EQ);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 38: /* cmp_op ::= TEST_ALL_NE */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_ALL_NE);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 39: /* cmp_op ::= TEST_ANY_NE */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_ANY_NE);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 40: /* cmp_op ::= TEST_GT */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_GT);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 41: /* cmp_op ::= TEST_GE */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_GE);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 42: /* cmp_op ::= TEST_LT */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_LT);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 43: /* cmp_op ::= TEST_LE */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_oper_set_op(yylhsminor.yy0, STNODE_OP_LE);
}
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 44: /* comparison_test ::= arithmetic_expr cmp_op arithmetic_expr */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2_args(yymsp[-1].minor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 45: /* comparison_test ::= arithmetic_expr cmp_op comparison_test */
{
    stnode_t *L, *F;

    F = yymsp[0].minor.yy0;
    while (stnode_type_id(F) == STTYPE_TEST) {
        sttype_oper_get(F, NULL, &F, NULL);
    }

    L = yymsp[-1].minor.yy0;
    sttype_oper_set2_args(L, yymsp[-2].minor.yy0, stnode_dup(F));

    yylhsminor.yy0 = stnode_new_empty(STTYPE_TEST);
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_AND, L, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 47: /* relation_test ::= entity TEST_CONTAINS entity */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_CONTAINS, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 48: /* relation_test ::= entity TEST_MATCHES entity */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_MATCHES, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 49: /* relation_test ::= entity TEST_IN set */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yylhsminor.yy0, STNODE_OP_IN, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 50: /* relation_test ::= entity TEST_NOT TEST_IN set */
{
    yylhsminor.yy0 = yymsp[-1].minor.yy0;
    sttype_oper_set2(yymsp[-1].minor.yy0, STNODE_OP_NOT_IN, yymsp[-3].minor.yy0, yymsp[0].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-3].minor.yy0, yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,4,&yymsp[-2].minor);
  yymsp[-3].minor.yy0 = yylhsminor.yy0;
        break;
      case 52: /* relation ::= ANY relation_test */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_test_set_match(yylhsminor.yy0, STNODE_MATCH_ANY);
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-1].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 53: /* relation ::= ALL relation_test */
{
    yylhsminor.yy0 = yymsp[0].minor.yy0;
    sttype_test_set_match(yylhsminor.yy0, STNODE_MATCH_ALL);
    stnode_merge_location(yylhsminor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-1].minor.yy0);
}
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 54: /* set_element_list ::= arithmetic_expr */
{
    yylhsminor.yy53 = g_slist_append(NULL, yymsp[0].minor.yy0);
    yylhsminor.yy53 = g_slist_append(yylhsminor.yy53, NULL);
}
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 55: /* set_element_list ::= arithmetic_expr DOTDOT arithmetic_expr */
{
    yylhsminor.yy53 = g_slist_append(NULL, yymsp[-2].minor.yy0);
    yylhsminor.yy53 = g_slist_append(yylhsminor.yy53, yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,42,&yymsp[-1].minor);
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      case 56: /* set_list ::= set_element_list */
{
    yylhsminor.yy53 = g_slist_concat(NULL, yymsp[0].minor.yy53);
}
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 57: /* set_list ::= set_list COMMA set_element_list */
{
    yylhsminor.yy53 = g_slist_concat(yymsp[-2].minor.yy53, yymsp[0].minor.yy53);
}
  yy_destructor(yypParser,43,&yymsp[-1].minor);
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      case 58: /* set ::= LBRACE set_list RBRACE */
{
    yylhsminor.yy0 = stnode_new(STTYPE_SET, yymsp[-1].minor.yy53, NULL, DFILTER_LOC_EMPTY);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[-2].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 59: /* slice ::= entity LBRACKET range_node_list RBRACKET */
{
    yylhsminor.yy0 = stnode_new(STTYPE_SLICE, NULL, NULL, DFILTER_LOC_EMPTY);
    sttype_slice_set(yylhsminor.yy0, yymsp[-3].minor.yy0, yymsp[-1].minor.yy53);

    /* Delete the list, but not the drange_nodes that
     * the list contains. */
    g_slist_free(yymsp[-1].minor.yy53);
}
  yy_destructor(yypParser,32,&yymsp[-2].minor);
  yy_destructor(yypParser,33,&yymsp[0].minor);
  yymsp[-3].minor.yy0 = yylhsminor.yy0;
        break;
      case 60: /* range_node_list ::= RANGE_NODE */
{
    char *err_msg = NULL;
    drange_node *rn = drange_node_from_str(stnode_token(yymsp[0].minor.yy0), &err_msg);
    if (err_msg != NULL) {
        FAIL(dfs, yymsp[0].minor.yy0, "%s", err_msg);
        g_free(err_msg);
    }
    yylhsminor.yy53 = g_slist_append(NULL, rn);
    stnode_free(yymsp[0].minor.yy0);
}
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 61: /* range_node_list ::= range_node_list COMMA RANGE_NODE */
{
    char *err_msg = NULL;
    drange_node *rn = drange_node_from_str(stnode_token(yymsp[0].minor.yy0), &err_msg);
    if (err_msg != NULL) {
        FAIL(dfs, yymsp[0].minor.yy0, "%s", err_msg);
        g_free(err_msg);
    }
    yylhsminor.yy53 = g_slist_append(yymsp[-2].minor.yy53, rn);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,43,&yymsp[-1].minor);
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      case 62: /* function ::= IDENTIFIER LPAREN func_params_list RPAREN */
{
    yylhsminor.yy0 = new_function(dfs, yymsp[-3].minor.yy0);
    sttype_function_set_params(yylhsminor.yy0, yymsp[-1].minor.yy53);
    stnode_merge_location(yylhsminor.yy0, yymsp[-3].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,23,&yymsp[-2].minor);
  yymsp[-3].minor.yy0 = yylhsminor.yy0;
        break;
      case 63: /* function ::= CONSTANT LPAREN func_params_list RPAREN */
{
    FAIL(dfs, yymsp[-3].minor.yy0, "Function '%s' does not exist", stnode_token(yymsp[-3].minor.yy0));
}
  yy_destructor(yypParser,23,&yymsp[-2].minor);
  yy_destructor(yypParser,46,&yymsp[-1].minor);
  yy_destructor(yypParser,24,&yymsp[0].minor);
        break;
      case 64: /* function ::= IDENTIFIER LPAREN RPAREN */
{
    yylhsminor.yy0 = new_function(dfs, yymsp[-2].minor.yy0);
    stnode_merge_location(yylhsminor.yy0, yymsp[-2].minor.yy0, yymsp[0].minor.yy0);
    stnode_free(yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 65: /* function ::= CONSTANT LPAREN RPAREN */
{
    FAIL(dfs, yymsp[-2].minor.yy0, "Function '%s' does not exist", stnode_token(yymsp[-2].minor.yy0));
}
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,24,&yymsp[0].minor);
        break;
      case 66: /* func_params_list ::= arithmetic_expr */
{
    yylhsminor.yy53 = g_slist_append(NULL, yymsp[0].minor.yy0);
}
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 67: /* func_params_list ::= func_params_list COMMA arithmetic_expr */
{
    yylhsminor.yy53 = g_slist_append(yymsp[-2].minor.yy53, yymsp[0].minor.yy0);
}
  yy_destructor(yypParser,43,&yymsp[-1].minor);
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  DfilterARG_FETCH
  DfilterCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  DfilterARG_STORE /* Suppress warning about unused %extra_argument variable */
  DfilterCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  DfilterTOKENTYPE yyminor         /* The minor type of the error token */
){
  DfilterARG_FETCH
  DfilterCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

    if (!TOKEN) {
        dfilter_fail(dfs, DF_ERROR_UNEXPECTED_END, DFILTER_LOC_EMPTY, "Unexpected end of filter expression.");
        return;
    }
    FAIL(dfs, TOKEN, "\"%s\" was unexpected in this context.", stnode_token(TOKEN));
/************ End %syntax_error code ******************************************/
  DfilterARG_STORE /* Suppress warning about unused %extra_argument variable */
  DfilterCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  DfilterARG_FETCH
  DfilterCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  DfilterARG_STORE /* Suppress warning about unused %extra_argument variable */
  DfilterCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "DfilterAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Dfilter(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  DfilterTOKENTYPE yyminor       /* The value for the token */
  DfilterARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  DfilterCTX_FETCH
  DfilterARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
#ifndef NDEBUG
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor DfilterCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos > yypParser->yystack ){
          yyact = yy_find_reduce_action(yypParser->yytos->stateno,
                                        YYERRORSYMBOL);
          if( yyact<=YY_MAX_SHIFTREDUCE ) break;
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos <= yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int DfilterFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}

DIAG_ON_LEMON()

    static stnode_t *
    new_function(dfsyntax_t *dfs, stnode_t *node)
    {
        const char *name = stnode_token(node);

        df_func_def_t *def = df_func_lookup(name);
        if (!def) {
            FAIL(dfs, node, "Function '%s' does not exist", name);
        }
        stnode_replace(node, STTYPE_FUNCTION, def);
        return node;
    }
