/******************************************************************************
* Copyright (c) 2022 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2024, Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/* NOTE: Auto generated file from topology generation scripts */

#include <stddef.h>
#include "xpm-nodeid-cdoutil.h"
#include <unordered_map>

// Node ID to Node Name mapping
static const std::unordered_map<unsigned int, const char *> nodeid_map
{
    { PM_POWER_PMC                , "power_pmc" },
    { PM_POWER_LPD                , "power_lpd" },
    { PM_POWER_FPD                , "power_fpd" },
    { PM_POWER_NOC                , "power_noc" },
    { PM_POWER_ME                 , "power_me" },
    { PM_POWER_PLD                , "power_pld" },
    { PM_POWER_CPM                , "power_cpm" },
    { PM_POWER_PL_SYSMON          , "power_pl_sysmon" },
    { PM_POWER_RPU0_0             , "power_rpu0_0" },
    { PM_POWER_GEM0               , "power_gem0" },
    { PM_POWER_GEM1               , "power_gem1" },
    { PM_POWER_OCM_0              , "power_ocm_0" },
    { PM_POWER_OCM_1              , "power_ocm_1" },
    { PM_POWER_OCM_2              , "power_ocm_2" },
    { PM_POWER_OCM_3              , "power_ocm_3" },
    { PM_POWER_TCM_0_A            , "power_tcm_0_a" },
    { PM_POWER_TCM_0_B            , "power_tcm_0_b" },
    { PM_POWER_TCM_1_A            , "power_tcm_1_a" },
    { PM_POWER_TCM_1_B            , "power_tcm_1_b" },
    { PM_POWER_ACPU_0             , "power_acpu_0" },
    { PM_POWER_ACPU_1             , "power_acpu_1" },
    { PM_POWER_L2_BANK_0          , "power_l2_bank_0" },
    { PM_POWER_XRAM_0             , "power_xram_0" },
    { PM_POWER_XRAM_1             , "power_xram_1" },
    { PM_POWER_XRAM_2             , "power_xram_2" },
    { PM_POWER_XRAM_3             , "power_xram_3" },
    { PM_POWER_XRAM_4             , "power_xram_4" },
    { PM_POWER_XRAM_5             , "power_xram_5" },
    { PM_POWER_XRAM_6             , "power_xram_6" },
    { PM_POWER_XRAM_7             , "power_xram_7" },
    { PM_POWER_XRAM_8             , "power_xram_8" },
    { PM_POWER_XRAM_9             , "power_xram_9" },
    { PM_POWER_XRAM_10            , "power_xram_10" },
    { PM_POWER_XRAM_11            , "power_xram_11" },
    { PM_POWER_XRAM_12            , "power_xram_12" },
    { PM_POWER_XRAM_13            , "power_xram_13" },
    { PM_POWER_XRAM_14            , "power_xram_14" },
    { PM_POWER_XRAM_15            , "power_xram_15" },
    { PM_POWER_CPM5               , "power_cpm5" },
    { PM_POWER_ME2                , "power_me2" },
    { PM_POWER_VCCINT_PMC         , "power_vccint_pmc" },
    { PM_POWER_VCCAUX_PMC         , "power_vccaux_pmc" },
    { PM_POWER_VCCINT_PSLP        , "power_vccint_pslp" },
    { PM_POWER_VCCINT_PSFP        , "power_vccint_psfp" },
    { PM_POWER_VCCINT_SOC         , "power_vccint_soc" },
    { PM_POWER_VCCINT_RAM         , "power_vccint_ram" },
    { PM_POWER_VCCAUX             , "power_vccaux" },
    { PM_POWER_VCCINT_PL          , "power_vccint_pl" },
    { PM_POWER_FPD_DOMAIN_CTRL    , "power_fpd_domain_ctrl" },
    { PM_POWER_PLD_DOMAIN_CTRL    , "power_pld_domain_ctrl" },
    { PM_POWER_VCCINT_CPM5N       , "power_vccint_cpm5n" },
    { PM_POWER_HNICX              , "power_hnicx" },
    { PM_POWER_CPM5N              , "power_cpm5n" },
    { PM_POWER_ACPU_0_0           , "power_acpu_0_0" },
    { PM_POWER_ACPU_0_1           , "power_acpu_0_1" },
    { PM_POWER_ACPU_0_2           , "power_acpu_0_2" },
    { PM_POWER_ACPU_0_3           , "power_acpu_0_3" },
    { PM_POWER_ACPU_1_0           , "power_acpu_1_0" },
    { PM_POWER_ACPU_1_1           , "power_acpu_1_1" },
    { PM_POWER_ACPU_1_2           , "power_acpu_1_2" },
    { PM_POWER_ACPU_1_3           , "power_acpu_1_3" },
    { PM_POWER_ACPU_2_0           , "power_acpu_2_0" },
    { PM_POWER_ACPU_2_1           , "power_acpu_2_1" },
    { PM_POWER_ACPU_2_2           , "power_acpu_2_2" },
    { PM_POWER_ACPU_2_3           , "power_acpu_2_3" },
    { PM_POWER_ACPU_3_0           , "power_acpu_3_0" },
    { PM_POWER_ACPU_3_1           , "power_acpu_3_1" },
    { PM_POWER_ACPU_3_2           , "power_acpu_3_2" },
    { PM_POWER_ACPU_3_3           , "power_acpu_3_3" },
    { PM_POWER_RPU_A_0            , "power_rpu_a_0" },
    { PM_POWER_RPU_A_1            , "power_rpu_a_1" },
    { PM_POWER_RPU_B_0            , "power_rpu_b_0" },
    { PM_POWER_RPU_B_1            , "power_rpu_b_1" },
    { PM_POWER_OCM_0_0            , "power_ocm_0_0" },
    { PM_POWER_OCM_0_1            , "power_ocm_0_1" },
    { PM_POWER_OCM_0_2            , "power_ocm_0_2" },
    { PM_POWER_OCM_0_3            , "power_ocm_0_3" },
    { PM_POWER_OCM_1_0            , "power_ocm_1_0" },
    { PM_POWER_OCM_1_1            , "power_ocm_1_1" },
    { PM_POWER_OCM_1_2            , "power_ocm_1_2" },
    { PM_POWER_OCM_1_3            , "power_ocm_1_3" },
    { PM_POWER_VCCINT_VCU         , "power_vccint_vcu" },
    { PM_POWER_VCCINT_ISP         , "power_vccint_isp" },
    { PM_POWER_MMI                , "power_mmi" },
    { PM_POWER_VCU                , "power_vcu" },
    { PM_POWER_ISP                , "power_isp" },
    { PM_POWER_OCM_2_0            , "power_ocm_2_0" },
    { PM_POWER_OCM_2_1            , "power_ocm_2_1" },
    { PM_POWER_OCM_2_2            , "power_ocm_2_2" },
    { PM_POWER_OCM_2_3            , "power_ocm_2_3" },
    { PM_POWER_OCM_3_0            , "power_ocm_3_0" },
    { PM_POWER_OCM_3_1            , "power_ocm_3_1" },
    { PM_POWER_OCM_3_2            , "power_ocm_3_2" },
    { PM_POWER_OCM_3_3            , "power_ocm_3_3" },
    { PM_POWER_TCM_0_C            , "power_tcm_0_c" },
    { PM_POWER_TCM_0_D            , "power_tcm_0_d" },
    { PM_POWER_TCM_0_E            , "power_tcm_0_e" },
    { PM_POWER_TCM_1_C            , "power_tcm_1_c" },
    { PM_POWER_TCM_1_D            , "power_tcm_1_d" },
    { PM_POWER_TCM_1_E            , "power_tcm_1_e" },
    { PM_RST_PMC_POR              , "rst_pmc_por" },
    { PM_RST_PMC                  , "rst_pmc" },
    { PM_RST_PS_POR               , "rst_ps_por" },
    { PM_RST_PL_POR               , "rst_pl_por" },
    { PM_RST_NOC_POR              , "rst_noc_por" },
    { PM_RST_FPD_POR              , "rst_fpd_por" },
    { PM_RST_ACPU_0_POR           , "rst_acpu_0_por" },
    { PM_RST_ACPU_1_POR           , "rst_acpu_1_por" },
    { PM_RST_OCM2_POR             , "rst_ocm2_por" },
    { PM_RST_PS_SRST              , "rst_ps_srst" },
    { PM_RST_PL_SRST              , "rst_pl_srst" },
    { PM_RST_NOC                  , "rst_noc" },
    { PM_RST_NPI                  , "rst_npi" },
    { PM_RST_SYS_RST_1            , "rst_sys_rst_1" },
    { PM_RST_SYS_RST_2            , "rst_sys_rst_2" },
    { PM_RST_SYS_RST_3            , "rst_sys_rst_3" },
    { PM_RST_FPD                  , "rst_fpd" },
    { PM_RST_PL0                  , "rst_pl0" },
    { PM_RST_PL1                  , "rst_pl1" },
    { PM_RST_PL2                  , "rst_pl2" },
    { PM_RST_PL3                  , "rst_pl3" },
    { PM_RST_APU                  , "rst_apu" },
    { PM_RST_ACPU_0               , "rst_acpu_0" },
    { PM_RST_ACPU_1               , "rst_acpu_1" },
    { PM_RST_ACPU_L2              , "rst_acpu_l2" },
    { PM_RST_ACPU_GIC             , "rst_acpu_gic" },
    { PM_RST_RPU_ISLAND           , "rst_rpu_island" },
    { PM_RST_RPU_AMBA             , "rst_rpu_amba" },
    { PM_RST_R5_0                 , "rst_r5_0" },
    { PM_RST_R5_1                 , "rst_r5_1" },
    { PM_RST_SYSMON_PMC_SEQ_RST   , "rst_sysmon_pmc_seq_rst" },
    { PM_RST_SYSMON_PMC_CFG_RST   , "rst_sysmon_pmc_cfg_rst" },
    { PM_RST_SYSMON_FPD_CFG_RST   , "rst_sysmon_fpd_cfg_rst" },
    { PM_RST_SYSMON_FPD_SEQ_RST   , "rst_sysmon_fpd_seq_rst" },
    { PM_RST_SYSMON_LPD           , "rst_sysmon_lpd" },
    { PM_RST_PDMA_RST1            , "rst_pdma_rst1" },
    { PM_RST_PDMA_RST0            , "rst_pdma_rst0" },
    { PM_RST_ADMA                 , "rst_adma" },
    { PM_RST_TIMESTAMP            , "rst_timestamp" },
    { PM_RST_OCM                  , "rst_ocm" },
    { PM_RST_OCM2_RST             , "rst_ocm2_rst" },
    { PM_RST_IPI                  , "rst_ipi" },
    { PM_RST_SBI                  , "rst_sbi" },
    { PM_RST_LPD                  , "rst_lpd" },
    { PM_RST_QSPI                 , "rst_qspi" },
    { PM_RST_OSPI                 , "rst_ospi" },
    { PM_RST_SDIO_0               , "rst_sdio_0" },
    { PM_RST_SDIO_1               , "rst_sdio_1" },
    { PM_RST_I2C_PMC              , "rst_i2c_pmc" },
    { PM_RST_GPIO_PMC             , "rst_gpio_pmc" },
    { PM_RST_GEM_0                , "rst_gem_0" },
    { PM_RST_GEM_1                , "rst_gem_1" },
    { PM_RST_SPARE                , "rst_spare" },
    { PM_RST_USB_0                , "rst_usb_0" },
    { PM_RST_UART_0               , "rst_uart_0" },
    { PM_RST_UART_1               , "rst_uart_1" },
    { PM_RST_SPI_0                , "rst_spi_0" },
    { PM_RST_SPI_1                , "rst_spi_1" },
    { PM_RST_CAN_FD_0             , "rst_can_fd_0" },
    { PM_RST_CAN_FD_1             , "rst_can_fd_1" },
    { PM_RST_I2C_0                , "rst_i2c_0" },
    { PM_RST_I2C_1                , "rst_i2c_1" },
    { PM_RST_GPIO_LPD             , "rst_gpio_lpd" },
    { PM_RST_TTC_0                , "rst_ttc_0" },
    { PM_RST_TTC_1                , "rst_ttc_1" },
    { PM_RST_TTC_2                , "rst_ttc_2" },
    { PM_RST_TTC_3                , "rst_ttc_3" },
    { PM_RST_SWDT_FPD             , "rst_swdt_fpd" },
    { PM_RST_SWDT_LPD             , "rst_swdt_lpd" },
    { PM_RST_USB                  , "rst_usb" },
    { PM_RST_DPC                  , "rst_dpc" },
    { PM_RST_PMCDBG               , "rst_pmcdbg" },
    { PM_RST_DBG_TRACE            , "rst_dbg_trace" },
    { PM_RST_DBG_FPD              , "rst_dbg_fpd" },
    { PM_RST_DBG_TSTMP            , "rst_dbg_tstmp" },
    { PM_RST_RPU0_DBG             , "rst_rpu0_dbg" },
    { PM_RST_RPU1_DBG             , "rst_rpu1_dbg" },
    { PM_RST_HSDP                 , "rst_hsdp" },
    { PM_RST_DBG_LPD              , "rst_dbg_lpd" },
    { PM_RST_CPM_POR              , "rst_cpm_por" },
    { PM_RST_CPM                  , "rst_cpm" },
    { PM_RST_CPMDBG               , "rst_cpmdbg" },
    { PM_RST_PCIE_CFG             , "rst_pcie_cfg" },
    { PM_RST_PCIE_CORE0           , "rst_pcie_core0" },
    { PM_RST_PCIE_CORE1           , "rst_pcie_core1" },
    { PM_RST_PCIE_DMA             , "rst_pcie_dma" },
    { PM_RST_CMN                  , "rst_cmn" },
    { PM_RST_L2_0                 , "rst_l2_0" },
    { PM_RST_L2_1                 , "rst_l2_1" },
    { PM_RST_ADDR_REMAP           , "rst_addr_remap" },
    { PM_RST_CPI0                 , "rst_cpi0" },
    { PM_RST_CPI1                 , "rst_cpi1" },
    { PM_RST_XRAM                 , "rst_xram" },
    { PM_RST_AIE_ARRAY            , "rst_aie_array" },
    { PM_RST_AIE_SHIM             , "rst_aie_shim" },
    { PM_RST_PCIE_DMA1            , "rst_pcie_dma1" },
    { PM_RST_GTY_1                , "rst_gty_1" },
    { PM_RST_GTY_3                , "rst_gty_3" },
    { PM_RST_GTY_2                , "rst_gty_2" },
    { PM_RST_DMA_CONFIG_POR       , "rst_dma_config_por" },
    { PM_RST_CDX                  , "rst_cdx" },
    { PM_RST_PCIE0_CONFIG         , "rst_pcie0_config" },
    { PM_RST_PCIE_CONFIG_POR      , "rst_pcie_config_por" },
    { PM_RST_DPU                  , "rst_dpu" },
    { PM_RST_CDX_CONFIG           , "rst_cdx_config" },
    { PM_RST_PCIE_1               , "rst_pcie_1" },
    { PM_RST_PCIE_0               , "rst_pcie_0" },
    { PM_RST_PCIE_3               , "rst_pcie_3" },
    { PM_RST_PCIE_2               , "rst_pcie_2" },
    { PM_RST_PCIE1_CONFIG         , "rst_pcie1_config" },
    { PM_RST_PCIE3_CONFIG         , "rst_pcie3_config" },
    { PM_RST_DPU_CONFIG           , "rst_dpu_config" },
    { PM_RST_PCIE2_CONFIG         , "rst_pcie2_config" },
    { PM_RST_RAM_0                , "rst_ram_0" },
    { PM_RST_RAM_1                , "rst_ram_1" },
    { PM_RST_USB1_PHY             , "rst_usb1_phy" },
    { PM_RST_WWDT                 , "rst_wwdt" },
    { PM_RST_SYSMON_CFG_CPM5N     , "rst_sysmon_cfg_cpm5n" },
    { PM_RST_SYSMON_CFG_PMC       , "rst_sysmon_cfg_pmc" },
    { PM_RST_SYSMON_SEQ_CPM5N     , "rst_sysmon_seq_cpm5n" },
    { PM_RST_SYSMON_SEQ_PMC       , "rst_sysmon_seq_pmc" },
    { PM_RST_USB0_PHY             , "rst_usb0_phy" },
    { PM_RST_PDMA_1               , "rst_pdma_1" },
    { PM_RST_PDMA_0               , "rst_pdma_0" },
    { PM_RST_I2C                  , "rst_i2c" },
    { PM_RST_DBG_CPM5N            , "rst_dbg_cpm5n" },
    { PM_RST_DBG_PMC              , "rst_dbg_pmc" },
    { PM_RST_DBG_DPC              , "rst_dbg_dpc" },
    { PM_RST_PKI                  , "rst_pki" },
    { PM_RST_FPD_SWDT_2           , "rst_fpd_swdt_2" },
    { PM_RST_FMU                  , "rst_fmu" },
    { PM_RST_FPD_SWDT_1           , "rst_fpd_swdt_1" },
    { PM_RST_MMU_TBU_3            , "rst_mmu_tbu_3" },
    { PM_RST_MMU_GLOBAL           , "rst_mmu_global" },
    { PM_RST_MMU_TBU_4            , "rst_mmu_tbu_4" },
    { PM_RST_MMU_TBU_9            , "rst_mmu_tbu_9" },
    { PM_RST_MMU_TBU_5            , "rst_mmu_tbu_5" },
    { PM_RST_MMU_TBU_0            , "rst_mmu_tbu_0" },
    { PM_RST_MMU_TBU_7            , "rst_mmu_tbu_7" },
    { PM_RST_MMU_TBU_1            , "rst_mmu_tbu_1" },
    { PM_RST_MMU_TBU_8            , "rst_mmu_tbu_8" },
    { PM_RST_MMU_TBU_6            , "rst_mmu_tbu_6" },
    { PM_RST_MMU_TBU_10           , "rst_mmu_tbu_10" },
    { PM_RST_MMU_TBU_2            , "rst_mmu_tbu_2" },
    { PM_RST_APU3_CORE1_WARM      , "rst_apu3_core1_warm" },
    { PM_RST_APU3_CORE3_COLD      , "rst_apu3_core3_cold" },
    { PM_RST_APU3_CORE0_COLD      , "rst_apu3_core0_cold" },
    { PM_RST_APU3_CORE1_COLD      , "rst_apu3_core1_cold" },
    { PM_RST_APU3_CLUSTER_COLD    , "rst_apu3_cluster_cold" },
    { PM_RST_APU3_CORE0_WARM      , "rst_apu3_core0_warm" },
    { PM_RST_APU3_CORE2_COLD      , "rst_apu3_core2_cold" },
    { PM_RST_APU3_CORE2_WARM      , "rst_apu3_core2_warm" },
    { PM_RST_APU3_CORE3_WARM      , "rst_apu3_core3_warm" },
    { PM_RST_APU3_CLUSTER_WARM    , "rst_apu3_cluster_warm" },
    { PM_RST_FPD_SWDT_3           , "rst_fpd_swdt_3" },
    { PM_RST_APU1_CORE1_WARM      , "rst_apu1_core1_warm" },
    { PM_RST_APU1_CORE3_COLD      , "rst_apu1_core3_cold" },
    { PM_RST_APU1_CORE0_COLD      , "rst_apu1_core0_cold" },
    { PM_RST_APU1_CORE1_COLD      , "rst_apu1_core1_cold" },
    { PM_RST_APU1_CLUSTER_COLD    , "rst_apu1_cluster_cold" },
    { PM_RST_APU1_CORE0_WARM      , "rst_apu1_core0_warm" },
    { PM_RST_APU1_CORE2_COLD      , "rst_apu1_core2_cold" },
    { PM_RST_APU1_CORE2_WARM      , "rst_apu1_core2_warm" },
    { PM_RST_APU1_CORE3_WARM      , "rst_apu1_core3_warm" },
    { PM_RST_APU1_CLUSTER_WARM    , "rst_apu1_cluster_warm" },
    { PM_RST_CPI                  , "rst_cpi" },
    { PM_RST_APU0_CORE1_WARM      , "rst_apu0_core1_warm" },
    { PM_RST_APU0_CORE3_COLD      , "rst_apu0_core3_cold" },
    { PM_RST_APU0_CORE0_COLD      , "rst_apu0_core0_cold" },
    { PM_RST_APU0_CORE1_COLD      , "rst_apu0_core1_cold" },
    { PM_RST_APU0_CLUSTER_COLD    , "rst_apu0_cluster_cold" },
    { PM_RST_APU0_CORE0_WARM      , "rst_apu0_core0_warm" },
    { PM_RST_APU0_CORE2_COLD      , "rst_apu0_core2_cold" },
    { PM_RST_APU0_CORE2_WARM      , "rst_apu0_core2_warm" },
    { PM_RST_APU0_CORE3_WARM      , "rst_apu0_core3_warm" },
    { PM_RST_APU0_CLUSTER_WARM    , "rst_apu0_cluster_warm" },
    { PM_RST_FPD_SWDT_0           , "rst_fpd_swdt_0" },
    { PM_RST_APU2_CORE1_WARM      , "rst_apu2_core1_warm" },
    { PM_RST_APU2_CORE3_COLD      , "rst_apu2_core3_cold" },
    { PM_RST_APU2_CORE0_COLD      , "rst_apu2_core0_cold" },
    { PM_RST_APU2_CORE1_COLD      , "rst_apu2_core1_cold" },
    { PM_RST_APU2_CLUSTER_COLD    , "rst_apu2_cluster_cold" },
    { PM_RST_APU2_CORE0_WARM      , "rst_apu2_core0_warm" },
    { PM_RST_APU2_CORE2_COLD      , "rst_apu2_core2_cold" },
    { PM_RST_APU2_CORE2_WARM      , "rst_apu2_core2_warm" },
    { PM_RST_APU2_CORE3_WARM      , "rst_apu2_core3_warm" },
    { PM_RST_APU2_CLUSTER_WARM    , "rst_apu2_cluster_warm" },
    { PM_RST_CMN_CXS              , "rst_cmn_cxs" },
    { PM_RST_CMN_CGL              , "rst_cmn_cgl" },
    { PM_RST_USB_1                , "rst_usb_1" },
    { PM_RST_SWDT_1               , "rst_swdt_1" },
    { PM_RST_SWDT_0               , "rst_swdt_0" },
    { PM_RST_RPU_A_GD             , "rst_rpu_a_gd" },
    { PM_RST_RPU_B_GD             , "rst_rpu_b_gd" },
    { PM_RST_RPU_CORE0A           , "rst_rpu_core0a" },
    { PM_RST_RPU_CORE0A_POR       , "rst_rpu_core0a_por" },
    { PM_RST_RPU_CORE0B_POR       , "rst_rpu_core0b_por" },
    { PM_RST_RPU_A_GD_TOP         , "rst_rpu_a_gd_top" },
    { PM_RST_RPU_CORE1B           , "rst_rpu_core1b" },
    { PM_RST_RPU_B_TOPRESET       , "rst_rpu_b_topreset" },
    { PM_RST_RPU_CORE1B_POR       , "rst_rpu_core1b_por" },
    { PM_RST_RPU_CORE1A           , "rst_rpu_core1a" },
    { PM_RST_RPU_B_GD_TOP         , "rst_rpu_b_gd_top" },
    { PM_RST_RPU_A_TOPRESET       , "rst_rpu_a_topreset" },
    { PM_RST_RPU_B_DBGRST         , "rst_rpu_b_dbgrst" },
    { PM_RST_RPU_A_DCLS_TOPRESET  , "rst_rpu_a_dcls_topreset" },
    { PM_RST_RPU_CORE1A_POR       , "rst_rpu_core1a_por" },
    { PM_RST_RPU_B_DCLS_TOPRESET  , "rst_rpu_b_dcls_topreset" },
    { PM_RST_RPU_A_DBGRST         , "rst_rpu_a_dbgrst" },
    { PM_RST_RPU_CORE0B           , "rst_rpu_core0b" },
    { PM_RST_SYSMON_CFG_FPD       , "rst_sysmon_cfg_fpd" },
    { PM_RST_SYSMON_CFG_LPD       , "rst_sysmon_cfg_lpd" },
    { PM_RST_SYSMON_SEQ_FPD       , "rst_sysmon_seq_fpd" },
    { PM_RST_SYSMON_SEQ_LPD       , "rst_sysmon_seq_lpd" },
    { PM_RST_I3C_1                , "rst_i3c_1" },
    { PM_RST_I3C_0                , "rst_i3c_0" },
    { PM_RST_FPD_SRST             , "rst_fpd_srst" },
    { PM_RST_DBG_LPD_HSDP         , "rst_dbg_lpd_hsdp" },
    { PM_RST_PSM_MODE_WAKEUP      , "rst_psm_mode_wakeup" },
    { PM_RST_PSM_MODE_MODE        , "rst_psm_mode_mode" },
    { PM_RST_TIMESTAMP_FPD        , "rst_timestamp_fpd" },
    { PM_RST_TIMESTAMP_LPD        , "rst_timestamp_lpd" },
    { PM_RST_SWDT_4               , "rst_swdt_4" },
    { PM_RST_SWDT_3               , "rst_swdt_3" },
    { PM_RST_SWDT_2               , "rst_swdt_2" },
    { PM_RST_OCM_3                , "rst_ocm_3" },
    { PM_RST_OCM_2                , "rst_ocm_2" },
    { PM_RST_OCM_1                , "rst_ocm_1" },
    { PM_RST_OCM_0                , "rst_ocm_0" },
    { PM_RST_ASU_GD_TOP           , "rst_asu_gd_top" },
    { PM_RST_ASU_GD               , "rst_asu_gd" },
    { PM_RST_RPU_GD_0_TOP         , "rst_rpu_gd_0_top" },
    { PM_RST_RPU_GD_0             , "rst_rpu_gd_0" },
    { PM_RST_RPU_GD_1_TOP         , "rst_rpu_gd_1_top" },
    { PM_RST_RPU_GD_1             , "rst_rpu_gd_1" },
    { PM_RST_RPU_CORE1C           , "rst_rpu_core1c" },
    { PM_RST_RPU_C_TOPRESET       , "rst_rpu_c_topreset" },
    { PM_RST_RPU_CORE1C_POR       , "rst_rpu_core1c_por" },
    { PM_RST_RPU_CORE0C           , "rst_rpu_core0c" },
    { PM_RST_RPU_CORE0C_POR       , "rst_rpu_core0c_por" },
    { PM_RST_RPU_CORE1E           , "rst_rpu_core1e" },
    { PM_RST_RPU_E_TOPRESET       , "rst_rpu_e_topreset" },
    { PM_RST_RPU_CORE1E_POR       , "rst_rpu_core1e_por" },
    { PM_RST_RPU_CORE0E           , "rst_rpu_core0e" },
    { PM_RST_RPU_CORE0E_POR       , "rst_rpu_core0e_por" },
    { PM_RST_RPU_CORE1D           , "rst_rpu_core1d" },
    { PM_RST_RPU_D_TOPRESET       , "rst_rpu_d_topreset" },
    { PM_RST_RPU_CORE1D_POR       , "rst_rpu_core1d_por" },
    { PM_RST_RPU_CORE0D           , "rst_rpu_core0d" },
    { PM_RST_RPU_CORE0D_POR       , "rst_rpu_core0d_por" },
    { PM_CLK_PMC_PLL              , "clk_pmc_pll" },
    { PM_CLK_APU_PLL              , "clk_apu_pll" },
    { PM_CLK_RPU_PLL              , "clk_rpu_pll" },
    { PM_CLK_CPM_PLL              , "clk_cpm_pll" },
    { PM_CLK_NOC_PLL              , "clk_noc_pll" },
    { PM_CLK_PMC_PRESRC           , "clk_pmc_presrc" },
    { PM_CLK_PMC_POSTCLK          , "clk_pmc_postclk" },
    { PM_CLK_PMC_PLL_OUT          , "clk_pmc_pll_out" },
    { PM_CLK_PPLL                 , "clk_ppll" },
    { PM_CLK_NOC_PRESRC           , "clk_noc_presrc" },
    { PM_CLK_NOC_POSTCLK          , "clk_noc_postclk" },
    { PM_CLK_NOC_PLL_OUT          , "clk_noc_pll_out" },
    { PM_CLK_NPLL                 , "clk_npll" },
    { PM_CLK_APU_PRESRC           , "clk_apu_presrc" },
    { PM_CLK_APU_POSTCLK          , "clk_apu_postclk" },
    { PM_CLK_APU_PLL_OUT          , "clk_apu_pll_out" },
    { PM_CLK_APLL                 , "clk_apll" },
    { PM_CLK_RPU_PRESRC           , "clk_rpu_presrc" },
    { PM_CLK_RPU_POSTCLK          , "clk_rpu_postclk" },
    { PM_CLK_RPU_PLL_OUT          , "clk_rpu_pll_out" },
    { PM_CLK_RPLL                 , "clk_rpll" },
    { PM_CLK_CPM_PRESRC           , "clk_cpm_presrc" },
    { PM_CLK_CPM_POSTCLK          , "clk_cpm_postclk" },
    { PM_CLK_CPM_PLL_OUT          , "clk_cpm_pll_out" },
    { PM_CLK_CPLL                 , "clk_cpll" },
    { PM_CLK_PPLL_TO_XPD          , "clk_ppll_to_xpd" },
    { PM_CLK_NPLL_TO_XPD          , "clk_npll_to_xpd" },
    { PM_CLK_APLL_TO_XPD          , "clk_apll_to_xpd" },
    { PM_CLK_RPLL_TO_XPD          , "clk_rpll_to_xpd" },
    { PM_CLK_EFUSE_REF            , "clk_efuse_ref" },
    { PM_CLK_SYSMON_REF           , "clk_sysmon_ref" },
    { PM_CLK_IRO_SUSPEND_REF      , "clk_iro_suspend_ref" },
    { PM_CLK_USB_SUSPEND          , "clk_usb_suspend" },
    { PM_CLK_SWITCH_TIMEOUT       , "clk_switch_timeout" },
    { PM_CLK_RCLK_PMC             , "clk_rclk_pmc" },
    { PM_CLK_RCLK_LPD             , "clk_rclk_lpd" },
    { PM_CLK_WDT                  , "clk_wdt" },
    { PM_CLK_TTC0                 , "clk_ttc0" },
    { PM_CLK_TTC1                 , "clk_ttc1" },
    { PM_CLK_TTC2                 , "clk_ttc2" },
    { PM_CLK_TTC3                 , "clk_ttc3" },
    { PM_CLK_GEM_TSU              , "clk_gem_tsu" },
    { PM_CLK_GEM_TSU_LB           , "clk_gem_tsu_lb" },
    { PM_CLK_MUXED_IRO_DIV2       , "clk_muxed_iro_div2" },
    { PM_CLK_MUXED_IRO_DIV4       , "clk_muxed_iro_div4" },
    { PM_CLK_PSM_REF              , "clk_psm_ref" },
    { PM_CLK_GEM0_RX              , "clk_gem0_rx" },
    { PM_CLK_GEM0_TX              , "clk_gem0_tx" },
    { PM_CLK_GEM1_RX              , "clk_gem1_rx" },
    { PM_CLK_GEM1_TX              , "clk_gem1_tx" },
    { PM_CLK_CPM_CORE_REF         , "clk_cpm_core_ref" },
    { PM_CLK_CPM_LSBUS_REF        , "clk_cpm_lsbus_ref" },
    { PM_CLK_CPM_DBG_REF          , "clk_cpm_dbg_ref" },
    { PM_CLK_CPM_AUX0_REF         , "clk_cpm_aux0_ref" },
    { PM_CLK_CPM_AUX1_REF         , "clk_cpm_aux1_ref" },
    { PM_CLK_QSPI_REF             , "clk_qspi_ref" },
    { PM_CLK_OSPI_REF             , "clk_ospi_ref" },
    { PM_CLK_SDIO0_REF            , "clk_sdio0_ref" },
    { PM_CLK_SDIO1_REF            , "clk_sdio1_ref" },
    { PM_CLK_PMC_LSBUS_REF        , "clk_pmc_lsbus_ref" },
    { PM_CLK_I2C_REF              , "clk_i2c_ref" },
    { PM_CLK_TEST_PATTERN_REF     , "clk_test_pattern_ref" },
    { PM_CLK_DFT_OSC_REF          , "clk_dft_osc_ref" },
    { PM_CLK_PMC_PL0_REF          , "clk_pmc_pl0_ref" },
    { PM_CLK_PMC_PL1_REF          , "clk_pmc_pl1_ref" },
    { PM_CLK_PMC_PL2_REF          , "clk_pmc_pl2_ref" },
    { PM_CLK_PMC_PL3_REF          , "clk_pmc_pl3_ref" },
    { PM_CLK_CFU_REF              , "clk_cfu_ref" },
    { PM_CLK_SPARE_REF            , "clk_spare_ref" },
    { PM_CLK_NPI_REF              , "clk_npi_ref" },
    { PM_CLK_HSM0_REF             , "clk_hsm0_ref" },
    { PM_CLK_HSM1_REF             , "clk_hsm1_ref" },
    { PM_CLK_SD_DLL_REF           , "clk_sd_dll_ref" },
    { PM_CLK_FPD_TOP_SWITCH       , "clk_fpd_top_switch" },
    { PM_CLK_FPD_LSBUS            , "clk_fpd_lsbus" },
    { PM_CLK_ACPU                 , "clk_acpu" },
    { PM_CLK_DBG_TRACE            , "clk_dbg_trace" },
    { PM_CLK_DBG_FPD              , "clk_dbg_fpd" },
    { PM_CLK_LPD_TOP_SWITCH       , "clk_lpd_top_switch" },
    { PM_CLK_ADMA                 , "clk_adma" },
    { PM_CLK_LPD_LSBUS            , "clk_lpd_lsbus" },
    { PM_CLK_CPU_R5               , "clk_cpu_r5" },
    { PM_CLK_CPU_R5_CORE          , "clk_cpu_r5_core" },
    { PM_CLK_CPU_R5_OCM           , "clk_cpu_r5_ocm" },
    { PM_CLK_CPU_R5_OCM2          , "clk_cpu_r5_ocm2" },
    { PM_CLK_IOU_SWITCH           , "clk_iou_switch" },
    { PM_CLK_GEM0_REF             , "clk_gem0_ref" },
    { PM_CLK_GEM1_REF             , "clk_gem1_ref" },
    { PM_CLK_GEM_TSU_REF          , "clk_gem_tsu_ref" },
    { PM_CLK_USB0_BUS_REF         , "clk_usb0_bus_ref" },
    { PM_CLK_UART0_REF            , "clk_uart0_ref" },
    { PM_CLK_UART1_REF            , "clk_uart1_ref" },
    { PM_CLK_SPI0_REF             , "clk_spi0_ref" },
    { PM_CLK_SPI1_REF             , "clk_spi1_ref" },
    { PM_CLK_CAN0_REF             , "clk_can0_ref" },
    { PM_CLK_CAN1_REF             , "clk_can1_ref" },
    { PM_CLK_I2C0_REF             , "clk_i2c0_ref" },
    { PM_CLK_I2C1_REF             , "clk_i2c1_ref" },
    { PM_CLK_DBG_LPD              , "clk_dbg_lpd" },
    { PM_CLK_TIMESTAMP_REF        , "clk_timestamp_ref" },
    { PM_CLK_DBG_TSTMP            , "clk_dbg_tstmp" },
    { PM_CLK_CPM_TOPSW_REF        , "clk_cpm_topsw_ref" },
    { PM_CLK_USB3_DUAL_REF        , "clk_usb3_dual_ref" },
    { PM_CLK_REF_CLK              , "clk_ref_clk" },
    { PM_CLK_PL_ALT_REF_CLK       , "clk_pl_alt_ref_clk" },
    { PM_CLK_MUXED_IRO            , "clk_muxed_iro" },
    { PM_CLK_PL_EXT               , "clk_pl_ext" },
    { PM_CLK_PL_LB                , "clk_pl_lb" },
    { PM_CLK_MIO_50_OR_51         , "clk_mio_50_or_51" },
    { PM_CLK_MIO_24_OR_25         , "clk_mio_24_or_25" },
    { PM_CLK_EMIO                 , "clk_emio" },
    { PM_CLK_MIO                  , "clk_mio" },
    { PM_CLK_XRAM_MAIN_CLK        , "clk_xram_main_clk" },
    { PM_CLK_XRAM_APB             , "clk_xram_apb" },
    { PM_CLK_PL_PMC_ALT_REF_CLK   , "clk_pl_pmc_alt_ref_clk" },
    { PM_CLK_PL_LPD_ALT_REF_CLK   , "clk_pl_lpd_alt_ref_clk" },
    { PM_CLK_PL_FPD_ALT_REF_CLK   , "clk_pl_fpd_alt_ref_clk" },
    { PM_CLK_CPM_DMA_ALT_REF      , "clk_cpm_dma_alt_ref" },
    { PM_CLK_CPM_AUX2_REF         , "clk_cpm_aux2_ref" },
    { PM_CLK_CPM5N_PRESRC         , "clk_cpm5n_presrc" },
    { PM_CLK_CPM5N_POSTCLK        , "clk_cpm5n_postclk" },
    { PM_CLK_CPM5N_PLL_OUT        , "clk_cpm5n_pll_out" },
    { PM_CLK_APU1_PRESRC          , "clk_apu1_presrc" },
    { PM_CLK_APU1_POSTCLK         , "clk_apu1_postclk" },
    { PM_CLK_APU_PLL1_OUT         , "clk_apu_pll1_out" },
    { PM_CLK_APLL1                , "clk_apll1" },
    { PM_CLK_APU2_PRESRC          , "clk_apu2_presrc" },
    { PM_CLK_APU2_POSTCLK         , "clk_apu2_postclk" },
    { PM_CLK_APU_PLL2_OUT         , "clk_apu_pll2_out" },
    { PM_CLK_APLL2                , "clk_apll2" },
    { PM_CLK_FLX_PRESRC           , "clk_flx_presrc" },
    { PM_CLK_FLX_POSTCLK          , "clk_flx_postclk" },
    { PM_CLK_FLX_PLL_OUT          , "clk_flx_pll_out" },
    { PM_CLK_FLXPLL               , "clk_flxpll" },
    { PM_CLK_IRO                  , "clk_iro" },
    { PM_CLK_IN_REF               , "clk_in_ref" },
    { PM_CLK_OSCCLK_DIV2          , "clk_oscclk_div2" },
    { PM_CLK_CPM5N_DBG_REF        , "clk_cpm5n_dbg_ref" },
    { PM_CLK_CPM5N_AUX1_REF       , "clk_cpm5n_aux1_ref" },
    { PM_CLK_CPM5N_TOPSW_REF      , "clk_cpm5n_topsw_ref" },
    { PM_CLK_CPM5N_AUX0_REF       , "clk_cpm5n_aux0_ref" },
    { PM_CLK_CPM5N_DMA_ALT        , "clk_cpm5n_dma_alt" },
    { PM_CLK_CPM5N_AUX2_REF       , "clk_cpm5n_aux2_ref" },
    { PM_CLK_CPM5N_CORE_REF       , "clk_cpm5n_core_ref" },
    { PM_CLK_PMC_RCLK             , "clk_pmc_rclk" },
    { PM_CLK_FPD_RCLK             , "clk_fpd_rclk" },
    { PM_CLK_FPD_WWDT_PLL         , "clk_fpd_wwdt_pll" },
    { PM_CLK_PERIPH               , "clk_periph" },
    { PM_CLK_ACPU0                , "clk_acpu0" },
    { PM_CLK_ACPU3                , "clk_acpu3" },
    { PM_CLK_ACPU2                , "clk_acpu2" },
    { PM_CLK_ACPU1                , "clk_acpu1" },
    { PM_CLK_FPD_PKI_DIV          , "clk_fpd_pki_div" },
    { PM_CLK_I3C0_REF             , "clk_i3c0_ref" },
    { PM_CLK_CAN0_REF_2X          , "clk_can0_ref_2x" },
    { PM_CLK_I3C1_REF             , "clk_i3c1_ref" },
    { PM_CLK_LPD_RCLK             , "clk_lpd_rclk" },
    { PM_CLK_GEM1_REF_TX          , "clk_gem1_ref_tx" },
    { PM_CLK_GEM1_REF_RX          , "clk_gem1_ref_rx" },
    { PM_CLK_RPU                  , "clk_rpu" },
    { PM_CLK_RPU_OCM              , "clk_rpu_ocm" },
    { PM_CLK_RPU_XRAM             , "clk_rpu_xram" },
    { PM_CLK_RPU_CLUSTERB         , "clk_rpu_clusterb" },
    { PM_CLK_RPU_CLUSTERA         , "clk_rpu_clustera" },
    { PM_CLK_GEM0_REF_TX          , "clk_gem0_ref_tx" },
    { PM_CLK_GEM0_REF_RX          , "clk_gem0_ref_rx" },
    { PM_CLK_PSM                  , "clk_psm" },
    { PM_CLK_CPM_TOPSW            , "clk_cpm_topsw" },
    { PM_CLK_CAN1_REF_2X          , "clk_can1_ref_2x" },
    { PM_CLK_LPD_WWDT_PLL         , "clk_lpd_wwdt_pll" },
    { PM_CLK_USB1_BUS_REF         , "clk_usb1_bus_ref" },
    { PM_CLK_FPD_TOPSW_MUX        , "clk_fpd_topsw_mux" },
    { PM_CLK_CPM5N_PLL            , "clk_cpm5n_pll" },
    { PM_CLK_APU_PLL1             , "clk_apu_pll1" },
    { PM_CLK_APU_PLL2             , "clk_apu_pll2" },
    { PM_CLK_FLX_PLL              , "clk_flx_pll" },
    { PM_CLK_FPD_WWDT0            , "clk_fpd_wwdt0" },
    { PM_CLK_FPD_WWDT1            , "clk_fpd_wwdt1" },
    { PM_CLK_FPD_WWDT2            , "clk_fpd_wwdt2" },
    { PM_CLK_FPD_WWDT3            , "clk_fpd_wwdt3" },
    { PM_CLK_LPD_WWDT0            , "clk_lpd_wwdt0" },
    { PM_CLK_LPD_WWDT1            , "clk_lpd_wwdt1" },
    { PM_CLK_MMI_TOPSW            , "clk_mmi_topsw" },
    { PM_CLK_I3C4_REF             , "clk_i3c4_ref" },
    { PM_CLK_I3C3_REF             , "clk_i3c3_ref" },
    { PM_CLK_I3C2_REF             , "clk_i3c2_ref" },
    { PM_CLK_RPU_CLUSTERC         , "clk_rpu_clusterc" },
    { PM_CLK_RPU_CLUSTERD         , "clk_rpu_clusterd" },
    { PM_CLK_RPU_CLUSTERE         , "clk_rpu_clustere" },
    { PM_CLK_CAN2_REF_2X          , "clk_can2_ref_2x" },
    { PM_CLK_LPD_TOP_SWITCH_SDMA  , "clk_lpd_top_switch_sdma" },
    { PM_CLK_I3C7_REF             , "clk_i3c7_ref" },
    { PM_CLK_I3C6_REF             , "clk_i3c6_ref" },
    { PM_CLK_ASU                  , "clk_asu" },
    { PM_CLK_CAN3_REF_2X          , "clk_can3_ref_2x" },
    { PM_CLK_I3C5_REF             , "clk_i3c5_ref" },
    { PM_CLK_DC_RCLK              , "clk_dc_rclk" },
    { PM_CLK_MMI_DBG              , "clk_mmi_dbg" },
    { PM_CLK_UFS_REF              , "clk_ufs_ref" },
    { PM_CLK_RCLK_MMI             , "clk_rclk_mmi" },
    { PM_CLK_LPD_WWDT2            , "clk_lpd_wwdt2" },
    { PM_CLK_LPD_WWDT3            , "clk_lpd_wwdt3" },
    { PM_CLK_LPD_WWDT4            , "clk_lpd_wwdt4" },
    { PM_STMIC_LMIO_0             , "stmic_lmio_0" },
    { PM_STMIC_LMIO_1             , "stmic_lmio_1" },
    { PM_STMIC_LMIO_2             , "stmic_lmio_2" },
    { PM_STMIC_LMIO_3             , "stmic_lmio_3" },
    { PM_STMIC_LMIO_4             , "stmic_lmio_4" },
    { PM_STMIC_LMIO_5             , "stmic_lmio_5" },
    { PM_STMIC_LMIO_6             , "stmic_lmio_6" },
    { PM_STMIC_LMIO_7             , "stmic_lmio_7" },
    { PM_STMIC_LMIO_8             , "stmic_lmio_8" },
    { PM_STMIC_LMIO_9             , "stmic_lmio_9" },
    { PM_STMIC_LMIO_10            , "stmic_lmio_10" },
    { PM_STMIC_LMIO_11            , "stmic_lmio_11" },
    { PM_STMIC_LMIO_12            , "stmic_lmio_12" },
    { PM_STMIC_LMIO_13            , "stmic_lmio_13" },
    { PM_STMIC_LMIO_14            , "stmic_lmio_14" },
    { PM_STMIC_LMIO_15            , "stmic_lmio_15" },
    { PM_STMIC_LMIO_16            , "stmic_lmio_16" },
    { PM_STMIC_LMIO_17            , "stmic_lmio_17" },
    { PM_STMIC_LMIO_18            , "stmic_lmio_18" },
    { PM_STMIC_LMIO_19            , "stmic_lmio_19" },
    { PM_STMIC_LMIO_20            , "stmic_lmio_20" },
    { PM_STMIC_LMIO_21            , "stmic_lmio_21" },
    { PM_STMIC_LMIO_22            , "stmic_lmio_22" },
    { PM_STMIC_LMIO_23            , "stmic_lmio_23" },
    { PM_STMIC_LMIO_24            , "stmic_lmio_24" },
    { PM_STMIC_LMIO_25            , "stmic_lmio_25" },
    { PM_STMIC_PMIO_0             , "stmic_pmio_0" },
    { PM_STMIC_PMIO_1             , "stmic_pmio_1" },
    { PM_STMIC_PMIO_2             , "stmic_pmio_2" },
    { PM_STMIC_PMIO_3             , "stmic_pmio_3" },
    { PM_STMIC_PMIO_4             , "stmic_pmio_4" },
    { PM_STMIC_PMIO_5             , "stmic_pmio_5" },
    { PM_STMIC_PMIO_6             , "stmic_pmio_6" },
    { PM_STMIC_PMIO_7             , "stmic_pmio_7" },
    { PM_STMIC_PMIO_8             , "stmic_pmio_8" },
    { PM_STMIC_PMIO_9             , "stmic_pmio_9" },
    { PM_STMIC_PMIO_10            , "stmic_pmio_10" },
    { PM_STMIC_PMIO_11            , "stmic_pmio_11" },
    { PM_STMIC_PMIO_12            , "stmic_pmio_12" },
    { PM_STMIC_PMIO_13            , "stmic_pmio_13" },
    { PM_STMIC_PMIO_14            , "stmic_pmio_14" },
    { PM_STMIC_PMIO_15            , "stmic_pmio_15" },
    { PM_STMIC_PMIO_16            , "stmic_pmio_16" },
    { PM_STMIC_PMIO_17            , "stmic_pmio_17" },
    { PM_STMIC_PMIO_18            , "stmic_pmio_18" },
    { PM_STMIC_PMIO_19            , "stmic_pmio_19" },
    { PM_STMIC_PMIO_20            , "stmic_pmio_20" },
    { PM_STMIC_PMIO_21            , "stmic_pmio_21" },
    { PM_STMIC_PMIO_22            , "stmic_pmio_22" },
    { PM_STMIC_PMIO_23            , "stmic_pmio_23" },
    { PM_STMIC_PMIO_24            , "stmic_pmio_24" },
    { PM_STMIC_PMIO_25            , "stmic_pmio_25" },
    { PM_STMIC_PMIO_26            , "stmic_pmio_26" },
    { PM_STMIC_PMIO_27            , "stmic_pmio_27" },
    { PM_STMIC_PMIO_28            , "stmic_pmio_28" },
    { PM_STMIC_PMIO_29            , "stmic_pmio_29" },
    { PM_STMIC_PMIO_30            , "stmic_pmio_30" },
    { PM_STMIC_PMIO_31            , "stmic_pmio_31" },
    { PM_STMIC_PMIO_32            , "stmic_pmio_32" },
    { PM_STMIC_PMIO_33            , "stmic_pmio_33" },
    { PM_STMIC_PMIO_34            , "stmic_pmio_34" },
    { PM_STMIC_PMIO_35            , "stmic_pmio_35" },
    { PM_STMIC_PMIO_36            , "stmic_pmio_36" },
    { PM_STMIC_PMIO_37            , "stmic_pmio_37" },
    { PM_STMIC_PMIO_38            , "stmic_pmio_38" },
    { PM_STMIC_PMIO_39            , "stmic_pmio_39" },
    { PM_STMIC_PMIO_40            , "stmic_pmio_40" },
    { PM_STMIC_PMIO_41            , "stmic_pmio_41" },
    { PM_STMIC_PMIO_42            , "stmic_pmio_42" },
    { PM_STMIC_PMIO_43            , "stmic_pmio_43" },
    { PM_STMIC_PMIO_44            , "stmic_pmio_44" },
    { PM_STMIC_PMIO_45            , "stmic_pmio_45" },
    { PM_STMIC_PMIO_46            , "stmic_pmio_46" },
    { PM_STMIC_PMIO_47            , "stmic_pmio_47" },
    { PM_STMIC_PMIO_48            , "stmic_pmio_48" },
    { PM_STMIC_PMIO_49            , "stmic_pmio_49" },
    { PM_STMIC_PMIO_50            , "stmic_pmio_50" },
    { PM_STMIC_PMIO_51            , "stmic_pmio_51" },
    { PM_DEV_PLD_0                , "dev_pld_0" },
    { PM_DEV_PMC_PROC             , "dev_pmc_proc" },
    { PM_DEV_PSM_PROC             , "dev_psm_proc" },
    { PM_DEV_ACPU_0               , "dev_acpu_0" },
    { PM_DEV_ACPU_1               , "dev_acpu_1" },
    { PM_DEV_RPU0_0               , "dev_rpu0_0" },
    { PM_DEV_RPU0_1               , "dev_rpu0_1" },
    { PM_DEV_OCM_0                , "dev_ocm_0" },
    { PM_DEV_OCM_1                , "dev_ocm_1" },
    { PM_DEV_OCM_2                , "dev_ocm_2" },
    { PM_DEV_OCM_3                , "dev_ocm_3" },
    { PM_DEV_TCM_0_A              , "dev_tcm_0_a" },
    { PM_DEV_TCM_0_B              , "dev_tcm_0_b" },
    { PM_DEV_TCM_1_A              , "dev_tcm_1_a" },
    { PM_DEV_TCM_1_B              , "dev_tcm_1_b" },
    { PM_DEV_L2_BANK_0            , "dev_l2_bank_0" },
    { PM_DEV_DDR_0                , "dev_ddr_0" },
    { PM_DEV_DDR_1                , "dev_ddr_1" },
    { PM_DEV_DDR_2                , "dev_ddr_2" },
    { PM_DEV_DDR_3                , "dev_ddr_3" },
    { PM_DEV_DDR_4                , "dev_ddr_4" },
    { PM_DEV_DDR_5                , "dev_ddr_5" },
    { PM_DEV_DDR_6                , "dev_ddr_6" },
    { PM_DEV_DDR_7                , "dev_ddr_7" },
    { PM_DEV_USB_0                , "dev_usb_0" },
    { PM_DEV_GEM_0                , "dev_gem_0" },
    { PM_DEV_GEM_1                , "dev_gem_1" },
    { PM_DEV_SPI_0                , "dev_spi_0" },
    { PM_DEV_SPI_1                , "dev_spi_1" },
    { PM_DEV_I2C_0                , "dev_i2c_0" },
    { PM_DEV_I2C_1                , "dev_i2c_1" },
    { PM_DEV_CAN_FD_0             , "dev_can_fd_0" },
    { PM_DEV_CAN_FD_1             , "dev_can_fd_1" },
    { PM_DEV_UART_0               , "dev_uart_0" },
    { PM_DEV_UART_1               , "dev_uart_1" },
    { PM_DEV_GPIO                 , "dev_gpio" },
    { PM_DEV_TTC_0                , "dev_ttc_0" },
    { PM_DEV_TTC_1                , "dev_ttc_1" },
    { PM_DEV_TTC_2                , "dev_ttc_2" },
    { PM_DEV_TTC_3                , "dev_ttc_3" },
    { PM_DEV_SWDT_LPD             , "dev_swdt_lpd" },
    { PM_DEV_SWDT_FPD             , "dev_swdt_fpd" },
    { PM_DEV_OSPI                 , "dev_ospi" },
    { PM_DEV_QSPI                 , "dev_qspi" },
    { PM_DEV_GPIO_PMC             , "dev_gpio_pmc" },
    { PM_DEV_I2C_PMC              , "dev_i2c_pmc" },
    { PM_DEV_SDIO_0               , "dev_sdio_0" },
    { PM_DEV_SDIO_1               , "dev_sdio_1" },
    { PM_DEV_RTC                  , "dev_rtc" },
    { PM_DEV_ADMA_0               , "dev_adma_0" },
    { PM_DEV_ADMA_1               , "dev_adma_1" },
    { PM_DEV_ADMA_2               , "dev_adma_2" },
    { PM_DEV_ADMA_3               , "dev_adma_3" },
    { PM_DEV_ADMA_4               , "dev_adma_4" },
    { PM_DEV_ADMA_5               , "dev_adma_5" },
    { PM_DEV_ADMA_6               , "dev_adma_6" },
    { PM_DEV_ADMA_7               , "dev_adma_7" },
    { PM_DEV_IPI_0                , "dev_ipi_0" },
    { PM_DEV_IPI_1                , "dev_ipi_1" },
    { PM_DEV_IPI_2                , "dev_ipi_2" },
    { PM_DEV_IPI_3                , "dev_ipi_3" },
    { PM_DEV_IPI_4                , "dev_ipi_4" },
    { PM_DEV_IPI_5                , "dev_ipi_5" },
    { PM_DEV_IPI_6                , "dev_ipi_6" },
    { PM_DEV_SOC                  , "dev_soc" },
    { PM_DEV_DDRMC_0              , "dev_ddrmc_0" },
    { PM_DEV_DDRMC_1              , "dev_ddrmc_1" },
    { PM_DEV_DDRMC_2              , "dev_ddrmc_2" },
    { PM_DEV_DDRMC_3              , "dev_ddrmc_3" },
    { PM_DEV_GT_0                 , "dev_gt_0" },
    { PM_DEV_GT_1                 , "dev_gt_1" },
    { PM_DEV_GT_2                 , "dev_gt_2" },
    { PM_DEV_GT_3                 , "dev_gt_3" },
    { PM_DEV_GT_4                 , "dev_gt_4" },
    { PM_DEV_GT_5                 , "dev_gt_5" },
    { PM_DEV_GT_6                 , "dev_gt_6" },
    { PM_DEV_GT_7                 , "dev_gt_7" },
    { PM_DEV_GT_8                 , "dev_gt_8" },
    { PM_DEV_GT_9                 , "dev_gt_9" },
    { PM_DEV_GT_10                , "dev_gt_10" },
    { PM_DEV_EFUSE_CACHE          , "dev_efuse_cache" },
    { PM_DEV_AMS_ROOT             , "dev_ams_root" },
    { PM_DEV_XRAM_0               , "dev_xram_0" },
    { PM_DEV_XRAM_1               , "dev_xram_1" },
    { PM_DEV_XRAM_2               , "dev_xram_2" },
    { PM_DEV_XRAM_3               , "dev_xram_3" },
    { PM_DEV_XRAM_4               , "dev_xram_4" },
    { PM_DEV_XRAM_5               , "dev_xram_5" },
    { PM_DEV_XRAM_6               , "dev_xram_6" },
    { PM_DEV_XRAM_7               , "dev_xram_7" },
    { PM_DEV_XRAM_8               , "dev_xram_8" },
    { PM_DEV_XRAM_9               , "dev_xram_9" },
    { PM_DEV_XRAM_10              , "dev_xram_10" },
    { PM_DEV_XRAM_11              , "dev_xram_11" },
    { PM_DEV_XRAM_12              , "dev_xram_12" },
    { PM_DEV_XRAM_13              , "dev_xram_13" },
    { PM_DEV_XRAM_14              , "dev_xram_14" },
    { PM_DEV_XRAM_15              , "dev_xram_15" },
    { PM_DEV_GTM_0                , "dev_gtm_0" },
    { PM_DEV_GTM_1                , "dev_gtm_1" },
    { PM_DEV_GTM_2                , "dev_gtm_2" },
    { PM_DEV_GTM_3                , "dev_gtm_3" },
    { PM_DEV_GTM_4                , "dev_gtm_4" },
    { PM_DEV_GTYP_0               , "dev_gtyp_0" },
    { PM_DEV_GTYP_1               , "dev_gtyp_1" },
    { PM_DEV_GTYP_2               , "dev_gtyp_2" },
    { PM_DEV_GTYP_CPM5_0          , "dev_gtyp_cpm5_0" },
    { PM_DEV_GTYP_CPM5_1          , "dev_gtyp_cpm5_1" },
    { PM_DEV_GTYP_CPM5_2          , "dev_gtyp_cpm5_2" },
    { PM_DEV_GTYP_CPM5_3          , "dev_gtyp_cpm5_3" },
    { PM_DEV_AIE                  , "dev_aie" },
    { PM_DEV_IPI_PMC              , "dev_ipi_pmc" },
    { PM_DEV_GTM_5                , "dev_gtm_5" },
    { PM_DEV_GTM_6                , "dev_gtm_6" },
    { PM_DEV_GTM_7                , "dev_gtm_7" },
    { PM_DEV_GTM_8                , "dev_gtm_8" },
    { PM_DEV_GTM_9                , "dev_gtm_9" },
    { PM_DEV_HBMMC_0              , "dev_hbmmc_0" },
    { PM_DEV_HBMMC_1              , "dev_hbmmc_1" },
    { PM_DEV_HBMMC_2              , "dev_hbmmc_2" },
    { PM_DEV_HBMMC_3              , "dev_hbmmc_3" },
    { PM_DEV_HBMMC_4              , "dev_hbmmc_4" },
    { PM_DEV_HBMMC_5              , "dev_hbmmc_5" },
    { PM_DEV_HBMMC_6              , "dev_hbmmc_6" },
    { PM_DEV_HBMMC_7              , "dev_hbmmc_7" },
    { PM_DEV_HBMMC_8              , "dev_hbmmc_8" },
    { PM_DEV_HBMMC_9              , "dev_hbmmc_9" },
    { PM_DEV_HBMMC_10             , "dev_hbmmc_10" },
    { PM_DEV_HBMMC_11             , "dev_hbmmc_11" },
    { PM_DEV_HBMMC_12             , "dev_hbmmc_12" },
    { PM_DEV_HBMMC_13             , "dev_hbmmc_13" },
    { PM_DEV_HBMMC_14             , "dev_hbmmc_14" },
    { PM_DEV_HBMMC_15             , "dev_hbmmc_15" },
    { PM_DEV_GTYP_3               , "dev_gtyp_3" },
    { PM_DEV_GTYP_4               , "dev_gtyp_4" },
    { PM_DEV_GTYP_5               , "dev_gtyp_5" },
    { PM_DEV_GTYP_6               , "dev_gtyp_6" },
    { PM_DEV_GTYP_7               , "dev_gtyp_7" },
    { PM_DEV_GTYP_8               , "dev_gtyp_8" },
    { PM_DEV_GTYP_9               , "dev_gtyp_9" },
    { PM_DEV_HBM_0                , "dev_hbm_0" },
    { PM_DEV_VDU_0                , "dev_vdu_0" },
    { PM_DEV_VDU_1                , "dev_vdu_1" },
    { PM_DEV_VDU_2                , "dev_vdu_2" },
    { PM_DEV_VDU_3                , "dev_vdu_3" },
    { PM_DEV_GTM_10               , "dev_gtm_10" },
    { PM_DEV_GTM_11               , "dev_gtm_11" },
    { PM_DEV_GTM_12               , "dev_gtm_12" },
    { PM_DEV_GTM_13               , "dev_gtm_13" },
    { PM_DEV_GTM_14               , "dev_gtm_14" },
    { PM_DEV_GTM_15               , "dev_gtm_15" },
    { PM_DEV_GTM_16               , "dev_gtm_16" },
    { PM_DEV_GTM_17               , "dev_gtm_17" },
    { PM_DEV_GTM_18               , "dev_gtm_18" },
    { PM_DEV_GTM_19               , "dev_gtm_19" },
    { PM_DEV_GTM_20               , "dev_gtm_20" },
    { PM_DEV_GTM_21               , "dev_gtm_21" },
    { PM_DEV_GTM_22               , "dev_gtm_22" },
    { PM_DEV_GTM_23               , "dev_gtm_23" },
    { PM_DEV_BFRB_0               , "dev_bfrb_0" },
    { PM_DEV_BFRB_1               , "dev_bfrb_1" },
    { PM_DEV_BFRB_2               , "dev_bfrb_2" },
    { PM_DEV_BFRB_3               , "dev_bfrb_3" },
    { PM_DEV_BFRB_4               , "dev_bfrb_4" },
    { PM_DEV_BFRB_5               , "dev_bfrb_5" },
    { PM_DEV_BFRB_6               , "dev_bfrb_6" },
    { PM_DEV_BFRB_7               , "dev_bfrb_7" },
    { PM_DEV_BFRB_8               , "dev_bfrb_8" },
    { PM_DEV_BFRB_9               , "dev_bfrb_9" },
    { PM_DEV_BFRB_10              , "dev_bfrb_10" },
    { PM_DEV_BFRB_11              , "dev_bfrb_11" },
    { PM_DEV_ADC_0                , "dev_adc_0" },
    { PM_DEV_ADC_1                , "dev_adc_1" },
    { PM_DEV_ADC_2                , "dev_adc_2" },
    { PM_DEV_ADC_3                , "dev_adc_3" },
    { PM_DEV_DAC_0                , "dev_dac_0" },
    { PM_DEV_DAC_1                , "dev_dac_1" },
    { PM_DEV_DAC_2                , "dev_dac_2" },
    { PM_DEV_DAC_3                , "dev_dac_3" },
    { PM_DEV_ACPU_0_0             , "dev_acpu_0_0" },
    { PM_DEV_ACPU_0_1             , "dev_acpu_0_1" },
    { PM_DEV_ACPU_0_2             , "dev_acpu_0_2" },
    { PM_DEV_ACPU_0_3             , "dev_acpu_0_3" },
    { PM_DEV_ACPU_1_0             , "dev_acpu_1_0" },
    { PM_DEV_ACPU_1_1             , "dev_acpu_1_1" },
    { PM_DEV_ACPU_1_2             , "dev_acpu_1_2" },
    { PM_DEV_ACPU_1_3             , "dev_acpu_1_3" },
    { PM_DEV_ACPU_2_0             , "dev_acpu_2_0" },
    { PM_DEV_ACPU_2_1             , "dev_acpu_2_1" },
    { PM_DEV_ACPU_2_2             , "dev_acpu_2_2" },
    { PM_DEV_ACPU_2_3             , "dev_acpu_2_3" },
    { PM_DEV_ACPU_3_0             , "dev_acpu_3_0" },
    { PM_DEV_ACPU_3_1             , "dev_acpu_3_1" },
    { PM_DEV_ACPU_3_2             , "dev_acpu_3_2" },
    { PM_DEV_ACPU_3_3             , "dev_acpu_3_3" },
    { PM_DEV_RPU_A_0              , "dev_rpu_a_0" },
    { PM_DEV_RPU_A_1              , "dev_rpu_a_1" },
    { PM_DEV_RPU_B_0              , "dev_rpu_b_0" },
    { PM_DEV_RPU_B_1              , "dev_rpu_b_1" },
    { PM_DEV_OCM_0_0              , "dev_ocm_0_0" },
    { PM_DEV_OCM_0_1              , "dev_ocm_0_1" },
    { PM_DEV_OCM_0_2              , "dev_ocm_0_2" },
    { PM_DEV_OCM_0_3              , "dev_ocm_0_3" },
    { PM_DEV_OCM_1_0              , "dev_ocm_1_0" },
    { PM_DEV_OCM_1_1              , "dev_ocm_1_1" },
    { PM_DEV_OCM_1_2              , "dev_ocm_1_2" },
    { PM_DEV_OCM_1_3              , "dev_ocm_1_3" },
    { PM_DEV_TCM_A_0A             , "dev_tcm_a_0a" },
    { PM_DEV_TCM_A_0B             , "dev_tcm_a_0b" },
    { PM_DEV_TCM_A_0C             , "dev_tcm_a_0c" },
    { PM_DEV_TCM_A_1A             , "dev_tcm_a_1a" },
    { PM_DEV_TCM_A_1B             , "dev_tcm_a_1b" },
    { PM_DEV_TCM_A_1C             , "dev_tcm_a_1c" },
    { PM_DEV_TCM_B_0A             , "dev_tcm_b_0a" },
    { PM_DEV_TCM_B_0B             , "dev_tcm_b_0b" },
    { PM_DEV_TCM_B_0C             , "dev_tcm_b_0c" },
    { PM_DEV_TCM_B_1A             , "dev_tcm_b_1a" },
    { PM_DEV_TCM_B_1B             , "dev_tcm_b_1b" },
    { PM_DEV_TCM_B_1C             , "dev_tcm_b_1c" },
    { PM_DEV_USB_1                , "dev_usb_1" },
    { PM_DEV_PMC_WWDT             , "dev_pmc_wwdt" },
    { PM_DEV_LPD_SWDT_0           , "dev_lpd_swdt_0" },
    { PM_DEV_LPD_SWDT_1           , "dev_lpd_swdt_1" },
    { PM_DEV_FPD_SWDT_0           , "dev_fpd_swdt_0" },
    { PM_DEV_FPD_SWDT_1           , "dev_fpd_swdt_1" },
    { PM_DEV_FPD_SWDT_2           , "dev_fpd_swdt_2" },
    { PM_DEV_FPD_SWDT_3           , "dev_fpd_swdt_3" },
    { PM_DEV_DDRMC_4              , "dev_ddrmc_4" },
    { PM_DEV_DDRMC_5              , "dev_ddrmc_5" },
    { PM_DEV_DDRMC_6              , "dev_ddrmc_6" },
    { PM_DEV_DDRMC_7              , "dev_ddrmc_7" },
    { PM_DEV_IPI_NOBUF_1          , "dev_ipi_nobuf_1" },
    { PM_DEV_IPI_NOBUF_2          , "dev_ipi_nobuf_2" },
    { PM_DEV_IPI_NOBUF_3          , "dev_ipi_nobuf_3" },
    { PM_DEV_IPI_NOBUF_4          , "dev_ipi_nobuf_4" },
    { PM_DEV_IPI_NOBUF_5          , "dev_ipi_nobuf_5" },
    { PM_DEV_IPI_NOBUF_6          , "dev_ipi_nobuf_6" },
    { PM_DEV_RPU_C_0              , "dev_rpu_c_0" },
    { PM_DEV_RPU_C_1              , "dev_rpu_c_1" },
    { PM_DEV_RPU_D_0              , "dev_rpu_d_0" },
    { PM_DEV_RPU_D_1              , "dev_rpu_d_1" },
    { PM_DEV_RPU_E_0              , "dev_rpu_e_0" },
    { PM_DEV_RPU_E_1              , "dev_rpu_e_1" },
    { PM_DEV_ASU                  , "dev_asu" },
    { PM_DEV_OCM_2_0              , "dev_ocm_2_0" },
    { PM_DEV_OCM_2_1              , "dev_ocm_2_1" },
    { PM_DEV_OCM_2_2              , "dev_ocm_2_2" },
    { PM_DEV_OCM_2_3              , "dev_ocm_2_3" },
    { PM_DEV_OCM_3_0              , "dev_ocm_3_0" },
    { PM_DEV_OCM_3_1              , "dev_ocm_3_1" },
    { PM_DEV_OCM_3_2              , "dev_ocm_3_2" },
    { PM_DEV_OCM_3_3              , "dev_ocm_3_3" },
    { PM_DEV_TCM_C_0A             , "dev_tcm_c_0a" },
    { PM_DEV_TCM_C_0B             , "dev_tcm_c_0b" },
    { PM_DEV_TCM_C_0C             , "dev_tcm_c_0c" },
    { PM_DEV_TCM_C_1A             , "dev_tcm_c_1a" },
    { PM_DEV_TCM_C_1B             , "dev_tcm_c_1b" },
    { PM_DEV_TCM_C_1C             , "dev_tcm_c_1c" },
    { PM_DEV_TCM_D_0A             , "dev_tcm_d_0a" },
    { PM_DEV_TCM_D_0B             , "dev_tcm_d_0b" },
    { PM_DEV_TCM_D_0C             , "dev_tcm_d_0c" },
    { PM_DEV_TCM_D_1A             , "dev_tcm_d_1a" },
    { PM_DEV_TCM_D_1B             , "dev_tcm_d_1b" },
    { PM_DEV_TCM_D_1C             , "dev_tcm_d_1c" },
    { PM_DEV_TCM_E_0A             , "dev_tcm_e_0a" },
    { PM_DEV_TCM_E_0B             , "dev_tcm_e_0b" },
    { PM_DEV_TCM_E_0C             , "dev_tcm_e_0c" },
    { PM_DEV_TCM_E_1A             , "dev_tcm_e_1a" },
    { PM_DEV_TCM_E_1B             , "dev_tcm_e_1b" },
    { PM_DEV_TCM_E_1C             , "dev_tcm_e_1c" },
    { PM_DEV_LPD_SWDT_2           , "dev_lpd_swdt_2" },
    { PM_DEV_LPD_SWDT_3           , "dev_lpd_swdt_3" },
    { PM_DEV_LPD_SWDT_4           , "dev_lpd_swdt_4" },
    { PM_DEV_IPI_ASU              , "dev_ipi_asu" },
    { PM_DEV_GGS_0                , "dev_ggs_0" },
    { PM_DEV_GGS_1                , "dev_ggs_1" },
    { PM_DEV_GGS_2                , "dev_ggs_2" },
    { PM_DEV_GGS_3                , "dev_ggs_3" },
    { PM_DEV_PGGS_0               , "dev_pggs_0" },
    { PM_DEV_PGGS_1               , "dev_pggs_1" },
    { PM_DEV_PGGS_RESERVED_0      , "dev_pggs_reserved_0" },
    { PM_DEV_PGGS_RESERVED_1      , "dev_pggs_reserved_1" },
    { PM_DEV_HB_MON_0             , "dev_hb_mon_0" },
    { PM_DEV_HB_MON_1             , "dev_hb_mon_1" },
    { PM_DEV_HB_MON_2             , "dev_hb_mon_2" },
    { PM_DEV_HB_MON_3             , "dev_hb_mon_3" },
    { PM_DEV_HB_MON_4             , "dev_hb_mon_4" },
    { PM_DEV_HB_MON_5             , "dev_hb_mon_5" },
    { PM_DEV_HB_MON_6             , "dev_hb_mon_6" },
    { PM_DEV_HB_MON_7             , "dev_hb_mon_7" },
    { PM_SUBSYS_DEFAULT           , "subsys_default" },
    { PM_SUBSYS_PMC               , "subsys_pmc" },
    { PM_ISO_FPD_PL_TEST          , "iso_fpd_pl_test" },
    { PM_ISO_FPD_PL               , "iso_fpd_pl" },
    { PM_ISO_FPD_SOC              , "iso_fpd_soc" },
    { PM_ISO_LPD_CPM_DFX          , "iso_lpd_cpm_dfx" },
    { PM_ISO_LPD_CPM              , "iso_lpd_cpm" },
    { PM_ISO_LPD_PL_TEST          , "iso_lpd_pl_test" },
    { PM_ISO_LPD_PL               , "iso_lpd_pl" },
    { PM_ISO_LPD_SOC              , "iso_lpd_soc" },
    { PM_ISO_PMC_LPD_DFX          , "iso_pmc_lpd_dfx" },
    { PM_ISO_PMC_LPD              , "iso_pmc_lpd" },
    { PM_ISO_PMC_PL_CFRAME        , "iso_pmc_pl_cframe" },
    { PM_ISO_PMC_PL_TEST          , "iso_pmc_pl_test" },
    { PM_ISO_PMC_PL               , "iso_pmc_pl" },
    { PM_ISO_PMC_SOC_NPI          , "iso_pmc_soc_npi" },
    { PM_ISO_PMC_SOC              , "iso_pmc_soc" },
    { PM_ISO_PL_SOC               , "iso_pl_soc" },
    { PM_ISO_VCCAUX_SOC           , "iso_vccaux_soc" },
    { PM_ISO_VCCRAM_SOC           , "iso_vccram_soc" },
    { PM_ISO_VCCAUX_VCCRAM        , "iso_vccaux_vccram" },
    { PM_ISO_PL_CPM_PCIEA0_ATTR   , "iso_pl_cpm_pciea0_attr" },
    { PM_ISO_PL_CPM_PCIEA1_ATTR   , "iso_pl_cpm_pciea1_attr" },
    { PM_ISO_PL_CPM_RST_CPI0      , "iso_pl_cpm_rst_cpi0" },
    { PM_ISO_PL_CPM_RST_CPI1      , "iso_pl_cpm_rst_cpi1" },
    { PM_ISO_GEM_TSU_CLK          , "iso_gem_tsu_clk" },
    { PM_ISO_GEM0_TXRX_CLK        , "iso_gem0_txrx_clk" },
    { PM_ISO_GEM1_TXRX_CLK        , "iso_gem1_txrx_clk" },
    { PM_ISO_CPM5_PL              , "iso_cpm5_pl" },
    { PM_ISO_CPM5_PL_AXIMM        , "iso_cpm5_pl_aximm" },
    { PM_ISO_CPM5_PL_CHI0         , "iso_cpm5_pl_chi0" },
    { PM_ISO_CPM5_PL_CHI1         , "iso_cpm5_pl_chi1" },
    { PM_ISO_CPM5_PL_TST          , "iso_cpm5_pl_tst" },
    { PM_ISO_CPM5_PL_PCIEA0_MPIO  , "iso_cpm5_pl_pciea0_mpio" },
    { PM_ISO_CPM5_PL_PCIEA1_MPIO  , "iso_cpm5_pl_pciea1_mpio" },
    { PM_ISO_CPM5_RAM             , "iso_cpm5_ram" },
    { PM_ISO_LPD_CPM5             , "iso_lpd_cpm5" },
    { PM_ISO_LPD_CPM5_DFX         , "iso_lpd_cpm5_dfx" },
    { PM_ISO_XRAM_PL_AXI0         , "iso_xram_pl_axi0" },
    { PM_ISO_XRAM_PL_AXI1         , "iso_xram_pl_axi1" },
    { PM_ISO_XRAM_PL_AXI2         , "iso_xram_pl_axi2" },
    { PM_ISO_XRAM_PL_AXILITE      , "iso_xram_pl_axilite" },
    { PM_ISO_XRAM_PL_FABRIC       , "iso_xram_pl_fabric" },
    { PM_ISO_CPM5_PL_DFX          , "iso_cpm5_pl_dfx" },
    { PM_ISO_CPM5_GT              , "iso_cpm5_gt" },
    { PM_ISO_CPM5_GT_DFX          , "iso_cpm5_gt_dfx" },
    { PM_ISO_XRAM_PL_MAIN_CLK     , "iso_xram_pl_main_clk" },
    { PM_ISO_PL_MISC_N            , "iso_pl_misc_n" },
    { PM_ISO_PL_TEST_N            , "iso_pl_test_n" },
    { PM_ISO_TNOC_AXI_N           , "iso_tnoc_axi_n" },
    { PM_ISO_PL_AXIST0_N          , "iso_pl_axist0_n" },
    { PM_ISO_PL_AXIST1_N          , "iso_pl_axist1_n" },
    { PM_ISO_FPD_CPM5             , "iso_fpd_cpm5" },
    { PM_ISO_LPD_FPD_DFX          , "iso_lpd_fpd_dfx" },
    { PM_ISO_LPD_FPD              , "iso_lpd_fpd" },
    { PM_ISO_CPM5_LPD_DFX         , "iso_cpm5_lpd_dfx" },
    { PM_ISO_FPD_CPM5_DFX         , "iso_fpd_cpm5_dfx" },
    { PM_ISO_CPM5_LPD             , "iso_cpm5_lpd" },
    { PM_ISO_PL_AXI_FPD0          , "iso_pl_axi_fpd0" },
    { PM_ISO_PL_AXI_FPD1          , "iso_pl_axi_fpd1" },
    { PM_ISO_PL_AXI_FPD2          , "iso_pl_axi_fpd2" },
    { PM_ISO_PL_AXI_FPD3          , "iso_pl_axi_fpd3" },
    { PM_ISO_FPD_AXI_PL           , "iso_fpd_axi_pl" },
    { PM_ISO_PL_AXI_LPD           , "iso_pl_axi_lpd" },
    { PM_ISO_LPD_AXI_PL           , "iso_lpd_axi_pl" },
    { PM_ISO_PL_CHI_FPD           , "iso_pl_chi_fpd" },
    { PM_ISO_PL_ACP_APU0          , "iso_pl_acp_apu0" },
    { PM_ISO_PL_ACP_APU1          , "iso_pl_acp_apu1" },
    { PM_ISO_PL_ACP_APU2          , "iso_pl_acp_apu2" },
    { PM_ISO_PL_ACP_APU3          , "iso_pl_acp_apu3" },
    { PM_ISO_PL_PS_DTI0           , "iso_pl_ps_dti0" },
    { PM_ISO_PL_PS_DTI1           , "iso_pl_ps_dti1" },
    { PM_ISO_CPM5_NOC_DFX         , "iso_cpm5_noc_dfx" },
    { PM_ISO_CPM5_NOC             , "iso_cpm5_noc" },
    { PM_ISO_PL_GEM_N             , "iso_pl_gem_n" },
    { PM_ISO_PL_DC_N              , "iso_pl_dc_n" },
    { PM_ISO_MMI_N                , "iso_mmi_n" },
    { PM_ISO_FPD_MMI_DFX          , "iso_fpd_mmi_dfx" },
    { PM_ISO_FPD_MMI              , "iso_fpd_mmi" },
    { PM_MISC_MJTAG_WA_IMG        , "misc_mjtag_wa_img" },
    { PM_MISC_READBACK_PDI_IMG    , "misc_readback_pdi_img" },
    { PM_MEMIC_NMU_0              , "memic_nmu_0" },
    { PM_MEMIC_NMU_1              , "memic_nmu_1" },
    { PM_MEMIC_NMU_2              , "memic_nmu_2" },
    { PM_MEMIC_NMU_3              , "memic_nmu_3" },
    { PM_MEMIC_NMU_4              , "memic_nmu_4" },
    { PM_MEMIC_NMU_5              , "memic_nmu_5" },
    { PM_MEMIC_NMU_6              , "memic_nmu_6" },
    { PM_MEMIC_NMU_7              , "memic_nmu_7" },
    { PM_MEMIC_NMU_8              , "memic_nmu_8" },
    { PM_MEMIC_NMU_9              , "memic_nmu_9" },
    { PM_MEMIC_NMU_10             , "memic_nmu_10" },
    { PM_MEMIC_NMU_11             , "memic_nmu_11" },
    { PM_MEMIC_NMU_12             , "memic_nmu_12" },
    { PM_MEMIC_NMU_13             , "memic_nmu_13" },
    { PM_MEMIC_NMU_14             , "memic_nmu_14" },
    { PM_MEMIC_NMU_15             , "memic_nmu_15" },
    { PM_MEMIC_NMU_16             , "memic_nmu_16" },
    { PM_MEMIC_NMU_17             , "memic_nmu_17" },
    { PM_MEMIC_NMU_18             , "memic_nmu_18" },
    { PM_MEMIC_NMU_19             , "memic_nmu_19" },
    { PM_MEMIC_NMU_20             , "memic_nmu_20" },
    { PM_MEMIC_NMU_21             , "memic_nmu_21" },
    { PM_MEMIC_NMU_22             , "memic_nmu_22" },
    { PM_MEMIC_NMU_23             , "memic_nmu_23" },
    { PM_MEMIC_NMU_24             , "memic_nmu_24" },
    { PM_MEMIC_NMU_25             , "memic_nmu_25" },
    { PM_MEMIC_NMU_26             , "memic_nmu_26" },
    { PM_MEMIC_NMU_27             , "memic_nmu_27" },
    { PM_MEMIC_NMU_28             , "memic_nmu_28" },
    { PM_MEMIC_NMU_29             , "memic_nmu_29" },
    { PM_MEMIC_NMU_30             , "memic_nmu_30" },
    { PM_MEMIC_NMU_31             , "memic_nmu_31" },
    { PM_MEMIC_NMU_32             , "memic_nmu_32" },
    { PM_MEMIC_NMU_33             , "memic_nmu_33" },
    { PM_MEMIC_NMU_34             , "memic_nmu_34" },
    { PM_MEMIC_NMU_35             , "memic_nmu_35" },
    { PM_MEMIC_NMU_36             , "memic_nmu_36" },
    { PM_MEMIC_NMU_37             , "memic_nmu_37" },
    { PM_MEMIC_NMU_38             , "memic_nmu_38" },
    { PM_MEMIC_NMU_39             , "memic_nmu_39" },
    { PM_MEMIC_NMU_40             , "memic_nmu_40" },
    { PM_MEMIC_NMU_41             , "memic_nmu_41" },
    { PM_MEMIC_NMU_42             , "memic_nmu_42" },
    { PM_MEMIC_NMU_43             , "memic_nmu_43" },
    { PM_MEMIC_NMU_44             , "memic_nmu_44" },
    { PM_MEMIC_NMU_45             , "memic_nmu_45" },
    { PM_MEMIC_NMU_46             , "memic_nmu_46" },
    { PM_MEMIC_NMU_47             , "memic_nmu_47" },
    { PM_MEMIC_NMU_48             , "memic_nmu_48" },
    { PM_MEMIC_NMU_49             , "memic_nmu_49" },
    { PM_MEMIC_NMU_50             , "memic_nmu_50" },
    { PM_MEMIC_NMU_51             , "memic_nmu_51" },
    { PM_MEMIC_NMU_52             , "memic_nmu_52" },
    { PM_MEMIC_NMU_53             , "memic_nmu_53" },
    { PM_MEMIC_NSU_0              , "memic_nsu_0" },
    { PM_MEMIC_NSU_1              , "memic_nsu_1" },
    { PM_MEMIC_NSU_2              , "memic_nsu_2" },
    { PM_MEMIC_NSU_3              , "memic_nsu_3" },
    { PM_MEMIC_NSU_4              , "memic_nsu_4" },
    { PM_MEMIC_NSU_5              , "memic_nsu_5" },
    { PM_MEMIC_NSU_6              , "memic_nsu_6" },
    { PM_MEMIC_NSU_7              , "memic_nsu_7" },
    { PM_MEMIC_NSU_8              , "memic_nsu_8" },
    { PM_MEMIC_NSU_9              , "memic_nsu_9" },
    { PM_MEMIC_NSU_10             , "memic_nsu_10" },
    { PM_MEMIC_NSU_11             , "memic_nsu_11" },
    { PM_MEMIC_NSU_12             , "memic_nsu_12" },
    { PM_MEMIC_NSU_13             , "memic_nsu_13" },
    { PM_MEMIC_NSU_14             , "memic_nsu_14" },
    { PM_MEMIC_NSU_15             , "memic_nsu_15" },
    { PM_MEMIC_NSU_16             , "memic_nsu_16" },
    { PM_MEMIC_NSU_17             , "memic_nsu_17" },
    { PM_MEMIC_NSU_18             , "memic_nsu_18" },
    { PM_MEMIC_NSU_19             , "memic_nsu_19" },
    { PM_MEMIC_NSU_20             , "memic_nsu_20" },
    { PM_MEMIC_NSU_21             , "memic_nsu_21" },
    { PM_MEMIC_NSU_22             , "memic_nsu_22" },
    { PM_MEMIC_NSU_23             , "memic_nsu_23" },
    { PM_MEMIC_NSU_24             , "memic_nsu_24" },
    { PM_MEMIC_NSU_25             , "memic_nsu_25" },
    { PM_MEMIC_NSU_26             , "memic_nsu_26" },
    { PM_MEMIC_NSU_27             , "memic_nsu_27" },
    { PM_MEMIC_NSU_28             , "memic_nsu_28" },
    { PM_MEMIC_NSU_29             , "memic_nsu_29" },
    { PM_MEMIC_NSU_30             , "memic_nsu_30" },
    { PM_MEMIC_NSU_31             , "memic_nsu_31" },
    { PM_MEMIC_NSU_32             , "memic_nsu_32" },
    { PM_MEMIC_NSU_33             , "memic_nsu_33" },
    { PM_MEMIC_NSU_34             , "memic_nsu_34" },
    { PM_MEMIC_NSU_35             , "memic_nsu_35" },
    { PM_MEMIC_NSU_36             , "memic_nsu_36" },
    { PM_MEMIC_NSU_37             , "memic_nsu_37" },
    { PM_MEMIC_NSU_38             , "memic_nsu_38" },
    { PM_MEMIC_NSU_39             , "memic_nsu_39" },
    { PM_MEMIC_NSU_40             , "memic_nsu_40" },
    { PM_MEMIC_NSU_41             , "memic_nsu_41" },
    { PM_MEMIC_NSU_42             , "memic_nsu_42" },
    { PM_MEMIC_NSU_43             , "memic_nsu_43" },
    { PM_MEMIC_NSU_44             , "memic_nsu_44" },
    { PM_MEMIC_NSU_45             , "memic_nsu_45" },
    { PM_MEMIC_NSU_46             , "memic_nsu_46" },
    { PM_MEMIC_NSU_47             , "memic_nsu_47" },
    { PM_MEMIC_NSU_48             , "memic_nsu_48" },
    { PM_MEMIC_NSU_49             , "memic_nsu_49" },
    { PM_MEMIC_NMU_54             , "memic_nmu_54" },
    { PM_MEMIC_NMU_55             , "memic_nmu_55" },
    { PM_MEMIC_NMU_56             , "memic_nmu_56" },
    { PM_MEMIC_NMU_57             , "memic_nmu_57" },
    { PM_MEMIC_NMU_58             , "memic_nmu_58" },
    { PM_MEMIC_NMU_59             , "memic_nmu_59" },
    { PM_MEMIC_NMU_60             , "memic_nmu_60" },
    { PM_MEMIC_NMU_61             , "memic_nmu_61" },
    { PM_MEMIC_NMU_62             , "memic_nmu_62" },
    { PM_MEMIC_NMU_63             , "memic_nmu_63" },
    { PM_MEMIC_NMU_64             , "memic_nmu_64" },
    { PM_MEMIC_NMU_65             , "memic_nmu_65" },
    { PM_MEMIC_NMU_66             , "memic_nmu_66" },
    { PM_MEMIC_NMU_67             , "memic_nmu_67" },
    { PM_MEMIC_NMU_68             , "memic_nmu_68" },
    { PM_MEMIC_NMU_69             , "memic_nmu_69" },
    { PM_MEMIC_NMU_70             , "memic_nmu_70" },
    { PM_MEMIC_NMU_71             , "memic_nmu_71" },
    { PM_MEMIC_NMU_72             , "memic_nmu_72" },
    { PM_MEMIC_NMU_73             , "memic_nmu_73" },
    { PM_MEMIC_NMU_74             , "memic_nmu_74" },
    { PM_MEMIC_NMU_75             , "memic_nmu_75" },
    { PM_MEMIC_NMU_76             , "memic_nmu_76" },
    { PM_MEMIC_NMU_77             , "memic_nmu_77" },
    { PM_MEMIC_NMU_78             , "memic_nmu_78" },
    { PM_MEMIC_NMU_79             , "memic_nmu_79" },
    { PM_MEMIC_NMU_80             , "memic_nmu_80" },
    { PM_MEMIC_NMU_81             , "memic_nmu_81" },
    { PM_MEMIC_NMU_82             , "memic_nmu_82" },
    { PM_MEMIC_NMU_83             , "memic_nmu_83" },
    { PM_MEMIC_NMU_84             , "memic_nmu_84" },
    { PM_MEMIC_NMU_85             , "memic_nmu_85" },
    { PM_MEMIC_NMU_86             , "memic_nmu_86" },
    { PM_MEMIC_NMU_87             , "memic_nmu_87" },
    { PM_MEMIC_NMU_88             , "memic_nmu_88" },
    { PM_MEMIC_NMU_89             , "memic_nmu_89" },
    { PM_MEMIC_NMU_90             , "memic_nmu_90" },
    { PM_MEMIC_NMU_91             , "memic_nmu_91" },
    { PM_MEMIC_NMU_92             , "memic_nmu_92" },
    { PM_MEMIC_NMU_93             , "memic_nmu_93" },
    { PM_MEMIC_NMU_94             , "memic_nmu_94" },
    { PM_MEMIC_NMU_95             , "memic_nmu_95" },
    { PM_MEMIC_NMU_96             , "memic_nmu_96" },
    { PM_MEMIC_NMU_97             , "memic_nmu_97" },
    { PM_MEMIC_NSU_50             , "memic_nsu_50" },
    { PM_MEMIC_NSU_51             , "memic_nsu_51" },
    { PM_MEMIC_NSU_52             , "memic_nsu_52" },
    { PM_MEMIC_NSU_53             , "memic_nsu_53" },
    { PM_MEMIC_NSU_54             , "memic_nsu_54" },
    { PM_MEMIC_NSU_55             , "memic_nsu_55" },
    { PM_MEMIC_NSU_56             , "memic_nsu_56" },
    { PM_MEMIC_NSU_57             , "memic_nsu_57" },
    { PM_PROT_XPPU_LPD            , "prot_xppu_lpd" },
    { PM_PROT_XPPU_PMC            , "prot_xppu_pmc" },
    { PM_PROT_XPPU_PMC_NPI        , "prot_xppu_pmc_npi" },
    { PM_PROT_XMPU_FPD_SLAVES     , "prot_xmpu_fpd_slaves" },
    { PM_PROT_XMPU_OCM            , "prot_xmpu_ocm" },
    { PM_PROT_XMPU_PMC            , "prot_xmpu_pmc" },
    { PM_PROT_XMPU_XRAM_0         , "prot_xmpu_xram_0" },
    { PM_PROT_XMPU_XRAM_1         , "prot_xmpu_xram_1" },
    { PM_PROT_XMPU_XRAM_2         , "prot_xmpu_xram_2" },
    { PM_PROT_XMPU_XRAM_3         , "prot_xmpu_xram_3" },
    { PM_MONITOR_SYSMON_PMC_0     , "monitor_sysmon_pmc_0" },
    { PM_MONITOR_SYSMON_PMC_1     , "monitor_sysmon_pmc_1" },
    { PM_MONITOR_SYSMON_PS_LPD    , "monitor_sysmon_ps_lpd" },
    { PM_MONITOR_SYSMON_PS_FPD    , "monitor_sysmon_ps_fpd" },
    { PM_MONITOR_SYSMON_NPD_0     , "monitor_sysmon_npd_0" },
    { PM_MONITOR_SYSMON_NPD_1     , "monitor_sysmon_npd_1" },
    { PM_MONITOR_SYSMON_NPD_2     , "monitor_sysmon_npd_2" },
    { PM_MONITOR_SYSMON_NPD_3     , "monitor_sysmon_npd_3" },
    { PM_MONITOR_SYSMON_NPD_4     , "monitor_sysmon_npd_4" },
    { PM_MONITOR_SYSMON_NPD_5     , "monitor_sysmon_npd_5" },
    { PM_MONITOR_SYSMON_NPD_6     , "monitor_sysmon_npd_6" },
    { PM_MONITOR_SYSMON_NPD_7     , "monitor_sysmon_npd_7" },
    { PM_MONITOR_SYSMON_NPD_8     , "monitor_sysmon_npd_8" },
    { PM_MONITOR_SYSMON_NPD_9     , "monitor_sysmon_npd_9" },
    { PM_MONITOR_SYSMON_NPD_10    , "monitor_sysmon_npd_10" },
    { PM_MONITOR_SYSMON_NPD_11    , "monitor_sysmon_npd_11" },
    { PM_MONITOR_SYSMON_NPD_12    , "monitor_sysmon_npd_12" },
    { PM_MONITOR_SYSMON_NPD_13    , "monitor_sysmon_npd_13" },
    { PM_MONITOR_SYSMON_NPD_14    , "monitor_sysmon_npd_14" },
    { PM_MONITOR_SYSMON_NPD_15    , "monitor_sysmon_npd_15" },
    { PM_MONITOR_SYSMON_NPD_16    , "monitor_sysmon_npd_16" },
    { PM_MONITOR_SYSMON_NPD_17    , "monitor_sysmon_npd_17" },
    { PM_MONITOR_SYSMON_NPD_18    , "monitor_sysmon_npd_18" },
    { PM_MONITOR_SYSMON_NPD_19    , "monitor_sysmon_npd_19" },
    { PM_MONITOR_SYSMON_NPD_20    , "monitor_sysmon_npd_20" },
    { PM_MONITOR_SYSMON_NPD_21    , "monitor_sysmon_npd_21" },
    { PM_MONITOR_SYSMON_NPD_22    , "monitor_sysmon_npd_22" },
    { PM_MONITOR_SYSMON_NPD_23    , "monitor_sysmon_npd_23" },
    { PM_MONITOR_SYSMON_NPD_24    , "monitor_sysmon_npd_24" },
    { PM_MONITOR_SYSMON_NPD_25    , "monitor_sysmon_npd_25" },
    { PM_MONITOR_SYSMON_NPD_26    , "monitor_sysmon_npd_26" },
    { PM_MONITOR_SYSMON_NPD_27    , "monitor_sysmon_npd_27" },
    { PM_MONITOR_SYSMON_NPD_28    , "monitor_sysmon_npd_28" },
    { PM_MONITOR_SYSMON_NPD_29    , "monitor_sysmon_npd_29" },
    { PM_MONITOR_SYSMON_NPD_30    , "monitor_sysmon_npd_30" },
    { PM_MONITOR_SYSMON_NPD_31    , "monitor_sysmon_npd_31" },
    { PM_MONITOR_SYSMON_NPD_32    , "monitor_sysmon_npd_32" },
    { PM_MONITOR_SYSMON_NPD_33    , "monitor_sysmon_npd_33" },
    { PM_MONITOR_SYSMON_NPD_34    , "monitor_sysmon_npd_34" },
    { PM_MONITOR_SYSMON_NPD_35    , "monitor_sysmon_npd_35" },
    { PM_MONITOR_SYSMON_NPD_36    , "monitor_sysmon_npd_36" },
    { PM_MONITOR_SYSMON_NPD_37    , "monitor_sysmon_npd_37" },
    { PM_MONITOR_SYSMON_NPD_38    , "monitor_sysmon_npd_38" },
    { PM_MONITOR_SYSMON_NPD_39    , "monitor_sysmon_npd_39" },
    { PM_MONITOR_SYSMON_NPD_40    , "monitor_sysmon_npd_40" },
    { PM_MONITOR_SYSMON_NPD_41    , "monitor_sysmon_npd_41" },
    { PM_MONITOR_SYSMON_NPD_42    , "monitor_sysmon_npd_42" },
    { PM_MONITOR_SYSMON_NPD_43    , "monitor_sysmon_npd_43" },
    { PM_MONITOR_SYSMON_NPD_44    , "monitor_sysmon_npd_44" },
    { PM_MONITOR_SYSMON_NPD_45    , "monitor_sysmon_npd_45" },
    { PM_MONITOR_SYSMON_NPD_46    , "monitor_sysmon_npd_46" },
    { PM_MONITOR_SYSMON_NPD_47    , "monitor_sysmon_npd_47" },
    { PM_MONITOR_SYSMON_NPD_48    , "monitor_sysmon_npd_48" },
    { PM_MONITOR_SYSMON_NPD_49    , "monitor_sysmon_npd_49" },
    { PM_MONITOR_SYSMON_NPD_50    , "monitor_sysmon_npd_50" },
    { PM_MONITOR_SYSMON_NPD_51    , "monitor_sysmon_npd_51" },
    { PM_MONITOR_SYSMON_NPD_52    , "monitor_sysmon_npd_52" },
    { PM_MONITOR_SYSMON_NPD_53    , "monitor_sysmon_npd_53" },
    { PM_MONITOR_SYSMON_NPD_54    , "monitor_sysmon_npd_54" },
    { PM_MONITOR_SYSMON_NPD_55    , "monitor_sysmon_npd_55" },
    { PM_MONITOR_SYSMON_NPD_56    , "monitor_sysmon_npd_56" },
    { PM_MONITOR_SYSMON_NPD_57    , "monitor_sysmon_npd_57" },
    { PM_MONITOR_SYSMON_LPD       , "monitor_sysmon_lpd" },
    { PM_MONITOR_SYSMON_CPM5N     , "monitor_sysmon_cpm5n" },
    { PM_MONITOR_SYSMON_FPD_0     , "monitor_sysmon_fpd_0" },
    { PM_MONITOR_SYSMON_FPD_1     , "monitor_sysmon_fpd_1" },
    { PM_MONITOR_SYSMON_FPD_2     , "monitor_sysmon_fpd_2" },
    { PM_MONITOR_SYSMON_FPD_3     , "monitor_sysmon_fpd_3" },
    { PM_MONITOR_SYSMON_MMI       , "monitor_sysmon_mmi" },
    { PM_MONITOR_SYSMON_SEIO_NPD  , "monitor_sysmon_seio_npd" },
    { PM_REG_CRP                  , "reg_crp" },
    // -- End of nodeid_map --
};

const char * get_node_id_str(unsigned int node_id)
{
    const char * out = NULL;
    std::unordered_map<unsigned int, const char *>::const_iterator id;

    id = nodeid_map.find(node_id);
    if (id != nodeid_map.end())
        out = id->second;

    return out;
}