# -*- coding: utf-8 -*-
import os
import platform
import subprocess
import sys

from ._version import version as __version__

__all__ = ["__version__", "DATA", "BIN_DIR", "ninja"]


def __dir__():
    return __all__


try:
    from .ninja_syntax import Writer, escape, expand
except ImportError:
    # Support importing `ninja_syntax` from the source tree
    if not os.path.exists(
            os.path.join(os.path.dirname(__file__), 'ninja_syntax.py')):
        sys.path.insert(0, os.path.abspath(os.path.join(
            os.path.dirname(__file__), '../../Ninja-src/misc')))
    from ninja_syntax import Writer, escape, expand  # noqa: F401


def _program(name, args):
    return subprocess.call([name] + args, close_fds=False)


def ninja():
    raise SystemExit(_program('ninja', sys.argv[1:]))
