// SPDX-License-Identifier: GPL-2.0-or-later
/*
 *
 *   Copyright (c) International Business Machines Corp., 2001
 */

/*
 * hugetlb.h - common definitions for the hugepage tests
 */

#ifndef __HUGETLB_H
#define __HUGETLB_H

#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include <sys/wait.h>
#include "tst_test.h"
#include "old_tmpdir.h"
#include "mem.h"

#define PALIGN(p, a) ((void *)LTP_ALIGN((unsigned long)(p), (a)))

#define SHM_RD	0400
#define SHM_WR	0200
#define SHM_RW	(SHM_RD|SHM_WR)

#ifndef SHM_HUGETLB
#define SHM_HUGETLB	04000	/* segment is mapped via hugetlb */
#endif

#ifndef barrier
# ifdef mb
	/* Redefining the mb() */
#   define barrier() mb()
# else
#   define barrier() __asm__ __volatile__ ("" : : : "memory")
# endif
#endif

/* Check if hugetlb page is gigantic */
static inline int is_hugetlb_gigantic(unsigned long hpage_size)
{
	return (hpage_size / getpagesize()) >> 11;
}

/*
 * to get the lower nine permission bits
 * from shmid_ds.ipc_perm.mode
 */
#define MODE_MASK	0x01FF

extern key_t shmkey;			/* an IPC key generated by ftok() */

int getipckey(void);
int getuserid(char *user);
void rm_shm(int shm_id);
int do_readback(void *p, size_t size, char *desc);
#endif /* hugetlb.h */
